; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64--linux-gnu -mattr=+sve < %s | FileCheck %s

;
; Masked Loads
;

define <vscale x 2 x i64> @masked_sload_nxv2i8(ptr %a, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: masked_sload_nxv2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sb { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ret
  %load = call <vscale x 2 x i8> @llvm.masked.load.nxv2i8(ptr %a, i32 1, <vscale x 2 x i1> %mask, <vscale x 2 x i8> undef)
  %ext = sext <vscale x 2 x i8> %load to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ext
}

define <vscale x 2 x i64> @masked_sload_nxv2i16(ptr %a, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: masked_sload_nxv2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sh { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ret
  %load = call <vscale x 2 x i16> @llvm.masked.load.nxv2i16(ptr %a, i32 1, <vscale x 2 x i1> %mask, <vscale x 2 x i16> undef)
  %ext = sext <vscale x 2 x i16> %load to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ext
}

define <vscale x 2 x i64> @masked_sload_nxv2i32(ptr %a, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: masked_sload_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sw { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ret
  %load = call <vscale x 2 x i32> @llvm.masked.load.nxv2i32(ptr %a, i32 1, <vscale x 2 x i1> %mask, <vscale x 2 x i32> undef)
  %ext = sext <vscale x 2 x i32> %load to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ext
}

define <vscale x 4 x i32> @masked_sload_nxv4i8(ptr %a, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: masked_sload_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sb { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ret
  %load = call <vscale x 4 x i8> @llvm.masked.load.nxv4i8(ptr %a, i32 1, <vscale x 4 x i1> %mask, <vscale x 4 x i8> undef)
  %ext = sext <vscale x 4 x i8> %load to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %ext
}

define <vscale x 4 x i32> @masked_sload_nxv4i16(ptr %a, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: masked_sload_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sh { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ret
  %load = call <vscale x 4 x i16> @llvm.masked.load.nxv4i16(ptr %a, i32 1, <vscale x 4 x i1> %mask, <vscale x 4 x i16> undef)
  %ext = sext <vscale x 4 x i16> %load to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %ext
}

define <vscale x 8 x i16> @masked_sload_nxv8i8(ptr %a, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: masked_sload_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sb { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ret
  %load = call <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr %a, i32 1, <vscale x 8 x i1> %mask, <vscale x 8 x i8> undef)
  %ext = sext <vscale x 8 x i8> %load to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %ext
}

define <vscale x 2 x i64> @masked_sload_passthru(ptr %a, <vscale x 2 x i1> %mask, <vscale x 2 x i32> %passthru) {
; CHECK-LABEL: masked_sload_passthru:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.d
; CHECK-NEXT:    ld1sw { z1.d }, p0/z, [x0]
; CHECK-NEXT:    sxtw z0.d, p1/m, z0.d
; CHECK-NEXT:    mov z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
  %load = call <vscale x 2 x i32> @llvm.masked.load.nxv2i32(ptr %a, i32 1, <vscale x 2 x i1> %mask, <vscale x 2 x i32> %passthru)
  %ext = sext <vscale x 2 x i32> %load to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %ext
}

; Return type requires splitting
define <vscale x 16 x i32> @masked_sload_nxv16i8(ptr %a, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: masked_sload_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    sunpklo z1.h, z0.b
; CHECK-NEXT:    sunpkhi z3.h, z0.b
; CHECK-NEXT:    sunpklo z0.s, z1.h
; CHECK-NEXT:    sunpkhi z1.s, z1.h
; CHECK-NEXT:    sunpklo z2.s, z3.h
; CHECK-NEXT:    sunpkhi z3.s, z3.h
; CHECK-NEXT:    ret
  %load = call <vscale x 16 x i8> @llvm.masked.load.nxv16i8(ptr %a, i32 2, <vscale x 16 x i1> %mask, <vscale x 16 x i8> undef)
  %ext = sext <vscale x 16 x i8> %load to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %ext
}

; Masked load requires promotion
define <vscale x 4 x double> @masked_sload_4i8_4f32(ptr noalias %in, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: masked_sload_4i8_4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sb { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ptrue p1.d
; CHECK-NEXT:    sunpkhi z1.d, z0.s
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z0.d, p1/m, z0.d
; CHECK-NEXT:    scvtf z1.d, p1/m, z1.d
; CHECK-NEXT:    ret
  %wide.load = call <vscale x 4 x i8> @llvm.masked.load.nxv4i8(ptr %in, i32 2, <vscale x 4 x i1> %mask, <vscale x 4 x i8> undef)
  %sext = sext <vscale x 4 x i8> %wide.load to <vscale x 4 x i64>
  %res = sitofp <vscale x 4 x i64> %sext to <vscale x 4 x double>
  ret <vscale x 4 x double> %res
}


; Extending loads from unpacked to wide illegal types

define <vscale x 4 x i64> @masked_sload_4i8_4i64(ptr %a, <vscale x 4 x i1> %b) {
; CHECK-LABEL: masked_sload_4i8_4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sb { z1.s }, p0/z, [x0]
; CHECK-NEXT:    sunpklo z0.d, z1.s
; CHECK-NEXT:    sunpkhi z1.d, z1.s
; CHECK-NEXT:    ret
  %aval = call <vscale x 4 x i8> @llvm.masked.load.nxv4i8(ptr %a, i32 16, <vscale x 4 x i1> %b, <vscale x 4 x i8> zeroinitializer)
  %aext = sext <vscale x 4 x i8> %aval to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %aext
}

define <vscale x 4 x i64> @masked_sload_4i16_4i64(ptr %a, <vscale x 4 x i1> %b) {
; CHECK-LABEL: masked_sload_4i16_4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sh { z1.s }, p0/z, [x0]
; CHECK-NEXT:    sunpklo z0.d, z1.s
; CHECK-NEXT:    sunpkhi z1.d, z1.s
; CHECK-NEXT:    ret
  %aval = call <vscale x 4 x i16> @llvm.masked.load.nxv4i16(ptr %a, i32 16, <vscale x 4 x i1> %b, <vscale x 4 x i16> zeroinitializer)
  %aext = sext <vscale x 4 x i16> %aval to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %aext
}

define <vscale x 8 x i32> @masked_sload_8i8_8i32(ptr %a, <vscale x 8 x i1> %b) {
; CHECK-LABEL: masked_sload_8i8_8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sb { z1.h }, p0/z, [x0]
; CHECK-NEXT:    sunpklo z0.s, z1.h
; CHECK-NEXT:    sunpkhi z1.s, z1.h
; CHECK-NEXT:    ret
  %aval = call <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr %a, i32 16, <vscale x 8 x i1> %b, <vscale x 8 x i8> zeroinitializer)
  %aext = sext <vscale x 8 x i8> %aval to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %aext
}

define <vscale x 8 x i64> @masked_sload_8i8_8i64(ptr %a, <vscale x 8 x i1> %b) {
; CHECK-LABEL: masked_sload_8i8_8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld1sb { z0.h }, p0/z, [x0]
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    sunpkhi z3.s, z0.h
; CHECK-NEXT:    sunpklo z0.d, z1.s
; CHECK-NEXT:    sunpkhi z1.d, z1.s
; CHECK-NEXT:    sunpklo z2.d, z3.s
; CHECK-NEXT:    sunpkhi z3.d, z3.s
; CHECK-NEXT:    ret
  %aval = call <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr %a, i32 16, <vscale x 8 x i1> %b, <vscale x 8 x i8> zeroinitializer)
  %aext = sext <vscale x 8 x i8> %aval to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %aext
}

define <vscale x 4 x i64> @masked_sload_x2_4i8_4i64(ptr %a, ptr %b, <vscale x 4 x i1> %c) {
; CHECK-LABEL: masked_sload_x2_4i8_4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p1.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ld1sb { z1.d }, p1/z, [x0, #1, mul vl]
; CHECK-NEXT:    ld1sb { z2.d }, p1/z, [x1, #1, mul vl]
; CHECK-NEXT:    ld1sb { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1sb { z3.d }, p0/z, [x1]
; CHECK-NEXT:    add z1.d, z1.d, z2.d
; CHECK-NEXT:    add z0.d, z0.d, z3.d
; CHECK-NEXT:    ret
  %aval = call <vscale x 4 x i8> @llvm.masked.load.nxv4i8(ptr %a, i32 16, <vscale x 4 x i1> %c, <vscale x 4 x i8> zeroinitializer)
  %bval = call <vscale x 4 x i8> @llvm.masked.load.nxv4i8(ptr %b, i32 16, <vscale x 4 x i1> %c, <vscale x 4 x i8> zeroinitializer)
  %aext = sext <vscale x 4 x i8> %aval to <vscale x 4 x i64>
  %bext = sext <vscale x 4 x i8> %bval to <vscale x 4 x i64>
  %res = add <vscale x 4 x i64> %aext, %bext
  ret <vscale x 4 x i64> %res
}

define <vscale x 4 x i64> @masked_sload_x2_4i16_4i64(ptr %a, ptr %b, <vscale x 4 x i1> %c) {
; CHECK-LABEL: masked_sload_x2_4i16_4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p1.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ld1sh { z1.d }, p1/z, [x0, #1, mul vl]
; CHECK-NEXT:    ld1sh { z2.d }, p1/z, [x1, #1, mul vl]
; CHECK-NEXT:    ld1sh { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1sh { z3.d }, p0/z, [x1]
; CHECK-NEXT:    add z1.d, z1.d, z2.d
; CHECK-NEXT:    add z0.d, z0.d, z3.d
; CHECK-NEXT:    ret
  %aval = call <vscale x 4 x i16> @llvm.masked.load.nxv4i16(ptr %a, i32 16, <vscale x 4 x i1> %c, <vscale x 4 x i16> zeroinitializer)
  %bval = call <vscale x 4 x i16> @llvm.masked.load.nxv4i16(ptr %b, i32 16, <vscale x 4 x i1> %c, <vscale x 4 x i16> zeroinitializer)
  %aext = sext <vscale x 4 x i16> %aval to <vscale x 4 x i64>
  %bext = sext <vscale x 4 x i16> %bval to <vscale x 4 x i64>
  %res = add <vscale x 4 x i64> %aext, %bext
  ret <vscale x 4 x i64> %res
}

define <vscale x 8 x i32> @masked_sload_x2_8i8_8i32(ptr %a, ptr %b, <vscale x 8 x i1> %c) {
; CHECK-LABEL: masked_sload_x2_8i8_8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p1.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ld1sb { z1.s }, p1/z, [x0, #1, mul vl]
; CHECK-NEXT:    ld1sb { z2.s }, p1/z, [x1, #1, mul vl]
; CHECK-NEXT:    ld1sb { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1sb { z3.s }, p0/z, [x1]
; CHECK-NEXT:    add z1.s, z1.s, z2.s
; CHECK-NEXT:    add z0.s, z0.s, z3.s
; CHECK-NEXT:    ret
  %aval = call <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr %a, i32 16, <vscale x 8 x i1> %c, <vscale x 8 x i8> zeroinitializer)
  %bval = call <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr %b, i32 16, <vscale x 8 x i1> %c, <vscale x 8 x i8> zeroinitializer)
  %aext = sext <vscale x 8 x i8> %aval to <vscale x 8 x i32>
  %bext = sext <vscale x 8 x i8> %bval to <vscale x 8 x i32>
  %res = add <vscale x 8 x i32> %aext, %bext
  ret <vscale x 8 x i32> %res
}

define <vscale x 8 x i64> @masked_sload_x2_8i8_8i64(ptr %a, ptr %b, <vscale x 8 x i1> %c) {
; CHECK-LABEL: masked_sload_x2_8i8_8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p1.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p2.h, p1.b
; CHECK-NEXT:    punpklo p1.h, p1.b
; CHECK-NEXT:    punpkhi p3.h, p0.b
; CHECK-NEXT:    ld1sb { z3.d }, p2/z, [x0, #3, mul vl]
; CHECK-NEXT:    ld1sb { z5.d }, p2/z, [x1, #3, mul vl]
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ld1sb { z2.d }, p1/z, [x0, #2, mul vl]
; CHECK-NEXT:    ld1sb { z6.d }, p1/z, [x1, #2, mul vl]
; CHECK-NEXT:    ld1sb { z1.d }, p3/z, [x0, #1, mul vl]
; CHECK-NEXT:    ld1sb { z7.d }, p3/z, [x1, #1, mul vl]
; CHECK-NEXT:    ld1sb { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1sb { z4.d }, p0/z, [x1]
; CHECK-NEXT:    add z3.d, z3.d, z5.d
; CHECK-NEXT:    add z2.d, z2.d, z6.d
; CHECK-NEXT:    add z1.d, z1.d, z7.d
; CHECK-NEXT:    add z0.d, z0.d, z4.d
; CHECK-NEXT:    ret
  %aval = call <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr %a, i32 16, <vscale x 8 x i1> %c, <vscale x 8 x i8> zeroinitializer)
  %bval = call <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr %b, i32 16, <vscale x 8 x i1> %c, <vscale x 8 x i8> zeroinitializer)
  %aext = sext <vscale x 8 x i8> %aval to <vscale x 8 x i64>
  %bext = sext <vscale x 8 x i8> %bval to <vscale x 8 x i64>
  %res = add <vscale x 8 x i64> %aext, %bext
  ret <vscale x 8 x i64> %res
}


declare <vscale x 2 x i8> @llvm.masked.load.nxv2i8(ptr, i32, <vscale x 2 x i1>, <vscale x 2 x i8>)
declare <vscale x 2 x i16> @llvm.masked.load.nxv2i16(ptr, i32, <vscale x 2 x i1>, <vscale x 2 x i16>)
declare <vscale x 2 x i32> @llvm.masked.load.nxv2i32(ptr, i32, <vscale x 2 x i1>, <vscale x 2 x i32>)
declare <vscale x 4 x i8> @llvm.masked.load.nxv4i8(ptr, i32, <vscale x 4 x i1>, <vscale x 4 x i8>)
declare <vscale x 4 x i16> @llvm.masked.load.nxv4i16(ptr, i32, <vscale x 4 x i1>, <vscale x 4 x i16>)
declare <vscale x 8 x i8> @llvm.masked.load.nxv8i8(ptr, i32, <vscale x 8 x i1>, <vscale x 8 x i8>)
declare <vscale x 16 x i8> @llvm.masked.load.nxv16i8(ptr, i32, <vscale x 16 x i1>, <vscale x 16 x i8>)
