; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=arm64-none-linux-gnu -mattr=+neon < %s | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=arm64-none-linux-gnu -mattr=+neon -global-isel < %s | FileCheck %s --check-prefixes=CHECK,CHECK-GI

declare <8 x i8> @llvm.aarch64.neon.addp.v8i8(<8 x i8>, <8 x i8>)

define <8 x i8> @test_addp_v8i8(<8 x i8> %lhs, <8 x i8> %rhs) {
; Using registers other than v0, v1 are possible, but would be odd.
; CHECK-LABEL: test_addp_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp1 = call <8 x i8> @llvm.aarch64.neon.addp.v8i8(<8 x i8> %lhs, <8 x i8> %rhs)
  ret <8 x i8> %tmp1
}

declare <16 x i8> @llvm.aarch64.neon.addp.v16i8(<16 x i8>, <16 x i8>)

define <16 x i8> @test_addp_v16i8(<16 x i8> %lhs, <16 x i8> %rhs) {
; CHECK-LABEL: test_addp_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = call <16 x i8> @llvm.aarch64.neon.addp.v16i8(<16 x i8> %lhs, <16 x i8> %rhs)
  ret <16 x i8> %tmp1
}

declare <4 x i16> @llvm.aarch64.neon.addp.v4i16(<4 x i16>, <4 x i16>)

define <4 x i16> @test_addp_v4i16(<4 x i16> %lhs, <4 x i16> %rhs) {
; CHECK-LABEL: test_addp_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp1 = call <4 x i16> @llvm.aarch64.neon.addp.v4i16(<4 x i16> %lhs, <4 x i16> %rhs)
  ret <4 x i16> %tmp1
}

declare <8 x i16> @llvm.aarch64.neon.addp.v8i16(<8 x i16>, <8 x i16>)

define <8 x i16> @test_addp_v8i16(<8 x i16> %lhs, <8 x i16> %rhs) {
; CHECK-LABEL: test_addp_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp1 = call <8 x i16> @llvm.aarch64.neon.addp.v8i16(<8 x i16> %lhs, <8 x i16> %rhs)
  ret <8 x i16> %tmp1
}

declare <2 x i32> @llvm.aarch64.neon.addp.v2i32(<2 x i32>, <2 x i32>)

define <2 x i32> @test_addp_v2i32(<2 x i32> %lhs, <2 x i32> %rhs) {
; CHECK-LABEL: test_addp_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp1 = call <2 x i32> @llvm.aarch64.neon.addp.v2i32(<2 x i32> %lhs, <2 x i32> %rhs)
  ret <2 x i32> %tmp1
}

declare <4 x i32> @llvm.aarch64.neon.addp.v4i32(<4 x i32>, <4 x i32>)

define <4 x i32> @test_addp_v4i32(<4 x i32> %lhs, <4 x i32> %rhs) {
; CHECK-LABEL: test_addp_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp1 = call <4 x i32> @llvm.aarch64.neon.addp.v4i32(<4 x i32> %lhs, <4 x i32> %rhs)
  ret <4 x i32> %tmp1
}


declare <2 x i64> @llvm.aarch64.neon.addp.v2i64(<2 x i64>, <2 x i64>)

define <2 x i64> @test_addp_v2i64(<2 x i64> %lhs, <2 x i64> %rhs) {
; CHECK-LABEL: test_addp_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
        %val = call <2 x i64> @llvm.aarch64.neon.addp.v2i64(<2 x i64> %lhs, <2 x i64> %rhs)
        ret <2 x i64> %val
}

declare <2 x float> @llvm.aarch64.neon.faddp.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.aarch64.neon.faddp.v4f32(<4 x float>, <4 x float>)
declare <2 x double> @llvm.aarch64.neon.faddp.v2f64(<2 x double>, <2 x double>)

define <2 x float> @test_faddp_v2f32(<2 x float> %lhs, <2 x float> %rhs) {
; CHECK-LABEL: test_faddp_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    faddp v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
        %val = call <2 x float> @llvm.aarch64.neon.faddp.v2f32(<2 x float> %lhs, <2 x float> %rhs)
        ret <2 x float> %val
}

define <4 x float> @test_faddp_v4f32(<4 x float> %lhs, <4 x float> %rhs) {
; CHECK-LABEL: test_faddp_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    faddp v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
        %val = call <4 x float> @llvm.aarch64.neon.faddp.v4f32(<4 x float> %lhs, <4 x float> %rhs)
        ret <4 x float> %val
}

define <2 x double> @test_faddp_v2f64(<2 x double> %lhs, <2 x double> %rhs) {
; CHECK-LABEL: test_faddp_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    faddp v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
        %val = call <2 x double> @llvm.aarch64.neon.faddp.v2f64(<2 x double> %lhs, <2 x double> %rhs)
        ret <2 x double> %val
}

define i32 @test_vaddv.v2i32(<2 x i32> %a) {
; CHECK-LABEL: test_vaddv.v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp v0.2s, v0.2s, v0.2s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %1 = tail call i32 @llvm.aarch64.neon.saddv.i32.v2i32(<2 x i32> %a)
  ret i32 %1
}

declare i32 @llvm.aarch64.neon.saddv.i32.v2i32(<2 x i32>)

define i32 @addp_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-SD-LABEL: addp_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    addp v0.4s, v0.4s, v0.4s
; CHECK-SD-NEXT:    dup v1.2s, v0.s[1]
; CHECK-SD-NEXT:    add v0.2s, v0.2s, v1.2s
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: addp_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    addp v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    rev64 v1.2s, v0.2s
; CHECK-GI-NEXT:    add v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
  %1 = add <4 x i32> %a, %b
  %2 = shufflevector <4 x i32> %1, <4 x i32> poison, <2 x i32> <i32 0, i32 1>
  %3 = shufflevector <4 x i32> %1, <4 x i32> poison, <2 x i32> <i32 2, i32 3>
  %4 = tail call <2 x i32> @llvm.aarch64.neon.addp.v2i32(<2 x i32> %2, <2 x i32> %3)
  %5 = shufflevector <2 x i32> %4, <2 x i32> poison, <2 x i32> <i32 1, i32 poison>
  %6 = add <2 x i32> %4, %5
  %7 = extractelement <2 x i32> %6, i64 0
  ret i32 %7
}

define <4 x i16> @addp_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-SD-LABEL: addp_v8i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add v0.8h, v0.8h, v1.8h
; CHECK-SD-NEXT:    addp v0.8h, v0.8h, v0.8h
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: addp_v8i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    addp v0.4h, v0.4h, v1.4h
; CHECK-GI-NEXT:    ret
  %1 = add <8 x i16> %a, %b
  %2 = shufflevector <8 x i16> %1, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <8 x i16> %1, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = tail call <4 x i16> @llvm.aarch64.neon.addp.v4i16(<4 x i16> %2, <4 x i16> %3)
  ret <4 x i16> %4
}

define <8 x i8> @addp_v16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-SD-LABEL: addp_v16i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    addp v0.16b, v0.16b, v0.16b
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: addp_v16i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    addp v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %1 = add <16 x i8> %a, %b
  %2 = shufflevector <16 x i8> %1, <16 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <16 x i8> %1, <16 x i8> poison, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = tail call <8 x i8> @llvm.aarch64.neon.addp.v8i8(<8 x i8> %2, <8 x i8> %3)
  ret <8 x i8> %4
}

