; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=aarch64-unknown-linux-gnu -mattr=+sve2 -passes="print<cost-model>" 2>&1 -disable-output | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @sdiv() {
; CHECK-LABEL: 'sdiv'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sdiv <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = sdiv <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = sdiv <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sdiv <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sdiv <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = sdiv <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = sdiv <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = sdiv <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = sdiv <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i16 = sdiv <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i16 = sdiv <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i16 = sdiv <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = sdiv <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i8 = sdiv <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i8 = sdiv <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i8 = sdiv <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i8 = sdiv <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i8 = sdiv <64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = sdiv <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = sdiv <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = sdiv <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = sdiv <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = sdiv <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = sdiv <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = sdiv <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = sdiv <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = sdiv <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = sdiv <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = sdiv <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = sdiv <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = sdiv <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = sdiv <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = sdiv <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = sdiv <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = sdiv <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = sdiv <vscale x 64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = sdiv <2 x i64> undef, undef
  %V4i64 = sdiv <4 x i64> undef, undef
  %V8i64 = sdiv <8 x i64> undef, undef
  %V2i32 = sdiv <2 x i32> undef, undef
  %V4i32 = sdiv <4 x i32> undef, undef
  %V8i32 = sdiv <8 x i32> undef, undef
  %V16i32 = sdiv <16 x i32> undef, undef
  %V2i16 = sdiv <2 x i16> undef, undef
  %V4i16 = sdiv <4 x i16> undef, undef
  %V8i16 = sdiv <8 x i16> undef, undef
  %V16i16 = sdiv <16 x i16> undef, undef
  %V32i16 = sdiv <32 x i16> undef, undef
  %V2i8 = sdiv <2 x i8> undef, undef
  %V4i8 = sdiv <4 x i8> undef, undef
  %V8i8 = sdiv <8 x i8> undef, undef
  %V16i8 = sdiv <16 x i8> undef, undef
  %V32i8 = sdiv <32 x i8> undef, undef
  %V64i8 = sdiv <64 x i8> undef, undef
  %NV2i64 = sdiv <vscale x 2 x i64> undef, undef
  %NV4i64 = sdiv <vscale x 4 x i64> undef, undef
  %NV8i64 = sdiv <vscale x 8 x i64> undef, undef
  %NV2i32 = sdiv <vscale x 2 x i32> undef, undef
  %NV4i32 = sdiv <vscale x 4 x i32> undef, undef
  %NV8i32 = sdiv <vscale x 8 x i32> undef, undef
  %NV16i32 = sdiv <vscale x 16 x i32> undef, undef
  %NV2i16 = sdiv <vscale x 2 x i16> undef, undef
  %NV4i16 = sdiv <vscale x 4 x i16> undef, undef
  %NV8i16 = sdiv <vscale x 8 x i16> undef, undef
  %NV16i16 = sdiv <vscale x 16 x i16> undef, undef
  %NV32i16 = sdiv <vscale x 32 x i16> undef, undef
  %NV2i8 = sdiv <vscale x 2 x i8> undef, undef
  %NV4i8 = sdiv <vscale x 4 x i8> undef, undef
  %NV8i8 = sdiv <vscale x 8 x i8> undef, undef
  %NV16i8 = sdiv <vscale x 16 x i8> undef, undef
  %NV32i8 = sdiv <vscale x 32 x i8> undef, undef
  %NV64i8 = sdiv <vscale x 64 x i8> undef, undef
  ret void
}

define void @udiv() {
; CHECK-LABEL: 'udiv'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = udiv <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = udiv <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = udiv <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = udiv <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = udiv <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = udiv <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = udiv <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = udiv <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = udiv <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i16 = udiv <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i16 = udiv <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i16 = udiv <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = udiv <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i8 = udiv <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i8 = udiv <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i8 = udiv <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i8 = udiv <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i8 = udiv <64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = udiv <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = udiv <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = udiv <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = udiv <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = udiv <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = udiv <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = udiv <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = udiv <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = udiv <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = udiv <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = udiv <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = udiv <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = udiv <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = udiv <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = udiv <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = udiv <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = udiv <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = udiv <vscale x 64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = udiv <2 x i64> undef, undef
  %V4i64 = udiv <4 x i64> undef, undef
  %V8i64 = udiv <8 x i64> undef, undef
  %V2i32 = udiv <2 x i32> undef, undef
  %V4i32 = udiv <4 x i32> undef, undef
  %V8i32 = udiv <8 x i32> undef, undef
  %V16i32 = udiv <16 x i32> undef, undef
  %V2i16 = udiv <2 x i16> undef, undef
  %V4i16 = udiv <4 x i16> undef, undef
  %V8i16 = udiv <8 x i16> undef, undef
  %V16i16 = udiv <16 x i16> undef, undef
  %V32i16 = udiv <32 x i16> undef, undef
  %V2i8 = udiv <2 x i8> undef, undef
  %V4i8 = udiv <4 x i8> undef, undef
  %V8i8 = udiv <8 x i8> undef, undef
  %V16i8 = udiv <16 x i8> undef, undef
  %V32i8 = udiv <32 x i8> undef, undef
  %V64i8 = udiv <64 x i8> undef, undef
  %NV2i64 = udiv <vscale x 2 x i64> undef, undef
  %NV4i64 = udiv <vscale x 4 x i64> undef, undef
  %NV8i64 = udiv <vscale x 8 x i64> undef, undef
  %NV2i32 = udiv <vscale x 2 x i32> undef, undef
  %NV4i32 = udiv <vscale x 4 x i32> undef, undef
  %NV8i32 = udiv <vscale x 8 x i32> undef, undef
  %NV16i32 = udiv <vscale x 16 x i32> undef, undef
  %NV2i16 = udiv <vscale x 2 x i16> undef, undef
  %NV4i16 = udiv <vscale x 4 x i16> undef, undef
  %NV8i16 = udiv <vscale x 8 x i16> undef, undef
  %NV16i16 = udiv <vscale x 16 x i16> undef, undef
  %NV32i16 = udiv <vscale x 32 x i16> undef, undef
  %NV2i8 = udiv <vscale x 2 x i8> undef, undef
  %NV4i8 = udiv <vscale x 4 x i8> undef, undef
  %NV8i8 = udiv <vscale x 8 x i8> undef, undef
  %NV16i8 = udiv <vscale x 16 x i8> undef, undef
  %NV32i8 = udiv <vscale x 32 x i8> undef, undef
  %NV64i8 = udiv <vscale x 64 x i8> undef, undef
  ret void
}

define void @sdiv_uniformconst() {
; CHECK-LABEL: 'sdiv_uniformconst'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sdiv <2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = sdiv <4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = sdiv <8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sdiv <2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4i32 = sdiv <4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = sdiv <8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = sdiv <16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = sdiv <2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = sdiv <4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i16 = sdiv <8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i16 = sdiv <16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i16 = sdiv <32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = sdiv <2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i8 = sdiv <4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i8 = sdiv <8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i8 = sdiv <16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i8 = sdiv <32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i8 = sdiv <64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = sdiv <vscale x 2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = sdiv <vscale x 4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = sdiv <vscale x 8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = sdiv <vscale x 2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = sdiv <vscale x 4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = sdiv <vscale x 8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = sdiv <vscale x 16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = sdiv <vscale x 2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = sdiv <vscale x 4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = sdiv <vscale x 8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = sdiv <vscale x 16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = sdiv <vscale x 32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = sdiv <vscale x 2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = sdiv <vscale x 4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = sdiv <vscale x 8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = sdiv <vscale x 16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = sdiv <vscale x 32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = sdiv <vscale x 64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = sdiv <2 x i64> undef, splat (i64 7)
  %V4i64 = sdiv <4 x i64> undef, splat (i64 7)
  %V8i64 = sdiv <8 x i64> undef, splat (i64 7)
  %V2i32 = sdiv <2 x i32> undef, splat (i32 7)
  %V4i32 = sdiv <4 x i32> undef, splat (i32 7)
  %V8i32 = sdiv <8 x i32> undef, splat (i32 7)
  %V16i32 = sdiv <16 x i32> undef, splat (i32 7)
  %V2i16 = sdiv <2 x i16> undef, splat (i16 7)
  %V4i16 = sdiv <4 x i16> undef, splat (i16 7)
  %V8i16 = sdiv <8 x i16> undef, splat (i16 7)
  %V16i16 = sdiv <16 x i16> undef, splat (i16 7)
  %V32i16 = sdiv <32 x i16> undef, splat (i16 7)
  %V2i8 = sdiv <2 x i8> undef, splat (i8 7)
  %V4i8 = sdiv <4 x i8> undef, splat (i8 7)
  %V8i8 = sdiv <8 x i8> undef, splat (i8 7)
  %V16i8 = sdiv <16 x i8> undef, splat (i8 7)
  %V32i8 = sdiv <32 x i8> undef, splat (i8 7)
  %V64i8 = sdiv <64 x i8> undef, splat (i8 7)
  %NV2i64 = sdiv <vscale x 2 x i64> undef, splat (i64 7)
  %NV4i64 = sdiv <vscale x 4 x i64> undef, splat (i64 7)
  %NV8i64 = sdiv <vscale x 8 x i64> undef, splat (i64 7)
  %NV2i32 = sdiv <vscale x 2 x i32> undef, splat (i32 7)
  %NV4i32 = sdiv <vscale x 4 x i32> undef, splat (i32 7)
  %NV8i32 = sdiv <vscale x 8 x i32> undef, splat (i32 7)
  %NV16i32 = sdiv <vscale x 16 x i32> undef, splat (i32 7)
  %NV2i16 = sdiv <vscale x 2 x i16> undef, splat (i16 7)
  %NV4i16 = sdiv <vscale x 4 x i16> undef, splat (i16 7)
  %NV8i16 = sdiv <vscale x 8 x i16> undef, splat (i16 7)
  %NV16i16 = sdiv <vscale x 16 x i16> undef, splat (i16 7)
  %NV32i16 = sdiv <vscale x 32 x i16> undef, splat (i16 7)
  %NV2i8 = sdiv <vscale x 2 x i8> undef, splat (i8 7)
  %NV4i8 = sdiv <vscale x 4 x i8> undef, splat (i8 7)
  %NV8i8 = sdiv <vscale x 8 x i8> undef, splat (i8 7)
  %NV16i8 = sdiv <vscale x 16 x i8> undef, splat (i8 7)
  %NV32i8 = sdiv <vscale x 32 x i8> undef, splat (i8 7)
  %NV64i8 = sdiv <vscale x 64 x i8> undef, splat (i8 7)
  ret void
}

define void @udiv_uniformconst() {
; CHECK-LABEL: 'udiv_uniformconst'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = udiv <2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = udiv <4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = udiv <8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = udiv <2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4i32 = udiv <4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = udiv <8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = udiv <16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = udiv <2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = udiv <4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i16 = udiv <8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i16 = udiv <16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i16 = udiv <32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = udiv <2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i8 = udiv <4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i8 = udiv <8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i8 = udiv <16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i8 = udiv <32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i8 = udiv <64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = udiv <vscale x 2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = udiv <vscale x 4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = udiv <vscale x 8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = udiv <vscale x 2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = udiv <vscale x 4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = udiv <vscale x 8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = udiv <vscale x 16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = udiv <vscale x 2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = udiv <vscale x 4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = udiv <vscale x 8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = udiv <vscale x 16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = udiv <vscale x 32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = udiv <vscale x 2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = udiv <vscale x 4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = udiv <vscale x 8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = udiv <vscale x 16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = udiv <vscale x 32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = udiv <vscale x 64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = udiv <2 x i64> undef, splat (i64 7)
  %V4i64 = udiv <4 x i64> undef, splat (i64 7)
  %V8i64 = udiv <8 x i64> undef, splat (i64 7)
  %V2i32 = udiv <2 x i32> undef, splat (i32 7)
  %V4i32 = udiv <4 x i32> undef, splat (i32 7)
  %V8i32 = udiv <8 x i32> undef, splat (i32 7)
  %V16i32 = udiv <16 x i32> undef, splat (i32 7)
  %V2i16 = udiv <2 x i16> undef, splat (i16 7)
  %V4i16 = udiv <4 x i16> undef, splat (i16 7)
  %V8i16 = udiv <8 x i16> undef, splat (i16 7)
  %V16i16 = udiv <16 x i16> undef, splat (i16 7)
  %V32i16 = udiv <32 x i16> undef, splat (i16 7)
  %V2i8 = udiv <2 x i8> undef, splat (i8 7)
  %V4i8 = udiv <4 x i8> undef, splat (i8 7)
  %V8i8 = udiv <8 x i8> undef, splat (i8 7)
  %V16i8 = udiv <16 x i8> undef, splat (i8 7)
  %V32i8 = udiv <32 x i8> undef, splat (i8 7)
  %V64i8 = udiv <64 x i8> undef, splat (i8 7)
  %NV2i64 = udiv <vscale x 2 x i64> undef, splat (i64 7)
  %NV4i64 = udiv <vscale x 4 x i64> undef, splat (i64 7)
  %NV8i64 = udiv <vscale x 8 x i64> undef, splat (i64 7)
  %NV2i32 = udiv <vscale x 2 x i32> undef, splat (i32 7)
  %NV4i32 = udiv <vscale x 4 x i32> undef, splat (i32 7)
  %NV8i32 = udiv <vscale x 8 x i32> undef, splat (i32 7)
  %NV16i32 = udiv <vscale x 16 x i32> undef, splat (i32 7)
  %NV2i16 = udiv <vscale x 2 x i16> undef, splat (i16 7)
  %NV4i16 = udiv <vscale x 4 x i16> undef, splat (i16 7)
  %NV8i16 = udiv <vscale x 8 x i16> undef, splat (i16 7)
  %NV16i16 = udiv <vscale x 16 x i16> undef, splat (i16 7)
  %NV32i16 = udiv <vscale x 32 x i16> undef, splat (i16 7)
  %NV2i8 = udiv <vscale x 2 x i8> undef, splat (i8 7)
  %NV4i8 = udiv <vscale x 4 x i8> undef, splat (i8 7)
  %NV8i8 = udiv <vscale x 8 x i8> undef, splat (i8 7)
  %NV16i8 = udiv <vscale x 16 x i8> undef, splat (i8 7)
  %NV32i8 = udiv <vscale x 32 x i8> undef, splat (i8 7)
  %NV64i8 = udiv <vscale x 64 x i8> undef, splat (i8 7)
  ret void
}

define void @sdiv_uniformconstpow2() {
; CHECK-LABEL: 'sdiv_uniformconstpow2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V2i64 = sdiv <2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V4i64 = sdiv <4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 60 for instruction: %V8i64 = sdiv <8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V2i32 = sdiv <2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %V4i32 = sdiv <4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %V8i32 = sdiv <8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 108 for instruction: %V16i32 = sdiv <16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V2i16 = sdiv <2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %V4i16 = sdiv <4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V8i16 = sdiv <8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %V16i16 = sdiv <16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 204 for instruction: %V32i16 = sdiv <32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V2i8 = sdiv <2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %V4i8 = sdiv <4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V8i8 = sdiv <8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V16i8 = sdiv <16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 198 for instruction: %V32i8 = sdiv <32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 396 for instruction: %V64i8 = sdiv <64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = sdiv <vscale x 2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = sdiv <vscale x 4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = sdiv <vscale x 8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = sdiv <vscale x 2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = sdiv <vscale x 4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = sdiv <vscale x 8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = sdiv <vscale x 16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = sdiv <vscale x 2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = sdiv <vscale x 4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = sdiv <vscale x 8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = sdiv <vscale x 16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = sdiv <vscale x 32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = sdiv <vscale x 2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = sdiv <vscale x 4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = sdiv <vscale x 8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = sdiv <vscale x 16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = sdiv <vscale x 32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = sdiv <vscale x 64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = sdiv <2 x i64> undef, splat (i64 16)
  %V4i64 = sdiv <4 x i64> undef, splat (i64 16)
  %V8i64 = sdiv <8 x i64> undef, splat (i64 16)
  %V2i32 = sdiv <2 x i32> undef, splat (i32 16)
  %V4i32 = sdiv <4 x i32> undef, splat (i32 16)
  %V8i32 = sdiv <8 x i32> undef, splat (i32 16)
  %V16i32 = sdiv <16 x i32> undef, splat (i32 16)
  %V2i16 = sdiv <2 x i16> undef, splat (i16 16)
  %V4i16 = sdiv <4 x i16> undef, splat (i16 16)
  %V8i16 = sdiv <8 x i16> undef, splat (i16 16)
  %V16i16 = sdiv <16 x i16> undef, splat (i16 16)
  %V32i16 = sdiv <32 x i16> undef, splat (i16 16)
  %V2i8 = sdiv <2 x i8> undef, splat (i8 16)
  %V4i8 = sdiv <4 x i8> undef, splat (i8 16)
  %V8i8 = sdiv <8 x i8> undef, splat (i8 16)
  %V16i8 = sdiv <16 x i8> undef, splat (i8 16)
  %V32i8 = sdiv <32 x i8> undef, splat (i8 16)
  %V64i8 = sdiv <64 x i8> undef, splat (i8 16)
  %NV2i64 = sdiv <vscale x 2 x i64> undef, splat (i64 16)
  %NV4i64 = sdiv <vscale x 4 x i64> undef, splat (i64 16)
  %NV8i64 = sdiv <vscale x 8 x i64> undef, splat (i64 16)
  %NV2i32 = sdiv <vscale x 2 x i32> undef, splat (i32 16)
  %NV4i32 = sdiv <vscale x 4 x i32> undef, splat (i32 16)
  %NV8i32 = sdiv <vscale x 8 x i32> undef, splat (i32 16)
  %NV16i32 = sdiv <vscale x 16 x i32> undef, splat (i32 16)
  %NV2i16 = sdiv <vscale x 2 x i16> undef, splat (i16 16)
  %NV4i16 = sdiv <vscale x 4 x i16> undef, splat (i16 16)
  %NV8i16 = sdiv <vscale x 8 x i16> undef, splat (i16 16)
  %NV16i16 = sdiv <vscale x 16 x i16> undef, splat (i16 16)
  %NV32i16 = sdiv <vscale x 32 x i16> undef, splat (i16 16)
  %NV2i8 = sdiv <vscale x 2 x i8> undef, splat (i8 16)
  %NV4i8 = sdiv <vscale x 4 x i8> undef, splat (i8 16)
  %NV8i8 = sdiv <vscale x 8 x i8> undef, splat (i8 16)
  %NV16i8 = sdiv <vscale x 16 x i8> undef, splat (i8 16)
  %NV32i8 = sdiv <vscale x 32 x i8> undef, splat (i8 16)
  %NV64i8 = sdiv <vscale x 64 x i8> undef, splat (i8 16)
  ret void
}

define void @udiv_uniformconstpow2() {
; CHECK-LABEL: 'udiv_uniformconstpow2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = udiv <2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = udiv <4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = udiv <8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = udiv <2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4i32 = udiv <4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = udiv <8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = udiv <16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = udiv <2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = udiv <4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i16 = udiv <8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i16 = udiv <16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i16 = udiv <32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = udiv <2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i8 = udiv <4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i8 = udiv <8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i8 = udiv <16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i8 = udiv <32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i8 = udiv <64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = udiv <vscale x 2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = udiv <vscale x 4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = udiv <vscale x 8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = udiv <vscale x 2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = udiv <vscale x 4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = udiv <vscale x 8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = udiv <vscale x 16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = udiv <vscale x 2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = udiv <vscale x 4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = udiv <vscale x 8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = udiv <vscale x 16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = udiv <vscale x 32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = udiv <vscale x 2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = udiv <vscale x 4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = udiv <vscale x 8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = udiv <vscale x 16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = udiv <vscale x 32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = udiv <vscale x 64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = udiv <2 x i64> undef, splat (i64 16)
  %V4i64 = udiv <4 x i64> undef, splat (i64 16)
  %V8i64 = udiv <8 x i64> undef, splat (i64 16)
  %V2i32 = udiv <2 x i32> undef, splat (i32 16)
  %V4i32 = udiv <4 x i32> undef, splat (i32 16)
  %V8i32 = udiv <8 x i32> undef, splat (i32 16)
  %V16i32 = udiv <16 x i32> undef, splat (i32 16)
  %V2i16 = udiv <2 x i16> undef, splat (i16 16)
  %V4i16 = udiv <4 x i16> undef, splat (i16 16)
  %V8i16 = udiv <8 x i16> undef, splat (i16 16)
  %V16i16 = udiv <16 x i16> undef, splat (i16 16)
  %V32i16 = udiv <32 x i16> undef, splat (i16 16)
  %V2i8 = udiv <2 x i8> undef, splat (i8 16)
  %V4i8 = udiv <4 x i8> undef, splat (i8 16)
  %V8i8 = udiv <8 x i8> undef, splat (i8 16)
  %V16i8 = udiv <16 x i8> undef, splat (i8 16)
  %V32i8 = udiv <32 x i8> undef, splat (i8 16)
  %V64i8 = udiv <64 x i8> undef, splat (i8 16)
  %NV2i64 = udiv <vscale x 2 x i64> undef, splat (i64 16)
  %NV4i64 = udiv <vscale x 4 x i64> undef, splat (i64 16)
  %NV8i64 = udiv <vscale x 8 x i64> undef, splat (i64 16)
  %NV2i32 = udiv <vscale x 2 x i32> undef, splat (i32 16)
  %NV4i32 = udiv <vscale x 4 x i32> undef, splat (i32 16)
  %NV8i32 = udiv <vscale x 8 x i32> undef, splat (i32 16)
  %NV16i32 = udiv <vscale x 16 x i32> undef, splat (i32 16)
  %NV2i16 = udiv <vscale x 2 x i16> undef, splat (i16 16)
  %NV4i16 = udiv <vscale x 4 x i16> undef, splat (i16 16)
  %NV8i16 = udiv <vscale x 8 x i16> undef, splat (i16 16)
  %NV16i16 = udiv <vscale x 16 x i16> undef, splat (i16 16)
  %NV32i16 = udiv <vscale x 32 x i16> undef, splat (i16 16)
  %NV2i8 = udiv <vscale x 2 x i8> undef, splat (i8 16)
  %NV4i8 = udiv <vscale x 4 x i8> undef, splat (i8 16)
  %NV8i8 = udiv <vscale x 8 x i8> undef, splat (i8 16)
  %NV16i8 = udiv <vscale x 16 x i8> undef, splat (i8 16)
  %NV32i8 = udiv <vscale x 32 x i8> undef, splat (i8 16)
  %NV64i8 = udiv <vscale x 64 x i8> undef, splat (i8 16)
  ret void
}

define void @sdiv_uniformconstnegpow2() {
; CHECK-LABEL: 'sdiv_uniformconstnegpow2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sdiv <2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = sdiv <4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = sdiv <8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sdiv <2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4i32 = sdiv <4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = sdiv <8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = sdiv <16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = sdiv <2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = sdiv <4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i16 = sdiv <8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i16 = sdiv <16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i16 = sdiv <32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = sdiv <2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i8 = sdiv <4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i8 = sdiv <8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i8 = sdiv <16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i8 = sdiv <32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i8 = sdiv <64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = sdiv <vscale x 2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = sdiv <vscale x 4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = sdiv <vscale x 8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = sdiv <vscale x 2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = sdiv <vscale x 4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = sdiv <vscale x 8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = sdiv <vscale x 16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = sdiv <vscale x 2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = sdiv <vscale x 4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = sdiv <vscale x 8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = sdiv <vscale x 16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = sdiv <vscale x 32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = sdiv <vscale x 2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = sdiv <vscale x 4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = sdiv <vscale x 8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = sdiv <vscale x 16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = sdiv <vscale x 32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = sdiv <vscale x 64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = sdiv <2 x i64> undef, splat (i64 -16)
  %V4i64 = sdiv <4 x i64> undef, splat (i64 -16)
  %V8i64 = sdiv <8 x i64> undef, splat (i64 -16)
  %V2i32 = sdiv <2 x i32> undef, splat (i32 -16)
  %V4i32 = sdiv <4 x i32> undef, splat (i32 -16)
  %V8i32 = sdiv <8 x i32> undef, splat (i32 -16)
  %V16i32 = sdiv <16 x i32> undef, splat (i32 -16)
  %V2i16 = sdiv <2 x i16> undef, splat (i16 -16)
  %V4i16 = sdiv <4 x i16> undef, splat (i16 -16)
  %V8i16 = sdiv <8 x i16> undef, splat (i16 -16)
  %V16i16 = sdiv <16 x i16> undef, splat (i16 -16)
  %V32i16 = sdiv <32 x i16> undef, splat (i16 -16)
  %V2i8 = sdiv <2 x i8> undef, splat (i8 -16)
  %V4i8 = sdiv <4 x i8> undef, splat (i8 -16)
  %V8i8 = sdiv <8 x i8> undef, splat (i8 -16)
  %V16i8 = sdiv <16 x i8> undef, splat (i8 -16)
  %V32i8 = sdiv <32 x i8> undef, splat (i8 -16)
  %V64i8 = sdiv <64 x i8> undef, splat (i8 -16)
  %NV2i64 = sdiv <vscale x 2 x i64> undef, splat (i64 -16)
  %NV4i64 = sdiv <vscale x 4 x i64> undef, splat (i64 -16)
  %NV8i64 = sdiv <vscale x 8 x i64> undef, splat (i64 -16)
  %NV2i32 = sdiv <vscale x 2 x i32> undef, splat (i32 -16)
  %NV4i32 = sdiv <vscale x 4 x i32> undef, splat (i32 -16)
  %NV8i32 = sdiv <vscale x 8 x i32> undef, splat (i32 -16)
  %NV16i32 = sdiv <vscale x 16 x i32> undef, splat (i32 -16)
  %NV2i16 = sdiv <vscale x 2 x i16> undef, splat (i16 -16)
  %NV4i16 = sdiv <vscale x 4 x i16> undef, splat (i16 -16)
  %NV8i16 = sdiv <vscale x 8 x i16> undef, splat (i16 -16)
  %NV16i16 = sdiv <vscale x 16 x i16> undef, splat (i16 -16)
  %NV32i16 = sdiv <vscale x 32 x i16> undef, splat (i16 -16)
  %NV2i8 = sdiv <vscale x 2 x i8> undef, splat (i8 -16)
  %NV4i8 = sdiv <vscale x 4 x i8> undef, splat (i8 -16)
  %NV8i8 = sdiv <vscale x 8 x i8> undef, splat (i8 -16)
  %NV16i8 = sdiv <vscale x 16 x i8> undef, splat (i8 -16)
  %NV32i8 = sdiv <vscale x 32 x i8> undef, splat (i8 -16)
  %NV64i8 = sdiv <vscale x 64 x i8> undef, splat (i8 -16)
  ret void
}

define void @udiv_uniformconstnegpow2() {
; CHECK-LABEL: 'udiv_uniformconstnegpow2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = udiv <2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = udiv <4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = udiv <8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = udiv <2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4i32 = udiv <4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = udiv <8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = udiv <16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = udiv <2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = udiv <4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i16 = udiv <8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i16 = udiv <16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i16 = udiv <32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = udiv <2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i8 = udiv <4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i8 = udiv <8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i8 = udiv <16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i8 = udiv <32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i8 = udiv <64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i64 = udiv <vscale x 2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV4i64 = udiv <vscale x 4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i64 = udiv <vscale x 8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i32 = udiv <vscale x 2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i32 = udiv <vscale x 4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NV8i32 = udiv <vscale x 8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV16i32 = udiv <vscale x 16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i16 = udiv <vscale x 2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i16 = udiv <vscale x 4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i16 = udiv <vscale x 8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i16 = udiv <vscale x 16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i16 = udiv <vscale x 32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV2i8 = udiv <vscale x 2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NV4i8 = udiv <vscale x 4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NV8i8 = udiv <vscale x 8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NV16i8 = udiv <vscale x 16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %NV32i8 = udiv <vscale x 32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %NV64i8 = udiv <vscale x 64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %V2i64 = udiv <2 x i64> undef, splat (i64 -16)
  %V4i64 = udiv <4 x i64> undef, splat (i64 -16)
  %V8i64 = udiv <8 x i64> undef, splat (i64 -16)
  %V2i32 = udiv <2 x i32> undef, splat (i32 -16)
  %V4i32 = udiv <4 x i32> undef, splat (i32 -16)
  %V8i32 = udiv <8 x i32> undef, splat (i32 -16)
  %V16i32 = udiv <16 x i32> undef, splat (i32 -16)
  %V2i16 = udiv <2 x i16> undef, splat (i16 -16)
  %V4i16 = udiv <4 x i16> undef, splat (i16 -16)
  %V8i16 = udiv <8 x i16> undef, splat (i16 -16)
  %V16i16 = udiv <16 x i16> undef, splat (i16 -16)
  %V32i16 = udiv <32 x i16> undef, splat (i16 -16)
  %V2i8 = udiv <2 x i8> undef, splat (i8 -16)
  %V4i8 = udiv <4 x i8> undef, splat (i8 -16)
  %V8i8 = udiv <8 x i8> undef, splat (i8 -16)
  %V16i8 = udiv <16 x i8> undef, splat (i8 -16)
  %V32i8 = udiv <32 x i8> undef, splat (i8 -16)
  %V64i8 = udiv <64 x i8> undef, splat (i8 -16)
  %NV2i64 = udiv <vscale x 2 x i64> undef, splat (i64 -16)
  %NV4i64 = udiv <vscale x 4 x i64> undef, splat (i64 -16)
  %NV8i64 = udiv <vscale x 8 x i64> undef, splat (i64 -16)
  %NV2i32 = udiv <vscale x 2 x i32> undef, splat (i32 -16)
  %NV4i32 = udiv <vscale x 4 x i32> undef, splat (i32 -16)
  %NV8i32 = udiv <vscale x 8 x i32> undef, splat (i32 -16)
  %NV16i32 = udiv <vscale x 16 x i32> undef, splat (i32 -16)
  %NV2i16 = udiv <vscale x 2 x i16> undef, splat (i16 -16)
  %NV4i16 = udiv <vscale x 4 x i16> undef, splat (i16 -16)
  %NV8i16 = udiv <vscale x 8 x i16> undef, splat (i16 -16)
  %NV16i16 = udiv <vscale x 16 x i16> undef, splat (i16 -16)
  %NV32i16 = udiv <vscale x 32 x i16> undef, splat (i16 -16)
  %NV2i8 = udiv <vscale x 2 x i8> undef, splat (i8 -16)
  %NV4i8 = udiv <vscale x 4 x i8> undef, splat (i8 -16)
  %NV8i8 = udiv <vscale x 8 x i8> undef, splat (i8 -16)
  %NV16i8 = udiv <vscale x 16 x i8> undef, splat (i8 -16)
  %NV32i8 = udiv <vscale x 32 x i8> undef, splat (i8 -16)
  %NV64i8 = udiv <vscale x 64 x i8> undef, splat (i8 -16)
  ret void
}
