# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-x390 -instruction-tables=full -iterations=1 < %s | FileCheck %s

# The legal (SEW, LMUL) pairs for FP on sifive-x390 are:
# (e16, mf4) (e16, mf2) (e16, m1) (e16, m2) (e16, m4) (e16, m8)
# (e32, mf2) (e32, m1) (e32, m2) (e32, m4) (e32, m8)
# (e64, m1) (e64, m2) (e64, m4) (e64, m8)
# Widening instructions do not have e64

# Vector Single-Width FP
vsetvli zero, zero, e16, mf4, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, mf2, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m1, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m2, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m4, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m8, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, mf2, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m1, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m2, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m4, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m8, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e64, m1, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e64, m2, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e64, m4, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e64, m8, tu, mu
vfadd.vv v8, v16, v24
vfadd.vf v8, v16, f8
vfsub.vv v8, v16, v24
vfsub.vf v8, v16, f8
vfrsub.vf v8, v16, f8
vfmul.vv v8, v16, v24
vfmul.vf v8, v16, f8
vfdiv.vv v8, v16, v24
vfdiv.vf v8, v16, f8
vfrdiv.vf v8, v16, f8
vfmacc.vv v8, v16, v24
vfmacc.vf v8, f8, v24
vfnmacc.vv v8, v16, v24
vfnmacc.vf v8, f8, v24
vfmsac.vv v8, v16, v24
vfmsac.vf v8, f8, v24
vfnmsac.vv v8, v16, v24
vfnmsac.vf v8, f8, v24
vfmadd.vv v8, v16, v24
vfmadd.vf v8, f8, v24
vfnmadd.vv v8, v16, v24
vfnmadd.vf v8, f8, v24
vfmsub.vv v8, v16, v24
vfmsub.vf v8, f8, v24
vfnmsub.vv v8, v16, v24
vfnmsub.vf v8, f8, v24
vfsqrt.v v8, v24
vfrsqrt7.v v8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

# Vector Widening FP
# no e64
vsetvli zero, zero, e16, mf4, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, mf2, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m1, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m2, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m4, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vsetvli zero, zero, e16, m8, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vsetvli zero, zero, e32, mf2, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vsetvli zero, zero, e32, m1, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vsetvli zero, zero, e32, m2, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vsetvli zero, zero, e32, m4, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vsetvli zero, zero, e32, m8, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e16, m8, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, mf2, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m1, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m2, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m4, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

vsetvli zero, zero, e32, m8, tu, mu
vfwadd.vv v8, v16, v24
vfwadd.vf v8, v16, f8
vfwsub.vv v8, v16, v24
vfwsub.vf v8, v16, f8
vfwadd.wv  v8, v16, v24
vfwadd.wf  v8, v16, f8
vfwsub.wv  v8, v16, v24
vfwsub.wf  v8, v16, f8
vfwmul.vv    v8, v16, v24
vfwmul.vf    v8, v16, f8
vfwmacc.vv v8, v16, v24
vfwmacc.vf v8, f8, v24
vfwnmacc.vv v8, v16, v24
vfwnmacc.vf v8, f8, v24
vfwmsac.vv v8, v16, v24
vfwmsac.vf v8, f8, v24
vfwnmsac.vv v8, v16, v24
vfwnmsac.vf v8, f8, v24
vfrec7.v v8, v24
vfmin.vv v8, v16, v24
vfmin.vf v8, v16, f8
vfmax.vv v8, v16, v24
vfmax.vf v8, v16, f8
vfsgnj.vv v8, v16, v24
vfsgnj.vf v8, v16, f8
vfsgnjn.vv v8, v16, v24
vfsgnjn.vf v8, v16, f8
vfsgnjx.vv v8, v16, v24
vfsgnjx.vf v8, v16, f8
vfcvt.xu.f.v v8, v16
vfcvt.x.f.v  v8, v16
vfcvt.rtz.xu.f.v v8, v16
vfcvt.rtz.x.f.v  v8, v16
vfcvt.f.xu.v v8, v16
vfcvt.f.x.v  v8, v16
vfwcvt.xu.f.v v8, v16
vfwcvt.x.f.v  v8, v16
vfwcvt.rtz.xu.f.v v8, v16
vfwcvt.rtz.x.f.v  v8, v16
vfwcvt.f.xu.v v8, v16
vfwcvt.f.x.v  v8, v16
vfwcvt.f.f.v v8, v16
vfncvt.xu.f.w v8, v16
vfncvt.x.f.w  v8, v16
vfncvt.rtz.xu.f.w v8, v16
vfncvt.rtz.x.f.w  v8, v16
vfncvt.f.xu.w v8, v16
vfncvt.f.x.w  v8, v16
vfncvt.f.f.w v8, v16
vfncvt.rod.f.f.w v8, v16

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv:1
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv:1
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA:1
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeAB:2 VLEN1024X300SiFive7PipeA, VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7PipeB:1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA1:1
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VA1OrVA2:2 VLEN1024X300SiFive7VA1, VLEN1024X300SiFive7VA2
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VA2:1
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VCQ:1
# CHECK-NEXT: [9]   - VLEN1024X300SiFive7VL:1
# CHECK-NEXT: [10]  - VLEN1024X300SiFive7VS:1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      60    60.00                        60    VLEN1024X300SiFive7VA1[1,61],VLEN1024X300SiFive7VA1OrVA2[1,61],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      60    60.00                        60    VLEN1024X300SiFive7VA1[1,61],VLEN1024X300SiFive7VA1OrVA2[1,61],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      60    60.00                        60    VLEN1024X300SiFive7VA1[1,61],VLEN1024X300SiFive7VA1OrVA2[1,61],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      60    60.00                        60    VLEN1024X300SiFive7VA1[1,61],VLEN1024X300SiFive7VA1OrVA2[1,61],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      120   120.00                       120   VLEN1024X300SiFive7VA1[1,121],VLEN1024X300SiFive7VA1OrVA2[1,121],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      120   120.00                       120   VLEN1024X300SiFive7VA1[1,121],VLEN1024X300SiFive7VA1OrVA2[1,121],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      120   120.00                       120   VLEN1024X300SiFive7VA1[1,121],VLEN1024X300SiFive7VA1OrVA2[1,121],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      120   120.00                       120   VLEN1024X300SiFive7VA1[1,121],VLEN1024X300SiFive7VA1OrVA2[1,121],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      240   240.00                       240   VLEN1024X300SiFive7VA1[1,241],VLEN1024X300SiFive7VA1OrVA2[1,241],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      240   240.00                       240   VLEN1024X300SiFive7VA1[1,241],VLEN1024X300SiFive7VA1OrVA2[1,241],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      240   240.00                       240   VLEN1024X300SiFive7VA1[1,241],VLEN1024X300SiFive7VA1OrVA2[1,241],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      240   240.00                       240   VLEN1024X300SiFive7VA1[1,241],VLEN1024X300SiFive7VA1OrVA2[1,241],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      480   480.00                       480   VLEN1024X300SiFive7VA1[1,481],VLEN1024X300SiFive7VA1OrVA2[1,481],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      480   480.00                       480   VLEN1024X300SiFive7VA1[1,481],VLEN1024X300SiFive7VA1OrVA2[1,481],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      480   480.00                       480   VLEN1024X300SiFive7VA1[1,481],VLEN1024X300SiFive7VA1OrVA2[1,481],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      480   480.00                       480   VLEN1024X300SiFive7VA1[1,481],VLEN1024X300SiFive7VA1OrVA2[1,481],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      960   960.00                       960   VLEN1024X300SiFive7VA1[1,961],VLEN1024X300SiFive7VA1OrVA2[1,961],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      960   960.00                       960   VLEN1024X300SiFive7VA1[1,961],VLEN1024X300SiFive7VA1OrVA2[1,961],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      960   960.00                       960   VLEN1024X300SiFive7VA1[1,961],VLEN1024X300SiFive7VA1OrVA2[1,961],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      960   960.00                       960   VLEN1024X300SiFive7VA1[1,961],VLEN1024X300SiFive7VA1OrVA2[1,961],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFADD_VV     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFADD_VF     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSUB_VV     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSUB_VF     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFRSUB_VF    vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMUL_VV     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMUL_VF     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      1920  1920.00                      1920  VLEN1024X300SiFive7VA1[1,1921],VLEN1024X300SiFive7VA1OrVA2[1,1921],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      1920  1920.00                      1920  VLEN1024X300SiFive7VA1[1,1921],VLEN1024X300SiFive7VA1OrVA2[1,1921],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      1920  1920.00                      1920  VLEN1024X300SiFive7VA1[1,1921],VLEN1024X300SiFive7VA1OrVA2[1,1921],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMACC_VV    vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMACC_VF    vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMACC_VV   vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMACC_VF   vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSAC_VV    vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSAC_VF    vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSAC_VV   vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSAC_VF   vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMADD_VV    vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMADD_VF    vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMADD_VV   vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMADD_VF   vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSUB_VV    vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSUB_VF    vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSUB_VV   vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSUB_VF   vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      1920  1920.00                      1920  VLEN1024X300SiFive7VA1[1,1921],VLEN1024X300SiFive7VA1OrVA2[1,1921],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VV    vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VF    vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VV   vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VF   vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VV   vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VF   vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      112   112.00                       112   VLEN1024X300SiFive7VA1[1,113],VLEN1024X300SiFive7VA1OrVA2[1,113],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      112   112.00                       112   VLEN1024X300SiFive7VA1[1,113],VLEN1024X300SiFive7VA1OrVA2[1,113],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      112   112.00                       112   VLEN1024X300SiFive7VA1[1,113],VLEN1024X300SiFive7VA1OrVA2[1,113],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      112   112.00                       112   VLEN1024X300SiFive7VA1[1,113],VLEN1024X300SiFive7VA1OrVA2[1,113],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      224   224.00                       224   VLEN1024X300SiFive7VA1[1,225],VLEN1024X300SiFive7VA1OrVA2[1,225],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      224   224.00                       224   VLEN1024X300SiFive7VA1[1,225],VLEN1024X300SiFive7VA1OrVA2[1,225],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      224   224.00                       224   VLEN1024X300SiFive7VA1[1,225],VLEN1024X300SiFive7VA1OrVA2[1,225],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      224   224.00                       224   VLEN1024X300SiFive7VA1[1,225],VLEN1024X300SiFive7VA1OrVA2[1,225],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      448   448.00                       448   VLEN1024X300SiFive7VA1[1,449],VLEN1024X300SiFive7VA1OrVA2[1,449],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      448   448.00                       448   VLEN1024X300SiFive7VA1[1,449],VLEN1024X300SiFive7VA1OrVA2[1,449],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      448   448.00                       448   VLEN1024X300SiFive7VA1[1,449],VLEN1024X300SiFive7VA1OrVA2[1,449],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      448   448.00                       448   VLEN1024X300SiFive7VA1[1,449],VLEN1024X300SiFive7VA1OrVA2[1,449],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFADD_VV      vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFADD_VF      vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSUB_VV      vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSUB_VF      vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFRSUB_VF     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMUL_VV      vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMUL_VF      vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      896   896.00                       896   VLEN1024X300SiFive7VA1[1,897],VLEN1024X300SiFive7VA1OrVA2[1,897],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      896   896.00                       896   VLEN1024X300SiFive7VA1[1,897],VLEN1024X300SiFive7VA1OrVA2[1,897],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      896   896.00                       896   VLEN1024X300SiFive7VA1[1,897],VLEN1024X300SiFive7VA1OrVA2[1,897],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      896   896.00                       896   VLEN1024X300SiFive7VA1[1,897],VLEN1024X300SiFive7VA1OrVA2[1,897],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFADD_VV     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFADD_VF     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSUB_VV     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSUB_VF     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFRSUB_VF    vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMUL_VV     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMUL_VF     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      1792  1792.00                      1792  VLEN1024X300SiFive7VA1[1,1793],VLEN1024X300SiFive7VA1OrVA2[1,1793],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      1792  1792.00                      1792  VLEN1024X300SiFive7VA1[1,1793],VLEN1024X300SiFive7VA1OrVA2[1,1793],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      1792  1792.00                      1792  VLEN1024X300SiFive7VA1[1,1793],VLEN1024X300SiFive7VA1OrVA2[1,1793],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMACC_VV    vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMACC_VF    vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMACC_VV   vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMACC_VF   vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSAC_VV    vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSAC_VF    vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSAC_VV   vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSAC_VF   vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMADD_VV    vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMADD_VF    vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMADD_VV   vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMADD_VF   vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSUB_VV    vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSUB_VF    vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSUB_VV   vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSUB_VF   vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      1792  1792.00                      1792  VLEN1024X300SiFive7VA1[1,1793],VLEN1024X300SiFive7VA1OrVA2[1,1793],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VV    vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VF    vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VV   vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VF   vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VV   vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VF   vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFADD_VV vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFADD_VF vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSUB_VV vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSUB_VF vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFRSUB_VF vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMUL_VV vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMUL_VF vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      228   228.00                       228   VLEN1024X300SiFive7VA1[1,229],VLEN1024X300SiFive7VA1OrVA2[1,229],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      228   228.00                       228   VLEN1024X300SiFive7VA1[1,229],VLEN1024X300SiFive7VA1OrVA2[1,229],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      228   228.00                       228   VLEN1024X300SiFive7VA1[1,229],VLEN1024X300SiFive7VA1OrVA2[1,229],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      228   228.00                       228   VLEN1024X300SiFive7VA1[1,229],VLEN1024X300SiFive7VA1OrVA2[1,229],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VV vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VF vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VV vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VF vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VV vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VF vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      16    16.00                        16    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFADD_VV vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFADD_VF vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSUB_VV vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSUB_VF vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFRSUB_VF vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFMUL_VV vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFMUL_VF vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      456   456.00                       456   VLEN1024X300SiFive7VA1[1,457],VLEN1024X300SiFive7VA1OrVA2[1,457],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      456   456.00                       456   VLEN1024X300SiFive7VA1[1,457],VLEN1024X300SiFive7VA1OrVA2[1,457],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      456   456.00                       456   VLEN1024X300SiFive7VA1[1,457],VLEN1024X300SiFive7VA1OrVA2[1,457],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      456   456.00                       456   VLEN1024X300SiFive7VA1[1,457],VLEN1024X300SiFive7VA1OrVA2[1,457],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSGNJ_VV vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSGNJ_VF vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSGNJN_VV vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSGNJN_VF vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSGNJX_VV vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFSGNJX_VF vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      32    32.00                        32    VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFADD_VV vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFADD_VF vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSUB_VV vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSUB_VF vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFRSUB_VF vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFMUL_VV vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFMUL_VF vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      912   912.00                       912   VLEN1024X300SiFive7VA1[1,913],VLEN1024X300SiFive7VA1OrVA2[1,913],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      912   912.00                       912   VLEN1024X300SiFive7VA1[1,913],VLEN1024X300SiFive7VA1OrVA2[1,913],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      912   912.00                       912   VLEN1024X300SiFive7VA1[1,913],VLEN1024X300SiFive7VA1OrVA2[1,913],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMACC_VV     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMACC_VF     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMACC_VV    vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMACC_VF    vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSAC_VV     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSAC_VF     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSAC_VV    vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSAC_VF    vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMADD_VV     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMADD_VF     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMADD_VV    vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMADD_VF    vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSUB_VV     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMSUB_VF     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSUB_VV    vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNMSUB_VF    vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      912   912.00                       912   VLEN1024X300SiFive7VA1[1,913],VLEN1024X300SiFive7VA1OrVA2[1,913],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSGNJ_VV vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSGNJ_VF vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSGNJN_VV vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSGNJN_VF vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSGNJX_VV vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFSGNJX_VF vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      64    64.00                        64    VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFADD_VV vfadd.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFADD_VF vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSUB_VV vfsub.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSUB_VF vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFRSUB_VF vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFMUL_VV vfmul.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFMUL_VF vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      1824  1824.00                      1824  VLEN1024X300SiFive7VA1[1,1825],VLEN1024X300SiFive7VA1OrVA2[1,1825],VLEN1024X300SiFive7VCQ VFDIV_VV vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  1      1824  1824.00                      1824  VLEN1024X300SiFive7VA1[1,1825],VLEN1024X300SiFive7VA1OrVA2[1,1825],VLEN1024X300SiFive7VCQ VFDIV_VF vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      1824  1824.00                      1824  VLEN1024X300SiFive7VA1[1,1825],VLEN1024X300SiFive7VA1OrVA2[1,1825],VLEN1024X300SiFive7VCQ VFRDIV_VF vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMACC_VV    vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMACC_VF    vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMACC_VV   vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMACC_VF   vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSAC_VV    vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSAC_VF    vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSAC_VV   vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSAC_VF   vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMADD_VV    vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMADD_VF    vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMADD_VV   vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMADD_VF   vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSUB_VV    vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMSUB_VF    vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSUB_VV   vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNMSUB_VF   vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  1      1824  1824.00                      1824  VLEN1024X300SiFive7VA1[1,1825],VLEN1024X300SiFive7VA1OrVA2[1,1825],VLEN1024X300SiFive7VCQ VFSQRT_V vfsqrt.v	v8, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFRSQRT7_V vfrsqrt7.v	v8, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSGNJ_VV vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSGNJ_VF vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSGNJN_VV vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSGNJN_VF vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSGNJX_VV vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFSGNJX_VF vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      128   128.00                       128   VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VV    vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VF    vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VV   vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VF   vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VV   vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VF   vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VV    vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VF    vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VV   vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VF   vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VV   vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VF   vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     32.00                        8     VLEN1024X300SiFive7VA1[1,33],VLEN1024X300SiFive7VA1OrVA2[1,33],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     64.00                        8     VLEN1024X300SiFive7VA1[1,65],VLEN1024X300SiFive7VA1OrVA2[1,65],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJ_VV     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJ_VF     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJN_VV    vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJN_VF    vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJX_VV    vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFSGNJX_VF    vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     128.00                       8     VLEN1024X300SiFive7VA1[1,129],VLEN1024X300SiFive7VA1OrVA2[1,129],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VV     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_VF     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VV     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_VF     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WV     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWADD_WF     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WV     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWSUB_WF     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VV     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMUL_VF     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VV    vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMACC_VF    vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VV   vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMACC_VF   vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VV    vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWMSAC_VF    vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VV   vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWNMSAC_VF   vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFREC7_V vfrec7.v	v8, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VV vfmin.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMIN_VF vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VV vfmax.vv	v8, v16, v24
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFMAX_VF vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VV    vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJ_VF    vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VV   vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJN_VF   vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VV   vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFSGNJX_VF   vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_XU_F_V vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_X_F_V vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_XU_F_V vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_RTZ_X_F_V vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_XU_V vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFCVT_F_X_V vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_XU_F_V vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_X_F_V vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_XU_F_V vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_RTZ_X_F_V vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_XU_V vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_X_V vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VFWCVT_F_F_V vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_XU_F_W vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_X_F_W vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_XU_F_W vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_RTZ_X_F_W vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_XU_W vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_X_W vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_F_F_W vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  1      8     16.00                        8     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VFNCVT_ROD_F_F_W vfncvt.rod.f.f.w	v8, v16

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7VA1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA2
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VCQ
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VL
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT:  -      -     32.00   -     58006.00 2446.00 1558.00  -   -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     61.00   -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     61.00   -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     61.00   -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     61.00   -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     121.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     121.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     121.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     121.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     241.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     241.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     241.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     241.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     481.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     481.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     481.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     481.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     961.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     961.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     961.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     961.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1921.00  -    1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1921.00  -    1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1921.00  -    1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1921.00  -    1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     113.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     113.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     113.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     113.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     225.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     225.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     225.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     225.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     449.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     449.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     449.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     449.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     897.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     897.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     897.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     897.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1793.00  -    1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1793.00  -    1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1793.00  -    1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1793.00  -    1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     229.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     229.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     229.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     229.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     457.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     457.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     457.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     457.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     913.00  -     1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     913.00  -     1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     913.00  -     1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     913.00  -     1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfrsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1825.00  -    1.00    -      -     vfdiv.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1825.00  -    1.00    -      -     vfdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1825.00  -    1.00    -      -     vfrdiv.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmadd.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfnmsub.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1825.00  -    1.00    -      -     vfsqrt.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrsqrt7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     33.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     65.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     129.00  -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwadd.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwsub.wf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmul.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmacc.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vfwnmsac.vf	v8, fs0, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfrec7.v	v8, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmin.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfmax.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnj.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjn.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vfsgnjx.vf	v8, v16, fs0
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.xu.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.rtz.x.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.xu.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.x.v	v8, v16
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vfwcvt.f.f.v	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.xu.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rtz.x.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.xu.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.x.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.f.f.w	v8, v16
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vfncvt.rod.f.f.w	v8, v16
