; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=verify -S < %s 2>&1 | FileCheck %s

target datalayout = "e-ni:4:6"

define i64 @f_0(ptr addrspace(4) %ptr) {
; CHECK-LABEL: @f_0(
; CHECK-NEXT:    [[VAL:%.*]] = ptrtoint ptr addrspace(4) [[PTR:%.*]] to i64
; CHECK-NEXT:    ret i64 [[VAL]]
;
  %val = ptrtoint i8 addrspace(4)* %ptr to i64
  ret i64 %val
}

define <4 x i64> @f_1(<4 x ptr addrspace(4)> %ptr) {
; CHECK-LABEL: @f_1(
; CHECK-NEXT:    [[VAL:%.*]] = ptrtoint <4 x ptr addrspace(4)> [[PTR:%.*]] to <4 x i64>
; CHECK-NEXT:    ret <4 x i64> [[VAL]]
;
  %val = ptrtoint <4 x i8 addrspace(4)*> %ptr to <4 x i64>
  ret <4 x i64> %val
}

define i64 @f_2(ptr addrspace(3) %ptr) {
; CHECK-LABEL: @f_2(
; CHECK-NEXT:    [[VAL:%.*]] = ptrtoint ptr addrspace(3) [[PTR:%.*]] to i64
; CHECK-NEXT:    ret i64 [[VAL]]
;
  %val = ptrtoint i8 addrspace(3)* %ptr to i64
  ret i64 %val
}

define ptr addrspace(4) @f_3(i64 %integer) {
; CHECK-LABEL: @f_3(
; CHECK-NEXT:    [[VAL:%.*]] = inttoptr i64 [[INTEGER:%.*]] to ptr addrspace(4)
; CHECK-NEXT:    ret ptr addrspace(4) [[VAL]]
;
  %val = inttoptr i64 %integer to i8 addrspace(4)*
  ret ptr addrspace(4) %val
}

define <4 x ptr addrspace(4)> @f_4(<4 x i64> %integer) {
; CHECK-LABEL: @f_4(
; CHECK-NEXT:    [[VAL:%.*]] = inttoptr <4 x i64> [[INTEGER:%.*]] to <4 x ptr addrspace(4)>
; CHECK-NEXT:    ret <4 x ptr addrspace(4)> [[VAL]]
;
  %val = inttoptr <4 x i64> %integer to <4 x i8 addrspace(4)*>
  ret <4 x ptr addrspace(4)> %val
}

define ptr addrspace(3) @f_5(i64 %integer) {
; CHECK-LABEL: @f_5(
; CHECK-NEXT:    [[VAL:%.*]] = inttoptr i64 [[INTEGER:%.*]] to ptr addrspace(3)
; CHECK-NEXT:    ret ptr addrspace(3) [[VAL]]
;
  %val = inttoptr i64 %integer to i8 addrspace(3)*
  ret ptr addrspace(3) %val
}

define i64 @f_6(ptr addrspace(6) %ptr) {
; CHECK-LABEL: @f_6(
; CHECK-NEXT:    [[VAL:%.*]] = ptrtoint ptr addrspace(6) [[PTR:%.*]] to i64
; CHECK-NEXT:    ret i64 [[VAL]]
;
  %val = ptrtoint i8 addrspace(6)* %ptr to i64
  ret i64 %val
}

define ptr addrspace(4) @f_7() {
; CHECK-LABEL: @f_7(
; CHECK-NEXT:    ret ptr addrspace(4) inttoptr (i64 50 to ptr addrspace(4))
;
  ret i8 addrspace(4)* inttoptr (i64 50 to i8 addrspace(4)*)
}

@global0 = addrspace(4) constant i8 42

define i64 @f_8() {
; CHECK-LABEL: @f_8(
; CHECK-NEXT:    ret i64 ptrtoint (ptr addrspace(4) @global0 to i64)
;
  ret i64 ptrtoint (i8 addrspace(4)* @global0 to i64)
}

define ptr addrspace(4) @f_9() {
; CHECK-LABEL: @f_9(
; CHECK-NEXT:    ret ptr addrspace(4) getelementptr (i8, ptr addrspace(4) inttoptr (i64 55 to ptr addrspace(4)), i32 100)
;
  ret i8 addrspace(4)* getelementptr (i8, i8 addrspace(4)* inttoptr (i64 55 to i8 addrspace(4)*), i32 100)
}

@global1 = addrspace(4) constant i8 42

define ptr addrspace(4) @f_10() {
; CHECK-LABEL: @f_10(
; CHECK-NEXT:    ret ptr addrspace(4) getelementptr (i8, ptr addrspace(4) @global0, i64 ptrtoint (ptr addrspace(4) @global1 to i64))
;
  ret i8 addrspace(4)* getelementptr (i8, i8 addrspace(4)* @global0, i64 ptrtoint (i8 addrspace(4)* @global1 to i64))
}

@cycle_0 = addrspace(4) constant i64 ptrtoint (ptr addrspace(4) @cycle_1 to i64)
@cycle_1 = addrspace(4) constant ptr addrspace(4) @cycle_0

define ptr addrspace(4) @f_11() {
; CHECK-LABEL: @f_11(
; CHECK-NEXT:    ret ptr addrspace(4) @cycle_1
;
  ret i64 addrspace(4)* addrspace(4)* @cycle_1
}

@cycle_self = addrspace(4) constant i64 ptrtoint (ptr addrspace(4) @cycle_self to i64)

define ptr addrspace(4) @f_12() {
; CHECK-LABEL: @f_12(
; CHECK-NEXT:    ret ptr addrspace(4) @cycle_self
;
  ret i64 addrspace(4)* @cycle_self
}
