; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=pre-isel-intrinsic-lowering -S < %s | FileCheck %s
target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "aarch64"

define <vscale x 4 x float> @scalable_vec_exp(<vscale x 4 x float> %input) {
; CHECK-LABEL: define <vscale x 4 x float> @scalable_vec_exp(
; CHECK-SAME: <vscale x 4 x float> [[INPUT:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i64 @llvm.vscale.i64()
; CHECK-NEXT:    [[TMP2:%.*]] = mul nuw i64 [[TMP1]], 4
; CHECK-NEXT:    br label %[[BB3:.*]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    [[TMP4:%.*]] = phi i64 [ 0, [[TMP0:%.*]] ], [ [[TMP9:%.*]], %[[BB3]] ]
; CHECK-NEXT:    [[TMP5:%.*]] = phi <vscale x 4 x float> [ [[INPUT]], [[TMP0]] ], [ [[TMP8:%.*]], %[[BB3]] ]
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <vscale x 4 x float> [[TMP5]], i64 [[TMP4]]
; CHECK-NEXT:    [[TMP7:%.*]] = call float @llvm.exp.f32(float [[TMP6]])
; CHECK-NEXT:    [[TMP8]] = insertelement <vscale x 4 x float> [[TMP5]], float [[TMP7]], i64 [[TMP4]]
; CHECK-NEXT:    [[TMP9]] = add i64 [[TMP4]], 1
; CHECK-NEXT:    [[TMP10:%.*]] = icmp eq i64 [[TMP9]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP10]], label %[[BB11:.*]], label %[[BB3]]
; CHECK:       [[BB11]]:
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP8]]
;
  %output = call <vscale x 4 x float> @llvm.exp.nxv4f32(<vscale x 4 x float> %input)
  ret <vscale x 4 x float> %output
}

define <4 x float> @fixed_vec_exp(<4 x float> %input) {
; CHECK-LABEL: define <4 x float> @fixed_vec_exp(
; CHECK-SAME: <4 x float> [[INPUT:%.*]]) {
; CHECK-NEXT:    [[OUTPUT:%.*]] = call <4 x float> @llvm.exp.v4f32(<4 x float> [[INPUT]])
; CHECK-NEXT:    ret <4 x float> [[OUTPUT]]
;
  %output = call <4 x float> @llvm.exp.v4f32(<4 x float> %input)
  ret <4 x float> %output
}

declare <4 x float> @llvm.exp.v4f32(<4 x float>) #0
declare <vscale x 4 x float> @llvm.exp.nxv4f32(<vscale x 4 x float>) #0

; CHECK: attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
; CHECK-NEXT: attributes #1 = { nocallback nofree nosync nounwind willreturn memory(none) }
attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
