; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

declare ptr @g()
declare ptr @use(ptr)

define void @call1() {
; CHECK-LABEL: define void @call1() {
; CHECK-NEXT:    [[A:%.*]] = call ptr @g()
; CHECK-NEXT:    [[B:%.*]] = getelementptr i8, ptr [[A]], i64 4
; CHECK-NEXT:    call void @use(ptr [[B]])
; CHECK-NEXT:    ret void
;
  %a = call ptr @g()
  %b = getelementptr i8, ptr %a, i64 4
  call void @use(ptr %b)
  ret void
}
define void @call2() {
; CHECK-LABEL: define void @call2() {
; CHECK-NEXT:    [[A:%.*]] = call dereferenceable(8) ptr @g()
; CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds nuw i8, ptr [[A]], i64 4
; CHECK-NEXT:    call void @use(ptr nonnull [[B]])
; CHECK-NEXT:    ret void
;
  %a = call dereferenceable(8) ptr @g()
  %b = getelementptr i8, ptr %a, i64 4
  call void @use(ptr %b)
  ret void
}

define void @call3() {
; CHECK-LABEL: define void @call3() {
; CHECK-NEXT:    [[A:%.*]] = call dereferenceable_or_null(8) ptr @g()
; CHECK-NEXT:    [[B:%.*]] = getelementptr i8, ptr [[A]], i64 4
; CHECK-NEXT:    call void @use(ptr [[B]])
; CHECK-NEXT:    ret void
;
  %a = call dereferenceable_or_null(8) ptr @g()
  %b = getelementptr i8, ptr %a, i64 4
  call void @use(ptr %b)
  ret void
}

define void @alloca() {
; CHECK-LABEL: define void @alloca() {
; CHECK-NEXT:    [[A:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds nuw i8, ptr [[A]], i64 4
; CHECK-NEXT:    call void @use(ptr nonnull [[B]])
; CHECK-NEXT:    ret void
;
  %a = alloca i64
  %b = getelementptr i8, ptr %a, i64 4
  call void @use(ptr %b)
  ret void
}

define void @arg1(ptr %a) {
; CHECK-LABEL: define void @arg1
; CHECK-SAME: (ptr [[A:%.*]]) {
; CHECK-NEXT:    [[B:%.*]] = getelementptr i8, ptr [[A]], i64 4
; CHECK-NEXT:    call void @use(ptr [[B]])
; CHECK-NEXT:    ret void
;
  %b = getelementptr i8, ptr %a, i64 4
  call void @use(ptr %b)
  ret void
}

define void @arg2(ptr dereferenceable(8) %a) {
; CHECK-LABEL: define void @arg2
; CHECK-SAME: (ptr dereferenceable(8) [[A:%.*]]) {
; CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds nuw i8, ptr [[A]], i64 4
; CHECK-NEXT:    call void @use(ptr nonnull [[B]])
; CHECK-NEXT:    ret void
;
  %b = getelementptr i8, ptr %a, i64 4
  call void @use(ptr %b)
  ret void
}

define void @arg3(ptr dereferenceable_or_null(8) %a) {
; CHECK-LABEL: define void @arg3
; CHECK-SAME: (ptr dereferenceable_or_null(8) [[A:%.*]]) {
; CHECK-NEXT:    [[B:%.*]] = getelementptr i8, ptr [[A]], i64 4
; CHECK-NEXT:    call void @use(ptr [[B]])
; CHECK-NEXT:    ret void
;
  %b = getelementptr i8, ptr %a, i64 4
  call void @use(ptr %b)
  ret void
}
