; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i4 @llvm.abs.i4(i4, i1)

define i1 @icmp_sge_abs(i4 %arg) {
; CHECK-LABEL: @icmp_sge_abs(
; CHECK-NEXT:    ret i1 true
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp sge i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_sge_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_sge_abs_false(
; CHECK-NEXT:    ret i1 true
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp sge i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_eq_abs(i4 %arg) {
; CHECK-LABEL: @icmp_eq_abs(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i4 [[ARG:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp eq i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_eq_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_eq_abs_false(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i4 [[ARG:%.*]], -7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp eq i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ne_abs(i4 %arg) {
; CHECK-LABEL: @icmp_ne_abs(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i4 [[ARG:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp ne i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ne_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_ne_abs_false(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i4 [[ARG:%.*]], -8
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp ne i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_sle_abs(i4 %arg) {
; CHECK-LABEL: @icmp_sle_abs(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i4 [[ARG:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp sle i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_sle_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_sle_abs_false(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i4 [[ARG:%.*]], -7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp sle i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_slt_abs(i4 %arg) {
; CHECK-LABEL: @icmp_slt_abs(
; CHECK-NEXT:    ret i1 false
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp slt i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_slt_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_slt_abs_false(
; CHECK-NEXT:    ret i1 false
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp slt i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_sgt_abs(i4 %arg) {
; CHECK-LABEL: @icmp_sgt_abs(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i4 [[ARG:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp sgt i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_sgt_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_sgt_abs_false(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i4 [[ARG:%.*]], -8
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp sgt i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ugt_abs(i4 %arg) {
; CHECK-LABEL: @icmp_ugt_abs(
; CHECK-NEXT:    ret i1 false
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp ugt i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ugt_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_ugt_abs_false(
; CHECK-NEXT:    ret i1 false
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp ugt i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_uge_abs(i4 %arg) {
; CHECK-LABEL: @icmp_uge_abs(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i4 [[ARG:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp uge i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_uge_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_uge_abs_false(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i4 [[ARG:%.*]], -7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp uge i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ule_abs(i4 %arg) {
; CHECK-LABEL: @icmp_ule_abs(
; CHECK-NEXT:    ret i1 true
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp ule i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ule_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_ule_abs_false(
; CHECK-NEXT:    ret i1 true
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp ule i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ult_abs(i4 %arg) {
; CHECK-LABEL: @icmp_ult_abs(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i4 [[ARG:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp ult i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_ult_abs_false(i4 %arg) {
; CHECK-LABEL: @icmp_ult_abs_false(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i4 [[ARG:%.*]], -8
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 false)
  %cmp = icmp ult i4 %abs, %arg
  ret i1 %cmp
}

define i1 @icmp_sge_abs2(i4 %arg) {
; CHECK-LABEL: @icmp_sge_abs2(
; CHECK-NEXT:    [[X:%.*]] = mul i4 [[ARG:%.*]], [[ARG]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i4 [[X]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %x = mul i4 %arg, %arg ; thwart complexity-based canonicalization
  %abs = call i4 @llvm.abs.i4(i4 %x, i1 true)
  %cmp = icmp sge i4 %x, %abs
  ret i1 %cmp
}

define i1 @icmp_sge_abs_mismatched_op(i4 %arg, i4 %arg2) {
; CHECK-LABEL: @icmp_sge_abs_mismatched_op(
; CHECK-NEXT:    [[ABS:%.*]] = call i4 @llvm.abs.i4(i4 [[ARG:%.*]], i1 true)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i4 [[ABS]], [[ARG2:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i4 @llvm.abs.i4(i4 %arg, i1 true)
  %cmp = icmp sge i4 %abs, %arg2
  ret i1 %cmp
  }
