; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=correlated-propagation -S | FileCheck %s

declare void @use(i8, i8)

define i8 @simple_phi(i1 %c, i8 %a, i8 %b) {
; CHECK-LABEL: define i8 @simple_phi
; CHECK-SAME: (i1 [[C:%.*]], i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i8 [[A]]
; CHECK:       else:
; CHECK-NEXT:    ret i8 [[B]]
;
entry:
  %s = select i1 %c, i8 %a, i8 %b
  br i1 %c, label %then, label %else

then:
  %phi1 = phi i8 [ %s, %entry ]
  ret i8 %phi1

else:
  %phi2 = phi i8 [ %s, %entry ]
  ret i8 %phi2
}

define i8 @phi_other_edge(i1 %c, i8 %a, i8 %b, i32 %sw) {
; CHECK-LABEL: define i8 @phi_other_edge
; CHECK-SAME: (i1 [[C:%.*]], i8 [[A:%.*]], i8 [[B:%.*]], i32 [[SW:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[SW]], label [[TEST:%.*]] [
; CHECK-NEXT:      i32 0, label [[THEN:%.*]]
; CHECK-NEXT:      i32 1, label [[ELSE:%.*]]
; CHECK-NEXT:    ]
; CHECK:       test:
; CHECK-NEXT:    br i1 [[C]], label [[THEN]], label [[ELSE]]
; CHECK:       then:
; CHECK-NEXT:    [[PHI1:%.*]] = phi i8 [ [[A]], [[TEST]] ], [ 1, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i8 [[PHI1]]
; CHECK:       else:
; CHECK-NEXT:    [[PHI2:%.*]] = phi i8 [ [[B]], [[TEST]] ], [ 2, [[ENTRY]] ]
; CHECK-NEXT:    ret i8 [[PHI2]]
;
entry:
  switch i32 %sw, label %test [
  i32 0, label %then
  i32 1, label %else
  ]

test:
  %s = select i1 %c, i8 %a, i8 %b
  br i1 %c, label %then, label %else

then:
  %phi1 = phi i8 [ %s, %test ], [ 1, %entry ]
  ret i8 %phi1

else:
  %phi2 = phi i8 [ %s, %test ], [ 2, %entry ]
  ret i8 %phi2
}

define void @phi_loop(i32) {
; CHECK-LABEL: define void @phi_loop
; CHECK-SAME: (i32 [[TMP0:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IDX:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[TMP2:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[IDX]], 0
; CHECK-NEXT:    [[TMP2]] = add i32 [[IDX]], -1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[TMP1]], i32 0, i32 [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP1]], label [[OUT:%.*]], label [[LOOP]]
; CHECK:       out:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %idx = phi i32 [ %0, %entry ], [ %sel, %loop ]
  %1 = icmp eq i32 %idx, 0
  %2 = add i32 %idx, -1
  %sel = select i1 %1, i32 0, i32 %2
  br i1 %1, label %out, label %loop

out:
  ret void
}

define i8 @simple_non_phi(i1 %c, i8 %a, i8 %b) {
; CHECK-LABEL: define i8 @simple_non_phi
; CHECK-SAME: (i1 [[C:%.*]], i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i8 [[A]]
; CHECK:       else:
; CHECK-NEXT:    ret i8 [[B]]
;
entry:
  %s = select i1 %c, i8 %a, i8 %b
  br i1 %c, label %then, label %else

then:
  ret i8 %s

else:
  ret i8 %s
}


define void @simple_multiple_uses(i1 %c, i8 %a, i8 %b) {
; CHECK-LABEL: define void @simple_multiple_uses
; CHECK-SAME: (i1 [[C:%.*]], i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S:%.*]] = select i1 [[C]], i8 [[A]], i8 [[B]]
; CHECK-NEXT:    call void @use(i8 [[S]], i8 [[S]])
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @use(i8 [[A]], i8 [[A]])
; CHECK-NEXT:    ret void
; CHECK:       else:
; CHECK-NEXT:    call void @use(i8 [[B]], i8 [[B]])
; CHECK-NEXT:    ret void
;
entry:
  %s = select i1 %c, i8 %a, i8 %b
  call void @use(i8 %s, i8 %s)
  br i1 %c, label %then, label %else

then:
  call void @use(i8 %s, i8 %s)
  ret void

else:
  call void @use(i8 %s, i8 %s)
  ret void
}

define i8 @not_correlated(i1, i1) {
; CHECK-LABEL: define range(i8 0, 2) i8 @not_correlated
; CHECK-SAME: (i1 [[TMP0:%.*]], i1 [[TMP1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S:%.*]] = select i1 [[TMP0]], i8 0, i8 1
; CHECK-NEXT:    br i1 [[TMP1]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i8 [[S]]
; CHECK:       else:
; CHECK-NEXT:    ret i8 [[S]]
;
entry:
  %s = select i1 %0, i8 0, i8 1
  br i1 %1, label %then, label %else

then:
  %a = phi i8 [ %s, %entry ]
  ret i8 %a

else:
  %b = phi i8 [ %s, %entry ]
  ret i8 %b
}

@c = global i32 0, align 4
@b = global i32 0, align 4

define i32 @PR23752() {
; CHECK-LABEL: define i32 @PR23752() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sgt ptr @b, @c
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP2]], i32 0, i32 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[SEL]], 1
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i32 1
;
entry:
  br label %for.body

for.body:
  %phi = phi i32 [ 0, %entry ], [ %sel, %for.body ]
  %cmp2 = icmp sgt ptr @b, @c
  %sel = select i1 %cmp2, i32 %phi, i32 1
  %cmp = icmp ne i32 %sel, 1
  br i1 %cmp, label %for.body, label %if.end


if.end:
  ret i32 %sel
}

define i1 @test1(ptr %p, i1 %unknown) {
; CHECK-LABEL: define i1 @test1
; CHECK-SAME: (ptr [[P:%.*]], i1 [[UNKNOWN:%.*]]) {
; CHECK-NEXT:    [[PVAL:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[PVAL]], 255
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[EXIT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[MIN:%.*]] = select i1 [[UNKNOWN]], i32 [[PVAL]], i32 5
; CHECK-NEXT:    ret i1 false
; CHECK:       exit:
; CHECK-NEXT:    ret i1 true
;
  %pval = load i32, ptr %p
  %cmp1 = icmp slt i32 %pval, 255
  br i1 %cmp1, label %next, label %exit

next:
  %min = select i1 %unknown, i32 %pval, i32 5
  %res = icmp eq i32 %min, 255
  ret i1 %res

exit:
  ret i1 true
}

; Check that we take a conservative meet
define i1 @test2(ptr %p, i32 %qval, i1 %unknown) {
; CHECK-LABEL: define i1 @test2
; CHECK-SAME: (ptr [[P:%.*]], i32 [[QVAL:%.*]], i1 [[UNKNOWN:%.*]]) {
; CHECK-NEXT:    [[PVAL:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[PVAL]], 255
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[EXIT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[MIN:%.*]] = select i1 [[UNKNOWN]], i32 [[PVAL]], i32 [[QVAL]]
; CHECK-NEXT:    [[RES:%.*]] = icmp eq i32 [[MIN]], 255
; CHECK-NEXT:    ret i1 [[RES]]
; CHECK:       exit:
; CHECK-NEXT:    ret i1 true
;
  %pval = load i32, ptr %p
  %cmp1 = icmp slt i32 %pval, 255
  br i1 %cmp1, label %next, label %exit

next:
  %min = select i1 %unknown, i32 %pval, i32 %qval
  %res = icmp eq i32 %min, 255
  ret i1 %res

exit:
  ret i1 true
}

; Same as @test2, but for the opposite select input
define i1 @test3(ptr %p, i32 %qval, i1 %unknown) {
; CHECK-LABEL: define i1 @test3
; CHECK-SAME: (ptr [[P:%.*]], i32 [[QVAL:%.*]], i1 [[UNKNOWN:%.*]]) {
; CHECK-NEXT:    [[PVAL:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[PVAL]], 255
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[EXIT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[MIN:%.*]] = select i1 [[UNKNOWN]], i32 [[QVAL]], i32 [[PVAL]]
; CHECK-NEXT:    [[RES:%.*]] = icmp eq i32 [[MIN]], 255
; CHECK-NEXT:    ret i1 [[RES]]
; CHECK:       exit:
; CHECK-NEXT:    ret i1 true
;
  %pval = load i32, ptr %p
  %cmp1 = icmp slt i32 %pval, 255
  br i1 %cmp1, label %next, label %exit

next:
  %min = select i1 %unknown, i32 %qval, i32 %pval
  %res = icmp eq i32 %min, 255
  ret i1 %res

exit:
  ret i1 true
}

; Conflicting constants (i.e. isOverdefined result)
; NOTE: Using doubles in this version is a bit of a hack.  This
; is to get around the fact that all integers (including constants
; and non-constants) are actually represented as constant-ranges.
define i1 @test4(ptr %p, i32 %qval, i1 %unknown) {
; CHECK-LABEL: define i1 @test4
; CHECK-SAME: (ptr [[P:%.*]], i32 [[QVAL:%.*]], i1 [[UNKNOWN:%.*]]) {
; CHECK-NEXT:    [[PVAL:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[PVAL]], 255
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[EXIT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[MIN:%.*]] = select i1 [[UNKNOWN]], double 1.000000e+00, double 0.000000e+00
; CHECK-NEXT:    [[RES:%.*]] = fcmp oeq double [[MIN]], 3.000000e+02
; CHECK-NEXT:    ret i1 [[RES]]
; CHECK:       exit:
; CHECK-NEXT:    ret i1 true
;
  %pval = load i32, ptr %p
  %cmp1 = icmp slt i32 %pval, 255
  br i1 %cmp1, label %next, label %exit

next:
  %min = select i1 %unknown, double 1.0, double 0.0
  %res = fcmp oeq double %min, 300.0
  ret i1 %res

exit:
  ret i1 true
}

;; Using the condition to clamp the result
;;

define i1 @test5(ptr %p, i1 %unknown) {
; CHECK-LABEL: define i1 @test5
; CHECK-SAME: (ptr [[P:%.*]], i1 [[UNKNOWN:%.*]]) {
; CHECK-NEXT:    [[PVAL:%.*]] = load i32, ptr [[P]], align 4, !noundef [[META0:![0-9]+]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[PVAL]], 255
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[EXIT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[PVAL]], 0
; CHECK-NEXT:    [[MIN:%.*]] = select i1 [[COND]], i32 [[PVAL]], i32 5
; CHECK-NEXT:    ret i1 false
; CHECK:       exit:
; CHECK-NEXT:    ret i1 true
;
  %pval = load i32, ptr %p, !noundef !0
  %cmp1 = icmp slt i32 %pval, 255
  br i1 %cmp1, label %next, label %exit

next:
  %cond = icmp sgt i32 %pval, 0
  %min = select i1 %cond, i32 %pval, i32 5
  %res = icmp eq i32 %min, -1
  ret i1 %res

exit:
  ret i1 true
}

define i1 @test6(ptr %p, i1 %unknown) {
; CHECK-LABEL: define i1 @test6
; CHECK-SAME: (ptr [[P:%.*]], i1 [[UNKNOWN:%.*]]) {
; CHECK-NEXT:    [[PVAL:%.*]] = load i32, ptr [[P]], align 4, !noundef [[META0]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i32 [[PVAL]], 255
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[EXIT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[COND:%.*]] = icmp ne i32 [[PVAL]], 254
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], i32 [[PVAL]], i32 1
; CHECK-NEXT:    ret i1 true
; CHECK:       exit:
; CHECK-NEXT:    ret i1 true
;
  %pval = load i32, ptr %p, !noundef !0
  %cmp1 = icmp ult i32 %pval, 255
  br i1 %cmp1, label %next, label %exit

next:
  %cond = icmp ne i32 %pval, 254
  %sel = select i1 %cond, i32 %pval, i32 1
  %res = icmp slt i32 %sel, 254
  ret i1 %res

exit:
  ret i1 true
}

define i64 @select_cond_may_undef(i32 %a) {
; CHECK-LABEL: define range(i64 -2147483648, 2147483648) i64 @select_cond_may_undef
; CHECK-SAME: (i32 [[A:%.*]]) {
; CHECK-NEXT:    [[IS_A_NONNEGATIVE:%.*]] = icmp sgt i32 [[A]], 1
; CHECK-NEXT:    [[NARROW:%.*]] = select i1 [[IS_A_NONNEGATIVE]], i32 [[A]], i32 0
; CHECK-NEXT:    [[MAX:%.*]] = sext i32 [[NARROW]] to i64
; CHECK-NEXT:    ret i64 [[MAX]]
;
  %is_a_nonnegative = icmp sgt i32 %a, 1
  %narrow = select i1 %is_a_nonnegative, i32 %a, i32 0
  %max = sext i32 %narrow to i64
  ret i64 %max
}

define i32 @test_solve_select_at_use(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: define i32 @test_solve_select_at_use
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], 0
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[A]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    ret i32 [[C]]
; CHECK:       if.else:
; CHECK-NEXT:    ret i32 [[B]]
;
entry:
  %cmp = icmp slt i32 %a, 0
  %retval = select i1 %cmp, i32 %b, i32 %c
  %cond = icmp sgt i32 %a, -1
  br i1 %cond, label %if.then, label %if.else
if.then:
  ret i32 %retval
if.else:
  ret i32 %retval
}

!0 = !{}
