// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: pabsb 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x1c,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
pabsb 485498096, %mm4

// CHECK: pabsb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1c,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pabsb 485498096, %xmm6

// CHECK: pabsb 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x1c,0x62,0x40]
pabsb 64(%rdx), %mm4

// CHECK: pabsb -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x1c,0x64,0x82,0xc0]
pabsb -64(%rdx,%rax,4), %mm4

// CHECK: pabsb 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x1c,0x64,0x82,0x40]
pabsb 64(%rdx,%rax,4), %mm4

// CHECK: pabsb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1c,0x74,0x82,0xc0]
pabsb -64(%rdx,%rax,4), %xmm6

// CHECK: pabsb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1c,0x74,0x82,0x40]
pabsb 64(%rdx,%rax,4), %xmm6

// CHECK: pabsb 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x1c,0x64,0x02,0x40]
pabsb 64(%rdx,%rax), %mm4

// CHECK: pabsb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1c,0x74,0x02,0x40]
pabsb 64(%rdx,%rax), %xmm6

// CHECK: pabsb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1c,0x72,0x40]
pabsb 64(%rdx), %xmm6

// CHECK: pabsb %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x1c,0xe4]
pabsb %mm4, %mm4

// CHECK: pabsb (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x1c,0x22]
pabsb (%rdx), %mm4

// CHECK: pabsb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1c,0x32]
pabsb (%rdx), %xmm6

// CHECK: pabsb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1c,0xf6]
pabsb %xmm6, %xmm6

// CHECK: pabsd 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x1e,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
pabsd 485498096, %mm4

// CHECK: pabsd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pabsd 485498096, %xmm6

// CHECK: pabsd 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x1e,0x62,0x40]
pabsd 64(%rdx), %mm4

// CHECK: pabsd -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x1e,0x64,0x82,0xc0]
pabsd -64(%rdx,%rax,4), %mm4

// CHECK: pabsd 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x1e,0x64,0x82,0x40]
pabsd 64(%rdx,%rax,4), %mm4

// CHECK: pabsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1e,0x74,0x82,0xc0]
pabsd -64(%rdx,%rax,4), %xmm6

// CHECK: pabsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1e,0x74,0x82,0x40]
pabsd 64(%rdx,%rax,4), %xmm6

// CHECK: pabsd 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x1e,0x64,0x02,0x40]
pabsd 64(%rdx,%rax), %mm4

// CHECK: pabsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1e,0x74,0x02,0x40]
pabsd 64(%rdx,%rax), %xmm6

// CHECK: pabsd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1e,0x72,0x40]
pabsd 64(%rdx), %xmm6

// CHECK: pabsd %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x1e,0xe4]
pabsd %mm4, %mm4

// CHECK: pabsd (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x1e,0x22]
pabsd (%rdx), %mm4

// CHECK: pabsd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1e,0x32]
pabsd (%rdx), %xmm6

// CHECK: pabsd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1e,0xf6]
pabsd %xmm6, %xmm6

// CHECK: pabsw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x1d,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
pabsw 485498096, %mm4

// CHECK: pabsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1d,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pabsw 485498096, %xmm6

// CHECK: pabsw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x1d,0x62,0x40]
pabsw 64(%rdx), %mm4

// CHECK: pabsw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x1d,0x64,0x82,0xc0]
pabsw -64(%rdx,%rax,4), %mm4

// CHECK: pabsw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x1d,0x64,0x82,0x40]
pabsw 64(%rdx,%rax,4), %mm4

// CHECK: pabsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1d,0x74,0x82,0xc0]
pabsw -64(%rdx,%rax,4), %xmm6

// CHECK: pabsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1d,0x74,0x82,0x40]
pabsw 64(%rdx,%rax,4), %xmm6

// CHECK: pabsw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x1d,0x64,0x02,0x40]
pabsw 64(%rdx,%rax), %mm4

// CHECK: pabsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1d,0x74,0x02,0x40]
pabsw 64(%rdx,%rax), %xmm6

// CHECK: pabsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1d,0x72,0x40]
pabsw 64(%rdx), %xmm6

// CHECK: pabsw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x1d,0xe4]
pabsw %mm4, %mm4

// CHECK: pabsw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x1d,0x22]
pabsw (%rdx), %mm4

// CHECK: pabsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1d,0x32]
pabsw (%rdx), %xmm6

// CHECK: pabsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x1d,0xf6]
pabsw %xmm6, %xmm6

// CHECK: palignr $0, 485498096, %mm4
// CHECK: encoding: [0x0f,0x3a,0x0f,0x24,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
palignr $0, 485498096, %mm4

// CHECK: palignr $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0f,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
palignr $0, 485498096, %xmm6

// CHECK: palignr $0, 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x3a,0x0f,0x62,0x40,0x00]
palignr $0, 64(%rdx), %mm4

// CHECK: palignr $0, -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x3a,0x0f,0x64,0x82,0xc0,0x00]
palignr $0, -64(%rdx,%rax,4), %mm4

// CHECK: palignr $0, 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x3a,0x0f,0x64,0x82,0x40,0x00]
palignr $0, 64(%rdx,%rax,4), %mm4

// CHECK: palignr $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0f,0x74,0x82,0xc0,0x00]
palignr $0, -64(%rdx,%rax,4), %xmm6

// CHECK: palignr $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0f,0x74,0x82,0x40,0x00]
palignr $0, 64(%rdx,%rax,4), %xmm6

// CHECK: palignr $0, 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x3a,0x0f,0x64,0x02,0x40,0x00]
palignr $0, 64(%rdx,%rax), %mm4

// CHECK: palignr $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0f,0x74,0x02,0x40,0x00]
palignr $0, 64(%rdx,%rax), %xmm6

// CHECK: palignr $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0f,0x72,0x40,0x00]
palignr $0, 64(%rdx), %xmm6

// CHECK: palignr $0, %mm4, %mm4
// CHECK: encoding: [0x0f,0x3a,0x0f,0xe4,0x00]
palignr $0, %mm4, %mm4

// CHECK: palignr $0, (%rdx), %mm4
// CHECK: encoding: [0x0f,0x3a,0x0f,0x22,0x00]
palignr $0, (%rdx), %mm4

// CHECK: palignr $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0f,0x32,0x00]
palignr $0, (%rdx), %xmm6

// CHECK: palignr $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0f,0xf6,0x00]
palignr $0, %xmm6, %xmm6

// CHECK: phaddd 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x02,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
phaddd 485498096, %mm4

// CHECK: phaddd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x02,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
phaddd 485498096, %xmm6

// CHECK: phaddd 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x02,0x62,0x40]
phaddd 64(%rdx), %mm4

// CHECK: phaddd -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x02,0x64,0x82,0xc0]
phaddd -64(%rdx,%rax,4), %mm4

// CHECK: phaddd 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x02,0x64,0x82,0x40]
phaddd 64(%rdx,%rax,4), %mm4

// CHECK: phaddd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x02,0x74,0x82,0xc0]
phaddd -64(%rdx,%rax,4), %xmm6

// CHECK: phaddd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x02,0x74,0x82,0x40]
phaddd 64(%rdx,%rax,4), %xmm6

// CHECK: phaddd 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x02,0x64,0x02,0x40]
phaddd 64(%rdx,%rax), %mm4

// CHECK: phaddd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x02,0x74,0x02,0x40]
phaddd 64(%rdx,%rax), %xmm6

// CHECK: phaddd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x02,0x72,0x40]
phaddd 64(%rdx), %xmm6

// CHECK: phaddd %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x02,0xe4]
phaddd %mm4, %mm4

// CHECK: phaddd (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x02,0x22]
phaddd (%rdx), %mm4

// CHECK: phaddd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x02,0x32]
phaddd (%rdx), %xmm6

// CHECK: phaddd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x02,0xf6]
phaddd %xmm6, %xmm6

// CHECK: phaddsw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x03,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
phaddsw 485498096, %mm4

// CHECK: phaddsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x03,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
phaddsw 485498096, %xmm6

// CHECK: phaddsw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x03,0x62,0x40]
phaddsw 64(%rdx), %mm4

// CHECK: phaddsw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x03,0x64,0x82,0xc0]
phaddsw -64(%rdx,%rax,4), %mm4

// CHECK: phaddsw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x03,0x64,0x82,0x40]
phaddsw 64(%rdx,%rax,4), %mm4

// CHECK: phaddsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x03,0x74,0x82,0xc0]
phaddsw -64(%rdx,%rax,4), %xmm6

// CHECK: phaddsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x03,0x74,0x82,0x40]
phaddsw 64(%rdx,%rax,4), %xmm6

// CHECK: phaddsw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x03,0x64,0x02,0x40]
phaddsw 64(%rdx,%rax), %mm4

// CHECK: phaddsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x03,0x74,0x02,0x40]
phaddsw 64(%rdx,%rax), %xmm6

// CHECK: phaddsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x03,0x72,0x40]
phaddsw 64(%rdx), %xmm6

// CHECK: phaddsw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x03,0xe4]
phaddsw %mm4, %mm4

// CHECK: phaddsw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x03,0x22]
phaddsw (%rdx), %mm4

// CHECK: phaddsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x03,0x32]
phaddsw (%rdx), %xmm6

// CHECK: phaddsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x03,0xf6]
phaddsw %xmm6, %xmm6

// CHECK: phaddw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x01,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
phaddw 485498096, %mm4

// CHECK: phaddw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x01,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
phaddw 485498096, %xmm6

// CHECK: phaddw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x01,0x62,0x40]
phaddw 64(%rdx), %mm4

// CHECK: phaddw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x01,0x64,0x82,0xc0]
phaddw -64(%rdx,%rax,4), %mm4

// CHECK: phaddw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x01,0x64,0x82,0x40]
phaddw 64(%rdx,%rax,4), %mm4

// CHECK: phaddw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x01,0x74,0x82,0xc0]
phaddw -64(%rdx,%rax,4), %xmm6

// CHECK: phaddw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x01,0x74,0x82,0x40]
phaddw 64(%rdx,%rax,4), %xmm6

// CHECK: phaddw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x01,0x64,0x02,0x40]
phaddw 64(%rdx,%rax), %mm4

// CHECK: phaddw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x01,0x74,0x02,0x40]
phaddw 64(%rdx,%rax), %xmm6

// CHECK: phaddw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x01,0x72,0x40]
phaddw 64(%rdx), %xmm6

// CHECK: phaddw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x01,0xe4]
phaddw %mm4, %mm4

// CHECK: phaddw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x01,0x22]
phaddw (%rdx), %mm4

// CHECK: phaddw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x01,0x32]
phaddw (%rdx), %xmm6

// CHECK: phaddw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x01,0xf6]
phaddw %xmm6, %xmm6

// CHECK: phsubd 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x06,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
phsubd 485498096, %mm4

// CHECK: phsubd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x06,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
phsubd 485498096, %xmm6

// CHECK: phsubd 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x06,0x62,0x40]
phsubd 64(%rdx), %mm4

// CHECK: phsubd -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x06,0x64,0x82,0xc0]
phsubd -64(%rdx,%rax,4), %mm4

// CHECK: phsubd 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x06,0x64,0x82,0x40]
phsubd 64(%rdx,%rax,4), %mm4

// CHECK: phsubd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x06,0x74,0x82,0xc0]
phsubd -64(%rdx,%rax,4), %xmm6

// CHECK: phsubd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x06,0x74,0x82,0x40]
phsubd 64(%rdx,%rax,4), %xmm6

// CHECK: phsubd 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x06,0x64,0x02,0x40]
phsubd 64(%rdx,%rax), %mm4

// CHECK: phsubd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x06,0x74,0x02,0x40]
phsubd 64(%rdx,%rax), %xmm6

// CHECK: phsubd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x06,0x72,0x40]
phsubd 64(%rdx), %xmm6

// CHECK: phsubd %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x06,0xe4]
phsubd %mm4, %mm4

// CHECK: phsubd (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x06,0x22]
phsubd (%rdx), %mm4

// CHECK: phsubd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x06,0x32]
phsubd (%rdx), %xmm6

// CHECK: phsubd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x06,0xf6]
phsubd %xmm6, %xmm6

// CHECK: phsubsw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x07,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
phsubsw 485498096, %mm4

// CHECK: phsubsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x07,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
phsubsw 485498096, %xmm6

// CHECK: phsubsw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x07,0x62,0x40]
phsubsw 64(%rdx), %mm4

// CHECK: phsubsw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x07,0x64,0x82,0xc0]
phsubsw -64(%rdx,%rax,4), %mm4

// CHECK: phsubsw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x07,0x64,0x82,0x40]
phsubsw 64(%rdx,%rax,4), %mm4

// CHECK: phsubsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x07,0x74,0x82,0xc0]
phsubsw -64(%rdx,%rax,4), %xmm6

// CHECK: phsubsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x07,0x74,0x82,0x40]
phsubsw 64(%rdx,%rax,4), %xmm6

// CHECK: phsubsw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x07,0x64,0x02,0x40]
phsubsw 64(%rdx,%rax), %mm4

// CHECK: phsubsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x07,0x74,0x02,0x40]
phsubsw 64(%rdx,%rax), %xmm6

// CHECK: phsubsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x07,0x72,0x40]
phsubsw 64(%rdx), %xmm6

// CHECK: phsubsw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x07,0xe4]
phsubsw %mm4, %mm4

// CHECK: phsubsw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x07,0x22]
phsubsw (%rdx), %mm4

// CHECK: phsubsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x07,0x32]
phsubsw (%rdx), %xmm6

// CHECK: phsubsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x07,0xf6]
phsubsw %xmm6, %xmm6

// CHECK: phsubw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x05,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
phsubw 485498096, %mm4

// CHECK: phsubw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x05,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
phsubw 485498096, %xmm6

// CHECK: phsubw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x05,0x62,0x40]
phsubw 64(%rdx), %mm4

// CHECK: phsubw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x05,0x64,0x82,0xc0]
phsubw -64(%rdx,%rax,4), %mm4

// CHECK: phsubw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x05,0x64,0x82,0x40]
phsubw 64(%rdx,%rax,4), %mm4

// CHECK: phsubw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x05,0x74,0x82,0xc0]
phsubw -64(%rdx,%rax,4), %xmm6

// CHECK: phsubw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x05,0x74,0x82,0x40]
phsubw 64(%rdx,%rax,4), %xmm6

// CHECK: phsubw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x05,0x64,0x02,0x40]
phsubw 64(%rdx,%rax), %mm4

// CHECK: phsubw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x05,0x74,0x02,0x40]
phsubw 64(%rdx,%rax), %xmm6

// CHECK: phsubw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x05,0x72,0x40]
phsubw 64(%rdx), %xmm6

// CHECK: phsubw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x05,0xe4]
phsubw %mm4, %mm4

// CHECK: phsubw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x05,0x22]
phsubw (%rdx), %mm4

// CHECK: phsubw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x05,0x32]
phsubw (%rdx), %xmm6

// CHECK: phsubw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x05,0xf6]
phsubw %xmm6, %xmm6

// CHECK: pmaddubsw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x04,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
pmaddubsw 485498096, %mm4

// CHECK: pmaddubsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x04,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaddubsw 485498096, %xmm6

// CHECK: pmaddubsw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x04,0x62,0x40]
pmaddubsw 64(%rdx), %mm4

// CHECK: pmaddubsw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x04,0x64,0x82,0xc0]
pmaddubsw -64(%rdx,%rax,4), %mm4

// CHECK: pmaddubsw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x04,0x64,0x82,0x40]
pmaddubsw 64(%rdx,%rax,4), %mm4

// CHECK: pmaddubsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x04,0x74,0x82,0xc0]
pmaddubsw -64(%rdx,%rax,4), %xmm6

// CHECK: pmaddubsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x04,0x74,0x82,0x40]
pmaddubsw 64(%rdx,%rax,4), %xmm6

// CHECK: pmaddubsw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x04,0x64,0x02,0x40]
pmaddubsw 64(%rdx,%rax), %mm4

// CHECK: pmaddubsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x04,0x74,0x02,0x40]
pmaddubsw 64(%rdx,%rax), %xmm6

// CHECK: pmaddubsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x04,0x72,0x40]
pmaddubsw 64(%rdx), %xmm6

// CHECK: pmaddubsw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x04,0xe4]
pmaddubsw %mm4, %mm4

// CHECK: pmaddubsw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x04,0x22]
pmaddubsw (%rdx), %mm4

// CHECK: pmaddubsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x04,0x32]
pmaddubsw (%rdx), %xmm6

// CHECK: pmaddubsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x04,0xf6]
pmaddubsw %xmm6, %xmm6

// CHECK: pmulhrsw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x0b,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
pmulhrsw 485498096, %mm4

// CHECK: pmulhrsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmulhrsw 485498096, %xmm6

// CHECK: pmulhrsw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x0b,0x62,0x40]
pmulhrsw 64(%rdx), %mm4

// CHECK: pmulhrsw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x0b,0x64,0x82,0xc0]
pmulhrsw -64(%rdx,%rax,4), %mm4

// CHECK: pmulhrsw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x0b,0x64,0x82,0x40]
pmulhrsw 64(%rdx,%rax,4), %mm4

// CHECK: pmulhrsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0b,0x74,0x82,0xc0]
pmulhrsw -64(%rdx,%rax,4), %xmm6

// CHECK: pmulhrsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0b,0x74,0x82,0x40]
pmulhrsw 64(%rdx,%rax,4), %xmm6

// CHECK: pmulhrsw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x0b,0x64,0x02,0x40]
pmulhrsw 64(%rdx,%rax), %mm4

// CHECK: pmulhrsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0b,0x74,0x02,0x40]
pmulhrsw 64(%rdx,%rax), %xmm6

// CHECK: pmulhrsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0b,0x72,0x40]
pmulhrsw 64(%rdx), %xmm6

// CHECK: pmulhrsw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x0b,0xe4]
pmulhrsw %mm4, %mm4

// CHECK: pmulhrsw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x0b,0x22]
pmulhrsw (%rdx), %mm4

// CHECK: pmulhrsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0b,0x32]
pmulhrsw (%rdx), %xmm6

// CHECK: pmulhrsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0b,0xf6]
pmulhrsw %xmm6, %xmm6

// CHECK: pshufb 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x00,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
pshufb 485498096, %mm4

// CHECK: pshufb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x00,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pshufb 485498096, %xmm6

// CHECK: pshufb 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x00,0x62,0x40]
pshufb 64(%rdx), %mm4

// CHECK: pshufb -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x00,0x64,0x82,0xc0]
pshufb -64(%rdx,%rax,4), %mm4

// CHECK: pshufb 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x00,0x64,0x82,0x40]
pshufb 64(%rdx,%rax,4), %mm4

// CHECK: pshufb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x00,0x74,0x82,0xc0]
pshufb -64(%rdx,%rax,4), %xmm6

// CHECK: pshufb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x00,0x74,0x82,0x40]
pshufb 64(%rdx,%rax,4), %xmm6

// CHECK: pshufb 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x00,0x64,0x02,0x40]
pshufb 64(%rdx,%rax), %mm4

// CHECK: pshufb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x00,0x74,0x02,0x40]
pshufb 64(%rdx,%rax), %xmm6

// CHECK: pshufb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x00,0x72,0x40]
pshufb 64(%rdx), %xmm6

// CHECK: pshufb %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x00,0xe4]
pshufb %mm4, %mm4

// CHECK: pshufb (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x00,0x22]
pshufb (%rdx), %mm4

// CHECK: pshufb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x00,0x32]
pshufb (%rdx), %xmm6

// CHECK: pshufb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x00,0xf6]
pshufb %xmm6, %xmm6

// CHECK: psignb 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x08,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
psignb 485498096, %mm4

// CHECK: psignb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x08,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psignb 485498096, %xmm6

// CHECK: psignb 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x08,0x62,0x40]
psignb 64(%rdx), %mm4

// CHECK: psignb -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x08,0x64,0x82,0xc0]
psignb -64(%rdx,%rax,4), %mm4

// CHECK: psignb 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x08,0x64,0x82,0x40]
psignb 64(%rdx,%rax,4), %mm4

// CHECK: psignb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x08,0x74,0x82,0xc0]
psignb -64(%rdx,%rax,4), %xmm6

// CHECK: psignb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x08,0x74,0x82,0x40]
psignb 64(%rdx,%rax,4), %xmm6

// CHECK: psignb 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x08,0x64,0x02,0x40]
psignb 64(%rdx,%rax), %mm4

// CHECK: psignb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x08,0x74,0x02,0x40]
psignb 64(%rdx,%rax), %xmm6

// CHECK: psignb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x08,0x72,0x40]
psignb 64(%rdx), %xmm6

// CHECK: psignb %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x08,0xe4]
psignb %mm4, %mm4

// CHECK: psignb (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x08,0x22]
psignb (%rdx), %mm4

// CHECK: psignb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x08,0x32]
psignb (%rdx), %xmm6

// CHECK: psignb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x08,0xf6]
psignb %xmm6, %xmm6

// CHECK: psignd 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x0a,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
psignd 485498096, %mm4

// CHECK: psignd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psignd 485498096, %xmm6

// CHECK: psignd 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x0a,0x62,0x40]
psignd 64(%rdx), %mm4

// CHECK: psignd -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x0a,0x64,0x82,0xc0]
psignd -64(%rdx,%rax,4), %mm4

// CHECK: psignd 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x0a,0x64,0x82,0x40]
psignd 64(%rdx,%rax,4), %mm4

// CHECK: psignd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0a,0x74,0x82,0xc0]
psignd -64(%rdx,%rax,4), %xmm6

// CHECK: psignd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0a,0x74,0x82,0x40]
psignd 64(%rdx,%rax,4), %xmm6

// CHECK: psignd 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x0a,0x64,0x02,0x40]
psignd 64(%rdx,%rax), %mm4

// CHECK: psignd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0a,0x74,0x02,0x40]
psignd 64(%rdx,%rax), %xmm6

// CHECK: psignd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0a,0x72,0x40]
psignd 64(%rdx), %xmm6

// CHECK: psignd %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x0a,0xe4]
psignd %mm4, %mm4

// CHECK: psignd (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x0a,0x22]
psignd (%rdx), %mm4

// CHECK: psignd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0a,0x32]
psignd (%rdx), %xmm6

// CHECK: psignd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x0a,0xf6]
psignd %xmm6, %xmm6

// CHECK: psignw 485498096, %mm4
// CHECK: encoding: [0x0f,0x38,0x09,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
psignw 485498096, %mm4

// CHECK: psignw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x09,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psignw 485498096, %xmm6

// CHECK: psignw 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x09,0x62,0x40]
psignw 64(%rdx), %mm4

// CHECK: psignw -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x09,0x64,0x82,0xc0]
psignw -64(%rdx,%rax,4), %mm4

// CHECK: psignw 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0x38,0x09,0x64,0x82,0x40]
psignw 64(%rdx,%rax,4), %mm4

// CHECK: psignw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x09,0x74,0x82,0xc0]
psignw -64(%rdx,%rax,4), %xmm6

// CHECK: psignw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x09,0x74,0x82,0x40]
psignw 64(%rdx,%rax,4), %xmm6

// CHECK: psignw 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0x38,0x09,0x64,0x02,0x40]
psignw 64(%rdx,%rax), %mm4

// CHECK: psignw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x09,0x74,0x02,0x40]
psignw 64(%rdx,%rax), %xmm6

// CHECK: psignw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x09,0x72,0x40]
psignw 64(%rdx), %xmm6

// CHECK: psignw %mm4, %mm4
// CHECK: encoding: [0x0f,0x38,0x09,0xe4]
psignw %mm4, %mm4

// CHECK: psignw (%rdx), %mm4
// CHECK: encoding: [0x0f,0x38,0x09,0x22]
psignw (%rdx), %mm4

// CHECK: psignw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x09,0x32]
psignw (%rdx), %xmm6

// CHECK: psignw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x09,0xf6]
psignw %xmm6, %xmm6

