; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -mattr=+sse | FileCheck %s --check-prefix=X86-SSE
; RUN: llc < %s -mtriple=i686-- -mattr=+avx | FileCheck %s --check-prefix=X86-SSE
; RUN: llc < %s -mtriple=i686-- -mattr=+sse,+prfchw | FileCheck %s -check-prefix=X86-PRFCHWSSE
; RUN: llc < %s -mtriple=i686-- -mattr=+prfchw | FileCheck %s -check-prefix=X86-PRFCHWSSE
; RUN: llc < %s -mtriple=i686-- -mcpu=slm | FileCheck %s -check-prefix=X86-PRFCHWSSE
; RUN: llc < %s -mtriple=i686-- -mcpu=btver2 | FileCheck %s -check-prefix=X86-PRFCHWSSE
; RUN: llc < %s -mtriple=i686-- -mcpu=btver2 -mattr=-prfchw | FileCheck %s -check-prefix=X86-SSE
; RUN: llc < %s -mtriple=i686-- -mattr=+prfchw | FileCheck %s -check-prefix=X86-PRFCHWSSE

; Rules:
; sse provides prefetch0/1/2/nta
; supporting prefetchw implicitly provides prefetcht0/1/2/nta as well, as we need something to fall back to for the non-write hint.

define void @t(ptr %ptr) nounwind  {
; X86-SSE-LABEL: t:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    prefetcht2 (%eax)
; X86-SSE-NEXT:    prefetcht1 (%eax)
; X86-SSE-NEXT:    prefetcht0 (%eax)
; X86-SSE-NEXT:    prefetchnta (%eax)
; X86-SSE-NEXT:    prefetcht2 (%eax)
; X86-SSE-NEXT:    prefetcht1 (%eax)
; X86-SSE-NEXT:    prefetcht0 (%eax)
; X86-SSE-NEXT:    prefetchnta (%eax)
; X86-SSE-NEXT:    retl
;
; X86-PRFCHWSSE-LABEL: t:
; X86-PRFCHWSSE:       # %bb.0: # %entry
; X86-PRFCHWSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-PRFCHWSSE-NEXT:    prefetcht2 (%eax)
; X86-PRFCHWSSE-NEXT:    prefetcht1 (%eax)
; X86-PRFCHWSSE-NEXT:    prefetcht0 (%eax)
; X86-PRFCHWSSE-NEXT:    prefetchnta (%eax)
; X86-PRFCHWSSE-NEXT:    prefetchw (%eax)
; X86-PRFCHWSSE-NEXT:    prefetchw (%eax)
; X86-PRFCHWSSE-NEXT:    prefetchw (%eax)
; X86-PRFCHWSSE-NEXT:    prefetchw (%eax)
; X86-PRFCHWSSE-NEXT:    retl

entry:
  tail call void @llvm.prefetch( ptr %ptr, i32 0, i32 1, i32 1 )
  tail call void @llvm.prefetch( ptr %ptr, i32 0, i32 2, i32 1 )
  tail call void @llvm.prefetch( ptr %ptr, i32 0, i32 3, i32 1 )
  tail call void @llvm.prefetch( ptr %ptr, i32 0, i32 0, i32 1 )
  tail call void @llvm.prefetch( ptr %ptr, i32 1, i32 1, i32 1 )
  tail call void @llvm.prefetch( ptr %ptr, i32 1, i32 2, i32 1 )
  tail call void @llvm.prefetch( ptr %ptr, i32 1, i32 3, i32 1 )
  tail call void @llvm.prefetch( ptr %ptr, i32 1, i32 0, i32 1 )
  ret void
}

declare void @llvm.prefetch(ptr, i32, i32, i32) nounwind
