; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
;; See also dollar-name-asm.ll for module asm tests, which update_llc_test_checks.py doesn't support.
; RUN: llc < %s -mtriple=i686 -relocation-model=static | FileCheck %s --check-prefix=STATIC
; RUN: llc < %s -mtriple=x86_64 -relocation-model=pic | FileCheck %s --check-prefix=PIC
; RUN: llc < %s -mtriple=x86_64 -relocation-model=pic -output-asm-variant=1 | FileCheck %s --check-prefix=INTEL-PIC

@"$arr" = global [2 x i32] zeroinitializer
@"$arr_h" = hidden global [2 x i32] zeroinitializer
@"$tls" = hidden thread_local global i32 0

define i32 @"$foo"() nounwind {
; STATIC-LABEL: $foo:
; STATIC:       # %bb.0:
; STATIC-NEXT:    movl ($arr), %eax
; STATIC-NEXT:    movl %gs:0, %ecx
; STATIC-NEXT:    addl ($arr+4), %eax
; STATIC-NEXT:    addl ($tls@NTPOFF)(%ecx), %eax
; STATIC-NEXT:    pushl ($arr_h)
; STATIC-NEXT:    pushl %eax
; STATIC-NEXT:    calll ($hen@PLT)
; STATIC-NEXT:    addl $8, %esp
; STATIC-NEXT:    retl
;
; PIC-LABEL: $foo:
; PIC:       # %bb.0:
; PIC-NEXT:    pushq %rbp
; PIC-NEXT:    pushq %r14
; PIC-NEXT:    pushq %rbx
; PIC-NEXT:    movq ($arr@GOTPCREL)(%rip), %r14
; PIC-NEXT:    movl (%r14), %ebx
; PIC-NEXT:    movl ($arr_h)(%rip), %ebp
; PIC-NEXT:    leaq ($tls@TLSLD)(%rip), %rdi
; PIC-NEXT:    callq __tls_get_addr@PLT
; PIC-NEXT:    addl 4(%r14), %ebx
; PIC-NEXT:    addl ($tls@DTPOFF)(%rax), %ebx
; PIC-NEXT:    movl %ebx, %edi
; PIC-NEXT:    movl %ebp, %esi
; PIC-NEXT:    callq ($hen@PLT)
; PIC-NEXT:    popq %rbx
; PIC-NEXT:    popq %r14
; PIC-NEXT:    popq %rbp
; PIC-NEXT:    retq
;
; INTEL-PIC-LABEL: $foo:
; INTEL-PIC:       # %bb.0:
; INTEL-PIC-NEXT:    push rbp
; INTEL-PIC-NEXT:    push r14
; INTEL-PIC-NEXT:    push rbx
; INTEL-PIC-NEXT:    mov r14, qword ptr [rip + $arr@GOTPCREL]
; INTEL-PIC-NEXT:    mov ebx, dword ptr [r14]
; INTEL-PIC-NEXT:    mov ebp, dword ptr [rip + $arr_h]
; INTEL-PIC-NEXT:    lea rdi, [rip + $tls@TLSLD]
; INTEL-PIC-NEXT:    call __tls_get_addr@PLT
; INTEL-PIC-NEXT:    add ebx, dword ptr [r14 + 4]
; INTEL-PIC-NEXT:    add ebx, dword ptr [rax + $tls@DTPOFF]
; INTEL-PIC-NEXT:    mov edi, ebx
; INTEL-PIC-NEXT:    mov esi, ebp
; INTEL-PIC-NEXT:    call $hen@PLT
; INTEL-PIC-NEXT:    pop rbx
; INTEL-PIC-NEXT:    pop r14
; INTEL-PIC-NEXT:    pop rbp
; INTEL-PIC-NEXT:    ret
  %m = load i32, ptr @"$arr"
  %m1 = load i32, ptr getelementptr inbounds nuw (i32, ptr @"$arr", i23 1)
  %m2 = load i32, ptr @"$arr_h"
  %tls_v = load i32, ptr @"$tls"
  %t0 = add i32 %m, %m1
  %t1 = add i32 %t0, %tls_v
  %u = call i32 @"$hen"(i32 %t1, i32 %m2)
  ret i32 %u
}

declare i32 @"$hen"(i32 %a, i32 %b)
