; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv32 -mattr=+zdinx -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 -mattr=+zhinx | FileCheck %s

;; These tests cover the use of `r`, `R`, and `cr` constraints for floating point values on rv32.
;;
;; In particular, there is significant complexity around using paired GPRs for double values on rv32.

define dso_local void @zdinx_asm(ptr nocapture noundef writeonly %a, double noundef %b, double noundef %c) nounwind {
; CHECK-LABEL: zdinx_asm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a5, a4
; CHECK-NEXT:    mv a7, a2
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    mv a6, a1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.d a2, a6, a4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a2, 8(a0)
; CHECK-NEXT:    sw a3, 12(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 1
  %0 = tail call double asm "fsgnjx.d $0, $1, $2", "=r,r,r"(double %b, double %c)
  store double %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zdinx_asm_R(ptr nocapture noundef writeonly %a, double noundef %b, double noundef %c) nounwind {
; CHECK-LABEL: zdinx_asm_R:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a5, a4
; CHECK-NEXT:    mv a7, a2
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    mv a6, a1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.d a2, a6, a4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a2, 8(a0)
; CHECK-NEXT:    sw a3, 12(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 1
  %0 = tail call double asm "fsgnjx.d $0, $1, $2", "=R,R,R"(double %b, double %c)
  store double %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zdinx_asm_inout(ptr nocapture noundef writeonly %a, double noundef %b) nounwind {
; CHECK-LABEL: zdinx_asm_inout:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a2
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fmv.d a2, a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a2, 8(a0)
; CHECK-NEXT:    sw a3, 12(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 1
  %0 = tail call double asm "fsgnj.d $0, $1, $1", "=r,0"(double %b)
  store double %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zdinx_asm_Pr_inout(ptr nocapture noundef writeonly %a, double noundef %b) nounwind {
; CHECK-LABEL: zdinx_asm_Pr_inout:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a2
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fabs.d a2, a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a2, 8(a0)
; CHECK-NEXT:    sw a3, 12(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 1
  %0 = tail call double asm "fsgnjx.d $0, $1, $1", "=R,0"(double %b)
  store double %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zdinx_asm_cR_inout(ptr nocapture noundef writeonly %a, double noundef %b) nounwind {
; CHECK-LABEL: zdinx_asm_cR_inout:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a2
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fabs.d a2, a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a2, 8(a0)
; CHECK-NEXT:    sw a3, 12(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 1
  %0 = tail call double asm "fsgnjx.d $0, $1, $1", "=^cR,0"(double %b)
  store double %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zfinx_asm(ptr nocapture noundef writeonly %a, float noundef %b, float noundef %c) nounwind {
; CHECK-LABEL: zfinx_asm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.s a1, a1, a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a1, 4(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds float, ptr %a, i32 1
  %0 = tail call float asm "fsgnjx.s $0, $1, $2", "=r,r,r"(float %b, float %c)
  store float %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zhinx_asm(ptr nocapture noundef writeonly %a, half noundef %b, half noundef %c) nounwind {
; CHECK-LABEL: zhinx_asm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.h a1, a1, a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sh a1, 2(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds half, ptr %a, i32 1
  %0 = tail call half asm "fsgnjx.h $0, $1, $2", "=r,r,r"(half %b, half %c)
  store half %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zdinx_asm_cr(ptr nocapture noundef writeonly %a, double noundef %b, double noundef %c) nounwind {
; CHECK-LABEL: zdinx_asm_cr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw s0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s1, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv a5, a4
; CHECK-NEXT:    mv s1, a2
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    mv s0, a1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.d a2, s0, a4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a2, 8(a0)
; CHECK-NEXT:    sw a3, 12(a0)
; CHECK-NEXT:    lw s0, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s1, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 1
  %0 = tail call double asm "fsgnjx.d $0, $1, $2", "=^cr,^cr,^cr"(double %b, double %c)
  store double %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zfinx_asm_cr(ptr nocapture noundef writeonly %a, float noundef %b, float noundef %c) nounwind {
; CHECK-LABEL: zfinx_asm_cr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.s a1, a1, a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a1, 4(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds float, ptr %a, i32 1
  %0 = tail call float asm "fsgnjx.s $0, $1, $2", "=^cr,^cr,^cr"(float %b, float %c)
  store float %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zhinx_asm_cr(ptr nocapture noundef writeonly %a, half noundef %b, half noundef %c) nounwind {
; CHECK-LABEL: zhinx_asm_cr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.h a1, a1, a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sh a1, 2(a0)
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds half, ptr %a, i32 1
  %0 = tail call half asm "fsgnjx.h $0, $1, $2", "=^cr,^cr,^cr"(half %b, half %c)
  store half %0, ptr %arrayidx, align 8
  ret void
}

define dso_local void @zdinx_asm_cR(ptr nocapture noundef writeonly %a, double noundef %b, double noundef %c) nounwind {
; CHECK-LABEL: zdinx_asm_cR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw s0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s1, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv a5, a4
; CHECK-NEXT:    mv s1, a2
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    mv s0, a1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    fsgnjx.d a2, s0, a4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sw a2, 8(a0)
; CHECK-NEXT:    sw a3, 12(a0)
; CHECK-NEXT:    lw s0, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s1, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 1
  %0 = tail call double asm "fsgnjx.d $0, $1, $2", "=^cR,^cR,^cR"(double %b, double %c)
  store double %0, ptr %arrayidx, align 8
  ret void
}
