; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB,RV32ZVBB
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB,RV64ZVBB

; ==============================================================================
; i32 -> i64
; ==============================================================================

define <vscale x 2 x i64> @vwsll_vv_nxv2i64_sext(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
; CHECK-LABEL: vwsll_vv_nxv2i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv2i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v9
; CHECK-ZVBB-NEXT:    vmv1r.v v11, v8
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v11, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i32> %b to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vv_nxv2i64_zext(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
; CHECK-LABEL: vwsll_vv_nxv2i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv2i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v9
; CHECK-ZVBB-NEXT:    vmv1r.v v11, v8
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v11, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i32> %b to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i64_nxv2i64(<vscale x 2 x i32> %a, i64 %b) {
; CHECK-LABEL: vwsll_vx_i64_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i64_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %splat
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i32_nxv2i64_sext(<vscale x 2 x i32> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_nxv2i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_nxv2i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i32_nxv2i64_zext(<vscale x 2 x i32> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_nxv2i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_nxv2i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i16_nxv2i64_sext(<vscale x 2 x i32> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_nxv2i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf4 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_nxv2i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i16_nxv2i64_zext(<vscale x 2 x i32> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_nxv2i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf4 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_nxv2i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i8_nxv2i64_sext(<vscale x 2 x i32> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv2i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf8 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv2i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i8_nxv2i64_zext(<vscale x 2 x i32> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv2i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf8 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv2i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vi_nxv2i64(<vscale x 2 x i32> %a) {
; CHECK-LABEL: vwsll_vi_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    li a0, 4
; CHECK-NEXT:    vwmulu.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vi v8, v10, 2
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, splat (i64 2)
  ret <vscale x 2 x i64> %z
}

; ==============================================================================
; i16 -> i32
; ==============================================================================

define <vscale x 4 x i32> @vwsll_vv_nxv4i32_sext(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b) {
; CHECK-LABEL: vwsll_vv_nxv4i32_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv4i32_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v9
; CHECK-ZVBB-NEXT:    vmv1r.v v11, v8
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v11, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %y = sext <vscale x 4 x i16> %b to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %y
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vv_nxv4i32_zext(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b) {
; CHECK-LABEL: vwsll_vv_nxv4i32_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv4i32_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v9
; CHECK-ZVBB-NEXT:    vmv1r.v v11, v8
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v11, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %y = zext <vscale x 4 x i16> %b to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %y
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vx_i64_nxv4i32(<vscale x 4 x i16> %a, i64 %b) {
; CHECK-LABEL: vwsll_vx_i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i64_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %y = trunc <vscale x 4 x i64> %splat to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %y
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vx_i32_nxv4i32(<vscale x 4 x i16> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %splat
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vx_i16_nxv4i32_sext(<vscale x 4 x i16> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_nxv4i32_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_nxv4i32_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %y = sext <vscale x 4 x i16> %splat to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %y
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vx_i16_nxv4i32_zext(<vscale x 4 x i16> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_nxv4i32_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_nxv4i32_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %y = zext <vscale x 4 x i16> %splat to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %y
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vx_i8_nxv4i32_sext(<vscale x 4 x i16> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv4i32_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf4 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv4i32_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %y = sext <vscale x 4 x i8> %splat to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %y
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vx_i8_nxv4i32_zext(<vscale x 4 x i16> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv4i32_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf4 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv4i32_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %y = zext <vscale x 4 x i8> %splat to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, %y
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @vwsll_vi_nxv4i32(<vscale x 4 x i16> %a) {
; CHECK-LABEL: vwsll_vi_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    li a0, 4
; CHECK-NEXT:    vwmulu.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vi v8, v10, 2
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %z = shl <vscale x 4 x i32> %x, splat (i32 2)
  ret <vscale x 4 x i32> %z
}

; ==============================================================================
; i8 -> i16
; ==============================================================================

define <vscale x 8 x i16> @vwsll_vv_nxv8i16_sext(<vscale x 8 x i8> %a, <vscale x 8 x i8> %b) {
; CHECK-LABEL: vwsll_vv_nxv8i16_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv8i16_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v9
; CHECK-ZVBB-NEXT:    vmv1r.v v11, v8
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v11, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %y = sext <vscale x 8 x i8> %b to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, %y
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @vwsll_vv_nxv8i16_zext(<vscale x 8 x i8> %a, <vscale x 8 x i8> %b) {
; CHECK-LABEL: vwsll_vv_nxv8i16_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv8i16_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v9
; CHECK-ZVBB-NEXT:    vmv1r.v v11, v8
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v11, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %y = zext <vscale x 8 x i8> %b to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, %y
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @vwsll_vx_i64_nxv8i16(<vscale x 8 x i8> %a, i64 %b) {
; CHECK-LABEL: vwsll_vx_i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i64_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %y = trunc <vscale x 8 x i64> %splat to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, %y
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @vwsll_vx_i32_nxv8i16(<vscale x 8 x i8> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %y = trunc <vscale x 8 x i32> %splat to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, %y
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @vwsll_vx_i16_nxv8i16(<vscale x 8 x i8> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, %splat
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @vwsll_vx_i8_nxv8i16_sext(<vscale x 8 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv8i16_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv8i16_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %y = sext <vscale x 8 x i8> %splat to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, %y
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @vwsll_vx_i8_nxv8i16_zext(<vscale x 8 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv8i16_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv8i16_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %y = zext <vscale x 8 x i8> %splat to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, %y
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @vwsll_vi_nxv8i16(<vscale x 8 x i8> %a) {
; CHECK-LABEL: vwsll_vi_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    li a0, 4
; CHECK-NEXT:    vwmulu.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vi v8, v10, 2
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %z = shl <vscale x 8 x i16> %x, splat (i16 2)
  ret <vscale x 8 x i16> %z
}

; ==============================================================================
; i8 -> i64
; ==============================================================================

define <vscale x 2 x i64> @vwsll_vv_nxv2i64_nxv2i8_sext(<vscale x 2 x i8> %a, <vscale x 2 x i8> %b) {
; CHECK-LABEL: vwsll_vv_nxv2i64_nxv2i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv2i64_nxv2i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf8 v12, v9
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v12
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i8> %b to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vv_nxv2i64_nxv2i8_zext(<vscale x 2 x i8> %a, <vscale x 2 x i8> %b) {
; CHECK-LABEL: vwsll_vv_nxv2i64_nxv2i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_nxv2i64_nxv2i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vzext.vf4 v11, v9
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v10, v11
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i8> %b to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i64_nxv2i64_nxv2i8(<vscale x 2 x i8> %a, i64 %b) {
; CHECK-LABEL: vwsll_vx_i64_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i64_nxv2i64_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %splat
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i32_nxv2i64_nxv2i8_sext(<vscale x 2 x i8> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_nxv2i64_nxv2i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_nxv2i64_nxv2i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v12, a0
; CHECK-ZVBB-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf2 v8, v12
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i32_nxv2i64_nxv2i8_zext(<vscale x 2 x i8> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_nxv2i64_nxv2i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf2 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_nxv2i64_nxv2i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i16_nxv2i64_nxv2i8_sext(<vscale x 2 x i8> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_nxv2i64_nxv2i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf4 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_nxv2i64_nxv2i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v12, a0
; CHECK-ZVBB-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf4 v8, v12
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i16_nxv2i64_nxv2i8_zext(<vscale x 2 x i8> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_nxv2i64_nxv2i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf4 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_nxv2i64_nxv2i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i8_nxv2i64_nxv2i8_sext(<vscale x 2 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv2i64_nxv2i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf8 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv2i64_nxv2i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v12, a0
; CHECK-ZVBB-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf8 v8, v12
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = sext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vx_i8_nxv2i64_nxv2i8_zext(<vscale x 2 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv2i64_nxv2i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf8 v8, v12
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_nxv2i64_nxv2i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @vwsll_vi_nxv2i64_nxv2i8(<vscale x 2 x i8> %a) {
; CHECK-LABEL: vwsll_vi_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsll.vi v8, v10, 2
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_nxv2i64_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vi v8, v10, 2
; CHECK-ZVBB-NEXT:    ret
  %x = zext <vscale x 2 x i8> %a to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, splat (i64 2)
  ret <vscale x 2 x i64> %z
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32ZVBB: {{.*}}
; RV64ZVBB: {{.*}}
