; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfbfmin,+zvfbfmin,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfbfmin,+zvfbfmin,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

define bfloat @vreduce_fmin_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fmin_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfredmin.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vector.reduce.fmin.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

define bfloat @vreduce_fmax_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fmax_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfredmax.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vector.reduce.fmax.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

define bfloat @vreduce_fmin_nnan_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fmin_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfredmin.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vector.reduce.fmin.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

define bfloat @vreduce_fmax_nnan_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fmax_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfredmax.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vector.reduce.fmax.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

define bfloat @vreduce_fminimum_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fminimum_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v10, v10
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    beqz a0, .LBB4_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_2:
; CHECK-NEXT:    vfredmin.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vector.reduce.fminimum.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

define bfloat @vreduce_fmaximum_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fmaximum_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v10, v10
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    beqz a0, .LBB5_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB5_2:
; CHECK-NEXT:    vfredmax.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vector.reduce.fmaximum.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

define bfloat @vreduce_fminimum_nnan_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fminimum_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfredmin.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vector.reduce.fminimum.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

define bfloat @vreduce_fmaximum_nnan_nxv4bf16(<vscale x 4 x bfloat> %val) {
; CHECK-LABEL: vreduce_fmaximum_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfredmax.vs v8, v10, v10
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vector.reduce.fmaximum.nxv4bf16(<vscale x 4 x bfloat> %val)
  ret bfloat %s
}

