; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+f,+d,+zvfh -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NO-ZVBB,RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+f,+d,+zvfh -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NO-ZVBB,RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+f,+d,+zvfh,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVBB,RV32-ZVBB
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+f,+d,+zvfh,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVBB,RV64-ZVBB

define <2 x i1> @reverse_v2i1(<2 x i1> %a) {
; NO-ZVBB-LABEL: reverse_v2i1:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; NO-ZVBB-NEXT:    vmv.v.i v8, 0
; NO-ZVBB-NEXT:    vmerge.vim v8, v8, 1, v0
; NO-ZVBB-NEXT:    vslidedown.vi v9, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v9, v8, 1
; NO-ZVBB-NEXT:    vmsne.vi v0, v9, 0
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v2i1:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; ZVBB-NEXT:    vbrev.v v8, v0
; ZVBB-NEXT:    vsrl.vi v0, v8, 6
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x i1> %a, <2 x i1> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x i1> %res
}

define <4 x i1> @reverse_v4i1(<4 x i1> %a) {
; NO-ZVBB-LABEL: reverse_v4i1:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; NO-ZVBB-NEXT:    vmv.v.i v8, 0
; NO-ZVBB-NEXT:    vmerge.vim v8, v8, 1, v0
; NO-ZVBB-NEXT:    vid.v v9
; NO-ZVBB-NEXT:    vrsub.vi v9, v9, 3
; NO-ZVBB-NEXT:    vrgather.vv v10, v8, v9
; NO-ZVBB-NEXT:    vmsne.vi v0, v10, 0
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v4i1:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; ZVBB-NEXT:    vbrev.v v8, v0
; ZVBB-NEXT:    vsrl.vi v0, v8, 4
; ZVBB-NEXT:    ret
  %res = shufflevector <4 x i1> %a, <4 x i1> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i1> %res
}

define <8 x i1> @reverse_v8i1(<8 x i1> %a) {
; NO-ZVBB-LABEL: reverse_v8i1:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; NO-ZVBB-NEXT:    vmv.v.i v8, 0
; NO-ZVBB-NEXT:    vmerge.vim v8, v8, 1, v0
; NO-ZVBB-NEXT:    vid.v v9
; NO-ZVBB-NEXT:    vrsub.vi v9, v9, 7
; NO-ZVBB-NEXT:    vrgather.vv v10, v8, v9
; NO-ZVBB-NEXT:    vmsne.vi v0, v10, 0
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v8i1:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; ZVBB-NEXT:    vbrev.v v0, v0
; ZVBB-NEXT:    ret
  %res = shufflevector <8 x i1> %a, <8 x i1> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i1> %res
}

define <16 x i1> @reverse_v16i1(<16 x i1> %a) {
; NO-ZVBB-LABEL: reverse_v16i1:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; NO-ZVBB-NEXT:    vmv.v.i v8, 0
; NO-ZVBB-NEXT:    vmerge.vim v8, v8, 1, v0
; NO-ZVBB-NEXT:    vid.v v9
; NO-ZVBB-NEXT:    vrsub.vi v9, v9, 15
; NO-ZVBB-NEXT:    vrgather.vv v10, v8, v9
; NO-ZVBB-NEXT:    vmsne.vi v0, v10, 0
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v16i1:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; ZVBB-NEXT:    vbrev.v v0, v0
; ZVBB-NEXT:    ret
  %res = shufflevector <16 x i1> %a, <16 x i1> poison, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i1> %res
}

define <32 x i1> @reverse_v32i1(<32 x i1> %a) {
; NO-ZVBB-LABEL: reverse_v32i1:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    li a0, 32
; NO-ZVBB-NEXT:    csrr a1, vlenb
; NO-ZVBB-NEXT:    vsetvli a2, zero, e16, m2, ta, ma
; NO-ZVBB-NEXT:    vid.v v8
; NO-ZVBB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; NO-ZVBB-NEXT:    vmv.v.i v10, 0
; NO-ZVBB-NEXT:    addi a2, a1, -1
; NO-ZVBB-NEXT:    slli a1, a1, 1
; NO-ZVBB-NEXT:    vmerge.vim v10, v10, 1, v0
; NO-ZVBB-NEXT:    vsetvli a3, zero, e16, m2, ta, ma
; NO-ZVBB-NEXT:    vrsub.vx v8, v8, a2
; NO-ZVBB-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; NO-ZVBB-NEXT:    vrgatherei16.vv v13, v10, v8
; NO-ZVBB-NEXT:    vrgatherei16.vv v12, v11, v8
; NO-ZVBB-NEXT:    addi a1, a1, -32
; NO-ZVBB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vx v8, v12, a1
; NO-ZVBB-NEXT:    vmsne.vi v0, v8, 0
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v32i1:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; ZVBB-NEXT:    vbrev.v v0, v0
; ZVBB-NEXT:    ret
  %res = shufflevector <32 x i1> %a, <32 x i1> poison, <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x i1> %res
}

define <64 x i1> @reverse_v64i1(<64 x i1> %a) {
; NO-ZVBB-LABEL: reverse_v64i1:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    li a0, 64
; NO-ZVBB-NEXT:    csrr a1, vlenb
; NO-ZVBB-NEXT:    vsetvli a2, zero, e16, m2, ta, ma
; NO-ZVBB-NEXT:    vid.v v12
; NO-ZVBB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; NO-ZVBB-NEXT:    vmv.v.i v8, 0
; NO-ZVBB-NEXT:    addi a2, a1, -1
; NO-ZVBB-NEXT:    slli a1, a1, 2
; NO-ZVBB-NEXT:    vmerge.vim v8, v8, 1, v0
; NO-ZVBB-NEXT:    vsetvli a3, zero, e16, m2, ta, ma
; NO-ZVBB-NEXT:    vrsub.vx v16, v12, a2
; NO-ZVBB-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; NO-ZVBB-NEXT:    vrgatherei16.vv v15, v8, v16
; NO-ZVBB-NEXT:    vrgatherei16.vv v14, v9, v16
; NO-ZVBB-NEXT:    vrgatherei16.vv v13, v10, v16
; NO-ZVBB-NEXT:    vrgatherei16.vv v12, v11, v16
; NO-ZVBB-NEXT:    addi a1, a1, -64
; NO-ZVBB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vx v8, v12, a1
; NO-ZVBB-NEXT:    vmsne.vi v0, v8, 0
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v64i1:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; ZVBB-NEXT:    vbrev.v v0, v0
; ZVBB-NEXT:    ret
  %res = shufflevector <64 x i1> %a, <64 x i1> poison, <64 x i32> <i32 63, i32 62, i32 61, i32 60, i32 59, i32 58, i32 57, i32 56, i32 55, i32 54, i32 53, i32 52, i32 51, i32 50, i32 49, i32 48, i32 47, i32 46, i32 45, i32 44, i32 43, i32 42, i32 41, i32 40, i32 39, i32 38, i32 37, i32 36, i32 35, i32 34, i32 33, i32 32, i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <64 x i1> %res
}

define <128 x i1> @reverse_v128i1(<128 x i1> %a) {
; CHECK-LABEL: reverse_v128i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 128
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    vsetvli a2, zero, e16, m2, ta, ma
; CHECK-NEXT:    vid.v v24
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    addi a2, a1, -1
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    vmerge.vim v16, v8, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e16, m2, ta, ma
; CHECK-NEXT:    vrsub.vx v24, v24, a2
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vrgatherei16.vv v15, v16, v24
; CHECK-NEXT:    vrgatherei16.vv v14, v17, v24
; CHECK-NEXT:    vrgatherei16.vv v13, v18, v24
; CHECK-NEXT:    vrgatherei16.vv v12, v19, v24
; CHECK-NEXT:    vrgatherei16.vv v11, v20, v24
; CHECK-NEXT:    vrgatherei16.vv v10, v21, v24
; CHECK-NEXT:    vrgatherei16.vv v9, v22, v24
; CHECK-NEXT:    vrgatherei16.vv v8, v23, v24
; CHECK-NEXT:    addi a1, a1, -128
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %res = shufflevector <128 x i1> %a, <128 x i1> poison, <128 x i32> <i32 127, i32 126, i32 125, i32 124, i32 123, i32 122, i32 121, i32 120, i32 119, i32 118, i32 117, i32 116, i32 115, i32 114, i32 113, i32 112, i32 111, i32 110, i32 109, i32 108, i32 107, i32 106, i32 105, i32 104, i32 103, i32 102, i32 101, i32 100, i32 99, i32 98, i32 97, i32 96, i32 95, i32 94, i32 93, i32 92, i32 91, i32 90, i32 89, i32 88, i32 87, i32 86, i32 85, i32 84, i32 83, i32 82, i32 81, i32 80, i32 79, i32 78, i32 77, i32 76, i32 75, i32 74, i32 73, i32 72, i32 71, i32 70, i32 69, i32 68, i32 67, i32 66, i32 65, i32 64, i32 63, i32 62, i32 61, i32 60, i32 59, i32 58, i32 57, i32 56, i32 55, i32 54, i32 53, i32 52, i32 51, i32 50, i32 49, i32 48, i32 47, i32 46, i32 45, i32 44, i32 43, i32 42, i32 41, i32 40, i32 39, i32 38, i32 37, i32 36, i32 35, i32 34, i32 33, i32 32, i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <128 x i1> %res
}

define <1 x i8> @reverse_v1i8(<1 x i8> %a) {
; CHECK-LABEL: reverse_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %res = shufflevector <1 x i8> %a, <1 x i8> poison, <1 x i32> <i32 0>
  ret <1 x i8> %res
}

define <2 x i8> @reverse_v2i8(<2 x i8> %a) {
; NO-ZVBB-LABEL: reverse_v2i8:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v9, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v9, v8, 1
; NO-ZVBB-NEXT:    vmv1r.v v8, v9
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v2i8:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; ZVBB-NEXT:    vrev8.v v8, v8
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x i8> %a, <2 x i8> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x i8> %res
}

define <4 x i8> @reverse_v4i8(<4 x i8> %a) {
; CHECK-LABEL: reverse_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 3
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i8> %a, <4 x i8> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i8> %res
}

define <8 x i8> @reverse_v8i8(<8 x i8> %a) {
; CHECK-LABEL: reverse_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 7
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i8> %a, <8 x i8> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i8> %res
}

define <16 x i8> @reverse_v16i8(<16 x i8> %a) {
; CHECK-LABEL: reverse_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 15
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <16 x i8> %a, <16 x i8> poison, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i8> %res
}

define <32 x i8> @reverse_v32i8(<32 x i8> %a) {
; CHECK-LABEL: reverse_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    addi a1, a0, -1
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    vrsub.vx v10, v10, a1
; CHECK-NEXT:    addi a0, a0, -32
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vrgatherei16.vv v13, v8, v10
; CHECK-NEXT:    vrgatherei16.vv v12, v9, v10
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <32 x i8> %a, <32 x i8> poison, <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x i8> %res
}

define <64 x i8> @reverse_v64i8(<64 x i8> %a) {
; CHECK-LABEL: reverse_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    addi a1, a0, -1
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    addi a0, a0, -64
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vrgatherei16.vv v15, v8, v16
; CHECK-NEXT:    vrgatherei16.vv v14, v9, v16
; CHECK-NEXT:    vrgatherei16.vv v13, v10, v16
; CHECK-NEXT:    vrgatherei16.vv v12, v11, v16
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <64 x i8> %a, <64 x i8> poison, <64 x i32> <i32 63, i32 62, i32 61, i32 60, i32 59, i32 58, i32 57, i32 56, i32 55, i32 54, i32 53, i32 52, i32 51, i32 50, i32 49, i32 48, i32 47, i32 46, i32 45, i32 44, i32 43, i32 42, i32 41, i32 40, i32 39, i32 38, i32 37, i32 36, i32 35, i32 34, i32 33, i32 32, i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <64 x i8> %res
}

define <1 x i16> @reverse_v1i16(<1 x i16> %a) {
; CHECK-LABEL: reverse_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %res = shufflevector <1 x i16> %a, <1 x i16> poison, <1 x i32> <i32 0>
  ret <1 x i16> %res
}

define <2 x i16> @reverse_v2i16(<2 x i16> %a) {
; NO-ZVBB-LABEL: reverse_v2i16:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v9, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v9, v8, 1
; NO-ZVBB-NEXT:    vmv1r.v v8, v9
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v2i16:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; ZVBB-NEXT:    vror.vi v8, v8, 16
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x i16> %a, <2 x i16> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x i16> %res
}

define <4 x i16> @reverse_v4i16(<4 x i16> %a) {
; CHECK-LABEL: reverse_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 3
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i16> %a, <4 x i16> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i16> %res
}

define <8 x i16> @reverse_v8i16(<8 x i16> %a) {
; CHECK-LABEL: reverse_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 7
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i16> %res
}

define <16 x i16> @reverse_v16i16(<16 x i16> %a) {
; CHECK-LABEL: reverse_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -16
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <16 x i16> %a, <16 x i16> poison, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i16> %res
}

define <32 x i16> @reverse_v32i16(<32 x i16> %a) {
; CHECK-LABEL: reverse_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 1
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    addi a0, a0, -32
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v15, v8, v16
; CHECK-NEXT:    vrgather.vv v14, v9, v16
; CHECK-NEXT:    vrgather.vv v13, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v11, v16
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <32 x i16> %a, <32 x i16> poison, <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x i16> %res
}

define <1 x i32> @reverse_v1i32(<1 x i32> %a) {
; CHECK-LABEL: reverse_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %res = shufflevector <1 x i32> %a, <1 x i32> poison, <1 x i32> <i32 0>
  ret <1 x i32> %res
}

define <2 x i32> @reverse_v2i32(<2 x i32> %a) {
; NO-ZVBB-LABEL: reverse_v2i32:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v9, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v9, v8, 1
; NO-ZVBB-NEXT:    vmv1r.v v8, v9
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v2i32:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; ZVBB-NEXT:    vror.vi v8, v8, 32
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x i32> %a, <2 x i32> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x i32> %res
}

define <4 x i32> @reverse_v4i32(<4 x i32> %a) {
; CHECK-LABEL: reverse_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 3
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i32> %res
}

define <8 x i32> @reverse_v8i32(<8 x i32> %a) {
; CHECK-LABEL: reverse_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i32> %a, <8 x i32> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i32> %res
}

define <16 x i32> @reverse_v16i32(<16 x i32> %a) {
; CHECK-LABEL: reverse_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v15, v8, v16
; CHECK-NEXT:    vrgather.vv v14, v9, v16
; CHECK-NEXT:    vrgather.vv v13, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v11, v16
; CHECK-NEXT:    addi a0, a0, -16
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <16 x i32> %a, <16 x i32> poison, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i32> %res
}

define <1 x i64> @reverse_v1i64(<1 x i64> %a) {
; CHECK-LABEL: reverse_v1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %res = shufflevector <1 x i64> %a, <1 x i64> poison, <1 x i32> <i32 0>
  ret <1 x i64> %res
}

define <2 x i64> @reverse_v2i64(<2 x i64> %a) {
; CHECK-LABEL: reverse_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-NEXT:    vslideup.vi v9, v8, 1
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x i64> %res
}

define <4 x i64> @reverse_v4i64(<4 x i64> %a) {
; CHECK-LABEL: reverse_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 3
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -4
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i64> %a, <4 x i64> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i64> %res
}

define <8 x i64> @reverse_v8i64(<8 x i64> %a) {
; CHECK-LABEL: reverse_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 3
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v15, v8, v16
; CHECK-NEXT:    vrgather.vv v14, v9, v16
; CHECK-NEXT:    vrgather.vv v13, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v11, v16
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i64> %a, <8 x i64> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i64> %res
}


define <1 x half> @reverse_v1f16(<1 x half> %a) {
; CHECK-LABEL: reverse_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %res = shufflevector <1 x half> %a, <1 x half> poison, <1 x i32> <i32 0>
  ret <1 x half> %res
}

define <2 x half> @reverse_v2f16(<2 x half> %a) {
; NO-ZVBB-LABEL: reverse_v2f16:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v9, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v9, v8, 1
; NO-ZVBB-NEXT:    vmv1r.v v8, v9
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v2f16:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; ZVBB-NEXT:    vror.vi v8, v8, 16
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x half> %a, <2 x half> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x half> %res
}

define <4 x half> @reverse_v4f16(<4 x half> %a) {
; CHECK-LABEL: reverse_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 3
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <4 x half> %a, <4 x half> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x half> %res
}

define <8 x half> @reverse_v8f16(<8 x half> %a) {
; CHECK-LABEL: reverse_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 7
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <8 x half> %a, <8 x half> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x half> %res
}

define <16 x half> @reverse_v16f16(<16 x half> %a) {
; CHECK-LABEL: reverse_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -16
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <16 x half> %a, <16 x half> poison, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x half> %res
}

define <32 x half> @reverse_v32f16(<32 x half> %a) {
; CHECK-LABEL: reverse_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 1
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    addi a0, a0, -32
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v15, v8, v16
; CHECK-NEXT:    vrgather.vv v14, v9, v16
; CHECK-NEXT:    vrgather.vv v13, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v11, v16
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <32 x half> %a, <32 x half> poison, <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x half> %res
}

define <1 x float> @reverse_v1f32(<1 x float> %a) {
; CHECK-LABEL: reverse_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %res = shufflevector <1 x float> %a, <1 x float> poison, <1 x i32> <i32 0>
  ret <1 x float> %res
}

define <2 x float> @reverse_v2f32(<2 x float> %a) {
; NO-ZVBB-LABEL: reverse_v2f32:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v9, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v9, v8, 1
; NO-ZVBB-NEXT:    vmv1r.v v8, v9
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v2f32:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; ZVBB-NEXT:    vror.vi v8, v8, 32
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x float> %a, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x float> %res
}

define <4 x float> @reverse_v4f32(<4 x float> %a) {
; CHECK-LABEL: reverse_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v9
; CHECK-NEXT:    vrsub.vi v10, v9, 3
; CHECK-NEXT:    vrgather.vv v9, v8, v10
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <4 x float> %a, <4 x float> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x float> %res
}

define <8 x float> @reverse_v8f32(<8 x float> %a) {
; CHECK-LABEL: reverse_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <8 x float> %a, <8 x float> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x float> %res
}

define <16 x float> @reverse_v16f32(<16 x float> %a) {
; CHECK-LABEL: reverse_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v15, v8, v16
; CHECK-NEXT:    vrgather.vv v14, v9, v16
; CHECK-NEXT:    vrgather.vv v13, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v11, v16
; CHECK-NEXT:    addi a0, a0, -16
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <16 x float> %a, <16 x float> poison, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x float> %res
}

define <1 x double> @reverse_v1f64(<1 x double> %a) {
; CHECK-LABEL: reverse_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %res = shufflevector <1 x double> %a, <1 x double> poison, <1 x i32> <i32 0>
  ret <1 x double> %res
}

define <2 x double> @reverse_v2f64(<2 x double> %a) {
; CHECK-LABEL: reverse_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-NEXT:    vslideup.vi v9, v8, 1
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %res = shufflevector <2 x double> %a, <2 x double> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x double> %res
}

define <4 x double> @reverse_v4f64(<4 x double> %a) {
; CHECK-LABEL: reverse_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 3
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -4
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <4 x double> %a, <4 x double> poison, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x double> %res
}

define <8 x double> @reverse_v8f64(<8 x double> %a) {
; CHECK-LABEL: reverse_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 3
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v15, v8, v16
; CHECK-NEXT:    vrgather.vv v14, v9, v16
; CHECK-NEXT:    vrgather.vv v13, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v11, v16
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a0
; CHECK-NEXT:    ret
  %res = shufflevector <8 x double> %a, <8 x double> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x double> %res
}


define <3 x i64> @reverse_v3i64(<3 x i64> %a) {
; CHECK-LABEL: reverse_v3i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v12, v10, 2
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vrgatherei16.vv v10, v8, v12
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %res = shufflevector <3 x i64> %a, <3 x i64> poison, <3 x i32> <i32 2, i32 1, i32 0>
  ret <3 x i64> %res
}

define <6 x i64> @reverse_v6i64(<6 x i64> %a) {
; CHECK-LABEL: reverse_v6i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    vrsub.vi v16, v12, 5
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vrgatherei16.vv v12, v8, v16
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %res = shufflevector <6 x i64> %a, <6 x i64> poison, <6 x i32> <i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <6 x i64> %res
}

define <12 x i64> @reverse_v12i64(<12 x i64> %a) {
; CHECK-LABEL: reverse_v12i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vid.v v16
; CHECK-NEXT:    vrsub.vi v24, v16, 11
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vrgatherei16.vv v16, v8, v24
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %res = shufflevector <12 x i64> %a, <12 x i64> poison, <12 x i32> <i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <12 x i64> %res
}

define <4 x i8> @reverse_v4i8_2(<2 x i8> %a, <2 x i8> %b) {
; NO-ZVBB-LABEL: reverse_v4i8_2:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslidedown.vi v8, v9, 1
; NO-ZVBB-NEXT:    vslideup.vi v8, v9, 1
; NO-ZVBB-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; NO-ZVBB-NEXT:    vslideup.vi v8, v10, 2
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v4i8_2:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; ZVBB-NEXT:    vrev8.v v10, v8
; ZVBB-NEXT:    vrev8.v v8, v9
; ZVBB-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVBB-NEXT:    vslideup.vi v8, v10, 2
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x i8> %a, <2 x i8> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i8> %res
}

define <8 x i8> @reverse_v8i8_2(<4 x i8> %a, <4 x i8> %b) {
; CHECK-LABEL: reverse_v8i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v10, v10, 3
; CHECK-NEXT:    vrgather.vv v11, v8, v10
; CHECK-NEXT:    vrgather.vv v8, v9, v10
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v11, 4
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i8> %res
}

define <16 x i8> @reverse_v16i8_2(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: reverse_v16i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v10, v10, 7
; CHECK-NEXT:    vrgather.vv v11, v8, v10
; CHECK-NEXT:    vrgather.vv v8, v9, v10
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v11, 8
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i8> %a, <8 x i8> %b, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i8> %res
}

define <32 x i8> @reverse_v32i8_2(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: reverse_v32i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v11, v10, 15
; CHECK-NEXT:    vrgather.vv v10, v8, v11
; CHECK-NEXT:    vrgather.vv v8, v9, v11
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v10, 16
; CHECK-NEXT:    ret
  %res = shufflevector <16 x i8> %a, <16 x i8> %b,  <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x i8> %res
}

define <4 x i16> @reverse_v4i16_2(<2 x i16> %a, <2 x i16> %b) {
; NO-ZVBB-LABEL: reverse_v4i16_2:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslidedown.vi v8, v9, 1
; NO-ZVBB-NEXT:    vslideup.vi v8, v9, 1
; NO-ZVBB-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; NO-ZVBB-NEXT:    vslideup.vi v8, v10, 2
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v4i16_2:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; ZVBB-NEXT:    vror.vi v10, v8, 16
; ZVBB-NEXT:    vror.vi v8, v9, 16
; ZVBB-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVBB-NEXT:    vslideup.vi v8, v10, 2
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x i16> %a, <2 x i16> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i16> %res
}

define <8 x i16> @reverse_v8i16_2(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: reverse_v8i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v10, v10, 3
; CHECK-NEXT:    vrgather.vv v11, v8, v10
; CHECK-NEXT:    vrgather.vv v8, v9, v10
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v11, 4
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i16> %a, <4 x i16> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i16> %res
}

define <16 x i16> @reverse_v16i16_2(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: reverse_v16i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v11, v10, 7
; CHECK-NEXT:    vrgather.vv v10, v8, v11
; CHECK-NEXT:    vrgather.vv v8, v9, v11
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v10, 8
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i16> %a, <8 x i16> %b,  <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i16> %res
}

define <32 x i16> @reverse_v32i16_2(<16 x i16> %a, <16 x i16> %b) {
; CHECK-LABEL: reverse_v32i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 1
; CHECK-NEXT:    addi a0, a0, -16
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v13, v8, v16
; CHECK-NEXT:    vrgather.vv v15, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v9, v16
; CHECK-NEXT:    vrgather.vv v14, v11, v16
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v12, a0
; CHECK-NEXT:    vslidedown.vx v8, v14, a0
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v12, 16
; CHECK-NEXT:    ret
  %res = shufflevector <16 x i16> %a, <16 x i16> %b,  <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x i16> %res
}

define <4 x i32> @reverse_v4i32_2(<2 x i32> %a, < 2 x i32> %b) {
; NO-ZVBB-LABEL: reverse_v4i32_2:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslidedown.vi v8, v9, 1
; NO-ZVBB-NEXT:    vslideup.vi v8, v9, 1
; NO-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; NO-ZVBB-NEXT:    vslideup.vi v8, v10, 2
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v4i32_2:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; ZVBB-NEXT:    vror.vi v10, v8, 32
; ZVBB-NEXT:    vror.vi v8, v9, 32
; ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZVBB-NEXT:    vslideup.vi v8, v10, 2
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x i32> %a, <2 x i32> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i32> %res
}

define <8 x i32> @reverse_v8i32_2(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: reverse_v8i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v11, v10, 3
; CHECK-NEXT:    vrgather.vv v10, v8, v11
; CHECK-NEXT:    vrgather.vv v8, v9, v11
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v10, 4
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i32> %res
}

define <16 x i32> @reverse_v16i32_2(<8 x i32> %a, <8 x i32> %b) {
; CHECK-LABEL: reverse_v16i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v13, v8, v16
; CHECK-NEXT:    vrgather.vv v15, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v9, v16
; CHECK-NEXT:    vrgather.vv v14, v11, v16
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v12, a0
; CHECK-NEXT:    vslidedown.vx v8, v14, a0
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v12, 8
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i32> %a, <8 x i32> %b,  <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i32> %res
}

define <32 x i32> @reverse_v32i32_2(<16 x i32> %a, <16 x i32> %b) {
; CHECK-LABEL: reverse_v32i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v16
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    addi a0, a0, -16
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v24, v16, a1
; CHECK-NEXT:    vrgather.vv v19, v8, v24
; CHECK-NEXT:    vrgather.vv v23, v12, v24
; CHECK-NEXT:    vrgather.vv v18, v9, v24
; CHECK-NEXT:    vrgather.vv v22, v13, v24
; CHECK-NEXT:    vrgather.vv v17, v10, v24
; CHECK-NEXT:    vrgather.vv v21, v14, v24
; CHECK-NEXT:    vrgather.vv v16, v11, v24
; CHECK-NEXT:    vrgather.vv v20, v15, v24
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v16, v16, a0
; CHECK-NEXT:    vslidedown.vx v8, v20, a0
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v16, 16
; CHECK-NEXT:    ret
  %res = shufflevector <16 x i32> %a, <16 x i32> %b,  <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x i32> %res
}

define <4 x i64> @reverse_v4i64_2(<2 x i64> %a, < 2 x i64> %b) {
; CHECK-LABEL: reverse_v4i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 1
; CHECK-NEXT:    vslideup.vi v10, v8, 1
; CHECK-NEXT:    vslidedown.vi v8, v9, 1
; CHECK-NEXT:    vslideup.vi v8, v9, 1
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v10, 2
; CHECK-NEXT:    ret
  %res = shufflevector <2 x i64> %a, <2 x i64> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i64> %res
}

define <8 x i64> @reverse_v8i64_2(<4 x i64> %a, <4 x i64> %b) {
; CHECK-LABEL: reverse_v8i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 3
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    addi a0, a0, -4
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v13, v8, v16
; CHECK-NEXT:    vrgather.vv v15, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v9, v16
; CHECK-NEXT:    vrgather.vv v14, v11, v16
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v12, a0
; CHECK-NEXT:    vslidedown.vx v8, v14, a0
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v12, 4
; CHECK-NEXT:    ret
  %res = shufflevector <4 x i64> %a, <4 x i64> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i64> %res
}

define <4 x half> @reverse_v4f16_2(<2 x half> %a, <2 x half> %b) {
; NO-ZVBB-LABEL: reverse_v4f16_2:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslidedown.vi v8, v9, 1
; NO-ZVBB-NEXT:    vslideup.vi v8, v9, 1
; NO-ZVBB-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; NO-ZVBB-NEXT:    vslideup.vi v8, v10, 2
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v4f16_2:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; ZVBB-NEXT:    vror.vi v10, v8, 16
; ZVBB-NEXT:    vror.vi v8, v9, 16
; ZVBB-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVBB-NEXT:    vslideup.vi v8, v10, 2
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x half> %a, <2 x half> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x half> %res
}

define <8 x half> @reverse_v8f16_2(<4 x half> %a, <4 x half> %b) {
; CHECK-LABEL: reverse_v8f16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v10, v10, 3
; CHECK-NEXT:    vrgather.vv v11, v8, v10
; CHECK-NEXT:    vrgather.vv v8, v9, v10
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v11, 4
; CHECK-NEXT:    ret
  %res = shufflevector <4 x half> %a, <4 x half> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x half> %res
}

define <16 x half> @reverse_v16f16_2(<8 x half> %a, <8 x half> %b) {
; CHECK-LABEL: reverse_v16f16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v11, v10, 7
; CHECK-NEXT:    vrgather.vv v10, v8, v11
; CHECK-NEXT:    vrgather.vv v8, v9, v11
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v10, 8
; CHECK-NEXT:    ret
  %res = shufflevector <8 x half> %a, <8 x half> %b,  <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x half> %res
}

define <32 x half> @reverse_v32f16_2(<16 x half> %a) {
; CHECK-LABEL: reverse_v32f16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    vrgather.vv v8, v9, v12
; CHECK-NEXT:    addi a0, a0, -32
; CHECK-NEXT:    vmv.v.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    ret
  %res = shufflevector <16 x half> %a, <16 x half> poison,  <32 x i32> <i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <32 x half> %res
}

define <4 x float> @reverse_v4f32_2(<2 x float> %a, <2 x float> %b) {
; NO-ZVBB-LABEL: reverse_v4f32_2:
; NO-ZVBB:       # %bb.0:
; NO-ZVBB-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; NO-ZVBB-NEXT:    vslidedown.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslideup.vi v10, v8, 1
; NO-ZVBB-NEXT:    vslidedown.vi v8, v9, 1
; NO-ZVBB-NEXT:    vslideup.vi v8, v9, 1
; NO-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; NO-ZVBB-NEXT:    vslideup.vi v8, v10, 2
; NO-ZVBB-NEXT:    ret
;
; ZVBB-LABEL: reverse_v4f32_2:
; ZVBB:       # %bb.0:
; ZVBB-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; ZVBB-NEXT:    vror.vi v10, v8, 32
; ZVBB-NEXT:    vror.vi v8, v9, 32
; ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZVBB-NEXT:    vslideup.vi v8, v10, 2
; ZVBB-NEXT:    ret
  %res = shufflevector <2 x float> %a, <2 x float> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x float> %res
}

define <8 x float> @reverse_v8f32_2(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: reverse_v8f32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v11, v10, 3
; CHECK-NEXT:    vrgather.vv v10, v8, v11
; CHECK-NEXT:    vrgather.vv v8, v9, v11
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v10, 4
; CHECK-NEXT:    ret
  %res = shufflevector <4 x float> %a, <4 x float> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x float> %res
}

define <16 x float> @reverse_v16f32_2(<8 x float> %a, <8 x float> %b) {
; CHECK-LABEL: reverse_v16f32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v13, v8, v16
; CHECK-NEXT:    vrgather.vv v15, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v9, v16
; CHECK-NEXT:    vrgather.vv v14, v11, v16
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v12, a0
; CHECK-NEXT:    vslidedown.vx v8, v14, a0
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v12, 8
; CHECK-NEXT:    ret
  %res = shufflevector <8 x float> %a, <8 x float> %b, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x float> %res
}

define <4 x double> @reverse_v4f64_2(<2 x double> %a, < 2 x double> %b) {
; CHECK-LABEL: reverse_v4f64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 1
; CHECK-NEXT:    vslideup.vi v10, v8, 1
; CHECK-NEXT:    vslidedown.vi v8, v9, 1
; CHECK-NEXT:    vslideup.vi v8, v9, 1
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v10, 2
; CHECK-NEXT:    ret
  %res = shufflevector <2 x double> %a, <2 x double> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x double> %res
}

define <8 x double> @reverse_v8f64_2(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: reverse_v8f64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vid.v v12
; CHECK-NEXT:    srli a1, a0, 3
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    addi a0, a0, -4
; CHECK-NEXT:    vrsub.vx v16, v12, a1
; CHECK-NEXT:    vrgather.vv v13, v8, v16
; CHECK-NEXT:    vrgather.vv v15, v10, v16
; CHECK-NEXT:    vrgather.vv v12, v9, v16
; CHECK-NEXT:    vrgather.vv v14, v11, v16
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v12, a0
; CHECK-NEXT:    vslidedown.vx v8, v14, a0
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vslideup.vi v8, v12, 4
; CHECK-NEXT:    ret
  %res = shufflevector <4 x double> %a, <4 x double> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x double> %res
}

; There is no corresponding v1i256 type, so make sure we don't crash if we try
; to lower via lowerBitreverseShuffle.
define <256 x i1> @reverse_v256i1(<256 x i1> %a) vscale_range(16, 1024) {
; CHECK-LABEL: reverse_v256i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 256
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    vsetvli a2, zero, e16, m2, ta, ma
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    addi a2, a1, -1
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    vmerge.vim v10, v10, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e16, m2, ta, ma
; CHECK-NEXT:    vrsub.vx v8, v8, a2
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vrgatherei16.vv v13, v10, v8
; CHECK-NEXT:    vrgatherei16.vv v12, v11, v8
; CHECK-NEXT:    addi a1, a1, -256
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v12, a1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %res = shufflevector <256 x i1> %a, <256 x i1> poison, <256 x i32> <i32 255, i32 254, i32 253, i32 252, i32 251, i32 250, i32 249, i32 248, i32 247, i32 246, i32 245, i32 244, i32 243, i32 242, i32 241, i32 240, i32 239, i32 238, i32 237, i32 236, i32 235, i32 234, i32 233, i32 232, i32 231, i32 230, i32 229, i32 228, i32 227, i32 226, i32 225, i32 224, i32 223, i32 222, i32 221, i32 220, i32 219, i32 218, i32 217, i32 216, i32 215, i32 214, i32 213, i32 212, i32 211, i32 210, i32 209, i32 208, i32 207, i32 206, i32 205, i32 204, i32 203, i32 202, i32 201, i32 200, i32 199, i32 198, i32 197, i32 196, i32 195, i32 194, i32 193, i32 192, i32 191, i32 190, i32 189, i32 188, i32 187, i32 186, i32 185, i32 184, i32 183, i32 182, i32 181, i32 180, i32 179, i32 178, i32 177, i32 176, i32 175, i32 174, i32 173, i32 172, i32 171, i32 170, i32 169, i32 168, i32 167, i32 166, i32 165, i32 164, i32 163, i32 162, i32 161, i32 160, i32 159, i32 158, i32 157, i32 156, i32 155, i32 154, i32 153, i32 152, i32 151, i32 150, i32 149, i32 148, i32 147, i32 146, i32 145, i32 144, i32 143, i32 142, i32 141, i32 140, i32 139, i32 138, i32 137, i32 136, i32 135, i32 134, i32 133, i32 132, i32 131, i32 130, i32 129, i32 128, i32 127, i32 126, i32 125, i32 124, i32 123, i32 122, i32 121, i32 120, i32 119, i32 118, i32 117, i32 116, i32 115, i32 114, i32 113, i32 112, i32 111, i32 110, i32 109, i32 108, i32 107, i32 106, i32 105, i32 104, i32 103, i32 102, i32 101, i32 100, i32 99, i32 98, i32 97, i32 96, i32 95, i32 94, i32 93, i32 92, i32 91, i32 90, i32 89, i32 88, i32 87, i32 86, i32 85, i32 84, i32 83, i32 82, i32 81, i32 80, i32 79, i32 78, i32 77, i32 76, i32 75, i32 74, i32 73, i32 72, i32 71, i32 70, i32 69, i32 68, i32 67, i32 66, i32 65, i32 64, i32 63, i32 62, i32 61, i32 60, i32 59, i32 58, i32 57, i32 56, i32 55, i32 54, i32 53, i32 52, i32 51, i32 50, i32 49, i32 48, i32 47, i32 46, i32 45, i32 44, i32 43, i32 42, i32 41, i32 40, i32 39, i32 38, i32 37, i32 36, i32 35, i32 34, i32 33, i32 32, i32 31, i32 30, i32 29, i32 28, i32 27, i32 26, i32 25, i32 24, i32 23, i32 22, i32 21, i32 20, i32 19, i32 18, i32 17, i32 16, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <256 x i1> %res
}

define <8 x i32> @reverse_v8i32_exact_vlen_128(<8 x i32> %a) vscale_range(2, 2) {
; CHECK-LABEL: reverse_v8i32_exact_vlen_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v12, v10, 3
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i32> %a, <8 x i32> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i32> %res
}

define <16 x i32> @reverse_v16i32_exact_vlen_256(<16 x i32> %a) vscale_range(4, 4) {
; CHECK-LABEL: reverse_v16i32_exact_vlen_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v12, v10, 7
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %res = shufflevector <16 x i32> %a, <16 x i32> poison, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i32> %res
}

define <8 x i32> @reverse_v8i32_undef_suffix(<8 x i32> %a) {
; CHECK-LABEL: reverse_v8i32_undef_suffix:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i32> %a, <8 x i32> poison, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %res
}

define <8 x i32> @reverse_v8i32_undef_prefix(<8 x i32> %a) {
; CHECK-LABEL: reverse_v8i32_undef_prefix:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vrsub.vx v12, v10, a1
; CHECK-NEXT:    vrgather.vv v11, v8, v12
; CHECK-NEXT:    vrgather.vv v10, v9, v12
; CHECK-NEXT:    addi a0, a0, -8
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v10, a0
; CHECK-NEXT:    ret
  %res = shufflevector <8 x i32> %a, <8 x i32> poison, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i32> %res
}


;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV32-ZVBB: {{.*}}
; RV64: {{.*}}
; RV64-ZVBB: {{.*}}
