; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfh,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfh,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

define void @fp2si_v2f32_v2i32(ptr %x, ptr %y) {
; CHECK-LABEL: fp2si_v2f32_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %x
  %d = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> %a)
  store <2 x i32> %d, ptr %y
  ret void
}
declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float>)

define void @fp2ui_v2f32_v2i32(ptr %x, ptr %y) {
; CHECK-LABEL: fp2ui_v2f32_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %x
  %d = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> %a)
  store <2 x i32> %d, ptr %y
  ret void
}
declare <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float>)

define void @fp2si_v8f32_v8i32(ptr %x, ptr %y) {
;
; CHECK-LABEL: fp2si_v8f32_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %d = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> %a)
  store <8 x i32> %d, ptr %y
  ret void
}
declare <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float>)

define void @fp2ui_v8f32_v8i32(ptr %x, ptr %y) {
;
; CHECK-LABEL: fp2ui_v8f32_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %d = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> %a)
  store <8 x i32> %d, ptr %y
  ret void
}
declare <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float>)

define void @fp2si_v2f32_v2i64(ptr %x, ptr %y) {
; CHECK-LABEL: fp2si_v2f32_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmerge.vim v8, v9, 0, v0
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %x
  %d = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> %a)
  store <2 x i64> %d, ptr %y
  ret void
}
declare <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float>)

define void @fp2ui_v2f32_v2i64(ptr %x, ptr %y) {
; CHECK-LABEL: fp2ui_v2f32_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmerge.vim v8, v9, 0, v0
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %x
  %d = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> %a)
  store <2 x i64> %d, ptr %y
  ret void
}
declare <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float>)

define void @fp2si_v8f32_v8i64(ptr %x, ptr %y) {
;
; CHECK-LABEL: fp2si_v8f32_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v12, (a0)
; CHECK-NEXT:    vmfne.vv v0, v12, v12
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v12
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %d = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> %a)
  store <8 x i64> %d, ptr %y
  ret void
}
declare <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float>)

define void @fp2ui_v8f32_v8i64(ptr %x, ptr %y) {
;
; CHECK-LABEL: fp2ui_v8f32_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v12, (a0)
; CHECK-NEXT:    vmfne.vv v0, v12, v12
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v12
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %d = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> %a)
  store <8 x i64> %d, ptr %y
  ret void
}
declare <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float>)

define void @fp2si_v2f16_v2i64(ptr %x, ptr %y) {
; CHECK-LABEL: fp2si_v2f16_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x half>, ptr %x
  %d = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> %a)
  store <2 x i64> %d, ptr %y
  ret void
}
declare <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half>)

define void @fp2ui_v2f16_v2i64(ptr %x, ptr %y) {
; CHECK-LABEL: fp2ui_v2f16_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x half>, ptr %x
  %d = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> %a)
  store <2 x i64> %d, ptr %y
  ret void
}
declare <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half>)

define void @fp2si_v2f64_v2i8(ptr %x, ptr %y) {
; CHECK-LABEL: fp2si_v2f64_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnclip.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnclip.wi v8, v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse8.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %d = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> %a)
  store <2 x i8> %d, ptr %y
  ret void
}
declare <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double>)

define void @fp2ui_v2f64_v2i8(ptr %x, ptr %y) {
; CHECK-LABEL: fp2ui_v2f64_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnclipu.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnclipu.wi v8, v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse8.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %d = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> %a)
  store <2 x i8> %d, ptr %y
  ret void
}
declare <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double>)

define void @fp2si_v8f64_v8i8(ptr %x, ptr %y) {
;
; CHECK-LABEL: fp2si_v8f64_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnclip.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnclip.wi v8, v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse8.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x double>, ptr %x
  %d = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> %a)
  store <8 x i8> %d, ptr %y
  ret void
}
declare <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double>)

define void @fp2ui_v8f64_v8i8(ptr %x, ptr %y) {
;
; CHECK-LABEL: fp2ui_v8f64_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnclipu.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnclipu.wi v8, v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 0, v0
; CHECK-NEXT:    vse8.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x double>, ptr %x
  %d = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> %a)
  store <8 x i8> %d, ptr %y
  ret void
}
declare <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> %a)

define void @fp2si_v2f64_v2i32(ptr %x, ptr %y) {
; CHECK-LABEL: fp2si_v2f64_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmerge.vim v8, v9, 0, v0
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %d = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> %a)
  store <2 x i32> %d, ptr %y
  ret void
}
declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double>)

define void @fp2ui_v2f64_v2i32(ptr %x, ptr %y) {
; CHECK-LABEL: fp2ui_v2f64_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v0, v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmerge.vim v8, v9, 0, v0
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %d = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> %a)
  store <2 x i32> %d, ptr %y
  ret void
}
declare <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double>)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV64: {{.*}}
