; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -global-isel  -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -verify-machineinstrs -o - < %s | FileCheck %s

define i64 @fptosi_float_i64(float %i) {
; CHECK-LABEL: fptosi_float_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxds f0, f1
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %i to i64
  ret i64 %conv
}

define i64 @fptosi_double_i64(double %i) {
; CHECK-LABEL: fptosi_double_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxds f0, f1
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %i to i64
  ret i64 %conv
}

define i64 @fptoui_float_i64(float %i) {
; CHECK-LABEL: fptoui_float_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxds f0, f1
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %i to i64
  ret i64 %conv
}

define i64 @fptoui_double_i64(double %i) {
; CHECK-LABEL: fptoui_double_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxds f0, f1
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %i to i64
  ret i64 %conv
}

define float @sitofp_i64_float(i64 %i) {
; CHECK-LABEL: sitofp_i64_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i64 %i to float
  ret float %conv
}

define double @sitofp_i64_double(i64 %i) {
; CHECK-LABEL: sitofp_i64_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i64 %i to double
  ret double %conv
}

define float @uitofp_i64_float(i64 %i) {
; CHECK-LABEL: uitofp_i64_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i64 %i to float
  ret float %conv
}

define double @uitofp_i64_double(i64 %i) {
; CHECK-LABEL: uitofp_i64_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i64 %i to double
  ret double %conv
}
