; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d < %s | FileCheck %s --check-prefixes=ALL,LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d < %s | FileCheck %s --check-prefixes=ALL,LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefixes=ALL,LA64

define void @foo() noreturn nounwind {
; ALL-LABEL: foo:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    .p2align 4, , 16
; ALL-NEXT:  .LBB0_1: # %loop
; ALL-NEXT:    # =>This Inner Loop Header: Depth=1
; ALL-NEXT:    b .LBB0_1
entry:
  br label %loop
loop:
  br label %loop
}

define void @foo_br_eq(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_eq:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    beq $a2, $a0, .LBB1_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB1_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_eq:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    beq $a2, $a0, .LBB1_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB1_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_eq:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    beq $a2, $a0, .LBB1_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB1_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp eq i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_ne(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_ne:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    bne $a2, $a0, .LBB2_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB2_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_ne:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    bne $a2, $a0, .LBB2_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB2_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_ne:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    bne $a2, $a0, .LBB2_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB2_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp ne i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_slt(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_slt:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    blt $a2, $a0, .LBB3_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB3_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_slt:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    blt $a2, $a0, .LBB3_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB3_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_slt:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    blt $a2, $a0, .LBB3_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB3_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp slt i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_sge(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_sge:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    bge $a2, $a0, .LBB4_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB4_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_sge:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    bge $a2, $a0, .LBB4_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB4_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_sge:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    bge $a2, $a0, .LBB4_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB4_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp sge i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_ult(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_ult:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    bltu $a2, $a0, .LBB5_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB5_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_ult:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    bltu $a2, $a0, .LBB5_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB5_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_ult:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    bltu $a2, $a0, .LBB5_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB5_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp ult i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_uge(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_uge:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    bgeu $a2, $a0, .LBB6_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB6_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_uge:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    bgeu $a2, $a0, .LBB6_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB6_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_uge:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    bgeu $a2, $a0, .LBB6_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB6_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp uge i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

;; Check for condition codes that don't have a matching instruction.
define void @foo_br_sgt(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_sgt:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    blt $a0, $a2, .LBB7_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB7_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_sgt:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    blt $a0, $a2, .LBB7_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB7_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_sgt:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    blt $a0, $a2, .LBB7_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB7_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp sgt i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_sle(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_sle:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    bge $a0, $a2, .LBB8_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB8_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_sle:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    bge $a0, $a2, .LBB8_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB8_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_sle:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    bge $a0, $a2, .LBB8_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB8_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp sle i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_ugt(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_ugt:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    bltu $a0, $a2, .LBB9_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB9_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_ugt:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    bltu $a0, $a2, .LBB9_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB9_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_ugt:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    bltu $a0, $a2, .LBB9_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB9_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp ugt i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

define void @foo_br_ule(i32 %a, ptr %b) nounwind {
; LA32R-LABEL: foo_br_ule:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $a2, $a1, 0
; LA32R-NEXT:    bgeu $a0, $a2, .LBB10_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a1, 0
; LA32R-NEXT:  .LBB10_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_ule:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $a2, $a1, 0
; LA32S-NEXT:    bgeu $a0, $a2, .LBB10_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a1, 0
; LA32S-NEXT:  .LBB10_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_ule:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a2, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    bgeu $a0, $a2, .LBB10_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a1, 0
; LA64-NEXT:  .LBB10_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %b
  %cc = icmp ule i32 %val, %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %b
  br label %end

end:
  ret void
}

;; Check the case of a branch where the condition was generated in another
;; function.
define void @foo_br_cc(ptr %a, i1 %cc) nounwind {
; LA32R-LABEL: foo_br_cc:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ld.w $zero, $a0, 0
; LA32R-NEXT:    andi $a1, $a1, 1
; LA32R-NEXT:    bne $a1, $zero, .LBB11_2
; LA32R-NEXT:  # %bb.1: # %test
; LA32R-NEXT:    ld.w $zero, $a0, 0
; LA32R-NEXT:  .LBB11_2: # %end
; LA32R-NEXT:    ret
;
; LA32S-LABEL: foo_br_cc:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ld.w $zero, $a0, 0
; LA32S-NEXT:    andi $a1, $a1, 1
; LA32S-NEXT:    bnez $a1, .LBB11_2
; LA32S-NEXT:  # %bb.1: # %test
; LA32S-NEXT:    ld.w $zero, $a0, 0
; LA32S-NEXT:  .LBB11_2: # %end
; LA32S-NEXT:    ret
;
; LA64-LABEL: foo_br_cc:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $zero, $a0, 0
; LA64-NEXT:    andi $a1, $a1, 1
; LA64-NEXT:    bnez $a1, .LBB11_2
; LA64-NEXT:  # %bb.1: # %test
; LA64-NEXT:    ld.w $zero, $a0, 0
; LA64-NEXT:  .LBB11_2: # %end
; LA64-NEXT:    ret
  %val = load volatile i32, ptr %a
  br i1 %cc, label %end, label %test
test:
  %tmp = load volatile i32, ptr %a
  br label %end

end:
  ret void
}
