; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn -mcpu=gfx950 < %s | FileCheck -enable-var-scope --check-prefix=GCN %s

; FIXME: bfloat vector arguments are broken in globalisel.
; https://github.com/llvm/llvm-project/issues/77055

declare <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat>, <8 x bfloat>, <16 x float>, i32 immarg, i32 immarg, i32 immarg)

; --------------------------------------------------------------------
; llvm.amdgcn.mfma.f32.32x32x16.bf16
; --------------------------------------------------------------------

define amdgpu_kernel void @test_mfma_f32_32x32x16_bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2) #1 {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    v_mov_b64_e32 v[12:13], 48
; GCN-NEXT:    v_mov_b64_e32 v[14:15], 32
; GCN-NEXT:    v_mov_b64_e32 v[16:17], 16
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GCN-NEXT:    v_accvgpr_write_b32 a0, s8
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GCN-NEXT:    v_accvgpr_write_b32 a1, s9
; GCN-NEXT:    v_accvgpr_write_b32 a2, s10
; GCN-NEXT:    v_accvgpr_write_b32 a3, s11
; GCN-NEXT:    v_accvgpr_write_b32 a4, s12
; GCN-NEXT:    v_accvgpr_write_b32 a5, s13
; GCN-NEXT:    v_accvgpr_write_b32 a6, s14
; GCN-NEXT:    v_accvgpr_write_b32 a7, s15
; GCN-NEXT:    v_accvgpr_write_b32 a8, s16
; GCN-NEXT:    v_accvgpr_write_b32 a9, s17
; GCN-NEXT:    v_accvgpr_write_b32 a10, s18
; GCN-NEXT:    v_accvgpr_write_b32 a11, s19
; GCN-NEXT:    v_accvgpr_write_b32 a12, s20
; GCN-NEXT:    v_accvgpr_write_b32 a13, s21
; GCN-NEXT:    v_accvgpr_write_b32 a14, s22
; GCN-NEXT:    v_accvgpr_write_b32 a15, s23
; GCN-NEXT:    v_mov_b64_e32 v[18:19], 0
; GCN-NEXT:    v_mov_b32_e32 v8, s16
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[16:31], v[0:3], v[4:7], a[0:15]
; GCN-NEXT:    v_mov_b32_e32 v0, s20
; GCN-NEXT:    v_mov_b32_e32 v1, s21
; GCN-NEXT:    v_mov_b32_e32 v2, s22
; GCN-NEXT:    v_mov_b32_e32 v3, s23
; GCN-NEXT:    v_mov_b32_e32 v9, s17
; GCN-NEXT:    v_mov_b32_e32 v10, s18
; GCN-NEXT:    v_mov_b32_e32 v11, s19
; GCN-NEXT:    s_nop 4
; GCN-NEXT:    global_store_dwordx4 v[12:13], a[28:31], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[14:15], a[24:27], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[16:17], a[20:23], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[18:19], a[16:19], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[14:15], v[8:11], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[12:13], v[0:3], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    global_store_dwordx4 v[18:19], v[0:3], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s12
; GCN-NEXT:    v_mov_b32_e32 v1, s13
; GCN-NEXT:    v_mov_b32_e32 v2, s14
; GCN-NEXT:    v_mov_b32_e32 v3, s15
; GCN-NEXT:    global_store_dwordx4 v[16:17], v[0:3], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  store volatile <16 x float> %result, ptr addrspace(1) null
  store volatile <16 x float> %arg2, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_bf16__flags(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2) #1 {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    v_mov_b64_e32 v[12:13], 48
; GCN-NEXT:    v_mov_b64_e32 v[14:15], 32
; GCN-NEXT:    v_mov_b64_e32 v[16:17], 16
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GCN-NEXT:    v_accvgpr_write_b32 a0, s8
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GCN-NEXT:    v_accvgpr_write_b32 a1, s9
; GCN-NEXT:    v_accvgpr_write_b32 a2, s10
; GCN-NEXT:    v_accvgpr_write_b32 a3, s11
; GCN-NEXT:    v_accvgpr_write_b32 a4, s12
; GCN-NEXT:    v_accvgpr_write_b32 a5, s13
; GCN-NEXT:    v_accvgpr_write_b32 a6, s14
; GCN-NEXT:    v_accvgpr_write_b32 a7, s15
; GCN-NEXT:    v_accvgpr_write_b32 a8, s16
; GCN-NEXT:    v_accvgpr_write_b32 a9, s17
; GCN-NEXT:    v_accvgpr_write_b32 a10, s18
; GCN-NEXT:    v_accvgpr_write_b32 a11, s19
; GCN-NEXT:    v_accvgpr_write_b32 a12, s20
; GCN-NEXT:    v_accvgpr_write_b32 a13, s21
; GCN-NEXT:    v_accvgpr_write_b32 a14, s22
; GCN-NEXT:    v_accvgpr_write_b32 a15, s23
; GCN-NEXT:    v_mov_b64_e32 v[18:19], 0
; GCN-NEXT:    v_mov_b32_e32 v8, s16
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[16:31], v[0:3], v[4:7], a[0:15] cbsz:2 abid:3 blgp:1
; GCN-NEXT:    v_mov_b32_e32 v0, s20
; GCN-NEXT:    v_mov_b32_e32 v1, s21
; GCN-NEXT:    v_mov_b32_e32 v2, s22
; GCN-NEXT:    v_mov_b32_e32 v3, s23
; GCN-NEXT:    v_mov_b32_e32 v9, s17
; GCN-NEXT:    v_mov_b32_e32 v10, s18
; GCN-NEXT:    v_mov_b32_e32 v11, s19
; GCN-NEXT:    s_nop 4
; GCN-NEXT:    global_store_dwordx4 v[12:13], a[28:31], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[14:15], a[24:27], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[16:17], a[20:23], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[18:19], a[16:19], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[14:15], v[8:11], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v[12:13], v[0:3], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    global_store_dwordx4 v[18:19], v[0:3], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s12
; GCN-NEXT:    v_mov_b32_e32 v1, s13
; GCN-NEXT:    v_mov_b32_e32 v2, s14
; GCN-NEXT:    v_mov_b32_e32 v3, s15
; GCN-NEXT:    global_store_dwordx4 v[16:17], v[0:3], off sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 2, i32 3, i32 1)
  store volatile <16 x float> %result, ptr addrspace(1) null
  store volatile <16 x float> %arg2, ptr addrspace(1) null
  ret void
}

define <16 x float> @test_mfma_f32_32x32x16_bf16__mac(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16__mac:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    v_accvgpr_write_b32 a4, v12
; GCN-NEXT:    v_accvgpr_write_b32 a5, v13
; GCN-NEXT:    v_accvgpr_write_b32 a6, v14
; GCN-NEXT:    v_accvgpr_write_b32 a7, v15
; GCN-NEXT:    v_accvgpr_write_b32 a8, v16
; GCN-NEXT:    v_accvgpr_write_b32 a9, v17
; GCN-NEXT:    v_accvgpr_write_b32 a10, v18
; GCN-NEXT:    v_accvgpr_write_b32 a11, v19
; GCN-NEXT:    v_accvgpr_write_b32 a12, v20
; GCN-NEXT:    v_accvgpr_write_b32 a13, v21
; GCN-NEXT:    v_accvgpr_write_b32 a14, v22
; GCN-NEXT:    v_accvgpr_write_b32 a15, v23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[0:15], v[0:3], v[4:7], a[0:15]
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 3
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    v_accvgpr_read_b32 v4, a4
; GCN-NEXT:    v_accvgpr_read_b32 v5, a5
; GCN-NEXT:    v_accvgpr_read_b32 v6, a6
; GCN-NEXT:    v_accvgpr_read_b32 v7, a7
; GCN-NEXT:    v_accvgpr_read_b32 v8, a8
; GCN-NEXT:    v_accvgpr_read_b32 v9, a9
; GCN-NEXT:    v_accvgpr_read_b32 v10, a10
; GCN-NEXT:    v_accvgpr_read_b32 v11, a11
; GCN-NEXT:    v_accvgpr_read_b32 v12, a12
; GCN-NEXT:    v_accvgpr_read_b32 v13, a13
; GCN-NEXT:    v_accvgpr_read_b32 v14, a14
; GCN-NEXT:    v_accvgpr_read_b32 v15, a15
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  ret <16 x float> %result
}

define <16 x float> @test_mfma_f32_32x32x16_bf16__mac__flags(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16__mac__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    v_accvgpr_write_b32 a4, v12
; GCN-NEXT:    v_accvgpr_write_b32 a5, v13
; GCN-NEXT:    v_accvgpr_write_b32 a6, v14
; GCN-NEXT:    v_accvgpr_write_b32 a7, v15
; GCN-NEXT:    v_accvgpr_write_b32 a8, v16
; GCN-NEXT:    v_accvgpr_write_b32 a9, v17
; GCN-NEXT:    v_accvgpr_write_b32 a10, v18
; GCN-NEXT:    v_accvgpr_write_b32 a11, v19
; GCN-NEXT:    v_accvgpr_write_b32 a12, v20
; GCN-NEXT:    v_accvgpr_write_b32 a13, v21
; GCN-NEXT:    v_accvgpr_write_b32 a14, v22
; GCN-NEXT:    v_accvgpr_write_b32 a15, v23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:1 abid:1 blgp:1
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 3
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    v_accvgpr_read_b32 v4, a4
; GCN-NEXT:    v_accvgpr_read_b32 v5, a5
; GCN-NEXT:    v_accvgpr_read_b32 v6, a6
; GCN-NEXT:    v_accvgpr_read_b32 v7, a7
; GCN-NEXT:    v_accvgpr_read_b32 v8, a8
; GCN-NEXT:    v_accvgpr_read_b32 v9, a9
; GCN-NEXT:    v_accvgpr_read_b32 v10, a10
; GCN-NEXT:    v_accvgpr_read_b32 v11, a11
; GCN-NEXT:    v_accvgpr_read_b32 v12, a12
; GCN-NEXT:    v_accvgpr_read_b32 v13, a13
; GCN-NEXT:    v_accvgpr_read_b32 v14, a14
; GCN-NEXT:    v_accvgpr_read_b32 v15, a15
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 1, i32 1, i32 1)
  ret <16 x float> %result
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_bf16__vgprcd(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16__vgprcd:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GCN-NEXT:    v_mov_b32_e32 v12, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GCN-NEXT:    v_accvgpr_write_b32 a31, s23
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GCN-NEXT:    v_accvgpr_write_b32 a30, s22
; GCN-NEXT:    v_accvgpr_write_b32 a29, s21
; GCN-NEXT:    v_accvgpr_write_b32 a28, s20
; GCN-NEXT:    v_accvgpr_write_b32 a27, s19
; GCN-NEXT:    v_accvgpr_write_b32 a26, s18
; GCN-NEXT:    v_accvgpr_write_b32 a25, s17
; GCN-NEXT:    v_accvgpr_write_b32 a24, s16
; GCN-NEXT:    v_accvgpr_write_b32 a23, s15
; GCN-NEXT:    v_accvgpr_write_b32 a22, s14
; GCN-NEXT:    v_accvgpr_write_b32 a21, s13
; GCN-NEXT:    v_accvgpr_write_b32 a20, s12
; GCN-NEXT:    v_accvgpr_write_b32 a19, s11
; GCN-NEXT:    v_accvgpr_write_b32 a18, s10
; GCN-NEXT:    v_accvgpr_write_b32 a17, s9
; GCN-NEXT:    v_accvgpr_write_b32 a16, s8
; GCN-NEXT:    v_mov_b32_e32 v8, s20
; GCN-NEXT:    v_mov_b32_e32 v9, s21
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[0:15], v[0:3], v[4:7], a[16:31]
; GCN-NEXT:    v_mov_b32_e32 v10, s22
; GCN-NEXT:    v_mov_b32_e32 v11, s23
; GCN-NEXT:    v_mov_b32_e32 v0, s16
; GCN-NEXT:    v_mov_b32_e32 v1, s17
; GCN-NEXT:    v_mov_b32_e32 v2, s18
; GCN-NEXT:    v_mov_b32_e32 v3, s19
; GCN-NEXT:    global_store_dwordx4 v12, v[8:11], s[0:1] offset:48 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:32 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s12
; GCN-NEXT:    v_mov_b32_e32 v1, s13
; GCN-NEXT:    v_mov_b32_e32 v2, s14
; GCN-NEXT:    v_mov_b32_e32 v3, s15
; GCN-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:16 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[8:11], s[0:1] offset:32 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[12:15], s[0:1] offset:48 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[0:3], s[0:1] sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[4:7], s[0:1] offset:16 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  store volatile <16 x float> %arg2, ptr addrspace(1) %out
  store volatile <16 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_bf16__vgprcd__flags(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16__vgprcd__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GCN-NEXT:    v_mov_b32_e32 v12, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GCN-NEXT:    v_accvgpr_write_b32 a31, s23
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GCN-NEXT:    v_accvgpr_write_b32 a30, s22
; GCN-NEXT:    v_accvgpr_write_b32 a29, s21
; GCN-NEXT:    v_accvgpr_write_b32 a28, s20
; GCN-NEXT:    v_accvgpr_write_b32 a27, s19
; GCN-NEXT:    v_accvgpr_write_b32 a26, s18
; GCN-NEXT:    v_accvgpr_write_b32 a25, s17
; GCN-NEXT:    v_accvgpr_write_b32 a24, s16
; GCN-NEXT:    v_accvgpr_write_b32 a23, s15
; GCN-NEXT:    v_accvgpr_write_b32 a22, s14
; GCN-NEXT:    v_accvgpr_write_b32 a21, s13
; GCN-NEXT:    v_accvgpr_write_b32 a20, s12
; GCN-NEXT:    v_accvgpr_write_b32 a19, s11
; GCN-NEXT:    v_accvgpr_write_b32 a18, s10
; GCN-NEXT:    v_accvgpr_write_b32 a17, s9
; GCN-NEXT:    v_accvgpr_write_b32 a16, s8
; GCN-NEXT:    v_mov_b32_e32 v8, s20
; GCN-NEXT:    v_mov_b32_e32 v9, s21
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[0:15], v[0:3], v[4:7], a[16:31] cbsz:1 abid:2 blgp:3
; GCN-NEXT:    v_mov_b32_e32 v10, s22
; GCN-NEXT:    v_mov_b32_e32 v11, s23
; GCN-NEXT:    v_mov_b32_e32 v0, s16
; GCN-NEXT:    v_mov_b32_e32 v1, s17
; GCN-NEXT:    v_mov_b32_e32 v2, s18
; GCN-NEXT:    v_mov_b32_e32 v3, s19
; GCN-NEXT:    global_store_dwordx4 v12, v[8:11], s[0:1] offset:48 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:32 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s12
; GCN-NEXT:    v_mov_b32_e32 v1, s13
; GCN-NEXT:    v_mov_b32_e32 v2, s14
; GCN-NEXT:    v_mov_b32_e32 v3, s15
; GCN-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:16 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[8:11], s[0:1] offset:32 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[12:15], s[0:1] offset:48 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[0:3], s[0:1] sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    global_store_dwordx4 v12, a[4:7], s[0:1] offset:16 sc0 sc1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 1, i32 2, i32 3)
  store volatile <16 x float> %arg2, ptr addrspace(1) %out
  store volatile <16 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_bf16__vgprcd_mac(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16__vgprcd_mac:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GCN-NEXT:    v_accvgpr_write_b32 a0, s8
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GCN-NEXT:    v_accvgpr_write_b32 a1, s9
; GCN-NEXT:    v_accvgpr_write_b32 a2, s10
; GCN-NEXT:    v_accvgpr_write_b32 a3, s11
; GCN-NEXT:    v_accvgpr_write_b32 a4, s12
; GCN-NEXT:    v_accvgpr_write_b32 a5, s13
; GCN-NEXT:    v_accvgpr_write_b32 a6, s14
; GCN-NEXT:    v_accvgpr_write_b32 a7, s15
; GCN-NEXT:    v_accvgpr_write_b32 a8, s16
; GCN-NEXT:    v_accvgpr_write_b32 a9, s17
; GCN-NEXT:    v_accvgpr_write_b32 a10, s18
; GCN-NEXT:    v_accvgpr_write_b32 a11, s19
; GCN-NEXT:    v_accvgpr_write_b32 a12, s20
; GCN-NEXT:    v_accvgpr_write_b32 a13, s21
; GCN-NEXT:    v_accvgpr_write_b32 a14, s22
; GCN-NEXT:    v_accvgpr_write_b32 a15, s23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[0:15], v[0:3], v[4:7], a[0:15]
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 2
; GCN-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; GCN-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; GCN-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; GCN-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; GCN-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  store <16 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_bf16__vgprcd_mac_flags(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test_mfma_f32_32x32x16_bf16__vgprcd_mac_flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GCN-NEXT:    v_accvgpr_write_b32 a0, s8
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GCN-NEXT:    v_accvgpr_write_b32 a1, s9
; GCN-NEXT:    v_accvgpr_write_b32 a2, s10
; GCN-NEXT:    v_accvgpr_write_b32 a3, s11
; GCN-NEXT:    v_accvgpr_write_b32 a4, s12
; GCN-NEXT:    v_accvgpr_write_b32 a5, s13
; GCN-NEXT:    v_accvgpr_write_b32 a6, s14
; GCN-NEXT:    v_accvgpr_write_b32 a7, s15
; GCN-NEXT:    v_accvgpr_write_b32 a8, s16
; GCN-NEXT:    v_accvgpr_write_b32 a9, s17
; GCN-NEXT:    v_accvgpr_write_b32 a10, s18
; GCN-NEXT:    v_accvgpr_write_b32 a11, s19
; GCN-NEXT:    v_accvgpr_write_b32 a12, s20
; GCN-NEXT:    v_accvgpr_write_b32 a13, s21
; GCN-NEXT:    v_accvgpr_write_b32 a14, s22
; GCN-NEXT:    v_accvgpr_write_b32 a15, s23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_32x32x16_bf16 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:3 abid:2 blgp:1
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 2
; GCN-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; GCN-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; GCN-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; GCN-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; GCN-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <16 x float> %arg2, i32 3, i32 2, i32 1)
  store <16 x float> %result, ptr addrspace(1) %out
  ret void
}

attributes #0 = { "amdgpu-flat-work-group-size"="512,512" }
attributes #1 = { "amdgpu-flat-work-group-size"="1,64" }
