; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define <16 x float> @bitcast_v16i32_to_v16f32(<16 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v16i32_to_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB0_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB0_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i32_to_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB0_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB0_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i32_to_v16f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB0_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB0_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i32_to_v16f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB0_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB0_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define inreg <16 x float> @bitcast_v16i32_to_v16f32_scalar(<16 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i32_to_v16f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_v16i32_to_v16f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_v16i32_to_v16f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_v16i32_to_v16f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB1_3
; GFX11-NEXT:  .LBB1_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB1_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_4:
; GFX11-NEXT:    s_branch .LBB1_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define <16 x i32> @bitcast_v16f32_to_v16i32(<16 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v16f32_to_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB2_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB2_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f32_to_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB2_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB2_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f32_to_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB2_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB2_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f32_to_v16i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB2_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB2_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define inreg <16 x i32> @bitcast_v16f32_to_v16i32_scalar(<16 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f32_to_v16i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB3_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_3
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB3_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    s_branch .LBB3_2
;
; VI-LABEL: bitcast_v16f32_to_v16i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB3_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_3
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB3_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    s_branch .LBB3_2
;
; GFX9-LABEL: bitcast_v16f32_to_v16i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_3
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB3_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    s_branch .LBB3_2
;
; GFX11-LABEL: bitcast_v16f32_to_v16i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB3_4
; GFX11-NEXT:  .LBB3_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v15, s27, 1.0
; GFX11-NEXT:    v_add_f32_e64 v14, s26, 1.0
; GFX11-NEXT:    v_add_f32_e64 v13, s25, 1.0
; GFX11-NEXT:    v_add_f32_e64 v12, s24, 1.0
; GFX11-NEXT:    v_add_f32_e64 v11, s23, 1.0
; GFX11-NEXT:    v_add_f32_e64 v10, s22, 1.0
; GFX11-NEXT:    v_add_f32_e64 v9, s21, 1.0
; GFX11-NEXT:    v_add_f32_e64 v8, s20, 1.0
; GFX11-NEXT:    v_add_f32_e64 v7, s19, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s18, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s17, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s16, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s15, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s14, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s13, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s12, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:    s_branch .LBB3_2
; GFX11-NEXT:  .LBB3_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define <8 x i64> @bitcast_v16i32_to_v8i64(<16 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v16i32_to_v8i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB4_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB4_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i32_to_v8i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB4_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB4_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i32_to_v8i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB4_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i32_to_v8i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB4_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB4_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <8 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <8 x i64>
  br label %end

end:
  %phi = phi <8 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i64> %phi
}

define inreg <8 x i64> @bitcast_v16i32_to_v8i64_scalar(<16 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i32_to_v8i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_v16i32_to_v8i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_v16i32_to_v8i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_v16i32_to_v8i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB5_3
; GFX11-NEXT:  .LBB5_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB5_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_4:
; GFX11-NEXT:    s_branch .LBB5_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <8 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <8 x i64>
  br label %end

end:
  %phi = phi <8 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i64> %phi
}

define <16 x i32> @bitcast_v8i64_to_v16i32(<8 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v8i64_to_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB6_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB6_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i64_to_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB6_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB6_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i64_to_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB6_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB6_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i64_to_v16i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB6_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i64> %a, splat (i64 3)
  %a2 = bitcast <8 x i64> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i64> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define inreg <16 x i32> @bitcast_v8i64_to_v16i32_scalar(<8 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i64_to_v16i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v8i64_to_v16i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v8i64_to_v16i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v8i64_to_v16i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB7_3
; GFX11-NEXT:  .LBB7_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s26, s26, 3
; GFX11-NEXT:    s_addc_u32 s27, s27, 0
; GFX11-NEXT:    s_add_u32 s24, s24, 3
; GFX11-NEXT:    s_addc_u32 s25, s25, 0
; GFX11-NEXT:    s_add_u32 s22, s22, 3
; GFX11-NEXT:    s_addc_u32 s23, s23, 0
; GFX11-NEXT:    s_add_u32 s20, s20, 3
; GFX11-NEXT:    s_addc_u32 s21, s21, 0
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB7_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_4:
; GFX11-NEXT:    s_branch .LBB7_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i64> %a, splat (i64 3)
  %a2 = bitcast <8 x i64> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i64> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define <8 x double> @bitcast_v16i32_to_v8f64(<16 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v16i32_to_v8f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB8_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB8_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i32_to_v8f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB8_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB8_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i32_to_v8f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB8_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB8_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i32_to_v8f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB8_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB8_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <8 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <8 x double>
  br label %end

end:
  %phi = phi <8 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x double> %phi
}

define inreg <8 x double> @bitcast_v16i32_to_v8f64_scalar(<16 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i32_to_v8f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_v16i32_to_v8f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_v16i32_to_v8f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_v16i32_to_v8f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX11-NEXT:  .LBB9_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB9_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_4:
; GFX11-NEXT:    s_branch .LBB9_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <8 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <8 x double>
  br label %end

end:
  %phi = phi <8 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x double> %phi
}

define <16 x i32> @bitcast_v8f64_to_v16i32(<8 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v8f64_to_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB10_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB10_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f64_to_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB10_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB10_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f64_to_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB10_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f64_to_v16i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB10_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <8 x double> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x double> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define inreg <16 x i32> @bitcast_v8f64_to_v16i32_scalar(<8 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f64_to_v16i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB11_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB11_3
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB11_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    s_branch .LBB11_2
;
; VI-LABEL: bitcast_v8f64_to_v16i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB11_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_3
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB11_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    s_branch .LBB11_2
;
; GFX9-LABEL: bitcast_v8f64_to_v16i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_3
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB11_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    s_branch .LBB11_2
;
; GFX11-LABEL: bitcast_v8f64_to_v16i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB11_4
; GFX11-NEXT:  .LBB11_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[14:15], s[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], s[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], s[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], s[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], s[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[12:13], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:    s_branch .LBB11_2
; GFX11-NEXT:  .LBB11_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <8 x double> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x double> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define <32 x i16> @bitcast_v16i32_to_v32i16(<16 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v16i32_to_v32i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v30, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v26, v13
; SI-NEXT:    v_mov_b32_e32 v24, v12
; SI-NEXT:    v_mov_b32_e32 v22, v11
; SI-NEXT:    v_mov_b32_e32 v20, v10
; SI-NEXT:    v_mov_b32_e32 v18, v9
; SI-NEXT:    v_mov_b32_e32 v32, v8
; SI-NEXT:    v_mov_b32_e32 v14, v7
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v8, v4
; SI-NEXT:    v_mov_b32_e32 v6, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v32, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB12_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v32, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB12_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v16, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i32_to_v32i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB12_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB12_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i32_to_v32i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB12_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB12_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i32_to_v32i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB12_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <32 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <32 x i16>
  br label %end

end:
  %phi = phi <32 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i16> %phi
}

define inreg <32 x i16> @bitcast_v16i32_to_v32i16_scalar(<16 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i32_to_v32i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    v_mov_b32_e32 v30, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v12, s22
; SI-NEXT:    v_mov_b32_e32 v14, s23
; SI-NEXT:    v_mov_b32_e32 v16, s24
; SI-NEXT:    v_mov_b32_e32 v18, s25
; SI-NEXT:    v_mov_b32_e32 v20, s26
; SI-NEXT:    v_mov_b32_e32 v22, s27
; SI-NEXT:    v_mov_b32_e32 v24, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v26, s29
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v16, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v16, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_v16i32_to_v32i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_v16i32_to_v32i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_v16i32_to_v32i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_3
; GFX11-NEXT:  .LBB13_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB13_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB13_4:
; GFX11-NEXT:    s_branch .LBB13_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <32 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <32 x i16>
  br label %end

end:
  %phi = phi <32 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i16> %phi
}

define <16 x i32> @bitcast_v32i16_to_v16i32(<32 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v32i16_to_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v31, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    v_mov_b32_e32 v38, v14
; SI-NEXT:    v_mov_b32_e32 v37, v12
; SI-NEXT:    v_mov_b32_e32 v36, v10
; SI-NEXT:    v_mov_b32_e32 v35, v8
; SI-NEXT:    v_mov_b32_e32 v34, v6
; SI-NEXT:    v_mov_b32_e32 v33, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v55, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v54, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v53, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v52, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v51, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v50, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v49, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v48, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v39, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v29
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v31
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v32
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v33
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v34
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v35
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v36
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v37
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v38
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v16
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v22
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v24
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v26
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v28
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v30
; SI-NEXT:    v_or_b32_e32 v0, v0, v42
; SI-NEXT:    v_or_b32_e32 v1, v1, v41
; SI-NEXT:    v_or_b32_e32 v2, v2, v40
; SI-NEXT:    v_or_b32_e32 v3, v3, v55
; SI-NEXT:    v_or_b32_e32 v4, v4, v54
; SI-NEXT:    v_or_b32_e32 v5, v5, v53
; SI-NEXT:    v_or_b32_e32 v6, v6, v52
; SI-NEXT:    v_or_b32_e32 v7, v7, v51
; SI-NEXT:    v_or_b32_e32 v8, v8, v50
; SI-NEXT:    v_or_b32_e32 v9, v9, v49
; SI-NEXT:    v_or_b32_e32 v10, v10, v48
; SI-NEXT:    v_or_b32_e32 v11, v11, v39
; SI-NEXT:    v_or_b32_e32 v12, v12, v23
; SI-NEXT:    v_or_b32_e32 v13, v13, v21
; SI-NEXT:    v_or_b32_e32 v14, v14, v19
; SI-NEXT:    v_or_b32_e32 v15, v15, v17
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:  .LBB14_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v33
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v34
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v35
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v36
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v37
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v38
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v30
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v41, v1
; SI-NEXT:    v_or_b32_e32 v2, v40, v2
; SI-NEXT:    v_or_b32_e32 v3, v55, v3
; SI-NEXT:    v_or_b32_e32 v4, v54, v4
; SI-NEXT:    v_or_b32_e32 v5, v53, v5
; SI-NEXT:    v_or_b32_e32 v6, v52, v6
; SI-NEXT:    v_or_b32_e32 v7, v51, v7
; SI-NEXT:    v_or_b32_e32 v8, v50, v8
; SI-NEXT:    v_or_b32_e32 v9, v49, v9
; SI-NEXT:    v_or_b32_e32 v10, v48, v10
; SI-NEXT:    v_or_b32_e32 v11, v39, v11
; SI-NEXT:    v_or_b32_e32 v12, v23, v12
; SI-NEXT:    v_or_b32_e32 v13, v21, v13
; SI-NEXT:    v_or_b32_e32 v14, v19, v14
; SI-NEXT:    v_or_b32_e32 v15, v17, v15
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v15
; SI-NEXT:  .LBB14_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i16_to_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v17, 3
; VI-NEXT:    v_add_u16_e32 v16, 3, v15
; VI-NEXT:    v_add_u16_sdwa v15, v15, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_u16_e32 v16, 3, v14
; VI-NEXT:    v_add_u16_sdwa v14, v14, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v16, v14
; VI-NEXT:    v_add_u16_e32 v16, 3, v13
; VI-NEXT:    v_add_u16_sdwa v13, v13, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v16, v13
; VI-NEXT:    v_add_u16_e32 v16, 3, v12
; VI-NEXT:    v_add_u16_sdwa v12, v12, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v16, v12
; VI-NEXT:    v_add_u16_e32 v16, 3, v11
; VI-NEXT:    v_add_u16_sdwa v11, v11, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v16, v11
; VI-NEXT:    v_add_u16_e32 v16, 3, v10
; VI-NEXT:    v_add_u16_sdwa v10, v10, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v16, v10
; VI-NEXT:    v_add_u16_e32 v16, 3, v9
; VI-NEXT:    v_add_u16_sdwa v9, v9, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v16, v9
; VI-NEXT:    v_add_u16_e32 v16, 3, v8
; VI-NEXT:    v_add_u16_sdwa v8, v8, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v8, v16, v8
; VI-NEXT:    v_add_u16_e32 v16, 3, v7
; VI-NEXT:    v_add_u16_sdwa v7, v7, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v16, v7
; VI-NEXT:    v_add_u16_e32 v16, 3, v6
; VI-NEXT:    v_add_u16_sdwa v6, v6, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v16, v6
; VI-NEXT:    v_add_u16_e32 v16, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v16, v5
; VI-NEXT:    v_add_u16_e32 v16, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v16, v4
; VI-NEXT:    v_add_u16_e32 v16, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v16, v3
; VI-NEXT:    v_add_u16_e32 v16, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v16, v2
; VI-NEXT:    v_add_u16_e32 v16, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v16, v1
; VI-NEXT:    v_add_u16_e32 v16, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v16, v0
; VI-NEXT:  .LBB14_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i16_to_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB14_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB14_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32i16_to_v16i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  .LBB14_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i16> %a, splat (i16 3)
  %a2 = bitcast <32 x i16> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i16> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define inreg <16 x i32> @bitcast_v32i16_to_v16i32_scalar(<32 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i16_to_v16i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v26, v14
; SI-NEXT:    v_mov_b32_e32 v25, v12
; SI-NEXT:    v_mov_b32_e32 v19, v10
; SI-NEXT:    v_mov_b32_e32 v20, v8
; SI-NEXT:    v_mov_b32_e32 v21, v6
; SI-NEXT:    v_mov_b32_e32 v22, v4
; SI-NEXT:    v_mov_b32_e32 v23, v2
; SI-NEXT:    v_mov_b32_e32 v24, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    s_cbranch_scc0 .LBB15_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v24
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    v_or_b32_e32 v7, v0, v33
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v22
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    v_or_b32_e32 v9, v0, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v21
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    v_or_b32_e32 v10, v0, v30
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v20
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    v_or_b32_e32 v11, v0, v29
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v19
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    v_or_b32_e32 v12, v0, v28
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v25
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    v_or_b32_e32 v13, v0, v27
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v26
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v23
; SI-NEXT:    v_or_b32_e32 v14, v0, v18
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v16
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_or_b32_e32 v8, v1, v32
; SI-NEXT:    v_or_b32_e32 v15, v0, v17
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB15_3
; SI-NEXT:  .LBB15_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v33, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v23
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v32, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v31, v0
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v21
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v30, v0
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v29, v0
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v19
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_or_b32_e32 v0, v28, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v25
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v26
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v16
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v17, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB15_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB15_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_branch .LBB15_2
;
; VI-LABEL: bitcast_v32i16_to_v16i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    v_readfirstlane_b32 s6, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v1
; VI-NEXT:    s_cbranch_scc0 .LBB15_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB15_3
; VI-NEXT:  .LBB15_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s7, 3
; VI-NEXT:    s_and_b32 s4, s7, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s6, 3
; VI-NEXT:    s_add_i32 s7, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s6, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s29, 3
; VI-NEXT:    s_add_i32 s6, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s29, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s28, 3
; VI-NEXT:    s_add_i32 s29, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s28, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s27, 3
; VI-NEXT:    s_add_i32 s28, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s27, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s26, 3
; VI-NEXT:    s_add_i32 s27, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s26, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s25, 3
; VI-NEXT:    s_add_i32 s26, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s25, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s24, 3
; VI-NEXT:    s_add_i32 s25, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s24, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s23, 3
; VI-NEXT:    s_add_i32 s24, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s22, 3
; VI-NEXT:    s_add_i32 s23, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_add_i32 s22, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB15_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    v_mov_b32_e32 v14, s6
; VI-NEXT:    v_mov_b32_e32 v15, s7
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB15_4:
; VI-NEXT:    s_branch .LBB15_2
;
; GFX9-LABEL: bitcast_v32i16_to_v16i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB15_3
; GFX9-NEXT:  .LBB15_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB15_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB15_4:
; GFX9-NEXT:    s_branch .LBB15_2
;
; GFX11-LABEL: bitcast_v32i16_to_v16i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB15_4
; GFX11-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v15, s27, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v14, s26, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v13, s25, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v12, s24, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v11, s23, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v10, s22, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v9, s21, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v8, s20, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v7, s19, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, s18, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, s17, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s16, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s15, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s14, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s13, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s12, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB15_3:
; GFX11-NEXT:    s_branch .LBB15_2
; GFX11-NEXT:  .LBB15_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i16> %a, splat (i16 3)
  %a2 = bitcast <32 x i16> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i16> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define <32 x half> @bitcast_v16i32_to_v32f16(<16 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v16i32_to_v32f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v32, v15
; SI-NEXT:    v_mov_b32_e32 v33, v14
; SI-NEXT:    v_mov_b32_e32 v34, v13
; SI-NEXT:    v_mov_b32_e32 v35, v12
; SI-NEXT:    v_mov_b32_e32 v36, v11
; SI-NEXT:    v_mov_b32_e32 v37, v10
; SI-NEXT:    v_mov_b32_e32 v38, v9
; SI-NEXT:    v_mov_b32_e32 v39, v8
; SI-NEXT:    v_mov_b32_e32 v48, v7
; SI-NEXT:    v_mov_b32_e32 v49, v6
; SI-NEXT:    v_mov_b32_e32 v50, v5
; SI-NEXT:    v_mov_b32_e32 v51, v4
; SI-NEXT:    v_mov_b32_e32 v52, v3
; SI-NEXT:    v_mov_b32_e32 v53, v2
; SI-NEXT:    v_mov_b32_e32 v54, v1
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_4
; SI-NEXT:  .LBB16_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB16_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v52
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v54
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v52
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v54
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v55
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_2
; SI-NEXT:  .LBB16_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v54
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v53
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v52
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v51
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v50
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v49
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v48
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v39
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v38
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v37
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v36
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v35
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v34
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v33
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v32
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v17, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i32_to_v32f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB16_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB16_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i32_to_v32f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB16_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB16_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i32_to_v32f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB16_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB16_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <32 x half>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <32 x half>
  br label %end

end:
  %phi = phi <32 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x half> %phi
}

define inreg <32 x half> @bitcast_v16i32_to_v32f16_scalar(<16 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i32_to_v32f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_readfirstlane_b32 s6, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s7, v1
; SI-NEXT:    s_cbranch_scc0 .LBB17_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s4
; SI-NEXT:    s_lshr_b32 s4, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s4
; SI-NEXT:    s_lshr_b32 s4, s29, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s4
; SI-NEXT:    s_lshr_b32 s4, s28, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s4
; SI-NEXT:    s_lshr_b32 s4, s27, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s4
; SI-NEXT:    s_lshr_b32 s4, s26, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s4
; SI-NEXT:    s_lshr_b32 s4, s25, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s4
; SI-NEXT:    s_lshr_b32 s4, s24, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s4
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB17_3
; SI-NEXT:  .LBB17_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    s_add_i32 s7, s7, 3
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    s_lshr_b32 s5, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s18, 16
; SI-NEXT:    s_lshr_b32 s9, s19, 16
; SI-NEXT:    s_lshr_b32 s10, s20, 16
; SI-NEXT:    s_lshr_b32 s11, s21, 16
; SI-NEXT:    s_lshr_b32 s12, s22, 16
; SI-NEXT:    s_lshr_b32 s13, s23, 16
; SI-NEXT:    s_lshr_b32 s14, s24, 16
; SI-NEXT:    s_lshr_b32 s15, s25, 16
; SI-NEXT:    s_lshr_b32 s40, s26, 16
; SI-NEXT:    s_lshr_b32 s41, s27, 16
; SI-NEXT:    s_lshr_b32 s42, s28, 16
; SI-NEXT:    s_lshr_b32 s43, s29, 16
; SI-NEXT:    s_lshr_b32 s44, s6, 16
; SI-NEXT:    s_lshr_b32 s45, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s45
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s44
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s43
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s42
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s41
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s40
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s12
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:  .LBB17_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB17_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_branch .LBB17_2
;
; VI-LABEL: bitcast_v16i32_to_v32f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB17_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB17_3
; VI-NEXT:  .LBB17_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB17_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB17_4:
; VI-NEXT:    s_branch .LBB17_2
;
; GFX9-LABEL: bitcast_v16i32_to_v32f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB17_3
; GFX9-NEXT:  .LBB17_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB17_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB17_4:
; GFX9-NEXT:    s_branch .LBB17_2
;
; GFX11-LABEL: bitcast_v16i32_to_v32f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB17_3
; GFX11-NEXT:  .LBB17_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB17_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB17_4:
; GFX11-NEXT:    s_branch .LBB17_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <32 x half>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <32 x half>
  br label %end

end:
  %phi = phi <32 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x half> %phi
}

define <16 x i32> @bitcast_v32f16_to_v16i32(<32 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v32f16_to_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:4
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v40, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v55, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v54, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v53, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v52, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v51, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v50, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v49, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v30
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v47
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v56
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v46
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v44
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v42
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v40
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v54
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v52
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v50
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v48
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v38
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v36
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v32
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_or_b32_e32 v1, v43, v1
; SI-NEXT:    v_or_b32_e32 v2, v41, v2
; SI-NEXT:    v_or_b32_e32 v3, v55, v3
; SI-NEXT:    v_or_b32_e32 v4, v53, v4
; SI-NEXT:    v_or_b32_e32 v5, v51, v5
; SI-NEXT:    v_or_b32_e32 v6, v49, v6
; SI-NEXT:    v_or_b32_e32 v7, v39, v7
; SI-NEXT:    v_or_b32_e32 v8, v37, v8
; SI-NEXT:    v_or_b32_e32 v9, v35, v9
; SI-NEXT:    v_or_b32_e32 v10, v33, v10
; SI-NEXT:    v_or_b32_e32 v11, v31, v11
; SI-NEXT:    v_or_b32_e32 v12, v22, v12
; SI-NEXT:    v_or_b32_e32 v13, v20, v13
; SI-NEXT:    v_or_b32_e32 v14, v18, v14
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:  .LBB18_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v44
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v45
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v43
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v41
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v40
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v55
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v53
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v54
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v52
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v50
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v49
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v39
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v38
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v36
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v35
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v33
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_or_b32_e32 v9, v11, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v32
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v23
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v22
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v20
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_or_b32_e32 v12, v14, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v19
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:  .LBB18_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32f16_to_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v16, 0x200
; VI-NEXT:    v_add_f16_sdwa v17, v15, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v15
; VI-NEXT:    v_or_b32_e32 v15, v15, v17
; VI-NEXT:    v_add_f16_sdwa v17, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v14
; VI-NEXT:    v_or_b32_e32 v14, v14, v17
; VI-NEXT:    v_add_f16_sdwa v17, v13, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v13
; VI-NEXT:    v_or_b32_e32 v13, v13, v17
; VI-NEXT:    v_add_f16_sdwa v17, v12, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v12
; VI-NEXT:    v_or_b32_e32 v12, v12, v17
; VI-NEXT:    v_add_f16_sdwa v17, v11, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v11
; VI-NEXT:    v_or_b32_e32 v11, v11, v17
; VI-NEXT:    v_add_f16_sdwa v17, v10, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v10
; VI-NEXT:    v_or_b32_e32 v10, v10, v17
; VI-NEXT:    v_add_f16_sdwa v17, v9, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v9
; VI-NEXT:    v_or_b32_e32 v9, v9, v17
; VI-NEXT:    v_add_f16_sdwa v17, v8, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v8
; VI-NEXT:    v_or_b32_e32 v8, v8, v17
; VI-NEXT:    v_add_f16_sdwa v17, v7, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v17
; VI-NEXT:    v_add_f16_sdwa v17, v6, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v17
; VI-NEXT:    v_add_f16_sdwa v17, v5, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v17
; VI-NEXT:    v_add_f16_sdwa v17, v4, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v17
; VI-NEXT:    v_add_f16_sdwa v17, v3, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v17
; VI-NEXT:    v_add_f16_sdwa v17, v2, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v17
; VI-NEXT:    v_add_f16_sdwa v17, v1, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v16, v0, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v17
; VI-NEXT:    v_or_b32_e32 v0, v0, v16
; VI-NEXT:  .LBB18_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32f16_to_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB18_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, v12, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, v11, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, v10, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB18_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32f16_to_v16i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB18_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  .LBB18_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <32 x half> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x half> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define inreg <16 x i32> @bitcast_v32f16_to_v16i32_scalar(<32 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32f16_to_v16i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f16_f32_e32 v51, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v50, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v40, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v55, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v54, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v53, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v52, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v49, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v48, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v39, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v38, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v37, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v36, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v35, s28
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB19_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v51
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v40
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v54
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v52
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v48
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v38
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v36
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v32
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v30
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v26
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v24
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v22
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v0, v50, v0
; SI-NEXT:    v_or_b32_e32 v1, v55, v1
; SI-NEXT:    v_or_b32_e32 v2, v53, v2
; SI-NEXT:    v_or_b32_e32 v3, v49, v3
; SI-NEXT:    v_or_b32_e32 v4, v39, v4
; SI-NEXT:    v_or_b32_e32 v5, v37, v5
; SI-NEXT:    v_or_b32_e32 v6, v35, v6
; SI-NEXT:    v_or_b32_e32 v7, v33, v7
; SI-NEXT:    v_or_b32_e32 v8, v31, v8
; SI-NEXT:    v_or_b32_e32 v9, v29, v9
; SI-NEXT:    v_or_b32_e32 v10, v27, v10
; SI-NEXT:    v_or_b32_e32 v11, v25, v11
; SI-NEXT:    v_or_b32_e32 v12, v23, v12
; SI-NEXT:    v_or_b32_e32 v13, v21, v13
; SI-NEXT:    v_or_b32_e32 v14, v19, v14
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    s_cbranch_execnz .LBB19_3
; SI-NEXT:  .LBB19_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v40
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v55
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v54
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v53
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v52
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v49
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v39
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v38
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v36
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v35
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v33
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v32
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v30
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v29
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v27
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_or_b32_e32 v9, v11, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v26
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v24
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v23
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v21
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_or_b32_e32 v12, v14, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v20
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:  .LBB19_3: ; %end
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB19_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_branch .LBB19_2
;
; VI-LABEL: bitcast_v32f16_to_v16i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB19_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB19_3
; VI-NEXT:  .LBB19_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v16, 0x200
; VI-NEXT:    v_add_f16_sdwa v17, v15, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v15
; VI-NEXT:    v_or_b32_e32 v15, v15, v17
; VI-NEXT:    v_add_f16_sdwa v17, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v14
; VI-NEXT:    v_or_b32_e32 v14, v14, v17
; VI-NEXT:    v_add_f16_sdwa v17, v13, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v13
; VI-NEXT:    v_or_b32_e32 v13, v13, v17
; VI-NEXT:    v_add_f16_sdwa v17, v12, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v12
; VI-NEXT:    v_or_b32_e32 v12, v12, v17
; VI-NEXT:    v_add_f16_sdwa v17, v11, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v11
; VI-NEXT:    v_or_b32_e32 v11, v11, v17
; VI-NEXT:    v_add_f16_sdwa v17, v10, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v10
; VI-NEXT:    v_or_b32_e32 v10, v10, v17
; VI-NEXT:    v_add_f16_sdwa v17, v9, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v9
; VI-NEXT:    v_or_b32_e32 v9, v9, v17
; VI-NEXT:    v_add_f16_sdwa v17, v8, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v8
; VI-NEXT:    v_or_b32_e32 v8, v8, v17
; VI-NEXT:    v_add_f16_sdwa v17, v7, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v17
; VI-NEXT:    v_add_f16_sdwa v17, v6, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v17
; VI-NEXT:    v_add_f16_sdwa v17, v5, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v17
; VI-NEXT:    v_add_f16_sdwa v17, v4, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v17
; VI-NEXT:    v_add_f16_sdwa v17, v3, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v17
; VI-NEXT:    v_add_f16_sdwa v17, v2, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v17
; VI-NEXT:    v_add_f16_sdwa v17, v1, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v16, v0, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v17
; VI-NEXT:    v_or_b32_e32 v0, v0, v16
; VI-NEXT:  .LBB19_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB19_4:
; VI-NEXT:    s_branch .LBB19_2
;
; GFX9-LABEL: bitcast_v32f16_to_v16i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB19_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB19_3
; GFX9-NEXT:  .LBB19_2: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s4, 0x200
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, v12, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, v11, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, v10, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s4 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB19_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB19_4:
; GFX9-NEXT:    s_branch .LBB19_2
;
; GFX11-LABEL: bitcast_v32f16_to_v16i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB19_4
; GFX11-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v15, 0x200, s27 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v14, 0x200, s26 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v13, 0x200, s25 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v12, 0x200, s24 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v11, 0x200, s23 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v10, 0x200, s22 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v9, 0x200, s21 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v8, 0x200, s20 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, s19 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, s18 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s17 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s16 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s15 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s14 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s13 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s12 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB19_3:
; GFX11-NEXT:    s_branch .LBB19_2
; GFX11-NEXT:  .LBB19_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <32 x half> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x half> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define <32 x bfloat> @bitcast_v16i32_to_v32bf16(<16 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v16i32_to_v32bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v55, v15
; SI-NEXT:    v_mov_b32_e32 v54, v14
; SI-NEXT:    v_mov_b32_e32 v53, v13
; SI-NEXT:    v_mov_b32_e32 v52, v12
; SI-NEXT:    v_mov_b32_e32 v51, v11
; SI-NEXT:    v_mov_b32_e32 v50, v10
; SI-NEXT:    v_mov_b32_e32 v49, v9
; SI-NEXT:    v_mov_b32_e32 v48, v8
; SI-NEXT:    v_mov_b32_e32 v39, v7
; SI-NEXT:    v_mov_b32_e32 v38, v6
; SI-NEXT:    v_mov_b32_e32 v37, v5
; SI-NEXT:    v_mov_b32_e32 v36, v4
; SI-NEXT:    v_mov_b32_e32 v35, v3
; SI-NEXT:    v_mov_b32_e32 v34, v2
; SI-NEXT:    v_mov_b32_e32 v33, v1
; SI-NEXT:    v_mov_b32_e32 v32, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_4
; SI-NEXT:  .LBB20_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB20_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v31, 0xffff0000, v55
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v55
; SI-NEXT:    v_and_b32_e32 v29, 0xffff0000, v54
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v54
; SI-NEXT:    v_and_b32_e32 v27, 0xffff0000, v53
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v53
; SI-NEXT:    v_and_b32_e32 v25, 0xffff0000, v52
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v52
; SI-NEXT:    v_and_b32_e32 v23, 0xffff0000, v51
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v51
; SI-NEXT:    v_and_b32_e32 v21, 0xffff0000, v50
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v50
; SI-NEXT:    v_and_b32_e32 v19, 0xffff0000, v49
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v49
; SI-NEXT:    v_and_b32_e32 v17, 0xffff0000, v48
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v48
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v39
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v39
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v38
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v38
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v37
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v37
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v36
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v36
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v35
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v35
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v34
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v34
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v33
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v32
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB20_2
; SI-NEXT:  .LBB20_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v33
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v34
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v35
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v36
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v37
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v38
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v39
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v48
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v49
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v50
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v51
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v52
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v53
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v54
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v55
; SI-NEXT:    v_and_b32_e32 v31, 0xffff0000, v15
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v15
; SI-NEXT:    v_and_b32_e32 v29, 0xffff0000, v14
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v14
; SI-NEXT:    v_and_b32_e32 v27, 0xffff0000, v13
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v13
; SI-NEXT:    v_and_b32_e32 v25, 0xffff0000, v12
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v12
; SI-NEXT:    v_and_b32_e32 v23, 0xffff0000, v11
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v11
; SI-NEXT:    v_and_b32_e32 v21, 0xffff0000, v10
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v10
; SI-NEXT:    v_and_b32_e32 v19, 0xffff0000, v9
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v9
; SI-NEXT:    v_and_b32_e32 v17, 0xffff0000, v8
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v8
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i32_to_v32bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB20_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB20_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i32_to_v32bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB20_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB20_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i32_to_v32bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB20_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB20_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <32 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <32 x bfloat>
  br label %end

end:
  %phi = phi <32 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x bfloat> %phi
}

define inreg <32 x bfloat> @bitcast_v16i32_to_v32bf16_scalar(<16 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i32_to_v32bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_readfirstlane_b32 s78, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s79, v1
; SI-NEXT:    s_cbranch_scc0 .LBB21_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s79, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s79, 16
; SI-NEXT:    s_and_b32 s8, s78, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s78, 16
; SI-NEXT:    s_and_b32 s10, s29, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_and_b32 s12, s28, 0xffff0000
; SI-NEXT:    s_lshl_b32 s13, s28, 16
; SI-NEXT:    s_and_b32 s14, s27, 0xffff0000
; SI-NEXT:    s_lshl_b32 s15, s27, 16
; SI-NEXT:    s_and_b32 s40, s26, 0xffff0000
; SI-NEXT:    s_lshl_b32 s41, s26, 16
; SI-NEXT:    s_and_b32 s42, s25, 0xffff0000
; SI-NEXT:    s_lshl_b32 s43, s25, 16
; SI-NEXT:    s_and_b32 s44, s24, 0xffff0000
; SI-NEXT:    s_lshl_b32 s45, s24, 16
; SI-NEXT:    s_and_b32 s46, s23, 0xffff0000
; SI-NEXT:    s_lshl_b32 s47, s23, 16
; SI-NEXT:    s_and_b32 s56, s22, 0xffff0000
; SI-NEXT:    s_lshl_b32 s57, s22, 16
; SI-NEXT:    s_and_b32 s58, s21, 0xffff0000
; SI-NEXT:    s_lshl_b32 s59, s21, 16
; SI-NEXT:    s_and_b32 s60, s20, 0xffff0000
; SI-NEXT:    s_lshl_b32 s61, s20, 16
; SI-NEXT:    s_and_b32 s62, s19, 0xffff0000
; SI-NEXT:    s_lshl_b32 s63, s19, 16
; SI-NEXT:    s_and_b32 s72, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s73, s18, 16
; SI-NEXT:    s_and_b32 s74, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s75, s17, 16
; SI-NEXT:    s_and_b32 s76, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s77, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB21_3
; SI-NEXT:  .LBB21_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s78, s78, 3
; SI-NEXT:    s_add_i32 s79, s79, 3
; SI-NEXT:    s_and_b32 s6, s79, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s79, 16
; SI-NEXT:    s_and_b32 s8, s78, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s78, 16
; SI-NEXT:    s_and_b32 s10, s29, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_and_b32 s12, s28, 0xffff0000
; SI-NEXT:    s_lshl_b32 s13, s28, 16
; SI-NEXT:    s_and_b32 s14, s27, 0xffff0000
; SI-NEXT:    s_lshl_b32 s15, s27, 16
; SI-NEXT:    s_and_b32 s40, s26, 0xffff0000
; SI-NEXT:    s_lshl_b32 s41, s26, 16
; SI-NEXT:    s_and_b32 s42, s25, 0xffff0000
; SI-NEXT:    s_lshl_b32 s43, s25, 16
; SI-NEXT:    s_and_b32 s44, s24, 0xffff0000
; SI-NEXT:    s_lshl_b32 s45, s24, 16
; SI-NEXT:    s_and_b32 s46, s23, 0xffff0000
; SI-NEXT:    s_lshl_b32 s47, s23, 16
; SI-NEXT:    s_and_b32 s56, s22, 0xffff0000
; SI-NEXT:    s_lshl_b32 s57, s22, 16
; SI-NEXT:    s_and_b32 s58, s21, 0xffff0000
; SI-NEXT:    s_lshl_b32 s59, s21, 16
; SI-NEXT:    s_and_b32 s60, s20, 0xffff0000
; SI-NEXT:    s_lshl_b32 s61, s20, 16
; SI-NEXT:    s_and_b32 s62, s19, 0xffff0000
; SI-NEXT:    s_lshl_b32 s63, s19, 16
; SI-NEXT:    s_and_b32 s72, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s73, s18, 16
; SI-NEXT:    s_and_b32 s74, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s75, s17, 16
; SI-NEXT:    s_and_b32 s76, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s77, s16, 16
; SI-NEXT:  .LBB21_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s77
; SI-NEXT:    v_mov_b32_e32 v1, s76
; SI-NEXT:    v_mov_b32_e32 v2, s75
; SI-NEXT:    v_mov_b32_e32 v3, s74
; SI-NEXT:    v_mov_b32_e32 v4, s73
; SI-NEXT:    v_mov_b32_e32 v5, s72
; SI-NEXT:    v_mov_b32_e32 v6, s63
; SI-NEXT:    v_mov_b32_e32 v7, s62
; SI-NEXT:    v_mov_b32_e32 v8, s61
; SI-NEXT:    v_mov_b32_e32 v9, s60
; SI-NEXT:    v_mov_b32_e32 v10, s59
; SI-NEXT:    v_mov_b32_e32 v11, s58
; SI-NEXT:    v_mov_b32_e32 v12, s57
; SI-NEXT:    v_mov_b32_e32 v13, s56
; SI-NEXT:    v_mov_b32_e32 v14, s47
; SI-NEXT:    v_mov_b32_e32 v15, s46
; SI-NEXT:    v_mov_b32_e32 v16, s45
; SI-NEXT:    v_mov_b32_e32 v17, s44
; SI-NEXT:    v_mov_b32_e32 v18, s43
; SI-NEXT:    v_mov_b32_e32 v19, s42
; SI-NEXT:    v_mov_b32_e32 v20, s41
; SI-NEXT:    v_mov_b32_e32 v21, s40
; SI-NEXT:    v_mov_b32_e32 v22, s15
; SI-NEXT:    v_mov_b32_e32 v23, s14
; SI-NEXT:    v_mov_b32_e32 v24, s13
; SI-NEXT:    v_mov_b32_e32 v25, s12
; SI-NEXT:    v_mov_b32_e32 v26, s11
; SI-NEXT:    v_mov_b32_e32 v27, s10
; SI-NEXT:    v_mov_b32_e32 v28, s9
; SI-NEXT:    v_mov_b32_e32 v29, s8
; SI-NEXT:    v_mov_b32_e32 v30, s7
; SI-NEXT:    v_mov_b32_e32 v31, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB21_4:
; SI-NEXT:    ; implicit-def: $sgpr77
; SI-NEXT:    ; implicit-def: $sgpr76
; SI-NEXT:    ; implicit-def: $sgpr75
; SI-NEXT:    ; implicit-def: $sgpr74
; SI-NEXT:    ; implicit-def: $sgpr73
; SI-NEXT:    ; implicit-def: $sgpr72
; SI-NEXT:    ; implicit-def: $sgpr63
; SI-NEXT:    ; implicit-def: $sgpr62
; SI-NEXT:    ; implicit-def: $sgpr61
; SI-NEXT:    ; implicit-def: $sgpr60
; SI-NEXT:    ; implicit-def: $sgpr59
; SI-NEXT:    ; implicit-def: $sgpr58
; SI-NEXT:    ; implicit-def: $sgpr57
; SI-NEXT:    ; implicit-def: $sgpr56
; SI-NEXT:    ; implicit-def: $sgpr47
; SI-NEXT:    ; implicit-def: $sgpr46
; SI-NEXT:    ; implicit-def: $sgpr45
; SI-NEXT:    ; implicit-def: $sgpr44
; SI-NEXT:    ; implicit-def: $sgpr43
; SI-NEXT:    ; implicit-def: $sgpr42
; SI-NEXT:    ; implicit-def: $sgpr41
; SI-NEXT:    ; implicit-def: $sgpr40
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB21_2
;
; VI-LABEL: bitcast_v16i32_to_v32bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB21_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB21_3
; VI-NEXT:  .LBB21_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB21_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB21_4:
; VI-NEXT:    s_branch .LBB21_2
;
; GFX9-LABEL: bitcast_v16i32_to_v32bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB21_3
; GFX9-NEXT:  .LBB21_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB21_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB21_4:
; GFX9-NEXT:    s_branch .LBB21_2
;
; GFX11-LABEL: bitcast_v16i32_to_v32bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB21_3
; GFX11-NEXT:  .LBB21_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB21_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB21_4:
; GFX11-NEXT:    s_branch .LBB21_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <32 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <32 x bfloat>
  br label %end

end:
  %phi = phi <32 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x bfloat> %phi
}

define <16 x i32> @bitcast_v32bf16_to_v16i32(<32 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v32bf16_to_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32
; SI-NEXT:    v_mul_f32_e32 v45, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v46, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v43, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v44, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v41, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v42, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v55, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v40, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v53, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v54, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v51, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v52, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v49, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v50, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v39, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v48, 1.0, v14
; SI-NEXT:    v_mul_f32_e32 v37, 1.0, v17
; SI-NEXT:    v_mul_f32_e32 v38, 1.0, v16
; SI-NEXT:    v_mul_f32_e32 v35, 1.0, v19
; SI-NEXT:    v_mul_f32_e32 v36, 1.0, v18
; SI-NEXT:    v_mul_f32_e32 v33, 1.0, v21
; SI-NEXT:    v_mul_f32_e32 v34, 1.0, v20
; SI-NEXT:    v_mul_f32_e32 v31, 1.0, v23
; SI-NEXT:    v_mul_f32_e32 v32, 1.0, v22
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v25
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v24
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v27
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v26
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v29
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v28
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v30
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v47
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v56
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB22_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v45
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v43
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v41
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v55
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v53
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v51
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v49
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v39
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v37
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v35
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v33
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v31
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v16
; SI-NEXT:    v_alignbit_b32 v0, v0, v46, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v44, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v42, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v40, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v54, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v52, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v50, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v48, 16
; SI-NEXT:    v_alignbit_b32 v8, v8, v38, 16
; SI-NEXT:    v_alignbit_b32 v9, v9, v36, 16
; SI-NEXT:    v_alignbit_b32 v10, v10, v34, 16
; SI-NEXT:    v_alignbit_b32 v11, v11, v32, 16
; SI-NEXT:    v_alignbit_b32 v12, v12, v23, 16
; SI-NEXT:    v_alignbit_b32 v13, v13, v21, 16
; SI-NEXT:    v_alignbit_b32 v14, v14, v19, 16
; SI-NEXT:    v_alignbit_b32 v15, v15, v18, 16
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:  .LBB22_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB22_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v45
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v46
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v44
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v41
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v42
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v55
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v40
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v53
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v54
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v51
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v52
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v49
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v50
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v39
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v48
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v37
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v38
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v35
; SI-NEXT:    v_alignbit_b32 v8, v9, v8, 16
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v36
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v33
; SI-NEXT:    v_alignbit_b32 v9, v10, v9, 16
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v34
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v31
; SI-NEXT:    v_alignbit_b32 v10, v11, v10, 16
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v32
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v22
; SI-NEXT:    v_alignbit_b32 v11, v12, v11, 16
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v12, v13, v12, 16
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v17
; SI-NEXT:    v_alignbit_b32 v13, v14, v13, 16
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_and_b32_e32 v16, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v14, v15, v14, 16
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v18
; SI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_lshrrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_alignbit_b32 v15, v16, v15, 16
; SI-NEXT:  .LBB22_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32bf16_to_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB22_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v15
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x7fff, v17
; VI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v15, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v15
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v15
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; VI-NEXT:    v_cndmask_b32_e32 v15, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v15, 16, v15
; VI-NEXT:    v_alignbit_b32 v15, v15, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v14
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v14, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v14
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v14
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; VI-NEXT:    v_cndmask_b32_e32 v14, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; VI-NEXT:    v_alignbit_b32 v14, v14, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v13
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v13, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v13
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v13
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; VI-NEXT:    v_cndmask_b32_e32 v13, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v13, 16, v13
; VI-NEXT:    v_alignbit_b32 v13, v13, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v12
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v12, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v12
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v12
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; VI-NEXT:    v_cndmask_b32_e32 v12, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; VI-NEXT:    v_alignbit_b32 v12, v12, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v11, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v11
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v11
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; VI-NEXT:    v_cndmask_b32_e32 v11, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; VI-NEXT:    v_alignbit_b32 v11, v11, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v10
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v10, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v10
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v10
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; VI-NEXT:    v_cndmask_b32_e32 v10, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; VI-NEXT:    v_alignbit_b32 v10, v10, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v9
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v9, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v9
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v9
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; VI-NEXT:    v_cndmask_b32_e32 v9, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; VI-NEXT:    v_alignbit_b32 v9, v9, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v8
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v8
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_cndmask_b32_e32 v8, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; VI-NEXT:    v_alignbit_b32 v8, v8, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v7
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v7, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v7
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v7
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; VI-NEXT:    v_cndmask_b32_e32 v7, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; VI-NEXT:    v_alignbit_b32 v7, v7, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v6
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v6, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v6
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v6
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; VI-NEXT:    v_cndmask_b32_e32 v6, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_alignbit_b32 v6, v6, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v5
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_cndmask_b32_e32 v5, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; VI-NEXT:    v_alignbit_b32 v5, v5, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v4
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v4
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_cndmask_b32_e32 v4, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; VI-NEXT:    v_alignbit_b32 v4, v4, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v3
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v3
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_alignbit_b32 v3, v3, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v2
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v2
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v1
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v1
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v0
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v0
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x7fff, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v16, 16
; VI-NEXT:  .LBB22_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32bf16_to_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v15
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v15, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v15, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v15
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX9-NEXT:    v_cndmask_b32_e32 v15, v17, v18, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v15, v15, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v14
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v14, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v14, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v14
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX9-NEXT:    v_cndmask_b32_e32 v14, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v14, v14, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v13
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v13, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v13, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v13
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX9-NEXT:    v_cndmask_b32_e32 v13, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v13, v13, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v12
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v12, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v12, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v12
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX9-NEXT:    v_cndmask_b32_e32 v12, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v12, v12, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v11, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v11, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v11
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v11, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v11, v11, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v10
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v10, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v10, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v10
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v10, v10, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v9
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v9, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v9, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v9, v9, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v8
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v8, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v8, v8, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v7
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v7, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v7, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v7
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v7, v7, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v6
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v6, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v6, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v6
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v6, v6, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v5, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v5, v5, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v4, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v4, v4, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v3
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v3, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v3, v3, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v2, v2, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v1
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v1, v1, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v0, v0, v16, s7
; GFX9-NEXT:  .LBB22_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v32bf16_to_v16i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff0000, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v15, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v15
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v20, v20, v15, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v15, v20, v22 :: v_dual_add_f32 v16, 0x40c00000, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v15.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v16, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v16
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v16, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v16, v19, v21 :: v_dual_and_b32 v17, 0xffff0000, v14
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v17, 0x40c00000, v17 :: v_dual_lshlrev_b32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_bfi_b32 v15, 0xffff, v15, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_bfe_u32 v23, v17, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v24, 0x400000, v17
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v25, v14, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v26, 0x400000, v14
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-TRUE16-NEXT:    v_add3_u32 v20, v23, v17, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v22, v25, v14, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v14, v22, v26, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v17, v20, v24 :: v_dual_and_b32 v18, 0xffff0000, v13
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v18 :: v_dual_lshlrev_b32 v13, 16, v13
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v14.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v18, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v18
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v13, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v13
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-TRUE16-NEXT:    v_bfi_b32 v14, 0xffff, v14, v17
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v19, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v13, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v13, v16, v20 :: v_dual_and_b32 v20, 0xffff0000, v11
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff0000, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v13.h
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v20
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v17, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v19, 0x40c00000, v19 :: v_dual_lshlrev_b32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v23, 0x400000, v20
; GFX11-TRUE16-NEXT:    v_bfi_b32 v13, 0xffff, v13, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v18, v12, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v12
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v19, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v18, v12, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v12, v18, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v18, v20, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v17, v17, v22, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v11
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v18, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v11, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_bfi_b32 v12, 0xffff, v12, v17
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v11.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v18, v18, v23, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v19
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v11, 0xffff, v11, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v18, 0xffff0000, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v20, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_lshlrev_b32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v10, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v10, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v10, v16, v20, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v9, 16, 1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v17, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v18, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v9, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v9
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v20
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v9, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v20, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v23, 0x400000, v20
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v9.h
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v17, v17, v22 :: v_dual_and_b32 v22, 0xffff0000, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v19, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_bfi_b32 v9, 0xffff, v9, v17
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 0x40c00000, v7 :: v_dual_add_f32 v8, 0x40c00000, v8
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v8, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v8, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v8, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_bfi_b32 v10, 0xffff, v10, v16
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v7, 16, 1
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v18, v18, v23 :: v_dual_and_b32 v23, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v8.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v19, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v7, 0x7fff
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_bfi_b32 v8, 0xffff, v8, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v18, 0xffff0000, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v20, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v6, 0x40c00000, v6 :: v_dual_cndmask_b32 v7, v16, v20
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v6, 16, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v17, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v18, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v6, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v6
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v20, 0x40c00000, v20 :: v_dual_add_f32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v7.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v6, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v20, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    v_bfi_b32 v7, 0xffff, v7, v16
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v6.h
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v19, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v17, v17, v22, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v5
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v20
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v6, 0xffff, v6, v17
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v4, 16, 1
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v18, v18, v22, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_bfi_b32 v5, 0xffff, v5, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v18, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v17, v20, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v18 :: v_dual_add_f32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v16, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v18, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v18
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v20, v20, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfe_u32 v23, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v4.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v20, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v23, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v17, v17, v22 :: v_dual_and_b32 v22, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfi_b32 v4, 0xffff, v4, v16
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v21, 0x40c00000, v22 :: v_dual_cndmask_b32 v18, v18, v20
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v24, 0x400000, v21
; GFX11-TRUE16-NEXT:    v_bfi_b32 v3, 0xffff, v3, v17
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v19, v20, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_bfe_u32 v22, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v25, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v21, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v23, v20, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v22, v22, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v27, 0x400000, v20
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v21, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v23, v23, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v22, v25, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_bfe_u32 v26, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v25, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v20, v23, v27, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v21, v21
; GFX11-TRUE16-NEXT:    v_add3_u32 v22, v26, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v2, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v20.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v19, v19, v24, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v19
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v22, v25, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v20, v0
; GFX11-TRUE16-NEXT:  .LBB22_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v32bf16_to_v16i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 0x40c00000, v17 :: v_dual_add_f32 v16, 0x40c00000, v16
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v17, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v16, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, 0x400000, v16
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v23, v14, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v21, v17, 0x7fff
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v16, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v23, v14, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, 0x400000, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; GFX11-FAKE16-NEXT:    v_bfe_u32 v20, v15, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v15
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v20, v20, v15, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v20, v22 :: v_dual_lshlrev_b32 v20, 16, v13
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v15, v16, 0x7060302
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v17, v21, v18 :: v_dual_add_f32 v18, 0x40c00000, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v14
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v19, v22 :: v_dual_lshlrev_b32 v19, 16, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v14, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v13, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 0x40c00000, v19 :: v_dual_cndmask_b32 v16, v16, v20
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v13, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v11
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v13, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v21
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v20, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v12, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v12, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v18, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v12, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v11, 16, 1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v11, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v19, v10, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v16, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v19, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v10
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v11, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v19, v22 :: v_dual_lshlrev_b32 v21, 16, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v21 :: v_dual_lshlrev_b32 v19, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v10, v17, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 0x40c00000, v19 :: v_dual_add_f32 v8, 0x40c00000, v8
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v8, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v20 :: v_dual_add_f32 v9, 0x40c00000, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v8, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v9, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v8
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v9, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v18, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v8, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v18 :: v_dual_add_f32 v19, 0x40c00000, v21
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v18, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_bfe_u32 v19, v6, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v20 :: v_dual_add_f32 v7, 0x40c00000, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v19, v6, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v7, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v7, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v6
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v21 :: v_dual_cndmask_b32 v17, v17, v20
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v20, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v19, v22 :: v_dual_lshlrev_b32 v19, 16, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v7, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v6, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v17, 0x40c00000, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v20, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v17, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v19, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, 0x400000, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v16, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v22, v17, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v5, v18, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v4, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v16, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v4, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 0x40c00000, v20 :: v_dual_lshlrev_b32 v20, 16, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v18, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v17, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v17
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v4, v16, 0x7060302
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v21, v17, 0x7fff
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v19, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v21, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v22, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v24, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v19, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-FAKE16-NEXT:    v_add3_u32 v20, v24, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v3, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v21, v23, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v20, v21 :: v_dual_lshlrev_b32 v23, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v22, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v23
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v2, v18, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v19, v21, v22 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v24, v20, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, 0x400000, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v24, v24, v20, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v21, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v23, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v22, v23, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, 0x400000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v22, v23, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v1, v19, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v24, v25, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v21, v26, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v20, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB22_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <32 x bfloat> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x bfloat> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define inreg <16 x i32> @bitcast_v32bf16_to_v16i32_scalar(<32 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32bf16_to_v16i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mul_f32_e64 v34, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v35, 1.0, s16
; SI-NEXT:    v_mul_f32_e32 v32, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v33, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v30, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v31, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v28, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v29, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v26, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v27, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v24, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v25, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v14
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_mul_f32_e64 v54, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v55, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v52, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v53, 1.0, s20
; SI-NEXT:    v_mul_f32_e64 v50, 1.0, s23
; SI-NEXT:    v_mul_f32_e64 v51, 1.0, s22
; SI-NEXT:    v_mul_f32_e64 v48, 1.0, s25
; SI-NEXT:    v_mul_f32_e64 v49, 1.0, s24
; SI-NEXT:    v_mul_f32_e64 v38, 1.0, s27
; SI-NEXT:    v_mul_f32_e64 v39, 1.0, s26
; SI-NEXT:    v_mul_f32_e64 v36, 1.0, s29
; SI-NEXT:    v_mul_f32_e64 v37, 1.0, s28
; SI-NEXT:    s_cbranch_scc0 .LBB23_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v54
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v52
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v50
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v48
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v38
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v36
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v32
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_alignbit_b32 v0, v0, v35, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v55, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v53, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v51, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v49, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v39, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v37, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v33, 16
; SI-NEXT:    v_alignbit_b32 v8, v8, v31, 16
; SI-NEXT:    v_alignbit_b32 v9, v9, v29, 16
; SI-NEXT:    v_alignbit_b32 v10, v10, v27, 16
; SI-NEXT:    v_alignbit_b32 v11, v11, v25, 16
; SI-NEXT:    v_alignbit_b32 v12, v12, v23, 16
; SI-NEXT:    v_alignbit_b32 v13, v13, v21, 16
; SI-NEXT:    v_alignbit_b32 v14, v14, v19, 16
; SI-NEXT:    v_alignbit_b32 v15, v15, v16, 16
; SI-NEXT:    s_cbranch_execnz .LBB23_3
; SI-NEXT:  .LBB23_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v34
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v35
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v54
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v55
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v52
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v53
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v50
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v51
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v48
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v49
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v38
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v39
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v36
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v37
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v32
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v33
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v30
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v31
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v28
; SI-NEXT:    v_alignbit_b32 v8, v9, v8, 16
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v29
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v26
; SI-NEXT:    v_alignbit_b32 v9, v10, v9, 16
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v27
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v24
; SI-NEXT:    v_alignbit_b32 v10, v11, v10, 16
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v25
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v22
; SI-NEXT:    v_alignbit_b32 v11, v12, v11, 16
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v12, v13, v12, 16
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v13, v14, v13, 16
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_alignbit_b32 v14, v15, v14, 16
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v16
; SI-NEXT:    v_and_b32_e32 v16, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_lshrrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_alignbit_b32 v15, v16, v15, 16
; SI-NEXT:  .LBB23_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB23_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_branch .LBB23_2
;
; VI-LABEL: bitcast_v32bf16_to_v16i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    v_writelane_b32 v19, s30, 0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    v_writelane_b32 v19, s31, 1
; VI-NEXT:    v_readfirstlane_b32 s30, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s31, v1
; VI-NEXT:    s_cbranch_scc0 .LBB23_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB23_4
; VI-NEXT:  .LBB23_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s31, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s31, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    s_lshl_b32 s4, s30, 16
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_add_f32_e32 v3, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    s_and_b32 s4, s30, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_add_f32_e32 v4, s4, v0
; VI-NEXT:    v_bfe_u32 v5, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v4
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_alignbit_b32 v15, v2, v1, 16
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    s_lshl_b32 s4, s29, 16
; VI-NEXT:    v_alignbit_b32 v14, v1, v3, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s29, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s28, 16
; VI-NEXT:    v_alignbit_b32 v13, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s28, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s27, 16
; VI-NEXT:    v_alignbit_b32 v12, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s27, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s26, 16
; VI-NEXT:    v_alignbit_b32 v11, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s26, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s25, 16
; VI-NEXT:    v_alignbit_b32 v10, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s25, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s24, 16
; VI-NEXT:    v_alignbit_b32 v9, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s24, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s23, 16
; VI-NEXT:    v_alignbit_b32 v8, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s22, 16
; VI-NEXT:    v_alignbit_b32 v7, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s21, 16
; VI-NEXT:    v_alignbit_b32 v6, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s20, 16
; VI-NEXT:    v_alignbit_b32 v5, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s19, 16
; VI-NEXT:    v_alignbit_b32 v4, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v16, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v16, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_alignbit_b32 v3, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v16, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v16, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v16, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v16, vcc, v16, v2
; VI-NEXT:    v_add_u32_e32 v16, vcc, 0x7fff, v16
; VI-NEXT:    v_or_b32_e32 v17, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v16, v17, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_alignbit_b32 v2, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v16, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v16, vcc, v16, v1
; VI-NEXT:    v_add_u32_e32 v16, vcc, 0x7fff, v16
; VI-NEXT:    v_or_b32_e32 v17, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v16, v17, vcc
; VI-NEXT:    v_add_f32_e32 v16, s4, v0
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x7fff, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v16, 16, v16
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v16, v1, 16
; VI-NEXT:    v_add_f32_e32 v16, s4, v0
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x7fff, v17
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v0
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x7fff, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v16, 16
; VI-NEXT:    s_branch .LBB23_5
; VI-NEXT:  .LBB23_3:
; VI-NEXT:    s_branch .LBB23_2
; VI-NEXT:  .LBB23_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    v_mov_b32_e32 v14, s30
; VI-NEXT:    v_mov_b32_e32 v15, s31
; VI-NEXT:  .LBB23_5: ; %end
; VI-NEXT:    v_readlane_b32 s31, v19, 1
; VI-NEXT:    v_readlane_b32 s30, v19, 0
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32bf16_to_v16i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    buffer_store_dword v20, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    v_writelane_b32 v20, s30, 0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    v_writelane_b32 v20, s31, 1
; GFX9-NEXT:    v_readfirstlane_b32 s30, v0
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s31, v1
; GFX9-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB23_4
; GFX9-NEXT:  .LBB23_2: ; %cmp.true
; GFX9-NEXT:    s_and_b32 s4, s31, 0xffff0000
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s31, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    s_and_b32 s4, s30, 0xffff0000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_add_f32_e32 v3, s4, v0
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v3
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    s_lshl_b32 s4, s30, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_add_f32_e32 v4, s4, v0
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v4
; GFX9-NEXT:    v_mov_b32_e32 v16, 0xffff
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_lshl_or_b32 v15, v1, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s29, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v14, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s29, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s28, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v13, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s28, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s27, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v12, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s27, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s26, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v11, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s26, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s25, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v10, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s25, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s24, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v9, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s24, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s23, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v8, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s23, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s22, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v7, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s22, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s21, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v6, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s21, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s20, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v5, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s20, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s19, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v4, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s19, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v17, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v17, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s18, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v3, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v17, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v17, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v17, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v17, v17, v2
; GFX9-NEXT:    v_add_u32_e32 v17, 0x7fff, v17
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v17, v18, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v16, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s17, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v2, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v17, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v17, v17, v1
; GFX9-NEXT:    v_add_u32_e32 v17, 0x7fff, v17
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; GFX9-NEXT:    v_add_f32_e32 v17, s4, v0
; GFX9-NEXT:    v_bfe_u32 v18, v17, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v18, v18, v17
; GFX9-NEXT:    v_add_u32_e32 v18, 0x7fff, v18
; GFX9-NEXT:    v_or_b32_e32 v19, 0x400000, v17
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX9-NEXT:    v_cndmask_b32_e32 v17, v18, v19, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v17, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s16, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v17
; GFX9-NEXT:    v_add_f32_e32 v17, s4, v0
; GFX9-NEXT:    v_bfe_u32 v18, v17, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v18, v18, v17
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v18, 0x7fff, v18
; GFX9-NEXT:    v_or_b32_e32 v19, 0x400000, v17
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v17, v18, v19, vcc
; GFX9-NEXT:    v_bfe_u32 v18, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v18, v18, v0
; GFX9-NEXT:    v_add_u32_e32 v18, 0x7fff, v18
; GFX9-NEXT:    v_or_b32_e32 v19, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v17
; GFX9-NEXT:    v_cndmask_b32_e32 v17, v18, v19, vcc
; GFX9-NEXT:    v_and_b32_sdwa v16, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v16
; GFX9-NEXT:    s_branch .LBB23_5
; GFX9-NEXT:  .LBB23_3:
; GFX9-NEXT:    s_branch .LBB23_2
; GFX9-NEXT:  .LBB23_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    v_mov_b32_e32 v14, s30
; GFX9-NEXT:    v_mov_b32_e32 v15, s31
; GFX9-NEXT:  .LBB23_5: ; %end
; GFX9-NEXT:    v_readlane_b32 s31, v20, 1
; GFX9-NEXT:    v_readlane_b32 s30, v20, 0
; GFX9-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32bf16_to_v16i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB23_4
; GFX11-NEXT:  .LBB23_2: ; %cmp.true
; GFX11-NEXT:    s_and_b32 s1, s27, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s0, s27, 16
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s1
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s0
; GFX11-NEXT:    s_and_b32 s0, s26, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s2, s26, 16
; GFX11-NEXT:    v_add_f32_e64 v3, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s2
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_bfe_u32 v9, v3, 16, 1
; GFX11-NEXT:    v_bfe_u32 v10, v5, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_and_b32 s1, s25, 0xffff0000
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s3, s25, 16
; GFX11-NEXT:    s_and_b32 s0, s24, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s1, s24, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v8, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v9, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v10, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v7 :: v_dual_add_nc_u32 v2, 0x7fff, v2
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 0x7fff, v8
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s3
; GFX11-NEXT:    v_bfe_u32 v5, v6, 16, 1
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v7, v4, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_bfe_u32 v7, v8, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshl_or_b32 v15, v1, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v9, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v5, v6
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v7, v8
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v8
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s1, s23, 16
; GFX11-NEXT:    v_lshl_or_b32 v14, v0, 16, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v5
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v8, v7, 16, 1
; GFX11-NEXT:    s_and_b32 s0, s23, 0xffff0000
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v4, v5, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v6, v8, v7
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v9, vcc_lo
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    s_lshl_b32 s1, s22, 16
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v4
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v6
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v7
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v7, v8, 16, 1
; GFX11-NEXT:    s_and_b32 s0, s22, 0xffff0000
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v4, v6, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v7, v8
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v6
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v9, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v13, v0, 16, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v4
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v8
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s0
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_bfe_u32 v8, v7, 16, 1
; GFX11-NEXT:    s_and_b32 s0, s21, 0xffff0000
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v4, v5, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v6, v8, v7
; GFX11-NEXT:    s_lshl_b32 s1, s21, 16
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v9, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v12, v0, 16, v1
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v4
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v7
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_bfe_u32 v7, v8, 16, 1
; GFX11-NEXT:    s_and_b32 s0, s20, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s1, s20, 16
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v4, v6, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v7, v8
; GFX11-NEXT:    v_lshl_or_b32 v11, v0, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v6
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v9, vcc_lo
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v4
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v8
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s0
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_bfe_u32 v8, v7, 16, 1
; GFX11-NEXT:    v_lshl_or_b32 v10, v0, 16, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v4, v5, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v8, v7
; GFX11-NEXT:    s_lshl_b32 s0, s19, 16
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v9, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x7fff, v0
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v7
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v4
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s0
; GFX11-NEXT:    s_and_b32 s0, s19, 0xffff0000
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc_lo
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_bfe_u32 v16, v4, 16, 1
; GFX11-NEXT:    s_and_b32 s0, s18, 0xffff0000
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_bfe_u32 v6, v8, 16, 1
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v9, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v16, v4
; GFX11-NEXT:    v_lshl_or_b32 v9, v1, 16, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v6, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v5
; GFX11-NEXT:    v_or_b32_e32 v5, 0x400000, v4
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s0
; GFX11-NEXT:    s_lshl_b32 s1, s18, 16
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s0, s17, 16
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_lshl_or_b32 v8, v2, 16, v0
; GFX11-NEXT:    s_and_b32 s1, s17, 0xffff0000
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v6, v4
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s0
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v7, v5
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s1
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_or_b32_e32 v16, 0x400000, v4
; GFX11-NEXT:    v_bfe_u32 v17, v6, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_or_b32_e32 v18, 0x400000, v5
; GFX11-NEXT:    v_bfe_u32 v19, v7, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v17, v6
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v16, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_or_b32_e32 v16, 0x400000, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v19, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_lshl_b32 s1, s16, 16
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v18, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 0x7fff, v5
; GFX11-NEXT:    v_or_b32_e32 v17, 0x400000, v7
; GFX11-NEXT:    v_add_f32_e64 v18, 0x40c00000, s1
; GFX11-NEXT:    s_and_b32 s0, s16, 0xffff0000
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v4, v16, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_f32_e64 v16, 0x40c00000, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v5, v17, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v17, v18, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v16, 16, 1
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshl_or_b32 v7, v0, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v17, v18
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v19, v6, v16
; GFX11-NEXT:    v_lshl_or_b32 v6, v2, 16, v3
; GFX11-NEXT:    v_or_b32_e32 v3, 0x400000, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x7fff, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-NEXT:    s_and_b32 s0, s15, 0xffff0000
; GFX11-NEXT:    v_lshl_or_b32 v5, v5, 16, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v19
; GFX11-NEXT:    v_or_b32_e32 v2, 0x400000, v16
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-NEXT:    s_lshl_b32 s1, s15, 16
; GFX11-NEXT:    s_and_b32 s0, s14, 0xffff0000
; GFX11-NEXT:    v_add_f32_e64 v17, 0x40c00000, s1
; GFX11-NEXT:    v_add_f32_e64 v16, 0x40c00000, s0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v2, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v19, 0x400000, v4
; GFX11-NEXT:    v_bfe_u32 v3, v17, 16, 1
; GFX11-NEXT:    v_bfe_u32 v18, v16, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v4
; GFX11-NEXT:    s_lshl_b32 s0, s14, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v17
; GFX11-NEXT:    v_or_b32_e32 v20, 0x400000, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v18, v18, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s0
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    s_and_b32 s0, s13, 0xffff0000
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v19, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 0x7fff, v18
; GFX11-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX11-NEXT:    v_bfe_u32 v19, v4, 16, 1
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v20, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_dual_cndmask_b32 v16, v17, v18 :: v_dual_add_nc_u32 v17, v19, v4
; GFX11-NEXT:    v_add_f32_e64 v18, 0x40c00000, s0
; GFX11-NEXT:    s_lshl_b32 s0, s13, 16
; GFX11-NEXT:    v_or_b32_e32 v19, 0x400000, v4
; GFX11-NEXT:    v_add_f32_e64 v21, 0x40c00000, s0
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 0x7fff, v17
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    s_lshl_b32 s0, s12, 16
; GFX11-NEXT:    v_bfe_u32 v20, v18, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v26, 0x400000, v21
; GFX11-NEXT:    v_or_b32_e32 v25, 0x400000, v18
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v17, v19, vcc_lo
; GFX11-NEXT:    v_add_f32_e64 v17, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v19, v21, 16, 1
; GFX11-NEXT:    s_and_b32 s0, s12, 0xffff0000
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v21, v21
; GFX11-NEXT:    v_add_f32_e64 v22, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v23, v17, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v19, v19, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, v20, v18
; GFX11-NEXT:    v_or_b32_e32 v27, 0x400000, v17
; GFX11-NEXT:    v_bfe_u32 v24, v22, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v23, v23, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 0x7fff, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 0x7fff, v20
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v24, v24, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 0x7fff, v23
; GFX11-NEXT:    v_cndmask_b32_e32 v19, v19, v26, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 0x7fff, v24
; GFX11-NEXT:    v_or_b32_e32 v24, 0x400000, v22
; GFX11-NEXT:    v_lshrrev_b32_e32 v19, 16, v19
; GFX11-NEXT:    v_cndmask_b32_e32 v17, v23, v27, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v16, 16, v16
; GFX11-NEXT:    v_lshl_or_b32 v3, v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v17, 16, v17
; GFX11-NEXT:    v_cndmask_b32_e32 v18, v20, v25, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v18, 16, v18
; GFX11-NEXT:    v_cndmask_b32_e32 v20, v21, v24, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v21, 0xffff, v4
; GFX11-NEXT:    v_lshl_or_b32 v4, v1, 16, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshl_or_b32 v1, v18, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v20, 16, v20
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshl_or_b32 v2, v16, 16, v21
; GFX11-NEXT:    v_lshl_or_b32 v0, v20, 16, v17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB23_3:
; GFX11-NEXT:    s_branch .LBB23_2
; GFX11-NEXT:  .LBB23_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <32 x bfloat> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x bfloat> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define <64 x i8> @bitcast_v16i32_to_v64i8(<16 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v16i32_to_v64i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v17
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; kill: killed $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v17, v16, v15, 24
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    v_alignbit_b32 v18, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v19, v16, v15, 8
; SI-NEXT:    v_alignbit_b32 v20, v14, v13, 24
; SI-NEXT:    v_alignbit_b32 v21, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v22, v14, v13, 8
; SI-NEXT:    v_alignbit_b32 v23, v12, v11, 24
; SI-NEXT:    v_alignbit_b32 v24, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v25, v12, v11, 8
; SI-NEXT:    v_alignbit_b32 v29, v10, v9, 24
; SI-NEXT:    v_alignbit_b32 v30, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v31, v10, v9, 8
; SI-NEXT:    v_alignbit_b32 v35, v8, v7, 24
; SI-NEXT:    v_alignbit_b32 v36, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v37, v8, v7, 8
; SI-NEXT:    v_alignbit_b32 v49, v6, v5, 24
; SI-NEXT:    v_alignbit_b32 v50, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v52, v6, v5, 8
; SI-NEXT:    v_alignbit_b32 v55, v4, v3, 24
; SI-NEXT:    v_alignbit_b32 v41, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v43, v4, v3, 8
; SI-NEXT:    v_alignbit_b32 v46, v2, v1, 24
; SI-NEXT:    v_alignbit_b32 v56, v2, v1, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v58, v2, v1, 8
; SI-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v28, 8, v16
; SI-NEXT:    v_lshrrev_b32_e32 v32, 24, v14
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v34, 8, v14
; SI-NEXT:    v_lshrrev_b32_e32 v38, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v48, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v51, 24, v10
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v54, 8, v10
; SI-NEXT:    v_lshrrev_b32_e32 v40, 24, v8
; SI-NEXT:    v_lshrrev_b32_e32 v42, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v44, 8, v8
; SI-NEXT:    v_lshrrev_b32_e32 v45, 24, v6
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v57, 8, v6
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_lshrrev_b32_e32 v59, 24, v4
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_lshrrev_b32_e32 v60, 16, v4
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v61, 8, v4
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v62, 24, v2
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v63, 16, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v17, 8, v2
; SI-NEXT:  .LBB24_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_alignbit_b32 v17, v16, v15, 24
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    v_alignbit_b32 v18, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v19, v16, v15, 8
; SI-NEXT:    v_alignbit_b32 v20, v14, v13, 24
; SI-NEXT:    v_alignbit_b32 v21, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v22, v14, v13, 8
; SI-NEXT:    v_alignbit_b32 v23, v12, v11, 24
; SI-NEXT:    v_alignbit_b32 v24, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v25, v12, v11, 8
; SI-NEXT:    v_alignbit_b32 v29, v10, v9, 24
; SI-NEXT:    v_alignbit_b32 v30, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v31, v10, v9, 8
; SI-NEXT:    v_alignbit_b32 v35, v8, v7, 24
; SI-NEXT:    v_alignbit_b32 v36, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v37, v8, v7, 8
; SI-NEXT:    v_alignbit_b32 v49, v6, v5, 24
; SI-NEXT:    v_alignbit_b32 v50, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v52, v6, v5, 8
; SI-NEXT:    v_alignbit_b32 v55, v4, v3, 24
; SI-NEXT:    v_alignbit_b32 v41, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v43, v4, v3, 8
; SI-NEXT:    v_alignbit_b32 v46, v2, v1, 24
; SI-NEXT:    v_alignbit_b32 v56, v2, v1, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v58, v2, v1, 8
; SI-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v28, 8, v16
; SI-NEXT:    v_lshrrev_b32_e32 v32, 24, v14
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v34, 8, v14
; SI-NEXT:    v_lshrrev_b32_e32 v38, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v48, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v51, 24, v10
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v54, 8, v10
; SI-NEXT:    v_lshrrev_b32_e32 v40, 24, v8
; SI-NEXT:    v_lshrrev_b32_e32 v42, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v44, 8, v8
; SI-NEXT:    v_lshrrev_b32_e32 v45, 24, v6
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v57, 8, v6
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_lshrrev_b32_e32 v59, 24, v4
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_lshrrev_b32_e32 v60, 16, v4
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v61, 8, v4
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v62, 24, v2
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v63, 16, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v17, 8, v2
; SI-NEXT:  .LBB24_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_lshlrev_b32_e32 v58, 8, v58
; SI-NEXT:    v_and_b32_e32 v56, 0xff, v56
; SI-NEXT:    v_or_b32_e32 v1, v1, v58
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v56
; SI-NEXT:    v_lshlrev_b32_e32 v46, 24, v46
; SI-NEXT:    v_or_b32_e32 v46, v46, v56
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v46
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v17
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v63
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v17, 24, v62
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v17, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v43
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v41
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v55
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v61
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v60
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v59
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v52
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v50
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v49
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v57
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v47
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v45
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v37
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v36
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v35
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v44
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v42
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v40
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v31
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v30
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v29
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v54
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v53
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v51
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v24
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v23
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v39
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v38
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v22
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v21
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v20
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v33
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v32
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v19
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v28
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v27
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v26
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i32_to_v64i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v17
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; kill: killed $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr62
; VI-NEXT:    ; implicit-def: $vgpr61
; VI-NEXT:    ; implicit-def: $vgpr60
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr59
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    ; implicit-def: $vgpr57
; VI-NEXT:    ; implicit-def: $vgpr56
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; kill: killed $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB24_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v17, 16, v16
; VI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v17, 8, v16
; VI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; VI-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; VI-NEXT:    v_lshrrev_b64 v[24:25], 24, v[7:8]
; VI-NEXT:    v_lshrrev_b32_e32 v22, 24, v16
; VI-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; VI-NEXT:    v_lshrrev_b64 v[25:26], 24, v[5:6]
; VI-NEXT:    v_mov_b32_e32 v26, v22
; VI-NEXT:    v_lshrrev_b64 v[21:22], 24, v[3:4]
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v31, 8, v15
; VI-NEXT:    v_lshrrev_b32_e32 v32, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v34, 8, v14
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v36, 8, v13
; VI-NEXT:    v_lshrrev_b32_e32 v37, 24, v12
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v39, 8, v12
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v49, 8, v11
; VI-NEXT:    v_lshrrev_b32_e32 v50, 24, v10
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v52, 8, v10
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v54, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 24, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v41, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v43, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v44, 24, v6
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v46, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v56, 8, v5
; VI-NEXT:    v_lshrrev_b32_e32 v57, 24, v4
; VI-NEXT:    v_lshrrev_b32_e32 v58, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v59, 8, v4
; VI-NEXT:    v_lshrrev_b32_e32 v60, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v61, 8, v3
; VI-NEXT:    v_lshrrev_b32_e32 v62, 24, v2
; VI-NEXT:    v_lshrrev_b32_e32 v63, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v28, 8, v2
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v1
; VI-NEXT:    v_lshrrev_b64 v[22:23], 24, v[1:2]
; VI-NEXT:  .LBB24_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB24_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_lshrrev_b64 v[21:22], 24, v[3:4]
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_lshrrev_b64 v[24:25], 24, v[7:8]
; VI-NEXT:    v_lshrrev_b64 v[22:23], 24, v[1:2]
; VI-NEXT:    v_lshrrev_b64 v[25:26], 24, v[5:6]
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; VI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v23, 8, v16
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v31, 8, v15
; VI-NEXT:    v_lshrrev_b32_e32 v32, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v34, 8, v14
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v36, 8, v13
; VI-NEXT:    v_lshrrev_b32_e32 v37, 24, v12
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v39, 8, v12
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v49, 8, v11
; VI-NEXT:    v_lshrrev_b32_e32 v50, 24, v10
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v52, 8, v10
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v54, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 24, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v41, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v43, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v44, 24, v6
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v46, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v56, 8, v5
; VI-NEXT:    v_lshrrev_b32_e32 v57, 24, v4
; VI-NEXT:    v_lshrrev_b32_e32 v58, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v59, 8, v4
; VI-NEXT:    v_lshrrev_b32_e32 v60, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v61, 8, v3
; VI-NEXT:    v_lshrrev_b32_e32 v62, 24, v2
; VI-NEXT:    v_lshrrev_b32_e32 v63, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v28, 8, v2
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v1
; VI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; VI-NEXT:  .LBB24_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b16_e32 v23, 8, v29
; VI-NEXT:    v_lshlrev_b16_e32 v22, 8, v22
; VI-NEXT:    v_or_b32_sdwa v1, v1, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v27, v22 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v23, 8, v28
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v62
; VI-NEXT:    v_or_b32_sdwa v2, v2, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v63, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 4, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v21
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v61
; VI-NEXT:    v_or_b32_sdwa v1, v60, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 8, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v59
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v57
; VI-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v58, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 12, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v56
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v25
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v47, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 16, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v46
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v44
; VI-NEXT:    v_or_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v45, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 20, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v43
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v24
; VI-NEXT:    v_or_b32_sdwa v1, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v42, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 24, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v41
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v55
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v40, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 28, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v54
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v20
; VI-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v53, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 32, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v52
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v50
; VI-NEXT:    v_or_b32_sdwa v1, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v51, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 36, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v49
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v19
; VI-NEXT:    v_or_b32_sdwa v1, v11, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 40, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v39
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v37
; VI-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v38, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 44, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v36
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v18
; VI-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v35, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 48, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v34
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v32
; VI-NEXT:    v_or_b32_sdwa v1, v14, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v33, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 52, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v31
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v17
; VI-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v30, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 56, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v26
; VI-NEXT:    v_add_u32_e32 v0, vcc, 60, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i32_to_v64i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v17
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; kill: killed $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; kill: killed $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB24_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v16
; GFX9-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 8, v16
; GFX9-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; GFX9-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; GFX9-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v16
; GFX9-NEXT:    v_lshrrev_b64 v[21:22], 24, v[7:8]
; GFX9-NEXT:    v_lshrrev_b64 v[25:26], 24, v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v26, v23
; GFX9-NEXT:    v_lshrrev_b64 v[22:23], 24, v[3:4]
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 8, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 8, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 24, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 8, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 8, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 24, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 8, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 24, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 24, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 8, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v1
; GFX9-NEXT:    v_lshrrev_b64 v[23:24], 24, v[1:2]
; GFX9-NEXT:  .LBB24_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB24_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshrrev_b64 v[21:22], 24, v[7:8]
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshrrev_b64 v[22:23], 24, v[3:4]
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_lshrrev_b64 v[23:24], 24, v[1:2]
; GFX9-NEXT:    v_lshrrev_b64 v[25:26], 24, v[5:6]
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; GFX9-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 8, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 8, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 8, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 24, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 8, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 8, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 24, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 8, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 24, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 24, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 8, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v1
; GFX9-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:  .LBB24_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_lshlrev_b16_e32 v24, 8, v29
; GFX9-NEXT:    v_lshlrev_b16_e32 v23, 8, v23
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v23, v27, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v24, 8, v28
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v62
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v63, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:4
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v22
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v60
; GFX9-NEXT:    v_or_b32_sdwa v1, v61, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:8
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v59
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v57
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v58, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:12
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v56
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v25
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v47, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:16
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v46
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v44
; GFX9-NEXT:    v_or_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v45, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:20
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v43
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v21
; GFX9-NEXT:    v_or_b32_sdwa v1, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v42, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:24
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v41
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v55
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v40, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:28
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v54
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v20
; GFX9-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v53, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:32
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v52
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v50
; GFX9-NEXT:    v_or_b32_sdwa v1, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v51, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:36
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v49
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v19
; GFX9-NEXT:    v_or_b32_sdwa v1, v11, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:40
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v39
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v37
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v38, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:44
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v36
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v18
; GFX9-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v35, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:48
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v34
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v32
; GFX9-NEXT:    v_or_b32_sdwa v1, v14, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v33, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:52
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v31
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v17
; GFX9-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v30, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:56
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v26
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:60
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v16i32_to_v64i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v17
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr25_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr24_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr64_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr55_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr54_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr23_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr53_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr52_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr51_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr22_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr50_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr49_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr48_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr39_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr38_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr37_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr33_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr32_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr31_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr30_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr29_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr28_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr27_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr26_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB24_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[21:22], 24, v[7:8]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[22:23], 24, v[5:6]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[23:24], 24, v[3:4]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[24:25], 24, v[1:2]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v27, 8, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v28, 8, v15
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 24, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v30, 8, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v32, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v33, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v34, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v35, 24, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v36, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v37, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v38, 24, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v39, 8, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v48, 8, v7
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v49, 24, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v50, 8, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v51, 8, v5
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v52, 24, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v53, 8, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v54, 8, v3
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v55, 24, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v64, 8, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v1
; GFX11-TRUE16-NEXT:  .LBB24_2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB24_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[21:22], 24, v[7:8]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[22:23], 24, v[5:6]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[23:24], 24, v[3:4]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[24:25], 24, v[1:2]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v27, 8, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v28, 8, v15
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 24, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v30, 8, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v32, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v33, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v34, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v35, 24, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v36, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v37, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v38, 24, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v39, 8, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v48, 8, v7
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v49, 24, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v50, 8, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v51, 8, v5
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v52, 24, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v53, 8, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v54, 8, v3
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v55, 24, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v64, 8, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v1
; GFX11-TRUE16-NEXT:  .LBB24_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v25.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v24.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v17.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v64.l
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v1.h, v18.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v55.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.h, 8, v54.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v21.h, 8, v53.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.l, v17.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v20.h, 8, v23.l
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v2.h, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v19.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v21.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v52.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v24
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v3.h, v20.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v4.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v54, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v51.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 8, v22.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v48.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v4.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v21.l
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v21.l, 8, v37.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v17.h
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v6.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v50.l
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, 0xff, v6.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 8, v49.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v49, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v54, v24
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v25, v22
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.h, 8, v39.l
; GFX11-TRUE16-NEXT:    v_or_b16 v22.l, v7.h, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v9.l, v21.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v9.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v7.h, 8, v20.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-TRUE16-NEXT:    v_and_b16 v8.h, 0xff, v8.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v20.h, 8, v38.l
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v19.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v10.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v35.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v7.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v53, v23
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v8.h, v20.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v25, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v36.l
; GFX11-TRUE16-NEXT:    v_and_b16 v10.l, 0xff, v11.l
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v11.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.h, 8, v19.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v9.l, v9.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 8, v34.l
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v8.h
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v12.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v34, 16, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v21, v19
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v33.l
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.l, 8, v31.l
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v14.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.h, 8, v30.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v12.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v32.l
; GFX11-TRUE16-NEXT:    v_and_b16 v13.h, 0xff, v13.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.l, 8, v18.l
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v19.l
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v14.l, v19.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v24, v22
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v20, v34
; GFX11-TRUE16-NEXT:    v_or_b16 v20.l, v12.h, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v18.l, v13.h, v18.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v14.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff, v13
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v14.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 8, v29.l
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v13.h, 8, v28.l
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v15.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v14.h, 8, v17.l
; GFX11-TRUE16-NEXT:    v_and_b16 v15.l, 0xff, v16.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.h, 8, v27.l
; GFX11-TRUE16-NEXT:    v_and_b16 v16.l, 0xff, v16.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.h, 8, v26.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v6.l, v6.h
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v11.l, v11.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v13.h
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v14.l, v14.h
; GFX11-TRUE16-NEXT:    v_or_b16 v15.l, v15.l, v15.h
; GFX11-TRUE16-NEXT:    v_or_b16 v16.l, v16.l, v16.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v51, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v25, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v12
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v23, 0xffff, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v14
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v25, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v49, v50
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v51, v6
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v35, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v21, v20
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v22, v18
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v19, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v23, v24
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, v25, v16
; GFX11-TRUE16-NEXT:    s_clause 0x3
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[1:4], off
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[5:8], off offset:16
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[9:12], off offset:32
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[13:16], off offset:48
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v16i32_to_v64i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr96
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr87
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr86
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr85
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr84
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr83
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr82
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr81
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr80
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr67
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr55
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB24_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[21:22], 24, v[7:8]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[22:23], 24, v[5:6]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[23:24], 24, v[3:4]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[24:25], 24, v[1:2]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 8, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 8, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 8, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 24, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 8, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 8, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 24, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 8, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 24, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 8, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 24, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 8, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 8, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 24, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v81, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v82, 8, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v83, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v84, 8, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v85, 24, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v86, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v87, 8, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v96, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v1
; GFX11-FAKE16-NEXT:  .LBB24_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB24_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[17:18], 24, v[15:16]
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[18:19], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[11:12]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[20:21], 24, v[9:10]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[21:22], 24, v[7:8]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[22:23], 24, v[5:6]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[23:24], 24, v[3:4]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[24:25], 24, v[1:2]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 24, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 8, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 8, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 8, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 24, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 8, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 8, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 24, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 8, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 24, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 8, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 24, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 8, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 8, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 24, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v81, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v82, 8, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v83, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v84, 8, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v85, 24, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v86, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v87, 8, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v96, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v1
; GFX11-FAKE16-NEXT:  .LBB24_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v25, 8, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v96, 0xff, v96
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v24, 8, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v86, 0xff, v86
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v25, 8, v87
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v96, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v85, 8, v85
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v86, v85
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v84, 8, v84
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v83, 0xff, v83
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v24, 8, v82
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v23, 8, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v80, 8, v80
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v71, 8, v71
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v81
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v70, 0xff, v70
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v22, 8, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v84
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v83, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v25, v80
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v71
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v70, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v22, 8, v66
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v65
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v24, 8, v64
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v55
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v54, 8, v54
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v53, 8, v53
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v23, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v25, v54
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v52
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v20, 8, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v24, 8, v51
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v50
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v49, 8, v49
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v48, 8, v48
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v39, 0xff, v39
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v19, 8, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v53
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v23, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v25, v49
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v48
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v39, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v19, 8, v38
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v37
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v36
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v22, 8, v35
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v34
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v18, 8, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v24, 8, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v69, 8, v69
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v68, 0xff, v68
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v67, 8, v67
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v20, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v23, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v14, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v32
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v22, 8, v30
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v24, 8, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v26, 8, v26
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v69
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v67, v68, v67
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v20, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v23, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v16, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v25, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v67, 16, v67
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v67
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v14, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v16, v21
; GFX11-FAKE16-NEXT:    s_clause 0x3
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[1:4], off
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[5:8], off offset:16
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[9:12], off offset:32
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[13:16], off offset:48
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <64 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <64 x i8>
  br label %end

end:
  %phi = phi <64 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <64 x i8> %phi
}

define inreg <64 x i8> @bitcast_v16i32_to_v64i8_scalar(<16 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i32_to_v64i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    v_readfirstlane_b32 s7, v1
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s6, v2
; SI-NEXT:    s_cbranch_scc0 .LBB25_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v9, s26
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v6, s28
; SI-NEXT:    v_alignbit_b32 v7, s27, v9, 24
; SI-NEXT:    v_alignbit_b32 v8, s27, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s27, v9, 8
; SI-NEXT:    v_mov_b32_e32 v9, s24
; SI-NEXT:    v_mov_b32_e32 v14, s22
; SI-NEXT:    v_mov_b32_e32 v18, s20
; SI-NEXT:    v_mov_b32_e32 v21, s18
; SI-NEXT:    v_mov_b32_e32 v22, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v3, 24
; SI-NEXT:    v_alignbit_b32 v2, s6, v3, 16
; SI-NEXT:    v_alignbit_b32 v3, s6, v3, 8
; SI-NEXT:    v_alignbit_b32 v4, s29, v6, 24
; SI-NEXT:    v_alignbit_b32 v5, s29, v6, 16
; SI-NEXT:    v_alignbit_b32 v6, s29, v6, 8
; SI-NEXT:    v_alignbit_b32 v13, s25, v9, 24
; SI-NEXT:    v_alignbit_b32 v15, s25, v9, 16
; SI-NEXT:    v_alignbit_b32 v9, s25, v9, 8
; SI-NEXT:    v_alignbit_b32 v11, s23, v14, 24
; SI-NEXT:    v_alignbit_b32 v12, s23, v14, 16
; SI-NEXT:    v_alignbit_b32 v14, s23, v14, 8
; SI-NEXT:    v_alignbit_b32 v16, s21, v18, 24
; SI-NEXT:    v_alignbit_b32 v17, s21, v18, 16
; SI-NEXT:    v_alignbit_b32 v18, s21, v18, 8
; SI-NEXT:    v_alignbit_b32 v19, s19, v21, 24
; SI-NEXT:    v_alignbit_b32 v20, s19, v21, 16
; SI-NEXT:    v_alignbit_b32 v21, s19, v21, 8
; SI-NEXT:    v_alignbit_b32 v23, s17, v22, 24
; SI-NEXT:    v_alignbit_b32 v24, s17, v22, 16
; SI-NEXT:    v_alignbit_b32 v22, s17, v22, 8
; SI-NEXT:    s_lshr_b32 s8, s6, 24
; SI-NEXT:    s_lshr_b32 s9, s6, 16
; SI-NEXT:    s_lshr_b32 s10, s6, 8
; SI-NEXT:    s_lshr_b32 s11, s29, 24
; SI-NEXT:    s_lshr_b32 s12, s29, 16
; SI-NEXT:    s_lshr_b32 s13, s29, 8
; SI-NEXT:    s_lshr_b32 s14, s27, 24
; SI-NEXT:    s_lshr_b32 s15, s27, 16
; SI-NEXT:    s_lshr_b32 s40, s27, 8
; SI-NEXT:    s_lshr_b32 s41, s25, 24
; SI-NEXT:    s_lshr_b32 s42, s25, 16
; SI-NEXT:    s_lshr_b32 s43, s25, 8
; SI-NEXT:    s_lshr_b32 s44, s23, 24
; SI-NEXT:    s_lshr_b32 s45, s23, 16
; SI-NEXT:    s_lshr_b32 s46, s23, 8
; SI-NEXT:    s_lshr_b32 s47, s21, 24
; SI-NEXT:    s_lshr_b32 s56, s21, 16
; SI-NEXT:    s_lshr_b32 s57, s21, 8
; SI-NEXT:    s_lshr_b32 s58, s19, 24
; SI-NEXT:    s_lshr_b32 s59, s19, 16
; SI-NEXT:    s_lshr_b32 s60, s19, 8
; SI-NEXT:    s_lshr_b32 s61, s17, 24
; SI-NEXT:    s_lshr_b32 s62, s17, 16
; SI-NEXT:    s_lshr_b32 s63, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB25_3
; SI-NEXT:  .LBB25_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s7, s7, 3
; SI-NEXT:    v_mov_b32_e32 v9, s26
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v6, s28
; SI-NEXT:    v_alignbit_b32 v7, s27, v9, 24
; SI-NEXT:    v_alignbit_b32 v8, s27, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s27, v9, 8
; SI-NEXT:    v_mov_b32_e32 v9, s24
; SI-NEXT:    v_mov_b32_e32 v14, s22
; SI-NEXT:    v_mov_b32_e32 v18, s20
; SI-NEXT:    v_mov_b32_e32 v21, s18
; SI-NEXT:    v_mov_b32_e32 v22, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v3, 24
; SI-NEXT:    v_alignbit_b32 v2, s6, v3, 16
; SI-NEXT:    v_alignbit_b32 v3, s6, v3, 8
; SI-NEXT:    v_alignbit_b32 v4, s29, v6, 24
; SI-NEXT:    v_alignbit_b32 v5, s29, v6, 16
; SI-NEXT:    v_alignbit_b32 v6, s29, v6, 8
; SI-NEXT:    v_alignbit_b32 v13, s25, v9, 24
; SI-NEXT:    v_alignbit_b32 v15, s25, v9, 16
; SI-NEXT:    v_alignbit_b32 v9, s25, v9, 8
; SI-NEXT:    v_alignbit_b32 v11, s23, v14, 24
; SI-NEXT:    v_alignbit_b32 v12, s23, v14, 16
; SI-NEXT:    v_alignbit_b32 v14, s23, v14, 8
; SI-NEXT:    v_alignbit_b32 v16, s21, v18, 24
; SI-NEXT:    v_alignbit_b32 v17, s21, v18, 16
; SI-NEXT:    v_alignbit_b32 v18, s21, v18, 8
; SI-NEXT:    v_alignbit_b32 v19, s19, v21, 24
; SI-NEXT:    v_alignbit_b32 v20, s19, v21, 16
; SI-NEXT:    v_alignbit_b32 v21, s19, v21, 8
; SI-NEXT:    v_alignbit_b32 v23, s17, v22, 24
; SI-NEXT:    v_alignbit_b32 v24, s17, v22, 16
; SI-NEXT:    v_alignbit_b32 v22, s17, v22, 8
; SI-NEXT:    s_lshr_b32 s8, s6, 24
; SI-NEXT:    s_lshr_b32 s9, s6, 16
; SI-NEXT:    s_lshr_b32 s10, s6, 8
; SI-NEXT:    s_lshr_b32 s11, s29, 24
; SI-NEXT:    s_lshr_b32 s12, s29, 16
; SI-NEXT:    s_lshr_b32 s13, s29, 8
; SI-NEXT:    s_lshr_b32 s14, s27, 24
; SI-NEXT:    s_lshr_b32 s15, s27, 16
; SI-NEXT:    s_lshr_b32 s40, s27, 8
; SI-NEXT:    s_lshr_b32 s41, s25, 24
; SI-NEXT:    s_lshr_b32 s42, s25, 16
; SI-NEXT:    s_lshr_b32 s43, s25, 8
; SI-NEXT:    s_lshr_b32 s44, s23, 24
; SI-NEXT:    s_lshr_b32 s45, s23, 16
; SI-NEXT:    s_lshr_b32 s46, s23, 8
; SI-NEXT:    s_lshr_b32 s47, s21, 24
; SI-NEXT:    s_lshr_b32 s56, s21, 16
; SI-NEXT:    s_lshr_b32 s57, s21, 8
; SI-NEXT:    s_lshr_b32 s58, s19, 24
; SI-NEXT:    s_lshr_b32 s59, s19, 16
; SI-NEXT:    s_lshr_b32 s60, s19, 8
; SI-NEXT:    s_lshr_b32 s61, s17, 24
; SI-NEXT:    s_lshr_b32 s62, s17, 16
; SI-NEXT:    s_lshr_b32 s63, s17, 8
; SI-NEXT:  .LBB25_3: ; %end
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v22, 8, v22
; SI-NEXT:    v_or_b32_e32 v22, s4, v22
; SI-NEXT:    s_and_b32 s4, s17, 0xff
; SI-NEXT:    s_lshl_b32 s5, s63, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s62, 0xff
; SI-NEXT:    v_and_b32_e32 v24, 0xff, v24
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s61, 24
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; SI-NEXT:    v_lshlrev_b32_e32 v23, 24, v23
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    v_or_b32_e32 v23, v23, v24
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_or_b32_e32 v22, v22, v23
; SI-NEXT:    v_mov_b32_e32 v23, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v21, 8, v21
; SI-NEXT:    v_or_b32_e32 v21, s4, v21
; SI-NEXT:    s_and_b32 s4, s19, 0xff
; SI-NEXT:    s_lshl_b32 s5, s60, 8
; SI-NEXT:    v_and_b32_e32 v20, 0xff, v20
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s59, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v19, 24, v19
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s58, 24
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    v_or_b32_e32 v19, v19, v20
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    buffer_store_dword v22, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v22, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:    v_add_i32_e32 v20, vcc, 8, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v23, v22, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v19, v20, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v20, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v18, 8, v18
; SI-NEXT:    v_or_b32_e32 v18, s4, v18
; SI-NEXT:    s_and_b32 s4, s21, 0xff
; SI-NEXT:    s_lshl_b32 s5, s57, 8
; SI-NEXT:    v_and_b32_e32 v17, 0xff, v17
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s56, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v16, 24, v16
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s47, 24
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_or_b32_e32 v16, v16, v17
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v19, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_add_i32_e32 v17, vcc, 16, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v20, v19, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v16, v17, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v17, s4
; SI-NEXT:    s_and_b32 s4, s22, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v14, 8, v14
; SI-NEXT:    v_or_b32_e32 v14, s4, v14
; SI-NEXT:    s_and_b32 s4, s23, 0xff
; SI-NEXT:    s_lshl_b32 s5, s46, 8
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v12
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s45, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s44, 24
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v11, v11, v12
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v16, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v11, v14, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, 24, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v17, v16, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v11, v12, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v12, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v11, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v9, s4, v9
; SI-NEXT:    s_and_b32 s4, s25, 0xff
; SI-NEXT:    s_lshl_b32 s5, s43, 8
; SI-NEXT:    buffer_store_dword v12, v11, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v15
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s42, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s41, 24
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    v_or_b32_e32 v9, v9, v11
; SI-NEXT:    v_add_i32_e32 v11, vcc, 32, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v9, v11, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v9, vcc, 36, v0
; SI-NEXT:    v_mov_b32_e32 v11, s4
; SI-NEXT:    buffer_store_dword v11, v9, s[0:3], 0 offen
; SI-NEXT:    s_and_b32 s4, s26, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v9, 8, v10
; SI-NEXT:    v_or_b32_e32 v9, s4, v9
; SI-NEXT:    s_and_b32 s4, s27, 0xff
; SI-NEXT:    s_lshl_b32 s5, s40, 8
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s15, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s14, s14, 24
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s14, s5
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 40, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v7, v8, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; SI-NEXT:    v_or_b32_e32 v6, s4, v6
; SI-NEXT:    s_and_b32 s4, s29, 0xff
; SI-NEXT:    s_lshl_b32 s5, s13, 8
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s12, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s11, s11, 24
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s11, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v8, v7, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v4, v5, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v5, s4
; SI-NEXT:    s_and_b32 s4, s7, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; SI-NEXT:    v_or_b32_e32 v3, s4, v3
; SI-NEXT:    s_and_b32 s4, s6, 0xff
; SI-NEXT:    s_lshl_b32 s5, s10, 8
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s9, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s8, 24
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 52, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v5, v4, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v0, vcc, 60, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB25_4:
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $sgpr63
; SI-NEXT:    ; implicit-def: $sgpr62
; SI-NEXT:    ; implicit-def: $sgpr61
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $sgpr60
; SI-NEXT:    ; implicit-def: $sgpr59
; SI-NEXT:    ; implicit-def: $sgpr58
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $sgpr57
; SI-NEXT:    ; implicit-def: $sgpr56
; SI-NEXT:    ; implicit-def: $sgpr47
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $sgpr46
; SI-NEXT:    ; implicit-def: $sgpr45
; SI-NEXT:    ; implicit-def: $sgpr44
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr43
; SI-NEXT:    ; implicit-def: $sgpr42
; SI-NEXT:    ; implicit-def: $sgpr41
; SI-NEXT:    ; implicit-def: $sgpr40
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_branch .LBB25_2
;
; VI-LABEL: bitcast_v16i32_to_v64i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    v_writelane_b32 v4, s30, 0
; VI-NEXT:    v_writelane_b32 v4, s31, 1
; VI-NEXT:    v_writelane_b32 v4, s34, 2
; VI-NEXT:    v_writelane_b32 v4, s35, 3
; VI-NEXT:    v_writelane_b32 v4, s36, 4
; VI-NEXT:    v_writelane_b32 v4, s37, 5
; VI-NEXT:    v_writelane_b32 v4, s38, 6
; VI-NEXT:    v_writelane_b32 v4, s39, 7
; VI-NEXT:    v_writelane_b32 v4, s48, 8
; VI-NEXT:    v_writelane_b32 v4, s49, 9
; VI-NEXT:    v_writelane_b32 v4, s50, 10
; VI-NEXT:    v_writelane_b32 v4, s51, 11
; VI-NEXT:    v_writelane_b32 v4, s52, 12
; VI-NEXT:    v_writelane_b32 v4, s53, 13
; VI-NEXT:    v_writelane_b32 v4, s54, 14
; VI-NEXT:    v_writelane_b32 v4, s55, 15
; VI-NEXT:    v_writelane_b32 v4, s64, 16
; VI-NEXT:    v_writelane_b32 v4, s65, 17
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    v_writelane_b32 v4, s66, 18
; VI-NEXT:    v_readfirstlane_b32 s4, v1
; VI-NEXT:    s_and_b64 s[6:7], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s5, v2
; VI-NEXT:    v_writelane_b32 v4, s67, 19
; VI-NEXT:    s_cbranch_scc0 .LBB25_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s56, s5, 24
; VI-NEXT:    s_lshr_b32 s57, s5, 16
; VI-NEXT:    s_lshr_b32 s58, s5, 8
; VI-NEXT:    s_lshr_b32 s59, s4, 16
; VI-NEXT:    s_lshr_b32 s60, s4, 8
; VI-NEXT:    s_lshr_b32 s61, s29, 24
; VI-NEXT:    s_lshr_b32 s62, s29, 16
; VI-NEXT:    s_lshr_b32 s63, s29, 8
; VI-NEXT:    s_lshr_b32 s72, s28, 16
; VI-NEXT:    s_lshr_b32 s73, s28, 8
; VI-NEXT:    s_lshr_b32 s74, s27, 24
; VI-NEXT:    s_lshr_b32 s75, s27, 16
; VI-NEXT:    s_lshr_b32 s76, s27, 8
; VI-NEXT:    s_lshr_b32 s77, s26, 16
; VI-NEXT:    s_lshr_b32 s78, s26, 8
; VI-NEXT:    s_lshr_b32 s79, s25, 24
; VI-NEXT:    s_lshr_b32 s88, s25, 16
; VI-NEXT:    s_lshr_b32 s89, s25, 8
; VI-NEXT:    s_lshr_b32 s90, s24, 16
; VI-NEXT:    s_lshr_b32 s91, s24, 8
; VI-NEXT:    s_lshr_b32 s30, s23, 24
; VI-NEXT:    s_lshr_b32 s31, s23, 16
; VI-NEXT:    s_lshr_b32 s34, s23, 8
; VI-NEXT:    s_lshr_b32 s35, s22, 16
; VI-NEXT:    s_lshr_b32 s36, s22, 8
; VI-NEXT:    s_lshr_b32 s37, s21, 24
; VI-NEXT:    s_lshr_b32 s38, s21, 16
; VI-NEXT:    s_lshr_b32 s39, s21, 8
; VI-NEXT:    s_lshr_b32 s48, s20, 16
; VI-NEXT:    s_lshr_b32 s49, s20, 8
; VI-NEXT:    s_lshr_b32 s50, s19, 24
; VI-NEXT:    s_lshr_b32 s51, s19, 16
; VI-NEXT:    s_lshr_b32 s52, s19, 8
; VI-NEXT:    s_lshr_b32 s53, s18, 16
; VI-NEXT:    s_lshr_b32 s54, s18, 8
; VI-NEXT:    s_lshr_b32 s55, s17, 24
; VI-NEXT:    s_lshr_b32 s64, s17, 16
; VI-NEXT:    s_lshr_b32 s65, s17, 8
; VI-NEXT:    s_lshr_b32 s66, s16, 16
; VI-NEXT:    s_lshr_b32 s67, s16, 8
; VI-NEXT:    s_lshr_b64 s[6:7], s[4:5], 24
; VI-NEXT:    s_lshr_b64 s[8:9], s[28:29], 24
; VI-NEXT:    s_lshr_b64 s[10:11], s[26:27], 24
; VI-NEXT:    s_lshr_b64 s[12:13], s[24:25], 24
; VI-NEXT:    s_lshr_b64 s[14:15], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[40:41], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[42:43], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[44:45], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB25_3
; VI-NEXT:  .LBB25_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_add_i32 s5, s5, 3
; VI-NEXT:    s_add_i32 s4, s4, 3
; VI-NEXT:    s_lshr_b64 s[6:7], s[4:5], 24
; VI-NEXT:    s_lshr_b64 s[8:9], s[28:29], 24
; VI-NEXT:    s_lshr_b64 s[10:11], s[26:27], 24
; VI-NEXT:    s_lshr_b64 s[12:13], s[24:25], 24
; VI-NEXT:    s_lshr_b64 s[14:15], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[40:41], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[42:43], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[44:45], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s56, s5, 24
; VI-NEXT:    s_lshr_b32 s57, s5, 16
; VI-NEXT:    s_lshr_b32 s58, s5, 8
; VI-NEXT:    s_lshr_b32 s59, s4, 16
; VI-NEXT:    s_lshr_b32 s60, s4, 8
; VI-NEXT:    s_lshr_b32 s61, s29, 24
; VI-NEXT:    s_lshr_b32 s62, s29, 16
; VI-NEXT:    s_lshr_b32 s63, s29, 8
; VI-NEXT:    s_lshr_b32 s72, s28, 16
; VI-NEXT:    s_lshr_b32 s73, s28, 8
; VI-NEXT:    s_lshr_b32 s74, s27, 24
; VI-NEXT:    s_lshr_b32 s75, s27, 16
; VI-NEXT:    s_lshr_b32 s76, s27, 8
; VI-NEXT:    s_lshr_b32 s77, s26, 16
; VI-NEXT:    s_lshr_b32 s78, s26, 8
; VI-NEXT:    s_lshr_b32 s79, s25, 24
; VI-NEXT:    s_lshr_b32 s88, s25, 16
; VI-NEXT:    s_lshr_b32 s89, s25, 8
; VI-NEXT:    s_lshr_b32 s90, s24, 16
; VI-NEXT:    s_lshr_b32 s91, s24, 8
; VI-NEXT:    s_lshr_b32 s30, s23, 24
; VI-NEXT:    s_lshr_b32 s31, s23, 16
; VI-NEXT:    s_lshr_b32 s34, s23, 8
; VI-NEXT:    s_lshr_b32 s35, s22, 16
; VI-NEXT:    s_lshr_b32 s36, s22, 8
; VI-NEXT:    s_lshr_b32 s37, s21, 24
; VI-NEXT:    s_lshr_b32 s38, s21, 16
; VI-NEXT:    s_lshr_b32 s39, s21, 8
; VI-NEXT:    s_lshr_b32 s48, s20, 16
; VI-NEXT:    s_lshr_b32 s49, s20, 8
; VI-NEXT:    s_lshr_b32 s50, s19, 24
; VI-NEXT:    s_lshr_b32 s51, s19, 16
; VI-NEXT:    s_lshr_b32 s52, s19, 8
; VI-NEXT:    s_lshr_b32 s53, s18, 16
; VI-NEXT:    s_lshr_b32 s54, s18, 8
; VI-NEXT:    s_lshr_b32 s55, s17, 24
; VI-NEXT:    s_lshr_b32 s64, s17, 16
; VI-NEXT:    s_lshr_b32 s65, s17, 8
; VI-NEXT:    s_lshr_b32 s66, s16, 16
; VI-NEXT:    s_lshr_b32 s67, s16, 8
; VI-NEXT:  .LBB25_3: ; %end
; VI-NEXT:    s_and_b32 s7, s16, 0xff
; VI-NEXT:    s_lshl_b32 s9, s67, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s66, 0xff
; VI-NEXT:    s_lshl_b32 s11, s44, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    s_and_b32 s7, s17, 0xff
; VI-NEXT:    s_lshl_b32 s9, s65, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s64, 0xff
; VI-NEXT:    s_lshl_b32 s11, s55, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s18, 0xff
; VI-NEXT:    s_lshl_b32 s9, s54, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s53, 0xff
; VI-NEXT:    s_lshl_b32 s11, s42, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 4, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s19, 0xff
; VI-NEXT:    s_lshl_b32 s9, s52, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s51, 0xff
; VI-NEXT:    s_lshl_b32 s11, s50, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 8, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s20, 0xff
; VI-NEXT:    s_lshl_b32 s9, s49, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s48, 0xff
; VI-NEXT:    s_lshl_b32 s11, s40, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 12, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s21, 0xff
; VI-NEXT:    s_lshl_b32 s9, s39, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s38, 0xff
; VI-NEXT:    s_lshl_b32 s11, s37, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 16, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s22, 0xff
; VI-NEXT:    s_lshl_b32 s9, s36, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s35, 0xff
; VI-NEXT:    s_lshl_b32 s11, s14, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 20, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s23, 0xff
; VI-NEXT:    s_lshl_b32 s9, s34, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s31, 0xff
; VI-NEXT:    s_lshl_b32 s11, s30, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 24, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s24, 0xff
; VI-NEXT:    s_lshl_b32 s9, s91, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s90, 0xff
; VI-NEXT:    s_lshl_b32 s11, s12, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 28, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s25, 0xff
; VI-NEXT:    s_lshl_b32 s9, s89, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s88, 0xff
; VI-NEXT:    s_lshl_b32 s11, s79, 8
; VI-NEXT:    s_or_b32 s9, s9, s11
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 32, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s9, s78, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s77, 0xff
; VI-NEXT:    s_lshl_b32 s10, s10, 8
; VI-NEXT:    s_or_b32 s9, s9, s10
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 36, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s27, 0xff
; VI-NEXT:    s_lshl_b32 s9, s76, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s75, 0xff
; VI-NEXT:    s_lshl_b32 s10, s74, 8
; VI-NEXT:    s_or_b32 s9, s9, s10
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 40, v0
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s28, 0xff
; VI-NEXT:    s_lshl_b32 s9, s73, 8
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s9, s72, 0xff
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_or_b32 s8, s9, s8
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 44, v0
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s7, s29, 0xff
; VI-NEXT:    s_lshl_b32 s8, s63, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s8, s62, 0xff
; VI-NEXT:    s_lshl_b32 s9, s61, 8
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 48, v0
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    s_and_b32 s4, s4, 0xff
; VI-NEXT:    s_lshl_b32 s7, s60, 8
; VI-NEXT:    s_or_b32 s4, s4, s7
; VI-NEXT:    s_and_b32 s7, s59, 0xff
; VI-NEXT:    s_lshl_b32 s6, s6, 8
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 52, v0
; VI-NEXT:    s_or_b32 s4, s4, s6
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    s_and_b32 s4, s5, 0xff
; VI-NEXT:    s_lshl_b32 s5, s58, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s57, 0xff
; VI-NEXT:    s_lshl_b32 s6, s56, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 56, v0
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v0, vcc, 60, v0
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    v_readlane_b32 s67, v4, 19
; VI-NEXT:    v_readlane_b32 s66, v4, 18
; VI-NEXT:    v_readlane_b32 s65, v4, 17
; VI-NEXT:    v_readlane_b32 s64, v4, 16
; VI-NEXT:    v_readlane_b32 s55, v4, 15
; VI-NEXT:    v_readlane_b32 s54, v4, 14
; VI-NEXT:    v_readlane_b32 s53, v4, 13
; VI-NEXT:    v_readlane_b32 s52, v4, 12
; VI-NEXT:    v_readlane_b32 s51, v4, 11
; VI-NEXT:    v_readlane_b32 s50, v4, 10
; VI-NEXT:    v_readlane_b32 s49, v4, 9
; VI-NEXT:    v_readlane_b32 s48, v4, 8
; VI-NEXT:    v_readlane_b32 s39, v4, 7
; VI-NEXT:    v_readlane_b32 s38, v4, 6
; VI-NEXT:    v_readlane_b32 s37, v4, 5
; VI-NEXT:    v_readlane_b32 s36, v4, 4
; VI-NEXT:    v_readlane_b32 s35, v4, 3
; VI-NEXT:    v_readlane_b32 s34, v4, 2
; VI-NEXT:    v_readlane_b32 s31, v4, 1
; VI-NEXT:    v_readlane_b32 s30, v4, 0
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB25_4:
; VI-NEXT:    ; implicit-def: $sgpr67
; VI-NEXT:    ; implicit-def: $sgpr66
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr65
; VI-NEXT:    ; implicit-def: $sgpr64
; VI-NEXT:    ; implicit-def: $sgpr55
; VI-NEXT:    ; implicit-def: $sgpr54
; VI-NEXT:    ; implicit-def: $sgpr53
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr52
; VI-NEXT:    ; implicit-def: $sgpr51
; VI-NEXT:    ; implicit-def: $sgpr50
; VI-NEXT:    ; implicit-def: $sgpr49
; VI-NEXT:    ; implicit-def: $sgpr48
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr39
; VI-NEXT:    ; implicit-def: $sgpr38
; VI-NEXT:    ; implicit-def: $sgpr37
; VI-NEXT:    ; implicit-def: $sgpr36
; VI-NEXT:    ; implicit-def: $sgpr35
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr34
; VI-NEXT:    ; implicit-def: $sgpr31
; VI-NEXT:    ; implicit-def: $sgpr30
; VI-NEXT:    ; implicit-def: $sgpr91
; VI-NEXT:    ; implicit-def: $sgpr90
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    ; implicit-def: $sgpr89
; VI-NEXT:    ; implicit-def: $sgpr88
; VI-NEXT:    ; implicit-def: $sgpr79
; VI-NEXT:    ; implicit-def: $sgpr78
; VI-NEXT:    ; implicit-def: $sgpr77
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr76
; VI-NEXT:    ; implicit-def: $sgpr75
; VI-NEXT:    ; implicit-def: $sgpr74
; VI-NEXT:    ; implicit-def: $sgpr73
; VI-NEXT:    ; implicit-def: $sgpr72
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr63
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr61
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    s_branch .LBB25_2
;
; GFX9-LABEL: bitcast_v16i32_to_v64i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    v_writelane_b32 v4, s30, 0
; GFX9-NEXT:    v_writelane_b32 v4, s31, 1
; GFX9-NEXT:    v_writelane_b32 v4, s34, 2
; GFX9-NEXT:    v_writelane_b32 v4, s35, 3
; GFX9-NEXT:    v_writelane_b32 v4, s36, 4
; GFX9-NEXT:    v_writelane_b32 v4, s37, 5
; GFX9-NEXT:    v_writelane_b32 v4, s38, 6
; GFX9-NEXT:    v_writelane_b32 v4, s39, 7
; GFX9-NEXT:    v_writelane_b32 v4, s48, 8
; GFX9-NEXT:    v_writelane_b32 v4, s49, 9
; GFX9-NEXT:    v_writelane_b32 v4, s50, 10
; GFX9-NEXT:    v_writelane_b32 v4, s51, 11
; GFX9-NEXT:    v_writelane_b32 v4, s52, 12
; GFX9-NEXT:    v_writelane_b32 v4, s53, 13
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    v_writelane_b32 v4, s54, 14
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s5, v2
; GFX9-NEXT:    v_writelane_b32 v4, s55, 15
; GFX9-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s56, s5, 24
; GFX9-NEXT:    s_lshr_b32 s57, s5, 16
; GFX9-NEXT:    s_lshr_b32 s58, s5, 8
; GFX9-NEXT:    s_lshr_b32 s59, s4, 16
; GFX9-NEXT:    s_lshr_b32 s60, s4, 8
; GFX9-NEXT:    s_lshr_b32 s61, s29, 24
; GFX9-NEXT:    s_lshr_b32 s62, s29, 16
; GFX9-NEXT:    s_lshr_b32 s63, s29, 8
; GFX9-NEXT:    s_lshr_b32 s72, s28, 16
; GFX9-NEXT:    s_lshr_b32 s73, s28, 8
; GFX9-NEXT:    s_lshr_b32 s74, s27, 24
; GFX9-NEXT:    s_lshr_b32 s75, s27, 16
; GFX9-NEXT:    s_lshr_b32 s76, s27, 8
; GFX9-NEXT:    s_lshr_b32 s77, s26, 16
; GFX9-NEXT:    s_lshr_b32 s78, s26, 8
; GFX9-NEXT:    s_lshr_b32 s79, s25, 24
; GFX9-NEXT:    s_lshr_b32 s88, s25, 16
; GFX9-NEXT:    s_lshr_b32 s89, s25, 8
; GFX9-NEXT:    s_lshr_b32 s90, s24, 16
; GFX9-NEXT:    s_lshr_b32 s91, s24, 8
; GFX9-NEXT:    s_lshr_b32 s92, s23, 24
; GFX9-NEXT:    s_lshr_b32 s93, s23, 16
; GFX9-NEXT:    s_lshr_b32 s94, s23, 8
; GFX9-NEXT:    s_lshr_b32 s95, s22, 16
; GFX9-NEXT:    s_lshr_b32 s30, s22, 8
; GFX9-NEXT:    s_lshr_b32 s31, s21, 24
; GFX9-NEXT:    s_lshr_b32 s34, s21, 16
; GFX9-NEXT:    s_lshr_b32 s35, s21, 8
; GFX9-NEXT:    s_lshr_b32 s36, s20, 16
; GFX9-NEXT:    s_lshr_b32 s37, s20, 8
; GFX9-NEXT:    s_lshr_b32 s38, s19, 24
; GFX9-NEXT:    s_lshr_b32 s39, s19, 16
; GFX9-NEXT:    s_lshr_b32 s48, s19, 8
; GFX9-NEXT:    s_lshr_b32 s49, s18, 16
; GFX9-NEXT:    s_lshr_b32 s50, s18, 8
; GFX9-NEXT:    s_lshr_b32 s51, s17, 24
; GFX9-NEXT:    s_lshr_b32 s52, s17, 16
; GFX9-NEXT:    s_lshr_b32 s53, s17, 8
; GFX9-NEXT:    s_lshr_b32 s54, s16, 16
; GFX9-NEXT:    s_lshr_b32 s55, s16, 8
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[4:5], 24
; GFX9-NEXT:    s_lshr_b64 s[8:9], s[28:29], 24
; GFX9-NEXT:    s_lshr_b64 s[10:11], s[26:27], 24
; GFX9-NEXT:    s_lshr_b64 s[12:13], s[24:25], 24
; GFX9-NEXT:    s_lshr_b64 s[14:15], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[40:41], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[42:43], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[44:45], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB25_3
; GFX9-NEXT:  .LBB25_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s25, s25, 3
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_add_i32 s27, s27, 3
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_add_i32 s29, s29, 3
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_add_i32 s5, s5, 3
; GFX9-NEXT:    s_add_i32 s4, s4, 3
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[4:5], 24
; GFX9-NEXT:    s_lshr_b64 s[8:9], s[28:29], 24
; GFX9-NEXT:    s_lshr_b64 s[10:11], s[26:27], 24
; GFX9-NEXT:    s_lshr_b64 s[12:13], s[24:25], 24
; GFX9-NEXT:    s_lshr_b64 s[14:15], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[40:41], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[42:43], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[44:45], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s56, s5, 24
; GFX9-NEXT:    s_lshr_b32 s57, s5, 16
; GFX9-NEXT:    s_lshr_b32 s58, s5, 8
; GFX9-NEXT:    s_lshr_b32 s59, s4, 16
; GFX9-NEXT:    s_lshr_b32 s60, s4, 8
; GFX9-NEXT:    s_lshr_b32 s61, s29, 24
; GFX9-NEXT:    s_lshr_b32 s62, s29, 16
; GFX9-NEXT:    s_lshr_b32 s63, s29, 8
; GFX9-NEXT:    s_lshr_b32 s72, s28, 16
; GFX9-NEXT:    s_lshr_b32 s73, s28, 8
; GFX9-NEXT:    s_lshr_b32 s74, s27, 24
; GFX9-NEXT:    s_lshr_b32 s75, s27, 16
; GFX9-NEXT:    s_lshr_b32 s76, s27, 8
; GFX9-NEXT:    s_lshr_b32 s77, s26, 16
; GFX9-NEXT:    s_lshr_b32 s78, s26, 8
; GFX9-NEXT:    s_lshr_b32 s79, s25, 24
; GFX9-NEXT:    s_lshr_b32 s88, s25, 16
; GFX9-NEXT:    s_lshr_b32 s89, s25, 8
; GFX9-NEXT:    s_lshr_b32 s90, s24, 16
; GFX9-NEXT:    s_lshr_b32 s91, s24, 8
; GFX9-NEXT:    s_lshr_b32 s92, s23, 24
; GFX9-NEXT:    s_lshr_b32 s93, s23, 16
; GFX9-NEXT:    s_lshr_b32 s94, s23, 8
; GFX9-NEXT:    s_lshr_b32 s95, s22, 16
; GFX9-NEXT:    s_lshr_b32 s30, s22, 8
; GFX9-NEXT:    s_lshr_b32 s31, s21, 24
; GFX9-NEXT:    s_lshr_b32 s34, s21, 16
; GFX9-NEXT:    s_lshr_b32 s35, s21, 8
; GFX9-NEXT:    s_lshr_b32 s36, s20, 16
; GFX9-NEXT:    s_lshr_b32 s37, s20, 8
; GFX9-NEXT:    s_lshr_b32 s38, s19, 24
; GFX9-NEXT:    s_lshr_b32 s39, s19, 16
; GFX9-NEXT:    s_lshr_b32 s48, s19, 8
; GFX9-NEXT:    s_lshr_b32 s49, s18, 16
; GFX9-NEXT:    s_lshr_b32 s50, s18, 8
; GFX9-NEXT:    s_lshr_b32 s51, s17, 24
; GFX9-NEXT:    s_lshr_b32 s52, s17, 16
; GFX9-NEXT:    s_lshr_b32 s53, s17, 8
; GFX9-NEXT:    s_lshr_b32 s54, s16, 16
; GFX9-NEXT:    s_lshr_b32 s55, s16, 8
; GFX9-NEXT:  .LBB25_3: ; %end
; GFX9-NEXT:    s_and_b32 s7, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s55, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s54, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s44, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s53, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s52, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s51, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s50, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s49, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s42, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:4
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s19, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s48, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s39, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s38, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:8
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s37, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s36, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s40, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:12
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s21, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s35, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s34, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s31, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:16
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s30, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s95, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s14, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:20
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s23, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s94, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s93, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s92, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:24
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s91, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s90, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s12, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:28
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s25, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s89, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s88, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s79, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s11
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:32
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s78, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s77, 0xff
; GFX9-NEXT:    s_lshl_b32 s10, s10, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s10
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:36
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s27, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s76, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s75, 0xff
; GFX9-NEXT:    s_lshl_b32 s10, s74, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s10
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:40
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s73, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s9
; GFX9-NEXT:    s_and_b32 s9, s72, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:44
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s7, s29, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s63, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s8, s62, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s61, 8
; GFX9-NEXT:    s_or_b32 s8, s8, s9
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:48
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s60, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s7
; GFX9-NEXT:    s_and_b32 s7, s59, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s6
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:52
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    s_and_b32 s4, s5, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s58, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s57, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s56, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:56
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:60
; GFX9-NEXT:    v_readlane_b32 s55, v4, 15
; GFX9-NEXT:    v_readlane_b32 s54, v4, 14
; GFX9-NEXT:    v_readlane_b32 s53, v4, 13
; GFX9-NEXT:    v_readlane_b32 s52, v4, 12
; GFX9-NEXT:    v_readlane_b32 s51, v4, 11
; GFX9-NEXT:    v_readlane_b32 s50, v4, 10
; GFX9-NEXT:    v_readlane_b32 s49, v4, 9
; GFX9-NEXT:    v_readlane_b32 s48, v4, 8
; GFX9-NEXT:    v_readlane_b32 s39, v4, 7
; GFX9-NEXT:    v_readlane_b32 s38, v4, 6
; GFX9-NEXT:    v_readlane_b32 s37, v4, 5
; GFX9-NEXT:    v_readlane_b32 s36, v4, 4
; GFX9-NEXT:    v_readlane_b32 s35, v4, 3
; GFX9-NEXT:    v_readlane_b32 s34, v4, 2
; GFX9-NEXT:    v_readlane_b32 s31, v4, 1
; GFX9-NEXT:    v_readlane_b32 s30, v4, 0
; GFX9-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB25_4:
; GFX9-NEXT:    ; implicit-def: $sgpr55
; GFX9-NEXT:    ; implicit-def: $sgpr54
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr53
; GFX9-NEXT:    ; implicit-def: $sgpr52
; GFX9-NEXT:    ; implicit-def: $sgpr51
; GFX9-NEXT:    ; implicit-def: $sgpr50
; GFX9-NEXT:    ; implicit-def: $sgpr49
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr48
; GFX9-NEXT:    ; implicit-def: $sgpr39
; GFX9-NEXT:    ; implicit-def: $sgpr38
; GFX9-NEXT:    ; implicit-def: $sgpr37
; GFX9-NEXT:    ; implicit-def: $sgpr36
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr35
; GFX9-NEXT:    ; implicit-def: $sgpr34
; GFX9-NEXT:    ; implicit-def: $sgpr31
; GFX9-NEXT:    ; implicit-def: $sgpr30
; GFX9-NEXT:    ; implicit-def: $sgpr95
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr94
; GFX9-NEXT:    ; implicit-def: $sgpr93
; GFX9-NEXT:    ; implicit-def: $sgpr92
; GFX9-NEXT:    ; implicit-def: $sgpr91
; GFX9-NEXT:    ; implicit-def: $sgpr90
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    ; implicit-def: $sgpr89
; GFX9-NEXT:    ; implicit-def: $sgpr88
; GFX9-NEXT:    ; implicit-def: $sgpr79
; GFX9-NEXT:    ; implicit-def: $sgpr78
; GFX9-NEXT:    ; implicit-def: $sgpr77
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr76
; GFX9-NEXT:    ; implicit-def: $sgpr75
; GFX9-NEXT:    ; implicit-def: $sgpr74
; GFX9-NEXT:    ; implicit-def: $sgpr73
; GFX9-NEXT:    ; implicit-def: $sgpr72
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr63
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr61
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    s_branch .LBB25_2
;
; GFX11-LABEL: bitcast_v16i32_to_v64i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_xor_saveexec_b32 s4, -1
; GFX11-NEXT:    scratch_store_b32 off, v17, s32 ; 4-byte Folded Spill
; GFX11-NEXT:    s_mov_b32 exec_lo, s4
; GFX11-NEXT:    v_writelane_b32 v17, s30, 0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 vcc_lo, 0
; GFX11-NEXT:    v_writelane_b32 v17, s31, 1
; GFX11-NEXT:    v_writelane_b32 v17, s34, 2
; GFX11-NEXT:    v_writelane_b32 v17, s35, 3
; GFX11-NEXT:    v_writelane_b32 v17, s36, 4
; GFX11-NEXT:    v_writelane_b32 v17, s37, 5
; GFX11-NEXT:    v_writelane_b32 v17, s38, 6
; GFX11-NEXT:    v_writelane_b32 v17, s39, 7
; GFX11-NEXT:    v_writelane_b32 v17, s48, 8
; GFX11-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s42, s27, 24
; GFX11-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-NEXT:    s_lshr_b32 s44, s27, 8
; GFX11-NEXT:    s_lshr_b32 s45, s26, 16
; GFX11-NEXT:    s_lshr_b32 s46, s26, 8
; GFX11-NEXT:    s_lshr_b32 s47, s25, 24
; GFX11-NEXT:    s_lshr_b32 s56, s25, 16
; GFX11-NEXT:    s_lshr_b32 s57, s25, 8
; GFX11-NEXT:    s_lshr_b32 s58, s24, 16
; GFX11-NEXT:    s_lshr_b32 s59, s24, 8
; GFX11-NEXT:    s_lshr_b32 s60, s23, 24
; GFX11-NEXT:    s_lshr_b32 s61, s23, 16
; GFX11-NEXT:    s_lshr_b32 s62, s23, 8
; GFX11-NEXT:    s_lshr_b32 s63, s22, 16
; GFX11-NEXT:    s_lshr_b32 s72, s22, 8
; GFX11-NEXT:    s_lshr_b32 s73, s21, 24
; GFX11-NEXT:    s_lshr_b32 s74, s21, 16
; GFX11-NEXT:    s_lshr_b32 s75, s21, 8
; GFX11-NEXT:    s_lshr_b32 s76, s20, 16
; GFX11-NEXT:    s_lshr_b32 s77, s20, 8
; GFX11-NEXT:    s_lshr_b32 s78, s19, 24
; GFX11-NEXT:    s_lshr_b32 s79, s19, 16
; GFX11-NEXT:    s_lshr_b32 s88, s19, 8
; GFX11-NEXT:    s_lshr_b32 s89, s18, 16
; GFX11-NEXT:    s_lshr_b32 s90, s18, 8
; GFX11-NEXT:    s_lshr_b32 s91, s17, 24
; GFX11-NEXT:    s_lshr_b32 s92, s17, 16
; GFX11-NEXT:    s_lshr_b32 s93, s17, 8
; GFX11-NEXT:    s_lshr_b32 s94, s16, 16
; GFX11-NEXT:    s_lshr_b32 s95, s16, 8
; GFX11-NEXT:    s_lshr_b32 vcc_hi, s3, 24
; GFX11-NEXT:    s_lshr_b32 s30, s3, 16
; GFX11-NEXT:    s_lshr_b32 s31, s3, 8
; GFX11-NEXT:    s_lshr_b32 s34, s2, 16
; GFX11-NEXT:    s_lshr_b32 s35, s2, 8
; GFX11-NEXT:    s_lshr_b32 s36, s1, 24
; GFX11-NEXT:    s_lshr_b32 s37, s1, 16
; GFX11-NEXT:    s_lshr_b32 s38, s1, 8
; GFX11-NEXT:    s_lshr_b32 s39, s0, 16
; GFX11-NEXT:    s_lshr_b32 s48, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[26:27], 24
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[24:25], 24
; GFX11-NEXT:    s_lshr_b64 s[8:9], s[22:23], 24
; GFX11-NEXT:    s_lshr_b64 s[10:11], s[20:21], 24
; GFX11-NEXT:    s_lshr_b64 s[12:13], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[14:15], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[28:29], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[40:41], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, vcc_lo
; GFX11-NEXT:    s_cbranch_vccnz .LBB25_3
; GFX11-NEXT:  .LBB25_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[26:27], 24
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[24:25], 24
; GFX11-NEXT:    s_lshr_b64 s[8:9], s[22:23], 24
; GFX11-NEXT:    s_lshr_b64 s[10:11], s[20:21], 24
; GFX11-NEXT:    s_lshr_b64 s[12:13], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[14:15], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[28:29], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[40:41], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s42, s27, 24
; GFX11-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-NEXT:    s_lshr_b32 s44, s27, 8
; GFX11-NEXT:    s_lshr_b32 s45, s26, 16
; GFX11-NEXT:    s_lshr_b32 s46, s26, 8
; GFX11-NEXT:    s_lshr_b32 s47, s25, 24
; GFX11-NEXT:    s_lshr_b32 s56, s25, 16
; GFX11-NEXT:    s_lshr_b32 s57, s25, 8
; GFX11-NEXT:    s_lshr_b32 s58, s24, 16
; GFX11-NEXT:    s_lshr_b32 s59, s24, 8
; GFX11-NEXT:    s_lshr_b32 s60, s23, 24
; GFX11-NEXT:    s_lshr_b32 s61, s23, 16
; GFX11-NEXT:    s_lshr_b32 s62, s23, 8
; GFX11-NEXT:    s_lshr_b32 s63, s22, 16
; GFX11-NEXT:    s_lshr_b32 s72, s22, 8
; GFX11-NEXT:    s_lshr_b32 s73, s21, 24
; GFX11-NEXT:    s_lshr_b32 s74, s21, 16
; GFX11-NEXT:    s_lshr_b32 s75, s21, 8
; GFX11-NEXT:    s_lshr_b32 s76, s20, 16
; GFX11-NEXT:    s_lshr_b32 s77, s20, 8
; GFX11-NEXT:    s_lshr_b32 s78, s19, 24
; GFX11-NEXT:    s_lshr_b32 s79, s19, 16
; GFX11-NEXT:    s_lshr_b32 s88, s19, 8
; GFX11-NEXT:    s_lshr_b32 s89, s18, 16
; GFX11-NEXT:    s_lshr_b32 s90, s18, 8
; GFX11-NEXT:    s_lshr_b32 s91, s17, 24
; GFX11-NEXT:    s_lshr_b32 s92, s17, 16
; GFX11-NEXT:    s_lshr_b32 s93, s17, 8
; GFX11-NEXT:    s_lshr_b32 s94, s16, 16
; GFX11-NEXT:    s_lshr_b32 s95, s16, 8
; GFX11-NEXT:    s_lshr_b32 vcc_hi, s3, 24
; GFX11-NEXT:    s_lshr_b32 s30, s3, 16
; GFX11-NEXT:    s_lshr_b32 s31, s3, 8
; GFX11-NEXT:    s_lshr_b32 s34, s2, 16
; GFX11-NEXT:    s_lshr_b32 s35, s2, 8
; GFX11-NEXT:    s_lshr_b32 s36, s1, 24
; GFX11-NEXT:    s_lshr_b32 s37, s1, 16
; GFX11-NEXT:    s_lshr_b32 s38, s1, 8
; GFX11-NEXT:    s_lshr_b32 s39, s0, 16
; GFX11-NEXT:    s_lshr_b32 s48, s0, 8
; GFX11-NEXT:  .LBB25_3: ; %end
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s48, 8
; GFX11-NEXT:    s_and_b32 s7, s39, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s40, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s9
; GFX11-NEXT:    s_and_b32 s1, s1, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s38, 8
; GFX11-NEXT:    s_and_b32 s9, s37, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s36, 8
; GFX11-NEXT:    s_or_b32 s1, s1, s7
; GFX11-NEXT:    s_or_b32 s7, s9, s11
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s5
; GFX11-NEXT:    s_or_b32 s1, s1, s7
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s35, 8
; GFX11-NEXT:    s_and_b32 s7, s34, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s28, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s9
; GFX11-NEXT:    s_and_b32 s3, s3, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s31, 8
; GFX11-NEXT:    s_and_b32 s9, s30, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, vcc_hi, 8
; GFX11-NEXT:    s_or_b32 s3, s3, s7
; GFX11-NEXT:    s_or_b32 s7, s9, s11
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s5
; GFX11-NEXT:    s_or_b32 s3, s3, s7
; GFX11-NEXT:    v_dual_mov_b32 v1, s0 :: v_dual_mov_b32 v2, s1
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v4, s3
; GFX11-NEXT:    s_and_b32 s0, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s95, 8
; GFX11-NEXT:    s_and_b32 s2, s94, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s14, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s17, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s93, 8
; GFX11-NEXT:    s_and_b32 s5, s92, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s91, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s7
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s90, 8
; GFX11-NEXT:    s_and_b32 s5, s89, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s12, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s7
; GFX11-NEXT:    s_and_b32 s5, s19, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s88, 8
; GFX11-NEXT:    s_and_b32 s9, s79, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s78, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s7
; GFX11-NEXT:    s_or_b32 s7, s9, s11
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s7
; GFX11-NEXT:    v_dual_mov_b32 v5, s0 :: v_dual_mov_b32 v6, s1
; GFX11-NEXT:    v_dual_mov_b32 v7, s2 :: v_dual_mov_b32 v8, s3
; GFX11-NEXT:    s_and_b32 s0, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s77, 8
; GFX11-NEXT:    s_and_b32 s2, s76, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s10, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s21, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s75, 8
; GFX11-NEXT:    s_and_b32 s5, s74, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s73, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s7
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s72, 8
; GFX11-NEXT:    s_and_b32 s5, s63, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s8, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s7
; GFX11-NEXT:    s_and_b32 s5, s23, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s62, 8
; GFX11-NEXT:    s_and_b32 s8, s61, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s60, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s7
; GFX11-NEXT:    s_or_b32 s7, s8, s9
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s7
; GFX11-NEXT:    v_dual_mov_b32 v9, s0 :: v_dual_mov_b32 v10, s1
; GFX11-NEXT:    v_dual_mov_b32 v11, s2 :: v_dual_mov_b32 v12, s3
; GFX11-NEXT:    s_and_b32 s0, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s59, 8
; GFX11-NEXT:    s_and_b32 s2, s58, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s6, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s25, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s57, 8
; GFX11-NEXT:    s_and_b32 s5, s56, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s47, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s6
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s26, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s46, 8
; GFX11-NEXT:    s_and_b32 s5, s45, 0xff
; GFX11-NEXT:    s_lshl_b32 s4, s4, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_and_b32 s4, s27, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s44, 8
; GFX11-NEXT:    s_and_b32 s6, s43, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s42, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s6, s7
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s4, s5
; GFX11-NEXT:    v_dual_mov_b32 v13, s0 :: v_dual_mov_b32 v14, s1
; GFX11-NEXT:    v_dual_mov_b32 v15, s2 :: v_dual_mov_b32 v16, s3
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_store_b128 v0, v[1:4], off
; GFX11-NEXT:    scratch_store_b128 v0, v[5:8], off offset:16
; GFX11-NEXT:    scratch_store_b128 v0, v[9:12], off offset:32
; GFX11-NEXT:    scratch_store_b128 v0, v[13:16], off offset:48
; GFX11-NEXT:    v_readlane_b32 s48, v17, 8
; GFX11-NEXT:    v_readlane_b32 s39, v17, 7
; GFX11-NEXT:    v_readlane_b32 s38, v17, 6
; GFX11-NEXT:    v_readlane_b32 s37, v17, 5
; GFX11-NEXT:    v_readlane_b32 s36, v17, 4
; GFX11-NEXT:    v_readlane_b32 s35, v17, 3
; GFX11-NEXT:    v_readlane_b32 s34, v17, 2
; GFX11-NEXT:    v_readlane_b32 s31, v17, 1
; GFX11-NEXT:    v_readlane_b32 s30, v17, 0
; GFX11-NEXT:    s_xor_saveexec_b32 s0, -1
; GFX11-NEXT:    scratch_load_b32 v17, off, s32 ; 4-byte Folded Reload
; GFX11-NEXT:    s_mov_b32 exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB25_4:
; GFX11-NEXT:    ; implicit-def: $sgpr48
; GFX11-NEXT:    ; implicit-def: $sgpr39
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr38
; GFX11-NEXT:    ; implicit-def: $sgpr37
; GFX11-NEXT:    ; implicit-def: $sgpr36
; GFX11-NEXT:    ; implicit-def: $sgpr35
; GFX11-NEXT:    ; implicit-def: $sgpr34
; GFX11-NEXT:    ; implicit-def: $sgpr28
; GFX11-NEXT:    ; implicit-def: $sgpr31
; GFX11-NEXT:    ; implicit-def: $sgpr30
; GFX11-NEXT:    ; implicit-def: $vcc_hi
; GFX11-NEXT:    ; implicit-def: $sgpr95
; GFX11-NEXT:    ; implicit-def: $sgpr94
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr93
; GFX11-NEXT:    ; implicit-def: $sgpr92
; GFX11-NEXT:    ; implicit-def: $sgpr91
; GFX11-NEXT:    ; implicit-def: $sgpr90
; GFX11-NEXT:    ; implicit-def: $sgpr89
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr88
; GFX11-NEXT:    ; implicit-def: $sgpr79
; GFX11-NEXT:    ; implicit-def: $sgpr78
; GFX11-NEXT:    ; implicit-def: $sgpr77
; GFX11-NEXT:    ; implicit-def: $sgpr76
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr75
; GFX11-NEXT:    ; implicit-def: $sgpr74
; GFX11-NEXT:    ; implicit-def: $sgpr73
; GFX11-NEXT:    ; implicit-def: $sgpr72
; GFX11-NEXT:    ; implicit-def: $sgpr63
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr62
; GFX11-NEXT:    ; implicit-def: $sgpr61
; GFX11-NEXT:    ; implicit-def: $sgpr60
; GFX11-NEXT:    ; implicit-def: $sgpr59
; GFX11-NEXT:    ; implicit-def: $sgpr58
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    s_branch .LBB25_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i32> %a, splat (i32 3)
  %a2 = bitcast <16 x i32> %a1 to <64 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i32> %a to <64 x i8>
  br label %end

end:
  %phi = phi <64 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <64 x i8> %phi
}

define <16 x i32> @bitcast_v64i8_to_v16i32(<64 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v64i8_to_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v34, v6
; SI-NEXT:    v_mov_b32_e32 v33, v4
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v31, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:132
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:80
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:88
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:96
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:104
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:112
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:120
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:128
; SI-NEXT:    v_lshlrev_b32_e32 v20, 24, v19
; SI-NEXT:    v_lshlrev_b32_e32 v26, 8, v25
; SI-NEXT:    v_lshlrev_b32_e32 v22, 8, v21
; SI-NEXT:    v_lshlrev_b32_e32 v24, 24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v28, 24, v27
; SI-NEXT:    v_lshlrev_b32_e32 v30, 8, v29
; SI-NEXT:    v_lshlrev_b32_e32 v49, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v48, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v39, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v35, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v36, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v37, 24, v11
; SI-NEXT:    v_lshlrev_b32_e32 v38, 8, v13
; SI-NEXT:    v_lshlrev_b32_e32 v16, 24, v15
; SI-NEXT:    v_lshlrev_b32_e32 v18, 8, v17
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v17, 24, v2
; SI-NEXT:    v_lshlrev_b32_e32 v63, 8, v4
; SI-NEXT:    v_lshlrev_b32_e32 v62, 24, v6
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_lshlrev_b32_e32 v59, 8, v8
; SI-NEXT:    s_waitcnt vmcnt(12)
; SI-NEXT:    v_lshlrev_b32_e32 v56, 24, v10
; SI-NEXT:    s_waitcnt vmcnt(11)
; SI-NEXT:    v_lshlrev_b32_e32 v46, 8, v12
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_lshlrev_b32_e32 v43, 24, v14
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_lshlrev_b32_e32 v41, 8, v50
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_lshlrev_b32_e32 v54, 24, v51
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_lshlrev_b32_e32 v51, 8, v52
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_lshlrev_b32_e32 v21, 24, v53
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_lshlrev_b32_e32 v19, 8, v55
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v40
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v25, 8, v42
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v44
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:116
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_lshlrev_b32_e32 v50, 24, v58
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v47
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:124
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:108
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:100
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:92
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:84
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:76
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:68
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:60
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:52
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB26_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v31
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v32
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v33
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v34
; SI-NEXT:    v_or_b32_e32 v0, v0, v49
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v2, v2, v39
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v48, v1
; SI-NEXT:    v_or_b32_e32 v3, v35, v3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v3
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v57
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v9, v62, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v42
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v56, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v52
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v43, v11
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v58
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v54, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v44
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v21, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v53
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v27, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v29
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v2, v2, v36
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v37, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v16, v4
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v20, v5
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v24, v6
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v28, v7
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v3, v3, v38
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v17, v8
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_or_b32_e32 v4, v4, v18
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_or_b32_e32 v5, v5, v22
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v5, v5, v6
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v6, v6, v26
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v6, v6, v7
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_or_b32_e32 v7, v7, v30
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v60
; SI-NEXT:    v_or_b32_e32 v8, v8, v63
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v8, v8, v9
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v45
; SI-NEXT:    v_or_b32_e32 v9, v9, v59
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_or_b32_e32 v9, v9, v10
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v55
; SI-NEXT:    v_or_b32_e32 v10, v10, v46
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v10, v10, v11
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v61
; SI-NEXT:    v_or_b32_e32 v11, v11, v41
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_or_b32_e32 v11, v11, v12
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v47
; SI-NEXT:    v_or_b32_e32 v12, v12, v51
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_or_b32_e32 v12, v12, v13
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v40
; SI-NEXT:    v_or_b32_e32 v13, v13, v19
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_or_b32_e32 v13, v13, v14
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v23
; SI-NEXT:    v_or_b32_e32 v14, v14, v25
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v14, v14, v15
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v15
; SI-NEXT:    v_or_b32_e32 v15, v15, v16
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v16, 0xff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v50, v16
; SI-NEXT:    v_or_b32_e32 v15, v15, v16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; kill: killed $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; kill: killed $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:  .LBB26_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB26_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v32
; SI-NEXT:    v_or_b32_e32 v0, v49, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_or_b32_e32 v1, v48, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v34
; SI-NEXT:    v_or_b32_e32 v1, v39, v1
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v35, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v57
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v9, v62, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v42
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v56, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v43, v11
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v58
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v54, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v44
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v21, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v53
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v27, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v29
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s7, v1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_or_b32_e32 v2, v36, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_or_b32_e32 v3, v37, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v2, vcc, s7, v2
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v16, v4
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v20, v5
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v24, v6
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v28, v7
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v3, v38, v3
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, s7, v3
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v17, v8
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_or_b32_e32 v4, v18, v4
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v4, vcc, s7, v4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_or_b32_e32 v5, v22, v5
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v5, vcc, s7, v5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v6, v26, v6
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v6, vcc, s7, v6
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_or_b32_e32 v7, v30, v7
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v60
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_or_b32_e32 v8, v63, v8
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v45
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v9
; SI-NEXT:    v_or_b32_e32 v9, v59, v9
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v55
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v10, v46, v10
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v61
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v11
; SI-NEXT:    v_or_b32_e32 v11, v41, v11
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v47
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v12
; SI-NEXT:    v_or_b32_e32 v12, v51, v12
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v40
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v13
; SI-NEXT:    v_or_b32_e32 v13, v19, v13
; SI-NEXT:    v_add_i32_e32 v13, vcc, s6, v13
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v23
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v14
; SI-NEXT:    v_or_b32_e32 v14, v25, v14
; SI-NEXT:    v_add_i32_e32 v14, vcc, s6, v14
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v7, vcc, s7, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s7, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s7, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s7, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, s7, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s7, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, s7, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x3000000, v14
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v15
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x300, v15
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_and_b32_e32 v16, 0xff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v50, v16
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x3000000, v15
; SI-NEXT:  .LBB26_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v64i8_to_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:132
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:8
; VI-NEXT:    buffer_load_ushort v6, off, s[0:3], s32 offset:16
; VI-NEXT:    buffer_load_ushort v8, off, s[0:3], s32 offset:24
; VI-NEXT:    buffer_load_ushort v10, off, s[0:3], s32 offset:32
; VI-NEXT:    buffer_load_ushort v12, off, s[0:3], s32 offset:40
; VI-NEXT:    buffer_load_ushort v14, off, s[0:3], s32 offset:48
; VI-NEXT:    buffer_load_ushort v26, off, s[0:3], s32 offset:56
; VI-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:64
; VI-NEXT:    buffer_load_ushort v39, off, s[0:3], s32 offset:72
; VI-NEXT:    buffer_load_ushort v48, off, s[0:3], s32 offset:80
; VI-NEXT:    buffer_load_ushort v49, off, s[0:3], s32 offset:88
; VI-NEXT:    buffer_load_ushort v52, off, s[0:3], s32 offset:96
; VI-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:104
; VI-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:112
; VI-NEXT:    buffer_load_ushort v41, off, s[0:3], s32 offset:120
; VI-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:128
; VI-NEXT:    v_lshlrev_b16_e32 v20, 8, v19
; VI-NEXT:    v_lshlrev_b16_e32 v22, 8, v21
; VI-NEXT:    v_lshlrev_b16_e32 v24, 8, v23
; VI-NEXT:    v_lshlrev_b16_e32 v28, 8, v25
; VI-NEXT:    v_lshlrev_b16_e32 v30, 8, v27
; VI-NEXT:    v_lshlrev_b16_e32 v63, 8, v29
; VI-NEXT:    v_lshlrev_b16_e32 v18, 8, v17
; VI-NEXT:    buffer_load_ushort v17, off, s[0:3], s32 offset:124
; VI-NEXT:    v_lshlrev_b16_e32 v31, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v32, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v33, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v34, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v35, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v36, 8, v11
; VI-NEXT:    v_lshlrev_b16_e32 v37, 8, v13
; VI-NEXT:    v_lshlrev_b16_e32 v16, 8, v15
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_lshlrev_b16_e32 v62, 8, v2
; VI-NEXT:    v_lshlrev_b16_e32 v59, 8, v4
; VI-NEXT:    v_lshlrev_b16_e32 v57, 8, v6
; VI-NEXT:    v_lshlrev_b16_e32 v56, 8, v8
; VI-NEXT:    s_waitcnt vmcnt(13)
; VI-NEXT:    v_lshlrev_b16_e32 v46, 8, v10
; VI-NEXT:    s_waitcnt vmcnt(12)
; VI-NEXT:    v_lshlrev_b16_e32 v44, 8, v12
; VI-NEXT:    s_waitcnt vmcnt(11)
; VI-NEXT:    v_lshlrev_b16_e32 v42, 8, v14
; VI-NEXT:    s_waitcnt vmcnt(10)
; VI-NEXT:    v_lshlrev_b16_e32 v55, 8, v26
; VI-NEXT:    s_waitcnt vmcnt(9)
; VI-NEXT:    v_lshlrev_b16_e32 v54, 8, v38
; VI-NEXT:    s_waitcnt vmcnt(8)
; VI-NEXT:    v_lshlrev_b16_e32 v51, 8, v39
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_lshlrev_b16_e32 v50, 8, v48
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v49
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_lshlrev_b16_e32 v39, 8, v52
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v25, 8, v53
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b16_e32 v21, 8, v40
; VI-NEXT:    buffer_load_ushort v23, off, s[0:3], s32 offset:44
; VI-NEXT:    buffer_load_ushort v29, off, s[0:3], s32 offset:36
; VI-NEXT:    buffer_load_ushort v49, off, s[0:3], s32 offset:28
; VI-NEXT:    buffer_load_ushort v52, off, s[0:3], s32 offset:20
; VI-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:12
; VI-NEXT:    buffer_load_ushort v43, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_ushort v19, off, s[0:3], s32 offset:116
; VI-NEXT:    s_waitcnt vmcnt(9)
; VI-NEXT:    v_lshlrev_b16_e32 v27, 8, v41
; VI-NEXT:    s_waitcnt vmcnt(8)
; VI-NEXT:    v_lshlrev_b16_e32 v60, 8, v45
; VI-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:108
; VI-NEXT:    buffer_load_ushort v41, off, s[0:3], s32 offset:100
; VI-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:92
; VI-NEXT:    buffer_load_ushort v47, off, s[0:3], s32 offset:84
; VI-NEXT:    buffer_load_ushort v58, off, s[0:3], s32 offset:76
; VI-NEXT:    buffer_load_ushort v61, off, s[0:3], s32 offset:68
; VI-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:60
; VI-NEXT:    buffer_load_ushort v26, off, s[0:3], s32 offset:52
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_or_b32_sdwa v9, v40, v57 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v49, v46 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v23, v42 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_or_b32_sdwa v12, v38, v54 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v58, v50 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v45, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v53, v21 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr57
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(8)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v32 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_or_b32_sdwa v2, v2, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_or_b32_sdwa v3, v3, v34 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_or_b32_sdwa v4, v4, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_or_b32_sdwa v5, v5, v20 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_or_b32_sdwa v6, v6, v24 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_or_b32_sdwa v7, v7, v30 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v17, v60 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr60
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_sdwa v8, v8, v62 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr62
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v2, v2, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v3, v3, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v4, v4, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v5, v5, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v6, v6, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v7, v7, v63 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v43, v59 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v52, v56 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v29, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v26, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v61, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v47, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v41, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v19, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; kill: killed $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr61
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr59
; VI-NEXT:    ; implicit-def: $vgpr56
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:  .LBB26_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; VI-NEXT:    v_mov_b32_e32 v15, 0x300
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_add_u16_e32 v9, 3, v40
; VI-NEXT:    v_or_b32_sdwa v9, v57, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v9, v9, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v10, 3, v49
; VI-NEXT:    v_or_b32_sdwa v10, v46, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v10, v10, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v11, 3, v23
; VI-NEXT:    v_or_b32_sdwa v11, v42, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v11, v11, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_add_u16_e32 v12, 3, v38
; VI-NEXT:    v_or_b32_sdwa v12, v54, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v12, v12, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v13, 3, v58
; VI-NEXT:    v_or_b32_sdwa v13, v50, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v13, v13, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v14, 3, v45
; VI-NEXT:    v_or_b32_sdwa v14, v39, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v14, v14, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v17, 3, v17
; VI-NEXT:    v_or_b32_sdwa v17, v60, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(8)
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_add_u16_e32 v1, 3, v1
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_add_u16_e32 v2, 3, v2
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_add_u16_e32 v3, 3, v3
; VI-NEXT:    v_or_b32_sdwa v0, v31, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v32, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v2, v33, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v34, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v2, 0x300, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v1, v2, v3
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_add_u16_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_sdwa v4, v16, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v4, v4, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_add_u16_e32 v5, 3, v5
; VI-NEXT:    v_or_b32_sdwa v5, v20, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v5, v5, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_add_u16_e32 v6, 3, v6
; VI-NEXT:    v_or_b32_sdwa v6, v24, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v6, v6, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_add_u16_e32 v7, 3, v7
; VI-NEXT:    v_or_b32_sdwa v7, v30, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v7, v7, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v16, 3, v53
; VI-NEXT:    v_or_b32_sdwa v16, v21, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v16, v16, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u16_e32 v8, 3, v8
; VI-NEXT:    v_or_b32_sdwa v8, v62, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v8, v8, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v2, 3, v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v3, 3, v3
; VI-NEXT:    v_or_b32_sdwa v2, v35, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v36, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v2, 0x300, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_sdwa v15, v17, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v3, 3, v3
; VI-NEXT:    v_or_b32_sdwa v3, v37, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_sdwa v4, v18, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v4, 0x300, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v5, 3, v5
; VI-NEXT:    v_or_b32_sdwa v5, v22, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v5, 0x300, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v6, 3, v6
; VI-NEXT:    v_or_b32_sdwa v6, v28, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v6, 0x300, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v7
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v7, 3, v7
; VI-NEXT:    v_or_b32_sdwa v7, v63, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v7, 0x300, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v43
; VI-NEXT:    v_or_b32_sdwa v8, v59, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v8, 0x300, v8
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_add_u16_e32 v9, 3, v52
; VI-NEXT:    v_or_b32_sdwa v9, v56, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v9, 0x300, v9
; VI-NEXT:    v_or_b32_e32 v9, v9, v10
; VI-NEXT:    v_add_u16_e32 v10, 3, v29
; VI-NEXT:    v_or_b32_sdwa v10, v44, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v10, 0x300, v10
; VI-NEXT:    v_or_b32_e32 v10, v10, v11
; VI-NEXT:    v_add_u16_e32 v11, 3, v26
; VI-NEXT:    v_or_b32_sdwa v11, v55, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v11, 0x300, v11
; VI-NEXT:    v_or_b32_e32 v11, v11, v12
; VI-NEXT:    v_add_u16_e32 v12, 3, v61
; VI-NEXT:    v_or_b32_sdwa v12, v51, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v12, 0x300, v12
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_add_u16_e32 v13, 3, v47
; VI-NEXT:    v_or_b32_sdwa v13, v48, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v13, 0x300, v13
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_u16_e32 v14, 3, v41
; VI-NEXT:    v_or_b32_sdwa v14, v25, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v14, 0x300, v14
; VI-NEXT:    v_or_b32_e32 v14, v14, v16
; VI-NEXT:    v_add_u16_e32 v16, 3, v19
; VI-NEXT:    v_or_b32_sdwa v16, v27, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v16, 0x300, v16
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:  .LBB26_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v64i8_to_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:132
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:8
; GFX9-NEXT:    buffer_load_ushort v6, off, s[0:3], s32 offset:16
; GFX9-NEXT:    buffer_load_ushort v8, off, s[0:3], s32 offset:24
; GFX9-NEXT:    buffer_load_ushort v10, off, s[0:3], s32 offset:32
; GFX9-NEXT:    buffer_load_ushort v12, off, s[0:3], s32 offset:40
; GFX9-NEXT:    buffer_load_ushort v14, off, s[0:3], s32 offset:48
; GFX9-NEXT:    buffer_load_ushort v26, off, s[0:3], s32 offset:56
; GFX9-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:64
; GFX9-NEXT:    buffer_load_ushort v39, off, s[0:3], s32 offset:72
; GFX9-NEXT:    buffer_load_ushort v48, off, s[0:3], s32 offset:80
; GFX9-NEXT:    buffer_load_ushort v49, off, s[0:3], s32 offset:88
; GFX9-NEXT:    buffer_load_ushort v52, off, s[0:3], s32 offset:96
; GFX9-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:104
; GFX9-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:112
; GFX9-NEXT:    buffer_load_ushort v41, off, s[0:3], s32 offset:120
; GFX9-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:128
; GFX9-NEXT:    v_lshlrev_b16_e32 v20, 8, v19
; GFX9-NEXT:    v_lshlrev_b16_e32 v22, 8, v21
; GFX9-NEXT:    v_lshlrev_b16_e32 v24, 8, v23
; GFX9-NEXT:    v_lshlrev_b16_e32 v28, 8, v25
; GFX9-NEXT:    v_lshlrev_b16_e32 v30, 8, v27
; GFX9-NEXT:    v_lshlrev_b16_e32 v63, 8, v29
; GFX9-NEXT:    v_lshlrev_b16_e32 v18, 8, v17
; GFX9-NEXT:    buffer_load_ushort v17, off, s[0:3], s32 offset:124
; GFX9-NEXT:    v_lshlrev_b16_e32 v31, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v32, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v34, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v35, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v36, 8, v11
; GFX9-NEXT:    v_lshlrev_b16_e32 v37, 8, v13
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 8, v15
; GFX9-NEXT:    s_waitcnt vmcnt(18)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(17)
; GFX9-NEXT:    v_lshlrev_b16_e32 v62, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(16)
; GFX9-NEXT:    v_lshlrev_b16_e32 v59, 8, v4
; GFX9-NEXT:    s_waitcnt vmcnt(15)
; GFX9-NEXT:    v_lshlrev_b16_e32 v57, 8, v6
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_lshlrev_b16_e32 v56, 8, v8
; GFX9-NEXT:    s_waitcnt vmcnt(13)
; GFX9-NEXT:    v_lshlrev_b16_e32 v46, 8, v10
; GFX9-NEXT:    s_waitcnt vmcnt(12)
; GFX9-NEXT:    v_lshlrev_b16_e32 v44, 8, v12
; GFX9-NEXT:    s_waitcnt vmcnt(11)
; GFX9-NEXT:    v_lshlrev_b16_e32 v42, 8, v14
; GFX9-NEXT:    s_waitcnt vmcnt(10)
; GFX9-NEXT:    v_lshlrev_b16_e32 v55, 8, v26
; GFX9-NEXT:    s_waitcnt vmcnt(9)
; GFX9-NEXT:    v_lshlrev_b16_e32 v54, 8, v38
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_lshlrev_b16_e32 v51, 8, v39
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_lshlrev_b16_e32 v50, 8, v48
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_lshlrev_b16_e32 v48, 8, v49
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_lshlrev_b16_e32 v39, 8, v52
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v25, 8, v53
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_lshlrev_b16_e32 v21, 8, v40
; GFX9-NEXT:    buffer_load_ushort v23, off, s[0:3], s32 offset:44
; GFX9-NEXT:    buffer_load_ushort v29, off, s[0:3], s32 offset:36
; GFX9-NEXT:    buffer_load_ushort v49, off, s[0:3], s32 offset:28
; GFX9-NEXT:    buffer_load_ushort v52, off, s[0:3], s32 offset:20
; GFX9-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:12
; GFX9-NEXT:    buffer_load_ushort v43, off, s[0:3], s32 offset:4
; GFX9-NEXT:    buffer_load_ushort v19, off, s[0:3], s32 offset:116
; GFX9-NEXT:    s_waitcnt vmcnt(9)
; GFX9-NEXT:    v_lshlrev_b16_e32 v27, 8, v41
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_lshlrev_b16_e32 v60, 8, v45
; GFX9-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:108
; GFX9-NEXT:    buffer_load_ushort v41, off, s[0:3], s32 offset:100
; GFX9-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:92
; GFX9-NEXT:    buffer_load_ushort v47, off, s[0:3], s32 offset:84
; GFX9-NEXT:    buffer_load_ushort v58, off, s[0:3], s32 offset:76
; GFX9-NEXT:    buffer_load_ushort v61, off, s[0:3], s32 offset:68
; GFX9-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:60
; GFX9-NEXT:    buffer_load_ushort v26, off, s[0:3], s32 offset:52
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_or_b32_sdwa v9, v40, v57 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v10, v49, v46 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v11, v23, v42 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_or_b32_sdwa v12, v38, v54 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v13, v58, v50 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v14, v45, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v15, v53, v21 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v32 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v34 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v20 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v24 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v30 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v16, v17, v60 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_or_b32_sdwa v8, v8, v62 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v63 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v43, v59 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v9, v52, v56 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v9, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v10, v29, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v10, v10, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v11, v26, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v11, v11, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v12, v61, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v12, v12, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v13, v47, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v13, v13, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v14, v41, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v14, v14, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v15, v19, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v15, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; kill: killed $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:  .LBB26_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_add_u16_e32 v9, 3, v40
; GFX9-NEXT:    v_or_b32_sdwa v9, v57, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v9, v9, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v10, 3, v49
; GFX9-NEXT:    v_or_b32_sdwa v10, v46, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v10, v10, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v11, 3, v23
; GFX9-NEXT:    v_or_b32_sdwa v11, v42, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v11, v11, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_add_u16_e32 v12, 3, v38
; GFX9-NEXT:    v_or_b32_sdwa v12, v54, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v12, v12, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v13, 3, v58
; GFX9-NEXT:    v_or_b32_sdwa v13, v50, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v13, v13, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v14, 3, v45
; GFX9-NEXT:    v_or_b32_sdwa v14, v39, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v14, v14, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v15, 3, v53
; GFX9-NEXT:    v_or_b32_sdwa v15, v21, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v15, v15, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v0
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v1
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v2
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v3
; GFX9-NEXT:    v_or_b32_sdwa v0, v31, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v32, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v33, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v34, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v4
; GFX9-NEXT:    v_or_b32_sdwa v4, v16, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v4, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v5
; GFX9-NEXT:    v_or_b32_sdwa v5, v20, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v5, v5, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v6, v24, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v6, v6, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v7
; GFX9-NEXT:    v_or_b32_sdwa v7, v30, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v7, v7, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v16, 3, v17
; GFX9-NEXT:    v_or_b32_sdwa v16, v60, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v16, v16, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_add_u16_e32 v8, 3, v8
; GFX9-NEXT:    v_or_b32_sdwa v8, v62, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v8, v8, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v3
; GFX9-NEXT:    v_or_b32_sdwa v2, v35, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v36, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v3
; GFX9-NEXT:    v_or_b32_sdwa v3, v37, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v3, 0x300, v3
; GFX9-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v4
; GFX9-NEXT:    v_or_b32_sdwa v4, v18, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v4, 0x300, v4
; GFX9-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v5
; GFX9-NEXT:    v_or_b32_sdwa v5, v22, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v5, 0x300, v5
; GFX9-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v6, v28, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v6, 0x300, v6
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v7
; GFX9-NEXT:    v_or_b32_sdwa v7, v63, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v7, 0x300, v7
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX9-NEXT:    v_add_u16_e32 v8, 3, v43
; GFX9-NEXT:    v_or_b32_sdwa v8, v59, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v8, 0x300, v8
; GFX9-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX9-NEXT:    v_add_u16_e32 v9, 3, v52
; GFX9-NEXT:    v_or_b32_sdwa v9, v56, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v9, 0x300, v9
; GFX9-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX9-NEXT:    v_add_u16_e32 v10, 3, v29
; GFX9-NEXT:    v_or_b32_sdwa v10, v44, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v10, 0x300, v10
; GFX9-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX9-NEXT:    v_add_u16_e32 v11, 3, v26
; GFX9-NEXT:    v_or_b32_sdwa v11, v55, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v11, 0x300, v11
; GFX9-NEXT:    v_or_b32_e32 v11, v11, v12
; GFX9-NEXT:    v_add_u16_e32 v12, 3, v61
; GFX9-NEXT:    v_or_b32_sdwa v12, v51, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v12, 0x300, v12
; GFX9-NEXT:    v_or_b32_e32 v12, v12, v13
; GFX9-NEXT:    v_add_u16_e32 v13, 3, v47
; GFX9-NEXT:    v_or_b32_sdwa v13, v48, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v13, 0x300, v13
; GFX9-NEXT:    v_or_b32_e32 v13, v13, v14
; GFX9-NEXT:    v_add_u16_e32 v14, 3, v41
; GFX9-NEXT:    v_or_b32_sdwa v14, v25, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v14, 0x300, v14
; GFX9-NEXT:    v_or_b32_e32 v14, v14, v15
; GFX9-NEXT:    v_add_u16_e32 v15, 3, v19
; GFX9-NEXT:    v_or_b32_sdwa v15, v27, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v15, 0x300, v15
; GFX9-NEXT:    v_or_b32_e32 v15, v15, v16
; GFX9-NEXT:  .LBB26_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v64i8_to_v16i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_clause 0x1f
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v64, off, s32 offset:128
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v31, off, s32 offset:124
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v64, off, s32 offset:120
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v31, off, s32 offset:116
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v65, off, s32 offset:112
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v32, off, s32 offset:108
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v65, off, s32 offset:104
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v32, off, s32 offset:100
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v66, off, s32 offset:96
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v33, off, s32 offset:92
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v66, off, s32 offset:88
; GFX11-TRUE16-NEXT:    scratch_load_b32 v82, off, s32 offset:132
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v67, off, s32
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v67, off, s32 offset:8
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v68, off, s32 offset:16
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v68, off, s32 offset:24
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v69, off, s32 offset:32
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v69, off, s32 offset:40
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v70, off, s32 offset:48
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v70, off, s32 offset:56
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v71, off, s32 offset:64
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v71, off, s32 offset:72
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v80, off, s32 offset:80
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v33, off, s32 offset:84
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v34, off, s32 offset:76
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v34, off, s32 offset:68
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v35, off, s32 offset:60
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v35, off, s32 offset:52
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v36, off, s32 offset:44
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v36, off, s32 offset:36
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v37, off, s32 offset:28
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v37, off, s32 offset:20
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v38, off, s32 offset:12
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v38, off, s32 offset:4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v80.h, v29.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v81.l, v27.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v22.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v27.h, v20.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v28.h, v18.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v29.l, v16.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v29.h, v14.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.h, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.l, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.h, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v54.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v54.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v52.h, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v51.h, 8, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v52.l, 8, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v51.l, 8, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v50.h, 8, v13.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v30.h, 8, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v39.l, 8, v17.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v39.h, 8, v19.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v48.l, 8, v21.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v48.h, 8, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v23.h, 8, v25.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v24.h, 8, v81.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v25.l, 8, v80.h
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(33)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.l, 8, v64.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(31)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v64.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(29)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.l, 8, v65.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(27)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.h, 8, v65.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(25)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.l, 8, v66.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(23)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v20.h, 8, v66.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(21)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v25.h, 8, v67.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(20)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v26.h, 8, v67.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(19)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v21.l, 8, v68.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(18)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v21.h, 8, v68.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(17)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v22.l, 8, v69.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(16)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v22.h, 8, v69.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(15)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v23.l, 8, v70.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(14)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v70.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(13)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.l, 8, v71.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(12)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.h, 8, v71.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(11)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v20.l, 8, v80.l
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v82
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB26_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB26_4
; GFX11-TRUE16-NEXT:  .LBB26_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB26_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v55.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v55.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v53.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v53.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v49.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v54.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v54.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v50.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v49.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v50.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v1.l, v52.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.h, v51.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v52.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v2.h, v51.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v6, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v29.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v29.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v28.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v27.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v27.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v30.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v1.h, v39.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.l, v39.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v2.h, v48.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v48.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v7
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, 0xff, v24.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v28.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v8, v9
; GFX11-TRUE16-NEXT:    v_and_b16 v6.h, 0xff, v26.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v30.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v38.h
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v6.l, v23.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v25.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v10, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v5, v13
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v6.h, v24.h
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v7.h, v25.h
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v26.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, 0xff, v38.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v37.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v4, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b16 v6.h, 0xff, v37.h
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v36.h
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v36.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v6.l, v21.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v22.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v6.h, v21.h
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v7.h, v22.h
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v13, v14
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v35.h
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v34.h
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v33.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v8
; GFX11-TRUE16-NEXT:    v_and_b16 v11.h, 0xff, v35.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v34.l
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v11.l, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v19.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v20.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v15, v21
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v10, v23
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v11.h, v19.l
; GFX11-TRUE16-NEXT:    v_or_b16 v15.l, v12.h, v20.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v23, 0xffff, v13
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v33.l
; GFX11-TRUE16-NEXT:    v_and_b16 v11.h, 0xff, v32.h
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v32.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v31.h
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v31.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v9, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v15
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v11.l, v16.l
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v11.h, v16.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v17.l
; GFX11-TRUE16-NEXT:    v_or_b16 v15.l, v12.h, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v18.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v12
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v13
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v19, v20
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v21, v22
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v23, v16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v14, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v15, v18
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr55_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr55_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr53_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr53_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr50_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr49_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr49_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr29_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr29_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr28_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr27_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr27_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr24_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr26_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr28_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr30_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr38_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr38_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr37_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr37_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr33_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr33_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr32_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr32_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr31_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr31_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr54_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr54_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr52_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr51_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr52_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr51_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr50_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr30_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr39_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr39_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr48_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr48_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr23_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr24_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr25_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr25_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr26_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr22_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr22_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr23_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_lo16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-TRUE16-NEXT:  .LBB26_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v55.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v55.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v53.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v53.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v50.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v49.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v49.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v54.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v54.h, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v52.h, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v51.h, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v52.l, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v51.l, v0.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v50.h, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v29.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v29.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v28.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v27.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v27.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v30.h, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v39.l, v1.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v39.h, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v48.l, v2.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, v24.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, v28.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v48.h, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.h, v26.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.h, v30.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, 0xff, v6.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v6.h, 0xff, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v23.h, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v25.l, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v8, v9
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, v38.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v6.h, v24.h, v6.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.h, v25.h, v7.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v6.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v7.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v10, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v5, v13
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, v38.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, v37.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v26.h, v8.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v9.l, 0x300, v6.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v10.l, 0x300, v7.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.h, v37.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.h, v36.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, 0xff, v6.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, 0x300, v8.l
; GFX11-TRUE16-NEXT:    v_and_b16 v6.h, 0xff, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v21.l, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v22.l, v7.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v4, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, v36.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v6.h, v21.h, v6.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.h, v22.h, v7.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v6.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v9.l, 0x300, v6.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v10.l, 0x300, v7.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v13, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.l, v35.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, v34.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, v33.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v23.l, v8.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.h, v35.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.h, v34.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v11.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v12.l
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, 0x300, v8.l
; GFX11-TRUE16-NEXT:    v_and_b16 v11.h, 0xff, v11.h
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v12.h
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v18.h, v11.l
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v19.h, v12.l
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v20.h, v13.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v8
; GFX11-TRUE16-NEXT:    v_or_b16 v11.h, v19.l, v11.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.h, v20.l, v12.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.l, 0x300, v11.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, 0x300, v12.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, 0x300, v13.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v15, v21
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v10, v23
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v14.l, 0x300, v11.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v15.l, 0x300, v12.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v23, 0xffff, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.l, v33.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.h, v32.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, v32.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.h, v31.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, v31.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v11.l
; GFX11-TRUE16-NEXT:    v_and_b16 v11.h, 0xff, v11.h
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v12.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v12.h
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v16.l, v11.l
; GFX11-TRUE16-NEXT:    v_or_b16 v11.h, v16.h, v11.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v17.l, v12.l
; GFX11-TRUE16-NEXT:    v_or_b16 v12.h, v17.h, v12.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v18.l, v13.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v9, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.l, 0x300, v11.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v14.l, 0x300, v11.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, 0x300, v12.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v15.l, 0x300, v12.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, 0x300, v13.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v12
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v13
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v19, v20
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v21, v22
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v23, v16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v14, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v15, v18
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v64i8_to_v16i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v38, v14 :: v_dual_mov_b32 v37, v12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v36, v10 :: v_dual_mov_b32 v35, v8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v34, v6 :: v_dual_mov_b32 v33, v4
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v32, v2 :: v_dual_mov_b32 v31, v0
; GFX11-FAKE16-NEXT:    s_clause 0x1f
; GFX11-FAKE16-NEXT:    scratch_load_u16 v0, off, s32 offset:128
; GFX11-FAKE16-NEXT:    scratch_load_u16 v39, off, s32 offset:124
; GFX11-FAKE16-NEXT:    scratch_load_u16 v2, off, s32 offset:120
; GFX11-FAKE16-NEXT:    scratch_load_u16 v48, off, s32 offset:116
; GFX11-FAKE16-NEXT:    scratch_load_u16 v4, off, s32 offset:112
; GFX11-FAKE16-NEXT:    scratch_load_u16 v49, off, s32 offset:108
; GFX11-FAKE16-NEXT:    scratch_load_u16 v6, off, s32 offset:104
; GFX11-FAKE16-NEXT:    scratch_load_u16 v50, off, s32 offset:100
; GFX11-FAKE16-NEXT:    scratch_load_u16 v8, off, s32 offset:96
; GFX11-FAKE16-NEXT:    scratch_load_u16 v51, off, s32 offset:92
; GFX11-FAKE16-NEXT:    scratch_load_u16 v10, off, s32 offset:88
; GFX11-FAKE16-NEXT:    scratch_load_b32 v12, off, s32 offset:132
; GFX11-FAKE16-NEXT:    scratch_load_u16 v14, off, s32
; GFX11-FAKE16-NEXT:    scratch_load_u16 v65, off, s32 offset:8
; GFX11-FAKE16-NEXT:    scratch_load_u16 v66, off, s32 offset:16
; GFX11-FAKE16-NEXT:    scratch_load_u16 v67, off, s32 offset:24
; GFX11-FAKE16-NEXT:    scratch_load_u16 v83, off, s32 offset:32
; GFX11-FAKE16-NEXT:    scratch_load_u16 v84, off, s32 offset:40
; GFX11-FAKE16-NEXT:    scratch_load_u16 v85, off, s32 offset:48
; GFX11-FAKE16-NEXT:    scratch_load_u16 v128, off, s32 offset:56
; GFX11-FAKE16-NEXT:    scratch_load_u16 v129, off, s32 offset:64
; GFX11-FAKE16-NEXT:    scratch_load_u16 v130, off, s32 offset:72
; GFX11-FAKE16-NEXT:    scratch_load_u16 v131, off, s32 offset:80
; GFX11-FAKE16-NEXT:    scratch_load_u16 v52, off, s32 offset:84
; GFX11-FAKE16-NEXT:    scratch_load_u16 v53, off, s32 offset:76
; GFX11-FAKE16-NEXT:    scratch_load_u16 v54, off, s32 offset:68
; GFX11-FAKE16-NEXT:    scratch_load_u16 v55, off, s32 offset:60
; GFX11-FAKE16-NEXT:    scratch_load_u16 v64, off, s32 offset:52
; GFX11-FAKE16-NEXT:    scratch_load_u16 v68, off, s32 offset:44
; GFX11-FAKE16-NEXT:    scratch_load_u16 v69, off, s32 offset:36
; GFX11-FAKE16-NEXT:    scratch_load_u16 v70, off, s32 offset:28
; GFX11-FAKE16-NEXT:    scratch_load_u16 v71, off, s32 offset:20
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    scratch_load_u16 v80, off, s32 offset:12
; GFX11-FAKE16-NEXT:    scratch_load_u16 v86, off, s32 offset:4
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v118, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v119, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v117, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v114, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v115, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v116, 8, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v113, 8, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v100, 8, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v101, 8, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v102, 8, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v103, 8, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v112, 8, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v87, 8, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v96, 8, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v97, 8, v29
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(33)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v25, 8, v0
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(31)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v23, 8, v2
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(29)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v4
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(27)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v19, 8, v6
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(25)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v8
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(22)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(21)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v98, 8, v14
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(20)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v99, 8, v65
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(19)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v81, 8, v66
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(18)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v82, 8, v67
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(17)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v83, 8, v83
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(16)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v84, 8, v84
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(15)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v85, 8, v85
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(14)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v27, 8, v128
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(13)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v29, 8, v129
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(12)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v65, 8, v130
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(11)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v66, 8, v131
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v67, 8, v10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB26_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB26_4
; GFX11-FAKE16-NEXT:  .LBB26_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB26_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v32
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v37
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v34
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v118
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v119
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v35
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v36
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v117
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v6, v113
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v114
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v115
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v116
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v101
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v38
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v102
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v103
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v112
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v100
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v6, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v9, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v30
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v86
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v80
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v71
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v70
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v69
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v68
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v87
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v96
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v97
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v98
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v99
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v81
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v82
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v83
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v14, v84
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v85
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v14, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v64
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v55
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v54
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v53
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v52
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v51
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xff, v50
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v49
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v48
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v39
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v65
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v14, v66
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v67
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v16, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v18, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v20, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v22, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v24, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v13, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v15, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v17, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v19, v20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr86
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr80
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr55
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr118
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr119
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr117
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr114
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr115
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr116
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr113
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr100
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr101
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr102
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr103
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr112
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr87
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr96
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr97
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr98
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr99
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr81
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr82
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr83
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr84
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr85
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr67
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-FAKE16-NEXT:  .LBB26_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v31, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v32, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v33, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v34, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v35, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v36, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v37, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v118, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v119, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v117, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v114, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v115, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v116, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v113, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, v16, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v38, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v18, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, v20, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, v22, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v101, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v100, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v102, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v103, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v112, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, 0x300, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, 0x300, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v9, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v24, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, v26, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v28, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, v30, 3
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, v86, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, v80, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, v71, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, v70, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, v69, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, v68, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v87, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v96, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v97, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v98, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v99, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v81, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v82, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v83, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v84, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v85, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, 0x300, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, 0x300, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, 0x300, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, 0x300, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, 0x300, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v14, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, v64, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, v55, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, v54, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, v53, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, v52, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, v51, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v18, v50, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v20, v49, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v22, v48, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v24, v39, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xff, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v27, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v29, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v65, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v66, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v67, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v17, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v19, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v21, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v23, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v25, v24
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, 0x300, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, 0x300, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, 0x300, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, 0x300, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v17, 0x300, v17
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v18, 0x300, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v19, 0x300, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v20, 0x300, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v13, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v15, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v17, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v19, v20
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <64 x i8> %a, splat (i8 3)
  %a2 = bitcast <64 x i8> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <64 x i8> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define inreg <16 x i32> @bitcast_v64i8_to_v16i32_scalar(<64 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v64i8_to_v16i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v48, v30
; SI-NEXT:    v_mov_b32_e32 v33, v4
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v31, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:76
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:16
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v34, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:52
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:60
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v37, off, s[0:3], s32 offset:68
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v3
; SI-NEXT:    v_lshlrev_b32_e32 v40, 24, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 8, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 24, v9
; SI-NEXT:    v_lshlrev_b32_e32 v59, 8, v11
; SI-NEXT:    v_lshlrev_b32_e32 v58, 24, v13
; SI-NEXT:    v_lshlrev_b32_e32 v57, 8, v15
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v17
; SI-NEXT:    v_lshlrev_b32_e32 v56, 8, v19
; SI-NEXT:    v_lshlrev_b32_e32 v47, 24, v21
; SI-NEXT:    v_lshlrev_b32_e32 v46, 8, v23
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v25
; SI-NEXT:    v_lshlrev_b32_e32 v45, 8, v27
; SI-NEXT:    v_lshlrev_b32_e32 v25, 24, v29
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v23, 8, v2
; SI-NEXT:    v_lshlrev_b32_e32 v11, 24, v4
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v21, 8, v51
; SI-NEXT:    v_lshlrev_b32_e32 v19, 24, v39
; SI-NEXT:    s_waitcnt vmcnt(12)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 8, v38
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v36
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_lshlrev_b32_e32 v51, 8, v30
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v42
; SI-NEXT:    buffer_store_dword v27, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_lshlrev_b32_e32 v15, 8, v43
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v42, 24, v44
; SI-NEXT:    s_cbranch_scc0 .LBB27_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v32
; SI-NEXT:    v_mov_b32_e32 v38, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v33
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v40, v1
; SI-NEXT:    v_or_b32_e32 v4, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v10
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v12
; SI-NEXT:    v_or_b32_e32 v0, v0, v59
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v58, v1
; SI-NEXT:    v_mov_b32_e32 v43, v6
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v6, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v16
; SI-NEXT:    v_or_b32_e32 v0, v0, v57
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v7, v1
; SI-NEXT:    v_mov_b32_e32 v61, v57
; SI-NEXT:    v_mov_b32_e32 v57, v7
; SI-NEXT:    v_or_b32_e32 v7, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v18
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v20
; SI-NEXT:    v_or_b32_e32 v0, v0, v56
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v47, v1
; SI-NEXT:    v_mov_b32_e32 v41, v3
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_mov_b32_e32 v29, v8
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v8
; SI-NEXT:    v_or_b32_e32 v8, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v22
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v24
; SI-NEXT:    v_or_b32_e32 v0, v0, v46
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    v_mov_b32_e32 v63, v59
; SI-NEXT:    v_mov_b32_e32 v59, v56
; SI-NEXT:    v_mov_b32_e32 v56, v9
; SI-NEXT:    v_or_b32_e32 v9, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v26
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v28
; SI-NEXT:    v_or_b32_e32 v0, v0, v45
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_mov_b32_e32 v44, v10
; SI-NEXT:    v_or_b32_e32 v10, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v48
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v50
; SI-NEXT:    v_or_b32_e32 v0, v0, v23
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v11, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v16, v18
; SI-NEXT:    v_mov_b32_e32 v18, v20
; SI-NEXT:    v_mov_b32_e32 v20, v22
; SI-NEXT:    v_mov_b32_e32 v22, v24
; SI-NEXT:    v_mov_b32_e32 v24, v26
; SI-NEXT:    v_mov_b32_e32 v26, v28
; SI-NEXT:    v_mov_b32_e32 v28, v25
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_or_b32_e32 v11, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v60
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v49
; SI-NEXT:    v_or_b32_e32 v0, v0, v21
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v19, v1
; SI-NEXT:    v_mov_b32_e32 v36, v12
; SI-NEXT:    v_or_b32_e32 v12, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v34
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v35
; SI-NEXT:    v_or_b32_e32 v0, v0, v17
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_mov_b32_e32 v62, v58
; SI-NEXT:    v_mov_b32_e32 v58, v47
; SI-NEXT:    v_mov_b32_e32 v47, v46
; SI-NEXT:    v_mov_b32_e32 v46, v45
; SI-NEXT:    v_mov_b32_e32 v45, v23
; SI-NEXT:    v_mov_b32_e32 v23, v21
; SI-NEXT:    v_mov_b32_e32 v21, v19
; SI-NEXT:    v_mov_b32_e32 v19, v17
; SI-NEXT:    v_mov_b32_e32 v17, v13
; SI-NEXT:    v_or_b32_e32 v13, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v55
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v54
; SI-NEXT:    v_or_b32_e32 v0, v0, v51
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v27, v1
; SI-NEXT:    v_mov_b32_e32 v52, v14
; SI-NEXT:    v_or_b32_e32 v14, v0, v1
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v37
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_mov_b32_e32 v27, v42
; SI-NEXT:    v_or_b32_e32 v1, v42, v1
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v53
; SI-NEXT:    v_or_b32_e32 v0, v0, v15
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_mov_b32_e32 v30, v48
; SI-NEXT:    v_mov_b32_e32 v48, v51
; SI-NEXT:    v_mov_b32_e32 v51, v15
; SI-NEXT:    v_or_b32_e32 v15, v0, v1
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    s_lshl_b32 s5, s29, 8
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v31
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    v_mov_b32_e32 v39, v40
; SI-NEXT:    v_mov_b32_e32 v40, v5
; SI-NEXT:    v_or_b32_e32 v5, v2, v3
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_lshl_b32 s8, s27, 24
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    v_or_b32_e32 v3, s4, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s26, 0xff
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_cbranch_execnz .LBB27_3
; SI-NEXT:  .LBB27_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    s_lshl_b32 s5, s29, 8
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v32
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v33
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v1, v38, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, s4, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v39, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v43
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x3000000, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v29
; SI-NEXT:    v_or_b32_e32 v0, v41, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v40, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v44
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v36
; SI-NEXT:    v_or_b32_e32 v0, v63, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v62, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v61, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v57, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v16
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v18
; SI-NEXT:    v_or_b32_e32 v0, v59, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v58, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v22
; SI-NEXT:    v_or_b32_e32 v0, v47, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v56, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v26
; SI-NEXT:    v_or_b32_e32 v0, v46, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v28, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v30
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v50
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v60
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v49
; SI-NEXT:    v_or_b32_e32 v0, v23, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v21, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v34
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v35
; SI-NEXT:    v_or_b32_e32 v0, v19, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_or_b32_e32 v0, v48, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v53
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v37
; SI-NEXT:    v_or_b32_e32 v0, v51, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v27, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x3000000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:  .LBB27_3: ; %end
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB27_4:
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v27, v42
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v38, v1
; SI-NEXT:    v_mov_b32_e32 v43, v6
; SI-NEXT:    v_mov_b32_e32 v29, v8
; SI-NEXT:    v_mov_b32_e32 v44, v10
; SI-NEXT:    v_mov_b32_e32 v36, v12
; SI-NEXT:    v_mov_b32_e32 v52, v14
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v16, v18
; SI-NEXT:    v_mov_b32_e32 v18, v20
; SI-NEXT:    v_mov_b32_e32 v20, v22
; SI-NEXT:    v_mov_b32_e32 v22, v24
; SI-NEXT:    v_mov_b32_e32 v24, v26
; SI-NEXT:    v_mov_b32_e32 v26, v28
; SI-NEXT:    v_mov_b32_e32 v30, v48
; SI-NEXT:    v_mov_b32_e32 v39, v40
; SI-NEXT:    v_mov_b32_e32 v41, v3
; SI-NEXT:    v_mov_b32_e32 v40, v5
; SI-NEXT:    v_mov_b32_e32 v63, v59
; SI-NEXT:    v_mov_b32_e32 v62, v58
; SI-NEXT:    v_mov_b32_e32 v61, v57
; SI-NEXT:    v_mov_b32_e32 v57, v7
; SI-NEXT:    v_mov_b32_e32 v59, v56
; SI-NEXT:    v_mov_b32_e32 v58, v47
; SI-NEXT:    v_mov_b32_e32 v47, v46
; SI-NEXT:    v_mov_b32_e32 v56, v9
; SI-NEXT:    v_mov_b32_e32 v46, v45
; SI-NEXT:    v_mov_b32_e32 v28, v25
; SI-NEXT:    v_mov_b32_e32 v45, v23
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v23, v21
; SI-NEXT:    v_mov_b32_e32 v21, v19
; SI-NEXT:    v_mov_b32_e32 v19, v17
; SI-NEXT:    v_mov_b32_e32 v17, v13
; SI-NEXT:    v_mov_b32_e32 v48, v51
; SI-NEXT:    v_mov_b32_e32 v51, v15
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_branch .LBB27_2
;
; VI-LABEL: bitcast_v64i8_to_v16i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v37, v30
; VI-NEXT:    v_mov_b32_e32 v61, v28
; VI-NEXT:    v_mov_b32_e32 v31, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:76
; VI-NEXT:    buffer_load_ushort v48, off, s[0:3], s32
; VI-NEXT:    buffer_load_ushort v28, off, s[0:3], s32 offset:8
; VI-NEXT:    buffer_load_ushort v62, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:16
; VI-NEXT:    buffer_load_ushort v60, off, s[0:3], s32 offset:12
; VI-NEXT:    buffer_load_ushort v36, off, s[0:3], s32 offset:24
; VI-NEXT:    buffer_load_ushort v33, off, s[0:3], s32 offset:20
; VI-NEXT:    buffer_load_ushort v35, off, s[0:3], s32 offset:32
; VI-NEXT:    buffer_load_ushort v55, off, s[0:3], s32 offset:28
; VI-NEXT:    buffer_load_ushort v34, off, s[0:3], s32 offset:40
; VI-NEXT:    buffer_load_ushort v54, off, s[0:3], s32 offset:36
; VI-NEXT:    buffer_load_ushort v30, off, s[0:3], s32 offset:48
; VI-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:44
; VI-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:56
; VI-NEXT:    buffer_load_ushort v52, off, s[0:3], s32 offset:52
; VI-NEXT:    buffer_load_ushort v43, off, s[0:3], s32 offset:64
; VI-NEXT:    buffer_load_ushort v51, off, s[0:3], s32 offset:60
; VI-NEXT:    buffer_load_ushort v44, off, s[0:3], s32 offset:72
; VI-NEXT:    buffer_load_ushort v50, off, s[0:3], s32 offset:68
; VI-NEXT:    v_lshlrev_b32_e32 v32, 8, v1
; VI-NEXT:    v_lshlrev_b32_e32 v39, 8, v3
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v5
; VI-NEXT:    v_lshlrev_b32_e32 v5, 8, v7
; VI-NEXT:    v_lshlrev_b32_e32 v3, 8, v9
; VI-NEXT:    v_lshlrev_b32_e32 v59, 8, v11
; VI-NEXT:    v_lshlrev_b32_e32 v58, 8, v13
; VI-NEXT:    v_lshlrev_b32_e32 v57, 8, v15
; VI-NEXT:    v_lshlrev_b32_e32 v7, 8, v17
; VI-NEXT:    v_lshlrev_b32_e32 v56, 8, v19
; VI-NEXT:    v_lshlrev_b32_e32 v47, 8, v21
; VI-NEXT:    v_lshlrev_b32_e32 v46, 8, v23
; VI-NEXT:    v_lshlrev_b32_e32 v9, 8, v25
; VI-NEXT:    v_lshlrev_b32_e32 v45, 8, v27
; VI-NEXT:    v_lshlrev_b32_e32 v25, 8, v29
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_lshlrev_b32_e32 v23, 8, v48
; VI-NEXT:    v_lshlrev_b32_e32 v11, 8, v28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_lshlrev_b32_e32 v21, 8, v38
; VI-NEXT:    v_lshlrev_b32_e32 v19, 8, v36
; VI-NEXT:    v_lshlrev_b32_e32 v17, 8, v35
; VI-NEXT:    s_waitcnt vmcnt(12)
; VI-NEXT:    v_lshlrev_b32_e32 v13, 8, v34
; VI-NEXT:    s_waitcnt vmcnt(10)
; VI-NEXT:    v_lshlrev_b32_e32 v28, 8, v30
; VI-NEXT:    s_waitcnt vmcnt(8)
; VI-NEXT:    v_lshlrev_b32_e32 v27, 8, v42
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_lshlrev_b32_e32 v15, 8, v43
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b32_e32 v42, 8, v44
; VI-NEXT:    s_cbranch_scc0 .LBB27_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v2, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v38, v1
; VI-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v35, v4
; VI-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v10, v59 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v12, v58 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v44, v2
; VI-NEXT:    v_mov_b32_e32 v49, v6
; VI-NEXT:    v_or_b32_sdwa v2, v6, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v14, v57 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v16, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v36, v58
; VI-NEXT:    v_mov_b32_e32 v58, v57
; VI-NEXT:    v_mov_b32_e32 v57, v7
; VI-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v18, v56 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v20, v47 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v40, v3
; VI-NEXT:    v_mov_b32_e32 v48, v8
; VI-NEXT:    v_or_b32_sdwa v3, v8, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v22, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v24, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v63, v59
; VI-NEXT:    v_mov_b32_e32 v59, v56
; VI-NEXT:    v_mov_b32_e32 v56, v47
; VI-NEXT:    v_mov_b32_e32 v47, v46
; VI-NEXT:    v_mov_b32_e32 v46, v9
; VI-NEXT:    v_or_b32_sdwa v9, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v26, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v61, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v34, v39
; VI-NEXT:    v_mov_b32_e32 v39, v10
; VI-NEXT:    v_or_b32_sdwa v10, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v37, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v62, v11 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v45, v25
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_or_b32_sdwa v11, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v60, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v43, v12
; VI-NEXT:    v_or_b32_sdwa v12, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v55, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v54, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v16, v18
; VI-NEXT:    v_mov_b32_e32 v18, v20
; VI-NEXT:    v_mov_b32_e32 v20, v22
; VI-NEXT:    v_mov_b32_e32 v22, v24
; VI-NEXT:    v_mov_b32_e32 v24, v26
; VI-NEXT:    v_mov_b32_e32 v26, v61
; VI-NEXT:    v_mov_b32_e32 v61, v23
; VI-NEXT:    v_mov_b32_e32 v23, v21
; VI-NEXT:    v_mov_b32_e32 v21, v19
; VI-NEXT:    v_mov_b32_e32 v19, v17
; VI-NEXT:    v_mov_b32_e32 v17, v13
; VI-NEXT:    v_or_b32_sdwa v13, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v53, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v52, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s28, 0xff
; VI-NEXT:    s_lshl_b32 s5, s29, 8
; VI-NEXT:    v_or_b32_sdwa v14, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v51, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_or_b32_sdwa v1, v50, v42 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    v_mov_b32_e32 v29, v33
; VI-NEXT:    v_mov_b32_e32 v33, v28
; VI-NEXT:    v_mov_b32_e32 v28, v15
; VI-NEXT:    v_or_b32_sdwa v15, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v31, v32 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v41, v5
; VI-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, s4, v0
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    v_mov_b32_e32 v30, v37
; VI-NEXT:    v_mov_b32_e32 v37, v27
; VI-NEXT:    v_mov_b32_e32 v27, v42
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_cbranch_execnz .LBB27_3
; VI-NEXT:  .LBB27_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_and_b32 s4, s28, 0xff
; VI-NEXT:    s_lshl_b32 s5, s29, 8
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v31
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v44
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v32, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v35
; VI-NEXT:    v_or_b32_e32 v0, s4, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x300, v1
; VI-NEXT:    v_or_b32_sdwa v2, v38, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v49
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x3000000, v1
; VI-NEXT:    v_or_b32_sdwa v0, v41, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v48
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v40, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v39
; VI-NEXT:    v_or_b32_sdwa v0, v63, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v43
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v36, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_or_b32_sdwa v0, v58, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v57, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v7, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v16
; VI-NEXT:    v_or_b32_sdwa v0, v59, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v56, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v20
; VI-NEXT:    v_or_b32_sdwa v0, v47, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v46, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v24
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v45, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v10, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v30
; VI-NEXT:    v_or_b32_sdwa v0, v61, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v62
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v11, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v60
; VI-NEXT:    v_or_b32_sdwa v0, v23, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v29
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v21, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v12, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v55
; VI-NEXT:    v_or_b32_sdwa v0, v19, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v54
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v17, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v13, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v53
; VI-NEXT:    v_or_b32_sdwa v0, v33, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v52
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v37, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v14, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v51
; VI-NEXT:    v_or_b32_sdwa v0, v28, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v50
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v27, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v15, vcc, 0x3000000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:  .LBB27_3: ; %end
; VI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB27_4:
; VI-NEXT:    v_mov_b32_e32 v44, v2
; VI-NEXT:    v_mov_b32_e32 v34, v39
; VI-NEXT:    v_mov_b32_e32 v35, v4
; VI-NEXT:    v_mov_b32_e32 v29, v33
; VI-NEXT:    v_mov_b32_e32 v49, v6
; VI-NEXT:    v_mov_b32_e32 v48, v8
; VI-NEXT:    v_mov_b32_e32 v39, v10
; VI-NEXT:    v_mov_b32_e32 v43, v12
; VI-NEXT:    v_mov_b32_e32 v16, v18
; VI-NEXT:    v_mov_b32_e32 v18, v20
; VI-NEXT:    v_mov_b32_e32 v20, v22
; VI-NEXT:    v_mov_b32_e32 v22, v24
; VI-NEXT:    v_mov_b32_e32 v24, v26
; VI-NEXT:    v_mov_b32_e32 v26, v61
; VI-NEXT:    v_mov_b32_e32 v30, v37
; VI-NEXT:    v_mov_b32_e32 v38, v1
; VI-NEXT:    v_mov_b32_e32 v41, v5
; VI-NEXT:    v_mov_b32_e32 v40, v3
; VI-NEXT:    v_mov_b32_e32 v63, v59
; VI-NEXT:    v_mov_b32_e32 v36, v58
; VI-NEXT:    v_mov_b32_e32 v58, v57
; VI-NEXT:    v_mov_b32_e32 v57, v7
; VI-NEXT:    v_mov_b32_e32 v59, v56
; VI-NEXT:    v_mov_b32_e32 v56, v47
; VI-NEXT:    v_mov_b32_e32 v47, v46
; VI-NEXT:    v_mov_b32_e32 v46, v9
; VI-NEXT:    v_mov_b32_e32 v45, v25
; VI-NEXT:    v_mov_b32_e32 v61, v23
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v23, v21
; VI-NEXT:    v_mov_b32_e32 v21, v19
; VI-NEXT:    v_mov_b32_e32 v19, v17
; VI-NEXT:    v_mov_b32_e32 v17, v13
; VI-NEXT:    v_mov_b32_e32 v37, v27
; VI-NEXT:    v_mov_b32_e32 v27, v42
; VI-NEXT:    v_mov_b32_e32 v33, v28
; VI-NEXT:    v_mov_b32_e32 v28, v15
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; VI-NEXT:    s_branch .LBB27_2
;
; GFX9-LABEL: bitcast_v64i8_to_v16i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v37, v30
; GFX9-NEXT:    v_mov_b32_e32 v61, v28
; GFX9-NEXT:    v_mov_b32_e32 v31, v0
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:76
; GFX9-NEXT:    buffer_load_ushort v48, off, s[0:3], s32
; GFX9-NEXT:    buffer_load_ushort v28, off, s[0:3], s32 offset:8
; GFX9-NEXT:    buffer_load_ushort v62, off, s[0:3], s32 offset:4
; GFX9-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:16
; GFX9-NEXT:    buffer_load_ushort v60, off, s[0:3], s32 offset:12
; GFX9-NEXT:    buffer_load_ushort v36, off, s[0:3], s32 offset:24
; GFX9-NEXT:    buffer_load_ushort v33, off, s[0:3], s32 offset:20
; GFX9-NEXT:    buffer_load_ushort v35, off, s[0:3], s32 offset:32
; GFX9-NEXT:    buffer_load_ushort v55, off, s[0:3], s32 offset:28
; GFX9-NEXT:    buffer_load_ushort v34, off, s[0:3], s32 offset:40
; GFX9-NEXT:    buffer_load_ushort v54, off, s[0:3], s32 offset:36
; GFX9-NEXT:    buffer_load_ushort v30, off, s[0:3], s32 offset:48
; GFX9-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:44
; GFX9-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:56
; GFX9-NEXT:    buffer_load_ushort v52, off, s[0:3], s32 offset:52
; GFX9-NEXT:    buffer_load_ushort v43, off, s[0:3], s32 offset:64
; GFX9-NEXT:    buffer_load_ushort v51, off, s[0:3], s32 offset:60
; GFX9-NEXT:    buffer_load_ushort v44, off, s[0:3], s32 offset:72
; GFX9-NEXT:    buffer_load_ushort v50, off, s[0:3], s32 offset:68
; GFX9-NEXT:    v_lshlrev_b32_e32 v32, 8, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v39, 8, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 8, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 8, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 8, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v59, 8, v11
; GFX9-NEXT:    v_lshlrev_b32_e32 v58, 8, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v57, 8, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 8, v17
; GFX9-NEXT:    v_lshlrev_b32_e32 v56, 8, v19
; GFX9-NEXT:    v_lshlrev_b32_e32 v47, 8, v21
; GFX9-NEXT:    v_lshlrev_b32_e32 v46, 8, v23
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 8, v25
; GFX9-NEXT:    v_lshlrev_b32_e32 v45, 8, v27
; GFX9-NEXT:    v_lshlrev_b32_e32 v25, 8, v29
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(22)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b32_e32 v23, 8, v48
; GFX9-NEXT:    s_waitcnt vmcnt(20)
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 8, v28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_waitcnt vmcnt(18)
; GFX9-NEXT:    v_lshlrev_b32_e32 v21, 8, v38
; GFX9-NEXT:    s_waitcnt vmcnt(16)
; GFX9-NEXT:    v_lshlrev_b32_e32 v19, 8, v36
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_lshlrev_b32_e32 v17, 8, v35
; GFX9-NEXT:    s_waitcnt vmcnt(12)
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 8, v34
; GFX9-NEXT:    s_waitcnt vmcnt(10)
; GFX9-NEXT:    v_lshlrev_b32_e32 v28, 8, v30
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_lshlrev_b32_e32 v27, 8, v42
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_lshlrev_b32_e32 v15, 8, v43
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b32_e32 v42, 8, v44
; GFX9-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v2, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v38, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v35, v4
; GFX9-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v59 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v58 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v44, v2
; GFX9-NEXT:    v_mov_b32_e32 v49, v6
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v14, v57 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v36, v58
; GFX9-NEXT:    v_mov_b32_e32 v58, v57
; GFX9-NEXT:    v_mov_b32_e32 v57, v7
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v18, v56 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v20, v47 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v40, v3
; GFX9-NEXT:    v_mov_b32_e32 v48, v8
; GFX9-NEXT:    v_or_b32_sdwa v3, v8, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v22, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v24, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v63, v59
; GFX9-NEXT:    v_mov_b32_e32 v59, v56
; GFX9-NEXT:    v_mov_b32_e32 v56, v47
; GFX9-NEXT:    v_mov_b32_e32 v47, v46
; GFX9-NEXT:    v_mov_b32_e32 v46, v9
; GFX9-NEXT:    v_or_b32_sdwa v9, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v26, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v61, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v34, v39
; GFX9-NEXT:    v_mov_b32_e32 v39, v10
; GFX9-NEXT:    v_or_b32_sdwa v10, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v37, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v62, v11 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v45, v25
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_or_b32_sdwa v11, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v60, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v43, v12
; GFX9-NEXT:    v_or_b32_sdwa v12, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v55, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v54, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v16, v18
; GFX9-NEXT:    v_mov_b32_e32 v18, v20
; GFX9-NEXT:    v_mov_b32_e32 v20, v22
; GFX9-NEXT:    v_mov_b32_e32 v22, v24
; GFX9-NEXT:    v_mov_b32_e32 v24, v26
; GFX9-NEXT:    v_mov_b32_e32 v26, v61
; GFX9-NEXT:    v_mov_b32_e32 v61, v23
; GFX9-NEXT:    v_mov_b32_e32 v23, v21
; GFX9-NEXT:    v_mov_b32_e32 v21, v19
; GFX9-NEXT:    v_mov_b32_e32 v19, v17
; GFX9-NEXT:    v_mov_b32_e32 v17, v13
; GFX9-NEXT:    v_or_b32_sdwa v13, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v53, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v52, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s29, 8
; GFX9-NEXT:    v_or_b32_sdwa v14, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v51, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_or_b32_sdwa v1, v50, v42 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    v_mov_b32_e32 v29, v33
; GFX9-NEXT:    v_mov_b32_e32 v33, v28
; GFX9-NEXT:    v_mov_b32_e32 v28, v15
; GFX9-NEXT:    v_or_b32_sdwa v15, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    v_or_b32_sdwa v0, v31, v32 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v41, v5
; GFX9-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s4, v0
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v30, v37
; GFX9-NEXT:    v_mov_b32_e32 v37, v27
; GFX9-NEXT:    v_mov_b32_e32 v27, v42
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB27_3
; GFX9-NEXT:  .LBB27_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_and_b32 s5, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s29, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v31
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v44
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v35
; GFX9-NEXT:    s_movk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v0, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v38, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    v_add_u32_sdwa v0, v0, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u32_sdwa v2, v2, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s5, v0
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v49
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v48
; GFX9-NEXT:    v_or_b32_sdwa v0, v41, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v40, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v39
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v43
; GFX9-NEXT:    v_or_b32_sdwa v0, v63, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v36, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s5, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s19, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s23, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_and_b32 s8, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s27, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_addk_i32 s8, 0x300
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 16
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_or_b32_sdwa v0, v58, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v57, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v18
; GFX9-NEXT:    v_or_b32_sdwa v0, v59, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v56, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v22
; GFX9-NEXT:    v_or_b32_sdwa v0, v47, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v46, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v9, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v26
; GFX9-NEXT:    v_or_b32_sdwa v1, v45, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v10, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v62
; GFX9-NEXT:    v_or_b32_sdwa v0, v61, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v11, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v60
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v29
; GFX9-NEXT:    v_or_b32_sdwa v0, v23, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v21, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v12, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v55
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v54
; GFX9-NEXT:    v_or_b32_sdwa v0, v19, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v17, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v13, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v53
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v52
; GFX9-NEXT:    v_or_b32_sdwa v0, v33, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v14, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v51
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v50
; GFX9-NEXT:    v_or_b32_sdwa v0, v28, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v27, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v15, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:  .LBB27_3: ; %end
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB27_4:
; GFX9-NEXT:    v_mov_b32_e32 v44, v2
; GFX9-NEXT:    v_mov_b32_e32 v34, v39
; GFX9-NEXT:    v_mov_b32_e32 v35, v4
; GFX9-NEXT:    v_mov_b32_e32 v29, v33
; GFX9-NEXT:    v_mov_b32_e32 v49, v6
; GFX9-NEXT:    v_mov_b32_e32 v48, v8
; GFX9-NEXT:    v_mov_b32_e32 v39, v10
; GFX9-NEXT:    v_mov_b32_e32 v43, v12
; GFX9-NEXT:    v_mov_b32_e32 v16, v18
; GFX9-NEXT:    v_mov_b32_e32 v18, v20
; GFX9-NEXT:    v_mov_b32_e32 v20, v22
; GFX9-NEXT:    v_mov_b32_e32 v22, v24
; GFX9-NEXT:    v_mov_b32_e32 v24, v26
; GFX9-NEXT:    v_mov_b32_e32 v26, v61
; GFX9-NEXT:    v_mov_b32_e32 v30, v37
; GFX9-NEXT:    v_mov_b32_e32 v38, v1
; GFX9-NEXT:    v_mov_b32_e32 v41, v5
; GFX9-NEXT:    v_mov_b32_e32 v40, v3
; GFX9-NEXT:    v_mov_b32_e32 v63, v59
; GFX9-NEXT:    v_mov_b32_e32 v36, v58
; GFX9-NEXT:    v_mov_b32_e32 v58, v57
; GFX9-NEXT:    v_mov_b32_e32 v57, v7
; GFX9-NEXT:    v_mov_b32_e32 v59, v56
; GFX9-NEXT:    v_mov_b32_e32 v56, v47
; GFX9-NEXT:    v_mov_b32_e32 v47, v46
; GFX9-NEXT:    v_mov_b32_e32 v46, v9
; GFX9-NEXT:    v_mov_b32_e32 v45, v25
; GFX9-NEXT:    v_mov_b32_e32 v61, v23
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v23, v21
; GFX9-NEXT:    v_mov_b32_e32 v21, v19
; GFX9-NEXT:    v_mov_b32_e32 v19, v17
; GFX9-NEXT:    v_mov_b32_e32 v17, v13
; GFX9-NEXT:    v_mov_b32_e32 v37, v27
; GFX9-NEXT:    v_mov_b32_e32 v27, v42
; GFX9-NEXT:    v_mov_b32_e32 v33, v28
; GFX9-NEXT:    v_mov_b32_e32 v28, v15
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX9-NEXT:    s_branch .LBB27_2
;
; GFX11-TRUE16-LABEL: bitcast_v64i8_to_v16i32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v38, v14 :: v_dual_mov_b32 v37, v12
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v36, v10 :: v_dual_mov_b32 v35, v8
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v34, v6 :: v_dual_mov_b32 v33, v4
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v32, v2 :: v_dual_mov_b32 v31, v0
; GFX11-TRUE16-NEXT:    s_clause 0xf
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v0, off, s32 offset:56
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v39, off, s32 offset:52
; GFX11-TRUE16-NEXT:    scratch_load_b32 v2, off, s32 offset:60
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v4, off, s32
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v6, off, s32 offset:8
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v8, off, s32 offset:16
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v10, off, s32 offset:24
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v12, off, s32 offset:32
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v14, off, s32 offset:40
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v86, off, s32 offset:48
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v48, off, s32 offset:44
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v49, off, s32 offset:36
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v50, off, s32 offset:28
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v51, off, s32 offset:20
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v52, off, s32 offset:12
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v53, off, s32 offset:4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v83, 8, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v84, 8, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v85, 8, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v70, 8, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v71, 8, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v80, 8, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v81, 8, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v82, 8, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v65, 8, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v66, 8, v19
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v67, 8, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v68, 8, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v69, 8, v25
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 8, v27
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v29, 8, v29
; GFX11-TRUE16-NEXT:    s_mov_b32 s4, 0
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(15)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 8, v0
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(13)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(12)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 8, v4
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(11)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v55, 8, v6
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(10)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v64, 8, v8
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(9)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 8, v10
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(8)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v19, 8, v12
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(7)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 8, v14
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(6)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 8, v86
; GFX11-TRUE16-NEXT:    s_and_b32 s5, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_and_b32 s5, s0, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s6, s1, 8
; GFX11-TRUE16-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-TRUE16-NEXT:    s_or_b32 s5, s5, s6
; GFX11-TRUE16-NEXT:    s_or_b32 s6, s7, s8
; GFX11-TRUE16-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-TRUE16-NEXT:    s_lshl_b32 s7, s17, 8
; GFX11-TRUE16-NEXT:    s_or_b32 s5, s5, s6
; GFX11-TRUE16-NEXT:    s_and_b32 s6, s16, 0xff
; GFX11-TRUE16-NEXT:    s_and_b32 s8, s18, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-TRUE16-NEXT:    s_or_b32 s6, s6, s7
; GFX11-TRUE16-NEXT:    s_or_b32 s7, s8, s9
; GFX11-TRUE16-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-TRUE16-NEXT:    s_and_b32 s8, s20, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-TRUE16-NEXT:    s_or_b32 s6, s6, s7
; GFX11-TRUE16-NEXT:    s_or_b32 s7, s8, s9
; GFX11-TRUE16-NEXT:    s_and_b32 s8, s22, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s9, s23, 8
; GFX11-TRUE16-NEXT:    s_lshl_b32 s10, s25, 8
; GFX11-TRUE16-NEXT:    s_or_b32 s8, s8, s9
; GFX11-TRUE16-NEXT:    s_and_b32 s9, s24, 0xff
; GFX11-TRUE16-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-TRUE16-NEXT:    s_or_b32 s9, s9, s10
; GFX11-TRUE16-NEXT:    s_or_b32 s7, s7, s8
; GFX11-TRUE16-NEXT:    s_and_b32 s8, s9, 0xffff
; GFX11-TRUE16-NEXT:    s_and_b32 s9, s26, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s10, s27, 8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v31
; GFX11-TRUE16-NEXT:    s_or_b32 s9, s9, s10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xff, v32
; GFX11-TRUE16-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xff, v38
; GFX11-TRUE16-NEXT:    s_or_b32 s8, s8, s9
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xff, v33
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v83
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v84
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xff, v22
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xff, v24
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v85
; GFX11-TRUE16-NEXT:    s_and_b32 s11, s28, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s12, s29, 8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v82
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v10, v68
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v11, v69
; GFX11-TRUE16-NEXT:    s_or_b32 s10, s11, s12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-TRUE16-NEXT:    s_and_b32 s10, s10, 0xffff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xff, v35
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, s10, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v34
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xff, v36
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xff, v37
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xff, v16
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xff, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xff, v20
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v70
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v71
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v80
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v3, v81
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v65
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v7, v66
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v9, v67
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xff, v52
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v11, v64
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v0, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v8, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v13, v9
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v26
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xff, v28
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xff, v30
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xff, v53
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xff, v51
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v12, 0xff, v50
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xff, v49
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xff, v48
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v86, 0xff, v39
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v27
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v29
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v54
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v3, v55
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v11, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v12, v19
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v14, v21
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v15, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v86, v86, v25
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v87, 16, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v96, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v86, 16, v86
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v0, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v2, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v13, v87
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v96, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v15, v86
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, s6
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v3, s8
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB27_3
; GFX11-TRUE16-NEXT:  .LBB27_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    s_add_i32 s0, s0, 3
; GFX11-TRUE16-NEXT:    s_add_i32 s2, s2, 3
; GFX11-TRUE16-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-TRUE16-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-TRUE16-NEXT:    s_or_b32 s0, s1, s0
; GFX11-TRUE16-NEXT:    s_or_b32 s1, s3, s2
; GFX11-TRUE16-NEXT:    s_addk_i32 s0, 0x300
; GFX11-TRUE16-NEXT:    s_addk_i32 s1, 0x300
; GFX11-TRUE16-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-TRUE16-NEXT:    s_add_i32 s16, s16, 3
; GFX11-TRUE16-NEXT:    s_or_b32 s0, s0, s1
; GFX11-TRUE16-NEXT:    s_and_b32 s1, s16, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s2, s17, 8
; GFX11-TRUE16-NEXT:    s_add_i32 s18, s18, 3
; GFX11-TRUE16-NEXT:    s_or_b32 s1, s2, s1
; GFX11-TRUE16-NEXT:    s_and_b32 s2, s18, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s3, s19, 8
; GFX11-TRUE16-NEXT:    s_addk_i32 s1, 0x300
; GFX11-TRUE16-NEXT:    s_or_b32 s2, s3, s2
; GFX11-TRUE16-NEXT:    s_add_i32 s20, s20, 3
; GFX11-TRUE16-NEXT:    s_addk_i32 s2, 0x300
; GFX11-TRUE16-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-TRUE16-NEXT:    s_and_b32 s3, s20, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s4, s21, 8
; GFX11-TRUE16-NEXT:    s_add_i32 s22, s22, 3
; GFX11-TRUE16-NEXT:    s_or_b32 s1, s1, s2
; GFX11-TRUE16-NEXT:    s_or_b32 s2, s4, s3
; GFX11-TRUE16-NEXT:    s_and_b32 s3, s22, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s4, s23, 8
; GFX11-TRUE16-NEXT:    s_add_i32 s24, s24, 3
; GFX11-TRUE16-NEXT:    s_or_b32 s3, s4, s3
; GFX11-TRUE16-NEXT:    s_and_b32 s4, s24, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s5, s25, 8
; GFX11-TRUE16-NEXT:    s_addk_i32 s2, 0x300
; GFX11-TRUE16-NEXT:    s_addk_i32 s3, 0x300
; GFX11-TRUE16-NEXT:    s_or_b32 s4, s5, s4
; GFX11-TRUE16-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-TRUE16-NEXT:    s_addk_i32 s4, 0x300
; GFX11-TRUE16-NEXT:    s_add_i32 s26, s26, 3
; GFX11-TRUE16-NEXT:    s_or_b32 s2, s2, s3
; GFX11-TRUE16-NEXT:    s_and_b32 s3, s4, 0xffff
; GFX11-TRUE16-NEXT:    s_and_b32 s4, s26, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s5, s27, 8
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 3, v31
; GFX11-TRUE16-NEXT:    s_or_b32 s4, s5, s4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v32
; GFX11-TRUE16-NEXT:    s_addk_i32 s4, 0x300
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v38
; GFX11-TRUE16-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-TRUE16-NEXT:    s_or_b32 s3, s3, s4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v33
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v22
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v24
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v83, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v84, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v85, v2
; GFX11-TRUE16-NEXT:    s_add_i32 s28, s28, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v82, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v68, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v69, v11
; GFX11-TRUE16-NEXT:    s_and_b32 s6, s28, 0xff
; GFX11-TRUE16-NEXT:    s_lshl_b32 s7, s29, 8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-TRUE16-NEXT:    s_or_b32 s5, s7, s6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 0x300, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 0x300, v10
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 0x300, v11
; GFX11-TRUE16-NEXT:    s_addk_i32 s5, 0x300
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-TRUE16-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v35
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, s5, v0
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 3, v34
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v36
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v37
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 3, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v20
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v52
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v70, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v71, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v80, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v81, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v65, v6
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v66, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v67, v9
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 0x300, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 0x300, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 0x300, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 0x300, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v64, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 0x300, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v0, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v8, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v13, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 3, v26
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v28
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v30
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v53
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v51
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v50
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 3, v49
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 3, v48
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 3, v39
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v27, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v29, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v54, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v55, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v17, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v19, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v21, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v23, v15
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, v25, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 0x300, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 0x300, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 0x300, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 0x300, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 0x300, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 0x300, v16
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v18, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v0, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v2, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v13, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v18, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v15, v16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:  .LBB27_3: ; %end
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB27_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX11-TRUE16-NEXT:    s_branch .LBB27_2
;
; GFX11-FAKE16-LABEL: bitcast_v64i8_to_v16i32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v38, v14 :: v_dual_mov_b32 v37, v12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v36, v10 :: v_dual_mov_b32 v35, v8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v34, v6 :: v_dual_mov_b32 v33, v4
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v32, v2 :: v_dual_mov_b32 v31, v0
; GFX11-FAKE16-NEXT:    s_clause 0xf
; GFX11-FAKE16-NEXT:    scratch_load_u16 v0, off, s32 offset:56
; GFX11-FAKE16-NEXT:    scratch_load_u16 v39, off, s32 offset:52
; GFX11-FAKE16-NEXT:    scratch_load_b32 v2, off, s32 offset:60
; GFX11-FAKE16-NEXT:    scratch_load_u16 v4, off, s32
; GFX11-FAKE16-NEXT:    scratch_load_u16 v6, off, s32 offset:8
; GFX11-FAKE16-NEXT:    scratch_load_u16 v8, off, s32 offset:16
; GFX11-FAKE16-NEXT:    scratch_load_u16 v10, off, s32 offset:24
; GFX11-FAKE16-NEXT:    scratch_load_u16 v12, off, s32 offset:32
; GFX11-FAKE16-NEXT:    scratch_load_u16 v14, off, s32 offset:40
; GFX11-FAKE16-NEXT:    scratch_load_u16 v86, off, s32 offset:48
; GFX11-FAKE16-NEXT:    scratch_load_u16 v48, off, s32 offset:44
; GFX11-FAKE16-NEXT:    scratch_load_u16 v49, off, s32 offset:36
; GFX11-FAKE16-NEXT:    scratch_load_u16 v50, off, s32 offset:28
; GFX11-FAKE16-NEXT:    scratch_load_u16 v51, off, s32 offset:20
; GFX11-FAKE16-NEXT:    scratch_load_u16 v52, off, s32 offset:12
; GFX11-FAKE16-NEXT:    scratch_load_u16 v53, off, s32 offset:4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v83, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v84, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v85, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v70, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v71, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v80, 8, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v81, 8, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v82, 8, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 8, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v66, 8, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v67, 8, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v68, 8, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v69, 8, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 8, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 8, v29
; GFX11-FAKE16-NEXT:    s_mov_b32 s4, 0
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(15)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 8, v0
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(13)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(12)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 8, v4
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(11)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 8, v6
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(10)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v64, 8, v8
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(9)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 8, v10
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(8)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 8, v12
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(7)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 8, v14
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(6)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 8, v86
; GFX11-FAKE16-NEXT:    s_and_b32 s5, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_and_b32 s5, s0, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s6, s1, 8
; GFX11-FAKE16-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-FAKE16-NEXT:    s_or_b32 s5, s5, s6
; GFX11-FAKE16-NEXT:    s_or_b32 s6, s7, s8
; GFX11-FAKE16-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-FAKE16-NEXT:    s_lshl_b32 s7, s17, 8
; GFX11-FAKE16-NEXT:    s_or_b32 s5, s5, s6
; GFX11-FAKE16-NEXT:    s_and_b32 s6, s16, 0xff
; GFX11-FAKE16-NEXT:    s_and_b32 s8, s18, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-FAKE16-NEXT:    s_or_b32 s6, s6, s7
; GFX11-FAKE16-NEXT:    s_or_b32 s7, s8, s9
; GFX11-FAKE16-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-FAKE16-NEXT:    s_and_b32 s8, s20, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-FAKE16-NEXT:    s_or_b32 s6, s6, s7
; GFX11-FAKE16-NEXT:    s_or_b32 s7, s8, s9
; GFX11-FAKE16-NEXT:    s_and_b32 s8, s22, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s9, s23, 8
; GFX11-FAKE16-NEXT:    s_lshl_b32 s10, s25, 8
; GFX11-FAKE16-NEXT:    s_or_b32 s8, s8, s9
; GFX11-FAKE16-NEXT:    s_and_b32 s9, s24, 0xff
; GFX11-FAKE16-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-FAKE16-NEXT:    s_or_b32 s9, s9, s10
; GFX11-FAKE16-NEXT:    s_or_b32 s7, s7, s8
; GFX11-FAKE16-NEXT:    s_and_b32 s8, s9, 0xffff
; GFX11-FAKE16-NEXT:    s_and_b32 s9, s26, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s10, s27, 8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v31
; GFX11-FAKE16-NEXT:    s_or_b32 s9, s9, s10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v32
; GFX11-FAKE16-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v38
; GFX11-FAKE16-NEXT:    s_or_b32 s8, s8, s9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v33
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v83
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v84
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v85
; GFX11-FAKE16-NEXT:    s_and_b32 s11, s28, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s12, s29, 8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v82
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v68
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v69
; GFX11-FAKE16-NEXT:    s_or_b32 s10, s11, s12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-FAKE16-NEXT:    s_and_b32 s10, s10, 0xffff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v35
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, s10, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v36
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v37
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v70
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v71
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v80
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v81
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v65
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v66
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v67
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v52
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v64
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v13, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v30
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v53
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v51
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v50
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v49
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v48
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v86, 0xff, v39
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v54
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v14, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v86, v86, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v87, 16, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v96, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v86, 16, v86
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v87
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v96, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v86
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, s6
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v3, s8
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB27_3
; GFX11-FAKE16-NEXT:  .LBB27_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    s_add_i32 s0, s0, 3
; GFX11-FAKE16-NEXT:    s_add_i32 s2, s2, 3
; GFX11-FAKE16-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-FAKE16-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-FAKE16-NEXT:    s_or_b32 s0, s1, s0
; GFX11-FAKE16-NEXT:    s_or_b32 s1, s3, s2
; GFX11-FAKE16-NEXT:    s_addk_i32 s0, 0x300
; GFX11-FAKE16-NEXT:    s_addk_i32 s1, 0x300
; GFX11-FAKE16-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-FAKE16-NEXT:    s_add_i32 s16, s16, 3
; GFX11-FAKE16-NEXT:    s_or_b32 s0, s0, s1
; GFX11-FAKE16-NEXT:    s_and_b32 s1, s16, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s2, s17, 8
; GFX11-FAKE16-NEXT:    s_add_i32 s18, s18, 3
; GFX11-FAKE16-NEXT:    s_or_b32 s1, s2, s1
; GFX11-FAKE16-NEXT:    s_and_b32 s2, s18, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s3, s19, 8
; GFX11-FAKE16-NEXT:    s_addk_i32 s1, 0x300
; GFX11-FAKE16-NEXT:    s_or_b32 s2, s3, s2
; GFX11-FAKE16-NEXT:    s_add_i32 s20, s20, 3
; GFX11-FAKE16-NEXT:    s_addk_i32 s2, 0x300
; GFX11-FAKE16-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-FAKE16-NEXT:    s_and_b32 s3, s20, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s4, s21, 8
; GFX11-FAKE16-NEXT:    s_add_i32 s22, s22, 3
; GFX11-FAKE16-NEXT:    s_or_b32 s1, s1, s2
; GFX11-FAKE16-NEXT:    s_or_b32 s2, s4, s3
; GFX11-FAKE16-NEXT:    s_and_b32 s3, s22, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s4, s23, 8
; GFX11-FAKE16-NEXT:    s_add_i32 s24, s24, 3
; GFX11-FAKE16-NEXT:    s_or_b32 s3, s4, s3
; GFX11-FAKE16-NEXT:    s_and_b32 s4, s24, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s5, s25, 8
; GFX11-FAKE16-NEXT:    s_addk_i32 s2, 0x300
; GFX11-FAKE16-NEXT:    s_addk_i32 s3, 0x300
; GFX11-FAKE16-NEXT:    s_or_b32 s4, s5, s4
; GFX11-FAKE16-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-FAKE16-NEXT:    s_addk_i32 s4, 0x300
; GFX11-FAKE16-NEXT:    s_add_i32 s26, s26, 3
; GFX11-FAKE16-NEXT:    s_or_b32 s2, s2, s3
; GFX11-FAKE16-NEXT:    s_and_b32 s3, s4, 0xffff
; GFX11-FAKE16-NEXT:    s_and_b32 s4, s26, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s5, s27, 8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 3, v31
; GFX11-FAKE16-NEXT:    s_or_b32 s4, s5, s4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v32
; GFX11-FAKE16-NEXT:    s_addk_i32 s4, 0x300
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v38
; GFX11-FAKE16-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    s_or_b32 s3, s3, s4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 3, v22
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v83, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v84, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v85, v2
; GFX11-FAKE16-NEXT:    s_add_i32 s28, s28, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v82, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v68, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v69, v11
; GFX11-FAKE16-NEXT:    s_and_b32 s6, s28, 0xff
; GFX11-FAKE16-NEXT:    s_lshl_b32 s7, s29, 8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    s_or_b32 s5, s7, s6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    s_addk_i32 s5, 0x300
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-FAKE16-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v35
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, s5, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 3, v34
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v36
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v37
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 3, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v52
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v70, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v71, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v80, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v81, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v65, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v66, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v67, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 0x300, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v64, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v13, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 3, v26
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v28
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v30
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v53
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v51
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 3, v50
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v49
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 3, v48
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 3, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v27, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v29, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v54, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v55, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v17, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v19, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v21, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v23, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v25, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 0x300, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 0x300, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 0x300, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v18, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:  .LBB27_3: ; %end
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB27_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX11-FAKE16-NEXT:    s_branch .LBB27_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <64 x i8> %a, splat (i8 3)
  %a2 = bitcast <64 x i8> %a1 to <16 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <64 x i8> %a to <16 x i32>
  br label %end

end:
  %phi = phi <16 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i32> %phi
}

define <8 x i64> @bitcast_v16f32_to_v8i64(<16 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v16f32_to_v8i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB28_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB28_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f32_to_v8i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB28_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB28_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f32_to_v8i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB28_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB28_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f32_to_v8i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB28_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB28_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <8 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <8 x i64>
  br label %end

end:
  %phi = phi <8 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i64> %phi
}

define inreg <8 x i64> @bitcast_v16f32_to_v8i64_scalar(<16 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f32_to_v8i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB29_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB29_3
; SI-NEXT:  .LBB29_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB29_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB29_4:
; SI-NEXT:    s_branch .LBB29_2
;
; VI-LABEL: bitcast_v16f32_to_v8i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB29_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB29_3
; VI-NEXT:  .LBB29_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB29_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB29_4:
; VI-NEXT:    s_branch .LBB29_2
;
; GFX9-LABEL: bitcast_v16f32_to_v8i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB29_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB29_3
; GFX9-NEXT:  .LBB29_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB29_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB29_4:
; GFX9-NEXT:    s_branch .LBB29_2
;
; GFX11-LABEL: bitcast_v16f32_to_v8i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB29_4
; GFX11-NEXT:  .LBB29_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v15, s27, 1.0
; GFX11-NEXT:    v_add_f32_e64 v14, s26, 1.0
; GFX11-NEXT:    v_add_f32_e64 v13, s25, 1.0
; GFX11-NEXT:    v_add_f32_e64 v12, s24, 1.0
; GFX11-NEXT:    v_add_f32_e64 v11, s23, 1.0
; GFX11-NEXT:    v_add_f32_e64 v10, s22, 1.0
; GFX11-NEXT:    v_add_f32_e64 v9, s21, 1.0
; GFX11-NEXT:    v_add_f32_e64 v8, s20, 1.0
; GFX11-NEXT:    v_add_f32_e64 v7, s19, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s18, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s17, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s16, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s15, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s14, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s13, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s12, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB29_3:
; GFX11-NEXT:    s_branch .LBB29_2
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <8 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <8 x i64>
  br label %end

end:
  %phi = phi <8 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i64> %phi
}

define <16 x float> @bitcast_v8i64_to_v16f32(<8 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v8i64_to_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB30_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB30_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i64_to_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB30_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB30_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i64_to_v16f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB30_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB30_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i64_to_v16f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB30_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB30_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i64> %a, splat (i64 3)
  %a2 = bitcast <8 x i64> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i64> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define inreg <16 x float> @bitcast_v8i64_to_v16f32_scalar(<8 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i64_to_v16f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB31_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB31_3
; SI-NEXT:  .LBB31_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB31_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB31_4:
; SI-NEXT:    s_branch .LBB31_2
;
; VI-LABEL: bitcast_v8i64_to_v16f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB31_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB31_3
; VI-NEXT:  .LBB31_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB31_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB31_4:
; VI-NEXT:    s_branch .LBB31_2
;
; GFX9-LABEL: bitcast_v8i64_to_v16f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB31_3
; GFX9-NEXT:  .LBB31_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB31_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB31_4:
; GFX9-NEXT:    s_branch .LBB31_2
;
; GFX11-LABEL: bitcast_v8i64_to_v16f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB31_3
; GFX11-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s26, s26, 3
; GFX11-NEXT:    s_addc_u32 s27, s27, 0
; GFX11-NEXT:    s_add_u32 s24, s24, 3
; GFX11-NEXT:    s_addc_u32 s25, s25, 0
; GFX11-NEXT:    s_add_u32 s22, s22, 3
; GFX11-NEXT:    s_addc_u32 s23, s23, 0
; GFX11-NEXT:    s_add_u32 s20, s20, 3
; GFX11-NEXT:    s_addc_u32 s21, s21, 0
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB31_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB31_4:
; GFX11-NEXT:    s_branch .LBB31_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i64> %a, splat (i64 3)
  %a2 = bitcast <8 x i64> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i64> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define <8 x double> @bitcast_v16f32_to_v8f64(<16 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v16f32_to_v8f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB32_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB32_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f32_to_v8f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB32_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB32_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f32_to_v8f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB32_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB32_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f32_to_v8f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB32_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB32_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <8 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <8 x double>
  br label %end

end:
  %phi = phi <8 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x double> %phi
}

define inreg <8 x double> @bitcast_v16f32_to_v8f64_scalar(<16 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f32_to_v8f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB33_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB33_3
; SI-NEXT:  .LBB33_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB33_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB33_4:
; SI-NEXT:    s_branch .LBB33_2
;
; VI-LABEL: bitcast_v16f32_to_v8f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB33_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB33_3
; VI-NEXT:  .LBB33_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB33_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB33_4:
; VI-NEXT:    s_branch .LBB33_2
;
; GFX9-LABEL: bitcast_v16f32_to_v8f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB33_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB33_3
; GFX9-NEXT:  .LBB33_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB33_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB33_4:
; GFX9-NEXT:    s_branch .LBB33_2
;
; GFX11-LABEL: bitcast_v16f32_to_v8f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB33_4
; GFX11-NEXT:  .LBB33_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v15, s27, 1.0
; GFX11-NEXT:    v_add_f32_e64 v14, s26, 1.0
; GFX11-NEXT:    v_add_f32_e64 v13, s25, 1.0
; GFX11-NEXT:    v_add_f32_e64 v12, s24, 1.0
; GFX11-NEXT:    v_add_f32_e64 v11, s23, 1.0
; GFX11-NEXT:    v_add_f32_e64 v10, s22, 1.0
; GFX11-NEXT:    v_add_f32_e64 v9, s21, 1.0
; GFX11-NEXT:    v_add_f32_e64 v8, s20, 1.0
; GFX11-NEXT:    v_add_f32_e64 v7, s19, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s18, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s17, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s16, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s15, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s14, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s13, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s12, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_3:
; GFX11-NEXT:    s_branch .LBB33_2
; GFX11-NEXT:  .LBB33_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <8 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <8 x double>
  br label %end

end:
  %phi = phi <8 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x double> %phi
}

define <16 x float> @bitcast_v8f64_to_v16f32(<8 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v8f64_to_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB34_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB34_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f64_to_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB34_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB34_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f64_to_v16f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB34_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB34_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f64_to_v16f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB34_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB34_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <8 x double> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x double> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define inreg <16 x float> @bitcast_v8f64_to_v16f32_scalar(<8 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f64_to_v16f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB35_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB35_3
; SI-NEXT:  .LBB35_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB35_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB35_4:
; SI-NEXT:    s_branch .LBB35_2
;
; VI-LABEL: bitcast_v8f64_to_v16f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB35_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB35_3
; VI-NEXT:  .LBB35_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB35_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB35_4:
; VI-NEXT:    s_branch .LBB35_2
;
; GFX9-LABEL: bitcast_v8f64_to_v16f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB35_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB35_3
; GFX9-NEXT:  .LBB35_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB35_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB35_4:
; GFX9-NEXT:    s_branch .LBB35_2
;
; GFX11-LABEL: bitcast_v8f64_to_v16f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB35_4
; GFX11-NEXT:  .LBB35_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[14:15], s[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], s[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], s[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], s[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], s[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[12:13], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB35_3:
; GFX11-NEXT:    s_branch .LBB35_2
; GFX11-NEXT:  .LBB35_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <8 x double> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x double> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define <32 x i16> @bitcast_v16f32_to_v32i16(<16 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v16f32_to_v32i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v30, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v26, v13
; SI-NEXT:    v_mov_b32_e32 v24, v12
; SI-NEXT:    v_mov_b32_e32 v22, v11
; SI-NEXT:    v_mov_b32_e32 v20, v10
; SI-NEXT:    v_mov_b32_e32 v18, v9
; SI-NEXT:    v_mov_b32_e32 v32, v8
; SI-NEXT:    v_mov_b32_e32 v14, v7
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v8, v4
; SI-NEXT:    v_mov_b32_e32 v6, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB36_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v32, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB36_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB36_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v32, 1.0, v32
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v30, 1.0, v30
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v32, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB36_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v16, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f32_to_v32i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB36_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB36_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f32_to_v32i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB36_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB36_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f32_to_v32i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB36_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB36_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <32 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <32 x i16>
  br label %end

end:
  %phi = phi <32 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i16> %phi
}

define inreg <32 x i16> @bitcast_v16f32_to_v32i16_scalar(<16 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f32_to_v32i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    v_mov_b32_e32 v30, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v12, s22
; SI-NEXT:    v_mov_b32_e32 v14, s23
; SI-NEXT:    v_mov_b32_e32 v16, s24
; SI-NEXT:    v_mov_b32_e32 v18, s25
; SI-NEXT:    v_mov_b32_e32 v20, s26
; SI-NEXT:    v_mov_b32_e32 v22, s27
; SI-NEXT:    v_mov_b32_e32 v24, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v26, s29
; SI-NEXT:    s_cbranch_scc0 .LBB37_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v16, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_cbranch_execnz .LBB37_3
; SI-NEXT:  .LBB37_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v30, 1.0, v30
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_alignbit_b32 v29, v30, v28, 16
; SI-NEXT:    v_alignbit_b32 v25, v26, v24, 16
; SI-NEXT:    v_alignbit_b32 v21, v22, v20, 16
; SI-NEXT:    v_alignbit_b32 v17, v18, v16, 16
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB37_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB37_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_branch .LBB37_2
;
; VI-LABEL: bitcast_v16f32_to_v32i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB37_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB37_3
; VI-NEXT:  .LBB37_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB37_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB37_4:
; VI-NEXT:    s_branch .LBB37_2
;
; GFX9-LABEL: bitcast_v16f32_to_v32i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB37_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB37_3
; GFX9-NEXT:  .LBB37_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB37_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB37_4:
; GFX9-NEXT:    s_branch .LBB37_2
;
; GFX11-LABEL: bitcast_v16f32_to_v32i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB37_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB37_4
; GFX11-NEXT:  .LBB37_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v15, s27, 1.0
; GFX11-NEXT:    v_add_f32_e64 v14, s26, 1.0
; GFX11-NEXT:    v_add_f32_e64 v13, s25, 1.0
; GFX11-NEXT:    v_add_f32_e64 v12, s24, 1.0
; GFX11-NEXT:    v_add_f32_e64 v11, s23, 1.0
; GFX11-NEXT:    v_add_f32_e64 v10, s22, 1.0
; GFX11-NEXT:    v_add_f32_e64 v9, s21, 1.0
; GFX11-NEXT:    v_add_f32_e64 v8, s20, 1.0
; GFX11-NEXT:    v_add_f32_e64 v7, s19, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s18, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s17, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s16, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s15, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s14, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s13, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s12, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB37_3:
; GFX11-NEXT:    s_branch .LBB37_2
; GFX11-NEXT:  .LBB37_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <32 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <32 x i16>
  br label %end

end:
  %phi = phi <32 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i16> %phi
}

define <16 x float> @bitcast_v32i16_to_v16f32(<32 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v32i16_to_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v31, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    v_mov_b32_e32 v38, v14
; SI-NEXT:    v_mov_b32_e32 v37, v12
; SI-NEXT:    v_mov_b32_e32 v36, v10
; SI-NEXT:    v_mov_b32_e32 v35, v8
; SI-NEXT:    v_mov_b32_e32 v34, v6
; SI-NEXT:    v_mov_b32_e32 v33, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v55, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v54, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v53, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v52, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v51, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v50, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v49, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v48, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v39, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v29
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB38_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v31
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v32
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v33
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v34
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v35
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v36
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v37
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v38
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v16
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v22
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v24
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v26
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v28
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v30
; SI-NEXT:    v_or_b32_e32 v0, v0, v42
; SI-NEXT:    v_or_b32_e32 v1, v1, v41
; SI-NEXT:    v_or_b32_e32 v2, v2, v40
; SI-NEXT:    v_or_b32_e32 v3, v3, v55
; SI-NEXT:    v_or_b32_e32 v4, v4, v54
; SI-NEXT:    v_or_b32_e32 v5, v5, v53
; SI-NEXT:    v_or_b32_e32 v6, v6, v52
; SI-NEXT:    v_or_b32_e32 v7, v7, v51
; SI-NEXT:    v_or_b32_e32 v8, v8, v50
; SI-NEXT:    v_or_b32_e32 v9, v9, v49
; SI-NEXT:    v_or_b32_e32 v10, v10, v48
; SI-NEXT:    v_or_b32_e32 v11, v11, v39
; SI-NEXT:    v_or_b32_e32 v12, v12, v23
; SI-NEXT:    v_or_b32_e32 v13, v13, v21
; SI-NEXT:    v_or_b32_e32 v14, v14, v19
; SI-NEXT:    v_or_b32_e32 v15, v15, v17
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:  .LBB38_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB38_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v33
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v34
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v35
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v36
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v37
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v38
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v30
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v41, v1
; SI-NEXT:    v_or_b32_e32 v2, v40, v2
; SI-NEXT:    v_or_b32_e32 v3, v55, v3
; SI-NEXT:    v_or_b32_e32 v4, v54, v4
; SI-NEXT:    v_or_b32_e32 v5, v53, v5
; SI-NEXT:    v_or_b32_e32 v6, v52, v6
; SI-NEXT:    v_or_b32_e32 v7, v51, v7
; SI-NEXT:    v_or_b32_e32 v8, v50, v8
; SI-NEXT:    v_or_b32_e32 v9, v49, v9
; SI-NEXT:    v_or_b32_e32 v10, v48, v10
; SI-NEXT:    v_or_b32_e32 v11, v39, v11
; SI-NEXT:    v_or_b32_e32 v12, v23, v12
; SI-NEXT:    v_or_b32_e32 v13, v21, v13
; SI-NEXT:    v_or_b32_e32 v14, v19, v14
; SI-NEXT:    v_or_b32_e32 v15, v17, v15
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v15
; SI-NEXT:  .LBB38_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i16_to_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB38_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v17, 3
; VI-NEXT:    v_add_u16_e32 v16, 3, v15
; VI-NEXT:    v_add_u16_sdwa v15, v15, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_u16_e32 v16, 3, v14
; VI-NEXT:    v_add_u16_sdwa v14, v14, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v16, v14
; VI-NEXT:    v_add_u16_e32 v16, 3, v13
; VI-NEXT:    v_add_u16_sdwa v13, v13, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v16, v13
; VI-NEXT:    v_add_u16_e32 v16, 3, v12
; VI-NEXT:    v_add_u16_sdwa v12, v12, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v16, v12
; VI-NEXT:    v_add_u16_e32 v16, 3, v11
; VI-NEXT:    v_add_u16_sdwa v11, v11, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v16, v11
; VI-NEXT:    v_add_u16_e32 v16, 3, v10
; VI-NEXT:    v_add_u16_sdwa v10, v10, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v16, v10
; VI-NEXT:    v_add_u16_e32 v16, 3, v9
; VI-NEXT:    v_add_u16_sdwa v9, v9, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v16, v9
; VI-NEXT:    v_add_u16_e32 v16, 3, v8
; VI-NEXT:    v_add_u16_sdwa v8, v8, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v8, v16, v8
; VI-NEXT:    v_add_u16_e32 v16, 3, v7
; VI-NEXT:    v_add_u16_sdwa v7, v7, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v16, v7
; VI-NEXT:    v_add_u16_e32 v16, 3, v6
; VI-NEXT:    v_add_u16_sdwa v6, v6, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v16, v6
; VI-NEXT:    v_add_u16_e32 v16, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v16, v5
; VI-NEXT:    v_add_u16_e32 v16, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v16, v4
; VI-NEXT:    v_add_u16_e32 v16, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v16, v3
; VI-NEXT:    v_add_u16_e32 v16, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v16, v2
; VI-NEXT:    v_add_u16_e32 v16, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v16, v1
; VI-NEXT:    v_add_u16_e32 v16, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v16, v0
; VI-NEXT:  .LBB38_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i16_to_v16f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB38_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB38_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32i16_to_v16f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB38_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  .LBB38_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i16> %a, splat (i16 3)
  %a2 = bitcast <32 x i16> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i16> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define inreg <16 x float> @bitcast_v32i16_to_v16f32_scalar(<32 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i16_to_v16f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v26, v14
; SI-NEXT:    v_mov_b32_e32 v25, v12
; SI-NEXT:    v_mov_b32_e32 v19, v10
; SI-NEXT:    v_mov_b32_e32 v20, v8
; SI-NEXT:    v_mov_b32_e32 v21, v6
; SI-NEXT:    v_mov_b32_e32 v22, v4
; SI-NEXT:    v_mov_b32_e32 v23, v2
; SI-NEXT:    v_mov_b32_e32 v24, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    s_cbranch_scc0 .LBB39_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v24
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    v_or_b32_e32 v7, v0, v33
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v22
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    v_or_b32_e32 v9, v0, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v21
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    v_or_b32_e32 v10, v0, v30
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v20
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    v_or_b32_e32 v11, v0, v29
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v19
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    v_or_b32_e32 v12, v0, v28
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v25
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    v_or_b32_e32 v13, v0, v27
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v26
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v23
; SI-NEXT:    v_or_b32_e32 v14, v0, v18
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v16
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_or_b32_e32 v8, v1, v32
; SI-NEXT:    v_or_b32_e32 v15, v0, v17
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB39_3
; SI-NEXT:  .LBB39_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v33, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v23
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v32, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v31, v0
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v21
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v30, v0
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v29, v0
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v19
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_or_b32_e32 v0, v28, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v25
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v26
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v16
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v17, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB39_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB39_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_branch .LBB39_2
;
; VI-LABEL: bitcast_v32i16_to_v16f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    v_readfirstlane_b32 s6, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v1
; VI-NEXT:    s_cbranch_scc0 .LBB39_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB39_3
; VI-NEXT:  .LBB39_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s7, 3
; VI-NEXT:    s_and_b32 s4, s7, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s6, 3
; VI-NEXT:    s_add_i32 s7, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s6, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s29, 3
; VI-NEXT:    s_add_i32 s6, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s29, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s28, 3
; VI-NEXT:    s_add_i32 s29, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s28, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s27, 3
; VI-NEXT:    s_add_i32 s28, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s27, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s26, 3
; VI-NEXT:    s_add_i32 s27, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s26, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s25, 3
; VI-NEXT:    s_add_i32 s26, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s25, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s24, 3
; VI-NEXT:    s_add_i32 s25, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s24, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s23, 3
; VI-NEXT:    s_add_i32 s24, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s22, 3
; VI-NEXT:    s_add_i32 s23, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_add_i32 s22, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB39_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    v_mov_b32_e32 v14, s6
; VI-NEXT:    v_mov_b32_e32 v15, s7
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB39_4:
; VI-NEXT:    s_branch .LBB39_2
;
; GFX9-LABEL: bitcast_v32i16_to_v16f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB39_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB39_3
; GFX9-NEXT:  .LBB39_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB39_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB39_4:
; GFX9-NEXT:    s_branch .LBB39_2
;
; GFX11-LABEL: bitcast_v32i16_to_v16f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB39_4
; GFX11-NEXT:  .LBB39_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v15, s27, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v14, s26, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v13, s25, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v12, s24, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v11, s23, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v10, s22, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v9, s21, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v8, s20, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v7, s19, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, s18, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, s17, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s16, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s15, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s14, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s13, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s12, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB39_3:
; GFX11-NEXT:    s_branch .LBB39_2
; GFX11-NEXT:  .LBB39_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i16> %a, splat (i16 3)
  %a2 = bitcast <32 x i16> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i16> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define <32 x half> @bitcast_v16f32_to_v32f16(<16 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v16f32_to_v32f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v32, v15
; SI-NEXT:    v_mov_b32_e32 v33, v14
; SI-NEXT:    v_mov_b32_e32 v34, v13
; SI-NEXT:    v_mov_b32_e32 v35, v12
; SI-NEXT:    v_mov_b32_e32 v36, v11
; SI-NEXT:    v_mov_b32_e32 v37, v10
; SI-NEXT:    v_mov_b32_e32 v38, v9
; SI-NEXT:    v_mov_b32_e32 v39, v8
; SI-NEXT:    v_mov_b32_e32 v48, v7
; SI-NEXT:    v_mov_b32_e32 v49, v6
; SI-NEXT:    v_mov_b32_e32 v50, v5
; SI-NEXT:    v_mov_b32_e32 v51, v4
; SI-NEXT:    v_mov_b32_e32 v52, v3
; SI-NEXT:    v_mov_b32_e32 v53, v2
; SI-NEXT:    v_mov_b32_e32 v54, v1
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB40_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB40_4
; SI-NEXT:  .LBB40_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB40_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v52
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v54
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v52
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v54
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v55
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_2
; SI-NEXT:  .LBB40_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v55
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v54
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v53
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v52
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v51
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v50
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v49
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v48
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v39
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v38
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v37
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v36
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v35
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v34
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v33
; SI-NEXT:    v_add_f32_e32 v30, 1.0, v32
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v17, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f32_to_v32f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB40_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB40_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f32_to_v32f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB40_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB40_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f32_to_v32f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB40_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB40_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <32 x half>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <32 x half>
  br label %end

end:
  %phi = phi <32 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x half> %phi
}

define inreg <32 x half> @bitcast_v16f32_to_v32f16_scalar(<16 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f32_to_v32f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_readfirstlane_b32 s6, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s7, v1
; SI-NEXT:    s_cbranch_scc0 .LBB41_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s4
; SI-NEXT:    s_lshr_b32 s4, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s4
; SI-NEXT:    s_lshr_b32 s4, s29, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s4
; SI-NEXT:    s_lshr_b32 s4, s28, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s4
; SI-NEXT:    s_lshr_b32 s4, s27, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s4
; SI-NEXT:    s_lshr_b32 s4, s26, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s4
; SI-NEXT:    s_lshr_b32 s4, s25, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s4
; SI-NEXT:    s_lshr_b32 s4, s24, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s4
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB41_3
; SI-NEXT:  .LBB41_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v8, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v10, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v12, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v14, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v16, s24, 1.0
; SI-NEXT:    v_add_f32_e64 v18, s25, 1.0
; SI-NEXT:    v_add_f32_e64 v20, s26, 1.0
; SI-NEXT:    v_add_f32_e64 v22, s27, 1.0
; SI-NEXT:    v_add_f32_e64 v24, s28, 1.0
; SI-NEXT:    v_add_f32_e64 v26, s29, 1.0
; SI-NEXT:    v_add_f32_e64 v28, s6, 1.0
; SI-NEXT:    v_add_f32_e64 v30, s7, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v17, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:  .LBB41_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB41_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_branch .LBB41_2
;
; VI-LABEL: bitcast_v16f32_to_v32f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB41_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB41_3
; VI-NEXT:  .LBB41_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB41_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB41_4:
; VI-NEXT:    s_branch .LBB41_2
;
; GFX9-LABEL: bitcast_v16f32_to_v32f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB41_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB41_3
; GFX9-NEXT:  .LBB41_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB41_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB41_4:
; GFX9-NEXT:    s_branch .LBB41_2
;
; GFX11-LABEL: bitcast_v16f32_to_v32f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB41_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB41_4
; GFX11-NEXT:  .LBB41_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v15, s27, 1.0
; GFX11-NEXT:    v_add_f32_e64 v14, s26, 1.0
; GFX11-NEXT:    v_add_f32_e64 v13, s25, 1.0
; GFX11-NEXT:    v_add_f32_e64 v12, s24, 1.0
; GFX11-NEXT:    v_add_f32_e64 v11, s23, 1.0
; GFX11-NEXT:    v_add_f32_e64 v10, s22, 1.0
; GFX11-NEXT:    v_add_f32_e64 v9, s21, 1.0
; GFX11-NEXT:    v_add_f32_e64 v8, s20, 1.0
; GFX11-NEXT:    v_add_f32_e64 v7, s19, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s18, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s17, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s16, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s15, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s14, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s13, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s12, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB41_3:
; GFX11-NEXT:    s_branch .LBB41_2
; GFX11-NEXT:  .LBB41_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <32 x half>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <32 x half>
  br label %end

end:
  %phi = phi <32 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x half> %phi
}

define <16 x float> @bitcast_v32f16_to_v16f32(<32 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v32f16_to_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:4
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v40, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v55, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v54, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v53, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v52, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v51, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v50, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v49, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v30
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v47
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v56
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v46
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v44
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v42
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v40
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v54
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v52
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v50
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v48
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v38
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v36
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v32
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_or_b32_e32 v1, v43, v1
; SI-NEXT:    v_or_b32_e32 v2, v41, v2
; SI-NEXT:    v_or_b32_e32 v3, v55, v3
; SI-NEXT:    v_or_b32_e32 v4, v53, v4
; SI-NEXT:    v_or_b32_e32 v5, v51, v5
; SI-NEXT:    v_or_b32_e32 v6, v49, v6
; SI-NEXT:    v_or_b32_e32 v7, v39, v7
; SI-NEXT:    v_or_b32_e32 v8, v37, v8
; SI-NEXT:    v_or_b32_e32 v9, v35, v9
; SI-NEXT:    v_or_b32_e32 v10, v33, v10
; SI-NEXT:    v_or_b32_e32 v11, v31, v11
; SI-NEXT:    v_or_b32_e32 v12, v22, v12
; SI-NEXT:    v_or_b32_e32 v13, v20, v13
; SI-NEXT:    v_or_b32_e32 v14, v18, v14
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:  .LBB42_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v44
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v45
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v43
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v41
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v40
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v55
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v53
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v54
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v52
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v50
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v49
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v39
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v38
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v36
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v35
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v33
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_or_b32_e32 v9, v11, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v32
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v23
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v22
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v20
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_or_b32_e32 v12, v14, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v19
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:  .LBB42_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32f16_to_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB42_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v16, 0x200
; VI-NEXT:    v_add_f16_sdwa v17, v15, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v15
; VI-NEXT:    v_or_b32_e32 v15, v15, v17
; VI-NEXT:    v_add_f16_sdwa v17, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v14
; VI-NEXT:    v_or_b32_e32 v14, v14, v17
; VI-NEXT:    v_add_f16_sdwa v17, v13, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v13
; VI-NEXT:    v_or_b32_e32 v13, v13, v17
; VI-NEXT:    v_add_f16_sdwa v17, v12, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v12
; VI-NEXT:    v_or_b32_e32 v12, v12, v17
; VI-NEXT:    v_add_f16_sdwa v17, v11, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v11
; VI-NEXT:    v_or_b32_e32 v11, v11, v17
; VI-NEXT:    v_add_f16_sdwa v17, v10, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v10
; VI-NEXT:    v_or_b32_e32 v10, v10, v17
; VI-NEXT:    v_add_f16_sdwa v17, v9, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v9
; VI-NEXT:    v_or_b32_e32 v9, v9, v17
; VI-NEXT:    v_add_f16_sdwa v17, v8, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v8
; VI-NEXT:    v_or_b32_e32 v8, v8, v17
; VI-NEXT:    v_add_f16_sdwa v17, v7, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v17
; VI-NEXT:    v_add_f16_sdwa v17, v6, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v17
; VI-NEXT:    v_add_f16_sdwa v17, v5, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v17
; VI-NEXT:    v_add_f16_sdwa v17, v4, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v17
; VI-NEXT:    v_add_f16_sdwa v17, v3, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v17
; VI-NEXT:    v_add_f16_sdwa v17, v2, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v17
; VI-NEXT:    v_add_f16_sdwa v17, v1, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v16, v0, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v17
; VI-NEXT:    v_or_b32_e32 v0, v0, v16
; VI-NEXT:  .LBB42_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32f16_to_v16f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB42_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, v12, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, v11, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, v10, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB42_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32f16_to_v16f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB42_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  .LBB42_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <32 x half> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x half> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define inreg <16 x float> @bitcast_v32f16_to_v16f32_scalar(<32 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32f16_to_v16f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f16_f32_e32 v51, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v50, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v40, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v55, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v54, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v53, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v52, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v49, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v48, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v39, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v38, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v37, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v36, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v35, s28
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB43_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v51
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v40
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v54
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v52
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v48
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v38
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v36
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v32
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v30
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v26
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v24
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v22
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v0, v50, v0
; SI-NEXT:    v_or_b32_e32 v1, v55, v1
; SI-NEXT:    v_or_b32_e32 v2, v53, v2
; SI-NEXT:    v_or_b32_e32 v3, v49, v3
; SI-NEXT:    v_or_b32_e32 v4, v39, v4
; SI-NEXT:    v_or_b32_e32 v5, v37, v5
; SI-NEXT:    v_or_b32_e32 v6, v35, v6
; SI-NEXT:    v_or_b32_e32 v7, v33, v7
; SI-NEXT:    v_or_b32_e32 v8, v31, v8
; SI-NEXT:    v_or_b32_e32 v9, v29, v9
; SI-NEXT:    v_or_b32_e32 v10, v27, v10
; SI-NEXT:    v_or_b32_e32 v11, v25, v11
; SI-NEXT:    v_or_b32_e32 v12, v23, v12
; SI-NEXT:    v_or_b32_e32 v13, v21, v13
; SI-NEXT:    v_or_b32_e32 v14, v19, v14
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    s_cbranch_execnz .LBB43_3
; SI-NEXT:  .LBB43_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v40
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v55
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v54
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v53
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v52
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v49
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v39
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v38
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v36
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v35
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v33
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v32
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v30
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v29
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v27
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_or_b32_e32 v9, v11, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v26
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v24
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v23
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v21
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_or_b32_e32 v12, v14, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v20
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:  .LBB43_3: ; %end
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB43_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_branch .LBB43_2
;
; VI-LABEL: bitcast_v32f16_to_v16f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB43_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB43_3
; VI-NEXT:  .LBB43_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v16, 0x200
; VI-NEXT:    v_add_f16_sdwa v17, v15, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v15
; VI-NEXT:    v_or_b32_e32 v15, v15, v17
; VI-NEXT:    v_add_f16_sdwa v17, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v14
; VI-NEXT:    v_or_b32_e32 v14, v14, v17
; VI-NEXT:    v_add_f16_sdwa v17, v13, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v13
; VI-NEXT:    v_or_b32_e32 v13, v13, v17
; VI-NEXT:    v_add_f16_sdwa v17, v12, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v12
; VI-NEXT:    v_or_b32_e32 v12, v12, v17
; VI-NEXT:    v_add_f16_sdwa v17, v11, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v11
; VI-NEXT:    v_or_b32_e32 v11, v11, v17
; VI-NEXT:    v_add_f16_sdwa v17, v10, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v10
; VI-NEXT:    v_or_b32_e32 v10, v10, v17
; VI-NEXT:    v_add_f16_sdwa v17, v9, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v9
; VI-NEXT:    v_or_b32_e32 v9, v9, v17
; VI-NEXT:    v_add_f16_sdwa v17, v8, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v8
; VI-NEXT:    v_or_b32_e32 v8, v8, v17
; VI-NEXT:    v_add_f16_sdwa v17, v7, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v17
; VI-NEXT:    v_add_f16_sdwa v17, v6, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v17
; VI-NEXT:    v_add_f16_sdwa v17, v5, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v17
; VI-NEXT:    v_add_f16_sdwa v17, v4, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v17
; VI-NEXT:    v_add_f16_sdwa v17, v3, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v17
; VI-NEXT:    v_add_f16_sdwa v17, v2, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v17
; VI-NEXT:    v_add_f16_sdwa v17, v1, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v16, v0, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v17
; VI-NEXT:    v_or_b32_e32 v0, v0, v16
; VI-NEXT:  .LBB43_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB43_4:
; VI-NEXT:    s_branch .LBB43_2
;
; GFX9-LABEL: bitcast_v32f16_to_v16f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB43_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB43_3
; GFX9-NEXT:  .LBB43_2: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s4, 0x200
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, v12, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, v11, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, v10, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s4 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB43_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB43_4:
; GFX9-NEXT:    s_branch .LBB43_2
;
; GFX11-LABEL: bitcast_v32f16_to_v16f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB43_4
; GFX11-NEXT:  .LBB43_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v15, 0x200, s27 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v14, 0x200, s26 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v13, 0x200, s25 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v12, 0x200, s24 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v11, 0x200, s23 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v10, 0x200, s22 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v9, 0x200, s21 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v8, 0x200, s20 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, s19 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, s18 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s17 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s16 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s15 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s14 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s13 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s12 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB43_3:
; GFX11-NEXT:    s_branch .LBB43_2
; GFX11-NEXT:  .LBB43_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <32 x half> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x half> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define <32 x bfloat> @bitcast_v16f32_to_v32bf16(<16 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v16f32_to_v32bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v55, v15
; SI-NEXT:    v_mov_b32_e32 v54, v14
; SI-NEXT:    v_mov_b32_e32 v53, v13
; SI-NEXT:    v_mov_b32_e32 v52, v12
; SI-NEXT:    v_mov_b32_e32 v51, v11
; SI-NEXT:    v_mov_b32_e32 v50, v10
; SI-NEXT:    v_mov_b32_e32 v49, v9
; SI-NEXT:    v_mov_b32_e32 v48, v8
; SI-NEXT:    v_mov_b32_e32 v39, v7
; SI-NEXT:    v_mov_b32_e32 v38, v6
; SI-NEXT:    v_mov_b32_e32 v37, v5
; SI-NEXT:    v_mov_b32_e32 v36, v4
; SI-NEXT:    v_mov_b32_e32 v35, v3
; SI-NEXT:    v_mov_b32_e32 v34, v2
; SI-NEXT:    v_mov_b32_e32 v33, v1
; SI-NEXT:    v_mov_b32_e32 v32, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_4
; SI-NEXT:  .LBB44_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB44_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v31, 0xffff0000, v55
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v55
; SI-NEXT:    v_and_b32_e32 v29, 0xffff0000, v54
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v54
; SI-NEXT:    v_and_b32_e32 v27, 0xffff0000, v53
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v53
; SI-NEXT:    v_and_b32_e32 v25, 0xffff0000, v52
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v52
; SI-NEXT:    v_and_b32_e32 v23, 0xffff0000, v51
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v51
; SI-NEXT:    v_and_b32_e32 v21, 0xffff0000, v50
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v50
; SI-NEXT:    v_and_b32_e32 v19, 0xffff0000, v49
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v49
; SI-NEXT:    v_and_b32_e32 v17, 0xffff0000, v48
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v48
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v39
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v39
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v38
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v38
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v37
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v37
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v36
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v36
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v35
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v35
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v34
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v34
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v33
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v32
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB44_2
; SI-NEXT:  .LBB44_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v32
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v33
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v34
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v35
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v36
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v37
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v38
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v39
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v48
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v49
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v50
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v51
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v52
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v53
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v54
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v55
; SI-NEXT:    v_and_b32_e32 v31, 0xffff0000, v15
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v15
; SI-NEXT:    v_and_b32_e32 v29, 0xffff0000, v14
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v14
; SI-NEXT:    v_and_b32_e32 v27, 0xffff0000, v13
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v13
; SI-NEXT:    v_and_b32_e32 v25, 0xffff0000, v12
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v12
; SI-NEXT:    v_and_b32_e32 v23, 0xffff0000, v11
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v11
; SI-NEXT:    v_and_b32_e32 v21, 0xffff0000, v10
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v10
; SI-NEXT:    v_and_b32_e32 v19, 0xffff0000, v9
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v9
; SI-NEXT:    v_and_b32_e32 v17, 0xffff0000, v8
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v8
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f32_to_v32bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB44_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB44_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f32_to_v32bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB44_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB44_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f32_to_v32bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB44_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB44_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <32 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <32 x bfloat>
  br label %end

end:
  %phi = phi <32 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x bfloat> %phi
}

define inreg <32 x bfloat> @bitcast_v16f32_to_v32bf16_scalar(<16 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f32_to_v32bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_mov_b32_e32 v34, s16
; SI-NEXT:    v_mov_b32_e32 v35, s17
; SI-NEXT:    v_mov_b32_e32 v36, s18
; SI-NEXT:    v_mov_b32_e32 v37, s19
; SI-NEXT:    v_mov_b32_e32 v38, s20
; SI-NEXT:    v_mov_b32_e32 v39, s21
; SI-NEXT:    v_mov_b32_e32 v48, s22
; SI-NEXT:    v_mov_b32_e32 v49, s23
; SI-NEXT:    v_mov_b32_e32 v50, s24
; SI-NEXT:    v_mov_b32_e32 v51, s25
; SI-NEXT:    v_mov_b32_e32 v52, s26
; SI-NEXT:    v_mov_b32_e32 v53, s27
; SI-NEXT:    v_mov_b32_e32 v54, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v55, s29
; SI-NEXT:    s_cbranch_scc0 .LBB45_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v31, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v1
; SI-NEXT:    v_and_b32_e32 v29, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v0
; SI-NEXT:    v_and_b32_e32 v27, 0xffff0000, v55
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v55
; SI-NEXT:    v_and_b32_e32 v25, 0xffff0000, v54
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v54
; SI-NEXT:    v_and_b32_e32 v23, 0xffff0000, v53
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v53
; SI-NEXT:    v_and_b32_e32 v21, 0xffff0000, v52
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v52
; SI-NEXT:    v_and_b32_e32 v19, 0xffff0000, v51
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v51
; SI-NEXT:    v_and_b32_e32 v17, 0xffff0000, v50
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v50
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v49
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v49
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v48
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v48
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v39
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v39
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v38
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v38
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v37
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v37
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v36
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v36
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v35
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_and_b32_e32 v32, 0xffff0000, v34
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v34
; SI-NEXT:    s_cbranch_execnz .LBB45_3
; SI-NEXT:  .LBB45_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v33, 1.0, v34
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v35
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v36
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v37
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v38
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v39
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v48
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v49
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v50
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v51
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v52
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v53
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v54
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v55
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_and_b32_e32 v31, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v1
; SI-NEXT:    v_and_b32_e32 v29, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v0
; SI-NEXT:    v_and_b32_e32 v27, 0xffff0000, v14
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v14
; SI-NEXT:    v_and_b32_e32 v25, 0xffff0000, v13
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v13
; SI-NEXT:    v_and_b32_e32 v23, 0xffff0000, v12
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v12
; SI-NEXT:    v_and_b32_e32 v21, 0xffff0000, v11
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v11
; SI-NEXT:    v_and_b32_e32 v19, 0xffff0000, v10
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v10
; SI-NEXT:    v_and_b32_e32 v17, 0xffff0000, v9
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v9
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v8
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v8
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v6
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v32, 0xffff0000, v33
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; SI-NEXT:  .LBB45_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, v33
; SI-NEXT:    v_mov_b32_e32 v1, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB45_4:
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_branch .LBB45_2
;
; VI-LABEL: bitcast_v16f32_to_v32bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB45_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB45_3
; VI-NEXT:  .LBB45_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB45_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB45_4:
; VI-NEXT:    s_branch .LBB45_2
;
; GFX9-LABEL: bitcast_v16f32_to_v32bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB45_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB45_3
; GFX9-NEXT:  .LBB45_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB45_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB45_4:
; GFX9-NEXT:    s_branch .LBB45_2
;
; GFX11-LABEL: bitcast_v16f32_to_v32bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s15, s3
; GFX11-NEXT:    s_mov_b32 s14, s2
; GFX11-NEXT:    s_mov_b32 s13, s1
; GFX11-NEXT:    s_mov_b32 s12, s0
; GFX11-NEXT:    s_cmp_lg_u32 s28, 0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB45_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB45_4
; GFX11-NEXT:  .LBB45_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v15, s27, 1.0
; GFX11-NEXT:    v_add_f32_e64 v14, s26, 1.0
; GFX11-NEXT:    v_add_f32_e64 v13, s25, 1.0
; GFX11-NEXT:    v_add_f32_e64 v12, s24, 1.0
; GFX11-NEXT:    v_add_f32_e64 v11, s23, 1.0
; GFX11-NEXT:    v_add_f32_e64 v10, s22, 1.0
; GFX11-NEXT:    v_add_f32_e64 v9, s21, 1.0
; GFX11-NEXT:    v_add_f32_e64 v8, s20, 1.0
; GFX11-NEXT:    v_add_f32_e64 v7, s19, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s18, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s17, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s16, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s15, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s14, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s13, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s12, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB45_3:
; GFX11-NEXT:    s_branch .LBB45_2
; GFX11-NEXT:  .LBB45_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v3, s15
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <16 x float> %a1 to <32 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <16 x float> %a to <32 x bfloat>
  br label %end

end:
  %phi = phi <32 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x bfloat> %phi
}

define <16 x float> @bitcast_v32bf16_to_v16f32(<32 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v32bf16_to_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32
; SI-NEXT:    v_mul_f32_e32 v45, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v46, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v43, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v44, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v41, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v42, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v55, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v40, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v53, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v54, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v51, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v52, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v49, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v50, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v39, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v48, 1.0, v14
; SI-NEXT:    v_mul_f32_e32 v37, 1.0, v17
; SI-NEXT:    v_mul_f32_e32 v38, 1.0, v16
; SI-NEXT:    v_mul_f32_e32 v35, 1.0, v19
; SI-NEXT:    v_mul_f32_e32 v36, 1.0, v18
; SI-NEXT:    v_mul_f32_e32 v33, 1.0, v21
; SI-NEXT:    v_mul_f32_e32 v34, 1.0, v20
; SI-NEXT:    v_mul_f32_e32 v31, 1.0, v23
; SI-NEXT:    v_mul_f32_e32 v32, 1.0, v22
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v25
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v24
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v27
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v26
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v29
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v28
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v30
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v47
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v56
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB46_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v45
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v43
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v41
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v55
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v53
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v51
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v49
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v39
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v37
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v35
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v33
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v31
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v16
; SI-NEXT:    v_alignbit_b32 v0, v0, v46, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v44, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v42, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v40, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v54, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v52, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v50, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v48, 16
; SI-NEXT:    v_alignbit_b32 v8, v8, v38, 16
; SI-NEXT:    v_alignbit_b32 v9, v9, v36, 16
; SI-NEXT:    v_alignbit_b32 v10, v10, v34, 16
; SI-NEXT:    v_alignbit_b32 v11, v11, v32, 16
; SI-NEXT:    v_alignbit_b32 v12, v12, v23, 16
; SI-NEXT:    v_alignbit_b32 v13, v13, v21, 16
; SI-NEXT:    v_alignbit_b32 v14, v14, v19, 16
; SI-NEXT:    v_alignbit_b32 v15, v15, v18, 16
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:  .LBB46_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB46_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v45
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v46
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v44
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v41
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v42
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v55
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v40
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v53
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v54
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v51
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v52
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v49
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v50
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v39
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v48
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v37
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v38
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v35
; SI-NEXT:    v_alignbit_b32 v8, v9, v8, 16
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v36
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v33
; SI-NEXT:    v_alignbit_b32 v9, v10, v9, 16
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v34
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v31
; SI-NEXT:    v_alignbit_b32 v10, v11, v10, 16
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v32
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v22
; SI-NEXT:    v_alignbit_b32 v11, v12, v11, 16
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v12, v13, v12, 16
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v17
; SI-NEXT:    v_alignbit_b32 v13, v14, v13, 16
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_and_b32_e32 v16, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v14, v15, v14, 16
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v18
; SI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_lshrrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_alignbit_b32 v15, v16, v15, 16
; SI-NEXT:  .LBB46_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32bf16_to_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB46_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v15
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x7fff, v17
; VI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v15, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v15
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v15
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; VI-NEXT:    v_cndmask_b32_e32 v15, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v15, 16, v15
; VI-NEXT:    v_alignbit_b32 v15, v15, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v14
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v14, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v14
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v14
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; VI-NEXT:    v_cndmask_b32_e32 v14, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; VI-NEXT:    v_alignbit_b32 v14, v14, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v13
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v13, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v13
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v13
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; VI-NEXT:    v_cndmask_b32_e32 v13, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v13, 16, v13
; VI-NEXT:    v_alignbit_b32 v13, v13, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v12
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v12, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v12
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v12
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; VI-NEXT:    v_cndmask_b32_e32 v12, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; VI-NEXT:    v_alignbit_b32 v12, v12, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v11, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v11
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v11
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; VI-NEXT:    v_cndmask_b32_e32 v11, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; VI-NEXT:    v_alignbit_b32 v11, v11, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v10
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v10, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v10
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v10
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; VI-NEXT:    v_cndmask_b32_e32 v10, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; VI-NEXT:    v_alignbit_b32 v10, v10, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v9
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v9, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v9
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v9
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; VI-NEXT:    v_cndmask_b32_e32 v9, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; VI-NEXT:    v_alignbit_b32 v9, v9, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v8
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v8
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_cndmask_b32_e32 v8, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; VI-NEXT:    v_alignbit_b32 v8, v8, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v7
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v7, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v7
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v7
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; VI-NEXT:    v_cndmask_b32_e32 v7, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; VI-NEXT:    v_alignbit_b32 v7, v7, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v6
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v6, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v6
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v6
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; VI-NEXT:    v_cndmask_b32_e32 v6, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_alignbit_b32 v6, v6, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v5
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_cndmask_b32_e32 v5, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; VI-NEXT:    v_alignbit_b32 v5, v5, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v4
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v4
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_cndmask_b32_e32 v4, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; VI-NEXT:    v_alignbit_b32 v4, v4, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v3
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v3
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_alignbit_b32 v3, v3, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v2
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v2
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v1
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v1
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v0
; VI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; VI-NEXT:    v_bfe_u32 v17, v16, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v16
; VI-NEXT:    v_add_u32_e32 v17, vcc, s6, v17
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; VI-NEXT:    v_bfe_u32 v17, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v17, vcc, v17, v0
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x7fff, v17
; VI-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v17, v18, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v16, 16
; VI-NEXT:  .LBB46_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32bf16_to_v16f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB46_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v15
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v15, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v15, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v15
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX9-NEXT:    v_cndmask_b32_e32 v15, v17, v18, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v15, v15, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v14
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v14, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v14, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v14
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX9-NEXT:    v_cndmask_b32_e32 v14, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v14, v14, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v13
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v13, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v13, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v13
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX9-NEXT:    v_cndmask_b32_e32 v13, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v13, v13, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v12
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v12, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v12, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v12
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX9-NEXT:    v_cndmask_b32_e32 v12, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v12, v12, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v11, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v11, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v11
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v11, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v11, v11, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v10
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v10, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v10, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v10
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v10, v10, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v9
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v9, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v9, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v9, v9, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v8
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v8, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v8, v8, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v7
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v7, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v7, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v7
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v7, v7, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v6
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v6, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v6, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v6
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v6, v6, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v5, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v5, v5, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v4, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v4, v4, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v3
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v3, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v3, v3, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v2, v2, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v1
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v1, v1, v16, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v16, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; GFX9-NEXT:    v_bfe_u32 v17, v16, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v17, v17, v16, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v16
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v16, v17, v18, vcc
; GFX9-NEXT:    v_bfe_u32 v17, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v17, v17, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v18, vcc
; GFX9-NEXT:    v_perm_b32 v0, v0, v16, s7
; GFX9-NEXT:  .LBB46_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v32bf16_to_v16f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB46_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff0000, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v15, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v15
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v20, v20, v15, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v15, v20, v22 :: v_dual_add_f32 v16, 0x40c00000, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v15.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v16, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v16
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v16, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v16, v19, v21 :: v_dual_and_b32 v17, 0xffff0000, v14
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v17, 0x40c00000, v17 :: v_dual_lshlrev_b32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_bfi_b32 v15, 0xffff, v15, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_bfe_u32 v23, v17, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v24, 0x400000, v17
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v25, v14, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v26, 0x400000, v14
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-TRUE16-NEXT:    v_add3_u32 v20, v23, v17, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v22, v25, v14, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v14, v22, v26, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v17, v20, v24 :: v_dual_and_b32 v18, 0xffff0000, v13
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v18 :: v_dual_lshlrev_b32 v13, 16, v13
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v14.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v18, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v18
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v13, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v13
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-TRUE16-NEXT:    v_bfi_b32 v14, 0xffff, v14, v17
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v19, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v13, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v13, v16, v20 :: v_dual_and_b32 v20, 0xffff0000, v11
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff0000, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v13.h
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v20
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v17, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v19, 0x40c00000, v19 :: v_dual_lshlrev_b32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v23, 0x400000, v20
; GFX11-TRUE16-NEXT:    v_bfi_b32 v13, 0xffff, v13, v16
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v18, v12, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v12
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v19, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v18, v12, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v12, v18, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v18, v20, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v17, v17, v22, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v11
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v18, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v11, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_bfi_b32 v12, 0xffff, v12, v17
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v11.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v18, v18, v23, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v19
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v11, 0xffff, v11, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v18, 0xffff0000, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v20, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_lshlrev_b32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v10, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v10, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v10, v16, v20, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v9, 16, 1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v17, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v18, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v9, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v9
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v20
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v9, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v20, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v23, 0x400000, v20
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v9.h
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v17, v17, v22 :: v_dual_and_b32 v22, 0xffff0000, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v19, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_bfi_b32 v9, 0xffff, v9, v17
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 0x40c00000, v7 :: v_dual_add_f32 v8, 0x40c00000, v8
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v8, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v8, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v8, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_bfi_b32 v10, 0xffff, v10, v16
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v7, 16, 1
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v18, v18, v23 :: v_dual_and_b32 v23, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v8.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v19, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v7, 0x7fff
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_bfi_b32 v8, 0xffff, v8, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v18, 0xffff0000, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v20, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v6, 0x40c00000, v6 :: v_dual_cndmask_b32 v7, v16, v20
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v6, 16, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v17, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v18, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v6, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v6
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v20, 0x40c00000, v20 :: v_dual_add_f32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v7.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v6, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v20, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    v_bfi_b32 v7, 0xffff, v7, v16
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v6.h
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v19, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v17, v17, v22, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v5
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v20
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v6, 0xffff, v6, v17
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v4, 16, 1
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v19, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v18, v18, v22, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_bfi_b32 v5, 0xffff, v5, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v18, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v16, v16, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v17, v20, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v18 :: v_dual_add_f32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v16, v16, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v17, v18, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v20, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, 0x400000, v18
; GFX11-TRUE16-NEXT:    v_add3_u32 v17, v17, v18, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v20, v20, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfe_u32 v23, v19, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v4.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v20, v21, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-TRUE16-NEXT:    v_add3_u32 v18, v23, v19, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-TRUE16-NEXT:    v_bfe_u32 v21, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v17, v17, v22 :: v_dual_and_b32 v22, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v21, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfi_b32 v4, 0xffff, v4, v16
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v21, 0x40c00000, v22 :: v_dual_cndmask_b32 v18, v18, v20
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v24, 0x400000, v21
; GFX11-TRUE16-NEXT:    v_bfi_b32 v3, 0xffff, v3, v17
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v19, v20, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v22
; GFX11-TRUE16-NEXT:    v_bfe_u32 v22, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v25, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v19, v21, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v23, v20, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v22, v22, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v27, 0x400000, v20
; GFX11-TRUE16-NEXT:    v_add3_u32 v19, v19, v21, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v23, v23, v20, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v22, v25, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_bfe_u32 v26, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v25, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v20, v23, v27, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v21, v21
; GFX11-TRUE16-NEXT:    v_add3_u32 v22, v26, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v2, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v20.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v19, v19, v24, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v19
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v22, v25, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v20, v0
; GFX11-TRUE16-NEXT:  .LBB46_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v32bf16_to_v16f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v16
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB46_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 0x40c00000, v17 :: v_dual_add_f32 v16, 0x40c00000, v16
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v17, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v16, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, 0x400000, v16
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v23, v14, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v21, v17, 0x7fff
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v16, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v23, v14, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, 0x400000, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; GFX11-FAKE16-NEXT:    v_bfe_u32 v20, v15, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v15
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v20, v20, v15, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v20, v22 :: v_dual_lshlrev_b32 v20, 16, v13
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v15, v16, 0x7060302
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v17, v21, v18 :: v_dual_add_f32 v18, 0x40c00000, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v14
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v19, v22 :: v_dual_lshlrev_b32 v19, 16, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v14, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v13, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 0x40c00000, v19 :: v_dual_cndmask_b32 v16, v16, v20
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v13, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v11
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v13, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v21
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v20, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v12, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v12, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v18, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v12, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v11, 16, 1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v11, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v19, v10, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v16, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v19, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v10
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v11, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v19, v22 :: v_dual_lshlrev_b32 v21, 16, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v21 :: v_dual_lshlrev_b32 v19, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v10, v17, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 0x40c00000, v19 :: v_dual_add_f32 v8, 0x40c00000, v8
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v8, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v20 :: v_dual_add_f32 v9, 0x40c00000, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v8, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v9, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v8
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v9, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v18, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v8, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v18 :: v_dual_add_f32 v19, 0x40c00000, v21
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v18, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_bfe_u32 v19, v6, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v20 :: v_dual_add_f32 v7, 0x40c00000, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v19, v6, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v17, v7, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v17, v7, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v17, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v17, v22, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v6
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v18, 0x40c00000, v21 :: v_dual_cndmask_b32 v17, v17, v20
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v20, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v19, v22 :: v_dual_lshlrev_b32 v19, 16, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v7, v16, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v6, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v17, 0x40c00000, v19
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v20, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v17, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v19, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, 0x400000, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v16, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v22, v17, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v5, v18, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v18, v4, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v16, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v18, v18, v4, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 0x40c00000, v20 :: v_dual_lshlrev_b32 v20, 16, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v18, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v17, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v18, 0x40c00000, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v17
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v4, v16, 0x7060302
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v21, v17, 0x7fff
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v18, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, 0x400000, v18
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v19, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v19, v21, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v22, v18, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v24, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v19, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v19, 0x40c00000, v22
; GFX11-FAKE16-NEXT:    v_add3_u32 v20, v24, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v3, v17, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v21, v23, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_bfe_u32 v22, v19, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v20, v21 :: v_dual_lshlrev_b32 v23, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v22, v19, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, 0x400000, v19
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v20, 0x40c00000, v23
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v2, v18, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v19, v21, v22 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v24, v20, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, 0x400000, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v21, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v24, v24, v20, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v21, v21, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v23, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v22, v23, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, 0x400000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v22, v23, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v1, v19, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v24, v25, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v21, v26, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v20, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB46_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <32 x bfloat> %a1 to <16 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x bfloat> %a to <16 x float>
  br label %end

end:
  %phi = phi <16 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x float> %phi
}

define inreg <16 x float> @bitcast_v32bf16_to_v16f32_scalar(<32 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32bf16_to_v16f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mul_f32_e64 v34, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v35, 1.0, s16
; SI-NEXT:    v_mul_f32_e32 v32, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v33, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v30, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v31, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v28, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v29, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v26, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v27, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v24, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v25, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v14
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_mul_f32_e64 v54, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v55, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v52, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v53, 1.0, s20
; SI-NEXT:    v_mul_f32_e64 v50, 1.0, s23
; SI-NEXT:    v_mul_f32_e64 v51, 1.0, s22
; SI-NEXT:    v_mul_f32_e64 v48, 1.0, s25
; SI-NEXT:    v_mul_f32_e64 v49, 1.0, s24
; SI-NEXT:    v_mul_f32_e64 v38, 1.0, s27
; SI-NEXT:    v_mul_f32_e64 v39, 1.0, s26
; SI-NEXT:    v_mul_f32_e64 v36, 1.0, s29
; SI-NEXT:    v_mul_f32_e64 v37, 1.0, s28
; SI-NEXT:    s_cbranch_scc0 .LBB47_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v54
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v52
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v50
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v48
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v38
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v36
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v32
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v30
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_alignbit_b32 v0, v0, v35, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v55, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v53, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v51, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v49, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v39, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v37, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v33, 16
; SI-NEXT:    v_alignbit_b32 v8, v8, v31, 16
; SI-NEXT:    v_alignbit_b32 v9, v9, v29, 16
; SI-NEXT:    v_alignbit_b32 v10, v10, v27, 16
; SI-NEXT:    v_alignbit_b32 v11, v11, v25, 16
; SI-NEXT:    v_alignbit_b32 v12, v12, v23, 16
; SI-NEXT:    v_alignbit_b32 v13, v13, v21, 16
; SI-NEXT:    v_alignbit_b32 v14, v14, v19, 16
; SI-NEXT:    v_alignbit_b32 v15, v15, v16, 16
; SI-NEXT:    s_cbranch_execnz .LBB47_3
; SI-NEXT:  .LBB47_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v34
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v35
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v54
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v55
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v52
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v53
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v50
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v51
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v48
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v49
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v38
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v39
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v36
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v37
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v32
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v33
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v30
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v31
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v28
; SI-NEXT:    v_alignbit_b32 v8, v9, v8, 16
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v29
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_add_f32_e32 v9, 0x40c00000, v9
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v26
; SI-NEXT:    v_alignbit_b32 v9, v10, v9, 16
; SI-NEXT:    v_and_b32_e32 v10, 0xffff0000, v27
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x40c00000, v10
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v24
; SI-NEXT:    v_alignbit_b32 v10, v11, v10, 16
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v25
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v11
; SI-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v22
; SI-NEXT:    v_alignbit_b32 v11, v12, v11, 16
; SI-NEXT:    v_and_b32_e32 v12, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_add_f32_e32 v12, 0x40c00000, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v12, v13, v12, 16
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x40c00000, v13
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v13, v14, v13, 16
; SI-NEXT:    v_and_b32_e32 v14, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_add_f32_e32 v14, 0x40c00000, v14
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_alignbit_b32 v14, v15, v14, 16
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v16
; SI-NEXT:    v_and_b32_e32 v16, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v16, 0x40c00000, v16
; SI-NEXT:    v_add_f32_e32 v15, 0x40c00000, v15
; SI-NEXT:    v_lshrrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_alignbit_b32 v15, v16, v15, 16
; SI-NEXT:  .LBB47_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB47_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; SI-NEXT:    s_branch .LBB47_2
;
; VI-LABEL: bitcast_v32bf16_to_v16f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    v_writelane_b32 v19, s30, 0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    v_writelane_b32 v19, s31, 1
; VI-NEXT:    v_readfirstlane_b32 s30, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s31, v1
; VI-NEXT:    s_cbranch_scc0 .LBB47_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB47_4
; VI-NEXT:  .LBB47_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s31, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s31, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    s_lshl_b32 s4, s30, 16
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_add_f32_e32 v3, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    s_and_b32 s4, s30, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_add_f32_e32 v4, s4, v0
; VI-NEXT:    v_bfe_u32 v5, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v4
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_alignbit_b32 v15, v2, v1, 16
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    s_lshl_b32 s4, s29, 16
; VI-NEXT:    v_alignbit_b32 v14, v1, v3, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s29, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s28, 16
; VI-NEXT:    v_alignbit_b32 v13, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s28, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s27, 16
; VI-NEXT:    v_alignbit_b32 v12, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT