; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -fast-isel=0 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ISEL
; RUN: llc -mtriple=aarch64-linux-gnu -fast-isel=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,FAST

define i32 @test1(i32 %x) {
; CHECK-LABEL: test1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #7
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    asr w0, w8, #3
; CHECK-NEXT:    ret
  %div = sdiv i32 %x, 8
  ret i32 %div
}

define i32 @test2(i32 %x) {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #7
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    neg w0, w8, asr #3
; CHECK-NEXT:    ret
  %div = sdiv i32 %x, -8
  ret i32 %div
}

define i32 @test3(i32 %x) {
; CHECK-LABEL: test3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #31
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    asr w0, w8, #5
; CHECK-NEXT:    ret
  %div = sdiv i32 %x, 32
  ret i32 %div
}

define i64 @test4(i64 %x) {
; CHECK-LABEL: test4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #7
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    asr x0, x8, #3
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, 8
  ret i64 %div
}

define i64 @test5(i64 %x) {
; CHECK-LABEL: test5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #7
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    neg x0, x8, asr #3
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, -8
  ret i64 %div
}

define i64 @test6(i64 %x) {
; CHECK-LABEL: test6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #63
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    asr x0, x8, #6
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, 64
  ret i64 %div
}

define i64 @test7(i64 %x) {
; CHECK-LABEL: test7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #281474976710655 // =0xffffffffffff
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    add x8, x0, x8
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    asr x0, x8, #48
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, 281474976710656
  ret i64 %div
}

define i64 @test8(i64 %x) {
; ISEL-LABEL: test8:
; ISEL:       // %bb.0:
; ISEL-NEXT:    add x8, x0, x0, lsr #63
; ISEL-NEXT:    asr x0, x8, #1
; ISEL-NEXT:    ret
;
; FAST-LABEL: test8:
; FAST:       // %bb.0:
; FAST-NEXT:    add x8, x0, #1
; FAST-NEXT:    cmp x0, #0
; FAST-NEXT:    csel x8, x8, x0, lt
; FAST-NEXT:    asr x0, x8, #1
; FAST-NEXT:    ret
  %div = sdiv i64 %x, 2
  ret i64 %div
}

define i32 @sdiv_int(i32 %begin, i32 %first) #0 {
; ISEL-LABEL: sdiv_int:
; ISEL:       // %bb.0:
; ISEL-NEXT:    sub w8, w0, w1
; ISEL-NEXT:    add w8, w8, #1
; ISEL-NEXT:    add w8, w8, w8, lsr #31
; ISEL-NEXT:    sub w0, w0, w8, asr #1
; ISEL-NEXT:    ret
;
; FAST-LABEL: sdiv_int:
; FAST:       // %bb.0:
; FAST-NEXT:    add w8, w0, #1
; FAST-NEXT:    sub w8, w8, w1
; FAST-NEXT:    add w9, w8, #1
; FAST-NEXT:    cmp w8, #0
; FAST-NEXT:    csel w8, w9, w8, lt
; FAST-NEXT:    neg w8, w8, asr #1
; FAST-NEXT:    add w0, w8, w0
; FAST-NEXT:    ret
  %sub = add i32 %begin, 1
  %add = sub i32 %sub, %first
  %div.neg = sdiv i32 %add, -2
  %sub1 = add i32 %div.neg, %begin
  ret i32 %sub1
}

attributes #0 = { "target-features"="+sve" vscale_range(2,2) }
