; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

; i32 saturate

define <2 x i32> @stest_f64i32(<2 x double> %x) {
; CHECK-LABEL: stest_f64i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    sqxtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 2147483647, i64 2147483647>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>
  %1 = icmp sgt <2 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32(<2 x double> %x) {
; CHECK-LABEL: utest_f64i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    fcvtzu w8, d0
; CHECK-NEXT:    fcvtzu w9, d1
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov v0.s[1], w9
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %0 = icmp ult <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    sqxtun v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %1 = icmp sgt <2 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> zeroinitializer
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32(<4 x float> %x) {
; CHECK-LABEL: stest_f32i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32(<4 x float> %x) {
; CHECK-LABEL: utest_f32i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32(<4 x half> %x) {
; CHECK-LABEL: stest_f16i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32(<4 x half> %x) {
; CHECK-LABEL: utesth_f16i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32(<4 x half> %x) {
; CHECK-LABEL: ustest_f16i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16(<2 x double> %x) {
; CHECK-LABEL: stest_f64i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    movi v1.2s, #127, msl #8
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    smin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    mvni v1.2s, #127, msl #8
; CHECK-NEXT:    smax v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 32767, i32 32767>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>
  %1 = icmp sgt <2 x i32> %spec.store.select, <i32 -32768, i32 -32768>
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16(<2 x double> %x) {
; CHECK-LABEL: utest_f64i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    umin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %0 = icmp ult <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-NEXT:    movi v2.2d, #0000000000000000
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    smin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    smax v0.2s, v0.2s, v2.2s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %1 = icmp sgt <2 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> zeroinitializer
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16(<4 x float> %x) {
; CHECK-LABEL: stest_f32i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    sqxtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <4 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16(<4 x float> %x) {
; CHECK-LABEL: utest_f32i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    uqxtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %0 = icmp ult <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    sqxtun v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <4 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> zeroinitializer
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16(<8 x half> %x) {
; CHECK-CVT-LABEL: stest_f16i16:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzs v2.4s, v0.4s
; CHECK-CVT-NEXT:    sqxtn v0.4h, v1.4s
; CHECK-CVT-NEXT:    sqxtn2 v0.8h, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: stest_f16i16:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzs v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <8 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16(<8 x half> %x) {
; CHECK-CVT-LABEL: utesth_f16i16:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzu v2.4s, v0.4s
; CHECK-CVT-NEXT:    uqxtn v0.4h, v1.4s
; CHECK-CVT-NEXT:    uqxtn2 v0.8h, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: utesth_f16i16:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %0 = icmp ult <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16(<8 x half> %x) {
; CHECK-CVT-LABEL: ustest_f16i16:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzs v2.4s, v0.4s
; CHECK-CVT-NEXT:    sqxtun v0.4h, v1.4s
; CHECK-CVT-NEXT:    sqxtun2 v0.8h, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: ustest_f16i16:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <8 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> zeroinitializer
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64(<2 x double> %x) {
; CHECK-LABEL: stest_f64i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64(<2 x double> %x) {
; CHECK-LABEL: utest_f64i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    bl __fixunsdfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl __fixunsdfti
; CHECK-NEXT:    cmp x1, #0
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, eq
; CHECK-NEXT:    cmp x20, #0
; CHECK-NEXT:    csel x9, x19, xzr, eq
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fmov d1, x9
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    cmp x1, #1
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, lt
; CHECK-NEXT:    csinc x9, x1, xzr, lt
; CHECK-NEXT:    cmp x20, #1
; CHECK-NEXT:    csel x10, x19, xzr, lt
; CHECK-NEXT:    csinc x11, x20, xzr, lt
; CHECK-NEXT:    cmp xzr, x10
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    ngcs xzr, x11
; CHECK-NEXT:    csel x10, x10, xzr, lt
; CHECK-NEXT:    cmp xzr, x8
; CHECK-NEXT:    ngcs xzr, x9
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    csel x8, x8, xzr, lt
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64(<2 x float> %x) {
; CHECK-LABEL: stest_f32i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64(<2 x float> %x) {
; CHECK-LABEL: utest_f32i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    bl __fixunssfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl __fixunssfti
; CHECK-NEXT:    cmp x1, #0
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, eq
; CHECK-NEXT:    cmp x20, #0
; CHECK-NEXT:    csel x9, x19, xzr, eq
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fmov d1, x9
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64(<2 x float> %x) {
; CHECK-LABEL: ustest_f32i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    cmp x1, #1
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csinc x8, x1, xzr, lt
; CHECK-NEXT:    csel x9, x0, xzr, lt
; CHECK-NEXT:    cmp x20, #1
; CHECK-NEXT:    csel x10, x19, xzr, lt
; CHECK-NEXT:    csinc x11, x20, xzr, lt
; CHECK-NEXT:    cmp xzr, x10
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    ngcs xzr, x11
; CHECK-NEXT:    csel x10, x10, xzr, lt
; CHECK-NEXT:    cmp xzr, x9
; CHECK-NEXT:    ngcs xzr, x8
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    csel x8, x9, xzr, lt
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64(<2 x half> %x) {
; CHECK-CVT-LABEL: stest_f16i64:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvtzs x8, s0
; CHECK-CVT-NEXT:    fcvtzs x9, s1
; CHECK-CVT-NEXT:    fmov d0, x8
; CHECK-CVT-NEXT:    mov v0.d[1], x9
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: stest_f16i64:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-FP16-NEXT:    fcvtzs x8, h0
; CHECK-FP16-NEXT:    fcvtzs x9, h1
; CHECK-FP16-NEXT:    fmov d0, x8
; CHECK-FP16-NEXT:    mov v0.d[1], x9
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64(<2 x half> %x) {
; CHECK-LABEL: utesth_f16i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov h0, v0.h[1]
; CHECK-NEXT:    bl __fixunshfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-NEXT:    bl __fixunshfti
; CHECK-NEXT:    cmp x1, #0
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, eq
; CHECK-NEXT:    cmp x20, #0
; CHECK-NEXT:    csel x9, x19, xzr, eq
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fmov d1, x9
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64(<2 x half> %x) {
; CHECK-LABEL: ustest_f16i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-NEXT:    bl __fixhfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    mov h0, v0.h[1]
; CHECK-NEXT:    bl __fixhfti
; CHECK-NEXT:    cmp x1, #1
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csinc x8, x1, xzr, lt
; CHECK-NEXT:    csel x9, x0, xzr, lt
; CHECK-NEXT:    cmp x20, #1
; CHECK-NEXT:    csel x10, x19, xzr, lt
; CHECK-NEXT:    csinc x11, x20, xzr, lt
; CHECK-NEXT:    cmp xzr, x10
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    ngcs xzr, x11
; CHECK-NEXT:    csel x10, x10, xzr, lt
; CHECK-NEXT:    cmp xzr, x9
; CHECK-NEXT:    ngcs xzr, x8
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    csel x8, x9, xzr, lt
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}



; i32 saturate

define <2 x i32> @stest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    sqxtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    fcvtzu w8, d0
; CHECK-NEXT:    fcvtzu w9, d1
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov v0.s[1], w9
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.umin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    sqxtun v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> zeroinitializer)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: stest_f32i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: utest_f32i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: stest_f16i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: utesth_f16i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: ustest_f16i32_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i16_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    movi v1.2s, #127, msl #8
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    smin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    mvni v1.2s, #127, msl #8
; CHECK-NEXT:    smax v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i16_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    umin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.umin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i16_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-NEXT:    movi v2.2d, #0000000000000000
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    smin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    smax v0.2s, v0.2s, v2.2s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> zeroinitializer)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: stest_f32i16_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    sqxtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: utest_f32i16_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    uqxtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.umin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i16_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    sqxtun v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> zeroinitializer)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16_mm(<8 x half> %x) {
; CHECK-CVT-LABEL: stest_f16i16_mm:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzs v2.4s, v0.4s
; CHECK-CVT-NEXT:    sqxtn v0.4h, v1.4s
; CHECK-CVT-NEXT:    sqxtn2 v0.8h, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: stest_f16i16_mm:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzs v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16_mm(<8 x half> %x) {
; CHECK-CVT-LABEL: utesth_f16i16_mm:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzu v2.4s, v0.4s
; CHECK-CVT-NEXT:    uqxtn v0.4h, v1.4s
; CHECK-CVT-NEXT:    uqxtn2 v0.8h, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: utesth_f16i16_mm:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.umin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16_mm(<8 x half> %x) {
; CHECK-CVT-LABEL: ustest_f16i16_mm:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzs v2.4s, v0.4s
; CHECK-CVT-NEXT:    sqxtun v0.4h, v1.4s
; CHECK-CVT-NEXT:    sqxtun2 v0.8h, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: ustest_f16i16_mm:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> zeroinitializer)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    bl __fixunsdfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl __fixunsdfti
; CHECK-NEXT:    cmp x1, #0
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, eq
; CHECK-NEXT:    cmp x20, #0
; CHECK-NEXT:    csel x9, x19, xzr, eq
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fmov d1, x9
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    cmp x1, #1
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, lt
; CHECK-NEXT:    csinc x9, x1, xzr, lt
; CHECK-NEXT:    cmp x20, #1
; CHECK-NEXT:    csinc x10, x20, xzr, lt
; CHECK-NEXT:    csel x11, x19, xzr, lt
; CHECK-NEXT:    cmp x10, #0
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    csel x10, xzr, x11, lt
; CHECK-NEXT:    cmp x9, #0
; CHECK-NEXT:    csel x8, xzr, x8, lt
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: stest_f32i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: utest_f32i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    bl __fixunssfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl __fixunssfti
; CHECK-NEXT:    cmp x1, #0
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, eq
; CHECK-NEXT:    cmp x20, #0
; CHECK-NEXT:    csel x9, x19, xzr, eq
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fmov d1, x9
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: ustest_f32i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    cmp x1, #1
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, lt
; CHECK-NEXT:    csinc x9, x1, xzr, lt
; CHECK-NEXT:    cmp x20, #1
; CHECK-NEXT:    csinc x10, x20, xzr, lt
; CHECK-NEXT:    csel x11, x19, xzr, lt
; CHECK-NEXT:    cmp x10, #0
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    csel x10, xzr, x11, lt
; CHECK-NEXT:    cmp x9, #0
; CHECK-NEXT:    csel x8, xzr, x8, lt
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64_mm(<2 x half> %x) {
; CHECK-CVT-LABEL: stest_f16i64_mm:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvtzs x8, s0
; CHECK-CVT-NEXT:    fcvtzs x9, s1
; CHECK-CVT-NEXT:    fmov d0, x8
; CHECK-CVT-NEXT:    mov v0.d[1], x9
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: stest_f16i64_mm:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-FP16-NEXT:    fcvtzs x8, h0
; CHECK-FP16-NEXT:    fcvtzs x9, h1
; CHECK-FP16-NEXT:    fmov d0, x8
; CHECK-FP16-NEXT:    mov v0.d[1], x9
; CHECK-FP16-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: utesth_f16i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov h0, v0.h[1]
; CHECK-NEXT:    bl __fixunshfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-NEXT:    bl __fixunshfti
; CHECK-NEXT:    cmp x1, #0
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, eq
; CHECK-NEXT:    cmp x20, #0
; CHECK-NEXT:    csel x9, x19, xzr, eq
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fmov d1, x9
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: ustest_f16i64_mm:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-NEXT:    bl __fixhfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x20, x1
; CHECK-NEXT:    mov h0, v0.h[1]
; CHECK-NEXT:    bl __fixhfti
; CHECK-NEXT:    cmp x1, #1
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x8, x0, xzr, lt
; CHECK-NEXT:    csinc x9, x1, xzr, lt
; CHECK-NEXT:    cmp x20, #1
; CHECK-NEXT:    csinc x10, x20, xzr, lt
; CHECK-NEXT:    csel x11, x19, xzr, lt
; CHECK-NEXT:    cmp x10, #0
; CHECK-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    csel x10, xzr, x11, lt
; CHECK-NEXT:    cmp x9, #0
; CHECK-NEXT:    csel x8, xzr, x8, lt
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

declare <2 x i32> @llvm.smin.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.smax.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.umin.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
declare <2 x i128> @llvm.smin.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.smax.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.umin.v2i128(<2 x i128>, <2 x i128>)
