; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=aarch64-- -verify-machineinstrs -global-isel -stop-after=irtranslator -o - %s | FileCheck %s

define float @test_minnum(float %x, float %y) {
  ; CHECK-LABEL: name: test_minnum
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $s0, $s1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK:   [[FMINNUM:%[0-9]+]]:_(s32) = G_FMINNUM [[COPY]], [[COPY1]]
  ; CHECK:   $s0 = COPY [[FMINNUM]](s32)
  ; CHECK:   RET_ReallyLR implicit $s0
  %val = call float @llvm.minnum.f32(float %x, float %y)
  ret float %val
}

define float @test_minnum_nnan(float %x, float %y) {
  ; CHECK-LABEL: name: test_minnum_nnan
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $s0, $s1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK:   %2:_(s32) = nnan G_FMINNUM [[COPY]], [[COPY1]]
  ; CHECK:   $s0 = COPY %2(s32)
  ; CHECK:   RET_ReallyLR implicit $s0
  %val = call nnan float @llvm.minnum.f32(float %x, float %y)
  ret float %val
}

define float @test_maxnum(float %x, float %y) {
  ; CHECK-LABEL: name: test_maxnum
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $s0, $s1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK:   [[FMAXNUM:%[0-9]+]]:_(s32) = G_FMAXNUM [[COPY]], [[COPY1]]
  ; CHECK:   $s0 = COPY [[FMAXNUM]](s32)
  ; CHECK:   RET_ReallyLR implicit $s0
  %val = call float @llvm.maxnum.f32(float %x, float %y)
  ret float %val
}

define float @test_minimum(float %x, float %y) {
  ; CHECK-LABEL: name: test_minimum
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $s0, $s1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK:   [[FMINIMUM:%[0-9]+]]:_(s32) = G_FMINIMUM [[COPY]], [[COPY1]]
  ; CHECK:   $s0 = COPY [[FMINIMUM]](s32)
  ; CHECK:   RET_ReallyLR implicit $s0
  %val = call float @llvm.minimum.f32(float %x, float %y)
  ret float %val
}

define float @test_minimum_nnan(float %x, float %y) {
  ; CHECK-LABEL: name: test_minimum_nnan
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $s0, $s1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK:   %2:_(s32) = nnan G_FMINIMUM [[COPY]], [[COPY1]]
  ; CHECK:   $s0 = COPY %2(s32)
  ; CHECK:   RET_ReallyLR implicit $s0
  %val = call nnan float @llvm.minimum.f32(float %x, float %y)
  ret float %val
}

define float @test_maximum(float %x, float %y) {
  ; CHECK-LABEL: name: test_maximum
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $s0, $s1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK:   [[FMAXIMUM:%[0-9]+]]:_(s32) = G_FMAXIMUM [[COPY]], [[COPY1]]
  ; CHECK:   $s0 = COPY [[FMAXIMUM]](s32)
  ; CHECK:   RET_ReallyLR implicit $s0
  %val = call float @llvm.maximum.f32(float %x, float %y)
  ret float %val
}

define float @test_minimumnum(float %x, float %y) {
  ; CHECK-LABEL: name: test_minimumnum
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $s0, $s1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK-NEXT:   [[FMINIMUMNUM:%[0-9]+]]:_(s32) = G_FMINIMUMNUM [[COPY]], [[COPY1]]
  ; CHECK-NEXT:   $s0 = COPY [[FMINIMUMNUM]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $s0
  %val = call float @llvm.minimumnum.f32(float %x, float %y)
  ret float %val
}

define float @test_minimumnum_nnan(float %x, float %y) {
  ; CHECK-LABEL: name: test_minimumnum_nnan
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $s0, $s1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK-NEXT:   [[FMINIMUMNUM:%[0-9]+]]:_(s32) = nnan G_FMINIMUMNUM [[COPY]], [[COPY1]]
  ; CHECK-NEXT:   $s0 = COPY [[FMINIMUMNUM]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $s0
  %val = call nnan float @llvm.minimumnum.f32(float %x, float %y)
  ret float %val
}

define float @test_maximumnum(float %x, float %y) {
  ; CHECK-LABEL: name: test_maximumnum
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $s0, $s1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK-NEXT:   [[FMAXIMUMNUM:%[0-9]+]]:_(s32) = G_FMAXIMUMNUM [[COPY]], [[COPY1]]
  ; CHECK-NEXT:   $s0 = COPY [[FMAXIMUMNUM]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $s0
  %val = call float @llvm.maximumnum.f32(float %x, float %y)
  ret float %val
}

define float @test_maximumnum_nnan(float %x, float %y) {
  ; CHECK-LABEL: name: test_maximumnum_nnan
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $s0, $s1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $s0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $s1
  ; CHECK-NEXT:   [[FMAXIMUMNUM:%[0-9]+]]:_(s32) = nnan G_FMAXIMUMNUM [[COPY]], [[COPY1]]
  ; CHECK-NEXT:   $s0 = COPY [[FMAXIMUMNUM]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $s0
  %val = call nnan float @llvm.maximumnum.f32(float %x, float %y)
  ret float %val
}

declare float @llvm.minnum.f32(float, float) #0
declare float @llvm.maxnum.f32(float, float) #0

declare float @llvm.minimum.f32(float, float) #0
declare float @llvm.maximum.f32(float, float) #0

attributes #0 = { nounwind readnone speculatable }
