; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes='print<scalar-evolution>' -scalar-evolution-classify-expressions=0 -disable-output %s 2>&1 | FileCheck %s

declare void @foo()

define void @test_trip_count_expr_contains_urem(i32 %N) {
; CHECK-LABEL: 'test_trip_count_expr_contains_urem'
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_count_expr_contains_urem
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((1 + (-1 * (zext i4 (1 + (trunc i32 %N to i4)) to i32))<nsw> + %N) /u 16)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 268435455
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((1 + (-1 * (zext i4 (1 + (trunc i32 %N to i4)) to i32))<nsw> + %N) /u 16)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %n.rnd.up = add i32 %N, 1
  %n.mod.vf = urem i32 %n.rnd.up, 16
  %n.vec = sub i32 %n.rnd.up, %n.mod.vf
  br label %loop

loop:
  %index = phi i32 [ 0, %entry ], [ %index.next, %loop ]
  %index.next = add i32 %index, 16
  call void @foo()
  %ec = icmp eq i32 %index, %n.vec
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
