; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 < %s 2>&1 | FileCheck %s

define void @test0(i32 %init) {
;
; CHECK-LABEL: 'test0'
; CHECK-NEXT:  Determining loop execution counts for: @test0
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 32
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 32
;
 entry:
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = lshr i32 %iv, 1
  %exit.cond = icmp eq i32 %iv, 0
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test1(i32 %init) {
;
; CHECK-LABEL: 'test1'
; CHECK-NEXT:  Determining loop execution counts for: @test1
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 32
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 32
;
 entry:
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = shl i32 %iv, 1
  %exit.cond = icmp eq i32 %iv, 0
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test2(i32 %init) {
;
; Unpredictable because %iv could "stabilize" to either -1 or 0,
; depending on %init.
; CHECK-LABEL: 'test2'
; CHECK-NEXT:  Determining loop execution counts for: @test2
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = ashr i32 %iv, 1
  %exit.cond = icmp eq i32 %iv, 0
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test3(ptr %init.ptr) {
;
; CHECK-LABEL: 'test3'
; CHECK-NEXT:  Determining loop execution counts for: @test3
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 32
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 32
;
 entry:
  %init = load i32, ptr %init.ptr, !range !0
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = ashr i32 %iv, 1
  %exit.cond = icmp eq i32 %iv, 0
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test4(ptr %init.ptr) {
;
; CHECK-LABEL: 'test4'
; CHECK-NEXT:  Determining loop execution counts for: @test4
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 32
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 32
;
 entry:
  %init = load i32, ptr %init.ptr, !range !1
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = ashr i32 %iv, 1
  %exit.cond = icmp eq i32 %iv, -1
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test5(ptr %init.ptr) {
;
; %iv will "stabilize" to -1, so this is an infinite loop
; CHECK-LABEL: 'test5'
; CHECK-NEXT:  Determining loop execution counts for: @test5
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  %init = load i32, ptr %init.ptr, !range !1
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = ashr i32 %iv, 1
  %exit.cond = icmp eq i32 %iv, 0
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test6(i32 %init, i32 %shift.amt) {
;
; Potentially infinite loop, since %shift.amt could be 0
; CHECK-LABEL: 'test6'
; CHECK-NEXT:  Determining loop execution counts for: @test6
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = lshr i32 %iv, %shift.amt
  %exit.cond = icmp eq i32 %iv, 0
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test7(i32 %init) {
;
; CHECK-LABEL: 'test7'
; CHECK-NEXT:  Determining loop execution counts for: @test7
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 32
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 32
;
 entry:
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = lshr i32 %iv, 1
  %exit.cond = icmp eq i32 %iv.shift, 0
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test8(i32 %init) {
;
; In this test case, %iv.test stabilizes to 127, not -1, so the loop
; is infinite.
; CHECK-LABEL: 'test8'
; CHECK-NEXT:  Determining loop execution counts for: @test8
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  br label %loop

 loop:
  %iv = phi i32 [ %init, %entry ], [ %iv.shift, %loop ]
  %iv.shift = ashr i32 %iv, 1
  %iv.test = lshr i32 %iv, 1
  %exit.cond = icmp eq i32 %iv.test, -1
  br i1 %exit.cond, label %leave, label %loop

 leave:
  ret void
}

define void @test9() {
;
; This is an infinite loop, make sure that it recognized as such.
; CHECK-LABEL: 'test9'
; CHECK-NEXT:  Determining loop execution counts for: @test9
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

leave:
  ret void

loop:
  %iv = phi i32 [ -20, %entry ], [ %iv.shift, %loop ]
  %iv.shift = ashr i32 %iv, 1
  %exit.cond = icmp sgt i32 %iv, -1
  br i1 %exit.cond, label %leave, label %loop
}

!0 = !{i32 0, i32 50000}
!1 = !{i32 -5000, i32 -1}
