; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck %s

define void @dependency_check_and_runtime_checks_needed_gepb_is_inbounds_iv2_step5(ptr %a, ptr %b, i64 %offset, i64 %n) {
; CHECK-LABEL: 'dependency_check_and_runtime_checks_needed_gepb_is_inbounds_iv2_step5'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr inbounds float, ptr %b, i64 %iv2
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr inbounds float, ptr %b, i64 %iv2
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %a High: ((4 * %n) + %a))
; CHECK-NEXT:            Member: {%a,+,4}<nuw><%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %b High: (-16 + (20 * %n) + %b))
; CHECK-NEXT:            Member: {%b,+,20}<%loop>
; CHECK-NEXT:        Group GRP2:
; CHECK-NEXT:          (Low: ((4 * %offset) + %a) High: ((4 * %offset) + (4 * %n) + %a))
; CHECK-NEXT:            Member: {((4 * %offset) + %a),+,4}<%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2.next, %loop ]
  %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
  %l1 = load float, ptr %gep.a.iv, align 4
  %iv.offset = add i64 %iv, %offset
  %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
  %l2 = load float, ptr %gep.a.iv.off, align 4
  %ad = fadd fast float %l1, %l2
  store float %ad, ptr %gep.a.iv, align 4
  %gep.b = getelementptr inbounds float, ptr %b, i64 %iv2
  store float 0.0, ptr %gep.b
  %iv.next = add nuw nsw i64 %iv, 1
  %iv2.next = add i64 %iv2, 5
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}

define void @dependency_check_and_runtime_checks_needed_gepb_not_inbounds_iv2_step5(ptr %a, ptr %b, i64 %offset, i64 %n) {
; CHECK-LABEL: 'dependency_check_and_runtime_checks_needed_gepb_not_inbounds_iv2_step5'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr i8, ptr %b, i64 %iv2
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr i8, ptr %b, i64 %iv2
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %a High: ((4 * %n) + %a))
; CHECK-NEXT:            Member: {%a,+,4}<nuw><%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %b High: (-1 + (5 * %n) + %b))
; CHECK-NEXT:            Member: {%b,+,5}<%loop>
; CHECK-NEXT:        Group GRP2:
; CHECK-NEXT:          (Low: ((4 * %offset) + %a) High: ((4 * %offset) + (4 * %n) + %a))
; CHECK-NEXT:            Member: {((4 * %offset) + %a),+,4}<%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-NEXT:      {%b,+,5}<%loop> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2.next, %loop ]
  %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
  %l1 = load float, ptr %gep.a.iv, align 4
  %iv.offset = add i64 %iv, %offset
  %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
  %l2 = load float, ptr %gep.a.iv.off, align 4
  %ad = fadd fast float %l1, %l2
  store float %ad, ptr %gep.a.iv, align 4
  %gep.b = getelementptr i8, ptr %b, i64 %iv2
  store float 0.0, ptr %gep.b
  %iv.next = add nuw nsw i64 %iv, 1
  %iv2.next = add i64 %iv2, 5
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}

define void @dependency_check_and_runtime_checks_needed_gepb_is_inbounds_iv2_step_not_constant(ptr %a, ptr %b, i64 %offset, i64 %n, i64 %s) {
; CHECK-LABEL: 'dependency_check_and_runtime_checks_needed_gepb_is_inbounds_iv2_step_not_constant'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %a High: ((4 * %n) + %a))
; CHECK-NEXT:            Member: {%a,+,4}<nuw><%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %b High: (3 + %n + %b))
; CHECK-NEXT:            Member: {%b,+,1}<%loop>
; CHECK-NEXT:        Group GRP2:
; CHECK-NEXT:          (Low: ((4 * %offset) + %a) High: ((4 * %offset) + (4 * %n) + %a))
; CHECK-NEXT:            Member: {((4 * %offset) + %a),+,4}<%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-NEXT:      Equal predicate: %s == 1
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
; CHECK-NEXT:      [PSE] %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2:
; CHECK-NEXT:        {%b,+,%s}<%loop>
; CHECK-NEXT:        --> {%b,+,1}<%loop>
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2.next, %loop ]
  %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
  %l1 = load float, ptr %gep.a.iv, align 4
  %iv.offset = add i64 %iv, %offset
  %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
  %l2 = load float, ptr %gep.a.iv.off, align 4
  %ad = fadd fast float %l1, %l2
  store float %ad, ptr %gep.a.iv, align 4
  %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2
  store float 0.0, ptr %gep.b
  %iv.next = add nuw nsw i64 %iv, 1
  %iv2.next = add i64 %iv2, %s
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}


define void @dependency_check_and_runtime_checks_needed_gepb_not_inbounds_iv2_step_not_constant(ptr %a, ptr %b, i64 %offset, i64 %n, i64 %s) {
; CHECK-LABEL: 'dependency_check_and_runtime_checks_needed_gepb_not_inbounds_iv2_step_not_constant'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %a High: ((4 * %n) + %a))
; CHECK-NEXT:            Member: {%a,+,4}<nuw><%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %b High: (3 + %n + %b))
; CHECK-NEXT:            Member: {%b,+,1}<%loop>
; CHECK-NEXT:        Group GRP2:
; CHECK-NEXT:          (Low: ((4 * %offset) + %a) High: ((4 * %offset) + (4 * %n) + %a))
; CHECK-NEXT:            Member: {((4 * %offset) + %a),+,4}<%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-NEXT:      Equal predicate: %s == 1
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
; CHECK-NEXT:      [PSE] %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2:
; CHECK-NEXT:        {%b,+,%s}<%loop>
; CHECK-NEXT:        --> {%b,+,1}<%loop>
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2.next, %loop ]
  %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
  %l1 = load float, ptr %gep.a.iv, align 4
  %iv.offset = add i64 %iv, %offset
  %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
  %l2 = load float, ptr %gep.a.iv.off, align 4
  %ad = fadd fast float %l1, %l2
  store float %ad, ptr %gep.a.iv, align 4
  %gep.b = getelementptr inbounds i8, ptr %b, i64 %iv2
  store float 0.0, ptr %gep.b
  %iv.next = add nuw nsw i64 %iv, 1
  %iv2.next = add i64 %iv2, %s
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}

define void @dependency_check_and_runtime_checks_needed_gepb_may_wrap(ptr %a, ptr %b, i64 %offset, i64 %n) {
; CHECK-LABEL: 'dependency_check_and_runtime_checks_needed_gepb_may_wrap'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr float, ptr %b, i64 %iv2
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group GRP1:
; CHECK-NEXT:          %gep.b = getelementptr float, ptr %b, i64 %iv2
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %a High: ((4 * %n) + %a))
; CHECK-NEXT:            Member: {%a,+,4}<nuw><%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %b High: (-4 + (8 * %n) + %b))
; CHECK-NEXT:            Member: {%b,+,8}<%loop>
; CHECK-NEXT:        Group GRP2:
; CHECK-NEXT:          (Low: ((4 * %offset) + %a) High: ((4 * %offset) + (4 * %n) + %a))
; CHECK-NEXT:            Member: {((4 * %offset) + %a),+,4}<%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-NEXT:      {%b,+,8}<%loop> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2.next, %loop ]
  %gep.a.iv = getelementptr inbounds float, ptr %a, i64 %iv
  %l1 = load float, ptr %gep.a.iv, align 4
  %iv.offset = add i64 %iv, %offset
  %gep.a.iv.off = getelementptr inbounds float, ptr %a, i64 %iv.offset
  %l2 = load float, ptr %gep.a.iv.off, align 4
  %ad = fadd fast float %l1, %l2
  store float %ad, ptr %gep.a.iv, align 4
  %gep.b = getelementptr float, ptr %b, i64 %iv2
  store float 0.0, ptr %gep.b
  %iv.next = add nuw nsw i64 %iv, 1
  %iv2.next = add i64 %iv2, 2
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}

define void @retry_after_dep_check_with_unknown_offset(ptr %A, i32 %offset) {
; CHECK-LABEL: 'retry_after_dep_check_with_unknown_offset'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %A.100.iv = getelementptr { float, float }, ptr %A.100, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %A.100.iv.offset.3 = getelementptr i8, ptr %A.100, i64 %iv.offset.3
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %A.100.iv = getelementptr { float, float }, ptr %A.100, i64 %iv
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:        ptr %A
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group GRP1:
; CHECK-NEXT:          %A.100.iv.offset.3 = getelementptr i8, ptr %A.100, i64 %iv.offset.3
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:        ptr %A
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: (100 + %A) High: (96 + (8 * (zext i32 %offset to i64))<nuw><nsw> + %A))
; CHECK-NEXT:            Member: {(100 + %A),+,8}<%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: (100 + (8 * (zext i32 %offset to i64))<nuw><nsw> + %A) High: (96 + (16 * (zext i32 %offset to i64))<nuw><nsw> + %A))
; CHECK-NEXT:            Member: {(100 + (8 * (zext i32 %offset to i64))<nuw><nsw> + %A),+,8}<%loop>
; CHECK-NEXT:        Group GRP2:
; CHECK-NEXT:          (Low: %A High: (4 + %A))
; CHECK-NEXT:            Member: %A
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-NEXT:      {(100 + %A),+,8}<%loop> Added Flags: <nusw>
; CHECK-NEXT:      {(100 + (8 * (zext i32 %offset to i64))<nuw><nsw> + %A),+,8}<%loop> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  %A.100 = getelementptr i8, ptr %A, i64 100
  %offset.ext = zext i32 %offset to i64
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %l.A = load float, ptr %A, align 4
  %A.100.iv = getelementptr { float, float }, ptr %A.100, i64 %iv
  store float %l.A, ptr %A.100.iv, align 8
  %iv.offset = add i64 %iv, %offset.ext
  %iv.offset.3 = shl i64 %iv.offset, 3
  %A.100.iv.offset.3 = getelementptr i8, ptr %A.100, i64 %iv.offset.3
  store float 0.0, ptr %A.100.iv.offset.3, align 4
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %offset.ext
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
