; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ
;
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=slm | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=goldmont | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=btver2 | FileCheck %s --check-prefixes=AVX,AVX1

define i32 @sitofp_i8_double() {
; SSE2-LABEL: 'sitofp_i8_double'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_i8_f64 = sitofp i8 undef to double
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i8_v2f64 = sitofp <2 x i8> undef to <2 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v4i8_v4f64 = sitofp <4 x i8> undef to <4 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v8i8_v8f64 = sitofp <8 x i8> undef to <8 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i8_double'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f64 = sitofp i8 undef to double
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i8_v2f64 = sitofp <2 x i8> undef to <2 x double>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_v4i8_v4f64 = sitofp <4 x i8> undef to <4 x double>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %cvt_v8i8_v8f64 = sitofp <8 x i8> undef to <8 x double>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sitofp_i8_double'
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f64 = sitofp i8 undef to double
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i8_v2f64 = sitofp <2 x i8> undef to <2 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i8_v4f64 = sitofp <4 x i8> undef to <4 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v8i8_v8f64 = sitofp <8 x i8> undef to <8 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sitofp_i8_double'
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f64 = sitofp i8 undef to double
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i8_v2f64 = sitofp <2 x i8> undef to <2 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i8_v4f64 = sitofp <4 x i8> undef to <4 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v8i8_v8f64 = sitofp <8 x i8> undef to <8 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'sitofp_i8_double'
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f64 = sitofp i8 undef to double
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i8_v2f64 = sitofp <2 x i8> undef to <2 x double>
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i8_v4f64 = sitofp <4 x i8> undef to <4 x double>
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i8_v8f64 = sitofp <8 x i8> undef to <8 x double>
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i8_f64 = sitofp i8 undef to double
  %cvt_v2i8_v2f64 = sitofp <2 x i8> undef to <2 x double>
  %cvt_v4i8_v4f64 = sitofp <4 x i8> undef to <4 x double>
  %cvt_v8i8_v8f64 = sitofp <8 x i8> undef to <8 x double>
  ret i32 undef
}

define i32 @sitofp_i16_double() {
; SSE2-LABEL: 'sitofp_i16_double'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_i16_f64 = sitofp i16 undef to double
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i16_v2f64 = sitofp <2 x i16> undef to <2 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v4i16_v4f64 = sitofp <4 x i16> undef to <4 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v8i16_v8f64 = sitofp <8 x i16> undef to <8 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i16_double'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f64 = sitofp i16 undef to double
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i16_v2f64 = sitofp <2 x i16> undef to <2 x double>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_v4i16_v4f64 = sitofp <4 x i16> undef to <4 x double>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %cvt_v8i16_v8f64 = sitofp <8 x i16> undef to <8 x double>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sitofp_i16_double'
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f64 = sitofp i16 undef to double
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i16_v2f64 = sitofp <2 x i16> undef to <2 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i16_v4f64 = sitofp <4 x i16> undef to <4 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v8i16_v8f64 = sitofp <8 x i16> undef to <8 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sitofp_i16_double'
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f64 = sitofp i16 undef to double
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i16_v2f64 = sitofp <2 x i16> undef to <2 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i16_v4f64 = sitofp <4 x i16> undef to <4 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v8i16_v8f64 = sitofp <8 x i16> undef to <8 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'sitofp_i16_double'
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f64 = sitofp i16 undef to double
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i16_v2f64 = sitofp <2 x i16> undef to <2 x double>
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i16_v4f64 = sitofp <4 x i16> undef to <4 x double>
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i16_v8f64 = sitofp <8 x i16> undef to <8 x double>
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i16_f64 = sitofp i16 undef to double
  %cvt_v2i16_v2f64 = sitofp <2 x i16> undef to <2 x double>
  %cvt_v4i16_v4f64 = sitofp <4 x i16> undef to <4 x double>
  %cvt_v8i16_v8f64 = sitofp <8 x i16> undef to <8 x double>
  ret i32 undef
}

define i32 @sitofp_i32_double() {
; SSE2-LABEL: 'sitofp_i32_double'
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_i32_f64 = sitofp i32 undef to double
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i32_v2f64 = sitofp <2 x i32> undef to <2 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v4i32_v4f64 = sitofp <4 x i32> undef to <4 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v8i32_v8f64 = sitofp <8 x i32> undef to <8 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i32_double'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f64 = sitofp i32 undef to double
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f64 = sitofp <2 x i32> undef to <2 x double>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i32_v4f64 = sitofp <4 x i32> undef to <4 x double>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %cvt_v8i32_v8f64 = sitofp <8 x i32> undef to <8 x double>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sitofp_i32_double'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f64 = sitofp i32 undef to double
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f64 = sitofp <2 x i32> undef to <2 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i32_v4f64 = sitofp <4 x i32> undef to <4 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i32_v8f64 = sitofp <8 x i32> undef to <8 x double>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sitofp_i32_double'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f64 = sitofp i32 undef to double
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f64 = sitofp <2 x i32> undef to <2 x double>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i32_v4f64 = sitofp <4 x i32> undef to <4 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i32_v8f64 = sitofp <8 x i32> undef to <8 x double>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'sitofp_i32_double'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f64 = sitofp i32 undef to double
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f64 = sitofp <2 x i32> undef to <2 x double>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i32_v4f64 = sitofp <4 x i32> undef to <4 x double>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v8i32_v8f64 = sitofp <8 x i32> undef to <8 x double>
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i32_f64 = sitofp i32 undef to double
  %cvt_v2i32_v2f64 = sitofp <2 x i32> undef to <2 x double>
  %cvt_v4i32_v4f64 = sitofp <4 x i32> undef to <4 x double>
  %cvt_v8i32_v8f64 = sitofp <8 x i32> undef to <8 x double>
  ret i32 undef
}

define i32 @sitofp_i64_double() {
; SSE2-LABEL: 'sitofp_i64_double'
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_i64_f64 = sitofp i64 undef to double
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f64 = sitofp <2 x i64> undef to <2 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v4i64_v4f64 = sitofp <4 x i64> undef to <4 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v8i64_v8f64 = sitofp <8 x i64> undef to <8 x double>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i64_double'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f64 = sitofp i64 undef to double
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f64 = sitofp <2 x i64> undef to <2 x double>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v4i64_v4f64 = sitofp <4 x i64> undef to <4 x double>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v8i64_v8f64 = sitofp <8 x i64> undef to <8 x double>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'sitofp_i64_double'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f64 = sitofp i64 undef to double
; AVX-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f64 = sitofp <2 x i64> undef to <2 x double>
; AVX-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i64_v4f64 = sitofp <4 x i64> undef to <4 x double>
; AVX-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i64_v8f64 = sitofp <8 x i64> undef to <8 x double>
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'sitofp_i64_double'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f64 = sitofp i64 undef to double
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f64 = sitofp <2 x i64> undef to <2 x double>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i64_v4f64 = sitofp <4 x i64> undef to <4 x double>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i64_v8f64 = sitofp <8 x i64> undef to <8 x double>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'sitofp_i64_double'
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f64 = sitofp i64 undef to double
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i64_v2f64 = sitofp <2 x i64> undef to <2 x double>
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i64_v4f64 = sitofp <4 x i64> undef to <4 x double>
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_v8i64_v8f64 = sitofp <8 x i64> undef to <8 x double>
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i64_f64 = sitofp i64 undef to double
  %cvt_v2i64_v2f64 = sitofp <2 x i64> undef to <2 x double>
  %cvt_v4i64_v4f64 = sitofp <4 x i64> undef to <4 x double>
  %cvt_v8i64_v8f64 = sitofp <8 x i64> undef to <8 x double>
  ret i32 undef
}

define i32 @sitofp_i8_float() {
; SSE2-LABEL: 'sitofp_i8_float'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_i8_f32 = sitofp i8 undef to float
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i8_v2f32 = sitofp <2 x i8> undef to <2 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i8_v4f32 = sitofp <4 x i8> undef to <4 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v8i8_v8f32 = sitofp <8 x i8> undef to <8 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v16i8_v16f32 = sitofp <16 x i8> undef to <16 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i8_float'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f32 = sitofp i8 undef to float
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i8_v2f32 = sitofp <2 x i8> undef to <2 x float>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i8_v4f32 = sitofp <4 x i8> undef to <4 x float>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_v8i8_v8f32 = sitofp <8 x i8> undef to <8 x float>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %cvt_v16i8_v16f32 = sitofp <16 x i8> undef to <16 x float>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sitofp_i8_float'
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f32 = sitofp i8 undef to float
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i8_v2f32 = sitofp <2 x i8> undef to <2 x float>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i8_v4f32 = sitofp <4 x i8> undef to <4 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i8_v8f32 = sitofp <8 x i8> undef to <8 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v16i8_v16f32 = sitofp <16 x i8> undef to <16 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sitofp_i8_float'
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f32 = sitofp i8 undef to float
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i8_v2f32 = sitofp <2 x i8> undef to <2 x float>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i8_v4f32 = sitofp <4 x i8> undef to <4 x float>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i8_v8f32 = sitofp <8 x i8> undef to <8 x float>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v16i8_v16f32 = sitofp <16 x i8> undef to <16 x float>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'sitofp_i8_float'
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %cvt_i8_f32 = sitofp i8 undef to float
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i8_v2f32 = sitofp <2 x i8> undef to <2 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i8_v4f32 = sitofp <4 x i8> undef to <4 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v8i8_v8f32 = sitofp <8 x i8> undef to <8 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v16i8_v16f32 = sitofp <16 x i8> undef to <16 x float>
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i8_f32 = sitofp i8 undef to float
  %cvt_v2i8_v2f32 = sitofp <2 x i8> undef to <2 x float>
  %cvt_v4i8_v4f32 = sitofp <4 x i8> undef to <4 x float>
  %cvt_v8i8_v8f32 = sitofp <8 x i8> undef to <8 x float>
  %cvt_v16i8_v16f32 = sitofp <16 x i8> undef to <16 x float>
  ret i32 undef
}

define i32 @sitofp_i16_float() {
; SSE2-LABEL: 'sitofp_i16_float'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_i16_f32 = sitofp i16 undef to float
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i16_v2f32 = sitofp <2 x i16> undef to <2 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i16_v4f32 = sitofp <4 x i16> undef to <4 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v8i16_v8f32 = sitofp <8 x i16> undef to <8 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v16i16_v16f32 = sitofp <16 x i16> undef to <16 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i16_float'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f32 = sitofp i16 undef to float
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i16_v2f32 = sitofp <2 x i16> undef to <2 x float>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i16_v4f32 = sitofp <4 x i16> undef to <4 x float>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_v8i16_v8f32 = sitofp <8 x i16> undef to <8 x float>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %cvt_v16i16_v16f32 = sitofp <16 x i16> undef to <16 x float>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sitofp_i16_float'
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f32 = sitofp i16 undef to float
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i16_v2f32 = sitofp <2 x i16> undef to <2 x float>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i16_v4f32 = sitofp <4 x i16> undef to <4 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i16_v8f32 = sitofp <8 x i16> undef to <8 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:3 Lat:3 SizeLat:3 for: %cvt_v16i16_v16f32 = sitofp <16 x i16> undef to <16 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sitofp_i16_float'
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f32 = sitofp i16 undef to float
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i16_v2f32 = sitofp <2 x i16> undef to <2 x float>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i16_v4f32 = sitofp <4 x i16> undef to <4 x float>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i16_v8f32 = sitofp <8 x i16> undef to <8 x float>
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:3 SizeLat:3 for: %cvt_v16i16_v16f32 = sitofp <16 x i16> undef to <16 x float>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'sitofp_i16_float'
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %cvt_i16_f32 = sitofp i16 undef to float
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i16_v2f32 = sitofp <2 x i16> undef to <2 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i16_v4f32 = sitofp <4 x i16> undef to <4 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v8i16_v8f32 = sitofp <8 x i16> undef to <8 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v16i16_v16f32 = sitofp <16 x i16> undef to <16 x float>
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i16_f32 = sitofp i16 undef to float
  %cvt_v2i16_v2f32 = sitofp <2 x i16> undef to <2 x float>
  %cvt_v4i16_v4f32 = sitofp <4 x i16> undef to <4 x float>
  %cvt_v8i16_v8f32 = sitofp <8 x i16> undef to <8 x float>
  %cvt_v16i16_v16f32 = sitofp <16 x i16> undef to <16 x float>
  ret i32 undef
}

define i32 @sitofp_i32_float() {
; SSE2-LABEL: 'sitofp_i32_float'
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_i32_f32 = sitofp i32 undef to float
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i32_v2f32 = sitofp <2 x i32> undef to <2 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i32_v4f32 = sitofp <4 x i32> undef to <4 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v8i32_v8f32 = sitofp <8 x i32> undef to <8 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v16i32_v16f32 = sitofp <16 x i32> undef to <16 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i32_float'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f32 = sitofp i32 undef to float
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f32 = sitofp <2 x i32> undef to <2 x float>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i32_v4f32 = sitofp <4 x i32> undef to <4 x float>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %cvt_v8i32_v8f32 = sitofp <8 x i32> undef to <8 x float>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %cvt_v16i32_v16f32 = sitofp <16 x i32> undef to <16 x float>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sitofp_i32_float'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f32 = sitofp i32 undef to float
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f32 = sitofp <2 x i32> undef to <2 x float>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i32_v4f32 = sitofp <4 x i32> undef to <4 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i32_v8f32 = sitofp <8 x i32> undef to <8 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v16i32_v16f32 = sitofp <16 x i32> undef to <16 x float>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sitofp_i32_float'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f32 = sitofp i32 undef to float
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f32 = sitofp <2 x i32> undef to <2 x float>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i32_v4f32 = sitofp <4 x i32> undef to <4 x float>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %cvt_v8i32_v8f32 = sitofp <8 x i32> undef to <8 x float>
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %cvt_v16i32_v16f32 = sitofp <16 x i32> undef to <16 x float>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'sitofp_i32_float'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_i32_f32 = sitofp i32 undef to float
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i32_v2f32 = sitofp <2 x i32> undef to <2 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i32_v4f32 = sitofp <4 x i32> undef to <4 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v8i32_v8f32 = sitofp <8 x i32> undef to <8 x float>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %cvt_v16i32_v16f32 = sitofp <16 x i32> undef to <16 x float>
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i32_f32 = sitofp i32 undef to float
  %cvt_v2i32_v2f32 = sitofp <2 x i32> undef to <2 x float>
  %cvt_v4i32_v4f32 = sitofp <4 x i32> undef to <4 x float>
  %cvt_v8i32_v8f32 = sitofp <8 x i32> undef to <8 x float>
  %cvt_v16i32_v16f32 = sitofp <16 x i32> undef to <16 x float>
  ret i32 undef
}

define i32 @sitofp_i64_float() {
; SSE2-LABEL: 'sitofp_i64_float'
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_i64_f32 = sitofp i64 undef to float
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f32 = sitofp <2 x i64> undef to <2 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v4i64_v4f32 = sitofp <4 x i64> undef to <4 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v8i64_v8f32 = sitofp <8 x i64> undef to <8 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %cvt_v16i64_v16f32 = sitofp <16 x i64> undef to <16 x float>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sitofp_i64_float'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f32 = sitofp i64 undef to float
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f32 = sitofp <2 x i64> undef to <2 x float>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %cvt_v4i64_v4f32 = sitofp <4 x i64> undef to <4 x float>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %cvt_v8i64_v8f32 = sitofp <8 x i64> undef to <8 x float>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %cvt_v16i64_v16f32 = sitofp <16 x i64> undef to <16 x float>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'sitofp_i64_float'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f32 = sitofp i64 undef to float
; AVX-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f32 = sitofp <2 x i64> undef to <2 x float>
; AVX-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i64_v4f32 = sitofp <4 x i64> undef to <4 x float>
; AVX-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i64_v8f32 = sitofp <8 x i64> undef to <8 x float>
; AVX-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v16i64_v16f32 = sitofp <16 x i64> undef to <16 x float>
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'sitofp_i64_float'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f32 = sitofp i64 undef to float
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v2i64_v2f32 = sitofp <2 x i64> undef to <2 x float>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v4i64_v4f32 = sitofp <4 x i64> undef to <4 x float>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v8i64_v8f32 = sitofp <8 x i64> undef to <8 x float>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:45 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v16i64_v16f32 = sitofp <16 x i64> undef to <16 x float>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'sitofp_i64_float'
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_i64_f32 = sitofp i64 undef to float
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_v2i64_v2f32 = sitofp <2 x i64> undef to <2 x float>
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_v4i64_v4f32 = sitofp <4 x i64> undef to <4 x float>
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %cvt_v8i64_v8f32 = sitofp <8 x i64> undef to <8 x float>
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %cvt_v16i64_v16f32 = sitofp <16 x i64> undef to <16 x float>
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %cvt_i64_f32 = sitofp i64 undef to float
  %cvt_v2i64_v2f32 = sitofp <2 x i64> undef to <2 x float>
  %cvt_v4i64_v4f32 = sitofp <4 x i64> undef to <4 x float>
  %cvt_v8i64_v8f32 = sitofp <8 x i64> undef to <8 x float>
  %cvt_v16i64_v16f32 = sitofp <16 x i64> undef to <16 x float>
  ret i32 undef
}
