; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v,+f,+d,+zfh,+zvfh < %s | FileCheck %s
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mcpu=sifive-x280 < %s | FileCheck %s --check-prefix=SIFIVE-X280
; Check that we don't crash querying costs when vectors are not enabled.
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64

define i32 @add() {
; CHECK-LABEL: 'add'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = add <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = add <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = add <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = add <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = add <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = add <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = add <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = add <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = add <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = add <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = add <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = add <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = add <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = add <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = add <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = add <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = add <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = add <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = add <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = add <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = add <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = add <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = add <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = add <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = add <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = add <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = add <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = add <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'add'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = add <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = add <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = add <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = add <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = add <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = add <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = add <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = add <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = add <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = add <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = add <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = add <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = add <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = add <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = add <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = add <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = add <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = add <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = add <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = add <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = add <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = add <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = add <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = add <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = add <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = add <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = add <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = add <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = add i16 undef, undef
  %I32 = add i32 undef, undef
  %I64 = add i64 undef, undef

  %V1I16 = add <1 x i16> undef, undef
  %V2I16 = add <2 x i16> undef, undef
  %V4I16 = add <4 x i16> undef, undef
  %V8I16 = add <8 x i16> undef, undef
  %V16I16 = add <16 x i16> undef, undef
  %V32I16 = add <32 x i16> undef, undef

  %NXV1I16 = add <vscale x 1 x i16> undef, undef
  %NXV2I16 = add <vscale x 2 x i16> undef, undef
  %NXV4I16 = add <vscale x 4 x i16> undef, undef
  %NXV8I16 = add <vscale x 8 x i16> undef, undef
  %NXV16I16 = add <vscale x 16 x i16> undef, undef
  %NXV32I16 = add <vscale x 32 x i16> undef, undef

  %V1I32 = add <1 x i32> undef, undef
  %V2I32 = add <2 x i32> undef, undef
  %V4I32 = add <4 x i32> undef, undef
  %V8I32 = add <8 x i32> undef, undef
  %V16I32 = add <16 x i32> undef, undef

  %NXV1I32 = add <vscale x 1 x i32> undef, undef
  %NXV2I32 = add <vscale x 2 x i32> undef, undef
  %NXV4I32 = add <vscale x 4 x i32> undef, undef
  %NXV8I32 = add <vscale x 8 x i32> undef, undef
  %NXV16I32 = add <vscale x 16 x i32> undef, undef

  %V1I64 = add <1 x i64> undef, undef
  %V2I64 = add <2 x i64> undef, undef
  %V4I64 = add <4 x i64> undef, undef
  %V8I64 = add <8 x i64> undef, undef

  %NXV1I64 = add <vscale x 1 x i64> undef, undef
  %NXV2I64 = add <vscale x 2 x i64> undef, undef
  %NXV4I64 = add <vscale x 4 x i64> undef, undef
  %NXV8I64 = add <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @sub() {
; CHECK-LABEL: 'sub'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = sub <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = sub <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = sub <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = sub <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = sub <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = sub <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = sub <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = sub <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = sub <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = sub <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = sub <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = sub <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = sub <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = sub <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = sub <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = sub <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = sub <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = sub <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = sub <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = sub <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = sub <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sub <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = sub <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = sub <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = sub <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = sub <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = sub <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = sub <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'sub'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = sub <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = sub <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = sub <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = sub <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = sub <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = sub <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = sub <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = sub <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = sub <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = sub <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = sub <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = sub <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = sub <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = sub <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = sub <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = sub <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = sub <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = sub <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = sub <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = sub <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = sub <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sub <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = sub <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = sub <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = sub <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = sub <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = sub <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = sub <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = sub i16 undef, undef
  %I32 = sub i32 undef, undef
  %I64 = sub i64 undef, undef

  %V1I16 = sub <1 x i16> undef, undef
  %V2I16 = sub <2 x i16> undef, undef
  %V4I16 = sub <4 x i16> undef, undef
  %V8I16 = sub <8 x i16> undef, undef
  %V16I16 = sub <16 x i16> undef, undef
  %V32I16 = sub <32 x i16> undef, undef

  %NXV1I16 = sub <vscale x 1 x i16> undef, undef
  %NXV2I16 = sub <vscale x 2 x i16> undef, undef
  %NXV4I16 = sub <vscale x 4 x i16> undef, undef
  %NXV8I16 = sub <vscale x 8 x i16> undef, undef
  %NXV16I16 = sub <vscale x 16 x i16> undef, undef
  %NXV32I16 = sub <vscale x 32 x i16> undef, undef

  %V1I32 = sub <1 x i32> undef, undef
  %V2I32 = sub <2 x i32> undef, undef
  %V4I32 = sub <4 x i32> undef, undef
  %V8I32 = sub <8 x i32> undef, undef
  %V16I32 = sub <16 x i32> undef, undef

  %NXV1I32 = sub <vscale x 1 x i32> undef, undef
  %NXV2I32 = sub <vscale x 2 x i32> undef, undef
  %NXV4I32 = sub <vscale x 4 x i32> undef, undef
  %NXV8I32 = sub <vscale x 8 x i32> undef, undef
  %NXV16I32 = sub <vscale x 16 x i32> undef, undef

  %V1I64 = sub <1 x i64> undef, undef
  %V2I64 = sub <2 x i64> undef, undef
  %V4I64 = sub <4 x i64> undef, undef
  %V8I64 = sub <8 x i64> undef, undef

  %NXV1I64 = sub <vscale x 1 x i64> undef, undef
  %NXV2I64 = sub <vscale x 2 x i64> undef, undef
  %NXV4I64 = sub <vscale x 4 x i64> undef, undef
  %NXV8I64 = sub <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @mul() {
; CHECK-LABEL: 'mul'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = mul i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = mul i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = mul i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = mul <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = mul <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = mul <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = mul <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = mul <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = mul <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = mul <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = mul <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = mul <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = mul <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = mul <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = mul <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = mul <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = mul <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = mul <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = mul <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = mul <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = mul <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = mul <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = mul <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = mul <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = mul <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = mul <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = mul <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = mul <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = mul <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = mul <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = mul <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = mul <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = mul <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'mul'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = mul i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = mul i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = mul i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = mul <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = mul <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = mul <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = mul <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = mul <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = mul <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = mul <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = mul <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = mul <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = mul <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = mul <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = mul <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = mul <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = mul <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = mul <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = mul <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = mul <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = mul <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = mul <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = mul <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = mul <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = mul <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = mul <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = mul <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = mul <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = mul <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = mul <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = mul <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = mul <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = mul <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = mul i16 undef, undef
  %I32 = mul i32 undef, undef
  %I64 = mul i64 undef, undef

  %V1I16 = mul <1 x i16> undef, undef
  %V2I16 = mul <2 x i16> undef, undef
  %V4I16 = mul <4 x i16> undef, undef
  %V8I16 = mul <8 x i16> undef, undef
  %V16I16 = mul <16 x i16> undef, undef
  %V32I16 = mul <32 x i16> undef, undef

  %NXV1I16 = mul <vscale x 1 x i16> undef, undef
  %NXV2I16 = mul <vscale x 2 x i16> undef, undef
  %NXV4I16 = mul <vscale x 4 x i16> undef, undef
  %NXV8I16 = mul <vscale x 8 x i16> undef, undef
  %NXV16I16 = mul <vscale x 16 x i16> undef, undef
  %NXV32I16 = mul <vscale x 32 x i16> undef, undef

  %V1I32 = mul <1 x i32> undef, undef
  %V2I32 = mul <2 x i32> undef, undef
  %V4I32 = mul <4 x i32> undef, undef
  %V8I32 = mul <8 x i32> undef, undef
  %V16I32 = mul <16 x i32> undef, undef

  %NXV1I32 = mul <vscale x 1 x i32> undef, undef
  %NXV2I32 = mul <vscale x 2 x i32> undef, undef
  %NXV4I32 = mul <vscale x 4 x i32> undef, undef
  %NXV8I32 = mul <vscale x 8 x i32> undef, undef
  %NXV16I32 = mul <vscale x 16 x i32> undef, undef

  %V1I64 = mul <1 x i64> undef, undef
  %V2I64 = mul <2 x i64> undef, undef
  %V4I64 = mul <4 x i64> undef, undef
  %V8I64 = mul <8 x i64> undef, undef

  %NXV1I64 = mul <vscale x 1 x i64> undef, undef
  %NXV2I64 = mul <vscale x 2 x i64> undef, undef
  %NXV4I64 = mul <vscale x 4 x i64> undef, undef
  %NXV8I64 = mul <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @shl() {
; CHECK-LABEL: 'shl'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = shl i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = shl i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = shl i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = shl <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = shl <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = shl <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = shl <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = shl <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = shl <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = shl <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = shl <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = shl <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = shl <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = shl <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = shl <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = shl <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = shl <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = shl <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = shl <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = shl <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = shl <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = shl <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = shl <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = shl <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = shl <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = shl <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = shl <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = shl <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = shl <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = shl <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = shl <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = shl <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = shl <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'shl'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = shl i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = shl i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = shl i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = shl <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = shl <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = shl <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = shl <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = shl <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = shl <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = shl <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = shl <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = shl <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = shl <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = shl <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = shl <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = shl <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = shl <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = shl <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = shl <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = shl <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = shl <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = shl <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = shl <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = shl <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = shl <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = shl <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = shl <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = shl <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = shl <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = shl <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = shl <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = shl <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = shl <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = shl i16 undef, undef
  %I32 = shl i32 undef, undef
  %I64 = shl i64 undef, undef

  %V1I16 = shl <1 x i16> undef, undef
  %V2I16 = shl <2 x i16> undef, undef
  %V4I16 = shl <4 x i16> undef, undef
  %V8I16 = shl <8 x i16> undef, undef
  %V16I16 = shl <16 x i16> undef, undef
  %V32I16 = shl <32 x i16> undef, undef

  %NXV1I16 = shl <vscale x 1 x i16> undef, undef
  %NXV2I16 = shl <vscale x 2 x i16> undef, undef
  %NXV4I16 = shl <vscale x 4 x i16> undef, undef
  %NXV8I16 = shl <vscale x 8 x i16> undef, undef
  %NXV16I16 = shl <vscale x 16 x i16> undef, undef
  %NXV32I16 = shl <vscale x 32 x i16> undef, undef

  %V1I32 = shl <1 x i32> undef, undef
  %V2I32 = shl <2 x i32> undef, undef
  %V4I32 = shl <4 x i32> undef, undef
  %V8I32 = shl <8 x i32> undef, undef
  %V16I32 = shl <16 x i32> undef, undef

  %NXV1I32 = shl <vscale x 1 x i32> undef, undef
  %NXV2I32 = shl <vscale x 2 x i32> undef, undef
  %NXV4I32 = shl <vscale x 4 x i32> undef, undef
  %NXV8I32 = shl <vscale x 8 x i32> undef, undef
  %NXV16I32 = shl <vscale x 16 x i32> undef, undef

  %V1I64 = shl <1 x i64> undef, undef
  %V2I64 = shl <2 x i64> undef, undef
  %V4I64 = shl <4 x i64> undef, undef
  %V8I64 = shl <8 x i64> undef, undef

  %NXV1I64 = shl <vscale x 1 x i64> undef, undef
  %NXV2I64 = shl <vscale x 2 x i64> undef, undef
  %NXV4I64 = shl <vscale x 4 x i64> undef, undef
  %NXV8I64 = shl <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @lshr() {
; CHECK-LABEL: 'lshr'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = lshr i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = lshr i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = lshr i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = lshr <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = lshr <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = lshr <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = lshr <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = lshr <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = lshr <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = lshr <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = lshr <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = lshr <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = lshr <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = lshr <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = lshr <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = lshr <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = lshr <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = lshr <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = lshr <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = lshr <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = lshr <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = lshr <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = lshr <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = lshr <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = lshr <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = lshr <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = lshr <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = lshr <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = lshr <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = lshr <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = lshr <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = lshr <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = lshr <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'lshr'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = lshr i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = lshr i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = lshr i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = lshr <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = lshr <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = lshr <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = lshr <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = lshr <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = lshr <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = lshr <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = lshr <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = lshr <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = lshr <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = lshr <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = lshr <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = lshr <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = lshr <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = lshr <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = lshr <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = lshr <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = lshr <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = lshr <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = lshr <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = lshr <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = lshr <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = lshr <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = lshr <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = lshr <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = lshr <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = lshr <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = lshr <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = lshr <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = lshr <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = lshr i16 undef, undef
  %I32 = lshr i32 undef, undef
  %I64 = lshr i64 undef, undef

  %V1I16 = lshr <1 x i16> undef, undef
  %V2I16 = lshr <2 x i16> undef, undef
  %V4I16 = lshr <4 x i16> undef, undef
  %V8I16 = lshr <8 x i16> undef, undef
  %V16I16 = lshr <16 x i16> undef, undef
  %V32I16 = lshr <32 x i16> undef, undef

  %NXV1I16 = lshr <vscale x 1 x i16> undef, undef
  %NXV2I16 = lshr <vscale x 2 x i16> undef, undef
  %NXV4I16 = lshr <vscale x 4 x i16> undef, undef
  %NXV8I16 = lshr <vscale x 8 x i16> undef, undef
  %NXV16I16 = lshr <vscale x 16 x i16> undef, undef
  %NXV32I16 = lshr <vscale x 32 x i16> undef, undef

  %V1I32 = lshr <1 x i32> undef, undef
  %V2I32 = lshr <2 x i32> undef, undef
  %V4I32 = lshr <4 x i32> undef, undef
  %V8I32 = lshr <8 x i32> undef, undef
  %V16I32 = lshr <16 x i32> undef, undef

  %NXV1I32 = lshr <vscale x 1 x i32> undef, undef
  %NXV2I32 = lshr <vscale x 2 x i32> undef, undef
  %NXV4I32 = lshr <vscale x 4 x i32> undef, undef
  %NXV8I32 = lshr <vscale x 8 x i32> undef, undef
  %NXV16I32 = lshr <vscale x 16 x i32> undef, undef

  %V1I64 = lshr <1 x i64> undef, undef
  %V2I64 = lshr <2 x i64> undef, undef
  %V4I64 = lshr <4 x i64> undef, undef
  %V8I64 = lshr <8 x i64> undef, undef

  %NXV1I64 = lshr <vscale x 1 x i64> undef, undef
  %NXV2I64 = lshr <vscale x 2 x i64> undef, undef
  %NXV4I64 = lshr <vscale x 4 x i64> undef, undef
  %NXV8I64 = lshr <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @ashr() {
; CHECK-LABEL: 'ashr'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = ashr i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = ashr i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = ashr i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = ashr <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = ashr <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = ashr <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = ashr <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = ashr <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = ashr <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = ashr <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = ashr <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = ashr <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = ashr <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = ashr <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = ashr <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = ashr <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = ashr <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = ashr <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = ashr <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = ashr <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = ashr <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = ashr <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = ashr <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = ashr <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = ashr <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = ashr <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = ashr <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = ashr <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = ashr <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = ashr <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = ashr <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = ashr <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = ashr <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'ashr'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = ashr i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = ashr i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = ashr i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = ashr <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = ashr <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = ashr <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = ashr <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = ashr <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = ashr <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = ashr <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = ashr <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = ashr <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = ashr <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = ashr <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = ashr <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = ashr <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = ashr <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = ashr <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = ashr <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = ashr <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = ashr <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = ashr <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = ashr <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = ashr <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = ashr <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = ashr <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = ashr <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = ashr <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = ashr <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = ashr <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = ashr <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = ashr <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = ashr <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = ashr i16 undef, undef
  %I32 = ashr i32 undef, undef
  %I64 = ashr i64 undef, undef

  %V1I16 = ashr <1 x i16> undef, undef
  %V2I16 = ashr <2 x i16> undef, undef
  %V4I16 = ashr <4 x i16> undef, undef
  %V8I16 = ashr <8 x i16> undef, undef
  %V16I16 = ashr <16 x i16> undef, undef
  %V32I16 = ashr <32 x i16> undef, undef

  %NXV1I16 = ashr <vscale x 1 x i16> undef, undef
  %NXV2I16 = ashr <vscale x 2 x i16> undef, undef
  %NXV4I16 = ashr <vscale x 4 x i16> undef, undef
  %NXV8I16 = ashr <vscale x 8 x i16> undef, undef
  %NXV16I16 = ashr <vscale x 16 x i16> undef, undef
  %NXV32I16 = ashr <vscale x 32 x i16> undef, undef

  %V1I32 = ashr <1 x i32> undef, undef
  %V2I32 = ashr <2 x i32> undef, undef
  %V4I32 = ashr <4 x i32> undef, undef
  %V8I32 = ashr <8 x i32> undef, undef
  %V16I32 = ashr <16 x i32> undef, undef

  %NXV1I32 = ashr <vscale x 1 x i32> undef, undef
  %NXV2I32 = ashr <vscale x 2 x i32> undef, undef
  %NXV4I32 = ashr <vscale x 4 x i32> undef, undef
  %NXV8I32 = ashr <vscale x 8 x i32> undef, undef
  %NXV16I32 = ashr <vscale x 16 x i32> undef, undef

  %V1I64 = ashr <1 x i64> undef, undef
  %V2I64 = ashr <2 x i64> undef, undef
  %V4I64 = ashr <4 x i64> undef, undef
  %V8I64 = ashr <8 x i64> undef, undef

  %NXV1I64 = ashr <vscale x 1 x i64> undef, undef
  %NXV2I64 = ashr <vscale x 2 x i64> undef, undef
  %NXV4I64 = ashr <vscale x 4 x i64> undef, undef
  %NXV8I64 = ashr <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @udiv() {
; CHECK-LABEL: 'udiv'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = udiv i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = udiv i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = udiv i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = udiv <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = udiv <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = udiv <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = udiv <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = udiv <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = udiv <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = udiv <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = udiv <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = udiv <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = udiv <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = udiv <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = udiv <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = udiv <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = udiv <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = udiv <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = udiv <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = udiv <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = udiv <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = udiv <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = udiv <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = udiv <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = udiv <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = udiv <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = udiv <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = udiv <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = udiv <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = udiv <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = udiv <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = udiv <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = udiv <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'udiv'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = udiv i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = udiv i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = udiv i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = udiv <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = udiv <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = udiv <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = udiv <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = udiv <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = udiv <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = udiv <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = udiv <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = udiv <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = udiv <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = udiv <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = udiv <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = udiv <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = udiv <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = udiv <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = udiv <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = udiv <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = udiv <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = udiv <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = udiv <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = udiv <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = udiv <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = udiv <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = udiv <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = udiv <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = udiv <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = udiv <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = udiv <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = udiv <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = udiv <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = udiv i16 undef, undef
  %I32 = udiv i32 undef, undef
  %I64 = udiv i64 undef, undef

  %V1I16 = udiv <1 x i16> undef, undef
  %V2I16 = udiv <2 x i16> undef, undef
  %V4I16 = udiv <4 x i16> undef, undef
  %V8I16 = udiv <8 x i16> undef, undef
  %V16I16 = udiv <16 x i16> undef, undef
  %V32I16 = udiv <32 x i16> undef, undef

  %NXV1I16 = udiv <vscale x 1 x i16> undef, undef
  %NXV2I16 = udiv <vscale x 2 x i16> undef, undef
  %NXV4I16 = udiv <vscale x 4 x i16> undef, undef
  %NXV8I16 = udiv <vscale x 8 x i16> undef, undef
  %NXV16I16 = udiv <vscale x 16 x i16> undef, undef
  %NXV32I16 = udiv <vscale x 32 x i16> undef, undef

  %V1I32 = udiv <1 x i32> undef, undef
  %V2I32 = udiv <2 x i32> undef, undef
  %V4I32 = udiv <4 x i32> undef, undef
  %V8I32 = udiv <8 x i32> undef, undef
  %V16I32 = udiv <16 x i32> undef, undef

  %NXV1I32 = udiv <vscale x 1 x i32> undef, undef
  %NXV2I32 = udiv <vscale x 2 x i32> undef, undef
  %NXV4I32 = udiv <vscale x 4 x i32> undef, undef
  %NXV8I32 = udiv <vscale x 8 x i32> undef, undef
  %NXV16I32 = udiv <vscale x 16 x i32> undef, undef

  %V1I64 = udiv <1 x i64> undef, undef
  %V2I64 = udiv <2 x i64> undef, undef
  %V4I64 = udiv <4 x i64> undef, undef
  %V8I64 = udiv <8 x i64> undef, undef

  %NXV1I64 = udiv <vscale x 1 x i64> undef, undef
  %NXV2I64 = udiv <vscale x 2 x i64> undef, undef
  %NXV4I64 = udiv <vscale x 4 x i64> undef, undef
  %NXV8I64 = udiv <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @urem() {
; CHECK-LABEL: 'urem'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = urem i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = urem i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = urem i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = urem <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = urem <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = urem <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = urem <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = urem <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = urem <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = urem <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = urem <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = urem <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = urem <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = urem <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = urem <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = urem <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = urem <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = urem <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = urem <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = urem <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = urem <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = urem <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = urem <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = urem <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = urem <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = urem <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = urem <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = urem <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = urem <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = urem <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = urem <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = urem <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = urem <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'urem'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = urem i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = urem i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = urem i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = urem <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = urem <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = urem <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = urem <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = urem <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = urem <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = urem <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = urem <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = urem <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = urem <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = urem <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = urem <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = urem <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = urem <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = urem <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = urem <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = urem <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = urem <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = urem <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = urem <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = urem <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = urem <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = urem <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = urem <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = urem <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = urem <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = urem <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = urem <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = urem <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = urem <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = urem i16 undef, undef
  %I32 = urem i32 undef, undef
  %I64 = urem i64 undef, undef

  %V1I16 = urem <1 x i16> undef, undef
  %V2I16 = urem <2 x i16> undef, undef
  %V4I16 = urem <4 x i16> undef, undef
  %V8I16 = urem <8 x i16> undef, undef
  %V16I16 = urem <16 x i16> undef, undef
  %V32I16 = urem <32 x i16> undef, undef

  %NXV1I16 = urem <vscale x 1 x i16> undef, undef
  %NXV2I16 = urem <vscale x 2 x i16> undef, undef
  %NXV4I16 = urem <vscale x 4 x i16> undef, undef
  %NXV8I16 = urem <vscale x 8 x i16> undef, undef
  %NXV16I16 = urem <vscale x 16 x i16> undef, undef
  %NXV32I16 = urem <vscale x 32 x i16> undef, undef

  %V1I32 = urem <1 x i32> undef, undef
  %V2I32 = urem <2 x i32> undef, undef
  %V4I32 = urem <4 x i32> undef, undef
  %V8I32 = urem <8 x i32> undef, undef
  %V16I32 = urem <16 x i32> undef, undef

  %NXV1I32 = urem <vscale x 1 x i32> undef, undef
  %NXV2I32 = urem <vscale x 2 x i32> undef, undef
  %NXV4I32 = urem <vscale x 4 x i32> undef, undef
  %NXV8I32 = urem <vscale x 8 x i32> undef, undef
  %NXV16I32 = urem <vscale x 16 x i32> undef, undef

  %V1I64 = urem <1 x i64> undef, undef
  %V2I64 = urem <2 x i64> undef, undef
  %V4I64 = urem <4 x i64> undef, undef
  %V8I64 = urem <8 x i64> undef, undef

  %NXV1I64 = urem <vscale x 1 x i64> undef, undef
  %NXV2I64 = urem <vscale x 2 x i64> undef, undef
  %NXV4I64 = urem <vscale x 4 x i64> undef, undef
  %NXV8I64 = urem <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @sdiv() {
; CHECK-LABEL: 'sdiv'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sdiv i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sdiv i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sdiv i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = sdiv <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = sdiv <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = sdiv <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sdiv <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = sdiv <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = sdiv <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = sdiv <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = sdiv <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = sdiv <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = sdiv <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = sdiv <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = sdiv <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = sdiv <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = sdiv <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sdiv <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = sdiv <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = sdiv <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = sdiv <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = sdiv <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = sdiv <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = sdiv <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = sdiv <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = sdiv <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sdiv <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = sdiv <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = sdiv <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = sdiv <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = sdiv <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = sdiv <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = sdiv <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'sdiv'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sdiv i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sdiv i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sdiv i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = sdiv <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = sdiv <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = sdiv <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sdiv <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = sdiv <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = sdiv <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = sdiv <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = sdiv <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = sdiv <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = sdiv <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = sdiv <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = sdiv <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = sdiv <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = sdiv <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sdiv <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = sdiv <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = sdiv <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = sdiv <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = sdiv <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = sdiv <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = sdiv <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = sdiv <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = sdiv <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sdiv <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = sdiv <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = sdiv <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = sdiv <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = sdiv <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = sdiv <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = sdiv <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = sdiv i16 undef, undef
  %I32 = sdiv i32 undef, undef
  %I64 = sdiv i64 undef, undef

  %V1I16 = sdiv <1 x i16> undef, undef
  %V2I16 = sdiv <2 x i16> undef, undef
  %V4I16 = sdiv <4 x i16> undef, undef
  %V8I16 = sdiv <8 x i16> undef, undef
  %V16I16 = sdiv <16 x i16> undef, undef
  %V32I16 = sdiv <32 x i16> undef, undef

  %NXV1I16 = sdiv <vscale x 1 x i16> undef, undef
  %NXV2I16 = sdiv <vscale x 2 x i16> undef, undef
  %NXV4I16 = sdiv <vscale x 4 x i16> undef, undef
  %NXV8I16 = sdiv <vscale x 8 x i16> undef, undef
  %NXV16I16 = sdiv <vscale x 16 x i16> undef, undef
  %NXV32I16 = sdiv <vscale x 32 x i16> undef, undef

  %V1I32 = sdiv <1 x i32> undef, undef
  %V2I32 = sdiv <2 x i32> undef, undef
  %V4I32 = sdiv <4 x i32> undef, undef
  %V8I32 = sdiv <8 x i32> undef, undef
  %V16I32 = sdiv <16 x i32> undef, undef

  %NXV1I32 = sdiv <vscale x 1 x i32> undef, undef
  %NXV2I32 = sdiv <vscale x 2 x i32> undef, undef
  %NXV4I32 = sdiv <vscale x 4 x i32> undef, undef
  %NXV8I32 = sdiv <vscale x 8 x i32> undef, undef
  %NXV16I32 = sdiv <vscale x 16 x i32> undef, undef

  %V1I64 = sdiv <1 x i64> undef, undef
  %V2I64 = sdiv <2 x i64> undef, undef
  %V4I64 = sdiv <4 x i64> undef, undef
  %V8I64 = sdiv <8 x i64> undef, undef

  %NXV1I64 = sdiv <vscale x 1 x i64> undef, undef
  %NXV2I64 = sdiv <vscale x 2 x i64> undef, undef
  %NXV4I64 = sdiv <vscale x 4 x i64> undef, undef
  %NXV8I64 = sdiv <vscale x 8 x i64> undef, undef

  ret i32 undef
}

define i32 @srem() {
; CHECK-LABEL: 'srem'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = srem i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = srem i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = srem i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = srem <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = srem <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = srem <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = srem <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = srem <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = srem <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = srem <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = srem <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV4I16 = srem <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV8I16 = srem <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV16I16 = srem <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV32I16 = srem <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = srem <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = srem <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = srem <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = srem <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = srem <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = srem <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I32 = srem <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I32 = srem <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I32 = srem <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I32 = srem <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = srem <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = srem <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = srem <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = srem <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I64 = srem <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I64 = srem <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I64 = srem <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I64 = srem <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'srem'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = srem i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = srem i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = srem i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I16 = srem <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I16 = srem <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I16 = srem <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = srem <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = srem <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = srem <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I16 = srem <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV2I16 = srem <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV4I16 = srem <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV8I16 = srem <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV16I16 = srem <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV32I16 = srem <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I32 = srem <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I32 = srem <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = srem <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = srem <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = srem <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %NXV1I32 = srem <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV2I32 = srem <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV4I32 = srem <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV8I32 = srem <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV16I32 = srem <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1I64 = srem <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = srem <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = srem <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = srem <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %NXV1I64 = srem <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %NXV2I64 = srem <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %NXV4I64 = srem <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %NXV8I64 = srem <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I16 = srem i16 undef, undef
  %I32 = srem i32 undef, undef
  %I64 = srem i64 undef, undef

  %V1I16 = srem <1 x i16> undef, undef
  %V2I16 = srem <2 x i16> undef, undef
  %V4I16 = srem <4 x i16> undef, undef
  %V8I16 = srem <8 x i16> undef, undef
  %V16I16 = srem <16 x i16> undef, undef
  %V32I16 = srem <32 x i16> undef, undef

  %NXV1I16 = srem <vscale x 1 x i16> undef, undef
  %NXV2I16 = srem <vscale x 2 x i16> undef, undef
  %NXV4I16 = srem <vscale x 4 x i16> undef, undef
  %NXV8I16 = srem <vscale x 8 x i16> undef, undef
  %NXV16I16 = srem <vscale x 16 x i16> undef, undef
  %NXV32I16 = srem <vscale x 32 x i16> undef, undef

  %V1I32 = srem <1 x i32> undef, undef
  %V2I32 = srem <2 x i32> undef, undef
  %V4I32 = srem <4 x i32> undef, undef
  %V8I32 = srem <8 x i32> undef, undef
  %V16I32 = srem <16 x i32> undef, undef

  %NXV1I32 = srem <vscale x 1 x i32> undef, undef
  %NXV2I32 = srem <vscale x 2 x i32> undef, undef
  %NXV4I32 = srem <vscale x 4 x i32> undef, undef
  %NXV8I32 = srem <vscale x 8 x i32> undef, undef
  %NXV16I32 = srem <vscale x 16 x i32> undef, undef

  %V1I64 = srem <1 x i64> undef, undef
  %V2I64 = srem <2 x i64> undef, undef
  %V4I64 = srem <4 x i64> undef, undef
  %V8I64 = srem <8 x i64> undef, undef

  %NXV1I64 = srem <vscale x 1 x i64> undef, undef
  %NXV2I64 = srem <vscale x 2 x i64> undef, undef
  %NXV4I64 = srem <vscale x 4 x i64> undef, undef
  %NXV8I64 = srem <vscale x 8 x i64> undef, undef

  ret i32 undef
}


; For constants, have to account for cost of materializing the constant itself
; This test exercises a few interesting constant patterns at VLEN=128
define void @add_of_constant() {
; CHECK-LABEL: 'add_of_constant'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = add <4 x i32> poison, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = add <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = add <4 x i32> zeroinitializer, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = add <2 x i64> zeroinitializer, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = add <4 x i32> splat (i32 1), undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = add <2 x i64> splat (i64 1), undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = add <4 x i32> splat (i32 4096), undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %8 = add <4 x i32> <i32 1, i32 1, i32 2, i32 1>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %9 = add <4 x i32> <i32 2, i32 1, i32 1, i32 1>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = add <4 x i32> <i32 0, i32 1, i32 2, i32 3>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %11 = add <4 x i32> <i32 1, i32 2, i32 3, i32 4>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %12 = add <4 x i32> <i32 -1, i32 -2, i32 -3, i32 -4>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %13 = add <4 x i32> <i32 2, i32 4, i32 6, i32 8>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %14 = add <4 x i32> <i32 -1, i32 0, i32 2, i32 1>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %15 = add <4 x i32> <i32 256, i32 4096, i32 57, i32 1>, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SIFIVE-X280-LABEL: 'add_of_constant'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = add <4 x i32> poison, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = add <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = add <4 x i32> zeroinitializer, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = add <2 x i64> zeroinitializer, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = add <4 x i32> splat (i32 1), undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = add <2 x i64> splat (i64 1), undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = add <4 x i32> splat (i32 4096), undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %8 = add <4 x i32> <i32 1, i32 1, i32 2, i32 1>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %9 = add <4 x i32> <i32 2, i32 1, i32 1, i32 1>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = add <4 x i32> <i32 0, i32 1, i32 2, i32 3>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %11 = add <4 x i32> <i32 1, i32 2, i32 3, i32 4>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %12 = add <4 x i32> <i32 -1, i32 -2, i32 -3, i32 -4>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %13 = add <4 x i32> <i32 2, i32 4, i32 6, i32 8>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %14 = add <4 x i32> <i32 -1, i32 0, i32 2, i32 1>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %15 = add <4 x i32> <i32 256, i32 4096, i32 57, i32 1>, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;

  ; poison and undef
  add <4 x i32> poison, undef
  add <4 x i32> undef, undef

  ; Various splats
  add <4 x i32> zeroinitializer, undef
  add <2 x i64> zeroinitializer, undef
  add <4 x i32> <i32 1, i32 1, i32 1, i32 1>, undef
  add <2 x i64> <i64 1, i64 1>, undef
  add <4 x i32> <i32 4096, i32 4096, i32 4096, i32 4096>, undef

  ; Nearly splats
  add <4 x i32> <i32 1, i32 1, i32 2, i32 1>, undef
  add <4 x i32> <i32 2, i32 1, i32 1, i32 1>, undef

  ; Step vector functions
  add <4 x i32> <i32 0, i32 1, i32 2, i32 3>, undef
  add <4 x i32> <i32 1, i32 2, i32 3, i32 4>, undef
  add <4 x i32> <i32 -1, i32 -2, i32 -3, i32 -4>, undef
  add <4 x i32> <i32 2, i32 4, i32 6, i32 8>, undef

  ; General case 128 bit constants
  add <4 x i32> <i32 -1, i32 0, i32 2, i32 1>, undef
  add <4 x i32> <i32 256, i32 4096, i32 57, i32 1>, undef

  ret void
}

define i32 @and() {
; CHECK-LABEL: 'and'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = and i1 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = and i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = and i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = and i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = and <1 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = and <2 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = and <4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = and <8 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = and <16 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = and <32 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = and <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = and <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = and <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = and <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = and <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %16 = and <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = and <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = and <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = and <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %20 = and <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = and <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = and <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = and <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %24 = and <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %25 = and <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = and <vscale x 1 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = and <vscale x 2 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = and <vscale x 4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = and <vscale x 8 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = and <vscale x 16 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = and <vscale x 32 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = and <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = and <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = and <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = and <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %36 = and <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %37 = and <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = and <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = and <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %40 = and <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = and <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = and <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = and <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = and <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = and <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %46 = and <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'and'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = and i1 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = and i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = and i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = and i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = and <1 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = and <2 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = and <4 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = and <8 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = and <16 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = and <32 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = and <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = and <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = and <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = and <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = and <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %16 = and <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = and <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = and <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = and <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = and <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %21 = and <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = and <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = and <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = and <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %25 = and <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = and <vscale x 1 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = and <vscale x 2 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = and <vscale x 4 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = and <vscale x 8 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = and <vscale x 16 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = and <vscale x 32 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = and <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = and <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = and <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = and <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %36 = and <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %37 = and <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = and <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %39 = and <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = and <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %41 = and <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %42 = and <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %43 = and <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %44 = and <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %45 = and <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %46 = and <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  and i1 undef, undef
  and i16 undef, undef
  and i32 undef, undef
  and i64 undef, undef

  and <1 x i1> undef, undef
  and <2 x i1> undef, undef
  and <4 x i1> undef, undef
  and <8 x i1> undef, undef
  and <16 x i1> undef, undef
  and <32 x i1> undef, undef

  and <1 x i16> undef, undef
  and <2 x i16> undef, undef
  and <4 x i16> undef, undef
  and <8 x i16> undef, undef
  and <16 x i16> undef, undef
  and <32 x i16> undef, undef

  and <1 x i32> undef, undef
  and <2 x i32> undef, undef
  and <4 x i32> undef, undef
  and <8 x i32> undef, undef
  and <16 x i32> undef, undef

  and <1 x i64> undef, undef
  and <2 x i64> undef, undef
  and <4 x i64> undef, undef
  and <8 x i64> undef, undef

  and <vscale x 1 x i1> undef, undef
  and <vscale x 2 x i1> undef, undef
  and <vscale x 4 x i1> undef, undef
  and <vscale x 8 x i1> undef, undef
  and <vscale x 16 x i1> undef, undef
  and <vscale x 32 x i1> undef, undef

  and <vscale x 1 x i16> undef, undef
  and <vscale x 2 x i16> undef, undef
  and <vscale x 4 x i16> undef, undef
  and <vscale x 8 x i16> undef, undef
  and <vscale x 16 x i16> undef, undef
  and <vscale x 32 x i16> undef, undef

  and <vscale x 1 x i32> undef, undef
  and <vscale x 2 x i32> undef, undef
  and <vscale x 4 x i32> undef, undef
  and <vscale x 8 x i32> undef, undef
  and <vscale x 16 x i32> undef, undef

  and <vscale x 1 x i64> undef, undef
  and <vscale x 2 x i64> undef, undef
  and <vscale x 4 x i64> undef, undef
  and <vscale x 8 x i64> undef, undef
  ret i32 undef
}

define i32 @or() {
; CHECK-LABEL: 'or'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = or i1 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = or i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = or i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = or i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = or <1 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = or <2 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = or <4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = or <8 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = or <16 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = or <32 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = or <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = or <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = or <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = or <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = or <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %16 = or <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = or <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = or <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = or <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %20 = or <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = or <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = or <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = or <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %24 = or <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %25 = or <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = or <vscale x 1 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = or <vscale x 2 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = or <vscale x 4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = or <vscale x 8 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = or <vscale x 16 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = or <vscale x 32 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = or <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = or <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = or <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = or <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %36 = or <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %37 = or <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = or <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = or <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %40 = or <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = or <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = or <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = or <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = or <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = or <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %46 = or <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'or'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = or i1 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = or i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = or i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = or i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = or <1 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = or <2 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = or <4 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = or <8 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = or <16 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = or <32 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = or <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = or <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = or <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = or <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = or <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %16 = or <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = or <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = or <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = or <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = or <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %21 = or <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = or <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = or <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = or <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %25 = or <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = or <vscale x 1 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = or <vscale x 2 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = or <vscale x 4 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = or <vscale x 8 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = or <vscale x 16 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = or <vscale x 32 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = or <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = or <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = or <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = or <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %36 = or <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %37 = or <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = or <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %39 = or <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = or <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %41 = or <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %42 = or <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %43 = or <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %44 = or <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %45 = or <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %46 = or <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  or i1 undef, undef
  or i16 undef, undef
  or i32 undef, undef
  or i64 undef, undef

  or <1 x i1> undef, undef
  or <2 x i1> undef, undef
  or <4 x i1> undef, undef
  or <8 x i1> undef, undef
  or <16 x i1> undef, undef
  or <32 x i1> undef, undef

  or <1 x i16> undef, undef
  or <2 x i16> undef, undef
  or <4 x i16> undef, undef
  or <8 x i16> undef, undef
  or <16 x i16> undef, undef
  or <32 x i16> undef, undef

  or <1 x i32> undef, undef
  or <2 x i32> undef, undef
  or <4 x i32> undef, undef
  or <8 x i32> undef, undef
  or <16 x i32> undef, undef

  or <1 x i64> undef, undef
  or <2 x i64> undef, undef
  or <4 x i64> undef, undef
  or <8 x i64> undef, undef

  or <vscale x 1 x i1> undef, undef
  or <vscale x 2 x i1> undef, undef
  or <vscale x 4 x i1> undef, undef
  or <vscale x 8 x i1> undef, undef
  or <vscale x 16 x i1> undef, undef
  or <vscale x 32 x i1> undef, undef

  or <vscale x 1 x i16> undef, undef
  or <vscale x 2 x i16> undef, undef
  or <vscale x 4 x i16> undef, undef
  or <vscale x 8 x i16> undef, undef
  or <vscale x 16 x i16> undef, undef
  or <vscale x 32 x i16> undef, undef

  or <vscale x 1 x i32> undef, undef
  or <vscale x 2 x i32> undef, undef
  or <vscale x 4 x i32> undef, undef
  or <vscale x 8 x i32> undef, undef
  or <vscale x 16 x i32> undef, undef

  or <vscale x 1 x i64> undef, undef
  or <vscale x 2 x i64> undef, undef
  or <vscale x 4 x i64> undef, undef
  or <vscale x 8 x i64> undef, undef
  ret i32 undef
}

define i32 @xor() {
; CHECK-LABEL: 'xor'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = xor i1 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = xor i16 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = xor i32 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = xor i64 undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = xor <1 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = xor <2 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = xor <4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = xor <8 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = xor <16 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = xor <32 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = xor <1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = xor <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = xor <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = xor <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = xor <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %16 = xor <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = xor <1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = xor <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = xor <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %20 = xor <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = xor <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = xor <1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = xor <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %24 = xor <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %25 = xor <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = xor <vscale x 1 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = xor <vscale x 2 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = xor <vscale x 4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = xor <vscale x 8 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = xor <vscale x 16 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = xor <vscale x 32 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = xor <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = xor <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = xor <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = xor <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %36 = xor <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %37 = xor <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = xor <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = xor <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %40 = xor <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = xor <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = xor <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = xor <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = xor <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = xor <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %46 = xor <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SIFIVE-X280-LABEL: 'xor'
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = xor i1 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = xor i16 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = xor i32 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = xor i64 undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = xor <1 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = xor <2 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = xor <4 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = xor <8 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = xor <16 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = xor <32 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = xor <1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = xor <2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = xor <4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = xor <8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = xor <16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %16 = xor <32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = xor <1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = xor <2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = xor <4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = xor <8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %21 = xor <16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = xor <1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = xor <2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = xor <4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %25 = xor <8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = xor <vscale x 1 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = xor <vscale x 2 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = xor <vscale x 4 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = xor <vscale x 8 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = xor <vscale x 16 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = xor <vscale x 32 x i1> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = xor <vscale x 1 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = xor <vscale x 2 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = xor <vscale x 4 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = xor <vscale x 8 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %36 = xor <vscale x 16 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %37 = xor <vscale x 32 x i16> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = xor <vscale x 1 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %39 = xor <vscale x 2 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = xor <vscale x 4 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %41 = xor <vscale x 8 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %42 = xor <vscale x 16 x i32> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %43 = xor <vscale x 1 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %44 = xor <vscale x 2 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %45 = xor <vscale x 4 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %46 = xor <vscale x 8 x i64> undef, undef
; SIFIVE-X280-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  xor i1 undef, undef
  xor i16 undef, undef
  xor i32 undef, undef
  xor i64 undef, undef

  xor <1 x i1> undef, undef
  xor <2 x i1> undef, undef
  xor <4 x i1> undef, undef
  xor <8 x i1> undef, undef
  xor <16 x i1> undef, undef
  xor <32 x i1> undef, undef

  xor <1 x i16> undef, undef
  xor <2 x i16> undef, undef
  xor <4 x i16> undef, undef
  xor <8 x i16> undef, undef
  xor <16 x i16> undef, undef
  xor <32 x i16> undef, undef

  xor <1 x i32> undef, undef
  xor <2 x i32> undef, undef
  xor <4 x i32> undef, undef
  xor <8 x i32> undef, undef
  xor <16 x i32> undef, undef

  xor <1 x i64> undef, undef
  xor <2 x i64> undef, undef
  xor <4 x i64> undef, undef
  xor <8 x i64> undef, undef

  xor <vscale x 1 x i1> undef, undef
  xor <vscale x 2 x i1> undef, undef
  xor <vscale x 4 x i1> undef, undef
  xor <vscale x 8 x i1> undef, undef
  xor <vscale x 16 x i1> undef, undef
  xor <vscale x 32 x i1> undef, undef

  xor <vscale x 1 x i16> undef, undef
  xor <vscale x 2 x i16> undef, undef
  xor <vscale x 4 x i16> undef, undef
  xor <vscale x 8 x i16> undef, undef
  xor <vscale x 16 x i16> undef, undef
  xor <vscale x 32 x i16> undef, undef

  xor <vscale x 1 x i32> undef, undef
  xor <vscale x 2 x i32> undef, undef
  xor <vscale x 4 x i32> undef, undef
  xor <vscale x 8 x i32> undef, undef
  xor <vscale x 16 x i32> undef, undef

  xor <vscale x 1 x i64> undef, undef
  xor <vscale x 2 x i64> undef, undef
  xor <vscale x 4 x i64> undef, undef
  xor <vscale x 8 x i64> undef, undef
  ret i32 undef
}
