; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512F
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mcpu=goldmont | FileCheck %s --check-prefixes=GLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mcpu=btver2 | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mcpu=knl | FileCheck %s --check-prefixes=AVX512

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.8.0"

;
; mul vXi8 -> mXi32
;

define void @mul_sext_vXi8(<4 x i8> %a4, <4 x i8> %b4, <8 x i8> %a8, <8 x i8> %b8, <16 x i8> %a16, <16 x i8> %b16, <32 x i8> %a32, <32 x i8> %b32, <64 x i8> %a64, <64 x i8> %b64)  {
; SSE2-LABEL: 'mul_sext_vXi8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'mul_sext_vXi8'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'mul_sext_vXi8'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:88 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:176 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'mul_sext_vXi8'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:3 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:8 SizeLat:10 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:16 SizeLat:20 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:32 SizeLat:40 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:64 SizeLat:80 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'mul_sext_vXi8'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:10 SizeLat:2 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'mul_sext_vXi8'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:20 SizeLat:4 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:40 SizeLat:8 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLM-LABEL: 'mul_sext_vXi8'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 3 for: %res4 = mul <4 x i32> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found costs of 6 for: %res8 = mul <8 x i32> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found costs of 12 for: %res16 = mul <16 x i32> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found costs of 24 for: %res32 = mul <32 x i32> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found costs of 48 for: %res64 = mul <64 x i32> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; GLM-LABEL: 'mul_sext_vXi8'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i8> %b4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = sext <8 x i8> %b8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = sext <16 x i8> %b16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = sext <32 x i8> %b32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = sext <64 x i8> %b64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:88 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:176 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %xa4 = sext <4 x i8> %a4 to <4 x i32>
  %xb4 = sext <4 x i8> %b4 to <4 x i32>
  %xa8 = sext <8 x i8> %a8 to <8 x i32>
  %xb8 = sext <8 x i8> %b8 to <8 x i32>
  %xa16 = sext <16 x i8> %a16 to <16 x i32>
  %xb16 = sext <16 x i8> %b16 to <16 x i32>
  %xa32 = sext <32 x i8> %a32 to <32 x i32>
  %xb32 = sext <32 x i8> %b32 to <32 x i32>
  %xa64 = sext <64 x i8> %a64 to <64 x i32>
  %xb64 = sext <64 x i8> %b64 to <64 x i32>
  %res4 = mul <4 x i32> %xa4, %xb4
  %res8 = mul <8 x i32> %xa8, %xb8
  %res16 = mul <16 x i32> %xa16, %xb16
  %res32 = mul <32 x i32> %xa32, %xb32
  %res64 = mul <64 x i32> %xa64, %xb64
  ret void
}

define void @mul_zext_vXi8(<4 x i8> %a4, <4 x i8> %b4, <8 x i8> %a8, <8 x i8> %b8, <16 x i8> %a16, <16 x i8> %b16, <32 x i8> %a32, <32 x i8> %b32, <64 x i8> %a64, <64 x i8> %b64)  {
; SSE2-LABEL: 'mul_zext_vXi8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'mul_zext_vXi8'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'mul_zext_vXi8'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'mul_zext_vXi8'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:8 SizeLat:6 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:16 SizeLat:12 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:32 SizeLat:24 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:40 Lat:64 SizeLat:48 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'mul_zext_vXi8'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512F-LABEL: 'mul_zext_vXi8'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512BW-LABEL: 'mul_zext_vXi8'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLM-LABEL: 'mul_zext_vXi8'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; GLM-LABEL: 'mul_zext_vXi8'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i8> %a4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i8> %a8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i8> %a16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i8> %a32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i8> %a64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %xa4 = zext <4 x i8> %a4 to <4 x i32>
  %xb4 = zext <4 x i8> %b4 to <4 x i32>
  %xa8 = zext <8 x i8> %a8 to <8 x i32>
  %xb8 = zext <8 x i8> %b8 to <8 x i32>
  %xa16 = zext <16 x i8> %a16 to <16 x i32>
  %xb16 = zext <16 x i8> %b16 to <16 x i32>
  %xa32 = zext <32 x i8> %a32 to <32 x i32>
  %xb32 = zext <32 x i8> %b32 to <32 x i32>
  %xa64 = zext <64 x i8> %a64 to <64 x i32>
  %xb64 = zext <64 x i8> %b64 to <64 x i32>
  %res4 = mul <4 x i32> %xa4, %xb4
  %res8 = mul <8 x i32> %xa8, %xb8
  %res16 = mul <16 x i32> %xa16, %xb16
  %res32 = mul <32 x i32> %xa32, %xb32
  %res64 = mul <64 x i32> %xa64, %xb64
  ret void
}

define void @mul_sext_zext_vXi8(<4 x i8> %a4, <4 x i8> %b4, <8 x i8> %a8, <8 x i8> %b8, <16 x i8> %a16, <16 x i8> %b16, <32 x i8> %a32, <32 x i8> %b32, <64 x i8> %a64, <64 x i8> %b64)  {
; SSE2-LABEL: 'mul_sext_zext_vXi8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'mul_sext_zext_vXi8'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'mul_sext_zext_vXi8'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'mul_sext_zext_vXi8'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:8 SizeLat:6 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:16 SizeLat:12 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:32 SizeLat:24 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:40 Lat:64 SizeLat:48 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'mul_sext_zext_vXi8'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512F-LABEL: 'mul_sext_zext_vXi8'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512BW-LABEL: 'mul_sext_zext_vXi8'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLM-LABEL: 'mul_sext_zext_vXi8'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; GLM-LABEL: 'mul_sext_zext_vXi8'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i8> %a4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i8> %b4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i8> %a8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i8> %b8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i8> %a16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i8> %b16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i8> %a32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i8> %b32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i8> %a64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i8> %b64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %xa4 = sext <4 x i8> %a4 to <4 x i32>
  %xb4 = zext <4 x i8> %b4 to <4 x i32>
  %xa8 = sext <8 x i8> %a8 to <8 x i32>
  %xb8 = zext <8 x i8> %b8 to <8 x i32>
  %xa16 = sext <16 x i8> %a16 to <16 x i32>
  %xb16 = zext <16 x i8> %b16 to <16 x i32>
  %xa32 = sext <32 x i8> %a32 to <32 x i32>
  %xb32 = zext <32 x i8> %b32 to <32 x i32>
  %xa64 = sext <64 x i8> %a64 to <64 x i32>
  %xb64 = zext <64 x i8> %b64 to <64 x i32>
  %res4 = mul <4 x i32> %xa4, %xb4
  %res8 = mul <8 x i32> %xa8, %xb8
  %res16 = mul <16 x i32> %xa16, %xb16
  %res32 = mul <32 x i32> %xa32, %xb32
  %res64 = mul <64 x i32> %xa64, %xb64
  ret void
}

;
; mul vXi16 -> mXi32
;

define void @mul_sext_vXi16(<4 x i16> %a4, <4 x i16> %b4, <8 x i16> %a8, <8 x i16> %b8, <16 x i16> %a16, <16 x i16> %b16, <32 x i16> %a32, <32 x i16> %b32, <64 x i16> %a64, <64 x i16> %b64)  {
; SSE2-LABEL: 'mul_sext_vXi16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'mul_sext_vXi16'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'mul_sext_vXi16'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'mul_sext_vXi16'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:8 SizeLat:6 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:16 SizeLat:12 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:32 SizeLat:24 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:40 Lat:64 SizeLat:48 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'mul_sext_vXi16'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512F-LABEL: 'mul_sext_vXi16'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512BW-LABEL: 'mul_sext_vXi16'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLM-LABEL: 'mul_sext_vXi16'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; GLM-LABEL: 'mul_sext_vXi16'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = sext <4 x i16> %b4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = sext <8 x i16> %b8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = sext <16 x i16> %b16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = sext <32 x i16> %b32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = sext <64 x i16> %b64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %xa4 = sext <4 x i16> %a4 to <4 x i32>
  %xb4 = sext <4 x i16> %b4 to <4 x i32>
  %xa8 = sext <8 x i16> %a8 to <8 x i32>
  %xb8 = sext <8 x i16> %b8 to <8 x i32>
  %xa16 = sext <16 x i16> %a16 to <16 x i32>
  %xb16 = sext <16 x i16> %b16 to <16 x i32>
  %xa32 = sext <32 x i16> %a32 to <32 x i32>
  %xb32 = sext <32 x i16> %b32 to <32 x i32>
  %xa64 = sext <64 x i16> %a64 to <64 x i32>
  %xb64 = sext <64 x i16> %b64 to <64 x i32>
  %res4 = mul <4 x i32> %xa4, %xb4
  %res8 = mul <8 x i32> %xa8, %xb8
  %res16 = mul <16 x i32> %xa16, %xb16
  %res32 = mul <32 x i32> %xa32, %xb32
  %res64 = mul <64 x i32> %xa64, %xb64
  ret void
}

define void @mul_zext_vXi16(<4 x i16> %a4, <4 x i16> %b4, <8 x i16> %a8, <8 x i16> %b8, <16 x i16> %a16, <16 x i16> %b16, <32 x i16> %a32, <32 x i16> %b32, <64 x i16> %a64, <64 x i16> %b64)  {
; SSE2-LABEL: 'mul_zext_vXi16'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:16 SizeLat:14 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:32 SizeLat:28 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:56 Lat:64 SizeLat:56 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:112 Lat:128 SizeLat:112 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'mul_zext_vXi16'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:16 SizeLat:14 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:32 SizeLat:28 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:56 Lat:64 SizeLat:56 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:112 Lat:128 SizeLat:112 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'mul_zext_vXi16'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:88 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:176 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'mul_zext_vXi16'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:3 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:8 SizeLat:10 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:16 SizeLat:20 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:32 SizeLat:40 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:64 SizeLat:80 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'mul_zext_vXi16'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:10 SizeLat:2 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'mul_zext_vXi16'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:20 SizeLat:4 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:40 SizeLat:8 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLM-LABEL: 'mul_zext_vXi16'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 5 for: %res4 = mul <4 x i32> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found costs of 10 for: %res8 = mul <8 x i32> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found costs of 20 for: %res16 = mul <16 x i32> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found costs of 40 for: %res32 = mul <32 x i32> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found costs of 80 for: %res64 = mul <64 x i32> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; GLM-LABEL: 'mul_zext_vXi16'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = zext <4 x i16> %a4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = zext <8 x i16> %a8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = zext <16 x i16> %a16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = zext <32 x i16> %a32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = zext <64 x i16> %a64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:88 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:176 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %xa4 = zext <4 x i16> %a4 to <4 x i32>
  %xb4 = zext <4 x i16> %b4 to <4 x i32>
  %xa8 = zext <8 x i16> %a8 to <8 x i32>
  %xb8 = zext <8 x i16> %b8 to <8 x i32>
  %xa16 = zext <16 x i16> %a16 to <16 x i32>
  %xb16 = zext <16 x i16> %b16 to <16 x i32>
  %xa32 = zext <32 x i16> %a32 to <32 x i32>
  %xb32 = zext <32 x i16> %b32 to <32 x i32>
  %xa64 = zext <64 x i16> %a64 to <64 x i32>
  %xb64 = zext <64 x i16> %b64 to <64 x i32>
  %res4 = mul <4 x i32> %xa4, %xb4
  %res8 = mul <8 x i32> %xa8, %xb8
  %res16 = mul <16 x i32> %xa16, %xb16
  %res32 = mul <32 x i32> %xa32, %xb32
  %res64 = mul <64 x i32> %xa64, %xb64
  ret void
}

define void @mul_sext_zext_vXi16(<4 x i16> %a4, <4 x i16> %b4, <8 x i16> %a8, <8 x i16> %b8, <16 x i16> %a16, <16 x i16> %b16, <32 x i16> %a32, <32 x i16> %b32, <64 x i16> %a64, <64 x i16> %b64)  {
; SSE2-LABEL: 'mul_sext_zext_vXi16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:16 SizeLat:14 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:32 SizeLat:28 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:56 Lat:64 SizeLat:56 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:112 Lat:128 SizeLat:112 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'mul_sext_zext_vXi16'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:16 SizeLat:14 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:32 SizeLat:28 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:56 Lat:64 SizeLat:56 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:112 Lat:128 SizeLat:112 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'mul_sext_zext_vXi16'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:88 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:176 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'mul_sext_zext_vXi16'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:3 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:8 SizeLat:10 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:16 SizeLat:20 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:32 SizeLat:40 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:64 SizeLat:80 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'mul_sext_zext_vXi16'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:10 SizeLat:2 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:20 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:40 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:80 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'mul_sext_zext_vXi16'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res4 = mul <4 x i32> %xa4, %xb4
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %res16 = mul <16 x i32> %xa16, %xb16
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:20 SizeLat:4 for: %res32 = mul <32 x i32> %xa32, %xb32
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:40 SizeLat:8 for: %res64 = mul <64 x i32> %xa64, %xb64
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLM-LABEL: 'mul_sext_zext_vXi16'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; SLM-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:11 SizeLat:7 for: %res4 = mul <4 x i32> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:2 Lat:22 SizeLat:14 for: %res8 = mul <8 x i32> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:44 SizeLat:28 for: %res16 = mul <16 x i32> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:8 Lat:88 SizeLat:56 for: %res32 = mul <32 x i32> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found costs of RThru:176 CodeSize:16 Lat:176 SizeLat:112 for: %res64 = mul <64 x i32> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; GLM-LABEL: 'mul_sext_zext_vXi16'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xa4 = sext <4 x i16> %a4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 1 for: %xb4 = zext <4 x i16> %b4 to <4 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xa8 = sext <8 x i16> %a8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 2 for: %xb8 = zext <8 x i16> %b8 to <8 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xa16 = sext <16 x i16> %a16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 4 for: %xb16 = zext <16 x i16> %b16 to <16 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xa32 = sext <32 x i16> %a32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 8 for: %xb32 = zext <32 x i16> %b32 to <32 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xa64 = sext <64 x i16> %a64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of 16 for: %xb64 = zext <64 x i16> %b64 to <64 x i32>
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %res4 = mul <4 x i32> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %res8 = mul <8 x i32> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %res16 = mul <16 x i32> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:88 SizeLat:8 for: %res32 = mul <32 x i32> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:176 SizeLat:16 for: %res64 = mul <64 x i32> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %xa4 = sext <4 x i16> %a4 to <4 x i32>
  %xb4 = zext <4 x i16> %b4 to <4 x i32>
  %xa8 = sext <8 x i16> %a8 to <8 x i32>
  %xb8 = zext <8 x i16> %b8 to <8 x i32>
  %xa16 = sext <16 x i16> %a16 to <16 x i32>
  %xb16 = zext <16 x i16> %b16 to <16 x i32>
  %xa32 = sext <32 x i16> %a32 to <32 x i32>
  %xb32 = zext <32 x i16> %b32 to <32 x i32>
  %xa64 = sext <64 x i16> %a64 to <64 x i32>
  %xb64 = zext <64 x i16> %b64 to <64 x i32>
  %res4 = mul <4 x i32> %xa4, %xb4
  %res8 = mul <8 x i32> %xa8, %xb8
  %res16 = mul <16 x i32> %xa16, %xb16
  %res32 = mul <32 x i32> %xa32, %xb32
  %res64 = mul <64 x i32> %xa64, %xb64
  ret void
}
