; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare float    @llvm.minimum.f32(float %Val0, float %Val1)
declare float    @llvm.maximum.f32(float %Val0, float %Val1)
declare <4 x float>    @llvm.minimum.v4f32(<4 x float> %Val0, <4 x float> %Val1)
declare <4 x float>    @llvm.maximum.v4f32(<4 x float> %Val0, <4 x float> %Val1)

define float @test(float %a, float %b) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = fadd float [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %min = call float @llvm.minimum.f32(float %a, float %b)
  %max = call float @llvm.maximum.f32(float %a, float %b)
  %res = fadd float %min, %max
  ret float %res
}

define float @test_comm1(float %a, float %b) {
; CHECK-LABEL: @test_comm1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = fadd float [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %min = call float @llvm.minimum.f32(float %a, float %b)
  %max = call float @llvm.maximum.f32(float %a, float %b)
  %res = fadd float %max, %min
  ret float %res
}

define float @test_comm2(float %a, float %b) {
; CHECK-LABEL: @test_comm2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = fadd float [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %min = call float @llvm.minimum.f32(float %a, float %b)
  %max = call float @llvm.maximum.f32(float %b, float %a)
  %res = fadd float %min, %max
  ret float %res
}

define float @test_comm3(float %a, float %b) {
; CHECK-LABEL: @test_comm3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = fadd float [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %min = call float @llvm.minimum.f32(float %a, float %b)
  %max = call float @llvm.maximum.f32(float %b, float %a)
  %res = fadd float %max, %min
  ret float %res
}

define <4 x float> @test_vect(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: @test_vect(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = fadd <4 x float> [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    ret <4 x float> [[RES]]
;
entry:
  %min = call <4 x float> @llvm.minimum.v4f32(<4 x float> %a, <4 x float> %b)
  %max = call <4 x float> @llvm.maximum.v4f32(<4 x float> %b, <4 x float> %a)
  %res = fadd <4 x float> %min, %max
  ret <4 x float> %res
}

define float @test_flags(float %a, float %b) {
; CHECK-LABEL: @test_flags(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = fadd fast float [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %min = call float @llvm.minimum.f32(float %a, float %b)
  %max = call float @llvm.maximum.f32(float %a, float %b)
  %res = fadd fast float %min, %max
  ret float %res
}

define float @test_flags2(float %a, float %b) {
; CHECK-LABEL: @test_flags2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = fadd reassoc nsz arcp contract afn float [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %min = call float @llvm.minimum.f32(float %a, float %b)
  %max = call float @llvm.maximum.f32(float %a, float %b)
  %res = fadd reassoc ninf nsz arcp contract afn float %min, %max
  ret float %res
}
