/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_EPUBHTMLMANAGER_H
#define INCLUDED_EPUBHTMLMANAGER_H

#include <string>
#include <vector>

#include <librevenge/librevenge.h>

#include "EPUBCounter.h"
#include "EPUBHTMLGenerator.h"
#include "EPUBPath.h"
#include "EPUBXMLSink.h"

namespace libepubgen
{

class EPUBImageManager;
class EPUBListStyleManager;
class EPUBParagraphStyleManager;
class EPUBSpanStyleManager;
class EPUBTableStyleManager;
class EPUBManifest;
class EPUBPackage;

class EPUBHTMLManager
{
  // disable copying
  EPUBHTMLManager(const EPUBHTMLManager &);
  EPUBHTMLManager &operator=(const EPUBHTMLManager &);

public:
  explicit EPUBHTMLManager(EPUBManifest &manifest);

  const EPUBHTMLGeneratorPtr_t create(EPUBImageManager &imageManager, EPUBListStyleManager &listStyleManager, EPUBParagraphStyleManager &paragraphStyleManager, EPUBSpanStyleManager &spanStyleManager, EPUBTableStyleManager &tableStyleManager, const EPUBPath &stylesheetPath);

  void writeTo(EPUBPackage &package);

  void writeSpineTo(EPUBXMLSink &sink);
  void writeTocTo(EPUBXMLSink &sink, const EPUBPath &tocPath);

private:
  EPUBManifest &m_manifest;
  std::vector<EPUBPath> m_paths;
  std::vector<EPUBXMLSink> m_contents;
  std::vector<std::string> m_ids;
  EPUBCounter m_number;
};

}

#endif // INCLUDED_EPUBHTMLMANAGER

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
