/*
    Large image displaying library.

    Copyright (C) 2004,2005 Maks Orlovich (maksim@kde.org)

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
    AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
    AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef PIXMAP_TILE_H
#define PIXMAP_TILE_H

#include <QPixmap>
#include <cstring>

#include "tile.h"
#include "imagemanager.h"

namespace khtmlImLoad
{

class PixmapTile: public Tile
{
public:
    QPixmap       *pixmap;

    void discard() Q_DECL_OVERRIDE
    {
        delete pixmap;
        pixmap = nullptr;
    }

    PixmapTile() : pixmap(nullptr)
    {}

    virtual ~PixmapTile()
    {
        if (cacheNode) {
            ImageManager::pixmapCache()->removeEntry(this);
        }
        delete pixmap;
    }
};

}

#endif
