with Ada.Unchecked_Conversion;
with Atree; use Atree; use Atree.Atree_Private_Part;
with Nlists; use Nlists;
pragma Warnings (Off);
with Einfo.Utils; use Einfo.Utils;
with Sinfo.Utils; use Sinfo.Utils;
pragma Warnings (On);

package body Sinfo.Nodes is

   --  This package is automatically generated.

   pragma Style_Checks ("M200");
   function Cast is new Ada.Unchecked_Conversion (Flag, Field_Size_1_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_1_Bit, Flag);
   function Cast is new Ada.Unchecked_Conversion (Node_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Node_Id);
   function Cast is new Ada.Unchecked_Conversion (List_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, List_Id);
   function Cast is new Ada.Unchecked_Conversion (Elist_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Elist_Id);
   function Cast is new Ada.Unchecked_Conversion (Name_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Name_Id);
   function Cast is new Ada.Unchecked_Conversion (String_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, String_Id);
   function Cast is new Ada.Unchecked_Conversion (Uint, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Uint);
   function Cast is new Ada.Unchecked_Conversion (Ureal, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Ureal);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_8_Bit, Node_Kind);
   function Cast is new Ada.Unchecked_Conversion (Source_Ptr, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Source_Ptr);
   function Cast is new Ada.Unchecked_Conversion (Small_Paren_Count_Type, Field_Size_2_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_2_Bit, Small_Paren_Count_Type);
   function Cast is new Ada.Unchecked_Conversion (Union_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Union_Id);

   --  Getters and setters for fields

   function Nkind (N : Node_Id) return Node_Kind is
      --  4  8-bit fields per 32-bit slot.
      --  Offset 0 = 0 slots + 0 fields in slot.

      Off : constant := 0;
      F_Size : constant := 8;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_8_Bit :=
        Field_Size_8_Bit (Shift_Right (S, V) and Mask);
      Val : constant Node_Kind := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Nkind;

   function Sloc (N : Node_Id) return Source_Ptr is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 3 = 3 slots + 0 fields in slot.

      Off : constant := 3;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Source_Ptr := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Sloc;

   procedure Set_Sloc (N : Node_Id; Val : Source_Ptr) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 3 = 3 slots + 0 fields in slot.

      Off : constant := 3;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Sloc;

   function In_List (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 20 = 0 slots + 20 fields in slot.

      Off : constant := 20;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end In_List;

   procedure Set_In_List (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 20 = 0 slots + 20 fields in slot.

      Off : constant := 20;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_In_List;

   function Rewrite_Ins (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 21 = 0 slots + 21 fields in slot.

      Off : constant := 21;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Rewrite_Ins;

   procedure Set_Rewrite_Ins (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 21 = 0 slots + 21 fields in slot.

      Off : constant := 21;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Rewrite_Ins;

   function Comes_From_Source (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 22 = 0 slots + 22 fields in slot.

      Off : constant := 22;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Comes_From_Source;

   procedure Set_Comes_From_Source (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 22 = 0 slots + 22 fields in slot.

      Off : constant := 22;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Comes_From_Source;

   function Analyzed (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 23 = 0 slots + 23 fields in slot.

      Off : constant := 23;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Analyzed;

   procedure Set_Analyzed (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 23 = 0 slots + 23 fields in slot.

      Off : constant := 23;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Analyzed;

   function Error_Posted (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 24 = 0 slots + 24 fields in slot.

      Off : constant := 24;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Error_Posted;

   procedure Set_Error_Posted (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 24 = 0 slots + 24 fields in slot.

      Off : constant := 24;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Error_Posted;

   function Small_Paren_Count (N : Node_Id) return Small_Paren_Count_Type is
      --  16  2-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 2;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_2_Bit :=
        Field_Size_2_Bit (Shift_Right (S, V) and Mask);
      Val : constant Small_Paren_Count_Type := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Small_Paren_Count;

   procedure Set_Small_Paren_Count (N : Node_Id; Val : Small_Paren_Count_Type) is
      --  16  2-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 2;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_2_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Small_Paren_Count;

   function Check_Actuals (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 25 = 0 slots + 25 fields in slot.

      Off : constant := 25;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Check_Actuals;

   procedure Set_Check_Actuals (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 25 = 0 slots + 25 fields in slot.

      Off : constant := 25;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Check_Actuals;

   function Has_Aspects (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 28 = 0 slots + 28 fields in slot.

      Off : constant := 28;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Aspects;

   procedure Set_Has_Aspects (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 28 = 0 slots + 28 fields in slot.

      Off : constant := 28;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Aspects;

   function Is_Ignored_Ghost_Node (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 29 = 0 slots + 29 fields in slot.

      Off : constant := 29;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ignored_Ghost_Node;

   procedure Set_Is_Ignored_Ghost_Node (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 29 = 0 slots + 29 fields in slot.

      Off : constant := 29;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ignored_Ghost_Node;

   function Link (N : Node_Id) return Union_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 4 = 4 slots + 0 fields in slot.

      Off : constant := 4;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Union_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Link;

   procedure Set_Link (N : Node_Id; Val : Union_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 4 = 4 slots + 0 fields in slot.

      Off : constant := 4;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Link;

   function Abort_Present (N : N_Requeue_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Abort_Present;

   procedure Set_Abort_Present (N : N_Requeue_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Abort_Present;

   function Abortable_Part (N : N_Asynchronous_Select_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Abortable_Part;

   procedure Set_Abortable_Part (N : N_Asynchronous_Select_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Abortable_Part;

   function Abstract_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Abstract_Present;

   procedure Set_Abstract_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Abstract_Present;

   function Accept_Handler_Records (N : N_Accept_Alternative_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Accept_Handler_Records;

   procedure Set_Accept_Handler_Records (N : N_Accept_Alternative_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Accept_Handler_Records;

   function Accept_Statement (N : N_Accept_Alternative_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Accept_Statement;

   procedure Set_Accept_Statement (N : N_Accept_Alternative_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Accept_Statement;

   function Access_Definition (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Access_Definition;

   procedure Set_Access_Definition (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Access_Definition;

   function Access_To_Subprogram_Definition (N : N_Access_Definition_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Access_To_Subprogram_Definition;

   procedure Set_Access_To_Subprogram_Definition (N : N_Access_Definition_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Access_To_Subprogram_Definition;

   function Access_Types_To_Process (N : N_Freeze_Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Access_Types_To_Process;

   procedure Set_Access_Types_To_Process (N : N_Freeze_Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Access_Types_To_Process;

   function Actions (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Actions;

   procedure Set_Actions (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Actions;

   function Activation_Chain_Entity (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Activation_Chain_Entity;

   procedure Set_Activation_Chain_Entity (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Activation_Chain_Entity;

   function Acts_As_Spec (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Acts_As_Spec;

   procedure Set_Acts_As_Spec (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Acts_As_Spec;

   function Actual_Designated_Subtype (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Actual_Designated_Subtype;

   procedure Set_Actual_Designated_Subtype (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Actual_Designated_Subtype;

   function Address_Warning_Posted (N : N_Attribute_Definition_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Address_Warning_Posted;

   procedure Set_Address_Warning_Posted (N : N_Attribute_Definition_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Address_Warning_Posted;

   function Aggregate_Bounds (N : N_Aggregate_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Aggregate_Bounds;

   procedure Set_Aggregate_Bounds (N : N_Aggregate_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Aggregate_Bounds;

   function Aliased_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Aliased_Present;

   procedure Set_Aliased_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Aliased_Present;

   function All_Others (N : N_Others_Choice_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end All_Others;

   procedure Set_All_Others (N : N_Others_Choice_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_All_Others;

   function All_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end All_Present;

   procedure Set_All_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_All_Present;

   function Alternatives (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Alternatives;

   procedure Set_Alternatives (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Alternatives;

   function Ancestor_Part (N : N_Extension_Aggregate_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Ancestor_Part;

   procedure Set_Ancestor_Part (N : N_Extension_Aggregate_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Ancestor_Part;

   function Atomic_Sync_Required (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Atomic_Sync_Required;

   procedure Set_Atomic_Sync_Required (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Atomic_Sync_Required;

   function Array_Aggregate (N : N_Enumeration_Representation_Clause_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Array_Aggregate;

   procedure Set_Array_Aggregate (N : N_Enumeration_Representation_Clause_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Array_Aggregate;

   function Aspect_On_Partial_View (N : N_Aspect_Specification_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Aspect_On_Partial_View;

   procedure Set_Aspect_On_Partial_View (N : N_Aspect_Specification_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Aspect_On_Partial_View;

   function Aspect_Rep_Item (N : N_Aspect_Specification_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Aspect_Rep_Item;

   procedure Set_Aspect_Rep_Item (N : N_Aspect_Specification_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Aspect_Rep_Item;

   function Assignment_OK (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Assignment_OK;

   procedure Set_Assignment_OK (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Assignment_OK;

   function Attribute_Name (N : N_Attribute_Reference_Id) return Name_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Name_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Attribute_Name;

   procedure Set_Attribute_Name (N : N_Attribute_Reference_Id; Val : Name_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Attribute_Name;

   function At_End_Proc (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end At_End_Proc;

   procedure Set_At_End_Proc (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_At_End_Proc;

   function Aux_Decls_Node (N : N_Compilation_Unit_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Aux_Decls_Node;

   procedure Set_Aux_Decls_Node (N : N_Compilation_Unit_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Aux_Decls_Node;

   function Backwards_OK (N : N_Assignment_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Backwards_OK;

   procedure Set_Backwards_OK (N : N_Assignment_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Backwards_OK;

   function Bad_Is_Detected (N : N_Subprogram_Body_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Bad_Is_Detected;

   procedure Set_Bad_Is_Detected (N : N_Subprogram_Body_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Bad_Is_Detected;

   function Binding_Chars (N : N_Component_Association_Id) return Name_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Name_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Binding_Chars;

   procedure Set_Binding_Chars (N : N_Component_Association_Id; Val : Name_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Binding_Chars;

   function Body_Required (N : N_Compilation_Unit_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Body_Required;

   procedure Set_Body_Required (N : N_Compilation_Unit_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Body_Required;

   function Body_To_Inline (N : N_Subprogram_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Body_To_Inline;

   procedure Set_Body_To_Inline (N : N_Subprogram_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Body_To_Inline;

   function Box_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Box_Present;

   procedure Set_Box_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Box_Present;

   function Char_Literal_Value (N : N_Character_Literal_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Char_Literal_Value;

   procedure Set_Char_Literal_Value (N : N_Character_Literal_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Char_Literal_Value;

   function Chars (N : Node_Id) return Name_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Name_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Chars;

   procedure Set_Chars (N : Node_Id; Val : Name_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Chars;

   function Check_Address_Alignment (N : N_Attribute_Definition_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Check_Address_Alignment;

   procedure Set_Check_Address_Alignment (N : N_Attribute_Definition_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Check_Address_Alignment;

   function Choice_Parameter (N : N_Exception_Handler_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Choice_Parameter;

   procedure Set_Choice_Parameter (N : N_Exception_Handler_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Choice_Parameter;

   function Choices (N : N_Component_Association_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Choices;

   procedure Set_Choices (N : N_Component_Association_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Choices;

   function Class_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Class_Present;

   procedure Set_Class_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Class_Present;

   function Classifications (N : N_Contract_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Classifications;

   procedure Set_Classifications (N : N_Contract_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Classifications;

   function Cleanup_Actions (N : N_Block_Statement_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Cleanup_Actions;

   procedure Set_Cleanup_Actions (N : N_Block_Statement_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Cleanup_Actions;

   function Comes_From_Check_Or_Contract (N : N_If_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Comes_From_Check_Or_Contract;

   procedure Set_Comes_From_Check_Or_Contract (N : N_If_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Comes_From_Check_Or_Contract;

   function Comes_From_Extended_Return_Statement (N : N_Simple_Return_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Comes_From_Extended_Return_Statement;

   procedure Set_Comes_From_Extended_Return_Statement (N : N_Simple_Return_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Comes_From_Extended_Return_Statement;

   function Comes_From_Iterator (N : N_Object_Renaming_Declaration_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Comes_From_Iterator;

   procedure Set_Comes_From_Iterator (N : N_Object_Renaming_Declaration_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Comes_From_Iterator;

   function Compile_Time_Known_Aggregate (N : N_Aggregate_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Compile_Time_Known_Aggregate;

   procedure Set_Compile_Time_Known_Aggregate (N : N_Aggregate_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Compile_Time_Known_Aggregate;

   function Component_Associations (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Associations;

   procedure Set_Component_Associations (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Component_Associations;

   function Component_Clauses (N : N_Record_Representation_Clause_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Clauses;

   procedure Set_Component_Clauses (N : N_Record_Representation_Clause_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Component_Clauses;

   function Component_Definition (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Definition;

   procedure Set_Component_Definition (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Component_Definition;

   function Component_Items (N : N_Component_List_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Items;

   procedure Set_Component_Items (N : N_Component_List_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Component_Items;

   function Component_List (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_List;

   procedure Set_Component_List (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Component_List;

   function Component_Name (N : N_Component_Clause_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Name;

   procedure Set_Component_Name (N : N_Component_Clause_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Component_Name;

   function Componentwise_Assignment (N : N_Assignment_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Componentwise_Assignment;

   procedure Set_Componentwise_Assignment (N : N_Assignment_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Componentwise_Assignment;

   function Condition (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Condition;

   procedure Set_Condition (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Condition;

   function Condition_Actions (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Condition_Actions;

   procedure Set_Condition_Actions (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Condition_Actions;

   function Config_Pragmas (N : N_Compilation_Unit_Aux_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Config_Pragmas;

   procedure Set_Config_Pragmas (N : N_Compilation_Unit_Aux_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Config_Pragmas;

   function Constant_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Constant_Present;

   procedure Set_Constant_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Constant_Present;

   function Constraint (N : N_Subtype_Indication_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Constraint;

   procedure Set_Constraint (N : N_Subtype_Indication_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Constraint;

   function Constraints (N : N_Index_Or_Discriminant_Constraint_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Constraints;

   procedure Set_Constraints (N : N_Index_Or_Discriminant_Constraint_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Constraints;

   function Context_Installed (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Context_Installed;

   procedure Set_Context_Installed (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Context_Installed;

   function Context_Items (N : N_Compilation_Unit_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Context_Items;

   procedure Set_Context_Items (N : N_Compilation_Unit_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Context_Items;

   function Context_Pending (N : N_Compilation_Unit_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Context_Pending;

   procedure Set_Context_Pending (N : N_Compilation_Unit_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Context_Pending;

   function Contract_Test_Cases (N : N_Contract_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Contract_Test_Cases;

   procedure Set_Contract_Test_Cases (N : N_Contract_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Contract_Test_Cases;

   function Controlling_Argument (N : N_Subprogram_Call_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Controlling_Argument;

   procedure Set_Controlling_Argument (N : N_Subprogram_Call_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Controlling_Argument;

   function Conversion_OK (N : N_Type_Conversion_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Conversion_OK;

   procedure Set_Conversion_OK (N : N_Type_Conversion_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Conversion_OK;

   function Corresponding_Aspect (N : N_Pragma_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Aspect;

   procedure Set_Corresponding_Aspect (N : N_Pragma_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Aspect;

   function Corresponding_Body (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Body;

   procedure Set_Corresponding_Body (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Body;

   function Corresponding_Entry_Body (N : N_Subprogram_Body_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 9 = 9 slots + 0 fields in slot.

      Off : constant := 9;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Entry_Body;

   procedure Set_Corresponding_Entry_Body (N : N_Subprogram_Body_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 9 = 9 slots + 0 fields in slot.

      Off : constant := 9;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Entry_Body;

   function Corresponding_Formal_Spec (N : N_Subprogram_Renaming_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Formal_Spec;

   procedure Set_Corresponding_Formal_Spec (N : N_Subprogram_Renaming_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Formal_Spec;

   function Corresponding_Generic_Association (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Generic_Association;

   procedure Set_Corresponding_Generic_Association (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Generic_Association;

   function Corresponding_Integer_Value (N : N_Real_Literal_Id) return Valid_Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Valid_Uint := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Integer_Value;

   procedure Set_Corresponding_Integer_Value (N : N_Real_Literal_Id; Val : Valid_Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Integer_Value;

   function Corresponding_Spec (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Spec;

   procedure Set_Corresponding_Spec (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Spec;

   function Corresponding_Spec_Of_Stub (N : N_Body_Stub_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Spec_Of_Stub;

   procedure Set_Corresponding_Spec_Of_Stub (N : N_Body_Stub_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Spec_Of_Stub;

   function Corresponding_Stub (N : N_Subunit_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Stub;

   procedure Set_Corresponding_Stub (N : N_Subunit_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Stub;

   function Dcheck_Function (N : N_Variant_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Dcheck_Function;

   procedure Set_Dcheck_Function (N : N_Variant_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Dcheck_Function;

   function Declarations (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Declarations;

   procedure Set_Declarations (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Declarations;

   function Default_Expression (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Expression;

   procedure Set_Default_Expression (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Default_Expression;

   function Default_Storage_Pool (N : N_Compilation_Unit_Aux_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Storage_Pool;

   procedure Set_Default_Storage_Pool (N : N_Compilation_Unit_Aux_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Default_Storage_Pool;

   function Default_Name (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Name;

   procedure Set_Default_Name (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Default_Name;

   function Default_Subtype_Mark (N : N_Formal_Type_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Subtype_Mark;

   procedure Set_Default_Subtype_Mark (N : N_Formal_Type_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Default_Subtype_Mark;

   function Defining_Identifier (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Defining_Identifier;

   procedure Set_Defining_Identifier (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Defining_Identifier;

   function Defining_Unit_Name (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Defining_Unit_Name;

   procedure Set_Defining_Unit_Name (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Defining_Unit_Name;

   function Delay_Alternative (N : N_Timed_Entry_Call_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Delay_Alternative;

   procedure Set_Delay_Alternative (N : N_Timed_Entry_Call_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Delay_Alternative;

   function Delay_Statement (N : N_Delay_Alternative_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Delay_Statement;

   procedure Set_Delay_Statement (N : N_Delay_Alternative_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Delay_Statement;

   function Delta_Expression (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Delta_Expression;

   procedure Set_Delta_Expression (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Delta_Expression;

   function Digits_Expression (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Digits_Expression;

   procedure Set_Digits_Expression (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Digits_Expression;

   function Discr_Check_Funcs_Built (N : N_Full_Type_Declaration_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discr_Check_Funcs_Built;

   procedure Set_Discr_Check_Funcs_Built (N : N_Full_Type_Declaration_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Discr_Check_Funcs_Built;

   function Discrete_Choices (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discrete_Choices;

   procedure Set_Discrete_Choices (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Discrete_Choices;

   function Discrete_Range (N : N_Slice_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discrete_Range;

   procedure Set_Discrete_Range (N : N_Slice_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Discrete_Range;

   function Discrete_Subtype_Definition (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discrete_Subtype_Definition;

   procedure Set_Discrete_Subtype_Definition (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Discrete_Subtype_Definition;

   function Discrete_Subtype_Definitions (N : N_Constrained_Array_Definition_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discrete_Subtype_Definitions;

   procedure Set_Discrete_Subtype_Definitions (N : N_Constrained_Array_Definition_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Discrete_Subtype_Definitions;

   function Discriminant_Specifications (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discriminant_Specifications;

   procedure Set_Discriminant_Specifications (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Discriminant_Specifications;

   function Discriminant_Type (N : N_Discriminant_Specification_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discriminant_Type;

   procedure Set_Discriminant_Type (N : N_Discriminant_Specification_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Discriminant_Type;

   function Do_Discriminant_Check (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Do_Discriminant_Check;

   procedure Set_Do_Discriminant_Check (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Do_Discriminant_Check;

   function Do_Division_Check (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Do_Division_Check;

   procedure Set_Do_Division_Check (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Do_Division_Check;

   function Do_Length_Check (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Do_Length_Check;

   procedure Set_Do_Length_Check (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Do_Length_Check;

   function Do_Overflow_Check (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Do_Overflow_Check;

   procedure Set_Do_Overflow_Check (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Do_Overflow_Check;

   function Do_Range_Check (N : N_Subexpr_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Do_Range_Check;

   procedure Set_Do_Range_Check (N : N_Subexpr_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Do_Range_Check;

   function Do_Storage_Check (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Do_Storage_Check;

   procedure Set_Do_Storage_Check (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Do_Storage_Check;

   function Elaborate_All_Desirable (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elaborate_All_Desirable;

   procedure Set_Elaborate_All_Desirable (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Elaborate_All_Desirable;

   function Elaborate_All_Present (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elaborate_All_Present;

   procedure Set_Elaborate_All_Present (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Elaborate_All_Present;

   function Elaborate_Desirable (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elaborate_Desirable;

   procedure Set_Elaborate_Desirable (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Elaborate_Desirable;

   function Elaborate_Present (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elaborate_Present;

   procedure Set_Elaborate_Present (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Elaborate_Present;

   function Else_Actions (N : N_If_Expression_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Else_Actions;

   procedure Set_Else_Actions (N : N_If_Expression_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Else_Actions;

   function Else_Statements (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Else_Statements;

   procedure Set_Else_Statements (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Else_Statements;

   function Elsif_Parts (N : N_If_Statement_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elsif_Parts;

   procedure Set_Elsif_Parts (N : N_If_Statement_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Elsif_Parts;

   function Enclosing_Variant (N : N_Variant_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Enclosing_Variant;

   procedure Set_Enclosing_Variant (N : N_Variant_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Enclosing_Variant;

   function End_Label (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end End_Label;

   procedure Set_End_Label (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_End_Label;

   function End_Span (N : Node_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end End_Span;

   procedure Set_End_Span (N : Node_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_End_Span;

   function Entity_Or_Associated_Node (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entity_Or_Associated_Node;

   procedure Set_Entity_Or_Associated_Node (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Entity_Or_Associated_Node;

   function Entry_Body_Formal_Part (N : N_Entry_Body_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Body_Formal_Part;

   procedure Set_Entry_Body_Formal_Part (N : N_Entry_Body_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Entry_Body_Formal_Part;

   function Entry_Call_Alternative (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Call_Alternative;

   procedure Set_Entry_Call_Alternative (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Entry_Call_Alternative;

   function Entry_Call_Statement (N : N_Entry_Call_Alternative_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Call_Statement;

   procedure Set_Entry_Call_Statement (N : N_Entry_Call_Alternative_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Entry_Call_Statement;

   function Entry_Direct_Name (N : N_Accept_Statement_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Direct_Name;

   procedure Set_Entry_Direct_Name (N : N_Accept_Statement_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Entry_Direct_Name;

   function Entry_Index (N : N_Accept_Statement_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Index;

   procedure Set_Entry_Index (N : N_Accept_Statement_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Entry_Index;

   function Entry_Index_Specification (N : N_Entry_Body_Formal_Part_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Index_Specification;

   procedure Set_Entry_Index_Specification (N : N_Entry_Body_Formal_Part_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Entry_Index_Specification;

   function Etype (N : N_Has_Etype_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Etype;

   procedure Set_Etype (N : N_Has_Etype_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Etype;

   function Exception_Choices (N : N_Exception_Handler_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Exception_Choices;

   procedure Set_Exception_Choices (N : N_Exception_Handler_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Exception_Choices;

   function Exception_Handlers (N : N_Handled_Sequence_Of_Statements_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Exception_Handlers;

   procedure Set_Exception_Handlers (N : N_Handled_Sequence_Of_Statements_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Exception_Handlers;

   function Exception_Junk (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Exception_Junk;

   procedure Set_Exception_Junk (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Exception_Junk;

   function Exception_Label (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Exception_Label;

   procedure Set_Exception_Label (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Exception_Label;

   function Expansion_Delayed (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Expansion_Delayed;

   procedure Set_Expansion_Delayed (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Expansion_Delayed;

   function Explicit_Actual_Parameter (N : N_Parameter_Association_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Explicit_Actual_Parameter;

   procedure Set_Explicit_Actual_Parameter (N : N_Parameter_Association_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Explicit_Actual_Parameter;

   function Explicit_Generic_Actual_Parameter (N : N_Generic_Association_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Explicit_Generic_Actual_Parameter;

   procedure Set_Explicit_Generic_Actual_Parameter (N : N_Generic_Association_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Explicit_Generic_Actual_Parameter;

   function Expression (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Expression;

   procedure Set_Expression (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Expression;

   function Expression_Copy (N : N_Pragma_Argument_Association_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Expression_Copy;

   procedure Set_Expression_Copy (N : N_Pragma_Argument_Association_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Expression_Copy;

   function Expressions (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Expressions;

   procedure Set_Expressions (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Expressions;

   function First_Bit (N : N_Component_Clause_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Bit;

   procedure Set_First_Bit (N : N_Component_Clause_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_First_Bit;

   function First_Inlined_Subprogram (N : N_Compilation_Unit_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Inlined_Subprogram;

   procedure Set_First_Inlined_Subprogram (N : N_Compilation_Unit_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Inlined_Subprogram;

   function First_Name (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Name;

   procedure Set_First_Name (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_First_Name;

   function First_Named_Actual (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Named_Actual;

   procedure Set_First_Named_Actual (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Named_Actual;

   function First_Subtype_Link (N : N_Freeze_Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Subtype_Link;

   procedure Set_First_Subtype_Link (N : N_Freeze_Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Subtype_Link;

   function Float_Truncate (N : N_Type_Conversion_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Float_Truncate;

   procedure Set_Float_Truncate (N : N_Type_Conversion_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Float_Truncate;

   function Formal_Type_Definition (N : N_Formal_Type_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Formal_Type_Definition;

   procedure Set_Formal_Type_Definition (N : N_Formal_Type_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Formal_Type_Definition;

   function Forwards_OK (N : N_Assignment_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Forwards_OK;

   procedure Set_Forwards_OK (N : N_Assignment_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Forwards_OK;

   function For_Special_Return_Object (N : N_Allocator_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end For_Special_Return_Object;

   procedure Set_For_Special_Return_Object (N : N_Allocator_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_For_Special_Return_Object;

   function From_Aspect_Specification (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end From_Aspect_Specification;

   procedure Set_From_Aspect_Specification (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_From_Aspect_Specification;

   function From_At_Mod (N : N_Attribute_Definition_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end From_At_Mod;

   procedure Set_From_At_Mod (N : N_Attribute_Definition_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_From_At_Mod;

   function From_Conditional_Expression (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end From_Conditional_Expression;

   procedure Set_From_Conditional_Expression (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_From_Conditional_Expression;

   function From_Default (N : N_Subprogram_Renaming_Declaration_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end From_Default;

   procedure Set_From_Default (N : N_Subprogram_Renaming_Declaration_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_From_Default;

   function Generalized_Indexing (N : N_Indexed_Component_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Generalized_Indexing;

   procedure Set_Generalized_Indexing (N : N_Indexed_Component_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Generalized_Indexing;

   function Generic_Associations (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Generic_Associations;

   procedure Set_Generic_Associations (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Generic_Associations;

   function Generic_Formal_Declarations (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Generic_Formal_Declarations;

   procedure Set_Generic_Formal_Declarations (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Generic_Formal_Declarations;

   function Generic_Parent (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Generic_Parent;

   procedure Set_Generic_Parent (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Generic_Parent;

   function Generic_Parent_Type (N : N_Subtype_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Generic_Parent_Type;

   procedure Set_Generic_Parent_Type (N : N_Subtype_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Generic_Parent_Type;

   function Handled_Statement_Sequence (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Handled_Statement_Sequence;

   procedure Set_Handled_Statement_Sequence (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Handled_Statement_Sequence;

   function Handler_List_Entry (N : N_Object_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Handler_List_Entry;

   procedure Set_Handler_List_Entry (N : N_Object_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Handler_List_Entry;

   function Has_Created_Identifier (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Created_Identifier;

   procedure Set_Has_Created_Identifier (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Created_Identifier;

   function Has_Dereference_Action (N : N_Explicit_Dereference_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Dereference_Action;

   procedure Set_Has_Dereference_Action (N : N_Explicit_Dereference_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Dereference_Action;

   function Has_Dynamic_Length_Check (N : N_Subexpr_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Dynamic_Length_Check;

   procedure Set_Has_Dynamic_Length_Check (N : N_Subexpr_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Dynamic_Length_Check;

   function Has_Init_Expression (N : N_Object_Declaration_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Init_Expression;

   procedure Set_Has_Init_Expression (N : N_Object_Declaration_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Init_Expression;

   function Has_Local_Raise (N : N_Exception_Handler_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Local_Raise;

   procedure Set_Has_Local_Raise (N : N_Exception_Handler_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Local_Raise;

   function Has_No_Elaboration_Code (N : N_Compilation_Unit_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_No_Elaboration_Code;

   procedure Set_Has_No_Elaboration_Code (N : N_Compilation_Unit_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_No_Elaboration_Code;

   function Has_Pragma_Suppress_All (N : N_Compilation_Unit_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Suppress_All;

   procedure Set_Has_Pragma_Suppress_All (N : N_Compilation_Unit_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Suppress_All;

   function Has_Private_View (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Private_View;

   procedure Set_Has_Private_View (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Private_View;

   function Has_Relative_Deadline_Pragma (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Relative_Deadline_Pragma;

   procedure Set_Has_Relative_Deadline_Pragma (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Relative_Deadline_Pragma;

   function Has_Self_Reference (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Self_Reference;

   procedure Set_Has_Self_Reference (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Self_Reference;

   function Has_SP_Choice (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_SP_Choice;

   procedure Set_Has_SP_Choice (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_SP_Choice;

   function Has_Storage_Size_Pragma (N : N_Task_Definition_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Storage_Size_Pragma;

   procedure Set_Has_Storage_Size_Pragma (N : N_Task_Definition_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Storage_Size_Pragma;

   function Has_Target_Names (N : N_Assignment_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Target_Names;

   procedure Set_Has_Target_Names (N : N_Assignment_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Target_Names;

   function Has_Wide_Character (N : N_String_Literal_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Wide_Character;

   procedure Set_Has_Wide_Character (N : N_String_Literal_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Wide_Character;

   function Has_Wide_Wide_Character (N : N_String_Literal_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Wide_Wide_Character;

   procedure Set_Has_Wide_Wide_Character (N : N_String_Literal_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Wide_Wide_Character;

   function Header_Size_Added (N : N_Attribute_Reference_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Header_Size_Added;

   procedure Set_Header_Size_Added (N : N_Attribute_Reference_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Header_Size_Added;

   function Hidden_By_Use_Clause (N : Node_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Hidden_By_Use_Clause;

   procedure Set_Hidden_By_Use_Clause (N : Node_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Hidden_By_Use_Clause;

   function High_Bound (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end High_Bound;

   procedure Set_High_Bound (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_High_Bound;

   function Identifier (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Identifier;

   procedure Set_Identifier (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Identifier;

   function Interface_List (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Interface_List;

   procedure Set_Interface_List (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Interface_List;

   function Interface_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Interface_Present;

   procedure Set_Interface_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Interface_Present;

   function Implicit_With (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Implicit_With;

   procedure Set_Implicit_With (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Implicit_With;

   function Import_Interface_Present (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Import_Interface_Present;

   procedure Set_Import_Interface_Present (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Import_Interface_Present;

   function In_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end In_Present;

   procedure Set_In_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_In_Present;

   function Includes_Infinities (N : N_Range_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Includes_Infinities;

   procedure Set_Includes_Infinities (N : N_Range_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Includes_Infinities;

   function Incomplete_View (N : N_Full_Type_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Incomplete_View;

   procedure Set_Incomplete_View (N : N_Full_Type_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Incomplete_View;

   function Inherited_Discriminant (N : N_Component_Association_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Inherited_Discriminant;

   procedure Set_Inherited_Discriminant (N : N_Component_Association_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Inherited_Discriminant;

   function Instance_Spec (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Instance_Spec;

   procedure Set_Instance_Spec (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Instance_Spec;

   function Intval (N : N_Integer_Literal_Id) return Valid_Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Valid_Uint := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Intval;

   procedure Set_Intval (N : N_Integer_Literal_Id; Val : Valid_Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Intval;

   function Is_Abort_Block (N : N_Block_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Abort_Block;

   procedure Set_Is_Abort_Block (N : N_Block_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Abort_Block;

   function Is_Accessibility_Actual (N : N_Parameter_Association_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Accessibility_Actual;

   procedure Set_Is_Accessibility_Actual (N : N_Parameter_Association_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Accessibility_Actual;

   function Is_Analyzed_Pragma (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Analyzed_Pragma;

   procedure Set_Is_Analyzed_Pragma (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Analyzed_Pragma;

   function Is_Asynchronous_Call_Block (N : N_Block_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Asynchronous_Call_Block;

   procedure Set_Is_Asynchronous_Call_Block (N : N_Block_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Asynchronous_Call_Block;

   function Is_Boolean_Aspect (N : N_Aspect_Specification_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Boolean_Aspect;

   procedure Set_Is_Boolean_Aspect (N : N_Aspect_Specification_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Boolean_Aspect;

   function Is_Checked (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Checked;

   procedure Set_Is_Checked (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Checked;

   function Is_Checked_Ghost_Pragma (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Checked_Ghost_Pragma;

   procedure Set_Is_Checked_Ghost_Pragma (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Checked_Ghost_Pragma;

   function Is_Component_Left_Opnd (N : N_Op_Concat_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Component_Left_Opnd;

   procedure Set_Is_Component_Left_Opnd (N : N_Op_Concat_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Component_Left_Opnd;

   function Is_Component_Right_Opnd (N : N_Op_Concat_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Component_Right_Opnd;

   procedure Set_Is_Component_Right_Opnd (N : N_Op_Concat_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Component_Right_Opnd;

   function Is_Controlling_Actual (N : N_Subexpr_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Controlling_Actual;

   procedure Set_Is_Controlling_Actual (N : N_Subexpr_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Controlling_Actual;

   function Is_Declaration_Level_Node (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Declaration_Level_Node;

   procedure Set_Is_Declaration_Level_Node (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Declaration_Level_Node;

   function Is_Delayed_Aspect (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Delayed_Aspect;

   procedure Set_Is_Delayed_Aspect (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Delayed_Aspect;

   function Is_Disabled (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Disabled;

   procedure Set_Is_Disabled (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Disabled;

   function Is_Dispatching_Call (N : N_Call_Marker_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Dispatching_Call;

   procedure Set_Is_Dispatching_Call (N : N_Call_Marker_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Dispatching_Call;

   function Is_Dynamic_Coextension (N : N_Allocator_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Dynamic_Coextension;

   procedure Set_Is_Dynamic_Coextension (N : N_Allocator_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Dynamic_Coextension;

   function Is_Effective_Use_Clause (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Effective_Use_Clause;

   procedure Set_Is_Effective_Use_Clause (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Effective_Use_Clause;

   function Is_Elaboration_Checks_OK_Node (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Elaboration_Checks_OK_Node;

   procedure Set_Is_Elaboration_Checks_OK_Node (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Elaboration_Checks_OK_Node;

   function Is_Elaboration_Code (N : N_Assignment_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Elaboration_Code;

   procedure Set_Is_Elaboration_Code (N : N_Assignment_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Elaboration_Code;

   function Is_Elaboration_Warnings_OK_Node (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Elaboration_Warnings_OK_Node;

   procedure Set_Is_Elaboration_Warnings_OK_Node (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Elaboration_Warnings_OK_Node;

   function Is_Elsif (N : N_If_Expression_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Elsif;

   procedure Set_Is_Elsif (N : N_If_Expression_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Elsif;

   function Is_Entry_Barrier_Function (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Entry_Barrier_Function;

   procedure Set_Is_Entry_Barrier_Function (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Entry_Barrier_Function;

   function Is_Expanded_Build_In_Place_Call (N : N_Function_Call_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Expanded_Build_In_Place_Call;

   procedure Set_Is_Expanded_Build_In_Place_Call (N : N_Function_Call_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Expanded_Build_In_Place_Call;

   function Is_Expanded_Contract (N : N_Contract_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Expanded_Contract;

   procedure Set_Is_Expanded_Contract (N : N_Contract_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Expanded_Contract;

   function Is_Finalization_Wrapper (N : N_Block_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Finalization_Wrapper;

   procedure Set_Is_Finalization_Wrapper (N : N_Block_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Finalization_Wrapper;

   function Is_Folded_In_Parser (N : N_String_Literal_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Folded_In_Parser;

   procedure Set_Is_Folded_In_Parser (N : N_String_Literal_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Folded_In_Parser;

   function Is_Generic_Contract_Pragma (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Generic_Contract_Pragma;

   procedure Set_Is_Generic_Contract_Pragma (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Generic_Contract_Pragma;

   function Is_Homogeneous_Aggregate (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Homogeneous_Aggregate;

   procedure Set_Is_Homogeneous_Aggregate (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Homogeneous_Aggregate;

   function Is_Parenthesis_Aggregate (N : N_Aggregate_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Parenthesis_Aggregate;

   procedure Set_Is_Parenthesis_Aggregate (N : N_Aggregate_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Parenthesis_Aggregate;

   function Is_Enum_Array_Aggregate (N : N_Aggregate_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Enum_Array_Aggregate;

   procedure Set_Is_Enum_Array_Aggregate (N : N_Aggregate_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Enum_Array_Aggregate;

   function Is_Ignored (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ignored;

   procedure Set_Is_Ignored (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ignored;

   function Is_Ignored_Ghost_Pragma (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ignored_Ghost_Pragma;

   procedure Set_Is_Ignored_Ghost_Pragma (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ignored_Ghost_Pragma;

   function Is_In_Discriminant_Check (N : N_Selected_Component_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_In_Discriminant_Check;

   procedure Set_Is_In_Discriminant_Check (N : N_Selected_Component_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_In_Discriminant_Check;

   function Is_Inherited_Pragma (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Inherited_Pragma;

   procedure Set_Is_Inherited_Pragma (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Inherited_Pragma;

   function Is_Initialization_Block (N : N_Block_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Initialization_Block;

   procedure Set_Is_Initialization_Block (N : N_Block_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Initialization_Block;

   function Is_Known_Guaranteed_ABE (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Known_Guaranteed_ABE;

   procedure Set_Is_Known_Guaranteed_ABE (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Known_Guaranteed_ABE;

   function Is_Machine_Number (N : N_Real_Literal_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Machine_Number;

   procedure Set_Is_Machine_Number (N : N_Real_Literal_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Machine_Number;

   function Is_Null_Loop (N : N_Loop_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Null_Loop;

   procedure Set_Is_Null_Loop (N : N_Loop_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Null_Loop;

   function Is_Overloaded (N : N_Subexpr_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Overloaded;

   procedure Set_Is_Overloaded (N : N_Subexpr_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Overloaded;

   function Is_Power_Of_2_For_Shift (N : N_Op_Expon_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Power_Of_2_For_Shift;

   procedure Set_Is_Power_Of_2_For_Shift (N : N_Op_Expon_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Power_Of_2_For_Shift;

   function Is_Preelaborable_Call (N : N_Call_Marker_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Preelaborable_Call;

   procedure Set_Is_Preelaborable_Call (N : N_Call_Marker_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Preelaborable_Call;

   function Is_Prefixed_Call (N : N_Selected_Component_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Prefixed_Call;

   procedure Set_Is_Prefixed_Call (N : N_Selected_Component_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Prefixed_Call;

   function Is_Protected_Subprogram_Body (N : N_Subprogram_Body_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Protected_Subprogram_Body;

   procedure Set_Is_Protected_Subprogram_Body (N : N_Subprogram_Body_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Protected_Subprogram_Body;

   function Is_Qualified_Universal_Literal (N : N_Qualified_Expression_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Qualified_Universal_Literal;

   procedure Set_Is_Qualified_Universal_Literal (N : N_Qualified_Expression_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Qualified_Universal_Literal;

   function Is_Read (N : N_Variable_Reference_Marker_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Read;

   procedure Set_Is_Read (N : N_Variable_Reference_Marker_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Read;

   function Is_Source_Call (N : N_Call_Marker_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Source_Call;

   procedure Set_Is_Source_Call (N : N_Call_Marker_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Source_Call;

   function Is_SPARK_Mode_On_Node (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_SPARK_Mode_On_Node;

   procedure Set_Is_SPARK_Mode_On_Node (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_SPARK_Mode_On_Node;

   function Is_Static_Coextension (N : N_Allocator_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Static_Coextension;

   procedure Set_Is_Static_Coextension (N : N_Allocator_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Static_Coextension;

   function Is_Static_Expression (N : N_Subexpr_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Static_Expression;

   procedure Set_Is_Static_Expression (N : N_Subexpr_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Static_Expression;

   function Is_Subprogram_Descriptor (N : N_Object_Declaration_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Subprogram_Descriptor;

   procedure Set_Is_Subprogram_Descriptor (N : N_Object_Declaration_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Subprogram_Descriptor;

   function Is_Task_Allocation_Block (N : N_Block_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Task_Allocation_Block;

   procedure Set_Is_Task_Allocation_Block (N : N_Block_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Task_Allocation_Block;

   function Is_Task_Body_Procedure (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Task_Body_Procedure;

   procedure Set_Is_Task_Body_Procedure (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Task_Body_Procedure;

   function Is_Task_Master (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Task_Master;

   procedure Set_Is_Task_Master (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Task_Master;

   function Is_Write (N : N_Variable_Reference_Marker_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Write;

   procedure Set_Is_Write (N : N_Variable_Reference_Marker_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Write;

   function Iterator_Filter (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Iterator_Filter;

   procedure Set_Iterator_Filter (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Iterator_Filter;

   function Iteration_Scheme (N : N_Loop_Statement_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Iteration_Scheme;

   procedure Set_Iteration_Scheme (N : N_Loop_Statement_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Iteration_Scheme;

   function Iterator_Specification (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Iterator_Specification;

   procedure Set_Iterator_Specification (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Iterator_Specification;

   function Itype (N : N_Itype_Reference_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Itype;

   procedure Set_Itype (N : N_Itype_Reference_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Itype;

   function Key_Expression (N : N_Iterated_Element_Association_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Key_Expression;

   procedure Set_Key_Expression (N : N_Iterated_Element_Association_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Key_Expression;

   function Kill_Range_Check (N : N_Unchecked_Type_Conversion_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Kill_Range_Check;

   procedure Set_Kill_Range_Check (N : N_Unchecked_Type_Conversion_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Kill_Range_Check;

   function Last_Bit (N : N_Component_Clause_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Last_Bit;

   procedure Set_Last_Bit (N : N_Component_Clause_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Last_Bit;

   function Last_Name (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Last_Name;

   procedure Set_Last_Name (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Last_Name;

   function Library_Unit (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Library_Unit;

   procedure Set_Library_Unit (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Library_Unit;

   function Label_Construct (N : N_Implicit_Label_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Label_Construct;

   procedure Set_Label_Construct (N : N_Implicit_Label_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Label_Construct;

   function Left_Opnd (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Left_Opnd;

   procedure Set_Left_Opnd (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Left_Opnd;

   function Limited_View_Installed (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Limited_View_Installed;

   procedure Set_Limited_View_Installed (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Limited_View_Installed;

   function Limited_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Limited_Present;

   procedure Set_Limited_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Limited_Present;

   function Literals (N : N_Enumeration_Type_Definition_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Literals;

   procedure Set_Literals (N : N_Enumeration_Type_Definition_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Literals;

   function Local_Raise_Not_OK (N : N_Exception_Handler_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Local_Raise_Not_OK;

   procedure Set_Local_Raise_Not_OK (N : N_Exception_Handler_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Local_Raise_Not_OK;

   function Local_Raise_Statements (N : N_Exception_Handler_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Local_Raise_Statements;

   procedure Set_Local_Raise_Statements (N : N_Exception_Handler_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Local_Raise_Statements;

   function Loop_Actions (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Loop_Actions;

   procedure Set_Loop_Actions (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Loop_Actions;

   function Loop_Parameter_Specification (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Loop_Parameter_Specification;

   procedure Set_Loop_Parameter_Specification (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Loop_Parameter_Specification;

   function Low_Bound (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Low_Bound;

   procedure Set_Low_Bound (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Low_Bound;

   function Mod_Clause (N : N_Record_Representation_Clause_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Mod_Clause;

   procedure Set_Mod_Clause (N : N_Record_Representation_Clause_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Mod_Clause;

   function More_Ids (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end More_Ids;

   procedure Set_More_Ids (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_More_Ids;

   function Multidefined_Bindings (N : N_Case_Statement_Alternative_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Multidefined_Bindings;

   procedure Set_Multidefined_Bindings (N : N_Case_Statement_Alternative_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Multidefined_Bindings;

   function Must_Be_Byte_Aligned (N : N_Attribute_Reference_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Must_Be_Byte_Aligned;

   procedure Set_Must_Be_Byte_Aligned (N : N_Attribute_Reference_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Must_Be_Byte_Aligned;

   function Must_Not_Freeze (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Must_Not_Freeze;

   procedure Set_Must_Not_Freeze (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Must_Not_Freeze;

   function Must_Not_Override (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Must_Not_Override;

   procedure Set_Must_Not_Override (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Must_Not_Override;

   function Must_Override (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Must_Override;

   procedure Set_Must_Override (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Must_Override;

   function Name (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Name;

   procedure Set_Name (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Name;

   function Names (N : N_Abort_Statement_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Names;

   procedure Set_Names (N : N_Abort_Statement_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Names;

   function Next_Entity (N : N_Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Entity;

   procedure Set_Next_Entity (N : N_Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Entity;

   function Next_Exit_Statement (N : N_Exit_Statement_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Exit_Statement;

   procedure Set_Next_Exit_Statement (N : N_Exit_Statement_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Exit_Statement;

   function Next_Implicit_With (N : N_With_Clause_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Implicit_With;

   procedure Set_Next_Implicit_With (N : N_With_Clause_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Implicit_With;

   function Next_Named_Actual (N : N_Parameter_Association_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Named_Actual;

   procedure Set_Next_Named_Actual (N : N_Parameter_Association_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Named_Actual;

   function Next_Pragma (N : N_Pragma_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Pragma;

   procedure Set_Next_Pragma (N : N_Pragma_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Pragma;

   function Next_Rep_Item (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Rep_Item;

   procedure Set_Next_Rep_Item (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Rep_Item;

   function Next_Use_Clause (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Use_Clause;

   procedure Set_Next_Use_Clause (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Use_Clause;

   function No_Ctrl_Actions (N : N_Assignment_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Ctrl_Actions;

   procedure Set_No_Ctrl_Actions (N : N_Assignment_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Ctrl_Actions;

   function No_Elaboration_Check (N : N_Subprogram_Call_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Elaboration_Check;

   procedure Set_No_Elaboration_Check (N : N_Subprogram_Call_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Elaboration_Check;

   function No_Entities_Ref_In_Spec (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Entities_Ref_In_Spec;

   procedure Set_No_Entities_Ref_In_Spec (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Entities_Ref_In_Spec;

   function No_Initialization (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Initialization;

   procedure Set_No_Initialization (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Initialization;

   function No_Minimize_Eliminate (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Minimize_Eliminate;

   procedure Set_No_Minimize_Eliminate (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Minimize_Eliminate;

   function No_Side_Effect_Removal (N : N_Function_Call_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Side_Effect_Removal;

   procedure Set_No_Side_Effect_Removal (N : N_Function_Call_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Side_Effect_Removal;

   function No_Truncation (N : N_Unchecked_Type_Conversion_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Truncation;

   procedure Set_No_Truncation (N : N_Unchecked_Type_Conversion_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Truncation;

   function Null_Excluding_Subtype (N : N_Access_To_Object_Definition_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Null_Excluding_Subtype;

   procedure Set_Null_Excluding_Subtype (N : N_Access_To_Object_Definition_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Null_Excluding_Subtype;

   function Null_Exclusion_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Null_Exclusion_Present;

   procedure Set_Null_Exclusion_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Null_Exclusion_Present;

   function Null_Exclusion_In_Return_Present (N : N_Access_Function_Definition_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Null_Exclusion_In_Return_Present;

   procedure Set_Null_Exclusion_In_Return_Present (N : N_Access_Function_Definition_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Null_Exclusion_In_Return_Present;

   function Null_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Null_Present;

   procedure Set_Null_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Null_Present;

   function Null_Record_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Null_Record_Present;

   procedure Set_Null_Record_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Null_Record_Present;

   function Null_Statement (N : N_Procedure_Specification_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Null_Statement;

   procedure Set_Null_Statement (N : N_Procedure_Specification_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Null_Statement;

   function Object_Definition (N : N_Object_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Object_Definition;

   procedure Set_Object_Definition (N : N_Object_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Object_Definition;

   function Of_Present (N : N_Iterator_Specification_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Of_Present;

   procedure Set_Of_Present (N : N_Iterator_Specification_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 9 = 0 slots + 9 fields in slot.

      Off : constant := 9;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Of_Present;

   function Original_Discriminant (N : N_Identifier_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Original_Discriminant;

   procedure Set_Original_Discriminant (N : N_Identifier_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Original_Discriminant;

   function Original_Entity (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Original_Entity;

   procedure Set_Original_Entity (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Original_Entity;

   function Others_Discrete_Choices (N : N_Others_Choice_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Others_Discrete_Choices;

   procedure Set_Others_Discrete_Choices (N : N_Others_Choice_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Others_Discrete_Choices;

   function Out_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Out_Present;

   procedure Set_Out_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Out_Present;

   function Parameter_Associations (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Parameter_Associations;

   procedure Set_Parameter_Associations (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Parameter_Associations;

   function Parameter_Specifications (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Parameter_Specifications;

   procedure Set_Parameter_Specifications (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Parameter_Specifications;

   function Parameter_Type (N : N_Parameter_Specification_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Parameter_Type;

   procedure Set_Parameter_Type (N : N_Parameter_Specification_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Parameter_Type;

   function Parent_Spec (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Parent_Spec;

   procedure Set_Parent_Spec (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Parent_Spec;

   function Parent_With (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Parent_With;

   procedure Set_Parent_With (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Parent_With;

   function Position (N : N_Component_Clause_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Position;

   procedure Set_Position (N : N_Component_Clause_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Position;

   function Pragma_Argument_Associations (N : N_Pragma_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Pragma_Argument_Associations;

   procedure Set_Pragma_Argument_Associations (N : N_Pragma_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Pragma_Argument_Associations;

   function Pragma_Identifier (N : N_Pragma_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Pragma_Identifier;

   procedure Set_Pragma_Identifier (N : N_Pragma_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Pragma_Identifier;

   function Pragmas_After (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Pragmas_After;

   procedure Set_Pragmas_After (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Pragmas_After;

   function Pragmas_Before (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Pragmas_Before;

   procedure Set_Pragmas_Before (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Pragmas_Before;

   function Pre_Post_Conditions (N : N_Contract_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Pre_Post_Conditions;

   procedure Set_Pre_Post_Conditions (N : N_Contract_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Pre_Post_Conditions;

   function Prefix (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Prefix;

   procedure Set_Prefix (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Prefix;

   function Premature_Use (N : N_Incomplete_Type_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Premature_Use;

   procedure Set_Premature_Use (N : N_Incomplete_Type_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Premature_Use;

   function Present_Expr (N : N_Variant_Id) return Valid_Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Valid_Uint := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Present_Expr;

   procedure Set_Present_Expr (N : N_Variant_Id; Val : Valid_Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Present_Expr;

   function Prev_Ids (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Prev_Ids;

   procedure Set_Prev_Ids (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Prev_Ids;

   function Prev_Use_Clause (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Prev_Use_Clause;

   procedure Set_Prev_Use_Clause (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 8 = 8 slots + 0 fields in slot.

      Off : constant := 8;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Prev_Use_Clause;

   function Print_In_Hex (N : N_Integer_Literal_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Print_In_Hex;

   procedure Set_Print_In_Hex (N : N_Integer_Literal_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Print_In_Hex;

   function Private_Declarations (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Private_Declarations;

   procedure Set_Private_Declarations (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Private_Declarations;

   function Private_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Private_Present;

   procedure Set_Private_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Private_Present;

   function Procedure_To_Call (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Procedure_To_Call;

   procedure Set_Procedure_To_Call (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Procedure_To_Call;

   function Proper_Body (N : N_Subunit_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Proper_Body;

   procedure Set_Proper_Body (N : N_Subunit_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Proper_Body;

   function Protected_Definition (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Protected_Definition;

   procedure Set_Protected_Definition (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Protected_Definition;

   function Protected_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Protected_Present;

   procedure Set_Protected_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Protected_Present;

   function Raises_Constraint_Error (N : N_Subexpr_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Raises_Constraint_Error;

   procedure Set_Raises_Constraint_Error (N : N_Subexpr_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Raises_Constraint_Error;

   function Range_Constraint (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Range_Constraint;

   procedure Set_Range_Constraint (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Range_Constraint;

   function Range_Expression (N : N_Range_Constraint_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Range_Expression;

   procedure Set_Range_Expression (N : N_Range_Constraint_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Range_Expression;

   function Real_Range_Specification (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Real_Range_Specification;

   procedure Set_Real_Range_Specification (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Real_Range_Specification;

   function Realval (N : N_Real_Literal_Id) return Ureal is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Ureal := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Realval;

   procedure Set_Realval (N : N_Real_Literal_Id; Val : Ureal) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Realval;

   function Reason (N : Node_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Reason;

   procedure Set_Reason (N : Node_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Reason;

   function Record_Extension_Part (N : N_Derived_Type_Definition_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Record_Extension_Part;

   procedure Set_Record_Extension_Part (N : N_Derived_Type_Definition_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Record_Extension_Part;

   function Redundant_Use (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Redundant_Use;

   procedure Set_Redundant_Use (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Redundant_Use;

   function Renaming_Exception (N : N_Exception_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Renaming_Exception;

   procedure Set_Renaming_Exception (N : N_Exception_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Renaming_Exception;

   function Result_Definition (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Result_Definition;

   procedure Set_Result_Definition (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Result_Definition;

   function Return_Object_Declarations (N : N_Extended_Return_Statement_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Return_Object_Declarations;

   procedure Set_Return_Object_Declarations (N : N_Extended_Return_Statement_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Return_Object_Declarations;

   function Return_Statement_Entity (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Return_Statement_Entity;

   procedure Set_Return_Statement_Entity (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Return_Statement_Entity;

   function Reverse_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Reverse_Present;

   procedure Set_Reverse_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 8 = 0 slots + 8 fields in slot.

      Off : constant := 8;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Reverse_Present;

   function Right_Opnd (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Right_Opnd;

   procedure Set_Right_Opnd (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Right_Opnd;

   function Rounded_Result (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Rounded_Result;

   procedure Set_Rounded_Result (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Rounded_Result;

   function Save_Invocation_Graph_Of_Body (N : N_Compilation_Unit_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Save_Invocation_Graph_Of_Body;

   procedure Set_Save_Invocation_Graph_Of_Body (N : N_Compilation_Unit_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 14 = 0 slots + 14 fields in slot.

      Off : constant := 14;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Save_Invocation_Graph_Of_Body;

   function SCIL_Controlling_Tag (N : N_SCIL_Dispatching_Call_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SCIL_Controlling_Tag;

   procedure Set_SCIL_Controlling_Tag (N : N_SCIL_Dispatching_Call_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_SCIL_Controlling_Tag;

   function SCIL_Entity (N : N_SCIL_Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SCIL_Entity;

   procedure Set_SCIL_Entity (N : N_SCIL_Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_SCIL_Entity;

   function SCIL_Tag_Value (N : N_SCIL_Membership_Test_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SCIL_Tag_Value;

   procedure Set_SCIL_Tag_Value (N : N_SCIL_Membership_Test_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_SCIL_Tag_Value;

   function SCIL_Target_Prim (N : N_SCIL_Dispatching_Call_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SCIL_Target_Prim;

   procedure Set_SCIL_Target_Prim (N : N_SCIL_Dispatching_Call_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 5 = 5 slots + 0 fields in slot.

      Off : constant := 5;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_SCIL_Target_Prim;

   function Scope (N : N_Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Scope;

   procedure Set_Scope (N : N_Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Scope;

   function Select_Alternatives (N : N_Selective_Accept_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Select_Alternatives;

   procedure Set_Select_Alternatives (N : N_Selective_Accept_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Select_Alternatives;

   function Selector_Name (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Selector_Name;

   procedure Set_Selector_Name (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Selector_Name;

   function Selector_Names (N : N_Discriminant_Association_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Selector_Names;

   procedure Set_Selector_Names (N : N_Discriminant_Association_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Selector_Names;

   function Shift_Count_OK (N : N_Op_Shift_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Shift_Count_OK;

   procedure Set_Shift_Count_OK (N : N_Op_Shift_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Shift_Count_OK;

   function Source_Type (N : N_Validate_Unchecked_Conversion_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Source_Type;

   procedure Set_Source_Type (N : N_Validate_Unchecked_Conversion_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Source_Type;

   function Specification (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Specification;

   procedure Set_Specification (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Specification;

   function Split_PPC (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Split_PPC;

   procedure Set_Split_PPC (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Split_PPC;

   function Statements (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Statements;

   procedure Set_Statements (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Statements;

   function Storage_Pool (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Storage_Pool;

   procedure Set_Storage_Pool (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Storage_Pool;

   function Subpool_Handle_Name (N : N_Allocator_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Subpool_Handle_Name;

   procedure Set_Subpool_Handle_Name (N : N_Allocator_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Subpool_Handle_Name;

   function Strval (N : Node_Id) return String_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant String_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Strval;

   procedure Set_Strval (N : Node_Id; Val : String_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Strval;

   function Subtype_Indication (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Subtype_Indication;

   procedure Set_Subtype_Indication (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Subtype_Indication;

   function Subtype_Mark (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Subtype_Mark;

   procedure Set_Subtype_Mark (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Subtype_Mark;

   function Subtype_Marks (N : N_Unconstrained_Array_Definition_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Subtype_Marks;

   procedure Set_Subtype_Marks (N : N_Unconstrained_Array_Definition_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Subtype_Marks;

   function Suppress_Assignment_Checks (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Suppress_Assignment_Checks;

   procedure Set_Suppress_Assignment_Checks (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 13 = 0 slots + 13 fields in slot.

      Off : constant := 13;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Suppress_Assignment_Checks;

   function Suppress_Loop_Warnings (N : N_Loop_Statement_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Suppress_Loop_Warnings;

   procedure Set_Suppress_Loop_Warnings (N : N_Loop_Statement_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Suppress_Loop_Warnings;

   function Synchronized_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Synchronized_Present;

   procedure Set_Synchronized_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Synchronized_Present;

   function Tagged_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Tagged_Present;

   procedure Set_Tagged_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 11 = 0 slots + 11 fields in slot.

      Off : constant := 11;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Tagged_Present;

   function Target (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Target;

   procedure Set_Target (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Target;

   function Target_Type (N : N_Validate_Unchecked_Conversion_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Target_Type;

   procedure Set_Target_Type (N : N_Validate_Unchecked_Conversion_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Target_Type;

   function Task_Definition (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Task_Definition;

   procedure Set_Task_Definition (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Task_Definition;

   function Task_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Task_Present;

   procedure Set_Task_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 15 = 0 slots + 15 fields in slot.

      Off : constant := 15;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Task_Present;

   function Then_Actions (N : N_If_Expression_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Then_Actions;

   procedure Set_Then_Actions (N : N_If_Expression_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Then_Actions;

   function Then_Statements (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Then_Statements;

   procedure Set_Then_Statements (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Then_Statements;

   function Triggering_Alternative (N : N_Asynchronous_Select_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Triggering_Alternative;

   procedure Set_Triggering_Alternative (N : N_Asynchronous_Select_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Triggering_Alternative;

   function Triggering_Statement (N : N_Triggering_Alternative_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Triggering_Statement;

   procedure Set_Triggering_Statement (N : N_Triggering_Alternative_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Triggering_Statement;

   function TSS_Elist (N : N_Freeze_Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end TSS_Elist;

   procedure Set_TSS_Elist (N : N_Freeze_Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_TSS_Elist;

   function Type_Definition (N : N_Full_Type_Declaration_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Type_Definition;

   procedure Set_Type_Definition (N : N_Full_Type_Declaration_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Type_Definition;

   function Uneval_Old_Accept (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Uneval_Old_Accept;

   procedure Set_Uneval_Old_Accept (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Uneval_Old_Accept;

   function Uneval_Old_Warn (N : N_Pragma_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Uneval_Old_Warn;

   procedure Set_Uneval_Old_Warn (N : N_Pragma_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 256 = 8 slots + 0 fields in slot.

      Off : constant := 256;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Uneval_Old_Warn;

   function Unit (N : N_Compilation_Unit_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Unit;

   procedure Set_Unit (N : N_Compilation_Unit_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Unit;

   function Unknown_Discriminants_Present (N : Node_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Unknown_Discriminants_Present;

   procedure Set_Unknown_Discriminants_Present (N : Node_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Unknown_Discriminants_Present;

   function Unreferenced_In_Spec (N : N_With_Clause_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Unreferenced_In_Spec;

   procedure Set_Unreferenced_In_Spec (N : N_With_Clause_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Unreferenced_In_Spec;

   function Variant_Part (N : N_Component_List_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Variant_Part;

   procedure Set_Variant_Part (N : N_Component_List_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 2 = 2 slots + 0 fields in slot.

      Off : constant := 2;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Variant_Part;

   function Variants (N : N_Variant_Part_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Variants;

   procedure Set_Variants (N : N_Variant_Part_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Variants;

   function Visible_Declarations (N : Node_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Visible_Declarations;

   procedure Set_Visible_Declarations (N : Node_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 7 = 7 slots + 0 fields in slot.

      Off : constant := 7;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      if Present (Val) and then Val /= Error_List then
         pragma Warnings (Off, "actuals for this call may be in wrong order");
         Set_Parent (Val, N);
         pragma Warnings (On, "actuals for this call may be in wrong order");
      end if;

      S := Slot (Raw);
   end Set_Visible_Declarations;

   function Uninitialized_Variable (N : Node_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Uninitialized_Variable;

   procedure Set_Uninitialized_Variable (N : Node_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 6 = 6 slots + 0 fields in slot.

      Off : constant := 6;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Uninitialized_Variable;

   function Used_Operations (N : N_Use_Type_Clause_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Used_Operations;

   procedure Set_Used_Operations (N : N_Use_Type_Clause_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Used_Operations;

   function Was_Attribute_Reference (N : N_Subprogram_Body_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Was_Attribute_Reference;

   procedure Set_Was_Attribute_Reference (N : N_Subprogram_Body_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Was_Attribute_Reference;

   function Was_Default_Init_Box_Association (N : N_Component_Association_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Was_Default_Init_Box_Association;

   procedure Set_Was_Default_Init_Box_Association (N : N_Component_Association_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 10 = 0 slots + 10 fields in slot.

      Off : constant := 10;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Was_Default_Init_Box_Association;

   function Was_Expression_Function (N : N_Subprogram_Body_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Was_Expression_Function;

   procedure Set_Was_Expression_Function (N : N_Subprogram_Body_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Was_Expression_Function;

   function Was_Originally_Stub (N : N_Proper_Body_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Was_Originally_Stub;

   procedure Set_Was_Originally_Stub (N : N_Proper_Body_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 12 = 0 slots + 12 fields in slot.

      Off : constant := 12;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Was_Originally_Stub;

end Sinfo.Nodes;
