/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu May 24 08:06:59 EDT 2018 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2c.native -fma -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hc2cf_32 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 434 FP additions, 260 FP multiplications,
 * (or, 236 additions, 62 multiplications, 198 fused multiply/add),
 * 102 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cf_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E T8, T8x, T3w, T87, Tl, T8y, T3B, T83, Tz, T6F, T3J, T5T, TM, T6G, T3Q;
	       E T5U, T11, T1e, T6M, T6J, T6K, T6L, T3Z, T5Y, T46, T5X, T1s, T1F, T6O, T6P;
	       E T6Q, T6R, T4e, T61, T4l, T60, T32, T7b, T79, T7N, T54, T6c, T5r, T6f, T29;
	       E T70, T6X, T7I, T4v, T65, T4S, T68, T3t, T76, T7e, T7O, T5b, T5s, T5i, T5t;
	       E T2A, T6Y, T73, T7J, T4C, T4T, T4J, T4U;
	       {
		    E T1, T86, T3, T6, T4, T84, T2, T7, T85, T5;
		    T1 = Rp[0];
		    T86 = Rm[0];
		    T3 = Rp[WS(rs, 8)];
		    T6 = Rm[WS(rs, 8)];
		    T2 = W[30];
		    T4 = T2 * T3;
		    T84 = T2 * T6;
		    T5 = W[31];
		    T7 = FMA(T5, T6, T4);
		    T85 = FNMS(T5, T3, T84);
		    T8 = T1 + T7;
		    T8x = T86 - T85;
		    T3w = T1 - T7;
		    T87 = T85 + T86;
	       }
	       {
		    E Ta, Td, Tb, T3x, Tg, Tj, Th, T3z, T9, Tf;
		    Ta = Rp[WS(rs, 4)];
		    Td = Rm[WS(rs, 4)];
		    T9 = W[14];
		    Tb = T9 * Ta;
		    T3x = T9 * Td;
		    Tg = Rp[WS(rs, 12)];
		    Tj = Rm[WS(rs, 12)];
		    Tf = W[46];
		    Th = Tf * Tg;
		    T3z = Tf * Tj;
		    {
			 E Te, T3y, Tk, T3A, Tc, Ti;
			 Tc = W[15];
			 Te = FMA(Tc, Td, Tb);
			 T3y = FNMS(Tc, Ta, T3x);
			 Ti = W[47];
			 Tk = FMA(Ti, Tj, Th);
			 T3A = FNMS(Ti, Tg, T3z);
			 Tl = Te + Tk;
			 T8y = Te - Tk;
			 T3B = T3y - T3A;
			 T83 = T3y + T3A;
		    }
	       }
	       {
		    E Ts, T3F, Ty, T3H, T3D, T3I;
		    {
			 E To, Tr, Tp, T3E, Tn, Tq;
			 To = Rp[WS(rs, 2)];
			 Tr = Rm[WS(rs, 2)];
			 Tn = W[6];
			 Tp = Tn * To;
			 T3E = Tn * Tr;
			 Tq = W[7];
			 Ts = FMA(Tq, Tr, Tp);
			 T3F = FNMS(Tq, To, T3E);
		    }
		    {
			 E Tu, Tx, Tv, T3G, Tt, Tw;
			 Tu = Rp[WS(rs, 10)];
			 Tx = Rm[WS(rs, 10)];
			 Tt = W[38];
			 Tv = Tt * Tu;
			 T3G = Tt * Tx;
			 Tw = W[39];
			 Ty = FMA(Tw, Tx, Tv);
			 T3H = FNMS(Tw, Tu, T3G);
		    }
		    Tz = Ts + Ty;
		    T6F = T3F + T3H;
		    T3D = Ts - Ty;
		    T3I = T3F - T3H;
		    T3J = T3D + T3I;
		    T5T = T3I - T3D;
	       }
	       {
		    E TF, T3M, TL, T3O, T3K, T3P;
		    {
			 E TB, TE, TC, T3L, TA, TD;
			 TB = Rp[WS(rs, 14)];
			 TE = Rm[WS(rs, 14)];
			 TA = W[54];
			 TC = TA * TB;
			 T3L = TA * TE;
			 TD = W[55];
			 TF = FMA(TD, TE, TC);
			 T3M = FNMS(TD, TB, T3L);
		    }
		    {
			 E TH, TK, TI, T3N, TG, TJ;
			 TH = Rp[WS(rs, 6)];
			 TK = Rm[WS(rs, 6)];
			 TG = W[22];
			 TI = TG * TH;
			 T3N = TG * TK;
			 TJ = W[23];
			 TL = FMA(TJ, TK, TI);
			 T3O = FNMS(TJ, TH, T3N);
		    }
		    TM = TF + TL;
		    T6G = T3M + T3O;
		    T3K = TF - TL;
		    T3P = T3M - T3O;
		    T3Q = T3K - T3P;
		    T5U = T3K + T3P;
	       }
	       {
		    E TU, T41, T1d, T3X, T10, T43, T17, T3V;
		    {
			 E TQ, TT, TR, T40, TP, TS;
			 TQ = Rp[WS(rs, 1)];
			 TT = Rm[WS(rs, 1)];
			 TP = W[2];
			 TR = TP * TQ;
			 T40 = TP * TT;
			 TS = W[3];
			 TU = FMA(TS, TT, TR);
			 T41 = FNMS(TS, TQ, T40);
		    }
		    {
			 E T19, T1c, T1a, T3W, T18, T1b;
			 T19 = Rp[WS(rs, 13)];
			 T1c = Rm[WS(rs, 13)];
			 T18 = W[50];
			 T1a = T18 * T19;
			 T3W = T18 * T1c;
			 T1b = W[51];
			 T1d = FMA(T1b, T1c, T1a);
			 T3X = FNMS(T1b, T19, T3W);
		    }
		    {
			 E TW, TZ, TX, T42, TV, TY;
			 TW = Rp[WS(rs, 9)];
			 TZ = Rm[WS(rs, 9)];
			 TV = W[34];
			 TX = TV * TW;
			 T42 = TV * TZ;
			 TY = W[35];
			 T10 = FMA(TY, TZ, TX);
			 T43 = FNMS(TY, TW, T42);
		    }
		    {
			 E T13, T16, T14, T3U, T12, T15;
			 T13 = Rp[WS(rs, 5)];
			 T16 = Rm[WS(rs, 5)];
			 T12 = W[18];
			 T14 = T12 * T13;
			 T3U = T12 * T16;
			 T15 = W[19];
			 T17 = FMA(T15, T16, T14);
			 T3V = FNMS(T15, T13, T3U);
		    }
		    T11 = TU + T10;
		    T1e = T17 + T1d;
		    T6M = T11 - T1e;
		    T6J = T41 + T43;
		    T6K = T3V + T3X;
		    T6L = T6J - T6K;
		    {
			 E T3T, T3Y, T44, T45;
			 T3T = TU - T10;
			 T3Y = T3V - T3X;
			 T3Z = T3T + T3Y;
			 T5Y = T3T - T3Y;
			 T44 = T41 - T43;
			 T45 = T17 - T1d;
			 T46 = T44 - T45;
			 T5X = T44 + T45;
		    }
	       }
	       {
		    E T1l, T4g, T1E, T4c, T1r, T4i, T1y, T4a;
		    {
			 E T1h, T1k, T1i, T4f, T1g, T1j;
			 T1h = Rp[WS(rs, 15)];
			 T1k = Rm[WS(rs, 15)];
			 T1g = W[58];
			 T1i = T1g * T1h;
			 T4f = T1g * T1k;
			 T1j = W[59];
			 T1l = FMA(T1j, T1k, T1i);
			 T4g = FNMS(T1j, T1h, T4f);
		    }
		    {
			 E T1A, T1D, T1B, T4b, T1z, T1C;
			 T1A = Rp[WS(rs, 11)];
			 T1D = Rm[WS(rs, 11)];
			 T1z = W[42];
			 T1B = T1z * T1A;
			 T4b = T1z * T1D;
			 T1C = W[43];
			 T1E = FMA(T1C, T1D, T1B);
			 T4c = FNMS(T1C, T1A, T4b);
		    }
		    {
			 E T1n, T1q, T1o, T4h, T1m, T1p;
			 T1n = Rp[WS(rs, 7)];
			 T1q = Rm[WS(rs, 7)];
			 T1m = W[26];
			 T1o = T1m * T1n;
			 T4h = T1m * T1q;
			 T1p = W[27];
			 T1r = FMA(T1p, T1q, T1o);
			 T4i = FNMS(T1p, T1n, T4h);
		    }
		    {
			 E T1u, T1x, T1v, T49, T1t, T1w;
			 T1u = Rp[WS(rs, 3)];
			 T1x = Rm[WS(rs, 3)];
			 T1t = W[10];
			 T1v = T1t * T1u;
			 T49 = T1t * T1x;
			 T1w = W[11];
			 T1y = FMA(T1w, T1x, T1v);
			 T4a = FNMS(T1w, T1u, T49);
		    }
		    T1s = T1l + T1r;
		    T1F = T1y + T1E;
		    T6O = T1s - T1F;
		    T6P = T4g + T4i;
		    T6Q = T4a + T4c;
		    T6R = T6P - T6Q;
		    {
			 E T48, T4d, T4j, T4k;
			 T48 = T1l - T1r;
			 T4d = T4a - T4c;
			 T4e = T48 + T4d;
			 T61 = T48 - T4d;
			 T4j = T4g - T4i;
			 T4k = T1y - T1E;
			 T4l = T4j - T4k;
			 T60 = T4j + T4k;
		    }
	       }
	       {
		    E T2H, T5m, T30, T52, T2N, T5o, T2U, T50;
		    {
			 E T2D, T2G, T2E, T5l, T2C, T2F;
			 T2D = Ip[WS(rs, 15)];
			 T2G = Im[WS(rs, 15)];
			 T2C = W[60];
			 T2E = T2C * T2D;
			 T5l = T2C * T2G;
			 T2F = W[61];
			 T2H = FMA(T2F, T2G, T2E);
			 T5m = FNMS(T2F, T2D, T5l);
		    }
		    {
			 E T2W, T2Z, T2X, T51, T2V, T2Y;
			 T2W = Ip[WS(rs, 11)];
			 T2Z = Im[WS(rs, 11)];
			 T2V = W[44];
			 T2X = T2V * T2W;
			 T51 = T2V * T2Z;
			 T2Y = W[45];
			 T30 = FMA(T2Y, T2Z, T2X);
			 T52 = FNMS(T2Y, T2W, T51);
		    }
		    {
			 E T2J, T2M, T2K, T5n, T2I, T2L;
			 T2J = Ip[WS(rs, 7)];
			 T2M = Im[WS(rs, 7)];
			 T2I = W[28];
			 T2K = T2I * T2J;
			 T5n = T2I * T2M;
			 T2L = W[29];
			 T2N = FMA(T2L, T2M, T2K);
			 T5o = FNMS(T2L, T2J, T5n);
		    }
		    {
			 E T2Q, T2T, T2R, T4Z, T2P, T2S;
			 T2Q = Ip[WS(rs, 3)];
			 T2T = Im[WS(rs, 3)];
			 T2P = W[12];
			 T2R = T2P * T2Q;
			 T4Z = T2P * T2T;
			 T2S = W[13];
			 T2U = FMA(T2S, T2T, T2R);
			 T50 = FNMS(T2S, T2Q, T4Z);
		    }
		    {
			 E T2O, T31, T77, T78;
			 T2O = T2H + T2N;
			 T31 = T2U + T30;
			 T32 = T2O + T31;
			 T7b = T2O - T31;
			 T77 = T5m + T5o;
			 T78 = T50 + T52;
			 T79 = T77 - T78;
			 T7N = T77 + T78;
		    }
		    {
			 E T4Y, T53, T5p, T5q;
			 T4Y = T2H - T2N;
			 T53 = T50 - T52;
			 T54 = T4Y + T53;
			 T6c = T4Y - T53;
			 T5p = T5m - T5o;
			 T5q = T30 - T2U;
			 T5r = T5p + T5q;
			 T6f = T5q - T5p;
		    }
	       }
	       {
		    E T1O, T4N, T27, T4t, T1U, T4P, T21, T4r;
		    {
			 E T1K, T1N, T1L, T4M, T1J, T1M;
			 T1K = Ip[0];
			 T1N = Im[0];
			 T1J = W[0];
			 T1L = T1J * T1K;
			 T4M = T1J * T1N;
			 T1M = W[1];
			 T1O = FMA(T1M, T1N, T1L);
			 T4N = FNMS(T1M, T1K, T4M);
		    }
		    {
			 E T23, T26, T24, T4s, T22, T25;
			 T23 = Ip[WS(rs, 12)];
			 T26 = Im[WS(rs, 12)];
			 T22 = W[48];
			 T24 = T22 * T23;
			 T4s = T22 * T26;
			 T25 = W[49];
			 T27 = FMA(T25, T26, T24);
			 T4t = FNMS(T25, T23, T4s);
		    }
		    {
			 E T1Q, T1T, T1R, T4O, T1P, T1S;
			 T1Q = Ip[WS(rs, 8)];
			 T1T = Im[WS(rs, 8)];
			 T1P = W[32];
			 T1R = T1P * T1Q;
			 T4O = T1P * T1T;
			 T1S = W[33];
			 T1U = FMA(T1S, T1T, T1R);
			 T4P = FNMS(T1S, T1Q, T4O);
		    }
		    {
			 E T1X, T20, T1Y, T4q, T1W, T1Z;
			 T1X = Ip[WS(rs, 4)];
			 T20 = Im[WS(rs, 4)];
			 T1W = W[16];
			 T1Y = T1W * T1X;
			 T4q = T1W * T20;
			 T1Z = W[17];
			 T21 = FMA(T1Z, T20, T1Y);
			 T4r = FNMS(T1Z, T1X, T4q);
		    }
		    {
			 E T1V, T28, T6V, T6W;
			 T1V = T1O + T1U;
			 T28 = T21 + T27;
			 T29 = T1V + T28;
			 T70 = T1V - T28;
			 T6V = T4N + T4P;
			 T6W = T4r + T4t;
			 T6X = T6V - T6W;
			 T7I = T6V + T6W;
		    }
		    {
			 E T4p, T4u, T4Q, T4R;
			 T4p = T1O - T1U;
			 T4u = T4r - T4t;
			 T4v = T4p + T4u;
			 T65 = T4p - T4u;
			 T4Q = T4N - T4P;
			 T4R = T21 - T27;
			 T4S = T4Q - T4R;
			 T68 = T4Q + T4R;
		    }
	       }
	       {
		    E T38, T57, T3r, T5g, T3e, T59, T3l, T5e;
		    {
			 E T34, T37, T35, T56, T33, T36;
			 T34 = Ip[WS(rs, 1)];
			 T37 = Im[WS(rs, 1)];
			 T33 = W[4];
			 T35 = T33 * T34;
			 T56 = T33 * T37;
			 T36 = W[5];
			 T38 = FMA(T36, T37, T35);
			 T57 = FNMS(T36, T34, T56);
		    }
		    {
			 E T3n, T3q, T3o, T5f, T3m, T3p;
			 T3n = Ip[WS(rs, 5)];
			 T3q = Im[WS(rs, 5)];
			 T3m = W[20];
			 T3o = T3m * T3n;
			 T5f = T3m * T3q;
			 T3p = W[21];
			 T3r = FMA(T3p, T3q, T3o);
			 T5g = FNMS(T3p, T3n, T5f);
		    }
		    {
			 E T3a, T3d, T3b, T58, T39, T3c;
			 T3a = Ip[WS(rs, 9)];
			 T3d = Im[WS(rs, 9)];
			 T39 = W[36];
			 T3b = T39 * T3a;
			 T58 = T39 * T3d;
			 T3c = W[37];
			 T3e = FMA(T3c, T3d, T3b);
			 T59 = FNMS(T3c, T3a, T58);
		    }
		    {
			 E T3h, T3k, T3i, T5d, T3g, T3j;
			 T3h = Ip[WS(rs, 13)];
			 T3k = Im[WS(rs, 13)];
			 T3g = W[52];
			 T3i = T3g * T3h;
			 T5d = T3g * T3k;
			 T3j = W[53];
			 T3l = FMA(T3j, T3k, T3i);
			 T5e = FNMS(T3j, T3h, T5d);
		    }
		    {
			 E T3f, T3s, T7c, T7d;
			 T3f = T38 + T3e;
			 T3s = T3l + T3r;
			 T3t = T3f + T3s;
			 T76 = T3s - T3f;
			 T7c = T57 + T59;
			 T7d = T5e + T5g;
			 T7e = T7c - T7d;
			 T7O = T7c + T7d;
		    }
		    {
			 E T55, T5a, T5c, T5h;
			 T55 = T38 - T3e;
			 T5a = T57 - T59;
			 T5b = T55 + T5a;
			 T5s = T5a - T55;
			 T5c = T3l - T3r;
			 T5h = T5e - T5g;
			 T5i = T5c - T5h;
			 T5t = T5c + T5h;
		    }
	       }
	       {
		    E T2f, T4y, T2y, T4H, T2l, T4A, T2s, T4F;
		    {
			 E T2b, T2e, T2c, T4x, T2a, T2d;
			 T2b = Ip[WS(rs, 2)];
			 T2e = Im[WS(rs, 2)];
			 T2a = W[8];
			 T2c = T2a * T2b;
			 T4x = T2a * T2e;
			 T2d = W[9];
			 T2f = FMA(T2d, T2e, T2c);
			 T4y = FNMS(T2d, T2b, T4x);
		    }
		    {
			 E T2u, T2x, T2v, T4G, T2t, T2w;
			 T2u = Ip[WS(rs, 6)];
			 T2x = Im[WS(rs, 6)];
			 T2t = W[24];
			 T2v = T2t * T2u;
			 T4G = T2t * T2x;
			 T2w = W[25];
			 T2y = FMA(T2w, T2x, T2v);
			 T4H = FNMS(T2w, T2u, T4G);
		    }
		    {
			 E T2h, T2k, T2i, T4z, T2g, T2j;
			 T2h = Ip[WS(rs, 10)];
			 T2k = Im[WS(rs, 10)];
			 T2g = W[40];
			 T2i = T2g * T2h;
			 T4z = T2g * T2k;
			 T2j = W[41];
			 T2l = FMA(T2j, T2k, T2i);
			 T4A = FNMS(T2j, T2h, T4z);
		    }
		    {
			 E T2o, T2r, T2p, T4E, T2n, T2q;
			 T2o = Ip[WS(rs, 14)];
			 T2r = Im[WS(rs, 14)];
			 T2n = W[56];
			 T2p = T2n * T2o;
			 T4E = T2n * T2r;
			 T2q = W[57];
			 T2s = FMA(T2q, T2r, T2p);
			 T4F = FNMS(T2q, T2o, T4E);
		    }
		    {
			 E T2m, T2z, T71, T72;
			 T2m = T2f + T2l;
			 T2z = T2s + T2y;
			 T2A = T2m + T2z;
			 T6Y = T2z - T2m;
			 T71 = T4y + T4A;
			 T72 = T4F + T4H;
			 T73 = T71 - T72;
			 T7J = T71 + T72;
		    }
		    {
			 E T4w, T4B, T4D, T4I;
			 T4w = T2f - T2l;
			 T4B = T4y - T4A;
			 T4C = T4w + T4B;
			 T4T = T4B - T4w;
			 T4D = T2s - T2y;
			 T4I = T4F - T4H;
			 T4J = T4D - T4I;
			 T4U = T4D + T4I;
		    }
	       }
	       {
		    E TO, T7C, T7Z, T80, T89, T8e, T1H, T8d, T3v, T8b, T7L, T7T, T7Q, T7U, T7F;
		    E T81;
		    {
			 E Tm, TN, T7X, T7Y;
			 Tm = T8 + Tl;
			 TN = Tz + TM;
			 TO = Tm + TN;
			 T7C = Tm - TN;
			 T7X = T7I + T7J;
			 T7Y = T7N + T7O;
			 T7Z = T7X - T7Y;
			 T80 = T7X + T7Y;
		    }
		    {
			 E T82, T88, T1f, T1G;
			 T82 = T6F + T6G;
			 T88 = T83 + T87;
			 T89 = T82 + T88;
			 T8e = T88 - T82;
			 T1f = T11 + T1e;
			 T1G = T1s + T1F;
			 T1H = T1f + T1G;
			 T8d = T1G - T1f;
		    }
		    {
			 E T2B, T3u, T7H, T7K;
			 T2B = T29 + T2A;
			 T3u = T32 + T3t;
			 T3v = T2B + T3u;
			 T8b = T3u - T2B;
			 T7H = T29 - T2A;
			 T7K = T7I - T7J;
			 T7L = T7H + T7K;
			 T7T = T7K - T7H;
		    }
		    {
			 E T7M, T7P, T7D, T7E;
			 T7M = T32 - T3t;
			 T7P = T7N - T7O;
			 T7Q = T7M - T7P;
			 T7U = T7M + T7P;
			 T7D = T6J + T6K;
			 T7E = T6P + T6Q;
			 T7F = T7D - T7E;
			 T81 = T7D + T7E;
		    }
		    {
			 E T1I, T8a, T7W, T8c;
			 T1I = TO + T1H;
			 Rm[WS(rs, 15)] = T1I - T3v;
			 Rp[0] = T1I + T3v;
			 T8a = T81 + T89;
			 Im[WS(rs, 15)] = T80 - T8a;
			 Ip[0] = T80 + T8a;
			 T7W = TO - T1H;
			 Rm[WS(rs, 7)] = T7W - T7Z;
			 Rp[WS(rs, 8)] = T7W + T7Z;
			 T8c = T89 - T81;
			 Im[WS(rs, 7)] = T8b - T8c;
			 Ip[WS(rs, 8)] = T8b + T8c;
		    }
		    {
			 E T7G, T7R, T8f, T8g;
			 T7G = T7C + T7F;
			 T7R = T7L + T7Q;
			 Rm[WS(rs, 11)] = FNMS(KP707106781, T7R, T7G);
			 Rp[WS(rs, 4)] = FMA(KP707106781, T7R, T7G);
			 T8f = T8d + T8e;
			 T8g = T7T + T7U;
			 Im[WS(rs, 11)] = FMS(KP707106781, T8g, T8f);
			 Ip[WS(rs, 4)] = FMA(KP707106781, T8g, T8f);
		    }
		    {
			 E T7S, T7V, T8h, T8i;
			 T7S = T7C - T7F;
			 T7V = T7T - T7U;
			 Rm[WS(rs, 3)] = FNMS(KP707106781, T7V, T7S);
			 Rp[WS(rs, 12)] = FMA(KP707106781, T7V, T7S);
			 T8h = T8e - T8d;
			 T8i = T7Q - T7L;
			 Im[WS(rs, 3)] = FMS(KP707106781, T8i, T8h);
			 Ip[WS(rs, 12)] = FMA(KP707106781, T8i, T8h);
		    }
	       }
	       {
		    E T6I, T7m, T7w, T7A, T8l, T8r, T6T, T8m, T75, T7j, T7p, T8s, T7t, T7z, T7g;
		    E T7k;
		    {
			 E T6E, T6H, T7u, T7v;
			 T6E = T8 - Tl;
			 T6H = T6F - T6G;
			 T6I = T6E - T6H;
			 T7m = T6E + T6H;
			 T7u = T7b + T7e;
			 T7v = T79 + T76;
			 T7w = FNMS(KP414213562, T7v, T7u);
			 T7A = FMA(KP414213562, T7u, T7v);
		    }
		    {
			 E T8j, T8k, T6N, T6S;
			 T8j = TM - Tz;
			 T8k = T87 - T83;
			 T8l = T8j + T8k;
			 T8r = T8k - T8j;
			 T6N = T6L - T6M;
			 T6S = T6O + T6R;
			 T6T = T6N - T6S;
			 T8m = T6N + T6S;
		    }
		    {
			 E T6Z, T74, T7n, T7o;
			 T6Z = T6X - T6Y;
			 T74 = T70 - T73;
			 T75 = FMA(KP414213562, T74, T6Z);
			 T7j = FNMS(KP414213562, T6Z, T74);
			 T7n = T6M + T6L;
			 T7o = T6O - T6R;
			 T7p = T7n + T7o;
			 T8s = T7o - T7n;
		    }
		    {
			 E T7r, T7s, T7a, T7f;
			 T7r = T70 + T73;
			 T7s = T6X + T6Y;
			 T7t = FMA(KP414213562, T7s, T7r);
			 T7z = FNMS(KP414213562, T7r, T7s);
			 T7a = T76 - T79;
			 T7f = T7b - T7e;
			 T7g = FMA(KP414213562, T7f, T7a);
			 T7k = FNMS(KP414213562, T7a, T7f);
		    }
		    {
			 E T6U, T7h, T8t, T8u;
			 T6U = FMA(KP707106781, T6T, T6I);
			 T7h = T75 + T7g;
			 Rm[WS(rs, 9)] = FNMS(KP923879532, T7h, T6U);
			 Rp[WS(rs, 6)] = FMA(KP923879532, T7h, T6U);
			 T8t = FMA(KP707106781, T8s, T8r);
			 T8u = T7k - T7j;
			 Im[WS(rs, 9)] = FMS(KP923879532, T8u, T8t);
			 Ip[WS(rs, 6)] = FMA(KP923879532, T8u, T8t);
		    }
		    {
			 E T7i, T7l, T8v, T8w;
			 T7i = FNMS(KP707106781, T6T, T6I);
			 T7l = T7j + T7k;
			 Rp[WS(rs, 14)] = FNMS(KP923879532, T7l, T7i);
			 Rm[WS(rs, 1)] = FMA(KP923879532, T7l, T7i);
			 T8v = FNMS(KP707106781, T8s, T8r);
			 T8w = T7g - T75;
			 Im[WS(rs, 1)] = FMS(KP923879532, T8w, T8v);
			 Ip[WS(rs, 14)] = FMA(KP923879532, T8w, T8v);
		    }
		    {
			 E T7q, T7x, T8n, T8o;
			 T7q = FMA(KP707106781, T7p, T7m);
			 T7x = T7t + T7w;
			 Rm[WS(rs, 13)] = FNMS(KP923879532, T7x, T7q);
			 Rp[WS(rs, 2)] = FMA(KP923879532, T7x, T7q);
			 T8n = FMA(KP707106781, T8m, T8l);
			 T8o = T7z + T7A;
			 Im[WS(rs, 13)] = FMS(KP923879532, T8o, T8n);
			 Ip[WS(rs, 2)] = FMA(KP923879532, T8o, T8n);
		    }
		    {
			 E T7y, T7B, T8p, T8q;
			 T7y = FNMS(KP707106781, T7p, T7m);
			 T7B = T7z - T7A;
			 Rm[WS(rs, 5)] = FNMS(KP923879532, T7B, T7y);
			 Rp[WS(rs, 10)] = FMA(KP923879532, T7B, T7y);
			 T8p = FNMS(KP707106781, T8m, T8l);
			 T8q = T7w - T7t;
			 Im[WS(rs, 5)] = FMS(KP923879532, T8q, T8p);
			 Ip[WS(rs, 10)] = FMA(KP923879532, T8q, T8p);
		    }
	       }
	       {
		    E T3S, T5C, T4n, T8I, T8B, T8H, T5F, T8C, T5w, T5Q, T5A, T5M, T4X, T5P, T5z;
		    E T5J;
		    {
			 E T3C, T3R, T5D, T5E;
			 T3C = T3w + T3B;
			 T3R = T3J + T3Q;
			 T3S = FMA(KP707106781, T3R, T3C);
			 T5C = FNMS(KP707106781, T3R, T3C);
			 {
			      E T47, T4m, T8z, T8A;
			      T47 = FMA(KP414213562, T46, T3Z);
			      T4m = FNMS(KP414213562, T4l, T4e);
			      T4n = T47 + T4m;
			      T8I = T4m - T47;
			      T8z = T8x - T8y;
			      T8A = T5T + T5U;
			      T8B = FMA(KP707106781, T8A, T8z);
			      T8H = FNMS(KP707106781, T8A, T8z);
			 }
			 T5D = FNMS(KP414213562, T3Z, T46);
			 T5E = FMA(KP414213562, T4e, T4l);
			 T5F = T5D - T5E;
			 T8C = T5D + T5E;
			 {
			      E T5k, T5K, T5v, T5L, T5j, T5u;
			      T5j = T5b + T5i;
			      T5k = FMA(KP707106781, T5j, T54);
			      T5K = FNMS(KP707106781, T5j, T54);
			      T5u = T5s + T5t;
			      T5v = FMA(KP707106781, T5u, T5r);
			      T5L = FNMS(KP707106781, T5u, T5r);
			      T5w = FNMS(KP198912367, T5v, T5k);
			      T5Q = FNMS(KP668178637, T5K, T5L);
			      T5A = FMA(KP198912367, T5k, T5v);
			      T5M = FMA(KP668178637, T5L, T5K);
			 }
			 {
			      E T4L, T5H, T4W, T5I, T4K, T4V;
			      T4K = T4C + T4J;
			      T4L = FMA(KP707106781, T4K, T4v);
			      T5H = FNMS(KP707106781, T4K, T4v);
			      T4V = T4T + T4U;
			      T4W = FMA(KP707106781, T4V, T4S);
			      T5I = FNMS(KP707106781, T4V, T4S);
			      T4X = FMA(KP198912367, T4W, T4L);
			      T5P = FMA(KP668178637, T5H, T5I);
			      T5z = FNMS(KP198912367, T4L, T4W);
			      T5J = FNMS(KP668178637, T5I, T5H);
			 }
		    }
		    {
			 E T4o, T5x, T8D, T8E;
			 T4o = FMA(KP923879532, T4n, T3S);
			 T5x = T4X + T5w;
			 Rm[WS(rs, 14)] = FNMS(KP980785280, T5x, T4o);
			 Rp[WS(rs, 1)] = FMA(KP980785280, T5x, T4o);
			 T8D = FMA(KP923879532, T8C, T8B);
			 T8E = T5z + T5A;
			 Im[WS(rs, 14)] = FMS(KP980785280, T8E, T8D);
			 Ip[WS(rs, 1)] = FMA(KP980785280, T8E, T8D);
		    }
		    {
			 E T5y, T5B, T8F, T8G;
			 T5y = FNMS(KP923879532, T4n, T3S);
			 T5B = T5z - T5A;
			 Rm[WS(rs, 6)] = FNMS(KP980785280, T5B, T5y);
			 Rp[WS(rs, 9)] = FMA(KP980785280, T5B, T5y);
			 T8F = FNMS(KP923879532, T8C, T8B);
			 T8G = T5w - T4X;
			 Im[WS(rs, 6)] = FMS(KP980785280, T8G, T8F);
			 Ip[WS(rs, 9)] = FMA(KP980785280, T8G, T8F);
		    }
		    {
			 E T5G, T5N, T8L, T8M;
			 T5G = FNMS(KP923879532, T5F, T5C);
			 T5N = T5J + T5M;
			 Rp[WS(rs, 13)] = FNMS(KP831469612, T5N, T5G);
			 Rm[WS(rs, 2)] = FMA(KP831469612, T5N, T5G);
			 T8L = FNMS(KP923879532, T8I, T8H);
			 T8M = T5P + T5Q;
			 Im[WS(rs, 2)] = -(FMA(KP831469612, T8M, T8L));
			 Ip[WS(rs, 13)] = FNMS(KP831469612, T8M, T8L);
		    }
		    {
			 E T5O, T5R, T8J, T8K;
			 T5O = FMA(KP923879532, T5F, T5C);
			 T5R = T5P - T5Q;
			 Rm[WS(rs, 10)] = FNMS(KP831469612, T5R, T5O);
			 Rp[WS(rs, 5)] = FMA(KP831469612, T5R, T5O);
			 T8J = FMA(KP923879532, T8I, T8H);
			 T8K = T5M - T5J;
			 Im[WS(rs, 10)] = FMS(KP831469612, T8K, T8J);
			 Ip[WS(rs, 5)] = FMA(KP831469612, T8K, T8J);
		    }
	       }
	       {
		    E T5W, T6o, T63, T8W, T8P, T8V, T6r, T8Q, T6i, T6C, T6m, T6y, T6b, T6B, T6l;
		    E T6v;
		    {
			 E T5S, T5V, T6p, T6q;
			 T5S = T3w - T3B;
			 T5V = T5T - T5U;
			 T5W = FMA(KP707106781, T5V, T5S);
			 T6o = FNMS(KP707106781, T5V, T5S);
			 {
			      E T5Z, T62, T8N, T8O;
			      T5Z = FMA(KP414213562, T5Y, T5X);
			      T62 = FNMS(KP414213562, T61, T60);
			      T63 = T5Z - T62;
			      T8W = T5Z + T62;
			      T8N = T8y + T8x;
			      T8O = T3Q - T3J;
			      T8P = FMA(KP707106781, T8O, T8N);
			      T8V = FNMS(KP707106781, T8O, T8N);
			 }
			 T6p = FNMS(KP414213562, T5X, T5Y);
			 T6q = FMA(KP414213562, T60, T61);
			 T6r = T6p + T6q;
			 T8Q = T6q - T6p;
			 {
			      E T6e, T6x, T6h, T6w, T6d, T6g;
			      T6d = T5t - T5s;
			      T6e = FNMS(KP707106781, T6d, T6c);
			      T6x = FMA(KP707106781, T6d, T6c);
			      T6g = T5i - T5b;
			      T6h = FNMS(KP707106781, T6g, T6f);
			      T6w = FMA(KP707106781, T6g, T6f);
			      T6i = FMA(KP668178637, T6h, T6e);
			      T6C = FNMS(KP198912367, T6w, T6x);
			      T6m = FNMS(KP668178637, T6e, T6h);
			      T6y = FMA(KP198912367, T6x, T6w);
			 }
			 {
			      E T67, T6u, T6a, T6t, T66, T69;
			      T66 = T4U - T4T;
			      T67 = FNMS(KP707106781, T66, T65);
			      T6u = FMA(KP707106781, T66, T65);
			      T69 = T4C - T4J;
			      T6a = FNMS(KP707106781, T69, T68);
			      T6t = FMA(KP707106781, T69, T68);
			      T6b = FMA(KP668178637, T6a, T67);
			      T6B = FNMS(KP198912367, T6t, T6u);
			      T6l = FNMS(KP668178637, T67, T6a);
			      T6v = FMA(KP198912367, T6u, T6t);
			 }
		    }
		    {
			 E T64, T6j, T8R, T8S;
			 T64 = FMA(KP923879532, T63, T5W);
			 T6j = T6b + T6i;
			 Rm[WS(rs, 12)] = FNMS(KP831469612, T6j, T64);
			 Rp[WS(rs, 3)] = FMA(KP831469612, T6j, T64);
			 T8R = FMA(KP923879532, T8Q, T8P);
			 T8S = T6l - T6m;
			 Im[WS(rs, 12)] = FMS(KP831469612, T8S, T8R);
			 Ip[WS(rs, 3)] = FMA(KP831469612, T8S, T8R);
		    }
		    {
			 E T6k, T6n, T8T, T8U;
			 T6k = FNMS(KP923879532, T63, T5W);
			 T6n = T6l + T6m;
			 Rm[WS(rs, 4)] = FNMS(KP831469612, T6n, T6k);
			 Rp[WS(rs, 11)] = FMA(KP831469612, T6n, T6k);
			 T8T = FNMS(KP923879532, T8Q, T8P);
			 T8U = T6i - T6b;
			 Im[WS(rs, 4)] = FMS(KP831469612, T8U, T8T);
			 Ip[WS(rs, 11)] = FMA(KP831469612, T8U, T8T);
		    }
		    {
			 E T6s, T6z, T8X, T8Y;
			 T6s = FNMS(KP923879532, T6r, T6o);
			 T6z = T6v + T6y;
			 Rm[WS(rs, 8)] = FNMS(KP980785280, T6z, T6s);
			 Rp[WS(rs, 7)] = FMA(KP980785280, T6z, T6s);
			 T8X = FNMS(KP923879532, T8W, T8V);
			 T8Y = T6C - T6B;
			 Im[WS(rs, 8)] = FMS(KP980785280, T8Y, T8X);
			 Ip[WS(rs, 7)] = FMA(KP980785280, T8Y, T8X);
		    }
		    {
			 E T6A, T6D, T8Z, T90;
			 T6A = FMA(KP923879532, T6r, T6o);
			 T6D = T6B + T6C;
			 Rp[WS(rs, 15)] = FNMS(KP980785280, T6D, T6A);
			 Rm[0] = FMA(KP980785280, T6D, T6A);
			 T8Z = FMA(KP923879532, T8W, T8V);
			 T90 = T6y - T6v;
			 Im[0] = FMS(KP980785280, T90, T8Z);
			 Ip[WS(rs, 15)] = FMA(KP980785280, T90, T8Z);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cf_32", twinstr, &GENUS, {236, 62, 198, 0} };

void X(codelet_hc2cf_32) (planner *p) {
     X(khc2c_register) (p, hc2cf_32, &desc, HC2C_VIA_RDFT);
}
#else

/* Generated by: ../../../genfft/gen_hc2c.native -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hc2cf_32 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 434 FP additions, 208 FP multiplications,
 * (or, 340 additions, 114 multiplications, 94 fused multiply/add),
 * 96 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cf_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E Tj, T5F, T7C, T7Q, T35, T4T, T78, T7m, T1Q, T61, T5Y, T6J, T3K, T59, T41;
	       E T56, T2B, T67, T6e, T6O, T4b, T5d, T4s, T5g, TG, T7l, T5I, T73, T3a, T4U;
	       E T3f, T4V, T14, T5N, T5M, T6E, T3m, T4Y, T3r, T4Z, T1r, T5P, T5S, T6F, T3x;
	       E T51, T3C, T52, T2d, T5Z, T64, T6K, T3V, T57, T44, T5a, T2Y, T6f, T6a, T6P;
	       E T4m, T5h, T4v, T5e;
	       {
		    E T1, T76, T6, T75, Tc, T32, Th, T33;
		    T1 = Rp[0];
		    T76 = Rm[0];
		    {
			 E T3, T5, T2, T4;
			 T3 = Rp[WS(rs, 8)];
			 T5 = Rm[WS(rs, 8)];
			 T2 = W[30];
			 T4 = W[31];
			 T6 = FMA(T2, T3, T4 * T5);
			 T75 = FNMS(T4, T3, T2 * T5);
		    }
		    {
			 E T9, Tb, T8, Ta;
			 T9 = Rp[WS(rs, 4)];
			 Tb = Rm[WS(rs, 4)];
			 T8 = W[14];
			 Ta = W[15];
			 Tc = FMA(T8, T9, Ta * Tb);
			 T32 = FNMS(Ta, T9, T8 * Tb);
		    }
		    {
			 E Te, Tg, Td, Tf;
			 Te = Rp[WS(rs, 12)];
			 Tg = Rm[WS(rs, 12)];
			 Td = W[46];
			 Tf = W[47];
			 Th = FMA(Td, Te, Tf * Tg);
			 T33 = FNMS(Tf, Te, Td * Tg);
		    }
		    {
			 E T7, Ti, T7A, T7B;
			 T7 = T1 + T6;
			 Ti = Tc + Th;
			 Tj = T7 + Ti;
			 T5F = T7 - Ti;
			 T7A = T76 - T75;
			 T7B = Tc - Th;
			 T7C = T7A - T7B;
			 T7Q = T7B + T7A;
		    }
		    {
			 E T31, T34, T74, T77;
			 T31 = T1 - T6;
			 T34 = T32 - T33;
			 T35 = T31 - T34;
			 T4T = T31 + T34;
			 T74 = T32 + T33;
			 T77 = T75 + T76;
			 T78 = T74 + T77;
			 T7m = T77 - T74;
		    }
	       }
	       {
		    E T1y, T3G, T1O, T3Z, T1D, T3H, T1J, T3Y;
		    {
			 E T1v, T1x, T1u, T1w;
			 T1v = Ip[0];
			 T1x = Im[0];
			 T1u = W[0];
			 T1w = W[1];
			 T1y = FMA(T1u, T1v, T1w * T1x);
			 T3G = FNMS(T1w, T1v, T1u * T1x);
		    }
		    {
			 E T1L, T1N, T1K, T1M;
			 T1L = Ip[WS(rs, 12)];
			 T1N = Im[WS(rs, 12)];
			 T1K = W[48];
			 T1M = W[49];
			 T1O = FMA(T1K, T1L, T1M * T1N);
			 T3Z = FNMS(T1M, T1L, T1K * T1N);
		    }
		    {
			 E T1A, T1C, T1z, T1B;
			 T1A = Ip[WS(rs, 8)];
			 T1C = Im[WS(rs, 8)];
			 T1z = W[32];
			 T1B = W[33];
			 T1D = FMA(T1z, T1A, T1B * T1C);
			 T3H = FNMS(T1B, T1A, T1z * T1C);
		    }
		    {
			 E T1G, T1I, T1F, T1H;
			 T1G = Ip[WS(rs, 4)];
			 T1I = Im[WS(rs, 4)];
			 T1F = W[16];
			 T1H = W[17];
			 T1J = FMA(T1F, T1G, T1H * T1I);
			 T3Y = FNMS(T1H, T1G, T1F * T1I);
		    }
		    {
			 E T1E, T1P, T5W, T5X;
			 T1E = T1y + T1D;
			 T1P = T1J + T1O;
			 T1Q = T1E + T1P;
			 T61 = T1E - T1P;
			 T5W = T3G + T3H;
			 T5X = T3Y + T3Z;
			 T5Y = T5W - T5X;
			 T6J = T5W + T5X;
		    }
		    {
			 E T3I, T3J, T3X, T40;
			 T3I = T3G - T3H;
			 T3J = T1J - T1O;
			 T3K = T3I + T3J;
			 T59 = T3I - T3J;
			 T3X = T1y - T1D;
			 T40 = T3Y - T3Z;
			 T41 = T3X - T40;
			 T56 = T3X + T40;
		    }
	       }
	       {
		    E T2j, T4o, T2z, T49, T2o, T4p, T2u, T48;
		    {
			 E T2g, T2i, T2f, T2h;
			 T2g = Ip[WS(rs, 15)];
			 T2i = Im[WS(rs, 15)];
			 T2f = W[60];
			 T2h = W[61];
			 T2j = FMA(T2f, T2g, T2h * T2i);
			 T4o = FNMS(T2h, T2g, T2f * T2i);
		    }
		    {
			 E T2w, T2y, T2v, T2x;
			 T2w = Ip[WS(rs, 11)];
			 T2y = Im[WS(rs, 11)];
			 T2v = W[44];
			 T2x = W[45];
			 T2z = FMA(T2v, T2w, T2x * T2y);
			 T49 = FNMS(T2x, T2w, T2v * T2y);
		    }
		    {
			 E T2l, T2n, T2k, T2m;
			 T2l = Ip[WS(rs, 7)];
			 T2n = Im[WS(rs, 7)];
			 T2k = W[28];
			 T2m = W[29];
			 T2o = FMA(T2k, T2l, T2m * T2n);
			 T4p = FNMS(T2m, T2l, T2k * T2n);
		    }
		    {
			 E T2r, T2t, T2q, T2s;
			 T2r = Ip[WS(rs, 3)];
			 T2t = Im[WS(rs, 3)];
			 T2q = W[12];
			 T2s = W[13];
			 T2u = FMA(T2q, T2r, T2s * T2t);
			 T48 = FNMS(T2s, T2r, T2q * T2t);
		    }
		    {
			 E T2p, T2A, T6c, T6d;
			 T2p = T2j + T2o;
			 T2A = T2u + T2z;
			 T2B = T2p + T2A;
			 T67 = T2p - T2A;
			 T6c = T4o + T4p;
			 T6d = T48 + T49;
			 T6e = T6c - T6d;
			 T6O = T6c + T6d;
		    }
		    {
			 E T47, T4a, T4q, T4r;
			 T47 = T2j - T2o;
			 T4a = T48 - T49;
			 T4b = T47 - T4a;
			 T5d = T47 + T4a;
			 T4q = T4o - T4p;
			 T4r = T2u - T2z;
			 T4s = T4q + T4r;
			 T5g = T4q - T4r;
		    }
	       }
	       {
		    E To, T36, TE, T3d, Tt, T37, Tz, T3c;
		    {
			 E Tl, Tn, Tk, Tm;
			 Tl = Rp[WS(rs, 2)];
			 Tn = Rm[WS(rs, 2)];
			 Tk = W[6];
			 Tm = W[7];
			 To = FMA(Tk, Tl, Tm * Tn);
			 T36 = FNMS(Tm, Tl, Tk * Tn);
		    }
		    {
			 E TB, TD, TA, TC;
			 TB = Rp[WS(rs, 6)];
			 TD = Rm[WS(rs, 6)];
			 TA = W[22];
			 TC = W[23];
			 TE = FMA(TA, TB, TC * TD);
			 T3d = FNMS(TC, TB, TA * TD);
		    }
		    {
			 E Tq, Ts, Tp, Tr;
			 Tq = Rp[WS(rs, 10)];
			 Ts = Rm[WS(rs, 10)];
			 Tp = W[38];
			 Tr = W[39];
			 Tt = FMA(Tp, Tq, Tr * Ts);
			 T37 = FNMS(Tr, Tq, Tp * Ts);
		    }
		    {
			 E Tw, Ty, Tv, Tx;
			 Tw = Rp[WS(rs, 14)];
			 Ty = Rm[WS(rs, 14)];
			 Tv = W[54];
			 Tx = W[55];
			 Tz = FMA(Tv, Tw, Tx * Ty);
			 T3c = FNMS(Tx, Tw, Tv * Ty);
		    }
		    {
			 E Tu, TF, T5G, T5H;
			 Tu = To + Tt;
			 TF = Tz + TE;
			 TG = Tu + TF;
			 T7l = TF - Tu;
			 T5G = T36 + T37;
			 T5H = T3c + T3d;
			 T5I = T5G - T5H;
			 T73 = T5G + T5H;
		    }
		    {
			 E T38, T39, T3b, T3e;
			 T38 = T36 - T37;
			 T39 = To - Tt;
			 T3a = T38 - T39;
			 T4U = T39 + T38;
			 T3b = Tz - TE;
			 T3e = T3c - T3d;
			 T3f = T3b + T3e;
			 T4V = T3b - T3e;
		    }
	       }
	       {
		    E TM, T3i, T12, T3p, TR, T3j, TX, T3o;
		    {
			 E TJ, TL, TI, TK;
			 TJ = Rp[WS(rs, 1)];
			 TL = Rm[WS(rs, 1)];
			 TI = W[2];
			 TK = W[3];
			 TM = FMA(TI, TJ, TK * TL);
			 T3i = FNMS(TK, TJ, TI * TL);
		    }
		    {
			 E TZ, T11, TY, T10;
			 TZ = Rp[WS(rs, 13)];
			 T11 = Rm[WS(rs, 13)];
			 TY = W[50];
			 T10 = W[51];
			 T12 = FMA(TY, TZ, T10 * T11);
			 T3p = FNMS(T10, TZ, TY * T11);
		    }
		    {
			 E TO, TQ, TN, TP;
			 TO = Rp[WS(rs, 9)];
			 TQ = Rm[WS(rs, 9)];
			 TN = W[34];
			 TP = W[35];
			 TR = FMA(TN, TO, TP * TQ);
			 T3j = FNMS(TP, TO, TN * TQ);
		    }
		    {
			 E TU, TW, TT, TV;
			 TU = Rp[WS(rs, 5)];
			 TW = Rm[WS(rs, 5)];
			 TT = W[18];
			 TV = W[19];
			 TX = FMA(TT, TU, TV * TW);
			 T3o = FNMS(TV, TU, TT * TW);
		    }
		    {
			 E TS, T13, T5K, T5L;
			 TS = TM + TR;
			 T13 = TX + T12;
			 T14 = TS + T13;
			 T5N = TS - T13;
			 T5K = T3i + T3j;
			 T5L = T3o + T3p;
			 T5M = T5K - T5L;
			 T6E = T5K + T5L;
		    }
		    {
			 E T3k, T3l, T3n, T3q;
			 T3k = T3i - T3j;
			 T3l = TX - T12;
			 T3m = T3k + T3l;
			 T4Y = T3k - T3l;
			 T3n = TM - TR;
			 T3q = T3o - T3p;
			 T3r = T3n - T3q;
			 T4Z = T3n + T3q;
		    }
	       }
	       {
		    E T19, T3t, T1p, T3A, T1e, T3u, T1k, T3z;
		    {
			 E T16, T18, T15, T17;
			 T16 = Rp[WS(rs, 15)];
			 T18 = Rm[WS(rs, 15)];
			 T15 = W[58];
			 T17 = W[59];
			 T19 = FMA(T15, T16, T17 * T18);
			 T3t = FNMS(T17, T16, T15 * T18);
		    }
		    {
			 E T1m, T1o, T1l, T1n;
			 T1m = Rp[WS(rs, 11)];
			 T1o = Rm[WS(rs, 11)];
			 T1l = W[42];
			 T1n = W[43];
			 T1p = FMA(T1l, T1m, T1n * T1o);
			 T3A = FNMS(T1n, T1m, T1l * T1o);
		    }
		    {
			 E T1b, T1d, T1a, T1c;
			 T1b = Rp[WS(rs, 7)];
			 T1d = Rm[WS(rs, 7)];
			 T1a = W[26];
			 T1c = W[27];
			 T1e = FMA(T1a, T1b, T1c * T1d);
			 T3u = FNMS(T1c, T1b, T1a * T1d);
		    }
		    {
			 E T1h, T1j, T1g, T1i;
			 T1h = Rp[WS(rs, 3)];
			 T1j = Rm[WS(rs, 3)];
			 T1g = W[10];
			 T1i = W[11];
			 T1k = FMA(T1g, T1h, T1i * T1j);
			 T3z = FNMS(T1i, T1h, T1g * T1j);
		    }
		    {
			 E T1f, T1q, T5Q, T5R;
			 T1f = T19 + T1e;
			 T1q = T1k + T1p;
			 T1r = T1f + T1q;
			 T5P = T1f - T1q;
			 T5Q = T3t + T3u;
			 T5R = T3z + T3A;
			 T5S = T5Q - T5R;
			 T6F = T5Q + T5R;
		    }
		    {
			 E T3v, T3w, T3y, T3B;
			 T3v = T3t - T3u;
			 T3w = T1k - T1p;
			 T3x = T3v + T3w;
			 T51 = T3v - T3w;
			 T3y = T19 - T1e;
			 T3B = T3z - T3A;
			 T3C = T3y - T3B;
			 T52 = T3y + T3B;
		    }
	       }
	       {
		    E T1V, T3R, T20, T3S, T3Q, T3T, T26, T3M, T2b, T3N, T3L, T3O;
		    {
			 E T1S, T1U, T1R, T1T;
			 T1S = Ip[WS(rs, 2)];
			 T1U = Im[WS(rs, 2)];
			 T1R = W[8];
			 T1T = W[9];
			 T1V = FMA(T1R, T1S, T1T * T1U);
			 T3R = FNMS(T1T, T1S, T1R * T1U);
		    }
		    {
			 E T1X, T1Z, T1W, T1Y;
			 T1X = Ip[WS(rs, 10)];
			 T1Z = Im[WS(rs, 10)];
			 T1W = W[40];
			 T1Y = W[41];
			 T20 = FMA(T1W, T1X, T1Y * T1Z);
			 T3S = FNMS(T1Y, T1X, T1W * T1Z);
		    }
		    T3Q = T1V - T20;
		    T3T = T3R - T3S;
		    {
			 E T23, T25, T22, T24;
			 T23 = Ip[WS(rs, 14)];
			 T25 = Im[WS(rs, 14)];
			 T22 = W[56];
			 T24 = W[57];
			 T26 = FMA(T22, T23, T24 * T25);
			 T3M = FNMS(T24, T23, T22 * T25);
		    }
		    {
			 E T28, T2a, T27, T29;
			 T28 = Ip[WS(rs, 6)];
			 T2a = Im[WS(rs, 6)];
			 T27 = W[24];
			 T29 = W[25];
			 T2b = FMA(T27, T28, T29 * T2a);
			 T3N = FNMS(T29, T28, T27 * T2a);
		    }
		    T3L = T26 - T2b;
		    T3O = T3M - T3N;
		    {
			 E T21, T2c, T62, T63;
			 T21 = T1V + T20;
			 T2c = T26 + T2b;
			 T2d = T21 + T2c;
			 T5Z = T2c - T21;
			 T62 = T3R + T3S;
			 T63 = T3M + T3N;
			 T64 = T62 - T63;
			 T6K = T62 + T63;
		    }
		    {
			 E T3P, T3U, T42, T43;
			 T3P = T3L - T3O;
			 T3U = T3Q + T3T;
			 T3V = KP707106781 * (T3P - T3U);
			 T57 = KP707106781 * (T3U + T3P);
			 T42 = T3T - T3Q;
			 T43 = T3L + T3O;
			 T44 = KP707106781 * (T42 - T43);
			 T5a = KP707106781 * (T42 + T43);
		    }
	       }
	       {
		    E T2G, T4c, T2L, T4d, T4e, T4f, T2R, T4i, T2W, T4j, T4h, T4k;
		    {
			 E T2D, T2F, T2C, T2E;
			 T2D = Ip[WS(rs, 1)];
			 T2F = Im[WS(rs, 1)];
			 T2C = W[4];
			 T2E = W[5];
			 T2G = FMA(T2C, T2D, T2E * T2F);
			 T4c = FNMS(T2E, T2D, T2C * T2F);
		    }
		    {
			 E T2I, T2K, T2H, T2J;
			 T2I = Ip[WS(rs, 9)];
			 T2K = Im[WS(rs, 9)];
			 T2H = W[36];
			 T2J = W[37];
			 T2L = FMA(T2H, T2I, T2J * T2K);
			 T4d = FNMS(T2J, T2I, T2H * T2K);
		    }
		    T4e = T4c - T4d;
		    T4f = T2G - T2L;
		    {
			 E T2O, T2Q, T2N, T2P;
			 T2O = Ip[WS(rs, 13)];
			 T2Q = Im[WS(rs, 13)];
			 T2N = W[52];
			 T2P = W[53];
			 T2R = FMA(T2N, T2O, T2P * T2Q);
			 T4i = FNMS(T2P, T2O, T2N * T2Q);
		    }
		    {
			 E T2T, T2V, T2S, T2U;
			 T2T = Ip[WS(rs, 5)];
			 T2V = Im[WS(rs, 5)];
			 T2S = W[20];
			 T2U = W[21];
			 T2W = FMA(T2S, T2T, T2U * T2V);
			 T4j = FNMS(T2U, T2T, T2S * T2V);
		    }
		    T4h = T2R - T2W;
		    T4k = T4i - T4j;
		    {
			 E T2M, T2X, T68, T69;
			 T2M = T2G + T2L;
			 T2X = T2R + T2W;
			 T2Y = T2M + T2X;
			 T6f = T2X - T2M;
			 T68 = T4c + T4d;
			 T69 = T4i + T4j;
			 T6a = T68 - T69;
			 T6P = T68 + T69;
		    }
		    {
			 E T4g, T4l, T4t, T4u;
			 T4g = T4e - T4f;
			 T4l = T4h + T4k;
			 T4m = KP707106781 * (T4g - T4l);
			 T5h = KP707106781 * (T4g + T4l);
			 T4t = T4h - T4k;
			 T4u = T4f + T4e;
			 T4v = KP707106781 * (T4t - T4u);
			 T5e = KP707106781 * (T4u + T4t);
		    }
	       }
	       {
		    E T1t, T6X, T7a, T7c, T30, T7b, T70, T71;
		    {
			 E TH, T1s, T72, T79;
			 TH = Tj + TG;
			 T1s = T14 + T1r;
			 T1t = TH + T1s;
			 T6X = TH - T1s;
			 T72 = T6E + T6F;
			 T79 = T73 + T78;
			 T7a = T72 + T79;
			 T7c = T79 - T72;
		    }
		    {
			 E T2e, T2Z, T6Y, T6Z;
			 T2e = T1Q + T2d;
			 T2Z = T2B + T2Y;
			 T30 = T2e + T2Z;
			 T7b = T2Z - T2e;
			 T6Y = T6J + T6K;
			 T6Z = T6O + T6P;
			 T70 = T6Y - T6Z;
			 T71 = T6Y + T6Z;
		    }
		    Rm[WS(rs, 15)] = T1t - T30;
		    Im[WS(rs, 15)] = T71 - T7a;
		    Rp[0] = T1t + T30;
		    Ip[0] = T71 + T7a;
		    Rm[WS(rs, 7)] = T6X - T70;
		    Im[WS(rs, 7)] = T7b - T7c;
		    Rp[WS(rs, 8)] = T6X + T70;
		    Ip[WS(rs, 8)] = T7b + T7c;
	       }
	       {
		    E T6H, T6T, T7g, T7i, T6M, T6U, T6R, T6V;
		    {
			 E T6D, T6G, T7e, T7f;
			 T6D = Tj - TG;
			 T6G = T6E - T6F;
			 T6H = T6D + T6G;
			 T6T = T6D - T6G;
			 T7e = T1r - T14;
			 T7f = T78 - T73;
			 T7g = T7e + T7f;
			 T7i = T7f - T7e;
		    }
		    {
			 E T6I, T6L, T6N, T6Q;
			 T6I = T1Q - T2d;
			 T6L = T6J - T6K;
			 T6M = T6I + T6L;
			 T6U = T6L - T6I;
			 T6N = T2B - T2Y;
			 T6Q = T6O - T6P;
			 T6R = T6N - T6Q;
			 T6V = T6N + T6Q;
		    }
		    {
			 E T6S, T7d, T6W, T7h;
			 T6S = KP707106781 * (T6M + T6R);
			 Rm[WS(rs, 11)] = T6H - T6S;
			 Rp[WS(rs, 4)] = T6H + T6S;
			 T7d = KP707106781 * (T6U + T6V);
			 Im[WS(rs, 11)] = T7d - T7g;
			 Ip[WS(rs, 4)] = T7d + T7g;
			 T6W = KP707106781 * (T6U - T6V);
			 Rm[WS(rs, 3)] = T6T - T6W;
			 Rp[WS(rs, 12)] = T6T + T6W;
			 T7h = KP707106781 * (T6R - T6M);
			 Im[WS(rs, 3)] = T7h - T7i;
			 Ip[WS(rs, 12)] = T7h + T7i;
		    }
	       }
	       {
		    E T5J, T7n, T7t, T6n, T5U, T7k, T6x, T6B, T6q, T7s, T66, T6k, T6u, T6A, T6h;
		    E T6l;
		    {
			 E T5O, T5T, T60, T65;
			 T5J = T5F - T5I;
			 T7n = T7l + T7m;
			 T7t = T7m - T7l;
			 T6n = T5F + T5I;
			 T5O = T5M - T5N;
			 T5T = T5P + T5S;
			 T5U = KP707106781 * (T5O - T5T);
			 T7k = KP707106781 * (T5O + T5T);
			 {
			      E T6v, T6w, T6o, T6p;
			      T6v = T67 + T6a;
			      T6w = T6e + T6f;
			      T6x = FNMS(KP382683432, T6w, KP923879532 * T6v);
			      T6B = FMA(KP923879532, T6w, KP382683432 * T6v);
			      T6o = T5N + T5M;
			      T6p = T5P - T5S;
			      T6q = KP707106781 * (T6o + T6p);
			      T7s = KP707106781 * (T6p - T6o);
			 }
			 T60 = T5Y - T5Z;
			 T65 = T61 - T64;
			 T66 = FMA(KP923879532, T60, KP382683432 * T65);
			 T6k = FNMS(KP923879532, T65, KP382683432 * T60);
			 {
			      E T6s, T6t, T6b, T6g;
			      T6s = T5Y + T5Z;
			      T6t = T61 + T64;
			      T6u = FMA(KP382683432, T6s, KP923879532 * T6t);
			      T6A = FNMS(KP382683432, T6t, KP923879532 * T6s);
			      T6b = T67 - T6a;
			      T6g = T6e - T6f;
			      T6h = FNMS(KP923879532, T6g, KP382683432 * T6b);
			      T6l = FMA(KP382683432, T6g, KP923879532 * T6b);
			 }
		    }
		    {
			 E T5V, T6i, T7r, T7u;
			 T5V = T5J + T5U;
			 T6i = T66 + T6h;
			 Rm[WS(rs, 9)] = T5V - T6i;
			 Rp[WS(rs, 6)] = T5V + T6i;
			 T7r = T6k + T6l;
			 T7u = T7s + T7t;
			 Im[WS(rs, 9)] = T7r - T7u;
			 Ip[WS(rs, 6)] = T7r + T7u;
		    }
		    {
			 E T6j, T6m, T7v, T7w;
			 T6j = T5J - T5U;
			 T6m = T6k - T6l;
			 Rm[WS(rs, 1)] = T6j - T6m;
			 Rp[WS(rs, 14)] = T6j + T6m;
			 T7v = T6h - T66;
			 T7w = T7t - T7s;
			 Im[WS(rs, 1)] = T7v - T7w;
			 Ip[WS(rs, 14)] = T7v + T7w;
		    }
		    {
			 E T6r, T6y, T7j, T7o;
			 T6r = T6n + T6q;
			 T6y = T6u + T6x;
			 Rm[WS(rs, 13)] = T6r - T6y;
			 Rp[WS(rs, 2)] = T6r + T6y;
			 T7j = T6A + T6B;
			 T7o = T7k + T7n;
			 Im[WS(rs, 13)] = T7j - T7o;
			 Ip[WS(rs, 2)] = T7j + T7o;
		    }
		    {
			 E T6z, T6C, T7p, T7q;
			 T6z = T6n - T6q;
			 T6C = T6A - T6B;
			 Rm[WS(rs, 5)] = T6z - T6C;
			 Rp[WS(rs, 10)] = T6z + T6C;
			 T7p = T6x - T6u;
			 T7q = T7n - T7k;
			 Im[WS(rs, 5)] = T7p - T7q;
			 Ip[WS(rs, 10)] = T7p + T7q;
		    }
	       }
	       {
		    E T3h, T4D, T7R, T7X, T3E, T7O, T4N, T4R, T46, T4A, T4G, T7W, T4K, T4Q, T4x;
		    E T4B, T3g, T7P;
		    T3g = KP707106781 * (T3a - T3f);
		    T3h = T35 - T3g;
		    T4D = T35 + T3g;
		    T7P = KP707106781 * (T4V - T4U);
		    T7R = T7P + T7Q;
		    T7X = T7Q - T7P;
		    {
			 E T3s, T3D, T4L, T4M;
			 T3s = FNMS(KP923879532, T3r, KP382683432 * T3m);
			 T3D = FMA(KP382683432, T3x, KP923879532 * T3C);
			 T3E = T3s - T3D;
			 T7O = T3s + T3D;
			 T4L = T4b + T4m;
			 T4M = T4s + T4v;
			 T4N = FNMS(KP555570233, T4M, KP831469612 * T4L);
			 T4R = FMA(KP831469612, T4M, KP555570233 * T4L);
		    }
		    {
			 E T3W, T45, T4E, T4F;
			 T3W = T3K - T3V;
			 T45 = T41 - T44;
			 T46 = FMA(KP980785280, T3W, KP195090322 * T45);
			 T4A = FNMS(KP980785280, T45, KP195090322 * T3W);
			 T4E = FMA(KP923879532, T3m, KP382683432 * T3r);
			 T4F = FNMS(KP923879532, T3x, KP382683432 * T3C);
			 T4G = T4E + T4F;
			 T7W = T4F - T4E;
		    }
		    {
			 E T4I, T4J, T4n, T4w;
			 T4I = T3K + T3V;
			 T4J = T41 + T44;
			 T4K = FMA(KP555570233, T4I, KP831469612 * T4J);
			 T4Q = FNMS(KP555570233, T4J, KP831469612 * T4I);
			 T4n = T4b - T4m;
			 T4w = T4s - T4v;
			 T4x = FNMS(KP980785280, T4w, KP195090322 * T4n);
			 T4B = FMA(KP195090322, T4w, KP980785280 * T4n);
		    }
		    {
			 E T3F, T4y, T7V, T7Y;
			 T3F = T3h + T3E;
			 T4y = T46 + T4x;
			 Rm[WS(rs, 8)] = T3F - T4y;
			 Rp[WS(rs, 7)] = T3F + T4y;
			 T7V = T4A + T4B;
			 T7Y = T7W + T7X;
			 Im[WS(rs, 8)] = T7V - T7Y;
			 Ip[WS(rs, 7)] = T7V + T7Y;
		    }
		    {
			 E T4z, T4C, T7Z, T80;
			 T4z = T3h - T3E;
			 T4C = T4A - T4B;
			 Rm[0] = T4z - T4C;
			 Rp[WS(rs, 15)] = T4z + T4C;
			 T7Z = T4x - T46;
			 T80 = T7X - T7W;
			 Im[0] = T7Z - T80;
			 Ip[WS(rs, 15)] = T7Z + T80;
		    }
		    {
			 E T4H, T4O, T7N, T7S;
			 T4H = T4D + T4G;
			 T4O = T4K + T4N;
			 Rm[WS(rs, 12)] = T4H - T4O;
			 Rp[WS(rs, 3)] = T4H + T4O;
			 T7N = T4Q + T4R;
			 T7S = T7O + T7R;
			 Im[WS(rs, 12)] = T7N - T7S;
			 Ip[WS(rs, 3)] = T7N + T7S;
		    }
		    {
			 E T4P, T4S, T7T, T7U;
			 T4P = T4D - T4G;
			 T4S = T4Q - T4R;
			 Rm[WS(rs, 4)] = T4P - T4S;
			 Rp[WS(rs, 11)] = T4P + T4S;
			 T7T = T4N - T4K;
			 T7U = T7R - T7O;
			 Im[WS(rs, 4)] = T7T - T7U;
			 Ip[WS(rs, 11)] = T7T + T7U;
		    }
	       }
	       {
		    E T4X, T5p, T7D, T7J, T54, T7y, T5z, T5D, T5c, T5m, T5s, T7I, T5w, T5C, T5j;
		    E T5n, T4W, T7z;
		    T4W = KP707106781 * (T4U + T4V);
		    T4X = T4T - T4W;
		    T5p = T4T + T4W;
		    T7z = KP707106781 * (T3a + T3f);
		    T7D = T7z + T7C;
		    T7J = T7C - T7z;
		    {
			 E T50, T53, T5x, T5y;
			 T50 = FNMS(KP382683432, T4Z, KP923879532 * T4Y);
			 T53 = FMA(KP923879532, T51, KP382683432 * T52);
			 T54 = T50 - T53;
			 T7y = T50 + T53;
			 T5x = T5d + T5e;
			 T5y = T5g + T5h;
			 T5z = FNMS(KP195090322, T5y, KP980785280 * T5x);
			 T5D = FMA(KP195090322, T5x, KP980785280 * T5y);
		    }
		    {
			 E T58, T5b, T5q, T5r;
			 T58 = T56 - T57;
			 T5b = T59 - T5a;
			 T5c = FMA(KP555570233, T58, KP831469612 * T5b);
			 T5m = FNMS(KP831469612, T58, KP555570233 * T5b);
			 T5q = FMA(KP382683432, T4Y, KP923879532 * T4Z);
			 T5r = FNMS(KP382683432, T51, KP923879532 * T52);
			 T5s = T5q + T5r;
			 T7I = T5r - T5q;
		    }
		    {
			 E T5u, T5v, T5f, T5i;
			 T5u = T56 + T57;
			 T5v = T59 + T5a;
			 T5w = FMA(KP980785280, T5u, KP195090322 * T5v);
			 T5C = FNMS(KP195090322, T5u, KP980785280 * T5v);
			 T5f = T5d - T5e;
			 T5i = T5g - T5h;
			 T5j = FNMS(KP831469612, T5i, KP555570233 * T5f);
			 T5n = FMA(KP831469612, T5f, KP555570233 * T5i);
		    }
		    {
			 E T55, T5k, T7H, T7K;
			 T55 = T4X + T54;
			 T5k = T5c + T5j;
			 Rm[WS(rs, 10)] = T55 - T5k;
			 Rp[WS(rs, 5)] = T55 + T5k;
			 T7H = T5m + T5n;
			 T7K = T7I + T7J;
			 Im[WS(rs, 10)] = T7H - T7K;
			 Ip[WS(rs, 5)] = T7H + T7K;
		    }
		    {
			 E T5l, T5o, T7L, T7M;
			 T5l = T4X - T54;
			 T5o = T5m - T5n;
			 Rm[WS(rs, 2)] = T5l - T5o;
			 Rp[WS(rs, 13)] = T5l + T5o;
			 T7L = T5j - T5c;
			 T7M = T7J - T7I;
			 Im[WS(rs, 2)] = T7L - T7M;
			 Ip[WS(rs, 13)] = T7L + T7M;
		    }
		    {
			 E T5t, T5A, T7x, T7E;
			 T5t = T5p + T5s;
			 T5A = T5w + T5z;
			 Rm[WS(rs, 14)] = T5t - T5A;
			 Rp[WS(rs, 1)] = T5t + T5A;
			 T7x = T5C + T5D;
			 T7E = T7y + T7D;
			 Im[WS(rs, 14)] = T7x - T7E;
			 Ip[WS(rs, 1)] = T7x + T7E;
		    }
		    {
			 E T5B, T5E, T7F, T7G;
			 T5B = T5p - T5s;
			 T5E = T5C - T5D;
			 Rm[WS(rs, 6)] = T5B - T5E;
			 Rp[WS(rs, 9)] = T5B + T5E;
			 T7F = T5z - T5w;
			 T7G = T7D - T7y;
			 Im[WS(rs, 6)] = T7F - T7G;
			 Ip[WS(rs, 9)] = T7F + T7G;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cf_32", twinstr, &GENUS, {340, 114, 94, 0} };

void X(codelet_hc2cf_32) (planner *p) {
     X(khc2c_register) (p, hc2cf_32, &desc, HC2C_VIA_RDFT);
}
#endif
