/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 3 "../rcfile_y.y"

/*
 * rcfile_y.y -- Run control file parser for fetchmail
 *
 * For license terms, see the file COPYING in this directory.
 */

#include "config.h"
#include "fetchmail.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "i18n.h"
#include "rcfile_l.h"
  
/* parser reads these */
char *rcfile;			/* path name of rc file */
struct query cmd_opts;		/* where to put command-line info */

/* parser sets these */
struct query *querylist;	/* head of server list (globally visible) */

static struct query current;	/* current server record */
static int prc_errflag;
static struct hostdata *leadentry;
static flag trailer;

static void record_current(void);
static void user_reset(void);
static void reset_server(const char *name, int skip);

/* these should be of size PATH_MAX */
char currentwd[1024] = "", rcfiledir[1024] = "";

/* lexer interface */
extern int prc_lineno;
void yyerror (const char *s)
/* report a syntax or out-of-memory error */
{
    report_at_line(stderr, 0, rcfile, prc_lineno, GT_("%s at %s"), s, 
		   (yytext && yytext[0]) ? yytext : GT_("end of input"));
    prc_errflag++;
}


#line 124 "rcfile_y.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_RCFILE_Y_H_INCLUDED
# define YY_YY_RCFILE_Y_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    DEFAULTS = 258,                /* DEFAULTS  */
    POLL = 259,                    /* POLL  */
    SKIP = 260,                    /* SKIP  */
    VIA = 261,                     /* VIA  */
    AKA = 262,                     /* AKA  */
    LOCALDOMAINS = 263,            /* LOCALDOMAINS  */
    PROTOCOL = 264,                /* PROTOCOL  */
    AUTHENTICATE = 265,            /* AUTHENTICATE  */
    TIMEOUT = 266,                 /* TIMEOUT  */
    IDLETIMEOUT = 267,             /* IDLETIMEOUT  */
    KPOP = 268,                    /* KPOP  */
    SDPS = 269,                    /* SDPS  */
    ENVELOPE = 270,                /* ENVELOPE  */
    QVIRTUAL = 271,                /* QVIRTUAL  */
    USERNAME = 272,                /* USERNAME  */
    PASSWORD = 273,                /* PASSWORD  */
    FOLDER = 274,                  /* FOLDER  */
    SMTPHOST = 275,                /* SMTPHOST  */
    FETCHDOMAINS = 276,            /* FETCHDOMAINS  */
    MDA = 277,                     /* MDA  */
    BSMTP = 278,                   /* BSMTP  */
    LMTP = 279,                    /* LMTP  */
    SMTPADDRESS = 280,             /* SMTPADDRESS  */
    SMTPNAME = 281,                /* SMTPNAME  */
    SPAMRESPONSE = 282,            /* SPAMRESPONSE  */
    PRECONNECT = 283,              /* PRECONNECT  */
    POSTCONNECT = 284,             /* POSTCONNECT  */
    LIMIT = 285,                   /* LIMIT  */
    WARNINGS = 286,                /* WARNINGS  */
    INTERFACE = 287,               /* INTERFACE  */
    MONITOR = 288,                 /* MONITOR  */
    PLUGIN = 289,                  /* PLUGIN  */
    PLUGOUT = 290,                 /* PLUGOUT  */
    IS = 291,                      /* IS  */
    HERE = 292,                    /* HERE  */
    THERE = 293,                   /* THERE  */
    TO = 294,                      /* TO  */
    MAP = 295,                     /* MAP  */
    BATCHLIMIT = 296,              /* BATCHLIMIT  */
    FETCHLIMIT = 297,              /* FETCHLIMIT  */
    FETCHSIZELIMIT = 298,          /* FETCHSIZELIMIT  */
    FASTUIDL = 299,                /* FASTUIDL  */
    EXPUNGE = 300,                 /* EXPUNGE  */
    PROPERTIES = 301,              /* PROPERTIES  */
    SET = 302,                     /* SET  */
    LOGFILE = 303,                 /* LOGFILE  */
    DAEMON = 304,                  /* DAEMON  */
    SYSLOG = 305,                  /* SYSLOG  */
    IDFILE = 306,                  /* IDFILE  */
    PIDFILE = 307,                 /* PIDFILE  */
    INVISIBLE = 308,               /* INVISIBLE  */
    POSTMASTER = 309,              /* POSTMASTER  */
    BOUNCEMAIL = 310,              /* BOUNCEMAIL  */
    SPAMBOUNCE = 311,              /* SPAMBOUNCE  */
    SOFTBOUNCE = 312,              /* SOFTBOUNCE  */
    SHOWDOTS = 313,                /* SHOWDOTS  */
    BADHEADER = 314,               /* BADHEADER  */
    ACCEPT = 315,                  /* ACCEPT  */
    REJECT_ = 316,                 /* REJECT_  */
    PROTO = 317,                   /* PROTO  */
    AUTHTYPE = 318,                /* AUTHTYPE  */
    STRING = 319,                  /* STRING  */
    NUMBER = 320,                  /* NUMBER  */
    NO = 321,                      /* NO  */
    KEEP = 322,                    /* KEEP  */
    MOVETO = 323,                  /* MOVETO  */
    FLUSH = 324,                   /* FLUSH  */
    LIMITFLUSH = 325,              /* LIMITFLUSH  */
    FETCHALL = 326,                /* FETCHALL  */
    REWRITE = 327,                 /* REWRITE  */
    FORCECR = 328,                 /* FORCECR  */
    STRIPCR = 329,                 /* STRIPCR  */
    PASS8BITS = 330,               /* PASS8BITS  */
    DROPSTATUS = 331,              /* DROPSTATUS  */
    DROPDELIVERED = 332,           /* DROPDELIVERED  */
    FORCEIDLE = 333,               /* FORCEIDLE  */
    DNS = 334,                     /* DNS  */
    SERVICE = 335,                 /* SERVICE  */
    PORT = 336,                    /* PORT  */
    UIDL = 337,                    /* UIDL  */
    INTERVAL = 338,                /* INTERVAL  */
    MIMEDECODE = 339,              /* MIMEDECODE  */
    IDLE = 340,                    /* IDLE  */
    CHECKALIAS = 341,              /* CHECKALIAS  */
    SSL = 342,                     /* SSL  */
    SSLKEY = 343,                  /* SSLKEY  */
    SSLCERT = 344,                 /* SSLCERT  */
    SSLPROTO = 345,                /* SSLPROTO  */
    SSLCERTCK = 346,               /* SSLCERTCK  */
    SSLCERTFILE = 347,             /* SSLCERTFILE  */
    SSLCERTPATH = 348,             /* SSLCERTPATH  */
    SSLCOMMONNAME = 349,           /* SSLCOMMONNAME  */
    SSLFINGERPRINT = 350,          /* SSLFINGERPRINT  */
    PRINCIPAL = 351,               /* PRINCIPAL  */
    ESMTPNAME = 352,               /* ESMTPNAME  */
    ESMTPPASSWORD = 353,           /* ESMTPPASSWORD  */
    TRACEPOLLS = 354               /* TRACEPOLLS  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define DEFAULTS 258
#define POLL 259
#define SKIP 260
#define VIA 261
#define AKA 262
#define LOCALDOMAINS 263
#define PROTOCOL 264
#define AUTHENTICATE 265
#define TIMEOUT 266
#define IDLETIMEOUT 267
#define KPOP 268
#define SDPS 269
#define ENVELOPE 270
#define QVIRTUAL 271
#define USERNAME 272
#define PASSWORD 273
#define FOLDER 274
#define SMTPHOST 275
#define FETCHDOMAINS 276
#define MDA 277
#define BSMTP 278
#define LMTP 279
#define SMTPADDRESS 280
#define SMTPNAME 281
#define SPAMRESPONSE 282
#define PRECONNECT 283
#define POSTCONNECT 284
#define LIMIT 285
#define WARNINGS 286
#define INTERFACE 287
#define MONITOR 288
#define PLUGIN 289
#define PLUGOUT 290
#define IS 291
#define HERE 292
#define THERE 293
#define TO 294
#define MAP 295
#define BATCHLIMIT 296
#define FETCHLIMIT 297
#define FETCHSIZELIMIT 298
#define FASTUIDL 299
#define EXPUNGE 300
#define PROPERTIES 301
#define SET 302
#define LOGFILE 303
#define DAEMON 304
#define SYSLOG 305
#define IDFILE 306
#define PIDFILE 307
#define INVISIBLE 308
#define POSTMASTER 309
#define BOUNCEMAIL 310
#define SPAMBOUNCE 311
#define SOFTBOUNCE 312
#define SHOWDOTS 313
#define BADHEADER 314
#define ACCEPT 315
#define REJECT_ 316
#define PROTO 317
#define AUTHTYPE 318
#define STRING 319
#define NUMBER 320
#define NO 321
#define KEEP 322
#define MOVETO 323
#define FLUSH 324
#define LIMITFLUSH 325
#define FETCHALL 326
#define REWRITE 327
#define FORCECR 328
#define STRIPCR 329
#define PASS8BITS 330
#define DROPSTATUS 331
#define DROPDELIVERED 332
#define FORCEIDLE 333
#define DNS 334
#define SERVICE 335
#define PORT 336
#define UIDL 337
#define INTERVAL 338
#define MIMEDECODE 339
#define IDLE 340
#define CHECKALIAS 341
#define SSL 342
#define SSLKEY 343
#define SSLCERT 344
#define SSLPROTO 345
#define SSLCERTCK 346
#define SSLCERTFILE 347
#define SSLCERTPATH 348
#define SSLCOMMONNAME 349
#define SSLFINGERPRINT 350
#define PRINCIPAL 351
#define ESMTPNAME 352
#define ESMTPPASSWORD 353
#define TRACEPOLLS 354

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 56 "../rcfile_y.y"

  int proto;
  int number;
  char *sval;

#line 381 "rcfile_y.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;


int yyparse (void);


#endif /* !YY_YY_RCFILE_Y_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_DEFAULTS = 3,                   /* DEFAULTS  */
  YYSYMBOL_POLL = 4,                       /* POLL  */
  YYSYMBOL_SKIP = 5,                       /* SKIP  */
  YYSYMBOL_VIA = 6,                        /* VIA  */
  YYSYMBOL_AKA = 7,                        /* AKA  */
  YYSYMBOL_LOCALDOMAINS = 8,               /* LOCALDOMAINS  */
  YYSYMBOL_PROTOCOL = 9,                   /* PROTOCOL  */
  YYSYMBOL_AUTHENTICATE = 10,              /* AUTHENTICATE  */
  YYSYMBOL_TIMEOUT = 11,                   /* TIMEOUT  */
  YYSYMBOL_IDLETIMEOUT = 12,               /* IDLETIMEOUT  */
  YYSYMBOL_KPOP = 13,                      /* KPOP  */
  YYSYMBOL_SDPS = 14,                      /* SDPS  */
  YYSYMBOL_ENVELOPE = 15,                  /* ENVELOPE  */
  YYSYMBOL_QVIRTUAL = 16,                  /* QVIRTUAL  */
  YYSYMBOL_USERNAME = 17,                  /* USERNAME  */
  YYSYMBOL_PASSWORD = 18,                  /* PASSWORD  */
  YYSYMBOL_FOLDER = 19,                    /* FOLDER  */
  YYSYMBOL_SMTPHOST = 20,                  /* SMTPHOST  */
  YYSYMBOL_FETCHDOMAINS = 21,              /* FETCHDOMAINS  */
  YYSYMBOL_MDA = 22,                       /* MDA  */
  YYSYMBOL_BSMTP = 23,                     /* BSMTP  */
  YYSYMBOL_LMTP = 24,                      /* LMTP  */
  YYSYMBOL_SMTPADDRESS = 25,               /* SMTPADDRESS  */
  YYSYMBOL_SMTPNAME = 26,                  /* SMTPNAME  */
  YYSYMBOL_SPAMRESPONSE = 27,              /* SPAMRESPONSE  */
  YYSYMBOL_PRECONNECT = 28,                /* PRECONNECT  */
  YYSYMBOL_POSTCONNECT = 29,               /* POSTCONNECT  */
  YYSYMBOL_LIMIT = 30,                     /* LIMIT  */
  YYSYMBOL_WARNINGS = 31,                  /* WARNINGS  */
  YYSYMBOL_INTERFACE = 32,                 /* INTERFACE  */
  YYSYMBOL_MONITOR = 33,                   /* MONITOR  */
  YYSYMBOL_PLUGIN = 34,                    /* PLUGIN  */
  YYSYMBOL_PLUGOUT = 35,                   /* PLUGOUT  */
  YYSYMBOL_IS = 36,                        /* IS  */
  YYSYMBOL_HERE = 37,                      /* HERE  */
  YYSYMBOL_THERE = 38,                     /* THERE  */
  YYSYMBOL_TO = 39,                        /* TO  */
  YYSYMBOL_MAP = 40,                       /* MAP  */
  YYSYMBOL_BATCHLIMIT = 41,                /* BATCHLIMIT  */
  YYSYMBOL_FETCHLIMIT = 42,                /* FETCHLIMIT  */
  YYSYMBOL_FETCHSIZELIMIT = 43,            /* FETCHSIZELIMIT  */
  YYSYMBOL_FASTUIDL = 44,                  /* FASTUIDL  */
  YYSYMBOL_EXPUNGE = 45,                   /* EXPUNGE  */
  YYSYMBOL_PROPERTIES = 46,                /* PROPERTIES  */
  YYSYMBOL_SET = 47,                       /* SET  */
  YYSYMBOL_LOGFILE = 48,                   /* LOGFILE  */
  YYSYMBOL_DAEMON = 49,                    /* DAEMON  */
  YYSYMBOL_SYSLOG = 50,                    /* SYSLOG  */
  YYSYMBOL_IDFILE = 51,                    /* IDFILE  */
  YYSYMBOL_PIDFILE = 52,                   /* PIDFILE  */
  YYSYMBOL_INVISIBLE = 53,                 /* INVISIBLE  */
  YYSYMBOL_POSTMASTER = 54,                /* POSTMASTER  */
  YYSYMBOL_BOUNCEMAIL = 55,                /* BOUNCEMAIL  */
  YYSYMBOL_SPAMBOUNCE = 56,                /* SPAMBOUNCE  */
  YYSYMBOL_SOFTBOUNCE = 57,                /* SOFTBOUNCE  */
  YYSYMBOL_SHOWDOTS = 58,                  /* SHOWDOTS  */
  YYSYMBOL_BADHEADER = 59,                 /* BADHEADER  */
  YYSYMBOL_ACCEPT = 60,                    /* ACCEPT  */
  YYSYMBOL_REJECT_ = 61,                   /* REJECT_  */
  YYSYMBOL_PROTO = 62,                     /* PROTO  */
  YYSYMBOL_AUTHTYPE = 63,                  /* AUTHTYPE  */
  YYSYMBOL_STRING = 64,                    /* STRING  */
  YYSYMBOL_NUMBER = 65,                    /* NUMBER  */
  YYSYMBOL_NO = 66,                        /* NO  */
  YYSYMBOL_KEEP = 67,                      /* KEEP  */
  YYSYMBOL_MOVETO = 68,                    /* MOVETO  */
  YYSYMBOL_FLUSH = 69,                     /* FLUSH  */
  YYSYMBOL_LIMITFLUSH = 70,                /* LIMITFLUSH  */
  YYSYMBOL_FETCHALL = 71,                  /* FETCHALL  */
  YYSYMBOL_REWRITE = 72,                   /* REWRITE  */
  YYSYMBOL_FORCECR = 73,                   /* FORCECR  */
  YYSYMBOL_STRIPCR = 74,                   /* STRIPCR  */
  YYSYMBOL_PASS8BITS = 75,                 /* PASS8BITS  */
  YYSYMBOL_DROPSTATUS = 76,                /* DROPSTATUS  */
  YYSYMBOL_DROPDELIVERED = 77,             /* DROPDELIVERED  */
  YYSYMBOL_FORCEIDLE = 78,                 /* FORCEIDLE  */
  YYSYMBOL_DNS = 79,                       /* DNS  */
  YYSYMBOL_SERVICE = 80,                   /* SERVICE  */
  YYSYMBOL_PORT = 81,                      /* PORT  */
  YYSYMBOL_UIDL = 82,                      /* UIDL  */
  YYSYMBOL_INTERVAL = 83,                  /* INTERVAL  */
  YYSYMBOL_MIMEDECODE = 84,                /* MIMEDECODE  */
  YYSYMBOL_IDLE = 85,                      /* IDLE  */
  YYSYMBOL_CHECKALIAS = 86,                /* CHECKALIAS  */
  YYSYMBOL_SSL = 87,                       /* SSL  */
  YYSYMBOL_SSLKEY = 88,                    /* SSLKEY  */
  YYSYMBOL_SSLCERT = 89,                   /* SSLCERT  */
  YYSYMBOL_SSLPROTO = 90,                  /* SSLPROTO  */
  YYSYMBOL_SSLCERTCK = 91,                 /* SSLCERTCK  */
  YYSYMBOL_SSLCERTFILE = 92,               /* SSLCERTFILE  */
  YYSYMBOL_SSLCERTPATH = 93,               /* SSLCERTPATH  */
  YYSYMBOL_SSLCOMMONNAME = 94,             /* SSLCOMMONNAME  */
  YYSYMBOL_SSLFINGERPRINT = 95,            /* SSLFINGERPRINT  */
  YYSYMBOL_PRINCIPAL = 96,                 /* PRINCIPAL  */
  YYSYMBOL_ESMTPNAME = 97,                 /* ESMTPNAME  */
  YYSYMBOL_ESMTPPASSWORD = 98,             /* ESMTPPASSWORD  */
  YYSYMBOL_TRACEPOLLS = 99,                /* TRACEPOLLS  */
  YYSYMBOL_YYACCEPT = 100,                 /* $accept  */
  YYSYMBOL_statement_list = 101,           /* statement_list  */
  YYSYMBOL_optmap = 102,                   /* optmap  */
  YYSYMBOL_statement = 103,                /* statement  */
  YYSYMBOL_define_server = 104,            /* define_server  */
  YYSYMBOL_serverspecs = 105,              /* serverspecs  */
  YYSYMBOL_alias_list = 106,               /* alias_list  */
  YYSYMBOL_domain_list = 107,              /* domain_list  */
  YYSYMBOL_serv_option = 108,              /* serv_option  */
  YYSYMBOL_userspecs = 109,                /* userspecs  */
  YYSYMBOL_explicits = 110,                /* explicits  */
  YYSYMBOL_explicitdef = 111,              /* explicitdef  */
  YYSYMBOL_userdef = 112,                  /* userdef  */
  YYSYMBOL_user0opts = 113,                /* user0opts  */
  YYSYMBOL_user1opts = 114,                /* user1opts  */
  YYSYMBOL_mapping_list = 115,             /* mapping_list  */
  YYSYMBOL_mapping = 116,                  /* mapping  */
  YYSYMBOL_folder_list = 117,              /* folder_list  */
  YYSYMBOL_smtp_list = 118,                /* smtp_list  */
  YYSYMBOL_fetch_list = 119,               /* fetch_list  */
  YYSYMBOL_num_list = 120,                 /* num_list  */
  YYSYMBOL_user_option = 121               /* user_option  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
# define YYCOPY_NEEDED 1
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   345

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  100
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  22
/* YYNRULES -- Number of rules.  */
#define YYNRULES  157
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  230

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   354


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,    97,    97,    98,    99,   102,   102,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   130,   131,   134,   138,   139,
     140,   143,   144,   147,   148,   151,   152,   155,   156,   157,
     158,   159,   170,   171,   172,   173,   181,   182,   183,   184,
     185,   188,   194,   200,   202,   204,   206,   208,   213,   219,
     220,   228,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   247,   248,   251,   252,   255,   258,   259,   260,   263,
     264,   267,   268,   271,   272,   275,   281,   284,   285,   288,
     289,   292,   293,   296,   302,   310,   311,   312,   313,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   344,   351,   352,   353,
     354,   355,   356,   357,   358,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   374,   375,
     377,   378,   379,   380,   381,   382,   383,   385
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  static const char *const yy_sname[] =
  {
  "end of file", "error", "invalid token", "DEFAULTS", "POLL", "SKIP",
  "VIA", "AKA", "LOCALDOMAINS", "PROTOCOL", "AUTHENTICATE", "TIMEOUT",
  "IDLETIMEOUT", "KPOP", "SDPS", "ENVELOPE", "QVIRTUAL", "USERNAME",
  "PASSWORD", "FOLDER", "SMTPHOST", "FETCHDOMAINS", "MDA", "BSMTP", "LMTP",
  "SMTPADDRESS", "SMTPNAME", "SPAMRESPONSE", "PRECONNECT", "POSTCONNECT",
  "LIMIT", "WARNINGS", "INTERFACE", "MONITOR", "PLUGIN", "PLUGOUT", "IS",
  "HERE", "THERE", "TO", "MAP", "BATCHLIMIT", "FETCHLIMIT",
  "FETCHSIZELIMIT", "FASTUIDL", "EXPUNGE", "PROPERTIES", "SET", "LOGFILE",
  "DAEMON", "SYSLOG", "IDFILE", "PIDFILE", "INVISIBLE", "POSTMASTER",
  "BOUNCEMAIL", "SPAMBOUNCE", "SOFTBOUNCE", "SHOWDOTS", "BADHEADER",
  "ACCEPT", "REJECT_", "PROTO", "AUTHTYPE", "STRING", "NUMBER", "NO",
  "KEEP", "MOVETO", "FLUSH", "LIMITFLUSH", "FETCHALL", "REWRITE",
  "FORCECR", "STRIPCR", "PASS8BITS", "DROPSTATUS", "DROPDELIVERED",
  "FORCEIDLE", "DNS", "SERVICE", "PORT", "UIDL", "INTERVAL", "MIMEDECODE",
  "IDLE", "CHECKALIAS", "SSL", "SSLKEY", "SSLCERT", "SSLPROTO",
  "SSLCERTCK", "SSLCERTFILE", "SSLCERTPATH", "SSLCOMMONNAME",
  "SSLFINGERPRINT", "PRINCIPAL", "ESMTPNAME", "ESMTPPASSWORD",
  "TRACEPOLLS", "$accept", "statement_list", "optmap", "statement",
  "define_server", "serverspecs", "alias_list", "domain_list",
  "serv_option", "userspecs", "explicits", "explicitdef", "userdef",
  "user0opts", "user1opts", "mapping_list", "mapping", "folder_list",
  "smtp_list", "fetch_list", "num_list", "user_option", YY_NULLPTR
  };
  return yy_sname[yysymbol];
}
#endif

#define YYPACT_NINF (-116)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-86)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     109,  -116,   116,  -116,  -116,   -55,   -22,   279,  -116,  -116,
    -116,  -116,     8,     8,     8,  -116,     8,     8,  -116,     8,
    -116,  -116,  -116,  -116,    85,    -5,  -116,   -13,    -7,    -6,
      54,    58,    63,  -116,  -116,  -116,  -116,  -116,  -116,    83,
      84,    87,    33,    70,    88,    89,    40,    95,    96,    97,
      98,   100,   101,   102,   103,  -116,   104,   105,    90,   111,
     112,   113,   114,   117,   118,   119,   120,   121,   122,   115,
     127,   139,   140,   142,   148,    69,   124,  -116,   149,  -116,
    -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,
      72,   151,  -116,   152,  -116,  -116,  -116,  -116,   150,   154,
     155,  -116,   156,   157,   158,   174,   175,   176,   177,  -116,
    -116,    91,   132,  -116,  -116,   206,  -116,  -116,  -116,  -116,
    -116,  -116,  -116,  -116,  -116,   179,  -116,   180,  -116,  -116,
    -116,  -116,  -116,  -116,  -116,   182,  -116,    94,   -29,  -116,
    -116,  -116,   189,  -116,   190,  -116,   191,  -116,  -116,  -116,
    -116,  -116,   192,  -116,  -116,  -116,  -116,  -116,  -116,  -116,
    -116,     5,    -4,   216,    80,  -116,  -116,  -116,  -116,  -116,
    -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,
    -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,
    -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,
    -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,    29,  -116,
    -116,   206,   235,  -116,  -116,  -116,  -116,  -116,   194,  -116,
    -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116,  -116
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,     4,     0,     1,    30,     0,     0,     0,     3,    31,
      28,    29,     6,     6,     6,    19,     6,     6,    21,     6,
      12,    14,    16,    23,     0,    25,     5,     0,     0,     0,
       0,     0,     0,    20,    22,    13,    15,    17,    24,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   109,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   112,     0,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   125,    64,
       0,     0,    46,     0,   123,   124,    48,   126,     0,     0,
       0,   130,     0,     0,     0,     0,     0,     0,     0,    67,
      32,    26,    72,    73,    79,    71,    81,    18,     7,    10,
       8,     9,    11,    38,    33,    37,    35,    39,    41,    45,
      40,    54,    55,    56,    58,     0,    59,    76,     0,    83,
     100,    87,   101,    89,   102,    91,   103,   107,   108,   104,
     105,    93,   106,   110,   111,   150,   151,    60,    61,    62,
      63,    85,    98,    85,    96,   155,   152,   153,   154,   156,
     157,    69,    70,    66,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   147,    65,    47,   145,   146,    49,
     148,   149,    68,   113,    50,    51,    52,    53,   127,   128,
     129,   131,   132,   133,   134,    42,    43,    44,     0,    27,
      74,    75,     0,    82,    34,    36,    57,    78,     0,    77,
      84,    88,    90,    92,    94,    99,    97,    95,    80,    86
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -116,  -116,    36,  -116,  -116,  -116,  -116,  -116,    41,  -116,
    -116,   147,  -116,  -116,  -116,    78,  -106,  -116,  -116,  -116,
    -116,  -115
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     2,    27,     8,     9,    25,   125,   127,   110,   111,
     112,   113,   114,   211,   115,   138,   139,   142,   144,   146,
     152,   116
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     213,    39,    40,    41,    42,    43,    44,    45,   219,    10,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,   220,   226,    68,   163,    69,    70,    71,    72,
      73,    74,    11,   225,   173,   218,   128,   129,    26,    28,
      29,   117,    30,    31,    75,    32,   220,   118,   220,   119,
     163,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   130,   228,    39,    40,    41,
      42,    43,    44,    45,   134,   135,    46,    47,   185,    -2,
       1,   186,    -2,    -2,    -2,   189,     3,   227,   120,     4,
       5,     6,   121,    63,    64,    65,    66,   122,   192,   171,
     172,   -85,   217,   131,   218,    33,   194,   195,    34,   173,
      35,    36,    37,    38,   163,   162,   164,   123,   124,    48,
      75,   126,   209,   132,   133,   151,    -2,   208,   -85,   136,
     137,   140,   141,     7,   143,   145,   147,   148,   149,   150,
      89,    90,    91,    92,    93,   153,   154,    96,   155,   156,
     165,   157,   158,   159,   160,   161,   163,   106,   107,   108,
     109,   174,   166,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   167,   168,   186,   169,   187,   188,
     189,   190,   170,   193,   198,   191,   196,   197,   199,   200,
     201,   202,   203,   192,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,   204,   205,
     206,   207,    67,   214,   215,    68,   216,    69,    70,    71,
      72,    73,    74,   221,   222,   223,   218,   224,   229,   210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   212,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,     0,     0,     0,     0,     0,
      94,    95,     0,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,     0,     0,     0,     0,     0,   187,
     188,     0,   190,     0,     0,    12,   191,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,     0,     0,
       0,     0,     0,     0,     0,    24
};

static const yytype_int16 yycheck[] =
{
     115,     6,     7,     8,     9,    10,    11,    12,    37,    64,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,   138,    37,    39,    64,    41,    42,    43,    44,
      45,    46,    64,    38,    15,    40,    13,    14,    40,    13,
      14,    64,    16,    17,    59,    19,   162,    64,   164,    65,
      64,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,    62,   211,     6,     7,     8,
       9,    10,    11,    12,    64,    65,    15,    16,    79,     0,
       1,    82,     3,     4,     5,    86,     0,    37,    64,     3,
       4,     5,    64,    32,    33,    34,    35,    64,    99,    60,
      61,    37,    38,    63,    40,    50,    64,    65,    53,    15,
      55,    56,    57,    58,    64,    67,    68,    64,    64,    17,
      59,    64,   111,    65,    65,    65,    47,    66,    64,    64,
      64,    64,    64,    47,    64,    64,    64,    64,    64,    64,
      79,    80,    81,    82,    83,    64,    64,    86,    65,    65,
      65,    64,    64,    64,    64,    64,    64,    96,    97,    98,
      99,    67,    65,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    65,    65,    82,    65,    84,    85,
      86,    87,    64,    64,    64,    91,    65,    65,    64,    64,
      64,    64,    64,    99,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    64,    64,
      64,    64,    36,    64,    64,    39,    64,    41,    42,    43,
      44,    45,    46,    64,    64,    64,    40,    65,    64,   112,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    -1,    -1,    -1,
      84,    85,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    -1,    -1,    -1,    -1,    -1,    84,
      85,    -1,    87,    -1,    -1,    46,    91,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     1,   101,     0,     3,     4,     5,    47,   103,   104,
      64,    64,    46,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    66,   105,    40,   102,   102,   102,
     102,   102,   102,    50,    53,    55,    56,    57,    58,     6,
       7,     8,     9,    10,    11,    12,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    39,    41,
      42,    43,    44,    45,    46,    59,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     108,   109,   110,   111,   112,   114,   121,    64,    64,    65,
      64,    64,    64,    64,    64,   106,    64,   107,    13,    14,
      62,    63,    65,    65,    64,    65,    64,    64,   115,   116,
      64,    64,   117,    64,   118,    64,   119,    64,    64,    64,
      64,    65,   120,    64,    64,    65,    65,    64,    64,    64,
      64,    64,   115,    64,   115,    65,    65,    65,    65,    65,
      64,    60,    61,    15,    67,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    82,    84,    85,    86,
      87,    91,    99,    64,    64,    65,    65,    65,    64,    64,
      64,    64,    64,    64,    64,    64,    64,    64,    66,   108,
     111,   113,    66,   121,    64,    64,    64,    38,    40,    37,
     116,    64,    64,    64,    65,    38,    37,    37,   121,    64
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,   100,   101,   101,   101,   102,   102,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   103,   104,   104,
     104,   105,   105,   106,   106,   107,   107,   108,   108,   108,
     108,   108,   108,   108,   108,   108,   108,   108,   108,   108,
     108,   108,   108,   108,   108,   108,   108,   108,   108,   108,
     108,   108,   108,   108,   108,   108,   108,   108,   108,   108,
     108,   109,   109,   110,   110,   111,   112,   112,   112,   113,
     113,   114,   114,   115,   115,   116,   116,   117,   117,   118,
     118,   119,   119,   120,   120,   121,   121,   121,   121,   121,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     121,   121,   121,   121,   121,   121,   121,   121
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     4,     4,     4,
       4,     4,     2,     3,     2,     3,     2,     3,     4,     2,
       3,     2,     3,     2,     3,     2,     3,     4,     2,     2,
       1,     0,     2,     1,     2,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     3,     2,     2,
       2,     2,     2,     2,     1,     2,     2,     1,     2,     2,
       2,     1,     1,     1,     2,     2,     2,     3,     3,     0,
       2,     1,     2,     1,     2,     1,     3,     1,     2,     1,
       2,     1,     2,     1,     2,     3,     2,     3,     2,     3,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     1,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       1,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        YY_LAC_DISCARD ("YYBACKUP");                              \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_DEFAULTS: /* DEFAULTS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1275 "rcfile_y.c"
        break;

    case YYSYMBOL_POLL: /* POLL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1281 "rcfile_y.c"
        break;

    case YYSYMBOL_SKIP: /* SKIP  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1287 "rcfile_y.c"
        break;

    case YYSYMBOL_VIA: /* VIA  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1293 "rcfile_y.c"
        break;

    case YYSYMBOL_AKA: /* AKA  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1299 "rcfile_y.c"
        break;

    case YYSYMBOL_LOCALDOMAINS: /* LOCALDOMAINS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1305 "rcfile_y.c"
        break;

    case YYSYMBOL_PROTOCOL: /* PROTOCOL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1311 "rcfile_y.c"
        break;

    case YYSYMBOL_AUTHENTICATE: /* AUTHENTICATE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1317 "rcfile_y.c"
        break;

    case YYSYMBOL_TIMEOUT: /* TIMEOUT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1323 "rcfile_y.c"
        break;

    case YYSYMBOL_IDLETIMEOUT: /* IDLETIMEOUT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1329 "rcfile_y.c"
        break;

    case YYSYMBOL_KPOP: /* KPOP  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1335 "rcfile_y.c"
        break;

    case YYSYMBOL_SDPS: /* SDPS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1341 "rcfile_y.c"
        break;

    case YYSYMBOL_ENVELOPE: /* ENVELOPE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1347 "rcfile_y.c"
        break;

    case YYSYMBOL_QVIRTUAL: /* QVIRTUAL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1353 "rcfile_y.c"
        break;

    case YYSYMBOL_USERNAME: /* USERNAME  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1359 "rcfile_y.c"
        break;

    case YYSYMBOL_PASSWORD: /* PASSWORD  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1365 "rcfile_y.c"
        break;

    case YYSYMBOL_FOLDER: /* FOLDER  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1371 "rcfile_y.c"
        break;

    case YYSYMBOL_SMTPHOST: /* SMTPHOST  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1377 "rcfile_y.c"
        break;

    case YYSYMBOL_FETCHDOMAINS: /* FETCHDOMAINS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1383 "rcfile_y.c"
        break;

    case YYSYMBOL_MDA: /* MDA  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1389 "rcfile_y.c"
        break;

    case YYSYMBOL_BSMTP: /* BSMTP  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1395 "rcfile_y.c"
        break;

    case YYSYMBOL_LMTP: /* LMTP  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1401 "rcfile_y.c"
        break;

    case YYSYMBOL_SMTPADDRESS: /* SMTPADDRESS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1407 "rcfile_y.c"
        break;

    case YYSYMBOL_SMTPNAME: /* SMTPNAME  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1413 "rcfile_y.c"
        break;

    case YYSYMBOL_SPAMRESPONSE: /* SPAMRESPONSE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1419 "rcfile_y.c"
        break;

    case YYSYMBOL_PRECONNECT: /* PRECONNECT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1425 "rcfile_y.c"
        break;

    case YYSYMBOL_POSTCONNECT: /* POSTCONNECT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1431 "rcfile_y.c"
        break;

    case YYSYMBOL_LIMIT: /* LIMIT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1437 "rcfile_y.c"
        break;

    case YYSYMBOL_WARNINGS: /* WARNINGS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1443 "rcfile_y.c"
        break;

    case YYSYMBOL_INTERFACE: /* INTERFACE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1449 "rcfile_y.c"
        break;

    case YYSYMBOL_MONITOR: /* MONITOR  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1455 "rcfile_y.c"
        break;

    case YYSYMBOL_PLUGIN: /* PLUGIN  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1461 "rcfile_y.c"
        break;

    case YYSYMBOL_PLUGOUT: /* PLUGOUT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1467 "rcfile_y.c"
        break;

    case YYSYMBOL_IS: /* IS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1473 "rcfile_y.c"
        break;

    case YYSYMBOL_HERE: /* HERE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1479 "rcfile_y.c"
        break;

    case YYSYMBOL_THERE: /* THERE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1485 "rcfile_y.c"
        break;

    case YYSYMBOL_TO: /* TO  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1491 "rcfile_y.c"
        break;

    case YYSYMBOL_MAP: /* MAP  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1497 "rcfile_y.c"
        break;

    case YYSYMBOL_BATCHLIMIT: /* BATCHLIMIT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1503 "rcfile_y.c"
        break;

    case YYSYMBOL_FETCHLIMIT: /* FETCHLIMIT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1509 "rcfile_y.c"
        break;

    case YYSYMBOL_FETCHSIZELIMIT: /* FETCHSIZELIMIT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1515 "rcfile_y.c"
        break;

    case YYSYMBOL_FASTUIDL: /* FASTUIDL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1521 "rcfile_y.c"
        break;

    case YYSYMBOL_EXPUNGE: /* EXPUNGE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1527 "rcfile_y.c"
        break;

    case YYSYMBOL_PROPERTIES: /* PROPERTIES  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1533 "rcfile_y.c"
        break;

    case YYSYMBOL_SET: /* SET  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1539 "rcfile_y.c"
        break;

    case YYSYMBOL_LOGFILE: /* LOGFILE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1545 "rcfile_y.c"
        break;

    case YYSYMBOL_DAEMON: /* DAEMON  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1551 "rcfile_y.c"
        break;

    case YYSYMBOL_SYSLOG: /* SYSLOG  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1557 "rcfile_y.c"
        break;

    case YYSYMBOL_IDFILE: /* IDFILE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1563 "rcfile_y.c"
        break;

    case YYSYMBOL_PIDFILE: /* PIDFILE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1569 "rcfile_y.c"
        break;

    case YYSYMBOL_INVISIBLE: /* INVISIBLE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1575 "rcfile_y.c"
        break;

    case YYSYMBOL_POSTMASTER: /* POSTMASTER  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1581 "rcfile_y.c"
        break;

    case YYSYMBOL_BOUNCEMAIL: /* BOUNCEMAIL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1587 "rcfile_y.c"
        break;

    case YYSYMBOL_SPAMBOUNCE: /* SPAMBOUNCE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1593 "rcfile_y.c"
        break;

    case YYSYMBOL_SOFTBOUNCE: /* SOFTBOUNCE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1599 "rcfile_y.c"
        break;

    case YYSYMBOL_SHOWDOTS: /* SHOWDOTS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1605 "rcfile_y.c"
        break;

    case YYSYMBOL_BADHEADER: /* BADHEADER  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1611 "rcfile_y.c"
        break;

    case YYSYMBOL_ACCEPT: /* ACCEPT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1617 "rcfile_y.c"
        break;

    case YYSYMBOL_REJECT_: /* REJECT_  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1623 "rcfile_y.c"
        break;

    case YYSYMBOL_PROTO: /* PROTO  */
#line 92 "../rcfile_y.y"
         { fprintf(yyo, "((proto)(%d))", ((*yyvaluep).proto)); }
#line 1629 "rcfile_y.c"
        break;

    case YYSYMBOL_AUTHTYPE: /* AUTHTYPE  */
#line 92 "../rcfile_y.y"
         { fprintf(yyo, "((proto)(%d))", ((*yyvaluep).proto)); }
#line 1635 "rcfile_y.c"
        break;

    case YYSYMBOL_STRING: /* STRING  */
#line 90 "../rcfile_y.y"
         { fprintf(yyo, "\"%s\"", ((*yyvaluep).sval)); }
#line 1641 "rcfile_y.c"
        break;

    case YYSYMBOL_NUMBER: /* NUMBER  */
#line 91 "../rcfile_y.y"
         { fprintf(yyo, "%d", ((*yyvaluep).number)); }
#line 1647 "rcfile_y.c"
        break;

    case YYSYMBOL_NO: /* NO  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1653 "rcfile_y.c"
        break;

    case YYSYMBOL_KEEP: /* KEEP  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1659 "rcfile_y.c"
        break;

    case YYSYMBOL_MOVETO: /* MOVETO  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1665 "rcfile_y.c"
        break;

    case YYSYMBOL_FLUSH: /* FLUSH  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1671 "rcfile_y.c"
        break;

    case YYSYMBOL_LIMITFLUSH: /* LIMITFLUSH  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1677 "rcfile_y.c"
        break;

    case YYSYMBOL_FETCHALL: /* FETCHALL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1683 "rcfile_y.c"
        break;

    case YYSYMBOL_REWRITE: /* REWRITE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1689 "rcfile_y.c"
        break;

    case YYSYMBOL_FORCECR: /* FORCECR  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1695 "rcfile_y.c"
        break;

    case YYSYMBOL_STRIPCR: /* STRIPCR  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1701 "rcfile_y.c"
        break;

    case YYSYMBOL_PASS8BITS: /* PASS8BITS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1707 "rcfile_y.c"
        break;

    case YYSYMBOL_DROPSTATUS: /* DROPSTATUS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1713 "rcfile_y.c"
        break;

    case YYSYMBOL_DROPDELIVERED: /* DROPDELIVERED  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1719 "rcfile_y.c"
        break;

    case YYSYMBOL_FORCEIDLE: /* FORCEIDLE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1725 "rcfile_y.c"
        break;

    case YYSYMBOL_DNS: /* DNS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1731 "rcfile_y.c"
        break;

    case YYSYMBOL_SERVICE: /* SERVICE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1737 "rcfile_y.c"
        break;

    case YYSYMBOL_PORT: /* PORT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1743 "rcfile_y.c"
        break;

    case YYSYMBOL_UIDL: /* UIDL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1749 "rcfile_y.c"
        break;

    case YYSYMBOL_INTERVAL: /* INTERVAL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1755 "rcfile_y.c"
        break;

    case YYSYMBOL_MIMEDECODE: /* MIMEDECODE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1761 "rcfile_y.c"
        break;

    case YYSYMBOL_IDLE: /* IDLE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1767 "rcfile_y.c"
        break;

    case YYSYMBOL_CHECKALIAS: /* CHECKALIAS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1773 "rcfile_y.c"
        break;

    case YYSYMBOL_SSL: /* SSL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1779 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLKEY: /* SSLKEY  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1785 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLCERT: /* SSLCERT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1791 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLPROTO: /* SSLPROTO  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1797 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLCERTCK: /* SSLCERTCK  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1803 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLCERTFILE: /* SSLCERTFILE  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1809 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLCERTPATH: /* SSLCERTPATH  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1815 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLCOMMONNAME: /* SSLCOMMONNAME  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1821 "rcfile_y.c"
        break;

    case YYSYMBOL_SSLFINGERPRINT: /* SSLFINGERPRINT  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1827 "rcfile_y.c"
        break;

    case YYSYMBOL_PRINCIPAL: /* PRINCIPAL  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1833 "rcfile_y.c"
        break;

    case YYSYMBOL_ESMTPNAME: /* ESMTPNAME  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1839 "rcfile_y.c"
        break;

    case YYSYMBOL_ESMTPPASSWORD: /* ESMTPPASSWORD  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1845 "rcfile_y.c"
        break;

    case YYSYMBOL_TRACEPOLLS: /* TRACEPOLLS  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1851 "rcfile_y.c"
        break;

    case YYSYMBOL_statement_list: /* statement_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1857 "rcfile_y.c"
        break;

    case YYSYMBOL_optmap: /* optmap  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1863 "rcfile_y.c"
        break;

    case YYSYMBOL_statement: /* statement  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1869 "rcfile_y.c"
        break;

    case YYSYMBOL_define_server: /* define_server  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1875 "rcfile_y.c"
        break;

    case YYSYMBOL_serverspecs: /* serverspecs  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1881 "rcfile_y.c"
        break;

    case YYSYMBOL_alias_list: /* alias_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1887 "rcfile_y.c"
        break;

    case YYSYMBOL_domain_list: /* domain_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1893 "rcfile_y.c"
        break;

    case YYSYMBOL_serv_option: /* serv_option  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1899 "rcfile_y.c"
        break;

    case YYSYMBOL_userspecs: /* userspecs  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1905 "rcfile_y.c"
        break;

    case YYSYMBOL_explicits: /* explicits  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1911 "rcfile_y.c"
        break;

    case YYSYMBOL_explicitdef: /* explicitdef  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1917 "rcfile_y.c"
        break;

    case YYSYMBOL_userdef: /* userdef  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1923 "rcfile_y.c"
        break;

    case YYSYMBOL_user0opts: /* user0opts  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1929 "rcfile_y.c"
        break;

    case YYSYMBOL_user1opts: /* user1opts  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1935 "rcfile_y.c"
        break;

    case YYSYMBOL_mapping_list: /* mapping_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1941 "rcfile_y.c"
        break;

    case YYSYMBOL_mapping: /* mapping  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1947 "rcfile_y.c"
        break;

    case YYSYMBOL_folder_list: /* folder_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1953 "rcfile_y.c"
        break;

    case YYSYMBOL_smtp_list: /* smtp_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1959 "rcfile_y.c"
        break;

    case YYSYMBOL_fetch_list: /* fetch_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1965 "rcfile_y.c"
        break;

    case YYSYMBOL_num_list: /* num_list  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1971 "rcfile_y.c"
        break;

    case YYSYMBOL_user_option: /* user_option  */
#line 93 "../rcfile_y.y"
         { fprintf(yyo, "<>"); }
#line 1977 "rcfile_y.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Given a state stack such that *YYBOTTOM is its bottom, such that
   *YYTOP is either its top or is YYTOP_EMPTY to indicate an empty
   stack, and such that *YYCAPACITY is the maximum number of elements it
   can hold without a reallocation, make sure there is enough room to
   store YYADD more elements.  If not, allocate a new stack using
   YYSTACK_ALLOC, copy the existing elements, and adjust *YYBOTTOM,
   *YYTOP, and *YYCAPACITY to reflect the new capacity and memory
   location.  If *YYBOTTOM != YYBOTTOM_NO_FREE, then free the old stack
   using YYSTACK_FREE.  Return 0 if successful or if no reallocation is
   required.  Return YYENOMEM if memory is exhausted.  */
static int
yy_lac_stack_realloc (YYPTRDIFF_T *yycapacity, YYPTRDIFF_T yyadd,
#if YYDEBUG
                      char const *yydebug_prefix,
                      char const *yydebug_suffix,
#endif
                      yy_state_t **yybottom,
                      yy_state_t *yybottom_no_free,
                      yy_state_t **yytop, yy_state_t *yytop_empty)
{
  YYPTRDIFF_T yysize_old =
    *yytop == yytop_empty ? 0 : *yytop - *yybottom + 1;
  YYPTRDIFF_T yysize_new = yysize_old + yyadd;
  if (*yycapacity < yysize_new)
    {
      YYPTRDIFF_T yyalloc = 2 * yysize_new;
      yy_state_t *yybottom_new;
      /* Use YYMAXDEPTH for maximum stack size given that the stack
         should never need to grow larger than the main state stack
         needs to grow without LAC.  */
      if (YYMAXDEPTH < yysize_new)
        {
          YYDPRINTF ((stderr, "%smax size exceeded%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (YYMAXDEPTH < yyalloc)
        yyalloc = YYMAXDEPTH;
      yybottom_new =
        YY_CAST (yy_state_t *,
                 YYSTACK_ALLOC (YY_CAST (YYSIZE_T,
                                         yyalloc * YYSIZEOF (*yybottom_new))));
      if (!yybottom_new)
        {
          YYDPRINTF ((stderr, "%srealloc failed%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (*yytop != yytop_empty)
        {
          YYCOPY (yybottom_new, *yybottom, yysize_old);
          *yytop = yybottom_new + (yysize_old - 1);
        }
      if (*yybottom != yybottom_no_free)
        YYSTACK_FREE (*yybottom);
      *yybottom = yybottom_new;
      *yycapacity = yyalloc;
    }
  return 0;
}

/* Establish the initial context for the current lookahead if no initial
   context is currently established.

   We define a context as a snapshot of the parser stacks.  We define
   the initial context for a lookahead as the context in which the
   parser initially examines that lookahead in order to select a
   syntactic action.  Thus, if the lookahead eventually proves
   syntactically unacceptable (possibly in a later context reached via a
   series of reductions), the initial context can be used to determine
   the exact set of tokens that would be syntactically acceptable in the
   lookahead's place.  Moreover, it is the context after which any
   further semantic actions would be erroneous because they would be
   determined by a syntactically unacceptable token.

   YY_LAC_ESTABLISH should be invoked when a reduction is about to be
   performed in an inconsistent state (which, for the purposes of LAC,
   includes consistent states that don't know they're consistent because
   their default reductions have been disabled).  Iff there is a
   lookahead token, it should also be invoked before reporting a syntax
   error.  This latter case is for the sake of the debugging output.

   For parse.lac=full, the implementation of YY_LAC_ESTABLISH is as
   follows.  If no initial context is currently established for the
   current lookahead, then check if that lookahead can eventually be
   shifted if syntactic actions continue from the current context.
   Report a syntax error if it cannot.  */
#define YY_LAC_ESTABLISH                                                \
do {                                                                    \
  if (!yy_lac_established)                                              \
    {                                                                   \
      YYDPRINTF ((stderr,                                               \
                  "LAC: initial context established for %s\n",          \
                  yysymbol_name (yytoken)));                            \
      yy_lac_established = 1;                                           \
      switch (yy_lac (yyesa, &yyes, &yyes_capacity, yyssp, yytoken))    \
        {                                                               \
        case YYENOMEM:                                                  \
          YYNOMEM;                                                      \
        case 1:                                                         \
          goto yyerrlab;                                                \
        }                                                               \
    }                                                                   \
} while (0)

/* Discard any previous initial lookahead context because of Event,
   which may be a lookahead change or an invalidation of the currently
   established initial context for the current lookahead.

   The most common example of a lookahead change is a shift.  An example
   of both cases is syntax error recovery.  That is, a syntax error
   occurs when the lookahead is syntactically erroneous for the
   currently established initial context, so error recovery manipulates
   the parser stacks to try to find a new initial context in which the
   current lookahead is syntactically acceptable.  If it fails to find
   such a context, it discards the lookahead.  */
#if YYDEBUG
# define YY_LAC_DISCARD(Event)                                           \
do {                                                                     \
  if (yy_lac_established)                                                \
    {                                                                    \
      YYDPRINTF ((stderr, "LAC: initial context discarded due to "       \
                  Event "\n"));                                          \
      yy_lac_established = 0;                                            \
    }                                                                    \
} while (0)
#else
# define YY_LAC_DISCARD(Event) yy_lac_established = 0
#endif

/* Given the stack whose top is *YYSSP, return 0 iff YYTOKEN can
   eventually (after perhaps some reductions) be shifted, return 1 if
   not, or return YYENOMEM if memory is exhausted.  As preconditions and
   postconditions: *YYES_CAPACITY is the allocated size of the array to
   which *YYES points, and either *YYES = YYESA or *YYES points to an
   array allocated with YYSTACK_ALLOC.  yy_lac may overwrite the
   contents of either array, alter *YYES and *YYES_CAPACITY, and free
   any old *YYES other than YYESA.  */
static int
yy_lac (yy_state_t *yyesa, yy_state_t **yyes,
        YYPTRDIFF_T *yyes_capacity, yy_state_t *yyssp, yysymbol_kind_t yytoken)
{
  yy_state_t *yyes_prev = yyssp;
  yy_state_t *yyesp = yyes_prev;
  /* Reduce until we encounter a shift and thereby accept the token.  */
  YYDPRINTF ((stderr, "LAC: checking lookahead %s:", yysymbol_name (yytoken)));
  if (yytoken == YYSYMBOL_YYUNDEF)
    {
      YYDPRINTF ((stderr, " Always Err\n"));
      return 1;
    }
  while (1)
    {
      int yyrule = yypact[+*yyesp];
      if (yypact_value_is_default (yyrule)
          || (yyrule += yytoken) < 0 || YYLAST < yyrule
          || yycheck[yyrule] != yytoken)
        {
          /* Use the default action.  */
          yyrule = yydefact[+*yyesp];
          if (yyrule == 0)
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
        }
      else
        {
          /* Use the action from yytable.  */
          yyrule = yytable[yyrule];
          if (yytable_value_is_error (yyrule))
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
          if (0 < yyrule)
            {
              YYDPRINTF ((stderr, " S%d\n", yyrule));
              return 0;
            }
          yyrule = -yyrule;
        }
      /* By now we know we have to simulate a reduce.  */
      YYDPRINTF ((stderr, " R%d", yyrule - 1));
      {
        /* Pop the corresponding number of values from the stack.  */
        YYPTRDIFF_T yylen = yyr2[yyrule];
        /* First pop from the LAC stack as many tokens as possible.  */
        if (yyesp != yyes_prev)
          {
            YYPTRDIFF_T yysize = yyesp - *yyes + 1;
            if (yylen < yysize)
              {
                yyesp -= yylen;
                yylen = 0;
              }
            else
              {
                yyesp = yyes_prev;
                yylen -= yysize;
              }
          }
        /* Only afterwards look at the main stack.  */
        if (yylen)
          yyesp = yyes_prev -= yylen;
      }
      /* Push the resulting state of the reduction.  */
      {
        yy_state_fast_t yystate;
        {
          const int yylhs = yyr1[yyrule] - YYNTOKENS;
          const int yyi = yypgoto[yylhs] + *yyesp;
          yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyesp
                     ? yytable[yyi]
                     : yydefgoto[yylhs]);
        }
        if (yyesp == yyes_prev)
          {
            yyesp = *yyes;
            YY_IGNORE_USELESS_CAST_BEGIN
            *yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        else
          {
            if (yy_lac_stack_realloc (yyes_capacity, 1,
#if YYDEBUG
                                      " (", ")",
#endif
                                      yyes, yyesa, &yyesp, yyes_prev))
              {
                YYDPRINTF ((stderr, "\n"));
                return YYENOMEM;
              }
            YY_IGNORE_USELESS_CAST_BEGIN
            *++yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        YYDPRINTF ((stderr, " G%d", yystate));
      }
    }
}

/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yy_state_t *yyesa;
  yy_state_t **yyes;
  YYPTRDIFF_T *yyes_capacity;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;

  int yyx;
  for (yyx = 0; yyx < YYNTOKENS; ++yyx)
    {
      yysymbol_kind_t yysym = YY_CAST (yysymbol_kind_t, yyx);
      if (yysym != YYSYMBOL_YYerror && yysym != YYSYMBOL_YYUNDEF)
        switch (yy_lac (yyctx->yyesa, yyctx->yyes, yyctx->yyes_capacity, yyctx->yyssp, yysym))
          {
          case YYENOMEM:
            return YYENOMEM;
          case 1:
            continue;
          default:
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif



static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
       In the first two cases, it might appear that the current syntax
       error should have been detected in the previous state when yy_lac
       was invoked.  However, at that time, there might have been a
       different syntax error that discarded a different initial context
       during error recovery, leaving behind the current lookahead.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      YYDPRINTF ((stderr, "Constructing syntax error message\n"));
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else if (yyn == 0)
        YYDPRINTF ((stderr, "No expected tokens.\n"));
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.  In order to see if a particular token T is a
   valid looakhead, invoke yy_lac (YYESA, YYES, YYES_CAPACITY, YYSSP, T).

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store or if
   yy_lac returned YYENOMEM.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yystrlen (yysymbol_name (yyarg[yyi]));
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp = yystpcpy (yyp, yysymbol_name (yyarg[yyi++]));
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_STRING: /* STRING  */
#line 84 "../rcfile_y.y"
            { free (((*yyvaluep).sval)); }
#line 2571 "rcfile_y.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    yy_state_t yyesa[20];
    yy_state_t *yyes = yyesa;
    YYPTRDIFF_T yyes_capacity = 20 < YYMAXDEPTH ? 20 : YYMAXDEPTH;

  /* Whether LAC context is established.  A Boolean.  */
  int yy_lac_established = 0;
  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    {
      YY_LAC_ESTABLISH;
      goto yydefault;
    }
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      YY_LAC_ESTABLISH;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  YY_LAC_DISCARD ("shift");
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  {
    int yychar_backup = yychar;
    switch (yyn)
      {
  case 7: /* statement: SET LOGFILE optmap STRING  */
#line 105 "../rcfile_y.y"
                                                {run.logfile = prependdir ((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 2857 "rcfile_y.c"
    break;

  case 8: /* statement: SET IDFILE optmap STRING  */
#line 106 "../rcfile_y.y"
                                                {run.idfile = prependdir ((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 2863 "rcfile_y.c"
    break;

  case 9: /* statement: SET PIDFILE optmap STRING  */
#line 107 "../rcfile_y.y"
                                                {run.pidfile = prependdir ((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 2869 "rcfile_y.c"
    break;

  case 10: /* statement: SET DAEMON optmap NUMBER  */
#line 108 "../rcfile_y.y"
                                                {run.poll_interval = (yyvsp[0].number);}
#line 2875 "rcfile_y.c"
    break;

  case 11: /* statement: SET POSTMASTER optmap STRING  */
#line 109 "../rcfile_y.y"
                                                {run.postmaster = (yyvsp[0].sval);}
#line 2881 "rcfile_y.c"
    break;

  case 12: /* statement: SET BOUNCEMAIL  */
#line 110 "../rcfile_y.y"
                                                {run.bouncemail = TRUE;}
#line 2887 "rcfile_y.c"
    break;

  case 13: /* statement: SET NO BOUNCEMAIL  */
#line 111 "../rcfile_y.y"
                                                {run.bouncemail = FALSE;}
#line 2893 "rcfile_y.c"
    break;

  case 14: /* statement: SET SPAMBOUNCE  */
#line 112 "../rcfile_y.y"
                                                {run.spambounce = TRUE;}
#line 2899 "rcfile_y.c"
    break;

  case 15: /* statement: SET NO SPAMBOUNCE  */
#line 113 "../rcfile_y.y"
                                                {run.spambounce = FALSE;}
#line 2905 "rcfile_y.c"
    break;

  case 16: /* statement: SET SOFTBOUNCE  */
#line 114 "../rcfile_y.y"
                                                {run.softbounce = TRUE;}
#line 2911 "rcfile_y.c"
    break;

  case 17: /* statement: SET NO SOFTBOUNCE  */
#line 115 "../rcfile_y.y"
                                                {run.softbounce = FALSE;}
#line 2917 "rcfile_y.c"
    break;

  case 18: /* statement: SET PROPERTIES optmap STRING  */
#line 116 "../rcfile_y.y"
                                                {run.properties = (yyvsp[0].sval);}
#line 2923 "rcfile_y.c"
    break;

  case 19: /* statement: SET SYSLOG  */
#line 117 "../rcfile_y.y"
                                                {run.use_syslog = TRUE;}
#line 2929 "rcfile_y.c"
    break;

  case 20: /* statement: SET NO SYSLOG  */
#line 118 "../rcfile_y.y"
                                                {run.use_syslog = FALSE;}
#line 2935 "rcfile_y.c"
    break;

  case 21: /* statement: SET INVISIBLE  */
#line 119 "../rcfile_y.y"
                                                {run.invisible = TRUE;}
#line 2941 "rcfile_y.c"
    break;

  case 22: /* statement: SET NO INVISIBLE  */
#line 120 "../rcfile_y.y"
                                                {run.invisible = FALSE;}
#line 2947 "rcfile_y.c"
    break;

  case 23: /* statement: SET SHOWDOTS  */
#line 121 "../rcfile_y.y"
                                                {run.showdots = FLAG_TRUE;}
#line 2953 "rcfile_y.c"
    break;

  case 24: /* statement: SET NO SHOWDOTS  */
#line 122 "../rcfile_y.y"
                                                {run.showdots = FLAG_FALSE;}
#line 2959 "rcfile_y.c"
    break;

  case 25: /* statement: define_server serverspecs  */
#line 130 "../rcfile_y.y"
                                                        {record_current();}
#line 2965 "rcfile_y.c"
    break;

  case 27: /* statement: define_server serverspecs userspecs serv_option  */
#line 135 "../rcfile_y.y"
                        {yyerror(GT_("server option after user options")); yyerrok; }
#line 2971 "rcfile_y.c"
    break;

  case 28: /* define_server: POLL STRING  */
#line 138 "../rcfile_y.y"
                                        {reset_server((yyvsp[0].sval), FALSE); free((yyvsp[0].sval));}
#line 2977 "rcfile_y.c"
    break;

  case 29: /* define_server: SKIP STRING  */
#line 139 "../rcfile_y.y"
                                        {reset_server((yyvsp[0].sval), TRUE);  free((yyvsp[0].sval));}
#line 2983 "rcfile_y.c"
    break;

  case 30: /* define_server: DEFAULTS  */
#line 140 "../rcfile_y.y"
                                        {reset_server("defaults", FALSE);}
#line 2989 "rcfile_y.c"
    break;

  case 33: /* alias_list: STRING  */
#line 147 "../rcfile_y.y"
                                        {save_str(&current.server.akalist,(yyvsp[0].sval),0); free((yyvsp[0].sval));}
#line 2995 "rcfile_y.c"
    break;

  case 34: /* alias_list: alias_list STRING  */
#line 148 "../rcfile_y.y"
                                        {save_str(&current.server.akalist,(yyvsp[0].sval),0); free((yyvsp[0].sval));}
#line 3001 "rcfile_y.c"
    break;

  case 35: /* domain_list: STRING  */
#line 151 "../rcfile_y.y"
                                        {save_str(&current.server.localdomains,(yyvsp[0].sval),0); free((yyvsp[0].sval));}
#line 3007 "rcfile_y.c"
    break;

  case 36: /* domain_list: domain_list STRING  */
#line 152 "../rcfile_y.y"
                                        {save_str(&current.server.localdomains,(yyvsp[0].sval),0); free((yyvsp[0].sval));}
#line 3013 "rcfile_y.c"
    break;

  case 38: /* serv_option: VIA STRING  */
#line 156 "../rcfile_y.y"
                                        {current.server.via = (yyvsp[0].sval);}
#line 3019 "rcfile_y.c"
    break;

  case 40: /* serv_option: PROTOCOL PROTO  */
#line 158 "../rcfile_y.y"
                                        {current.server.protocol = (yyvsp[0].proto);}
#line 3025 "rcfile_y.c"
    break;

  case 41: /* serv_option: PROTOCOL KPOP  */
#line 159 "../rcfile_y.y"
                                        {
					    current.server.protocol = P_POP3;

					    if (current.server.authenticate == A_PASSWORD)
#ifdef KERBEROS_V5
						current.server.authenticate = A_KERBEROS_V5;
#else
						current.server.authenticate = A_KERBEROS_V4;
#endif /* KERBEROS_V5 */
					    current.server.service = KPOP_PORT;
					}
#line 3041 "rcfile_y.c"
    break;

  case 42: /* serv_option: PRINCIPAL STRING  */
#line 170 "../rcfile_y.y"
                                        {current.server.principal = (yyvsp[0].sval);}
#line 3047 "rcfile_y.c"
    break;

  case 43: /* serv_option: ESMTPNAME STRING  */
#line 171 "../rcfile_y.y"
                                        {current.server.esmtp_name = (yyvsp[0].sval);}
#line 3053 "rcfile_y.c"
    break;

  case 44: /* serv_option: ESMTPPASSWORD STRING  */
#line 172 "../rcfile_y.y"
                                        {current.server.esmtp_password = (yyvsp[0].sval);}
#line 3059 "rcfile_y.c"
    break;

  case 45: /* serv_option: PROTOCOL SDPS  */
#line 173 "../rcfile_y.y"
                                        {
#ifdef SDPS_ENABLE
					    current.server.protocol = P_POP3;
					    current.server.sdps = TRUE;
#else
					    yyerror(GT_("SDPS not enabled."));
#endif /* SDPS_ENABLE */
					}
#line 3072 "rcfile_y.c"
    break;

  case 46: /* serv_option: UIDL  */
#line 181 "../rcfile_y.y"
                                        {current.server.uidl = FLAG_TRUE;}
#line 3078 "rcfile_y.c"
    break;

  case 47: /* serv_option: NO UIDL  */
#line 182 "../rcfile_y.y"
                                        {current.server.uidl  = FLAG_FALSE;}
#line 3084 "rcfile_y.c"
    break;

  case 48: /* serv_option: CHECKALIAS  */
#line 183 "../rcfile_y.y"
                                        {current.server.checkalias = FLAG_TRUE;}
#line 3090 "rcfile_y.c"
    break;

  case 49: /* serv_option: NO CHECKALIAS  */
#line 184 "../rcfile_y.y"
                                        {current.server.checkalias  = FLAG_FALSE;}
#line 3096 "rcfile_y.c"
    break;

  case 50: /* serv_option: SERVICE STRING  */
#line 185 "../rcfile_y.y"
                                        {
					current.server.service = (yyvsp[0].sval);
					}
#line 3104 "rcfile_y.c"
    break;

  case 51: /* serv_option: SERVICE NUMBER  */
#line 188 "../rcfile_y.y"
                                        {
					int port = (yyvsp[0].number);
					char buf[10];
					snprintf(buf, sizeof buf, "%d", port);
					current.server.service = xstrdup(buf);
		}
#line 3115 "rcfile_y.c"
    break;

  case 52: /* serv_option: PORT NUMBER  */
#line 194 "../rcfile_y.y"
                                        {
					int port = (yyvsp[0].number);
					char buf[10];
					snprintf(buf, sizeof buf, "%d", port);
					current.server.service = xstrdup(buf);
		}
#line 3126 "rcfile_y.c"
    break;

  case 53: /* serv_option: INTERVAL NUMBER  */
#line 201 "../rcfile_y.y"
                        {current.server.interval = (yyvsp[0].number);}
#line 3132 "rcfile_y.c"
    break;

  case 54: /* serv_option: AUTHENTICATE AUTHTYPE  */
#line 203 "../rcfile_y.y"
                        {current.server.authenticate = (yyvsp[0].proto);}
#line 3138 "rcfile_y.c"
    break;

  case 55: /* serv_option: TIMEOUT NUMBER  */
#line 205 "../rcfile_y.y"
                        {current.server.timeout = (yyvsp[0].number);}
#line 3144 "rcfile_y.c"
    break;

  case 56: /* serv_option: IDLETIMEOUT NUMBER  */
#line 207 "../rcfile_y.y"
                        {current.server.idle_timeout = (yyvsp[0].number);}
#line 3150 "rcfile_y.c"
    break;

  case 57: /* serv_option: ENVELOPE NUMBER STRING  */
#line 209 "../rcfile_y.y"
                                        {
					    current.server.envelope = (yyvsp[0].sval);
					    current.server.envskip = (yyvsp[-1].number);
					}
#line 3159 "rcfile_y.c"
    break;

  case 58: /* serv_option: ENVELOPE STRING  */
#line 214 "../rcfile_y.y"
                                        {
					    current.server.envelope = (yyvsp[0].sval);
					    current.server.envskip = 0;
					}
#line 3168 "rcfile_y.c"
    break;

  case 59: /* serv_option: QVIRTUAL STRING  */
#line 219 "../rcfile_y.y"
                                        {current.server.qvirtual = (yyvsp[0].sval);}
#line 3174 "rcfile_y.c"
    break;

  case 60: /* serv_option: INTERFACE STRING  */
#line 220 "../rcfile_y.y"
                                        {
#ifdef CAN_MONITOR
					interface_parse((yyvsp[0].sval), &current.server);
#else
					fprintf(stderr, GT_("fetchmail: interface option is only supported under Linux (without IPv6) and FreeBSD\n"));
#endif
					free((yyvsp[0].sval));
					}
#line 3187 "rcfile_y.c"
    break;

  case 61: /* serv_option: MONITOR STRING  */
#line 228 "../rcfile_y.y"
                                        {
#ifdef CAN_MONITOR
					current.server.monitor = (yyvsp[0].sval);
#else
					fprintf(stderr, GT_("fetchmail: monitor option is only supported under Linux (without IPv6) and FreeBSD\n"));
					free((yyvsp[0].sval));
#endif
					}
#line 3200 "rcfile_y.c"
    break;

  case 62: /* serv_option: PLUGIN STRING  */
#line 236 "../rcfile_y.y"
                                        { current.server.plugin = (yyvsp[0].sval); }
#line 3206 "rcfile_y.c"
    break;

  case 63: /* serv_option: PLUGOUT STRING  */
#line 237 "../rcfile_y.y"
                                        { current.server.plugout = (yyvsp[0].sval); }
#line 3212 "rcfile_y.c"
    break;

  case 64: /* serv_option: DNS  */
#line 238 "../rcfile_y.y"
                                        {current.server.dns = FLAG_TRUE;}
#line 3218 "rcfile_y.c"
    break;

  case 65: /* serv_option: NO DNS  */
#line 239 "../rcfile_y.y"
                                        {current.server.dns = FLAG_FALSE;}
#line 3224 "rcfile_y.c"
    break;

  case 66: /* serv_option: NO ENVELOPE  */
#line 240 "../rcfile_y.y"
                                        {current.server.envelope = STRING_DISABLED;}
#line 3230 "rcfile_y.c"
    break;

  case 67: /* serv_option: TRACEPOLLS  */
#line 241 "../rcfile_y.y"
                                        {current.server.tracepolls = FLAG_TRUE;}
#line 3236 "rcfile_y.c"
    break;

  case 68: /* serv_option: NO TRACEPOLLS  */
#line 242 "../rcfile_y.y"
                                        {current.server.tracepolls = FLAG_FALSE;}
#line 3242 "rcfile_y.c"
    break;

  case 69: /* serv_option: BADHEADER ACCEPT  */
#line 243 "../rcfile_y.y"
                                        {current.server.badheader = BHACCEPT;}
#line 3248 "rcfile_y.c"
    break;

  case 70: /* serv_option: BADHEADER REJECT_  */
#line 244 "../rcfile_y.y"
                                        {current.server.badheader = BHREJECT;}
#line 3254 "rcfile_y.c"
    break;

  case 71: /* userspecs: user1opts  */
#line 247 "../rcfile_y.y"
                                        {record_current(); user_reset();}
#line 3260 "rcfile_y.c"
    break;

  case 73: /* explicits: explicitdef  */
#line 251 "../rcfile_y.y"
                                        {record_current(); user_reset();}
#line 3266 "rcfile_y.c"
    break;

  case 74: /* explicits: explicits explicitdef  */
#line 252 "../rcfile_y.y"
                                        {record_current(); user_reset();}
#line 3272 "rcfile_y.c"
    break;

  case 76: /* userdef: USERNAME STRING  */
#line 258 "../rcfile_y.y"
                                        {current.remotename = (yyvsp[0].sval);}
#line 3278 "rcfile_y.c"
    break;

  case 78: /* userdef: USERNAME STRING THERE  */
#line 260 "../rcfile_y.y"
                                        {current.remotename = (yyvsp[-1].sval);}
#line 3284 "rcfile_y.c"
    break;

  case 85: /* mapping: STRING  */
#line 275 "../rcfile_y.y"
                                        {if (0 == strcmp((yyvsp[0].sval), "*")) {
					      current.wildcard = TRUE;
					  } else {
					    save_str_pair(&current.localnames, (yyvsp[0].sval), NULL);
					  }
					 free((yyvsp[0].sval));}
#line 3295 "rcfile_y.c"
    break;

  case 86: /* mapping: STRING MAP STRING  */
#line 281 "../rcfile_y.y"
                                        {save_str_pair(&current.localnames, (yyvsp[-2].sval), (yyvsp[0].sval)); free((yyvsp[-2].sval)); free((yyvsp[0].sval));}
#line 3301 "rcfile_y.c"
    break;

  case 87: /* folder_list: STRING  */
#line 284 "../rcfile_y.y"
                                        {save_str(&current.mailboxes,(yyvsp[0].sval),0); free((yyvsp[0].sval));}
#line 3307 "rcfile_y.c"
    break;

  case 88: /* folder_list: folder_list STRING  */
#line 285 "../rcfile_y.y"
                                        {save_str(&current.mailboxes,(yyvsp[0].sval),0); free((yyvsp[0].sval));}
#line 3313 "rcfile_y.c"
    break;

  case 89: /* smtp_list: STRING  */
#line 288 "../rcfile_y.y"
                                        {save_str(&current.smtphunt, (yyvsp[0].sval),TRUE); free((yyvsp[0].sval));}
#line 3319 "rcfile_y.c"
    break;

  case 90: /* smtp_list: smtp_list STRING  */
#line 289 "../rcfile_y.y"
                                        {save_str(&current.smtphunt, (yyvsp[0].sval),TRUE); free((yyvsp[0].sval));}
#line 3325 "rcfile_y.c"
    break;

  case 91: /* fetch_list: STRING  */
#line 292 "../rcfile_y.y"
                                        {save_str(&current.domainlist, (yyvsp[0].sval),TRUE); free((yyvsp[0].sval));}
#line 3331 "rcfile_y.c"
    break;

  case 92: /* fetch_list: fetch_list STRING  */
#line 293 "../rcfile_y.y"
                                        {save_str(&current.domainlist, (yyvsp[0].sval),TRUE); free((yyvsp[0].sval));}
#line 3337 "rcfile_y.c"
    break;

  case 93: /* num_list: NUMBER  */
#line 297 "../rcfile_y.y"
                        {
			    struct idlist *id;
			    id = save_str(&current.antispam,STRING_DUMMY,0);
			    id->val.status.num = (yyvsp[0].number);
			}
#line 3347 "rcfile_y.c"
    break;

  case 94: /* num_list: num_list NUMBER  */
#line 303 "../rcfile_y.y"
                        {
			    struct idlist *id;
			    id = save_str(&current.antispam,STRING_DUMMY,0);
			    id->val.status.num = (yyvsp[0].number);
			}
#line 3357 "rcfile_y.c"
    break;

  case 99: /* user_option: IS STRING THERE  */
#line 315 "../rcfile_y.y"
                                        {current.remotename  = (yyvsp[-1].sval);}
#line 3363 "rcfile_y.c"
    break;

  case 100: /* user_option: PASSWORD STRING  */
#line 316 "../rcfile_y.y"
                                        {current.password    = (yyvsp[0].sval);}
#line 3369 "rcfile_y.c"
    break;

  case 104: /* user_option: SMTPADDRESS STRING  */
#line 320 "../rcfile_y.y"
                                        {current.smtpaddress = (yyvsp[0].sval);}
#line 3375 "rcfile_y.c"
    break;

  case 105: /* user_option: SMTPNAME STRING  */
#line 321 "../rcfile_y.y"
                                        {current.smtpname =    (yyvsp[0].sval);}
#line 3381 "rcfile_y.c"
    break;

  case 107: /* user_option: MDA STRING  */
#line 323 "../rcfile_y.y"
                                        {current.mda         = (yyvsp[0].sval);}
#line 3387 "rcfile_y.c"
    break;

  case 108: /* user_option: BSMTP STRING  */
#line 324 "../rcfile_y.y"
                                        {current.bsmtp       = prependdir ((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 3393 "rcfile_y.c"
    break;

  case 109: /* user_option: LMTP  */
#line 325 "../rcfile_y.y"
                                        {current.listener    = LMTP_MODE;}
#line 3399 "rcfile_y.c"
    break;

  case 110: /* user_option: PRECONNECT STRING  */
#line 326 "../rcfile_y.y"
                                        {current.preconnect  = (yyvsp[0].sval);}
#line 3405 "rcfile_y.c"
    break;

  case 111: /* user_option: POSTCONNECT STRING  */
#line 327 "../rcfile_y.y"
                                        {current.postconnect = (yyvsp[0].sval);}
#line 3411 "rcfile_y.c"
    break;

  case 112: /* user_option: KEEP  */
#line 329 "../rcfile_y.y"
                                        {current.keep        = FLAG_TRUE;}
#line 3417 "rcfile_y.c"
    break;

  case 113: /* user_option: MOVETO STRING  */
#line 330 "../rcfile_y.y"
                                        {current.moveto      = (yyvsp[0].sval);}
#line 3423 "rcfile_y.c"
    break;

  case 114: /* user_option: FLUSH  */
#line 331 "../rcfile_y.y"
                                        {current.flush       = FLAG_TRUE;}
#line 3429 "rcfile_y.c"
    break;

  case 115: /* user_option: LIMITFLUSH  */
#line 332 "../rcfile_y.y"
                                        {current.limitflush  = FLAG_TRUE;}
#line 3435 "rcfile_y.c"
    break;

  case 116: /* user_option: FETCHALL  */
#line 333 "../rcfile_y.y"
                                        {current.fetchall    = FLAG_TRUE;}
#line 3441 "rcfile_y.c"
    break;

  case 117: /* user_option: REWRITE  */
#line 334 "../rcfile_y.y"
                                        {current.rewrite     = FLAG_TRUE;}
#line 3447 "rcfile_y.c"
    break;

  case 118: /* user_option: FORCECR  */
#line 335 "../rcfile_y.y"
                                        {current.forcecr     = FLAG_TRUE;}
#line 3453 "rcfile_y.c"
    break;

  case 119: /* user_option: STRIPCR  */
#line 336 "../rcfile_y.y"
                                        {current.stripcr     = FLAG_TRUE;}
#line 3459 "rcfile_y.c"
    break;

  case 120: /* user_option: PASS8BITS  */
#line 337 "../rcfile_y.y"
                                        {current.pass8bits   = FLAG_TRUE;}
#line 3465 "rcfile_y.c"
    break;

  case 121: /* user_option: DROPSTATUS  */
#line 338 "../rcfile_y.y"
                                        {current.dropstatus  = FLAG_TRUE;}
#line 3471 "rcfile_y.c"
    break;

  case 122: /* user_option: DROPDELIVERED  */
#line 339 "../rcfile_y.y"
                                        {current.dropdelivered = FLAG_TRUE;}
#line 3477 "rcfile_y.c"
    break;

  case 123: /* user_option: MIMEDECODE  */
#line 340 "../rcfile_y.y"
                                        {current.mimedecode  = FLAG_TRUE;}
#line 3483 "rcfile_y.c"
    break;

  case 124: /* user_option: IDLE  */
#line 341 "../rcfile_y.y"
                                        {current.idle        = FLAG_TRUE;}
#line 3489 "rcfile_y.c"
    break;

  case 125: /* user_option: FORCEIDLE  */
#line 342 "../rcfile_y.y"
                                        {current.forceidle   = FLAG_TRUE;}
#line 3495 "rcfile_y.c"
    break;

  case 126: /* user_option: SSL  */
#line 344 "../rcfile_y.y"
                                        {
#ifdef SSL_ENABLE
		    current.use_ssl = FLAG_TRUE;
#else
		    yyerror(GT_("SSL is not enabled"));
#endif 
		}
#line 3507 "rcfile_y.c"
    break;

  case 127: /* user_option: SSLKEY STRING  */
#line 351 "../rcfile_y.y"
                                        {current.sslkey = prependdir ((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 3513 "rcfile_y.c"
    break;

  case 128: /* user_option: SSLCERT STRING  */
#line 352 "../rcfile_y.y"
                                        {current.sslcert = prependdir ((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 3519 "rcfile_y.c"
    break;

  case 129: /* user_option: SSLPROTO STRING  */
#line 353 "../rcfile_y.y"
                                        {current.sslproto = (yyvsp[0].sval);}
#line 3525 "rcfile_y.c"
    break;

  case 130: /* user_option: SSLCERTCK  */
#line 354 "../rcfile_y.y"
                                        {current.sslcertck = FLAG_TRUE;}
#line 3531 "rcfile_y.c"
    break;

  case 131: /* user_option: SSLCERTFILE STRING  */
#line 355 "../rcfile_y.y"
                                        {current.sslcertfile = prependdir((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 3537 "rcfile_y.c"
    break;

  case 132: /* user_option: SSLCERTPATH STRING  */
#line 356 "../rcfile_y.y"
                                        {current.sslcertpath = prependdir((yyvsp[0].sval), rcfiledir); free((yyvsp[0].sval));}
#line 3543 "rcfile_y.c"
    break;

  case 133: /* user_option: SSLCOMMONNAME STRING  */
#line 357 "../rcfile_y.y"
                                        {current.sslcommonname = (yyvsp[0].sval);}
#line 3549 "rcfile_y.c"
    break;

  case 134: /* user_option: SSLFINGERPRINT STRING  */
#line 358 "../rcfile_y.y"
                                        {current.sslfingerprint = (yyvsp[0].sval);}
#line 3555 "rcfile_y.c"
    break;

  case 135: /* user_option: NO KEEP  */
#line 360 "../rcfile_y.y"
                                        {current.keep        = FLAG_FALSE;}
#line 3561 "rcfile_y.c"
    break;

  case 136: /* user_option: NO FLUSH  */
#line 361 "../rcfile_y.y"
                                        {current.flush       = FLAG_FALSE;}
#line 3567 "rcfile_y.c"
    break;

  case 137: /* user_option: NO LIMITFLUSH  */
#line 362 "../rcfile_y.y"
                                        {current.limitflush  = FLAG_FALSE;}
#line 3573 "rcfile_y.c"
    break;

  case 138: /* user_option: NO FETCHALL  */
#line 363 "../rcfile_y.y"
                                        {current.fetchall    = FLAG_FALSE;}
#line 3579 "rcfile_y.c"
    break;

  case 139: /* user_option: NO REWRITE  */
#line 364 "../rcfile_y.y"
                                        {current.rewrite     = FLAG_FALSE;}
#line 3585 "rcfile_y.c"
    break;

  case 140: /* user_option: NO FORCECR  */
#line 365 "../rcfile_y.y"
                                        {current.forcecr     = FLAG_FALSE;}
#line 3591 "rcfile_y.c"
    break;

  case 141: /* user_option: NO STRIPCR  */
#line 366 "../rcfile_y.y"
                                        {current.stripcr     = FLAG_FALSE;}
#line 3597 "rcfile_y.c"
    break;

  case 142: /* user_option: NO PASS8BITS  */
#line 367 "../rcfile_y.y"
                                        {current.pass8bits   = FLAG_FALSE;}
#line 3603 "rcfile_y.c"
    break;

  case 143: /* user_option: NO DROPSTATUS  */
#line 368 "../rcfile_y.y"
                                        {current.dropstatus  = FLAG_FALSE;}
#line 3609 "rcfile_y.c"
    break;

  case 144: /* user_option: NO DROPDELIVERED  */
#line 369 "../rcfile_y.y"
                                        {current.dropdelivered = FLAG_FALSE;}
#line 3615 "rcfile_y.c"
    break;

  case 145: /* user_option: NO MIMEDECODE  */
#line 370 "../rcfile_y.y"
                                        {current.mimedecode  = FLAG_FALSE;}
#line 3621 "rcfile_y.c"
    break;

  case 146: /* user_option: NO IDLE  */
#line 371 "../rcfile_y.y"
                                        {current.idle        = FLAG_FALSE;}
#line 3627 "rcfile_y.c"
    break;

  case 147: /* user_option: NO FORCEIDLE  */
#line 372 "../rcfile_y.y"
                                        {current.forceidle   = FLAG_FALSE;}
#line 3633 "rcfile_y.c"
    break;

  case 148: /* user_option: NO SSL  */
#line 374 "../rcfile_y.y"
                                        {current.use_ssl     = FLAG_FALSE;}
#line 3639 "rcfile_y.c"
    break;

  case 149: /* user_option: NO SSLCERTCK  */
#line 375 "../rcfile_y.y"
                                        {current.sslcertck   = FLAG_FALSE;}
#line 3645 "rcfile_y.c"
    break;

  case 150: /* user_option: LIMIT NUMBER  */
#line 377 "../rcfile_y.y"
                                        {current.limit       = NUM_VALUE_IN((yyvsp[0].number));}
#line 3651 "rcfile_y.c"
    break;

  case 151: /* user_option: WARNINGS NUMBER  */
#line 378 "../rcfile_y.y"
                                        {current.warnings    = NUM_VALUE_IN((yyvsp[0].number));}
#line 3657 "rcfile_y.c"
    break;

  case 152: /* user_option: FETCHLIMIT NUMBER  */
#line 379 "../rcfile_y.y"
                                        {current.fetchlimit  = NUM_VALUE_IN((yyvsp[0].number));}
#line 3663 "rcfile_y.c"
    break;

  case 153: /* user_option: FETCHSIZELIMIT NUMBER  */
#line 380 "../rcfile_y.y"
                                        {current.fetchsizelimit = NUM_VALUE_IN((yyvsp[0].number));}
#line 3669 "rcfile_y.c"
    break;

  case 154: /* user_option: FASTUIDL NUMBER  */
#line 381 "../rcfile_y.y"
                                        {current.fastuidl    = NUM_VALUE_IN((yyvsp[0].number));}
#line 3675 "rcfile_y.c"
    break;

  case 155: /* user_option: BATCHLIMIT NUMBER  */
#line 382 "../rcfile_y.y"
                                        {current.batchlimit  = NUM_VALUE_IN((yyvsp[0].number));}
#line 3681 "rcfile_y.c"
    break;

  case 156: /* user_option: EXPUNGE NUMBER  */
#line 383 "../rcfile_y.y"
                                        {current.expunge     = NUM_VALUE_IN((yyvsp[0].number));}
#line 3687 "rcfile_y.c"
    break;

  case 157: /* user_option: PROPERTIES STRING  */
#line 385 "../rcfile_y.y"
                                        {current.properties  = (yyvsp[0].sval);}
#line 3693 "rcfile_y.c"
    break;


#line 3697 "rcfile_y.c"

        default: break;
      }
    if (yychar_backup != yychar)
      YY_LAC_DISCARD ("yychar change");
  }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yyesa, &yyes, &yyes_capacity, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        if (yychar != YYEMPTY)
          YY_LAC_ESTABLISH;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  /* If the stack popping above didn't lose the initial context for the
     current lookahead token, the shift below will for sure.  */
  YY_LAC_DISCARD ("error recovery");

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yyes != yyesa)
    YYSTACK_FREE (yyes);
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 387 "../rcfile_y.y"


static struct query *hosttail;	/* where to add new elements */

/** check that a configuration file is secure, returns PS_* status codes */
int prc_filecheck(const char *pathname,
		  const flag securecheck /** shortcuts permission, filetype and uid tests if false */)
{
    struct stat statbuf;

    errno = 0;

    /* special case useful for debugging purposes */
    if (strcmp("/dev/null", pathname) == 0)
	return(PS_SUCCESS);

    /* pass through the special name for stdin */
    if (strcmp("-", pathname) == 0)
	return(PS_SUCCESS);

    /* the run control file must have the same uid as the REAL uid of this 
       process, it must have permissions no greater than 600, and it must not 
       be a symbolic link.  We check these conditions here. */

    if (stat(pathname, &statbuf) < 0) {
	if (errno == ENOENT) 
	    return(PS_SUCCESS);
	else {
	    report(stderr, "lstat: %s: %s\n", pathname, strerror(errno));
	    return(PS_IOERR);
	}
    }

    if (!securecheck)	return PS_SUCCESS;

    if (!S_ISREG(statbuf.st_mode))
    {
	fprintf(stderr, GT_("File %s must be a regular file.\n"), pathname);
	return(PS_IOERR);
    }

    if (statbuf.st_mode & (S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH | S_IXOTH))
    {
	fprintf(stderr, GT_("File %s must have no more than -rwx------ (0700) permissions.\n"), 
		pathname);
	return(PS_IOERR);
    }

    if (statbuf.st_uid != geteuid())
    {
	fprintf(stderr, GT_("File %s must be owned by you.\n"), pathname);
	return(PS_IOERR);
    }
    return(PS_SUCCESS);
}

int prc_parse_file (const char *pathname, const flag securecheck)
/* digest the configuration into a linked list of host records */
{
    prc_errflag = 0;
    querylist = hosttail = (struct query *)NULL;

    errno = 0;

    /* Check that the file is secure */
    if ( (prc_errflag = prc_filecheck(pathname, securecheck)) != 0 )
	return(prc_errflag);

    /*
     * Croak if the configuration directory does not exist.
     * This probably means an NFS mount failed and we can't
     * see a configuration file that ought to be there.
     * Question: is this a portable check? It's not clear
     * that all implementations of lstat() will return ENOTDIR
     * rather than plain ENOENT in this case...
     */
    if (errno == ENOTDIR)
	return(PS_IOERR);
    else if (errno == ENOENT)
	return(PS_SUCCESS);

    /* Open the configuration file and feed it to the lexer. */
    if (strcmp(pathname, "-") == 0)
	yyin = stdin;
    else if ((yyin = fopen(pathname,"r")) == (FILE *)NULL) {
	report(stderr, "open: %s: %s\n", pathname, strerror(errno));
	return(PS_IOERR);
    }

    int parseerr = yyparse();		/* parse entire file */

    if (2 == parseerr) {
	report(stderr, GT_("%s: parsing rcfile %s: memory exhausted\n"), program_name, pathname);
	return PS_IOERR;
    }

    if (yyin != stdin)
       fclose(yyin);	/* not checking this should be safe, file mode was r */

    if (prc_errflag || parseerr)
	return PS_SYNTAX;

    return PS_SUCCESS;
}

static void reset_server(const char *name, int skip)
/* clear the entire global record and initialize it with a new name */
{
    trailer = FALSE;
    memset(&current,'\0',sizeof(current));
    current.smtp_socket = -1;
    current.server.pollname = xstrdup(name);
    current.server.skip = skip;
}


static void user_reset(void)
/* clear the global current record (user parameters) used by the parser */
{
    struct hostdata save;

    /*
     * Purpose of this code is to initialize the new server block, but
     * preserve whatever server name was previously set.  Also
     * preserve server options unless the command-line explicitly
     * overrides them.
     */
    save = current.server;

    memset(&current, '\0', sizeof(current));
    current.smtp_socket = -1;

    current.server = save;
}

/** append a host record to the host list */
struct query *hostalloc(struct query *init /** pointer to block containing
					       initial values */)
{
    struct query *node;

    /* allocate new node */
    node = (struct query *) xmalloc(sizeof(struct query));

    /* initialize it */
    if (init)
	memcpy(node, init, sizeof(struct query));
    else
    {
	memset(node, '\0', sizeof(struct query));
	node->smtp_socket = -1;
    }

    /* append to end of list */
    if (hosttail != (struct query *) 0)
	hosttail->next = node;	/* list contains at least one element */
    else
	querylist = node;	/* list is empty */
    hosttail = node;

    if (trailer)
	node->server.lead_server = leadentry;
    else
    {
	node->server.lead_server = NULL;
	leadentry = &node->server;
    }

    return(node);
}

static void record_current(void)
/* register current parameters and append to the host list */
{
    (void) hostalloc(&current);
    trailer = TRUE;
}

char *prependdir (const char *file, const char *dir)
/* if a filename is relative to dir, convert it to an absolute path */
{
    char *newfile;
    if (!file[0] ||			/* null path */
	file[0] == '/' ||		/* absolute path */
	strcmp(file, "-") == 0 ||	/* stdin/stdout */
	!dir[0])			/* we don't HAVE_GETCWD */
	return xstrdup (file);
    newfile = (char *)xmalloc (strlen (dir) + 1 + strlen (file) + 1);
    if (dir[strlen(dir) - 1] != '/')
	sprintf (newfile, "%s/%s", dir, file);
    else
	sprintf (newfile, "%s%s", dir, file);
    return newfile;
}

/* rcfile_y.y ends here */
