/* FavoritesTimeline.c generated by valac 0.36.4, the Vala compiler
 * generated from FavoritesTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "CbUserStream.h"
#include <json-glib/json-glib.h>
#include "rest/oauth-proxy.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTweet.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_FAVORITES_TIMELINE (favorites_timeline_get_type ())
#define FAVORITES_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FAVORITES_TIMELINE, FavoritesTimeline))
#define FAVORITES_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FAVORITES_TIMELINE, FavoritesTimelineClass))
#define IS_FAVORITES_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FAVORITES_TIMELINE))
#define IS_FAVORITES_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FAVORITES_TIMELINE))
#define FAVORITES_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FAVORITES_TIMELINE, FavoritesTimelineClass))

typedef struct _FavoritesTimeline FavoritesTimeline;
typedef struct _FavoritesTimelineClass FavoritesTimelineClass;
typedef struct _FavoritesTimelinePrivate FavoritesTimelinePrivate;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, CbBundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _FavoritesTimeline {
	DefaultTimeline parent_instance;
	FavoritesTimelinePrivate * priv;
};

struct _FavoritesTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer favorites_timeline_parent_class = NULL;
static CbMessageReceiverInterface * favorites_timeline_cb_message_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType favorites_timeline_get_type (void) G_GNUC_CONST;
enum  {
	FAVORITES_TIMELINE_DUMMY_PROPERTY,
	FAVORITES_TIMELINE_FUNCTION
};
FavoritesTimeline* favorites_timeline_new (gint id, Account* account);
FavoritesTimeline* favorites_timeline_construct (GType object_type, gint id, Account* account);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
static void favorites_timeline_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void _vala_JsonNode_free (JsonNode* self);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
static void favorites_timeline_real_on_leave (DefaultTimeline* base);
void default_timeline_on_leave (DefaultTimeline* self);
static gchar* favorites_timeline_real_get_title (DefaultTimeline* base);
static void favorites_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_favorites_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


FavoritesTimeline* favorites_timeline_construct (GType object_type, gint id, Account* account) {
	FavoritesTimeline * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	TweetListBox* _tmp2_;
	Account* _tmp3_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = id;
	self = (FavoritesTimeline*) default_timeline_construct (object_type, _tmp0_);
	_tmp1_ = account;
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account = _tmp1_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	return self;
}


FavoritesTimeline* favorites_timeline_new (gint id, Account* account) {
	return favorites_timeline_construct (TYPE_FAVORITES_TIMELINE, id, account);
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void favorites_timeline_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root) {
	FavoritesTimeline * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FAVORITES_TIMELINE, FavoritesTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_EVENT_FAVORITE) {
		JsonNode* tweet_obj = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonNode* _tmp3_;
		JsonNode* _tmp4_;
		gint64 tweet_id = 0LL;
		JsonNode* _tmp5_;
		JsonObject* _tmp6_;
		gint64 _tmp7_;
		JsonObject* source_obj = NULL;
		JsonNode* _tmp8_;
		JsonObject* _tmp9_;
		JsonObject* _tmp10_;
		JsonObject* _tmp11_;
		JsonObject* _tmp12_;
		gint64 _tmp13_;
		Account* _tmp14_;
		gint64 _tmp15_;
		CbTweet* existing_tweet = NULL;
		TweetListBox* _tmp16_;
		CbTweetModel* _tmp17_;
		gint64 _tmp18_;
		CbTweet* _tmp19_;
		CbTweet* _tmp20_;
		CbTweet* _tmp21_;
		CbTweet* tweet = NULL;
		CbTweet* _tmp25_;
		CbTweet* _tmp26_;
		JsonNode* _tmp27_;
		Account* _tmp28_;
		gint64 _tmp29_;
		GDateTime* _tmp30_;
		GDateTime* _tmp31_;
		CbTweet* _tmp32_;
		TweetListBox* _tmp33_;
		CbTweetModel* _tmp34_;
		CbTweet* _tmp35_;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_member (_tmp2_, "target_object");
		_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
		tweet_obj = _tmp4_;
		_tmp5_ = tweet_obj;
		_tmp6_ = json_node_get_object (_tmp5_);
		_tmp7_ = json_object_get_int_member (_tmp6_, "id");
		tweet_id = _tmp7_;
		_tmp8_ = root;
		_tmp9_ = json_node_get_object (_tmp8_);
		_tmp10_ = json_object_get_object_member (_tmp9_, "source");
		_tmp11_ = _json_object_ref0 (_tmp10_);
		source_obj = _tmp11_;
		_tmp12_ = source_obj;
		_tmp13_ = json_object_get_int_member (_tmp12_, "id");
		_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp15_ = _tmp14_->id;
		if (_tmp13_ != _tmp15_) {
			_json_object_unref0 (source_obj);
			__vala_JsonNode_free0 (tweet_obj);
			return;
		}
		_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
		_tmp17_ = _tmp16_->model;
		_tmp18_ = tweet_id;
		_tmp19_ = cb_tweet_model_get_for_id (_tmp17_, _tmp18_, 0);
		_tmp20_ = _g_object_ref0 (_tmp19_);
		existing_tweet = _tmp20_;
		_tmp21_ = existing_tweet;
		if (_tmp21_ != NULL) {
			TweetListBox* _tmp22_;
			CbTweetModel* _tmp23_;
			CbTweet* _tmp24_;
			_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
			_tmp23_ = _tmp22_->model;
			_tmp24_ = existing_tweet;
			cb_tweet_model_set_tweet_flag (_tmp23_, _tmp24_, CB_TWEET_STATE_FAVORITED);
			_g_object_unref0 (existing_tweet);
			_json_object_unref0 (source_obj);
			__vala_JsonNode_free0 (tweet_obj);
			return;
		}
		_tmp25_ = cb_tweet_new ();
		tweet = _tmp25_;
		_tmp26_ = tweet;
		_tmp27_ = tweet_obj;
		_tmp28_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp29_ = _tmp28_->id;
		_tmp30_ = g_date_time_new_now_local ();
		_tmp31_ = _tmp30_;
		cb_tweet_load_from_json (_tmp26_, _tmp27_, _tmp29_, _tmp31_);
		_g_date_time_unref0 (_tmp31_);
		_tmp32_ = tweet;
		cb_tweet_set_flag (_tmp32_, (guint) CB_TWEET_STATE_FAVORITED);
		_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
		_tmp34_ = _tmp33_->model;
		_tmp35_ = tweet;
		cb_tweet_model_add (_tmp34_, _tmp35_);
		_g_object_unref0 (tweet);
		_g_object_unref0 (existing_tweet);
		_json_object_unref0 (source_obj);
		__vala_JsonNode_free0 (tweet_obj);
	} else {
		CbStreamMessageType _tmp36_;
		_tmp36_ = type;
		if (_tmp36_ == CB_STREAM_MESSAGE_EVENT_UNFAVORITE) {
			gint64 id = 0LL;
			JsonNode* _tmp37_;
			JsonObject* _tmp38_;
			JsonObject* _tmp39_;
			gint64 _tmp40_;
			gint64 _tmp41_;
			_tmp37_ = root;
			_tmp38_ = json_node_get_object (_tmp37_);
			_tmp39_ = json_object_get_object_member (_tmp38_, "target_object");
			_tmp40_ = json_object_get_int_member (_tmp39_, "id");
			id = _tmp40_;
			_tmp41_ = id;
			default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp41_, FALSE);
		}
	}
}


static void favorites_timeline_real_on_leave (DefaultTimeline* base) {
	FavoritesTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FAVORITES_TIMELINE, FavoritesTimeline);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				TweetListBox* _tmp3_;
				CbTweetModel* _tmp4_;
				guint _tmp5_;
				CbTweet* tweet = NULL;
				TweetListBox* _tmp6_;
				CbTweetModel* _tmp7_;
				guint _tmp8_;
				GObject* _tmp9_;
				CbTweet* _tmp10_;
				gboolean _tmp11_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
				_tmp4_ = _tmp3_->model;
				_tmp5_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_list_model_get_type (), GListModel));
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
				_tmp7_ = _tmp6_->model;
				_tmp8_ = i;
				_tmp9_ = g_list_model_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_list_model_get_type (), GListModel), _tmp8_);
				tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CB_TYPE_TWEET, CbTweet);
				_tmp10_ = tweet;
				_tmp11_ = cb_tweet_is_flag_set (_tmp10_, (guint) CB_TWEET_STATE_FAVORITED);
				if (!_tmp11_) {
					TweetListBox* _tmp12_;
					CbTweetModel* _tmp13_;
					CbTweet* _tmp14_;
					guint _tmp15_;
					_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
					_tmp13_ = _tmp12_->model;
					_tmp14_ = tweet;
					cb_tweet_model_remove_tweet (_tmp13_, _tmp14_);
					_tmp15_ = i;
					i = _tmp15_ - 1;
				}
				_g_object_unref0 (tweet);
			}
		}
	}
	DEFAULT_TIMELINE_CLASS (favorites_timeline_parent_class)->on_leave (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
}


static gchar* favorites_timeline_real_get_title (DefaultTimeline* base) {
	FavoritesTimeline * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FAVORITES_TIMELINE, FavoritesTimeline);
	_tmp0_ = g_strdup (_ ("Favorites"));
	result = _tmp0_;
	return result;
}


static void favorites_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group) {
	FavoritesTimeline * self;
	GtkRadioButton* _tmp0_;
	BadgeRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FAVORITES_TIMELINE, FavoritesTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = badge_radio_button_new (_tmp0_, "corebird-favorite-symbolic", _ ("Favorites"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button = _tmp1_;
}


static const gchar* favorites_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	FavoritesTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FAVORITES_TIMELINE, FavoritesTimeline);
	result = "1.1/favorites/list.json";
	return result;
}


static void favorites_timeline_class_init (FavoritesTimelineClass * klass) {
	favorites_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->on_leave = (void (*) (DefaultTimeline *)) favorites_timeline_real_on_leave;
	((DefaultTimelineClass *) klass)->get_title = (gchar* (*) (DefaultTimeline *)) favorites_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->create_radio_button = (void (*) (DefaultTimeline *, GtkRadioButton*)) favorites_timeline_real_create_radio_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = favorites_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_favorites_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FAVORITES_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void favorites_timeline_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	favorites_timeline_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) favorites_timeline_real_stream_message_received;
}


static void favorites_timeline_instance_init (FavoritesTimeline * self) {
}


GType favorites_timeline_get_type (void) {
	static volatile gsize favorites_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&favorites_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FavoritesTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) favorites_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FavoritesTimeline), 0, (GInstanceInitFunc) favorites_timeline_instance_init, NULL };
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) favorites_timeline_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType favorites_timeline_type_id;
		favorites_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "FavoritesTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (favorites_timeline_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&favorites_timeline_type_id__volatile, favorites_timeline_type_id);
	}
	return favorites_timeline_type_id__volatile;
}


static void _vala_favorites_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FavoritesTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FAVORITES_TIMELINE, FavoritesTimeline);
	switch (property_id) {
		case FAVORITES_TIMELINE_FUNCTION:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



