/* DMListEntry.c generated by valac 0.34.6, the Vala compiler
 * generated from DMListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>


#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;

#define TYPE_DM_LIST_ENTRY (dm_list_entry_get_type ())
#define DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_LIST_ENTRY, DMListEntry))
#define DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_LIST_ENTRY, DMListEntryClass))
#define IS_DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_LIST_ENTRY))
#define IS_DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_LIST_ENTRY))
#define DM_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_LIST_ENTRY, DMListEntryClass))

typedef struct _DMListEntry DMListEntry;
typedef struct _DMListEntryClass DMListEntryClass;
typedef struct _DMListEntryPrivate DMListEntryPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_PAGE (page_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _DMListEntry {
	GtkListBoxRow parent_instance;
	DMListEntryPrivate * priv;
	gint64 timestamp;
	gint64 id;
	gint64 user_id;
	MainWindow* main_window;
};

struct _DMListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _DMListEntryPrivate {
	AvatarWidget* avatar_image;
	GtkLabel* text_label;
	GtkLabel* screen_name_label;
	TextButton* name_button;
	GtkLabel* time_delta_label;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;


static gpointer dm_list_entry_parent_class = NULL;
static ITwitterItemIface* dm_list_entry_itwitter_item_parent_iface = NULL;

GType itwitter_item_get_type (void) G_GNUC_CONST;
GType dm_list_entry_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
#define DM_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_LIST_ENTRY, DMListEntryPrivate))
enum  {
	DM_LIST_ENTRY_DUMMY_PROPERTY,
	DM_LIST_ENTRY_TEXT,
	DM_LIST_ENTRY_SCREEN_NAME,
	DM_LIST_ENTRY_NAME,
	DM_LIST_ENTRY_AVATAR,
	DM_LIST_ENTRY_SEEN,
	DM_LIST_ENTRY_SORT_FACTOR
};
DMListEntry* dm_list_entry_new (void);
DMListEntry* dm_list_entry_construct (GType object_type);
static void __lambda93_ (DMListEntry* self);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
GType main_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self);
void dm_list_entry_load_avatar (DMListEntry* self, const gchar* avatar_url);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_);
static gint dm_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
void dm_list_entry_set_text (DMListEntry* self, const gchar* value);
void dm_list_entry_set_screen_name (DMListEntry* self, const gchar* value);
void dm_list_entry_set_name (DMListEntry* self, const gchar* value);
void dm_list_entry_set_avatar (DMListEntry* self, cairo_surface_t* value);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
gboolean dm_list_entry_get_seen (DMListEntry* self);
void dm_list_entry_set_seen (DMListEntry* self, gboolean value);
static void dm_list_entry_finalize (GObject* obj);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
static void _vala_dm_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dm_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void __lambda93_ (DMListEntry* self) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	MainWindow* _tmp7_ = NULL;
	MainWidget* _tmp8_ = NULL;
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = self->user_id;
	bundle_put_int64 (bundle, "user_id", _tmp1_);
	_tmp2_ = self->priv->screen_name_label;
	_tmp3_ = gtk_label_get_label (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
	_tmp6_ = _tmp5_;
	bundle_put_string (bundle, "screen_name", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->main_window;
	_tmp8_ = _tmp7_->main_widget;
	main_widget_switch_page (_tmp8_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda93_ ((DMListEntry*) self);
}


DMListEntry* dm_list_entry_construct (GType object_type) {
	DMListEntry * self = NULL;
	TextButton* _tmp0_ = NULL;
	self = (DMListEntry*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->name_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) ___lambda93__gtk_button_clicked, self, 0);
	return self;
}


DMListEntry* dm_list_entry_new (void) {
	return dm_list_entry_construct (TYPE_DM_LIST_ENTRY);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch74_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch74_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally74;
	__catch74_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally74:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void dm_list_entry_load_avatar (DMListEntry* self, const gchar* avatar_url) {
	gchar* url = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Twitter* _tmp5_ = NULL;
	Twitter* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	const gchar* _tmp8_ = NULL;
	AvatarWidget* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = avatar_url;
	_tmp1_ = g_strdup (_tmp0_);
	url = _tmp1_;
	_tmp2_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp2_ == 2) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = url;
		_tmp4_ = string_replace (_tmp3_, "_normal", "_bigger");
		_g_free0 (url);
		url = _tmp4_;
	}
	_tmp5_ = twitter_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = self->user_id;
	_tmp8_ = url;
	_tmp9_ = self->priv->avatar_image;
	_tmp10_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	twitter_get_avatar (_tmp6_, _tmp7_, _tmp8_, _tmp9_, 48 * _tmp10_, FALSE, NULL, NULL);
	_g_object_unref0 (_tmp6_);
	_g_free0 (url);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static gint dm_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	DMListEntry * self;
	gint result = 0;
	GDateTime* cur_time = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* then = NULL;
	gint64 _tmp4_ = 0LL;
	GDateTime* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GDateTime* _tmp10_ = NULL;
	GTimeSpan _tmp11_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_LIST_ENTRY, DMListEntry);
	_tmp0_ = now;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_ = NULL;
		_tmp1_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp1_;
	} else {
		GDateTime* _tmp2_ = NULL;
		GDateTime* _tmp3_ = NULL;
		_tmp2_ = now;
		_tmp3_ = _g_date_time_ref0 (_tmp2_);
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp3_;
	}
	_tmp4_ = self->timestamp;
	_tmp5_ = g_date_time_new_from_unix_local (_tmp4_);
	then = _tmp5_;
	_tmp6_ = self->priv->time_delta_label;
	_tmp7_ = cur_time;
	_tmp8_ = utils_get_time_delta (then, _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = cur_time;
	_tmp11_ = g_date_time_difference (_tmp10_, then);
	result = (gint) ((_tmp11_ / 1000.0) / 1000.0);
	_g_date_time_unref0 (then);
	_g_date_time_unref0 (cur_time);
	return result;
}


void dm_list_entry_set_text (DMListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->text_label;
	_tmp1_ = value;
	gtk_label_set_label (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "text");
}


void dm_list_entry_set_screen_name (DMListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->screen_name_label;
	_tmp1_ = value;
	_tmp2_ = g_strconcat ("@", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify ((GObject *) self, "screen-name");
}


void dm_list_entry_set_name (DMListEntry* self, const gchar* value) {
	TextButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->name_button;
	_tmp1_ = value;
	gtk_button_set_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_button_get_type (), GtkButton), _tmp1_);
	g_object_notify ((GObject *) self, "name");
}


void dm_list_entry_set_avatar (DMListEntry* self, cairo_surface_t* value) {
	AvatarWidget* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = value;
	avatar_widget_set_surface (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "avatar");
}


gboolean dm_list_entry_get_seen (DMListEntry* self) {
	gboolean result;
	g_return_val_if_fail (IS_DM_LIST_ENTRY (self), FALSE);
	result = TRUE;
	return result;
}


void dm_list_entry_set_seen (DMListEntry* self, gboolean value) {
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	g_object_notify ((GObject *) self, "seen");
}


static gint64 dm_list_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	DMListEntry* self;
	gint64 _tmp0_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_LIST_ENTRY, DMListEntry);
	_tmp0_ = self->timestamp;
	result = _tmp0_;
	return result;
}


static void dm_list_entry_class_init (DMListEntryClass * klass) {
	gint DMListEntry_private_offset;
	dm_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMListEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_SCREEN_NAME, g_param_spec_string ("screen-name", "screen-name", "screen-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_AVATAR, g_param_spec_pointer ("avatar", "avatar", "avatar", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_SEEN, g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	DMListEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/dm-list-entry.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, DMListEntry_private_offset + G_STRUCT_OFFSET (DMListEntryPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, DMListEntry_private_offset + G_STRUCT_OFFSET (DMListEntryPrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, DMListEntry_private_offset + G_STRUCT_OFFSET (DMListEntryPrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, DMListEntry_private_offset + G_STRUCT_OFFSET (DMListEntryPrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_delta_label", FALSE, DMListEntry_private_offset + G_STRUCT_OFFSET (DMListEntryPrivate, time_delta_label));
}


static void dm_list_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	dm_list_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) dm_list_entry_real_update_time_delta;
	iface->get_sort_factor = dm_list_entry_real_get_sort_factor;
}


static void dm_list_entry_instance_init (DMListEntry * self) {
	self->priv = DM_LIST_ENTRY_GET_PRIVATE (self);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_TEXT_BUTTON);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dm_list_entry_finalize (GObject* obj) {
	DMListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_LIST_ENTRY, DMListEntry);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->time_delta_label);
	G_OBJECT_CLASS (dm_list_entry_parent_class)->finalize (obj);
}


GType dm_list_entry_get_type (void) {
	static volatile gsize dm_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&dm_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMListEntry), 0, (GInstanceInitFunc) dm_list_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) dm_list_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_list_entry_type_id;
		dm_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "DMListEntry", &g_define_type_info, 0);
		g_type_add_interface_static (dm_list_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&dm_list_entry_type_id__volatile, dm_list_entry_type_id);
	}
	return dm_list_entry_type_id__volatile;
}


static void _vala_dm_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_LIST_ENTRY, DMListEntry);
	switch (property_id) {
		case DM_LIST_ENTRY_SEEN:
		g_value_set_boolean (value, dm_list_entry_get_seen (self));
		break;
		case DM_LIST_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_LIST_ENTRY, DMListEntry);
	switch (property_id) {
		case DM_LIST_ENTRY_TEXT:
		dm_list_entry_set_text (self, g_value_get_string (value));
		break;
		case DM_LIST_ENTRY_SCREEN_NAME:
		dm_list_entry_set_screen_name (self, g_value_get_string (value));
		break;
		case DM_LIST_ENTRY_NAME:
		dm_list_entry_set_name (self, g_value_get_string (value));
		break;
		case DM_LIST_ENTRY_AVATAR:
		dm_list_entry_set_avatar (self, g_value_get_pointer (value));
		break;
		case DM_LIST_ENTRY_SEEN:
		dm_list_entry_set_seen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



