; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='default<O2>' -S | FileCheck %s

; Same test as coro-retcon.ll, but with opaque pointers enabled.

define ptr @f(ptr %buffer, i32 %n) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    tail call void @print(i32 [[N]])
; CHECK-NEXT:    ret ptr @f.resume.0
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 8, i32 4, ptr %buffer, ptr @prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:                                             ; preds = %resume, %entry
  %n.val = phi i32 [ %n, %entry ], [ %inc, %resume ]
  call void @print(i32 %n.val)
  %unwind0 = call i1 (...) @llvm.coro.suspend.retcon.i1()
  br i1 %unwind0, label %cleanup, label %resume

resume:                                           ; preds = %loop
  %inc = add i32 %n.val, 1
  br label %loop

cleanup:                                          ; preds = %loop
  %0 = call i1 @llvm.coro.end(ptr %hdl, i1 false, token none)
  unreachable
}

define i32 @main() {
; CHECK-LABEL: @main(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @print(i32 4)
; CHECK-NEXT:    tail call void @llvm.experimental.noalias.scope.decl(metadata [[META0:![0-9]+]])
; CHECK-NEXT:    tail call void @print(i32 5), !noalias [[META0]]
; CHECK-NEXT:    tail call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
; CHECK-NEXT:    tail call void @print(i32 6), !noalias [[META3]]
; CHECK-NEXT:    ret i32 0
;
entry:
  %0 = alloca [8 x i8], align 4
  %prepare = call ptr @llvm.coro.prepare.retcon(ptr @f)
  %cont0 = call ptr %prepare(ptr %0, i32 4)
  %cont1 = call ptr %cont0(ptr %0, i1 zeroext false)
  %cont2 = call ptr %cont1(ptr %0, i1 zeroext false)
  %1 = call ptr %cont2(ptr %0, i1 zeroext true)
  ret i32 0
}

define hidden { ptr, ptr } @g(ptr %buffer, ptr %ptr) {
; CHECK-LABEL: @g(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call ptr @allocate(i32 8)
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, ptr } { ptr @g.resume.0, ptr poison }, ptr [[PTR]], 1
; CHECK-NEXT:    ret { ptr, ptr } [[TMP1]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 8, i32 4, ptr %buffer, ptr @g_prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:                                             ; preds = %resume, %entry
  %unwind0 = call i1 (...) @llvm.coro.suspend.retcon.i1(ptr %ptr)
  br i1 %unwind0, label %cleanup, label %resume

resume:                                           ; preds = %loop
  br label %loop

cleanup:                                          ; preds = %loop
  %0 = call i1 @llvm.coro.end(ptr %hdl, i1 false, token none)
  unreachable
}

declare token @llvm.coro.id.retcon(i32, i32, ptr, ptr, ptr, ptr)
declare ptr @llvm.coro.begin(token, ptr)
declare i1 @llvm.coro.suspend.retcon.i1(...)
declare i1 @llvm.coro.end(ptr, i1, token)
declare ptr @llvm.coro.prepare.retcon(ptr)

declare ptr @prototype(ptr, i1 zeroext)
declare {ptr,ptr} @g_prototype(ptr, i1 zeroext)

declare noalias ptr @allocate(i32 %size)
declare void @deallocate(ptr %ptr)

declare void @print(i32)
