; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -mattr=+vsx -mcpu=pwr8 < %s |  \
; RUN:   FileCheck %s --implicit-check-not lxvd2x --implicit-check-not lfs
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -mattr=-altivec -mcpu=pwr8 -mattr=-vsx < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-NVSXALT --implicit-check-not xxlxor \
; RUN:                                             --implicit-check-not vxor

define signext i32 @t1(float %x) local_unnamed_addr #0 {
; CHECK-LABEL: t1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor 0, 0, 0
; CHECK-NEXT:    li 3, 11
; CHECK-NEXT:    li 4, 43
; CHECK-NEXT:    fcmpu 0, 1, 0
; CHECK-NEXT:    iselgt 3, 4, 3
; CHECK-NEXT:    blr
;
; CHECK-NVSXALT-LABEL: t1:
; CHECK-NVSXALT:       # %bb.0: # %entry
; CHECK-NVSXALT-NEXT:    addis 3, 2, .LCPI0_0@toc@ha
; CHECK-NVSXALT-NEXT:    li 4, 43
; CHECK-NVSXALT-NEXT:    lfs 0, .LCPI0_0@toc@l(3)
; CHECK-NVSXALT-NEXT:    li 3, 11
; CHECK-NVSXALT-NEXT:    fcmpu 0, 1, 0
; CHECK-NVSXALT-NEXT:    iselgt 3, 4, 3
; CHECK-NVSXALT-NEXT:    blr
entry:
  %cmp = fcmp ogt float %x, 0.000000e+00
  %tmp = select i1 %cmp, i32 43, i32 11
  ret i32 %tmp

}

define signext i32 @t2(double %x) local_unnamed_addr #0 {
; CHECK-LABEL: t2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor 0, 0, 0
; CHECK-NEXT:    li 3, 11
; CHECK-NEXT:    li 4, 43
; CHECK-NEXT:    xscmpudp 0, 1, 0
; CHECK-NEXT:    iselgt 3, 4, 3
; CHECK-NEXT:    blr
;
; CHECK-NVSXALT-LABEL: t2:
; CHECK-NVSXALT:       # %bb.0: # %entry
; CHECK-NVSXALT-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; CHECK-NVSXALT-NEXT:    li 4, 43
; CHECK-NVSXALT-NEXT:    lfs 0, .LCPI1_0@toc@l(3)
; CHECK-NVSXALT-NEXT:    li 3, 11
; CHECK-NVSXALT-NEXT:    fcmpu 0, 1, 0
; CHECK-NVSXALT-NEXT:    iselgt 3, 4, 3
; CHECK-NVSXALT-NEXT:    blr
entry:
  %cmp = fcmp ogt double %x, 0.000000e+00
  %tmp = select i1 %cmp, i32 43, i32 11
  ret i32 %tmp

}

define signext i32 @t3(ppc_fp128 %x) local_unnamed_addr #0 {
; CHECK-LABEL: t3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor 0, 0, 0
; CHECK-NEXT:    li 3, 11
; CHECK-NEXT:    li 4, 43
; CHECK-NEXT:    fcmpu 0, 2, 0
; CHECK-NEXT:    fcmpu 1, 1, 0
; CHECK-NEXT:    crand 20, 6, 1
; CHECK-NEXT:    cror 20, 5, 20
; CHECK-NEXT:    isel 3, 4, 3, 20
; CHECK-NEXT:    blr
;
; CHECK-NVSXALT-LABEL: t3:
; CHECK-NVSXALT:       # %bb.0: # %entry
; CHECK-NVSXALT-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; CHECK-NVSXALT-NEXT:    li 4, 43
; CHECK-NVSXALT-NEXT:    lfs 0, .LCPI2_0@toc@l(3)
; CHECK-NVSXALT-NEXT:    li 3, 11
; CHECK-NVSXALT-NEXT:    fcmpu 0, 2, 0
; CHECK-NVSXALT-NEXT:    fcmpu 1, 1, 0
; CHECK-NVSXALT-NEXT:    crand 20, 6, 1
; CHECK-NVSXALT-NEXT:    cror 20, 5, 20
; CHECK-NVSXALT-NEXT:    isel 3, 4, 3, 20
; CHECK-NVSXALT-NEXT:    blr
entry:
  %cmp = fcmp ogt ppc_fp128 %x, 0xM00000000000000000000000000000000
  %tmp = select i1 %cmp, i32 43, i32 11
  ret i32 %tmp

}

define <2 x double> @t4() local_unnamed_addr #0 {
; CHECK-LABEL: t4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xxlxor 34, 34, 34
; CHECK-NEXT:    blr
;
; CHECK-NVSXALT-LABEL: t4:
; CHECK-NVSXALT:       # %bb.0:
; CHECK-NVSXALT-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; CHECK-NVSXALT-NEXT:    lfs 1, .LCPI3_0@toc@l(3)
; CHECK-NVSXALT-NEXT:    fmr 2, 1
; CHECK-NVSXALT-NEXT:    blr
  ret <2 x double> zeroinitializer
}

define <2 x i64> @t5() local_unnamed_addr #0 {
; CHECK-LABEL: t5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xxlxor 34, 34, 34
; CHECK-NEXT:    blr
;
; CHECK-NVSXALT-LABEL: t5:
; CHECK-NVSXALT:       # %bb.0:
; CHECK-NVSXALT-NEXT:    li 3, 0
; CHECK-NVSXALT-NEXT:    li 4, 0
; CHECK-NVSXALT-NEXT:    blr
  ret <2 x i64> zeroinitializer
}
