; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lasx < %s | FileCheck %s

;; TODO For these special shuffle mask, we can lower it to xvbsll + xvbsrl + xvor.

define <32 x i8> @byte_rotate_v32_i8_1(<32 x i8> %a, <32 x i8> %b) {
; CHECK-LABEL: byte_rotate_v32_i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr0, $xr0, 1
; CHECK-NEXT:    xvbsll.v $xr1, $xr1, 15
; CHECK-NEXT:    xvor.v $xr0, $xr1, $xr0
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> %b, <32 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 32, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 48>
  ret <32 x i8> %shuffle
}

define <32 x i8> @byte_rotate_v32_i8_2(<32 x i8> %a, <32 x i8> %b) {
; CHECK-LABEL: byte_rotate_v32_i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr1, $xr1, 13
; CHECK-NEXT:    xvbsll.v $xr0, $xr0, 3
; CHECK-NEXT:    xvor.v $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> %b, <32 x i32> <i32 45, i32 46, i32 47, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 61, i32 62, i32 63, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28>
  ret <32 x i8> %shuffle
}

define <32 x i8> @byte_rotate_v32_i8_3(<32 x i8> %a) {
; CHECK-LABEL: byte_rotate_v32_i8_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr1, $xr0, 1
; CHECK-NEXT:    xvbsll.v $xr0, $xr0, 15
; CHECK-NEXT:    xvor.v $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> poison, <32 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16>
  ret <32 x i8> %shuffle
}


define <16 x i16> @byte_rotate_v16i16_1(<16 x i16> %a, <16 x i16> %b) nounwind {
; CHECK-LABEL: byte_rotate_v16i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr0, $xr0, 6
; CHECK-NEXT:    xvbsll.v $xr1, $xr1, 10
; CHECK-NEXT:    xvor.v $xr0, $xr1, $xr0
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> %b, <16 x i32> <i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 11, i32 12, i32 13, i32 14, i32 15, i32 24, i32 25, i32 26>
  ret <16 x i16> %shuffle
}

define <16 x i16> @byte_rotate_v16i16_2(<16 x i16> %a, <16 x i16> %b) nounwind {
; CHECK-LABEL: byte_rotate_v16i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr1, $xr1, 10
; CHECK-NEXT:    xvbsll.v $xr0, $xr0, 6
; CHECK-NEXT:    xvor.v $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> %b, <16 x i32> <i32 21, i32 22, i32 23, i32 0, i32 1, i32 2,i32 3, i32 4, i32 29, i32 30, i32 31, i32 8, i32 9, i32 10, i32 11, i32 12>
  ret <16 x i16> %shuffle
}

define <16 x i16> @byte_rotate_v16i16_3(<16 x i16> %a) nounwind {
; CHECK-LABEL: byte_rotate_v16i16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr1, $xr0, 6
; CHECK-NEXT:    xvbsll.v $xr0, $xr0, 10
; CHECK-NEXT:    xvor.v $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> poison, <16 x i32> <i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10>
  ret <16 x i16> %shuffle
}

define <8 x i32> @byte_rotate_v8i32_1(<8 x i32> %a, <8 x i32> %b) nounwind {
; CHECK-LABEL: byte_rotate_v8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr0, $xr0, 4
; CHECK-NEXT:    xvbsll.v $xr1, $xr1, 12
; CHECK-NEXT:    xvor.v $xr0, $xr1, $xr0
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 2, i32 3, i32 8, i32 5, i32 6, i32 7, i32 12>
  ret <8 x i32> %shuffle
}

define <8 x i32> @byte_rotate_v8i32_2(<8 x i32> %a, <8 x i32> %b) nounwind {
; CHECK-LABEL: byte_rotate_v8i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr1, $xr1, 12
; CHECK-NEXT:    xvbsll.v $xr0, $xr0, 4
; CHECK-NEXT:    xvor.v $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 11, i32 0, i32 1, i32 2, i32 15, i32 4, i32 5, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @byte_rotate_v8i32_3(<8 x i32> %a) nounwind {
; CHECK-LABEL: byte_rotate_v8i32_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvshuf4i.w $xr0, $xr0, 57
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> poison, <8 x i32> <i32 1, i32 2, i32 3, i32 0, i32 5, i32 6, i32 7, i32 4>
  ret <8 x i32> %shuffle
}

define <4 x i64> @byte_rotate_v4i64_1(<4 x i64> %a, <4 x i64> %b) nounwind {
; CHECK-LABEL: byte_rotate_v4i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr0, $xr0, 8
; CHECK-NEXT:    xvbsll.v $xr1, $xr1, 8
; CHECK-NEXT:    xvor.v $xr0, $xr1, $xr0
; CHECK-NEXT:    ret
    %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 4, i32 3, i32 6>
    ret <4 x i64> %shuffle
}

define <4 x i64> @byte_rotate_v4i64_2(<4 x i64> %a, <4 x i64> %b) nounwind {
; CHECK-LABEL: byte_rotate_v4i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr1, $xr1, 8
; CHECK-NEXT:    xvbsll.v $xr0, $xr0, 8
; CHECK-NEXT:    xvor.v $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
    %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 5, i32 0, i32 7, i32 2>
    ret <4 x i64> %shuffle
}

define <4 x i64> @byte_rotate_v4i64_3(<4 x i64> %a) nounwind {
; CHECK-LABEL: byte_rotate_v4i64_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvbsrl.v $xr1, $xr0, 8
; CHECK-NEXT:    xvbsll.v $xr0, $xr0, 8
; CHECK-NEXT:    xvor.v $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
    %shuffle = shufflevector <4 x i64> %a, <4 x i64> poison, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
    ret <4 x i64> %shuffle
}
