; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
target datalayout = "e-i64:64-f80:128-n8:16:32:64-S128"
; RUN: opt < %s -passes=alignment-from-assumptions -S | FileCheck %s

define i32 @foo(ptr nocapture %a) {
; CHECK-LABEL: define i32 @foo
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i32 32) ]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 32
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i32 32)]
  %0 = load i32, ptr %a, align 4
  ret i32 %0
}

define i32 @foo2(ptr nocapture %a) {
; CHECK-LABEL: define i32 @foo2
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i32 32, i32 24) ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 -2
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 16
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i32 32, i32 24)]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 -2
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

define i32 @foo2a(ptr nocapture %a) {
; CHECK-LABEL: define i32 @foo2a
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i32 32, i32 28) ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 32
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i32 32, i32 28)]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 1
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

; TODO: this can be 8-bytes aligned
define i32 @foo2b(ptr nocapture %a) {
; CHECK-LABEL: define i32 @foo2b
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i32 32, i32 28) ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 -1
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i32 32, i32 28)]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 -1
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

define i32 @goo(ptr nocapture %a) {
; CHECK-LABEL: define i32 @goo
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i32 32, i32 0) ]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 32
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i32 32, i32 0)]
  %0 = load i32, ptr %a, align 4
  ret i32 %0
}

define i32 @hoo(ptr nocapture %a) {
; CHECK-LABEL: define i32 @hoo
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i64 32, i32 0) ]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[R_06:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 32
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[TMP0]], [[R_06]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add i64 [[INDVARS_IV]], 8
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP1]], 2048
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    [[ADD_LCSSA:%.*]] = phi i32 [ [[ADD]], [[FOR_BODY]] ]
; CHECK-NEXT:    ret i32 [[ADD_LCSSA]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i64 32, i32 0)]
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %r.06 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %0, %r.06
  %indvars.iv.next = add i64 %indvars.iv, 8
  %1 = trunc i64 %indvars.iv.next to i32
  %cmp = icmp slt i32 %1, 2048
  br i1 %cmp, label %for.body, label %for.end

for.end:                                          ; preds = %for.body
  %add.lcssa = phi i32 [ %add, %for.body ]
  ret i32 %add.lcssa
}

; test D66575
; def hoo2(a, id, num):
;   for i0 in range(id*64, 4096, num*64):
;     for i1 in range(0, 4096, 32):
;       for i2 in range(0, 4096, 32):
;         load(a, i0+i1+i2+32)
define void @hoo2(ptr nocapture %a, i64 %id, i64 %num) {
; CHECK-LABEL: define void @hoo2
; CHECK-SAME: (ptr captures(none) [[A:%.*]], i64 [[ID:%.*]], i64 [[NUM:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i8 32, i64 0) ]
; CHECK-NEXT:    [[ID_MUL:%.*]] = shl nsw i64 [[ID]], 6
; CHECK-NEXT:    [[NUM_MUL:%.*]] = shl nsw i64 [[NUM]], 6
; CHECK-NEXT:    br label [[FOR0_BODY:%.*]]
; CHECK:       for0.body:
; CHECK-NEXT:    [[I0:%.*]] = phi i64 [ [[ID_MUL]], [[ENTRY:%.*]] ], [ [[I0_NEXT:%.*]], [[FOR0_END:%.*]] ]
; CHECK-NEXT:    br label [[FOR1_BODY:%.*]]
; CHECK:       for1.body:
; CHECK-NEXT:    [[I1:%.*]] = phi i64 [ 0, [[FOR0_BODY]] ], [ [[I1_NEXT:%.*]], [[FOR1_END:%.*]] ]
; CHECK-NEXT:    br label [[FOR2_BODY:%.*]]
; CHECK:       for2.body:
; CHECK-NEXT:    [[I2:%.*]] = phi i64 [ 0, [[FOR1_BODY]] ], [ [[I2_NEXT:%.*]], [[FOR2_BODY]] ]
; CHECK-NEXT:    [[T1:%.*]] = add nuw nsw i64 [[I0]], [[I1]]
; CHECK-NEXT:    [[T2:%.*]] = add nuw nsw i64 [[T1]], [[I2]]
; CHECK-NEXT:    [[T3:%.*]] = add nuw nsw i64 [[T2]], 32
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[T3]]
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[ARRAYIDX]], align 32
; CHECK-NEXT:    [[I2_NEXT]] = add nuw nsw i64 [[I2]], 32
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ult i64 [[I2_NEXT]], 4096
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR2_BODY]], label [[FOR1_END]]
; CHECK:       for1.end:
; CHECK-NEXT:    [[I1_NEXT]] = add nuw nsw i64 [[I1]], 32
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i64 [[I1_NEXT]], 4096
; CHECK-NEXT:    br i1 [[CMP1]], label [[FOR1_BODY]], label [[FOR0_END]]
; CHECK:       for0.end:
; CHECK-NEXT:    [[I0_NEXT]] = add nuw nsw i64 [[I0]], [[NUM_MUL]]
; CHECK-NEXT:    [[CMP0:%.*]] = icmp ult i64 [[I0_NEXT]], 4096
; CHECK-NEXT:    br i1 [[CMP0]], label [[FOR0_BODY]], label [[RETURN:%.*]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i8 32, i64 0)]
  %id.mul = shl nsw i64 %id, 6
  %num.mul = shl nsw i64 %num, 6
  br label %for0.body

for0.body:
  %i0 = phi i64 [ %id.mul, %entry ], [ %i0.next, %for0.end ]
  br label %for1.body

for1.body:
  %i1 = phi i64 [ 0, %for0.body ], [ %i1.next, %for1.end ]
  br label %for2.body

for2.body:
  %i2 = phi i64 [ 0, %for1.body ], [ %i2.next, %for2.body ]

  %t1 = add nuw nsw i64 %i0, %i1
  %t2 = add nuw nsw i64 %t1, %i2
  %t3 = add nuw nsw i64 %t2, 32
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %t3
  %x = load i32, ptr %arrayidx, align 4

  %i2.next = add nuw nsw i64 %i2, 32
  %cmp2 = icmp ult i64 %i2.next, 4096
  br i1 %cmp2, label %for2.body, label %for1.end

for1.end:
  %i1.next = add nuw nsw i64 %i1, 32
  %cmp1 = icmp ult i64 %i1.next, 4096
  br i1 %cmp1, label %for1.body, label %for0.end

for0.end:
  %i0.next = add nuw nsw i64 %i0, %num.mul
  %cmp0 = icmp ult i64 %i0.next, 4096
  br i1 %cmp0, label %for0.body, label %return

return:
  ret void
}

define i32 @joo(ptr nocapture %a) {
; CHECK-LABEL: define i32 @joo
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i8 32, i8 0) ]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 4, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[R_06:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 16
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[TMP0]], [[R_06]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add i64 [[INDVARS_IV]], 8
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP1]], 2048
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    [[ADD_LCSSA:%.*]] = phi i32 [ [[ADD]], [[FOR_BODY]] ]
; CHECK-NEXT:    ret i32 [[ADD_LCSSA]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i8 32, i8 0)]
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 4, %entry ], [ %indvars.iv.next, %for.body ]
  %r.06 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %0, %r.06
  %indvars.iv.next = add i64 %indvars.iv, 8
  %1 = trunc i64 %indvars.iv.next to i32
  %cmp = icmp slt i32 %1, 2048
  br i1 %cmp, label %for.body, label %for.end

for.end:                                          ; preds = %for.body
  %add.lcssa = phi i32 [ %add, %for.body ]
  ret i32 %add.lcssa
}

define i32 @koo(ptr nocapture %a) {
; CHECK-LABEL: define i32 @koo
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[R_06:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i8 32, i8 0) ]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 16
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[TMP0]], [[R_06]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add i64 [[INDVARS_IV]], 4
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP1]], 2048
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    [[ADD_LCSSA:%.*]] = phi i32 [ [[ADD]], [[FOR_BODY]] ]
; CHECK-NEXT:    ret i32 [[ADD_LCSSA]]
;
entry:
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %r.06 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %indvars.iv
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i8 32, i8 0)]
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %0, %r.06
  %indvars.iv.next = add i64 %indvars.iv, 4
  %1 = trunc i64 %indvars.iv.next to i32
  %cmp = icmp slt i32 %1, 2048
  br i1 %cmp, label %for.body, label %for.end

for.end:                                          ; preds = %for.body
  %add.lcssa = phi i32 [ %add, %for.body ]
  ret i32 %add.lcssa
}

define i32 @koo2(ptr nocapture %a) {
; CHECK-LABEL: define i32 @koo2
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i128 32, i128 0) ]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ -4, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[R_06:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 16
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[TMP0]], [[R_06]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add i64 [[INDVARS_IV]], 4
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP1]], 2048
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    [[ADD_LCSSA:%.*]] = phi i32 [ [[ADD]], [[FOR_BODY]] ]
; CHECK-NEXT:    ret i32 [[ADD_LCSSA]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i128 32, i128 0)]
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ -4, %entry ], [ %indvars.iv.next, %for.body ]
  %r.06 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %0, %r.06
  %indvars.iv.next = add i64 %indvars.iv, 4
  %1 = trunc i64 %indvars.iv.next to i32
  %cmp = icmp slt i32 %1, 2048
  br i1 %cmp, label %for.body, label %for.end

for.end:                                          ; preds = %for.body
  %add.lcssa = phi i32 [ %add, %for.body ]
  ret i32 %add.lcssa
}

define i32 @moo(ptr nocapture %a) {
; CHECK-LABEL: define i32 @moo
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i16 32) ]
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr align 32 [[A]], i8 0, i64 64, i1 false)
; CHECK-NEXT:    ret i32 0
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i16 32)]
  tail call void @llvm.memset.p0.i64(ptr align 4 %a, i8 0, i64 64, i1 false)
  ret i32 0
}

define i32 @moo2(ptr nocapture %a, ptr nocapture %b) {
; CHECK-LABEL: define i32 @moo2
; CHECK-SAME: (ptr captures(none) [[A:%.*]], ptr captures(none) [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[B]], i32 128) ]
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i16 32) ]
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr align 32 [[A]], ptr align 128 [[B]], i64 64, i1 false)
; CHECK-NEXT:    ret i32 0
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %b, i32 128)]
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i16 32)]
  tail call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 %b, i64 64, i1 false)
  ret i32 0
}

define i32 @moo3(ptr nocapture %a, ptr nocapture %b) {
; CHECK-LABEL: define i32 @moo3
; CHECK-SAME: (ptr captures(none) [[A:%.*]], ptr captures(none) [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i16 32), "align"(ptr [[B]], i32 128) ]
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr align 32 [[A]], ptr align 128 [[B]], i64 64, i1 false)
; CHECK-NEXT:    ret i32 0
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i16 32), "align"(ptr %b, i32 128)]
  tail call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 %b, i64 64, i1 false)
  ret i32 0
}


; Variable alignments appear to be legal, don't crash
define i32 @pr51680(ptr nocapture %a, i32 %align) {
; CHECK-LABEL: define i32 @pr51680
; CHECK-SAME: (ptr captures(none) [[A:%.*]], i32 [[ALIGN:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i32 [[ALIGN]]) ]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i32 %align)]
  %0 = load i32, ptr %a, align 4
  ret i32 %0
}

define i32 @pr64687(ptr nocapture %a) {
; CHECK-LABEL: define i32 @pr64687
; CHECK-SAME: (ptr captures(none) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.assume(i1 true) [ "align"(ptr [[A]], i32 123) ]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  tail call void @llvm.assume(i1 true) ["align"(ptr %a, i32 123)]
  %0 = load i32, ptr %a, align 4
  ret i32 %0
}

declare void @llvm.assume(i1) nounwind

declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) nounwind
declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind

