; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -wasm-disable-explicit-locals -wasm-keep-registers | FileCheck %s

target triple = "wasm32-unknown-unknown"

; Return multiple values, some of which will be legalized into multiple values.
declare { i64, i128, i192, i128, i64 } @return_multi_multi()

; Test returning a single value from @return_multi_multi.

define i64 @test0() {
; CHECK-LABEL: test0:
; CHECK:         .functype test0 () -> (i64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push0=, __stack_pointer
; CHECK-NEXT:    i32.const $push1=, 96
; CHECK-NEXT:    i32.sub $push5=, $pop0, $pop1
; CHECK-NEXT:    local.tee $push4=, $1=, $pop5
; CHECK-NEXT:    global.set __stack_pointer, $pop4
; CHECK-NEXT:    call return_multi_multi, $1
; CHECK-NEXT:    i64.load $0=, 0($1)
; CHECK-NEXT:    i32.const $push2=, 96
; CHECK-NEXT:    i32.add $push3=, $1, $pop2
; CHECK-NEXT:    global.set __stack_pointer, $pop3
; CHECK-NEXT:    local.copy $push6=, $0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %t1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 0
  ret i64 %t1
}

define i128 @test1() {
; CHECK-LABEL: test1:
; CHECK:         .functype test1 (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push1=, __stack_pointer
; CHECK-NEXT:    i32.const $push2=, 96
; CHECK-NEXT:    i32.sub $push6=, $pop1, $pop2
; CHECK-NEXT:    local.tee $push5=, $2=, $pop6
; CHECK-NEXT:    global.set __stack_pointer, $pop5
; CHECK-NEXT:    call return_multi_multi, $2
; CHECK-NEXT:    i64.load $1=, 24($2)
; CHECK-NEXT:    i64.load $push0=, 16($2)
; CHECK-NEXT:    i64.store 0($0), $pop0
; CHECK-NEXT:    i64.store 8($0), $1
; CHECK-NEXT:    i32.const $push3=, 96
; CHECK-NEXT:    i32.add $push4=, $2, $pop3
; CHECK-NEXT:    global.set __stack_pointer, $pop4
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %t1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 1
  ret i128 %t1
}

define i192 @test2() {
; CHECK-LABEL: test2:
; CHECK:         .functype test2 (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push3=, __stack_pointer
; CHECK-NEXT:    i32.const $push4=, 96
; CHECK-NEXT:    i32.sub $push8=, $pop3, $pop4
; CHECK-NEXT:    local.tee $push7=, $3=, $pop8
; CHECK-NEXT:    global.set __stack_pointer, $pop7
; CHECK-NEXT:    call return_multi_multi, $3
; CHECK-NEXT:    i64.load $1=, 40($3)
; CHECK-NEXT:    i64.load $2=, 32($3)
; CHECK-NEXT:    i32.const $push0=, 48
; CHECK-NEXT:    i32.add $push1=, $3, $pop0
; CHECK-NEXT:    i64.load $push2=, 0($pop1)
; CHECK-NEXT:    i64.store 16($0), $pop2
; CHECK-NEXT:    i64.store 0($0), $2
; CHECK-NEXT:    i64.store 8($0), $1
; CHECK-NEXT:    i32.const $push5=, 96
; CHECK-NEXT:    i32.add $push6=, $3, $pop5
; CHECK-NEXT:    global.set __stack_pointer, $pop6
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %t1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 2
  ret i192 %t1
}

define i128 @test3() {
; CHECK-LABEL: test3:
; CHECK:         .functype test3 (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push1=, __stack_pointer
; CHECK-NEXT:    i32.const $push2=, 96
; CHECK-NEXT:    i32.sub $push6=, $pop1, $pop2
; CHECK-NEXT:    local.tee $push5=, $2=, $pop6
; CHECK-NEXT:    global.set __stack_pointer, $pop5
; CHECK-NEXT:    call return_multi_multi, $2
; CHECK-NEXT:    i64.load $1=, 72($2)
; CHECK-NEXT:    i64.load $push0=, 64($2)
; CHECK-NEXT:    i64.store 0($0), $pop0
; CHECK-NEXT:    i64.store 8($0), $1
; CHECK-NEXT:    i32.const $push3=, 96
; CHECK-NEXT:    i32.add $push4=, $2, $pop3
; CHECK-NEXT:    global.set __stack_pointer, $pop4
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %t1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 3
  ret i128 %t1
}

define i64 @test4() {
; CHECK-LABEL: test4:
; CHECK:         .functype test4 () -> (i64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push0=, __stack_pointer
; CHECK-NEXT:    i32.const $push1=, 96
; CHECK-NEXT:    i32.sub $push5=, $pop0, $pop1
; CHECK-NEXT:    local.tee $push4=, $1=, $pop5
; CHECK-NEXT:    global.set __stack_pointer, $pop4
; CHECK-NEXT:    call return_multi_multi, $1
; CHECK-NEXT:    i64.load $0=, 80($1)
; CHECK-NEXT:    i32.const $push2=, 96
; CHECK-NEXT:    i32.add $push3=, $1, $pop2
; CHECK-NEXT:    global.set __stack_pointer, $pop3
; CHECK-NEXT:    local.copy $push6=, $0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %t1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 4
  ret i64 %t1
}

; Test returning multiple values from @return_multi_multi.

define { i64, i128 } @test5() {
; CHECK-LABEL: test5:
; CHECK:         .functype test5 (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push1=, __stack_pointer
; CHECK-NEXT:    i32.const $push2=, 96
; CHECK-NEXT:    i32.sub $push6=, $pop1, $pop2
; CHECK-NEXT:    local.tee $push5=, $3=, $pop6
; CHECK-NEXT:    global.set __stack_pointer, $pop5
; CHECK-NEXT:    call return_multi_multi, $3
; CHECK-NEXT:    i64.load $1=, 24($3)
; CHECK-NEXT:    i64.load $2=, 16($3)
; CHECK-NEXT:    i64.load $push0=, 0($3)
; CHECK-NEXT:    i64.store 0($0), $pop0
; CHECK-NEXT:    i64.store 16($0), $2
; CHECK-NEXT:    i64.store 24($0), $1
; CHECK-NEXT:    i32.const $push3=, 96
; CHECK-NEXT:    i32.add $push4=, $3, $pop3
; CHECK-NEXT:    global.set __stack_pointer, $pop4
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %r0 = extractvalue { i64, i128, i192, i128, i64 } %t0, 0
  %r1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 1
  %s0 = insertvalue { i64, i128 } undef, i64 %r0, 0
  %s1 = insertvalue { i64, i128 } %s0, i128 %r1, 1
  ret { i64, i128 } %s1
}

define { i128, i128 } @test6() {
; CHECK-LABEL: test6:
; CHECK:         .functype test6 (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push1=, __stack_pointer
; CHECK-NEXT:    i32.const $push2=, 96
; CHECK-NEXT:    i32.sub $push6=, $pop1, $pop2
; CHECK-NEXT:    local.tee $push5=, $4=, $pop6
; CHECK-NEXT:    global.set __stack_pointer, $pop5
; CHECK-NEXT:    call return_multi_multi, $4
; CHECK-NEXT:    i64.load $1=, 24($4)
; CHECK-NEXT:    i64.load $2=, 16($4)
; CHECK-NEXT:    i64.load $3=, 72($4)
; CHECK-NEXT:    i64.load $push0=, 64($4)
; CHECK-NEXT:    i64.store 16($0), $pop0
; CHECK-NEXT:    i64.store 24($0), $3
; CHECK-NEXT:    i64.store 0($0), $2
; CHECK-NEXT:    i64.store 8($0), $1
; CHECK-NEXT:    i32.const $push3=, 96
; CHECK-NEXT:    i32.add $push4=, $4, $pop3
; CHECK-NEXT:    global.set __stack_pointer, $pop4
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %r1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 1
  %r3 = extractvalue { i64, i128, i192, i128, i64 } %t0, 3
  %s0 = insertvalue { i128, i128 } undef, i128 %r1, 0
  %s1 = insertvalue { i128, i128 } %s0, i128 %r3, 1
  ret { i128, i128 } %s1
}

define { i64, i192 } @test7() {
; CHECK-LABEL: test7:
; CHECK:         .functype test7 (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push3=, __stack_pointer
; CHECK-NEXT:    i32.const $push4=, 96
; CHECK-NEXT:    i32.sub $push8=, $pop3, $pop4
; CHECK-NEXT:    local.tee $push7=, $4=, $pop8
; CHECK-NEXT:    global.set __stack_pointer, $pop7
; CHECK-NEXT:    call return_multi_multi, $4
; CHECK-NEXT:    i32.const $push0=, 48
; CHECK-NEXT:    i32.add $push1=, $4, $pop0
; CHECK-NEXT:    i64.load $1=, 0($pop1)
; CHECK-NEXT:    i64.load $2=, 40($4)
; CHECK-NEXT:    i64.load $3=, 32($4)
; CHECK-NEXT:    i64.load $push2=, 0($4)
; CHECK-NEXT:    i64.store 0($0), $pop2
; CHECK-NEXT:    i64.store 32($0), $1
; CHECK-NEXT:    i64.store 16($0), $3
; CHECK-NEXT:    i64.store 24($0), $2
; CHECK-NEXT:    i32.const $push5=, 96
; CHECK-NEXT:    i32.add $push6=, $4, $pop5
; CHECK-NEXT:    global.set __stack_pointer, $pop6
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %r0 = extractvalue { i64, i128, i192, i128, i64 } %t0, 0
  %r2 = extractvalue { i64, i128, i192, i128, i64 } %t0, 2
  %s0 = insertvalue { i64, i192 } undef, i64 %r0, 0
  %s1 = insertvalue { i64, i192 } %s0, i192 %r2, 1
  ret { i64, i192 } %s1
}

define { i128, i192, i128, i64 } @test8() {
; CHECK-LABEL: test8:
; CHECK:         .functype test8 (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push3=, __stack_pointer
; CHECK-NEXT:    i32.const $push4=, 96
; CHECK-NEXT:    i32.sub $push8=, $pop3, $pop4
; CHECK-NEXT:    local.tee $push7=, $8=, $pop8
; CHECK-NEXT:    global.set __stack_pointer, $pop7
; CHECK-NEXT:    call return_multi_multi, $8
; CHECK-NEXT:    i32.const $push0=, 48
; CHECK-NEXT:    i32.add $push1=, $8, $pop0
; CHECK-NEXT:    i64.load $1=, 0($pop1)
; CHECK-NEXT:    i64.load $2=, 72($8)
; CHECK-NEXT:    i64.load $3=, 64($8)
; CHECK-NEXT:    i64.load $4=, 40($8)
; CHECK-NEXT:    i64.load $5=, 32($8)
; CHECK-NEXT:    i64.load $6=, 24($8)
; CHECK-NEXT:    i64.load $7=, 16($8)
; CHECK-NEXT:    i64.load $push2=, 0($8)
; CHECK-NEXT:    i64.store 64($0), $pop2
; CHECK-NEXT:    i64.store 48($0), $7
; CHECK-NEXT:    i64.store 56($0), $6
; CHECK-NEXT:    i64.store 32($0), $1
; CHECK-NEXT:    i64.store 16($0), $5
; CHECK-NEXT:    i64.store 24($0), $4
; CHECK-NEXT:    i64.store 0($0), $3
; CHECK-NEXT:    i64.store 8($0), $2
; CHECK-NEXT:    i32.const $push5=, 96
; CHECK-NEXT:    i32.add $push6=, $8, $pop5
; CHECK-NEXT:    global.set __stack_pointer, $pop6
; CHECK-NEXT:    # fallthrough-return
  %t0 = call { i64, i128, i192, i128, i64 } @return_multi_multi()
  %r0 = extractvalue { i64, i128, i192, i128, i64 } %t0, 0
  %r1 = extractvalue { i64, i128, i192, i128, i64 } %t0, 1
  %r2 = extractvalue { i64, i128, i192, i128, i64 } %t0, 2
  %r3 = extractvalue { i64, i128, i192, i128, i64 } %t0, 3
  %s0 = insertvalue { i128, i192, i128, i64 } undef, i128 %r3, 0
  %s1 = insertvalue { i128, i192, i128, i64 } %s0, i192 %r2, 1
  %s2 = insertvalue { i128, i192, i128, i64 } %s1, i128 %r1, 2
  %s3 = insertvalue { i128, i192, i128, i64 } %s2, i64 %r0, 3
  ret { i128, i192, i128, i64 } %s3
}
