; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=mipsisa32r6 < %s | FileCheck %s --check-prefix=MIPS32R6

declare float @llvm.maximumnum.f32(float, float)
declare double @llvm.maximumnum.f64(double, double)
declare float @llvm.minimumnum.f32(float, float)
declare double @llvm.minimumnum.f64(double, double)

define float @maximumnum_float(float %x, float %y) {
; MIPS32R6-LABEL: maximumnum_float:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.s $f0, $f1, $f0
  %z = call float @llvm.maximumnum.f32(float %x, float %y)
  ret float %z
}

define float @maximumnum_float_nsz(float %x, float %y) {
; MIPS32R6-LABEL: maximumnum_float_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.s $f0, $f1, $f0
  %z = call nsz float @llvm.maximumnum.f32(float %x, float %y)
  ret float %z
}

define float @maximumnum_float_nnan(float %x, float %y) {
; MIPS32R6-LABEL: maximumnum_float_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.s $f0, $f12, $f14
  %z = call nnan float @llvm.maximumnum.f32(float %x, float %y)
  ret float %z
}


define double @maximumnum_double(double %x, double %y) {
; MIPS32R6-LABEL: maximumnum_double:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.d $f0, $f1, $f0
  %z = call double @llvm.maximumnum.f64(double %x, double %y)
  ret double %z
}

define double @maximumnum_double_nsz(double %x, double %y) {
; MIPS32R6-LABEL: maximumnum_double_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.d $f0, $f1, $f0
  %z = call nsz double @llvm.maximumnum.f64(double %x, double %y)
  ret double %z
}

define double @maximumnum_double_nnan(double %x, double %y) {
; MIPS32R6-LABEL: maximumnum_double_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.d $f0, $f12, $f14
  %z = call nnan double @llvm.maximumnum.f64(double %x, double %y)
  ret double %z
}

define float @minimumnum_float(float %x, float %y) {
; MIPS32R6-LABEL: minimumnum_float:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f1, $f0
  %z = call float @llvm.minimumnum.f32(float %x, float %y)
  ret float %z
}

define float @minimumnum_float_nsz(float %x, float %y) {
; MIPS32R6-LABEL: minimumnum_float_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f1, $f0
  %z = call nsz float @llvm.minimumnum.f32(float %x, float %y)
  ret float %z
}

define float @minimumnum_float_nnan(float %x, float %y) {
; MIPS32R6-LABEL: minimumnum_float_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f12, $f14
  %z = call nnan float @llvm.minimumnum.f32(float %x, float %y)
  ret float %z
}

define double @minimumnum_double(double %x, double %y) {
; MIPS32R6-LABEL: minimumnum_double:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f1, $f0
  %z = call double @llvm.minimumnum.f64(double %x, double %y)
  ret double %z
}

define double @minimumnum_double_nsz(double %x, double %y) {
; MIPS32R6-LABEL: minimumnum_double_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f1, $f0
  %z = call nsz double @llvm.minimumnum.f64(double %x, double %y)
  ret double %z
}

define double @minimumnum_double_nnan(double %x, double %y) {
; MIPS32R6-LABEL: minimumnum_double_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f12, $f14
  %z = call nnan double @llvm.minimumnum.f64(double %x, double %y)
  ret double %z
}
