; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <2 x i32> @and_extract_zext_idx0(<4 x i16> %vec) nounwind {
; CHECK-SD-LABEL: and_extract_zext_idx0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_extract_zext_idx0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %zext = zext <4 x i16> %vec to <4 x i32>
  %extract = call <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32> %zext, i64 0)
  %and = and <2 x i32> %extract, <i32 65535, i32 65535>
  ret <2 x i32> %and
}

define <4 x i16> @and_extract_sext_idx0(<8 x i8> %vec) nounwind {
; CHECK-SD-LABEL: and_extract_sext_idx0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_extract_sext_idx0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %sext = sext <8 x i8> %vec to <8 x i16>
  %extract = call <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16> %sext, i64 0)
  %and = and <4 x i16> %extract, <i16 255, i16 255, i16 255, i16 255>
  ret <4 x i16> %and
}

define <2 x i32> @and_extract_zext_idx2(<4 x i16> %vec) nounwind {
; CHECK-SD-LABEL: and_extract_zext_idx2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_extract_zext_idx2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-GI-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %zext = zext <4 x i16> %vec to <4 x i32>
  %extract = call <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32> %zext, i64 2)
  %and = and <2 x i32> %extract, <i32 65535, i32 65535>
  ret <2 x i32> %and
}

define <4 x i16> @and_extract_sext_idx4(<8 x i8> %vec) nounwind {
; CHECK-SD-LABEL: and_extract_sext_idx4:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_extract_sext_idx4:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %sext = sext <8 x i8> %vec to <8 x i16>
  %extract = call <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16> %sext, i64 4)
  %and = and <4 x i16> %extract, <i16 255, i16 255, i16 255, i16 255>
  ret <4 x i16> %and
}

define <2 x i32> @sext_extract_zext_idx0(<4 x i16> %vec) nounwind {
; CHECK-SD-LABEL: sext_extract_zext_idx0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_extract_zext_idx0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    shl v0.2s, v0.2s, #16
; CHECK-GI-NEXT:    sshr v0.2s, v0.2s, #16
; CHECK-GI-NEXT:    ret
  %zext = zext <4 x i16> %vec to <4 x i32>
  %extract = call <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32> %zext, i64 0)
  %sext_inreg_step0 = shl <2 x i32> %extract, <i32 16, i32 16>
  %sext_inreg = ashr <2 x i32> %sext_inreg_step0, <i32 16, i32 16>
  ret <2 x i32> %sext_inreg
}

; Negative test, combine should not fire if sign extension is for a different width.
define <2 x i32> @sext_extract_zext_idx0_negtest(<4 x i16> %vec) nounwind {
; CHECK-LABEL: sext_extract_zext_idx0_negtest:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    shl v0.2s, v0.2s, #17
; CHECK-NEXT:    sshr v0.2s, v0.2s, #17
; CHECK-NEXT:    ret
  %zext = zext <4 x i16> %vec to <4 x i32>
  %extract = call <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32> %zext, i64 0)
  %sext_inreg_step0 = shl <2 x i32> %extract, <i32 17, i32 17>
  %sext_inreg = ashr <2 x i32> %sext_inreg_step0, <i32 17, i32 17>
  ret <2 x i32> %sext_inreg
}

define <4 x i16> @sext_extract_sext_idx0(<8 x i8> %vec) nounwind {
; CHECK-SD-LABEL: sext_extract_sext_idx0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_extract_sext_idx0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-GI-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-GI-NEXT:    ret
  %sext = sext <8 x i8> %vec to <8 x i16>
  %extract = call <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16> %sext, i64 0)
  %sext_inreg_step0 = shl <4 x i16> %extract, <i16 8, i16 8, i16 8, i16 8>
  %sext_inreg = ashr <4 x i16> %sext_inreg_step0, <i16 8, i16 8, i16 8, i16 8>
  ret <4 x i16> %sext_inreg
}

define <2 x i32> @sext_extract_zext_idx2(<4 x i16> %vec) nounwind {
; CHECK-SD-LABEL: sext_extract_zext_idx2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_extract_zext_idx2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-GI-NEXT:    shl v0.2s, v0.2s, #16
; CHECK-GI-NEXT:    sshr v0.2s, v0.2s, #16
; CHECK-GI-NEXT:    ret
  %zext = zext <4 x i16> %vec to <4 x i32>
  %extract = call <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32> %zext, i64 2)
  %sext_inreg_step0 = shl <2 x i32> %extract, <i32 16, i32 16>
  %sext_inreg = ashr <2 x i32> %sext_inreg_step0, <i32 16, i32 16>
  ret <2 x i32> %sext_inreg
}

define <4 x i16> @sext_extract_sext_idx4(<8 x i8> %vec) nounwind {
; CHECK-SD-LABEL: sext_extract_sext_idx4:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_extract_sext_idx4:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-GI-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-GI-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-GI-NEXT:    ret
  %sext = sext <8 x i8> %vec to <8 x i16>
  %extract = call <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16> %sext, i64 4)
  %sext_inreg_step0 = shl <4 x i16> %extract, <i16 8, i16 8, i16 8, i16 8>
  %sext_inreg = ashr <4 x i16> %sext_inreg_step0, <i16 8, i16 8, i16 8, i16 8>
  ret <4 x i16> %sext_inreg
}

define <8 x i8> @sext_extract_idx(<16 x i8> %vec) nounwind {
; CHECK-LABEL: sext_extract_idx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %extract = call <8 x i8> @llvm.vector.extract.v8i8.v16i8(<16 x i8> %vec, i64 0)
  ret <8 x i8> %extract
}

declare <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32>, i64)
declare <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16>, i64)
declare <8 x i8> @llvm.vector.extract.v8i8.v16i8(<16 x i8>, i64)
