; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=aarch64--linux-gnu -mattr=+sve < %s | FileCheck %s

; This regression test is verifying that a GEP instruction performed on a
; scalable vector does not produce a 'assumption that TypeSize is not scalable'
; warning when performing cost analysis.

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @gep_scalable_types(ptr %ptr) {
; CHECK-LABEL: 'gep_scalable_types'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %gep1 = getelementptr <vscale x 16 x i8>, ptr %ptr, i32 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %gep2 = getelementptr [2 x <vscale x 16 x i8>], ptr %ptr, i32 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %gep3 = getelementptr target("aarch64.svcount"), ptr %ptr, i32 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %gep4 = getelementptr [2 x target("aarch64.svcount")], ptr %ptr, i32 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %gep1 = getelementptr <vscale x 16 x i8>, ptr %ptr, i32 2
  %gep2 = getelementptr [2 x <vscale x 16 x i8>], ptr %ptr, i32 2
  %gep3 = getelementptr target("aarch64.svcount"), ptr %ptr, i32 2
  %gep4 = getelementptr [2 x target("aarch64.svcount")], ptr %ptr, i32 2
  ret void
}

define ptr @sext_gep(ptr %p, i32 %a) {
; CHECK-LABEL: 'sext_gep'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %b = sext i32 %a to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r = getelementptr <vscale x 8 x half>, ptr %p, i64 %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret ptr %r
;
  %b = sext i32 %a to i64
  %r = getelementptr <vscale x 8 x half>, ptr %p, i64 %b
  ret ptr %r
}
