; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes='require<profile-summary>,function(codegenprepare)' %s -o - | FileCheck %s
; This file tests the different cases what are involved when codegen prepare
; tries to get sign/zero extension out of the way of addressing mode.
; This tests require an actual target as addressing mode decisions depends
; on the target.

target datalayout = "e-i64:64-f80:128-s:64-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx"


; Check that we correctly promote both operands of the promotable add.
define i8 @twoArgsPromotion(i32 %arg1, i32 %arg2) {
; CHECK-LABEL: define i8 @twoArgsPromotion(
; CHECK-SAME: i32 [[ARG1:%.*]], i32 [[ARG2:%.*]]) {
; CHECK-NEXT:    [[PROMOTED:%.*]] = sext i32 [[ARG1]] to i64
; CHECK-NEXT:    [[PROMOTED2:%.*]] = sext i32 [[ARG2]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED]], [[PROMOTED2]]
; CHECK-NEXT:    [[BASE:%.*]] = inttoptr i64 [[ADD]] to ptr
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[BASE]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %add = add nsw i32 %arg1, %arg2
  %sextadd = sext i32 %add to i64
  %base = inttoptr i64 %sextadd to ptr
  %res = load i8, ptr %base
  ret i8 %res
}

; Check that we do not promote both operands of the promotable add when
; the instruction will not be folded into the addressing mode.
; Otherwise, we will increase the number of instruction executed.
; (This is a heuristic of course, because the new sext could have been
; merged with something else.)
define i8 @twoArgsNoPromotion(i32 %arg1, i32 %arg2, ptr %base) {
; CHECK-LABEL: define i8 @twoArgsNoPromotion(
; CHECK-SAME: i32 [[ARG1:%.*]], i32 [[ARG2:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[ARG1]], [[ARG2]]
; CHECK-NEXT:    [[SEXTADD:%.*]] = sext i32 [[ADD]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[SEXTADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %add = add nsw i32 %arg1, %arg2
  %sextadd = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we do not promote when the related instruction does not have
; the nsw flag.
define i8 @noPromotion(i32 %arg1, i32 %arg2, ptr %base) {
; CHECK-LABEL: define i8 @noPromotion(
; CHECK-SAME: i32 [[ARG1:%.*]], i32 [[ARG2:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[ARG1]], [[ARG2]]
; CHECK-NEXT:    [[SEXTADD:%.*]] = sext i32 [[ADD]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[SEXTADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %add = add i32 %arg1, %arg2
  %sextadd = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we correctly promote constant arguments.
define i8 @oneArgPromotion(i32 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotion(
; CHECK-SAME: i32 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED:%.*]] = sext i32 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %add = add nsw i32 %arg1, 1
  %sextadd = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we are able to merge a sign extension with a zero extension.
define i8 @oneArgPromotionZExt(i8 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionZExt(
; CHECK-SAME: i8 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED2:%.*]] = zext i8 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED2]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %zext = zext i8 %arg1 to i32
  %add = add nsw i32 %zext, 1
  %sextadd = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; When promoting a constant zext, the IR builder returns a constant,
; not an instruction. Make sure this is properly handled. This used
; to crash.
; Note: The constant zext is promoted, but does not help matching
; more thing in the addressing mode. Therefore the modification is
; rolled back.
; Still, this test case exercises the desired code path.
define i8 @oneArgPromotionCstZExt(ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionCstZExt(
; CHECK-SAME: ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 0, 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %cst = zext i16 undef to i32
  %add = add nsw i32 %cst, 1
  %sextadd = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we do not promote truncate when we cannot determine the
; bits that are dropped.
define i8 @oneArgPromotionBlockTrunc1(i32 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionBlockTrunc1(
; CHECK-SAME: i32 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[ARG1]] to i8
; CHECK-NEXT:    [[PROMOTED:%.*]] = sext i8 [[TRUNC]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %trunc = trunc i32 %arg1 to i8
  %add = add nsw i8 %trunc, 1
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we do not promote truncate when we cannot determine all the
; bits that are dropped.
define i8 @oneArgPromotionBlockTrunc2(i16 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionBlockTrunc2(
; CHECK-SAME: i16 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[SEXTARG1:%.*]] = sext i16 [[ARG1]] to i32
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[SEXTARG1]] to i8
; CHECK-NEXT:    [[PROMOTED:%.*]] = sext i8 [[TRUNC]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sextarg1 = sext i16 %arg1 to i32
  %trunc = trunc i32 %sextarg1 to i8
  %add = add nsw i8 %trunc, 1
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we are able to promote truncate when we know all the bits
; that are dropped.
define i8 @oneArgPromotionPassTruncKeepSExt(i1 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionPassTruncKeepSExt(
; CHECK-SAME: i1 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED:%.*]] = sext i1 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sextarg1 = sext i1 %arg1 to i32
  %trunc = trunc i32 %sextarg1 to i8
  %add = add nsw i8 %trunc, 1
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; On X86 truncate are free. Check that we are able to promote the add
; to be used as addressing mode and that we insert a truncate for the other
; use.
define i8 @oneArgPromotionTruncInsert(i8 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionTruncInsert(
; CHECK-SAME: i8 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED2:%.*]] = sext i8 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED2]], 1
; CHECK-NEXT:    [[PROMOTED:%.*]] = trunc i64 [[ADD]] to i8
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    [[FINALRES:%.*]] = add i8 [[RES]], [[PROMOTED]]
; CHECK-NEXT:    ret i8 [[FINALRES]]
;
  %add = add nsw i8 %arg1, 1
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  %finalres = add i8 %res, %add
  ret i8 %finalres
}

; Cannot sext from a larger type than the promoted type.
define i8 @oneArgPromotionLargerType(i128 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionLargerType(
; CHECK-SAME: i128 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i128 [[ARG1]] to i8
; CHECK-NEXT:    [[PROMOTED2:%.*]] = sext i8 [[TRUNC]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED2]], 1
; CHECK-NEXT:    [[PROMOTED:%.*]] = trunc i64 [[ADD]] to i8
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    [[FINALRES:%.*]] = add i8 [[RES]], [[PROMOTED]]
; CHECK-NEXT:    ret i8 [[FINALRES]]
;
  %trunc = trunc i128 %arg1 to i8
  %add = add nsw i8 %trunc, 1
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  %finalres = add i8 %res, %add
  ret i8 %finalres
}

; Use same inserted trunc
; On X86 truncate are free. Check that we are able to promote the add
; to be used as addressing mode and that we insert a truncate for
; *all* the other uses.
define i8 @oneArgPromotionTruncInsertSeveralUse(i8 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionTruncInsertSeveralUse(
; CHECK-SAME: i8 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED2:%.*]] = sext i8 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED2]], 1
; CHECK-NEXT:    [[PROMOTED:%.*]] = trunc i64 [[ADD]] to i8
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    [[ALMOSTFINALRES:%.*]] = add i8 [[RES]], [[PROMOTED]]
; CHECK-NEXT:    [[FINALRES:%.*]] = add i8 [[ALMOSTFINALRES]], [[PROMOTED]]
; CHECK-NEXT:    ret i8 [[FINALRES]]
;
  %add = add nsw i8 %arg1, 1
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  %almostfinalres = add i8 %res, %add
  %finalres = add i8 %almostfinalres, %add
  ret i8 %finalres
}

; Check that the promoted instruction is used for all uses of the original
; sign extension.
define i64 @oneArgPromotionSExtSeveralUse(i8 %arg1, ptr %base) {
; CHECK-LABEL: define i64 @oneArgPromotionSExtSeveralUse(
; CHECK-SAME: i8 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED:%.*]] = sext i8 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[PROMOTED]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    [[ALMOSTFINALRES:%.*]] = zext i8 [[RES]] to i64
; CHECK-NEXT:    [[FINALRES:%.*]] = add i64 [[ALMOSTFINALRES]], [[ADD]]
; CHECK-NEXT:    ret i64 [[FINALRES]]
;
  %add = add nsw i8 %arg1, 1
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  %almostfinalres = zext i8 %res to i64
  %finalres = add i64 %almostfinalres, %sextadd
  ret i64 %finalres
}

; Check all types of rollback mechanism.
; For this test, the sign extension stays in place.
; However, the matching process goes until promoting both the operands
; of the first promotable add implies.
; At this point the rollback mechanism kicks in and restores the states
; until the addressing mode matcher is able to match something: in that
; case promote nothing.
; Along the way, the promotion mechanism involves:
; - Mutating the type of %promotableadd1 and %promotableadd2.
; - Creating a sext for %arg1 and %arg2.
; - Creating a trunc for a use of %promotableadd1.
; - Replacing a bunch of uses.
; - Setting the operands of the promoted instruction with the promoted values.
; - Moving instruction around (mainly sext when promoting instruction).
; Each type of those promotions has to be undo at least once during this
; specific test.
define i8 @twoArgsPromotionNest(i32 %arg1, i32 %arg2, ptr %base) {
; CHECK-LABEL: define i8 @twoArgsPromotionNest(
; CHECK-SAME: i32 [[ARG1:%.*]], i32 [[ARG2:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTABLEADD1:%.*]] = add nsw i32 [[ARG1]], [[ARG2]]
; CHECK-NEXT:    [[PROMOTABLEADD2:%.*]] = add nsw i32 [[PROMOTABLEADD1]], [[PROMOTABLEADD1]]
; CHECK-NEXT:    [[SEXTADD:%.*]] = sext i32 [[PROMOTABLEADD2]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[SEXTADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %promotableadd1 = add nsw i32 %arg1, %arg2
  %promotableadd2 = add nsw i32 %promotableadd1, %promotableadd1
  %sextadd = sext i32 %promotableadd2 to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Test the InstructionRemover undo, which was the only one not
; kicked in the previous test.
; The matcher first promotes the add, removes the trunc and promotes
; the sext of arg1.
; Then, the matcher cannot use an addressing mode r + r + r, thus it
; rolls back.
define i8 @twoArgsNoPromotionRemove(i1 %arg1, i8 %arg2, ptr %base) {
; CHECK-LABEL: define i8 @twoArgsNoPromotionRemove(
; CHECK-SAME: i1 [[ARG1:%.*]], i8 [[ARG2:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[SEXTARG1:%.*]] = sext i1 [[ARG1]] to i32
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[SEXTARG1]] to i8
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[TRUNC]], [[ARG2]]
; CHECK-NEXT:    [[SEXTADD:%.*]] = sext i8 [[ADD]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[SEXTADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sextarg1 = sext i1 %arg1 to i32
  %trunc = trunc i32 %sextarg1 to i8
  %add = add nsw i8 %trunc, %arg2
  %sextadd = sext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %sextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Ensure that when the profitability checks kicks in, the IR is not modified
; will IgnoreProfitability is on.
; The profitabily check happens when a candidate instruction has several uses.
; The matcher will create a new matcher for each use and check if the
; instruction is in the list of the matched instructions of this new matcher.
; All changes made by the new matchers must be dropped before pursuing
; otherwise the state of the original matcher will be wrong.
;
; Without the profitability check, when checking for the second use of
; arrayidx, the matcher promotes everything all the way to %arg1, %arg2.
; Check that we did not promote anything in the final matching.
;
; <rdar://problem/16020230>
; BB then
; BB else
define i32 @checkProfitability(i32 %arg1, i32 %arg2, i1 %test) {
; CHECK-LABEL: define i32 @checkProfitability(
; CHECK-SAME: i32 [[ARG1:%.*]], i32 [[ARG2:%.*]], i1 [[TEST:%.*]]) {
; CHECK-NEXT:    [[SHL:%.*]] = shl nsw i32 [[ARG1]], 1
; CHECK-NEXT:    [[ADD1:%.*]] = add nsw i32 [[SHL]], [[ARG2]]
; CHECK-NEXT:    [[SEXTIDX1:%.*]] = sext i32 [[ADD1]] to i64
; CHECK-NEXT:    br i1 [[TEST]], label %[[THEN:.*]], label %[[ELSE:.*]]
; CHECK:       [[THEN]]:
; CHECK-NEXT:    [[SUNKADDR:%.*]] = inttoptr i64 [[SEXTIDX1]] to ptr
; CHECK-NEXT:    [[SUNKADDR13:%.*]] = getelementptr i8, ptr [[SUNKADDR]], i64 48
; CHECK-NEXT:    [[RES1:%.*]] = load i32, ptr [[SUNKADDR13]], align 4
; CHECK-NEXT:    br label %[[END:.*]]
; CHECK:       [[ELSE]]:
; CHECK-NEXT:    [[SUNKADDR17:%.*]] = inttoptr i64 [[SEXTIDX1]] to ptr
; CHECK-NEXT:    [[SUNKADDR18:%.*]] = getelementptr i8, ptr [[SUNKADDR17]], i64 48
; CHECK-NEXT:    [[RES2:%.*]] = load i32, ptr [[SUNKADDR18]], align 4
; CHECK-NEXT:    br label %[[END]]
; CHECK:       [[END]]:
; CHECK-NEXT:    [[TMP:%.*]] = phi i32 [ [[RES1]], %[[THEN]] ], [ [[RES2]], %[[ELSE]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[SEXTIDX1]] to i32
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[TMP]], [[TMP1]]
; CHECK-NEXT:    [[ADDR:%.*]] = inttoptr i32 [[RES]] to ptr
; CHECK-NEXT:    [[FINAL:%.*]] = load i32, ptr [[ADDR]], align 4
; CHECK-NEXT:    ret i32 [[FINAL]]
;
  %shl = shl nsw i32 %arg1, 1
  %add1 = add nsw i32 %shl, %arg2
  %sextidx1 = sext i32 %add1 to i64
  %tmpptr = inttoptr i64 %sextidx1 to ptr
  %arrayidx1 = getelementptr i32, ptr %tmpptr, i64 12
  br i1 %test, label %then, label %else
then:
  %res1 = load i32, ptr %arrayidx1
  br label %end
else:
  %res2 = load i32, ptr %arrayidx1
  br label %end
end:
  %tmp = phi i32 [%res1, %then], [%res2, %else]
  %res = add i32 %tmp, %add1
  %addr = inttoptr i32 %res to ptr
  %final = load i32, ptr %addr
  ret i32 %final
}

%struct.dns_packet = type { i32, i32, %union.anon }
%union.anon = type { i32 }

@a = common global i32 0, align 4
@b = common global i16 0, align 2

; We used to crash on this function because we did not return the right
; promoted instruction for %conv.i.
; Make sure we generate the right code now.
; %conv.i is used twice and only one of its use is being promoted.
; Use it at the starting point for the matching.
define signext i16 @fn3(ptr nocapture readonly %P) {
; CHECK-LABEL: define signext i16 @fn3(
; CHECK-SAME: ptr nocapture readonly [[P:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[WHILE_BODY_I_I:.*]]
; CHECK:       [[WHILE_BODY_I_I]]:
; CHECK-NEXT:    [[SRC_ADDR_0_I_I:%.*]] = phi i16 [ 0, %[[ENTRY]] ], [ [[INC_I_I:%.*]], %[[WHILE_BODY_I_I]] ]
; CHECK-NEXT:    [[INC_I_I]] = add i16 [[SRC_ADDR_0_I_I]], 1
; CHECK-NEXT:    [[IDXPROM_I_I:%.*]] = sext i16 [[SRC_ADDR_0_I_I]] to i64
; CHECK-NEXT:    [[SUNKADDR:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 [[IDXPROM_I_I]]
; CHECK-NEXT:    [[SUNKADDR2:%.*]] = getelementptr inbounds i8, ptr [[SUNKADDR]], i64 8
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[SUNKADDR2]], align 1
; CHECK-NEXT:    [[CONV2_I_I:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    [[AND_I_I:%.*]] = and i32 [[CONV2_I_I]], 15
; CHECK-NEXT:    store i32 [[AND_I_I]], ptr @a, align 4
; CHECK-NEXT:    [[TOBOOL_I_I:%.*]] = icmp eq i32 [[AND_I_I]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_I_I]], label %[[WHILE_BODY_I_I]], label %[[FN1_EXIT_I:.*]]
; CHECK:       [[FN1_EXIT_I]]:
; CHECK-NEXT:    [[CONV_I:%.*]] = zext i16 [[INC_I_I]] to i32
; CHECK-NEXT:    [[PROMOTED4:%.*]] = zext i16 [[INC_I_I]] to i64
; CHECK-NEXT:    [[SUNKADDR5:%.*]] = getelementptr i8, ptr [[P]], i64 [[PROMOTED4]]
; CHECK-NEXT:    [[SUNKADDR6:%.*]] = getelementptr i8, ptr [[SUNKADDR5]], i64 7
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr [[SUNKADDR6]], align 1
; CHECK-NEXT:    [[CONV2_I:%.*]] = sext i8 [[TMP2]] to i16
; CHECK-NEXT:    store i16 [[CONV2_I]], ptr @b, align 2
; CHECK-NEXT:    [[SUB4_I:%.*]] = sub nsw i32 0, [[CONV_I]]
; CHECK-NEXT:    [[CONV5_I:%.*]] = zext i16 [[CONV2_I]] to i32
; CHECK-NEXT:    [[CMP_I:%.*]] = icmp sgt i32 [[CONV5_I]], [[SUB4_I]]
; CHECK-NEXT:    br i1 [[CMP_I]], label %[[IF_THEN_I:.*]], label %[[FN2_EXIT:.*]]
; CHECK:       [[IF_THEN_I]]:
; CHECK-NEXT:    [[END_I:%.*]] = getelementptr inbounds [[STRUCT_DNS_PACKET:%.*]], ptr [[P]], i64 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[END_I]], align 4
; CHECK-NEXT:    [[SUB7_I:%.*]] = add i32 [[TMP3]], 65535
; CHECK-NEXT:    [[CONV8_I:%.*]] = trunc i32 [[SUB7_I]] to i16
; CHECK-NEXT:    br label %[[FN2_EXIT]]
; CHECK:       [[FN2_EXIT]]:
; CHECK-NEXT:    [[RETVAL_0_I:%.*]] = phi i16 [ [[CONV8_I]], %[[IF_THEN_I]] ], [ undef, %[[FN1_EXIT_I]] ]
; CHECK-NEXT:    ret i16 [[RETVAL_0_I]]
;
entry:
  %tmp = getelementptr inbounds %struct.dns_packet, ptr %P, i64 0, i32 2
  br label %while.body.i.i

while.body.i.i:                                   ; preds = %while.body.i.i, %entry
  %src.addr.0.i.i = phi i16 [ 0, %entry ], [ %inc.i.i, %while.body.i.i ]
  %inc.i.i = add i16 %src.addr.0.i.i, 1
  %idxprom.i.i = sext i16 %src.addr.0.i.i to i64
  %arrayidx.i.i = getelementptr inbounds [0 x i8], ptr %tmp, i64 0, i64 %idxprom.i.i
  %tmp1 = load i8, ptr %arrayidx.i.i, align 1
  %conv2.i.i = zext i8 %tmp1 to i32
  %and.i.i = and i32 %conv2.i.i, 15
  store i32 %and.i.i, ptr @a, align 4
  %tobool.i.i = icmp eq i32 %and.i.i, 0
  br i1 %tobool.i.i, label %while.body.i.i, label %fn1.exit.i

fn1.exit.i:                                       ; preds = %while.body.i.i
  %inc.i.i.lcssa = phi i16 [ %inc.i.i, %while.body.i.i ]
  %conv.i = zext i16 %inc.i.i.lcssa to i32
  %sub.i = add nsw i32 %conv.i, -1
  %idxprom.i = sext i32 %sub.i to i64
  %arrayidx.i = getelementptr inbounds [0 x i8], ptr %tmp, i64 0, i64 %idxprom.i
  %tmp2 = load i8, ptr %arrayidx.i, align 1
  %conv2.i = sext i8 %tmp2 to i16
  store i16 %conv2.i, ptr @b, align 2
  %sub4.i = sub nsw i32 0, %conv.i
  %conv5.i = zext i16 %conv2.i to i32
  %cmp.i = icmp sgt i32 %conv5.i, %sub4.i
  br i1 %cmp.i, label %if.then.i, label %fn2.exit

if.then.i:                                        ; preds = %fn1.exit.i
  %end.i = getelementptr inbounds %struct.dns_packet, ptr %P, i64 0, i32 1
  %tmp3 = load i32, ptr %end.i, align 4
  %sub7.i = add i32 %tmp3, 65535
  %conv8.i = trunc i32 %sub7.i to i16
  br label %fn2.exit

fn2.exit:                                         ; preds = %if.then.i, %fn1.exit.i
  %retval.0.i = phi i16 [ %conv8.i, %if.then.i ], [ undef, %fn1.exit.i ]
  ret i16 %retval.0.i
}

; Check that we do not promote an extension if the non-wrapping flag does not
; match the kind of the extension.
define i8 @noPromotionFlag(i32 %arg1, i32 %arg2) {
; CHECK-LABEL: define i8 @noPromotionFlag(
; CHECK-SAME: i32 [[ARG1:%.*]], i32 [[ARG2:%.*]]) {
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[ARG1]], [[ARG2]]
; CHECK-NEXT:    [[ZEXTADD:%.*]] = zext i32 [[ADD]] to i64
; CHECK-NEXT:    [[BASE:%.*]] = inttoptr i64 [[ZEXTADD]] to ptr
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[BASE]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %add = add nsw i32 %arg1, %arg2
  %zextadd = zext i32 %add to i64
  %base = inttoptr i64 %zextadd to ptr
  %res = load i8, ptr %base
  ret i8 %res
}

; Check that we correctly promote both operands of the promotable add with zext.
define i8 @twoArgsPromotionZExt(i32 %arg1, i32 %arg2) {
; CHECK-LABEL: define i8 @twoArgsPromotionZExt(
; CHECK-SAME: i32 [[ARG1:%.*]], i32 [[ARG2:%.*]]) {
; CHECK-NEXT:    [[PROMOTED:%.*]] = zext i32 [[ARG1]] to i64
; CHECK-NEXT:    [[PROMOTED2:%.*]] = zext i32 [[ARG2]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i64 [[PROMOTED]], [[PROMOTED2]]
; CHECK-NEXT:    [[BASE:%.*]] = inttoptr i64 [[ADD]] to ptr
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[BASE]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %add = add nuw i32 %arg1, %arg2
  %zextadd = zext i32 %add to i64
  %base = inttoptr i64 %zextadd to ptr
  %res = load i8, ptr %base
  ret i8 %res
}

; Check that we correctly promote constant arguments.
define i8 @oneArgPromotionNegativeCstZExt(i8 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionNegativeCstZExt(
; CHECK-SAME: i8 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED:%.*]] = zext i8 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i64 [[PROMOTED]], 255
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %add = add nuw i8 %arg1, -1
  %zextadd = zext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %zextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we are able to merge two zero extensions.
define i8 @oneArgPromotionZExtZExt(i8 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionZExtZExt(
; CHECK-SAME: i8 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED2:%.*]] = zext i8 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i64 [[PROMOTED2]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %zext = zext i8 %arg1 to i32
  %add = add nuw i32 %zext, 1
  %zextadd = zext i32 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %zextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we do not promote truncate when the dropped bits
; are of a different kind.
define i8 @oneArgPromotionBlockTruncZExt(i1 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionBlockTruncZExt(
; CHECK-SAME: i1 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[SEXTARG1:%.*]] = sext i1 [[ARG1]] to i32
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[SEXTARG1]] to i8
; CHECK-NEXT:    [[PROMOTED:%.*]] = zext i8 [[TRUNC]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i64 [[PROMOTED]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sextarg1 = sext i1 %arg1 to i32
  %trunc = trunc i32 %sextarg1 to i8
  %add = add nuw i8 %trunc, 1
  %zextadd = zext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %zextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we are able to promote truncate when we know all the bits
; that are dropped.
define i8 @oneArgPromotionPassTruncZExt(i1 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionPassTruncZExt(
; CHECK-SAME: i1 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[PROMOTED2:%.*]] = zext i1 [[ARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i64 [[PROMOTED2]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sextarg1 = zext i1 %arg1 to i32
  %trunc = trunc i32 %sextarg1 to i8
  %add = add nuw i8 %trunc, 1
  %zextadd = zext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %zextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we do not promote sext with zext.
define i8 @oneArgPromotionBlockSExtZExt(i1 %arg1, ptr %base) {
; CHECK-LABEL: define i8 @oneArgPromotionBlockSExtZExt(
; CHECK-SAME: i1 [[ARG1:%.*]], ptr [[BASE:%.*]]) {
; CHECK-NEXT:    [[SEXTARG1:%.*]] = sext i1 [[ARG1]] to i8
; CHECK-NEXT:    [[PROMOTED:%.*]] = zext i8 [[SEXTARG1]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i64 [[PROMOTED]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = load i8, ptr [[ARRAYIDX]], align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sextarg1 = sext i1 %arg1 to i8
  %add = add nuw i8 %sextarg1, 1
  %zextadd = zext i8 %add to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %zextadd
  %res = load i8, ptr %arrayidx
  ret i8 %res
}

; Check that we replace the deleted sext with the promoted value.
define void @pr70938(ptr %f) {
; CHECK-LABEL: define void @pr70938(
; CHECK-SAME: ptr [[F:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 0, 1
; CHECK-NEXT:    [[SUNKADDR:%.*]] = mul i64 [[ADD]], 2
; CHECK-NEXT:    [[SUNKADDR1:%.*]] = getelementptr i8, ptr [[F]], i64 [[SUNKADDR]]
; CHECK-NEXT:    [[SUNKADDR2:%.*]] = getelementptr i8, ptr [[SUNKADDR1]], i64 1
; CHECK-NEXT:    store i8 0, ptr [[SUNKADDR2]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %add = add nsw i32 0, 1
  %idxprom3 = sext i32 %add to i64
  %arrayidx4 = getelementptr [2 x [1 x [2 x i8]]], ptr %f, i64 0, i64 %idxprom3
  %arrayidx8 = getelementptr [2 x i8], ptr %arrayidx4, i64 0, i64 %idxprom3
  br label %if.end

if.end:                                           ; preds = %entry
  store i8 0, ptr %arrayidx8, align 1
  ret void
}

define void @pr119429() {
; CHECK-LABEL: define void @pr119429() {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[AND:%.*]] = and i64 0, 0
; CHECK-NEXT:    [[SUNKADDR:%.*]] = inttoptr i64 [[AND]] to ptr
; CHECK-NEXT:    [[SUNKADDR1:%.*]] = mul i64 [[AND]], 2
; CHECK-NEXT:    [[SUNKADDR2:%.*]] = getelementptr i8, ptr [[SUNKADDR]], i64 [[SUNKADDR1]]
; CHECK-NEXT:    store i64 0, ptr [[SUNKADDR2]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %and = and i32 0, 0
  %conv1 = zext i32 %and to i64
  %sub = add i64 %conv1, 0
  br label %if.end

if.end:
  %mul = shl i64 %sub, 1
  %add = add i64 %mul, %conv1
  %ptr = inttoptr i64 %add to ptr
  store i64 0, ptr %ptr, align 8
  ret void
}
