; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple aarch64 -aarch64-enable-atomic-cfg-tidy=0 -stop-after=irtranslator -global-isel -verify-machineinstrs -disable-cgp-delete-phis %s -o - 2>&1 | FileCheck %s

define i32 @test_bittest(i16 %p) {
  ; CHECK-LABEL: name: test_bittest
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.4(0x1b6db6db), %bb.5(0x64924925)
  ; CHECK-NEXT:   liveins: $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 114
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 42
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s16)
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[SUB:%[0-9]+]]:_(s32) = G_SUB [[ZEXT]], [[C3]]
  ; CHECK-NEXT:   [[ZEXT1:%[0-9]+]]:_(s64) = G_ZEXT [[SUB]](s32)
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 59
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ugt), [[SUB]](s32), [[C4]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP]](s1), %bb.4
  ; CHECK-NEXT:   G_BR %bb.5
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.3(0x40000000), %bb.2(0x40000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[ICMP1:%[0-9]+]]:_(s1) = G_ICMP intpred(eq), [[ZEXT]](s32), [[C]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP1]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.2
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.5 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.3(0x745d1746), %bb.4(0x0ba2e8ba)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[SHL:%[0-9]+]]:_(s64) = G_SHL [[C5]], [[ZEXT1]](s64)
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 866239240827043840
  ; CHECK-NEXT:   [[AND:%[0-9]+]]:_(s64) = G_AND [[SHL]], [[C6]]
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[ICMP2:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[AND]](s64), [[C7]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP2]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.sw.epilog:
  ; CHECK-NEXT:   $w0 = COPY [[C2]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.cb1:
  ; CHECK-NEXT:   $w0 = COPY [[C1]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  switch i16 %p, label %sw.epilog [
    i16 58, label %cb1
    i16 59, label %cb1
    i16 47, label %cb1
    i16 48, label %cb1
    i16 50, label %cb1
    i16 114, label %cb1
  ]
sw.epilog:
  ret i32 0

cb1:
  ret i32 42
}


declare void @callee()

define void @test_bittest_2_bt(i32 %p) {
  ; CHECK-LABEL: name: test_bittest_2_bt
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   successors: %bb.5(0x345d1746), %bb.6(0x4ba2e8ba)
  ; CHECK-NEXT:   liveins: $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 176
  ; CHECK-NEXT:   [[SUB:%[0-9]+]]:_(s32) = G_SUB [[COPY]], [[C]]
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 15
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ugt), [[SUB]](s32), [[C1]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP]](s1), %bb.5
  ; CHECK-NEXT:   G_BR %bb.6
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.5.entry:
  ; CHECK-NEXT:   successors: %bb.4(0x0ccccccd), %bb.7(0x73333333)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[SUB1:%[0-9]+]]:_(s32) = G_SUB [[COPY]], [[C2]]
  ; CHECK-NEXT:   [[ZEXT:%[0-9]+]]:_(s64) = G_ZEXT [[SUB1]](s32)
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 38
  ; CHECK-NEXT:   [[ICMP1:%[0-9]+]]:_(s1) = G_ICMP intpred(ugt), [[SUB1]](s32), [[C3]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP1]](s1), %bb.4
  ; CHECK-NEXT:   G_BR %bb.7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.6.entry:
  ; CHECK-NEXT:   successors: %bb.2(0x76276276), %bb.5(0x09d89d8a)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; CHECK-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C4]], [[SUB]](s32)
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_CONSTANT i32 57351
  ; CHECK-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[SHL]], [[C5]]
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[ICMP2:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[AND]](s32), [[C6]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP2]](s1), %bb.2
  ; CHECK-NEXT:   G_BR %bb.5
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.7.entry:
  ; CHECK-NEXT:   successors: %bb.3(0x71c71c72), %bb.4(0x0e38e38e)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[SHL1:%[0-9]+]]:_(s64) = G_SHL [[C7]], [[ZEXT]](s64)
  ; CHECK-NEXT:   [[C8:%[0-9]+]]:_(s64) = G_CONSTANT i64 365072220160
  ; CHECK-NEXT:   [[AND1:%[0-9]+]]:_(s64) = G_AND [[SHL1]], [[C8]]
  ; CHECK-NEXT:   [[C9:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[ICMP3:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[AND1]](s64), [[C9]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP3]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.sw.bb37:
  ; CHECK-NEXT:   TCRETURNdi @callee, 0, csr_aarch64_aapcs, implicit $sp
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.sw.bb55:
  ; CHECK-NEXT:   TCRETURNdi @callee, 0, csr_aarch64_aapcs, implicit $sp
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4.sw.default:
  ; CHECK-NEXT:   RET_ReallyLR
entry:
  switch i32 %p, label %sw.default [
    i32 32, label %sw.bb55
    i32 34, label %sw.bb55
    i32 36, label %sw.bb55
    i32 191, label %sw.bb37
    i32 190, label %sw.bb37
    i32 189, label %sw.bb37
    i32 178, label %sw.bb37
    i32 177, label %sw.bb37
    i32 176, label %sw.bb37
    i32 38, label %sw.bb55
  ]

sw.bb37:                                          ; preds = %entry, %entry, %entry, %entry, %entry, %entry
  tail call void @callee()
  ret void

sw.bb55:                                          ; preds = %entry, %entry, %entry, %entry
  tail call void @callee()
  ret void

sw.default:                                       ; preds = %entry
  ret void
}

define i32 @test_bittest_single_bt_only_with_fallthrough(i16 %p) {
  ; CHECK-LABEL: name: test_bittest_single_bt_only_with_fallthrough
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.2(0x0aaaaaab), %bb.4(0x75555555)
  ; CHECK-NEXT:   liveins: $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 42
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s16)
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[SUB:%[0-9]+]]:_(s32) = G_SUB [[ZEXT]], [[C2]]
  ; CHECK-NEXT:   [[ZEXT1:%[0-9]+]]:_(s64) = G_ZEXT [[SUB]](s32)
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 59
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ugt), [[SUB]](s32), [[C3]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP]](s1), %bb.2
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.3(0x745d1746), %bb.2(0x0ba2e8ba)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[SHL:%[0-9]+]]:_(s64) = G_SHL [[C4]], [[ZEXT1]](s64)
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 866239240827043840
  ; CHECK-NEXT:   [[AND:%[0-9]+]]:_(s64) = G_AND [[SHL]], [[C5]]
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[ICMP1:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[AND]](s64), [[C6]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP1]](s1), %bb.3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.sw.epilog:
  ; CHECK-NEXT:   $w0 = COPY [[C1]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.cb1:
  ; CHECK-NEXT:   $w0 = COPY [[C]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  switch i16 %p, label %sw.epilog [
    i16 58, label %cb1
    i16 59, label %cb1
    i16 47, label %cb1
    i16 48, label %cb1
    i16 50, label %cb1
  ]
sw.epilog:
  ret i32 0

cb1:
  ret i32 42
}

define void @bit_test_block_incomplete_phi() {
  ; CHECK-LABEL: name: bit_test_block_incomplete_phi
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   successors: %bb.5(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[DEF1:%[0-9]+]]:_(p0) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s1) = G_CONSTANT i1 false
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s1) = G_CONSTANT i1 true
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[SUB:%[0-9]+]]:_(s32) = G_SUB [[DEF]], [[C2]]
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.5.entry:
  ; CHECK-NEXT:   successors: %bb.3(0x51745d17), %bb.4(0x2e8ba2e9)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; CHECK-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C3]], [[SUB]](s32)
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 491
  ; CHECK-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[SHL]], [[C4]]
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[AND]](s32), [[C5]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.6.entry:
  ; CHECK-NEXT:   successors:
  ; CHECK: bb.2.sw.epilog.i:
  ; CHECK-NEXT:   successors:
  ; CHECK: bb.3.if.end:
  ; CHECK-NEXT:   successors: %bb.4(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[LOAD:%[0-9]+]]:_(p0) = G_LOAD [[DEF1]](p0) :: (load (p0) from `ptr undef`)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4.return:
  ; CHECK-NEXT:   [[PHI:%[0-9]+]]:_(s1) = G_PHI [[C]](s1), %bb.3, [[C1]](s1), %bb.5
  ; CHECK-NEXT:   RET_ReallyLR
entry:
  switch i32 undef, label %sw.epilog.i [
    i32 4, label %return
    i32 2, label %return
    i32 10, label %return
    i32 9, label %return
    i32 1, label %if.end
    i32 3, label %if.end
    i32 5, label %if.end
    i32 0, label %if.end
    i32 6, label %if.end
    i32 7, label %if.end
    i32 8, label %if.end
  ]

sw.epilog.i:                                      ; preds = %entry
  unreachable

if.end:                                           ; preds = %entry, %entry, %entry, %entry, %entry, %entry, %entry
  %0 = load ptr, ptr undef, align 8
  br label %return

return:                                           ; preds = %if.end, %entry, %entry, %entry, %entry
  %retval.0 = phi i1 [ false, %if.end ], [ true, %entry ], [ true, %entry ], [ true, %entry ], [ true, %entry ]
  ret void
}

define i32 @test_odd_type(i328 %p) {
  ; CHECK-LABEL: name: test_odd_type
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.4(0x1b6db6db), %bb.5(0x64924925)
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3, $x4, $x5
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s384) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64), [[COPY2]](s64), [[COPY3]](s64), [[COPY4]](s64), [[COPY5]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s328) = G_TRUNC [[MV]](s384)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s328) = G_CONSTANT i328 114
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 42
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s328) = G_CONSTANT i328 0
  ; CHECK-NEXT:   [[SUB:%[0-9]+]]:_(s328) = G_SUB [[TRUNC]], [[C3]]
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s64) = G_TRUNC [[SUB]](s328)
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s328) = G_CONSTANT i328 59
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ugt), [[SUB]](s328), [[C4]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP]](s1), %bb.4
  ; CHECK-NEXT:   G_BR %bb.5
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.3(0x40000000), %bb.2(0x40000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[ICMP1:%[0-9]+]]:_(s1) = G_ICMP intpred(eq), [[TRUNC]](s328), [[C]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP1]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.2
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.5 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.3(0x745d1746), %bb.4(0x0ba2e8ba)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[SHL:%[0-9]+]]:_(s64) = G_SHL [[C5]], [[TRUNC1]](s64)
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 866239240827043840
  ; CHECK-NEXT:   [[AND:%[0-9]+]]:_(s64) = G_AND [[SHL]], [[C6]]
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[ICMP2:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[AND]](s64), [[C7]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP2]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.sw.epilog:
  ; CHECK-NEXT:   $w0 = COPY [[C2]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.cb1:
  ; CHECK-NEXT:   $w0 = COPY [[C1]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  switch i328 %p, label %sw.epilog [
    i328 58, label %cb1
    i328 59, label %cb1
    i328 47, label %cb1
    i328 48, label %cb1
    i328 50, label %cb1
    i328 114, label %cb1
  ]
sw.epilog:
  ret i32 0
cb1:
  ret i32 42
}

define i32 @test_large_pow2_type(i256 %p) {
  ; CHECK-LABEL: name: test_large_pow2_type
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.4(0x1b6db6db), %bb.5(0x64924925)
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s256) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64), [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s256) = G_CONSTANT i256 114
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 42
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s256) = G_CONSTANT i256 0
  ; CHECK-NEXT:   [[SUB:%[0-9]+]]:_(s256) = G_SUB [[MV]], [[C3]]
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s64) = G_TRUNC [[SUB]](s256)
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s256) = G_CONSTANT i256 59
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ugt), [[SUB]](s256), [[C4]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP]](s1), %bb.4
  ; CHECK-NEXT:   G_BR %bb.5
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.3(0x40000000), %bb.2(0x40000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[ICMP1:%[0-9]+]]:_(s1) = G_ICMP intpred(eq), [[MV]](s256), [[C]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP1]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.2
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.5 (%ir-block.0):
  ; CHECK-NEXT:   successors: %bb.3(0x745d1746), %bb.4(0x0ba2e8ba)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[SHL:%[0-9]+]]:_(s64) = G_SHL [[C5]], [[TRUNC]](s64)
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 866239240827043840
  ; CHECK-NEXT:   [[AND:%[0-9]+]]:_(s64) = G_AND [[SHL]], [[C6]]
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[ICMP2:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[AND]](s64), [[C7]]
  ; CHECK-NEXT:   G_BRCOND [[ICMP2]](s1), %bb.3
  ; CHECK-NEXT:   G_BR %bb.4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.sw.epilog:
  ; CHECK-NEXT:   $w0 = COPY [[C2]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.cb1:
  ; CHECK-NEXT:   $w0 = COPY [[C1]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  switch i256 %p, label %sw.epilog [
    i256 58, label %cb1
    i256 59, label %cb1
    i256 47, label %cb1
    i256 48, label %cb1
    i256 50, label %cb1
    i256 114, label %cb1
  ]
sw.epilog:
  ret i32 0
cb1:
  ret i32 42
}

