package HTTP::Webdav::Constants ;

use Exporter ;

@ISA = qw(Exporter) ;
@EXPORT = qw{HTTP_QUOTES HTTP_WHITESPACE NE_ACL_H NE_ALLOC_H NE_AUTH NE_AUTHPROXY NE_AUTH_H NE_BASIC_H NE_COMPRESS_H NE_CONNECT NE_COOKIES_H NE_DBG_FLUSH NE_DBG_HTTP NE_DBG_HTTPAUTH NE_DBG_HTTPBASIC NE_DBG_HTTPBODY NE_DBG_HTTPPLAIN NE_DBG_LOCKS NE_DBG_SOCKET NE_DBG_XML NE_DBG_XMLPARSE NE_DEPTH_INFINITE NE_DEPTH_ONE NE_DEPTH_ZERO NE_ELM_207_UNUSED NE_ELM_207_first NE_ELM_UNUSED NE_ELM_href NE_ELM_multistatus NE_ELM_prop NE_ELM_propstat NE_ELM_response NE_ELM_responsedescription NE_ELM_root NE_ELM_status NE_ELM_unknown NE_ERROR NE_FAILED NE_LOCKS_H NE_LOOKUP NE_OK NE_PROPS_H NE_PROXYAUTH NE_REDIRECT NE_REDIRECT_H NE_REQUEST_H NE_RETRY NE_SERVERAUTH NE_SESSION_H NE_SOCKET_H NE_STRING_H NE_TIMEOUT NE_TIMEOUT_INFINITE NE_TIMEOUT_INVALID NE_URI_H NE_UTILS_H NE_XML_CDATA NE_XML_COLLECT NE_XML_DECLINE NE_XML_H NE_XML_INVALID NE_XML_MIXED NE_XML_UTF8DECODE NE_XML_VALID} ;

use constant HTTP_QUOTES => "\"'"  ;
use constant HTTP_WHITESPACE => " \r\n\t"  ;
use constant NE_AUTH => (4)  ;
use constant NE_AUTHPROXY => (5)  ;
use constant NE_CONNECT => (8)  ;
use constant NE_DBG_FLUSH => (1<<30)  ;
use constant NE_DBG_HTTP => (1<<1)  ;
use constant NE_DBG_HTTPAUTH => (1<<3)  ;
use constant NE_DBG_HTTPBASIC => (1<<8)  ;
use constant NE_DBG_HTTPBODY => (1<<7)  ;
use constant NE_DBG_HTTPPLAIN => (1<<4)  ;
use constant NE_DBG_LOCKS => (1<<5)  ;
use constant NE_DBG_SOCKET => (1<<0)  ;
use constant NE_DBG_XML => (1<<2)  ;
use constant NE_DBG_XMLPARSE => (1<<6)  ;
use constant NE_DEPTH_INFINITE => (2)  ;
use constant NE_DEPTH_ONE => (1)  ;
use constant NE_DEPTH_ZERO => (0)  ;
use constant NE_ELM_UNUSED => (100)  ;
use constant NE_ELM_207_UNUSED => (NE_ELM_UNUSED + 100)  ;
use constant NE_ELM_207_first => (NE_ELM_UNUSED)  ;
use constant NE_ELM_href => (NE_ELM_207_first + 3)  ;
use constant NE_ELM_multistatus => (NE_ELM_207_first)  ;
use constant NE_ELM_prop => (NE_ELM_207_first + 5)  ;
use constant NE_ELM_propstat => (NE_ELM_207_first + 4)  ;
use constant NE_ELM_response => (NE_ELM_207_first + 1)  ;
use constant NE_ELM_responsedescription => (NE_ELM_207_first + 2)  ;
use constant NE_ELM_root => 0  ;
use constant NE_ELM_status => (NE_ELM_207_first + 6)  ;
use constant NE_ELM_unknown => -1  ;
use constant NE_ERROR => (1)  ;
use constant NE_FAILED => (10)  ;
use constant NE_LOOKUP => (3)  ;
use constant NE_OK => (0)  ;
use constant NE_PROXYAUTH => (7)  ;
use constant NE_REDIRECT => (12)  ;
use constant NE_RETRY => (11)  ;
use constant NE_SERVERAUTH => (6)  ;
use constant NE_SESSION_H => 1  ;
use constant NE_TIMEOUT => (9)  ;
use constant NE_TIMEOUT_INFINITE => -1  ;
use constant NE_TIMEOUT_INVALID => -2  ;
use constant NE_XML_CDATA => (1<<1)  ;
use constant NE_XML_COLLECT => ((1<<2) | NE_XML_CDATA)  ;
use constant NE_XML_DECLINE => (-2)  ;
use constant NE_XML_INVALID => (-1)  ;
use constant NE_XML_MIXED => (1<<4)  ;
use constant NE_XML_UTF8DECODE => (1<<3)  ;
use constant NE_XML_VALID => (0)  ;
