#!perl
use strict;
use warnings;

my $uri_unsafe = qr/[^A-Za-z0-9\-\._~]/; # defined by RFC 3986

print "/* Check whether a character is unsafe by the definition of RFC 3986 */\n";
print "/* This file is automatically generated by $0 */\n";

print <<'C';
static int
is_uri_unsafe(char const c) {
    switch((unsigned char)c) {
C

for(my $i = 0; $i < 256; $i++) {
    my $c = chr $i;

    if($c !~ $uri_unsafe) {
        printf "    case 0x%02X: return 0;%s\n",
            $i,
            ($c =~ /[[:print:]]/ ? " /* $c */" : '');
    }
}

print <<'C';
    default: return 1;
    }
} /* is_uri_unsafe */
C
